# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc/applications/fee/v1/ack.proto, ibc/applications/fee/v1/fee.proto, ibc/applications/fee/v1/genesis.proto, ibc/applications/fee/v1/metadata.proto, ibc/applications/fee/v1/query.proto, ibc/applications/fee/v1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class Fee(betterproto.Message):
    """Fee defines the ICS29 receive, acknowledgement and timeout fees"""

    # the packet receive fee
    recv_fee: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)
    # the packet acknowledgement fee
    ack_fee: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(2)
    # the packet timeout fee
    timeout_fee: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class PacketFee(betterproto.Message):
    """
    PacketFee contains ICS29 relayer fees, refund address and optional list of
    permitted relayers
    """

    # fee encapsulates the recv, ack and timeout fees associated with an IBC
    # packet
    fee: "Fee" = betterproto.message_field(1)
    # the refund address for unspent fees
    refund_address: str = betterproto.string_field(2)
    # optional list of relayers permitted to receive fees
    relayers: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class PacketFees(betterproto.Message):
    """PacketFees contains a list of type PacketFee"""

    # list of packet fees
    packet_fees: List["PacketFee"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class IdentifiedPacketFees(betterproto.Message):
    """
    IdentifiedPacketFees contains a list of type PacketFee and associated
    PacketId
    """

    # unique packet identifier comprised of the channel ID, port ID and sequence
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)
    # list of packet fees
    packet_fees: List["PacketFee"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgRegisterCounterpartyAddress(betterproto.Message):
    """
    MsgRegisterCounterpartyAddress defines the request type for the
    RegisterCounterpartyAddress rpc
    """

    # the relayer address
    address: str = betterproto.string_field(1)
    # the counterparty relayer address
    counterparty_address: str = betterproto.string_field(2)
    # unique channel identifier
    channel_id: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgRegisterCounterpartyAddressResponse(betterproto.Message):
    """
    MsgRegisterCounterpartyAddressResponse defines the response type for the
    RegisterCounterpartyAddress rpc
    """

    pass


@dataclass(eq=False, repr=False)
class MsgPayPacketFee(betterproto.Message):
    """
    MsgPayPacketFee defines the request type for the PayPacketFee rpc This Msg
    can be used to pay for a packet at the next sequence send & should be
    combined with the Msg that will be paid for
    """

    # fee encapsulates the recv, ack and timeout fees associated with an IBC
    # packet
    fee: "Fee" = betterproto.message_field(1)
    # the source port unique identifier
    source_port_id: str = betterproto.string_field(2)
    # the source channel unique identifer
    source_channel_id: str = betterproto.string_field(3)
    # account address to refund fee if necessary
    signer: str = betterproto.string_field(4)
    # optional list of relayers permitted to the receive packet fees
    relayers: List[str] = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgPayPacketFeeResponse(betterproto.Message):
    """
    MsgPayPacketFeeResponse defines the response type for the PayPacketFee rpc
    """

    pass


@dataclass(eq=False, repr=False)
class MsgPayPacketFeeAsync(betterproto.Message):
    """
    MsgPayPacketFeeAsync defines the request type for the PayPacketFeeAsync rpc
    This Msg can be used to pay for a packet at a specified sequence (instead
    of the next sequence send)
    """

    # unique packet identifier comprised of the channel ID, port ID and sequence
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)
    # the packet fee associated with a particular IBC packet
    packet_fee: "PacketFee" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgPayPacketFeeAsyncResponse(betterproto.Message):
    """
    MsgPayPacketFeeAsyncResponse defines the response type for the
    PayPacketFeeAsync rpc
    """

    pass


@dataclass(eq=False, repr=False)
class IncentivizedAcknowledgement(betterproto.Message):
    """
    IncentivizedAcknowledgement is the acknowledgement format to be used by
    applications wrapped in the fee middleware
    """

    # the underlying app acknowledgement result bytes
    result: bytes = betterproto.bytes_field(1)
    # the relayer address which submits the recv packet message
    forward_relayer_address: str = betterproto.string_field(2)
    # success flag of the base application callback
    underlying_app_success: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the ICS29 fee middleware genesis state"""

    # list of identified packet fees
    identified_fees: List["IdentifiedPacketFees"] = betterproto.message_field(1)
    # list of fee enabled channels
    fee_enabled_channels: List["FeeEnabledChannel"] = betterproto.message_field(2)
    # list of registered relayer addresses
    registered_relayers: List["RegisteredRelayerAddress"] = betterproto.message_field(3)
    # list of forward relayer addresses
    forward_relayers: List["ForwardRelayerAddress"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class FeeEnabledChannel(betterproto.Message):
    """
    FeeEnabledChannel contains the PortID & ChannelID for a fee enabled channel
    """

    # unique port identifier
    port_id: str = betterproto.string_field(1)
    # unique channel identifier
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RegisteredRelayerAddress(betterproto.Message):
    """
    RegisteredRelayerAddress contains the address and counterparty address for
    a specific relayer (for distributing fees)
    """

    # the relayer address
    address: str = betterproto.string_field(1)
    # the counterparty relayer address
    counterparty_address: str = betterproto.string_field(2)
    # unique channel identifier
    channel_id: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ForwardRelayerAddress(betterproto.Message):
    """
    ForwardRelayerAddress contains the forward relayer address and PacketId
    used for async acknowledgements
    """

    # the forward relayer address
    address: str = betterproto.string_field(1)
    # unique packet identifer comprised of the channel ID, port ID and sequence
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketsRequest(betterproto.Message):
    """
    QueryIncentivizedPacketsRequest defines the request type for the
    IncentivizedPackets rpc
    """

    # pagination defines an optional pagination for the request.
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    # block height at which to query
    query_height: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketsResponse(betterproto.Message):
    """
    QueryIncentivizedPacketsResponse defines the response type for the
    IncentivizedPackets rpc
    """

    # list of identified fees for incentivized packets
    incentivized_packets: List["IdentifiedPacketFees"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketRequest(betterproto.Message):
    """
    QueryIncentivizedPacketRequest defines the request type for the
    IncentivizedPacket rpc
    """

    # unique packet identifier comprised of channel ID, port ID and sequence
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)
    # block height at which to query
    query_height: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketResponse(betterproto.Message):
    """
    QueryIncentivizedPacketsResponse defines the response type for the
    IncentivizedPacket rpc
    """

    # the identified fees for the incentivized packet
    incentivized_packet: "IdentifiedPacketFees" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketsForChannelRequest(betterproto.Message):
    """
    QueryIncentivizedPacketsForChannelRequest defines the request type for
    querying for all incentivized packets for a specific channel
    """

    # pagination defines an optional pagination for the request.
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    port_id: str = betterproto.string_field(2)
    channel_id: str = betterproto.string_field(3)
    # Height to query at
    query_height: int = betterproto.uint64_field(4)


@dataclass(eq=False, repr=False)
class QueryIncentivizedPacketsForChannelResponse(betterproto.Message):
    """
    QueryIncentivizedPacketsResponse defines the response type for the
    incentivized packets RPC
    """

    # Map of all incentivized_packets
    incentivized_packets: List["IdentifiedPacketFees"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalRecvFeesRequest(betterproto.Message):
    """
    QueryTotalRecvFeesRequest defines the request type for the TotalRecvFees
    rpc
    """

    # the packet identifier for the associated fees
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalRecvFeesResponse(betterproto.Message):
    """
    QueryTotalRecvFeesResponse defines the response type for the TotalRecvFees
    rpc
    """

    # the total packet receive fees
    recv_fees: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalAckFeesRequest(betterproto.Message):
    """
    QueryTotalAckFeesRequest defines the request type for the TotalAckFees rpc
    """

    # the packet identifier for the associated fees
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalAckFeesResponse(betterproto.Message):
    """
    QueryTotalAckFeesResponse defines the response type for the TotalAckFees
    rpc
    """

    # the total packet acknowledgement fees
    ack_fees: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalTimeoutFeesRequest(betterproto.Message):
    """
    QueryTotalTimeoutFeesRequest defines the request type for the
    TotalTimeoutFees rpc
    """

    # the packet identifier for the associated fees
    packet_id: "___core_channel_v1__.PacketId" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalTimeoutFeesResponse(betterproto.Message):
    """
    QueryTotalTimeoutFeesResponse defines the response type for the
    TotalTimeoutFees rpc
    """

    # the total packet timeout fees
    timeout_fees: List["____cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryCounterpartyAddressRequest(betterproto.Message):
    """
    QueryCounterpartyAddressRequest defines the request type for the
    CounterpartyAddress rpc
    """

    # unique channel identifier
    channel_id: str = betterproto.string_field(1)
    # the relayer address to which the counterparty is registered
    relayer_address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryCounterpartyAddressResponse(betterproto.Message):
    """
    QueryCounterpartyAddressResponse defines the response type for the
    CounterpartyAddress rpc
    """

    # the counterparty address used to compensate forward relaying
    counterparty_address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryFeeEnabledChannelsRequest(betterproto.Message):
    """
    QueryFeeEnabledChannelsRequest defines the request type for the
    FeeEnabledChannels rpc
    """

    # pagination defines an optional pagination for the request.
    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    # block height at which to query
    query_height: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class QueryFeeEnabledChannelsResponse(betterproto.Message):
    """
    QueryFeeEnabledChannelsResponse defines the response type for the
    FeeEnabledChannels rpc
    """

    # list of fee enabled channels
    fee_enabled_channels: List["FeeEnabledChannel"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryFeeEnabledChannelRequest(betterproto.Message):
    """
    QueryFeeEnabledChannelRequest defines the request type for the
    FeeEnabledChannel rpc
    """

    # unique port identifier
    port_id: str = betterproto.string_field(1)
    # unique channel identifier
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryFeeEnabledChannelResponse(betterproto.Message):
    """
    QueryFeeEnabledChannelResponse defines the response type for the
    FeeEnabledChannel rpc
    """

    # boolean flag representing the fee enabled channel status
    fee_enabled: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class Metadata(betterproto.Message):
    """
    Metadata defines the ICS29 channel specific metadata encoded into the
    channel version bytestring See ICS004:
    https://github.com/cosmos/ibc/tree/master/spec/core/ics-004-channel-and-
    packet-semantics#Versioning
    """

    # fee_version defines the ICS29 fee version
    fee_version: str = betterproto.string_field(1)
    # app_version defines the underlying application version, which may or may
    # not be a JSON encoded bytestring
    app_version: str = betterproto.string_field(2)


class MsgStub(betterproto.ServiceStub):
    async def register_counterparty_address(
        self, *, address: str = "", counterparty_address: str = "", channel_id: str = ""
    ) -> "MsgRegisterCounterpartyAddressResponse":

        request = MsgRegisterCounterpartyAddress()
        request.address = address
        request.counterparty_address = counterparty_address
        request.channel_id = channel_id

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Msg/RegisterCounterpartyAddress",
            request,
            MsgRegisterCounterpartyAddressResponse,
        )

    async def pay_packet_fee(
        self,
        *,
        fee: "Fee" = None,
        source_port_id: str = "",
        source_channel_id: str = "",
        signer: str = "",
        relayers: Optional[List[str]] = None
    ) -> "MsgPayPacketFeeResponse":
        relayers = relayers or []

        request = MsgPayPacketFee()
        if fee is not None:
            request.fee = fee
        request.source_port_id = source_port_id
        request.source_channel_id = source_channel_id
        request.signer = signer
        request.relayers = relayers

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Msg/PayPacketFee",
            request,
            MsgPayPacketFeeResponse,
        )

    async def pay_packet_fee_async(
        self,
        *,
        packet_id: "___core_channel_v1__.PacketId" = None,
        packet_fee: "PacketFee" = None
    ) -> "MsgPayPacketFeeAsyncResponse":

        request = MsgPayPacketFeeAsync()
        if packet_id is not None:
            request.packet_id = packet_id
        if packet_fee is not None:
            request.packet_fee = packet_fee

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Msg/PayPacketFeeAsync",
            request,
            MsgPayPacketFeeAsyncResponse,
        )


class QueryStub(betterproto.ServiceStub):
    async def incentivized_packets(
        self,
        *,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None,
        query_height: int = 0
    ) -> "QueryIncentivizedPacketsResponse":

        request = QueryIncentivizedPacketsRequest()
        if pagination is not None:
            request.pagination = pagination
        request.query_height = query_height

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/IncentivizedPackets",
            request,
            QueryIncentivizedPacketsResponse,
        )

    async def incentivized_packet(
        self,
        *,
        packet_id: "___core_channel_v1__.PacketId" = None,
        query_height: int = 0
    ) -> "QueryIncentivizedPacketResponse":

        request = QueryIncentivizedPacketRequest()
        if packet_id is not None:
            request.packet_id = packet_id
        request.query_height = query_height

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/IncentivizedPacket",
            request,
            QueryIncentivizedPacketResponse,
        )

    async def incentivized_packets_for_channel(
        self,
        *,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None,
        port_id: str = "",
        channel_id: str = "",
        query_height: int = 0
    ) -> "QueryIncentivizedPacketsForChannelResponse":

        request = QueryIncentivizedPacketsForChannelRequest()
        if pagination is not None:
            request.pagination = pagination
        request.port_id = port_id
        request.channel_id = channel_id
        request.query_height = query_height

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/IncentivizedPacketsForChannel",
            request,
            QueryIncentivizedPacketsForChannelResponse,
        )

    async def total_recv_fees(
        self, *, packet_id: "___core_channel_v1__.PacketId" = None
    ) -> "QueryTotalRecvFeesResponse":

        request = QueryTotalRecvFeesRequest()
        if packet_id is not None:
            request.packet_id = packet_id

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/TotalRecvFees",
            request,
            QueryTotalRecvFeesResponse,
        )

    async def total_ack_fees(
        self, *, packet_id: "___core_channel_v1__.PacketId" = None
    ) -> "QueryTotalAckFeesResponse":

        request = QueryTotalAckFeesRequest()
        if packet_id is not None:
            request.packet_id = packet_id

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/TotalAckFees",
            request,
            QueryTotalAckFeesResponse,
        )

    async def total_timeout_fees(
        self, *, packet_id: "___core_channel_v1__.PacketId" = None
    ) -> "QueryTotalTimeoutFeesResponse":

        request = QueryTotalTimeoutFeesRequest()
        if packet_id is not None:
            request.packet_id = packet_id

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/TotalTimeoutFees",
            request,
            QueryTotalTimeoutFeesResponse,
        )

    async def counterparty_address(
        self, *, channel_id: str = "", relayer_address: str = ""
    ) -> "QueryCounterpartyAddressResponse":

        request = QueryCounterpartyAddressRequest()
        request.channel_id = channel_id
        request.relayer_address = relayer_address

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/CounterpartyAddress",
            request,
            QueryCounterpartyAddressResponse,
        )

    async def fee_enabled_channels(
        self,
        *,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = None,
        query_height: int = 0
    ) -> "QueryFeeEnabledChannelsResponse":

        request = QueryFeeEnabledChannelsRequest()
        if pagination is not None:
            request.pagination = pagination
        request.query_height = query_height

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/FeeEnabledChannels",
            request,
            QueryFeeEnabledChannelsResponse,
        )

    async def fee_enabled_channel(
        self, *, port_id: str = "", channel_id: str = ""
    ) -> "QueryFeeEnabledChannelResponse":

        request = QueryFeeEnabledChannelRequest()
        request.port_id = port_id
        request.channel_id = channel_id

        return await self._unary_unary(
            "/ibc.applications.fee.v1.Query/FeeEnabledChannel",
            request,
            QueryFeeEnabledChannelResponse,
        )


class MsgBase(ServiceBase):
    async def register_counterparty_address(
        self, address: str, counterparty_address: str, channel_id: str
    ) -> "MsgRegisterCounterpartyAddressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pay_packet_fee(
        self,
        fee: "Fee",
        source_port_id: str,
        source_channel_id: str,
        signer: str,
        relayers: Optional[List[str]],
    ) -> "MsgPayPacketFeeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pay_packet_fee_async(
        self, packet_id: "___core_channel_v1__.PacketId", packet_fee: "PacketFee"
    ) -> "MsgPayPacketFeeAsyncResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_register_counterparty_address(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "counterparty_address": request.counterparty_address,
            "channel_id": request.channel_id,
        }

        response = await self.register_counterparty_address(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pay_packet_fee(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "fee": request.fee,
            "source_port_id": request.source_port_id,
            "source_channel_id": request.source_channel_id,
            "signer": request.signer,
            "relayers": request.relayers,
        }

        response = await self.pay_packet_fee(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pay_packet_fee_async(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet_id": request.packet_id,
            "packet_fee": request.packet_fee,
        }

        response = await self.pay_packet_fee_async(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.applications.fee.v1.Msg/RegisterCounterpartyAddress": grpclib.const.Handler(
                self.__rpc_register_counterparty_address,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgRegisterCounterpartyAddress,
                MsgRegisterCounterpartyAddressResponse,
            ),
            "/ibc.applications.fee.v1.Msg/PayPacketFee": grpclib.const.Handler(
                self.__rpc_pay_packet_fee,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgPayPacketFee,
                MsgPayPacketFeeResponse,
            ),
            "/ibc.applications.fee.v1.Msg/PayPacketFeeAsync": grpclib.const.Handler(
                self.__rpc_pay_packet_fee_async,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgPayPacketFeeAsync,
                MsgPayPacketFeeAsyncResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def incentivized_packets(
        self,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
        query_height: int,
    ) -> "QueryIncentivizedPacketsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def incentivized_packet(
        self, packet_id: "___core_channel_v1__.PacketId", query_height: int
    ) -> "QueryIncentivizedPacketResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def incentivized_packets_for_channel(
        self,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
        port_id: str,
        channel_id: str,
        query_height: int,
    ) -> "QueryIncentivizedPacketsForChannelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_recv_fees(
        self, packet_id: "___core_channel_v1__.PacketId"
    ) -> "QueryTotalRecvFeesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_ack_fees(
        self, packet_id: "___core_channel_v1__.PacketId"
    ) -> "QueryTotalAckFeesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_timeout_fees(
        self, packet_id: "___core_channel_v1__.PacketId"
    ) -> "QueryTotalTimeoutFeesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def counterparty_address(
        self, channel_id: str, relayer_address: str
    ) -> "QueryCounterpartyAddressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fee_enabled_channels(
        self,
        pagination: "____cosmos_base_query_v1_beta1__.PageRequest",
        query_height: int,
    ) -> "QueryFeeEnabledChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fee_enabled_channel(
        self, port_id: str, channel_id: str
    ) -> "QueryFeeEnabledChannelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_incentivized_packets(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
            "query_height": request.query_height,
        }

        response = await self.incentivized_packets(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_incentivized_packet(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet_id": request.packet_id,
            "query_height": request.query_height,
        }

        response = await self.incentivized_packet(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_incentivized_packets_for_channel(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
            "port_id": request.port_id,
            "channel_id": request.channel_id,
            "query_height": request.query_height,
        }

        response = await self.incentivized_packets_for_channel(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_total_recv_fees(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet_id": request.packet_id,
        }

        response = await self.total_recv_fees(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_total_ack_fees(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet_id": request.packet_id,
        }

        response = await self.total_ack_fees(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_total_timeout_fees(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "packet_id": request.packet_id,
        }

        response = await self.total_timeout_fees(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_counterparty_address(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "channel_id": request.channel_id,
            "relayer_address": request.relayer_address,
        }

        response = await self.counterparty_address(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_fee_enabled_channels(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
            "query_height": request.query_height,
        }

        response = await self.fee_enabled_channels(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_fee_enabled_channel(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "port_id": request.port_id,
            "channel_id": request.channel_id,
        }

        response = await self.fee_enabled_channel(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.applications.fee.v1.Query/IncentivizedPackets": grpclib.const.Handler(
                self.__rpc_incentivized_packets,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryIncentivizedPacketsRequest,
                QueryIncentivizedPacketsResponse,
            ),
            "/ibc.applications.fee.v1.Query/IncentivizedPacket": grpclib.const.Handler(
                self.__rpc_incentivized_packet,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryIncentivizedPacketRequest,
                QueryIncentivizedPacketResponse,
            ),
            "/ibc.applications.fee.v1.Query/IncentivizedPacketsForChannel": grpclib.const.Handler(
                self.__rpc_incentivized_packets_for_channel,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryIncentivizedPacketsForChannelRequest,
                QueryIncentivizedPacketsForChannelResponse,
            ),
            "/ibc.applications.fee.v1.Query/TotalRecvFees": grpclib.const.Handler(
                self.__rpc_total_recv_fees,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTotalRecvFeesRequest,
                QueryTotalRecvFeesResponse,
            ),
            "/ibc.applications.fee.v1.Query/TotalAckFees": grpclib.const.Handler(
                self.__rpc_total_ack_fees,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTotalAckFeesRequest,
                QueryTotalAckFeesResponse,
            ),
            "/ibc.applications.fee.v1.Query/TotalTimeoutFees": grpclib.const.Handler(
                self.__rpc_total_timeout_fees,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTotalTimeoutFeesRequest,
                QueryTotalTimeoutFeesResponse,
            ),
            "/ibc.applications.fee.v1.Query/CounterpartyAddress": grpclib.const.Handler(
                self.__rpc_counterparty_address,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCounterpartyAddressRequest,
                QueryCounterpartyAddressResponse,
            ),
            "/ibc.applications.fee.v1.Query/FeeEnabledChannels": grpclib.const.Handler(
                self.__rpc_fee_enabled_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryFeeEnabledChannelsRequest,
                QueryFeeEnabledChannelsResponse,
            ),
            "/ibc.applications.fee.v1.Query/FeeEnabledChannel": grpclib.const.Handler(
                self.__rpc_fee_enabled_channel,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryFeeEnabledChannelRequest,
                QueryFeeEnabledChannelResponse,
            ),
        }


from .....cosmos.base import v1beta1 as ____cosmos_base_v1_beta1__
from .....cosmos.base.query import v1beta1 as ____cosmos_base_query_v1_beta1__
from ....core.channel import v1 as ___core_channel_v1__
