# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmwasm/wasm/v1/genesis.proto, cosmwasm/wasm/v1/ibc.proto, cosmwasm/wasm/v1/proposal.proto, cosmwasm/wasm/v1/query.proto, cosmwasm/wasm/v1/tx.proto, cosmwasm/wasm/v1/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class AccessType(betterproto.Enum):
    """AccessType permission types"""

    # AccessTypeUnspecified placeholder for empty value
    ACCESS_TYPE_UNSPECIFIED = 0
    # AccessTypeNobody forbidden
    ACCESS_TYPE_NOBODY = 1
    # AccessTypeOnlyAddress restricted to an address
    ACCESS_TYPE_ONLY_ADDRESS = 2
    # AccessTypeEverybody unrestricted
    ACCESS_TYPE_EVERYBODY = 3


class ContractCodeHistoryOperationType(betterproto.Enum):
    """ContractCodeHistoryOperationType actions that caused a code change"""

    # ContractCodeHistoryOperationTypeUnspecified placeholder for empty value
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_UNSPECIFIED = 0
    # ContractCodeHistoryOperationTypeInit on chain contract instantiation
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_INIT = 1
    # ContractCodeHistoryOperationTypeMigrate code migration
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_MIGRATE = 2
    # ContractCodeHistoryOperationTypeGenesis based on genesis data
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_GENESIS = 3


@dataclass(eq=False, repr=False)
class AccessTypeParam(betterproto.Message):
    """AccessTypeParam"""

    value: "AccessType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class AccessConfig(betterproto.Message):
    """AccessConfig access control type."""

    permission: "AccessType" = betterproto.enum_field(1)
    address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the set of wasm parameters."""

    code_upload_access: "AccessConfig" = betterproto.message_field(1)
    instantiate_default_permission: "AccessType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class CodeInfo(betterproto.Message):
    """CodeInfo is data for the uploaded contract WASM code"""

    # CodeHash is the unique identifier created by wasmvm
    code_hash: bytes = betterproto.bytes_field(1)
    # Creator address who initially stored the code
    creator: str = betterproto.string_field(2)
    # InstantiateConfig access control to apply on contract creation, optional
    instantiate_config: "AccessConfig" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class ContractInfo(betterproto.Message):
    """ContractInfo stores a WASM contract instance"""

    # CodeID is the reference to the stored Wasm code
    code_id: int = betterproto.uint64_field(1)
    # Creator address who initially instantiated the contract
    creator: str = betterproto.string_field(2)
    # Admin is an optional address that can execute migrations
    admin: str = betterproto.string_field(3)
    # Label is optional metadata to be stored with a contract instance.
    label: str = betterproto.string_field(4)
    # Created Tx position when the contract was instantiated. This data should
    # kept internal and not be exposed via query results. Just use for sorting
    created: "AbsoluteTxPosition" = betterproto.message_field(5)
    ibc_port_id: str = betterproto.string_field(6)
    # Extension is an extension point to store custom metadata within the
    # persistence model.
    extension: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class ContractCodeHistoryEntry(betterproto.Message):
    """ContractCodeHistoryEntry metadata to a contract."""

    operation: "ContractCodeHistoryOperationType" = betterproto.enum_field(1)
    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(2)
    # Updated Tx position when the operation was executed.
    updated: "AbsoluteTxPosition" = betterproto.message_field(3)
    msg: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class AbsoluteTxPosition(betterproto.Message):
    """
    AbsoluteTxPosition is a unique transaction position that allows for global
    ordering of transactions.
    """

    # BlockHeight is the block the contract was created at
    block_height: int = betterproto.uint64_field(1)
    # TxIndex is a monotonic counter within the block (actual transaction index,
    # or gas consumed)
    tx_index: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class Model(betterproto.Message):
    """Model is a struct that holds a KV pair"""

    # hex-encode key to read it better (this is often ascii)
    key: bytes = betterproto.bytes_field(1)
    # base64-encode raw value
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class MsgStoreCode(betterproto.Message):
    """MsgStoreCode submit Wasm code to the system"""

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # WASMByteCode can be raw or gzip compressed
    wasm_byte_code: bytes = betterproto.bytes_field(2)
    # InstantiatePermission access control to apply on contract creation,
    # optional
    instantiate_permission: "AccessConfig" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class MsgStoreCodeResponse(betterproto.Message):
    """MsgStoreCodeResponse returns store result data."""

    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgInstantiateContract(betterproto.Message):
    """
    MsgInstantiateContract create a new smart contract instance for the given
    code id.
    """

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # Admin is an optional address that can execute migrations
    admin: str = betterproto.string_field(2)
    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(3)
    # Label is optional metadata to be stored with a contract instance.
    label: str = betterproto.string_field(4)
    # Msg json encoded message to be passed to the contract on instantiation
    msg: bytes = betterproto.bytes_field(5)
    # Funds coins that are transferred to the contract on instantiation
    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class MsgInstantiateContractResponse(betterproto.Message):
    """MsgInstantiateContractResponse return instantiation result data"""

    # Address is the bech32 address of the new contract instance.
    address: str = betterproto.string_field(1)
    # Data contains base64-encoded bytes to returned from the contract
    data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class MsgExecuteContract(betterproto.Message):
    """
    MsgExecuteContract submits the given message data to a smart contract
    """

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(2)
    # Msg json encoded message to be passed to the contract
    msg: bytes = betterproto.bytes_field(3)
    # Funds coins that are transferred to the contract on execution
    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class MsgExecuteContractResponse(betterproto.Message):
    """MsgExecuteContractResponse returns execution result data."""

    # Data contains base64-encoded bytes to returned from the contract
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class MsgMigrateContract(betterproto.Message):
    """
    MsgMigrateContract runs a code upgrade/ downgrade for a smart contract
    """

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(2)
    # CodeID references the new WASM code
    code_id: int = betterproto.uint64_field(3)
    # Msg json encoded message to be passed to the contract on migration
    msg: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class MsgMigrateContractResponse(betterproto.Message):
    """MsgMigrateContractResponse returns contract migration result data."""

    # Data contains same raw bytes returned as data from the wasm contract. (May
    # be empty)
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class MsgUpdateAdmin(betterproto.Message):
    """MsgUpdateAdmin sets a new admin for a smart contract"""

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # NewAdmin address to be set
    new_admin: str = betterproto.string_field(2)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgUpdateAdminResponse(betterproto.Message):
    """MsgUpdateAdminResponse returns empty data"""

    pass


@dataclass(eq=False, repr=False)
class MsgClearAdmin(betterproto.Message):
    """MsgClearAdmin removes any admin stored for a smart contract"""

    # Sender is the that actor that signed the messages
    sender: str = betterproto.string_field(1)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgClearAdminResponse(betterproto.Message):
    """MsgClearAdminResponse returns empty data"""

    pass


@dataclass(eq=False, repr=False)
class QueryContractInfoRequest(betterproto.Message):
    """
    QueryContractInfoRequest is the request type for the Query/ContractInfo RPC
    method
    """

    # address is the address of the contract to query
    address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryContractInfoResponse(betterproto.Message):
    """
    QueryContractInfoResponse is the response type for the Query/ContractInfo
    RPC method
    """

    # address is the address of the contract
    address: str = betterproto.string_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryContractHistoryRequest(betterproto.Message):
    """
    QueryContractHistoryRequest is the request type for the
    Query/ContractHistory RPC method
    """

    # address is the address of the contract to query
    address: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryContractHistoryResponse(betterproto.Message):
    """
    QueryContractHistoryResponse is the response type for the
    Query/ContractHistory RPC method
    """

    entries: List["ContractCodeHistoryEntry"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryContractsByCodeRequest(betterproto.Message):
    """
    QueryContractsByCodeRequest is the request type for the
    Query/ContractsByCode RPC method
    """

    code_id: int = betterproto.uint64_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryContractsByCodeResponse(betterproto.Message):
    """
    QueryContractsByCodeResponse is the response type for the
    Query/ContractsByCode RPC method
    """

    # contracts are a set of contract addresses
    contracts: List[str] = betterproto.string_field(1)
    # pagination defines the pagination in the response.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryAllContractStateRequest(betterproto.Message):
    """
    QueryAllContractStateRequest is the request type for the
    Query/AllContractState RPC method
    """

    # address is the address of the contract
    address: str = betterproto.string_field(1)
    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryAllContractStateResponse(betterproto.Message):
    """
    QueryAllContractStateResponse is the response type for the
    Query/AllContractState RPC method
    """

    models: List["Model"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryRawContractStateRequest(betterproto.Message):
    """
    QueryRawContractStateRequest is the request type for the
    Query/RawContractState RPC method
    """

    # address is the address of the contract
    address: str = betterproto.string_field(1)
    query_data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryRawContractStateResponse(betterproto.Message):
    """
    QueryRawContractStateResponse is the response type for the
    Query/RawContractState RPC method
    """

    # Data contains the raw store data
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QuerySmartContractStateRequest(betterproto.Message):
    """
    QuerySmartContractStateRequest is the request type for the
    Query/SmartContractState RPC method
    """

    # address is the address of the contract
    address: str = betterproto.string_field(1)
    # QueryData contains the query data passed to the contract
    query_data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QuerySmartContractStateResponse(betterproto.Message):
    """
    QuerySmartContractStateResponse is the response type for the
    Query/SmartContractState RPC method
    """

    # Data contains the json data returned from the smart contract
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryCodeRequest(betterproto.Message):
    """QueryCodeRequest is the request type for the Query/Code RPC method"""

    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class CodeInfoResponse(betterproto.Message):
    """CodeInfoResponse contains code meta data from CodeInfo"""

    code_id: int = betterproto.uint64_field(1)
    creator: str = betterproto.string_field(2)
    data_hash: bytes = betterproto.bytes_field(3)
    instantiate_permission: "AccessConfig" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class QueryCodeResponse(betterproto.Message):
    """QueryCodeResponse is the response type for the Query/Code RPC method"""

    code_info: "CodeInfoResponse" = betterproto.message_field(1)
    data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryCodesRequest(betterproto.Message):
    """QueryCodesRequest is the request type for the Query/Codes RPC method"""

    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )


@dataclass(eq=False, repr=False)
class QueryCodesResponse(betterproto.Message):
    """
    QueryCodesResponse is the response type for the Query/Codes RPC method
    """

    code_infos: List["CodeInfoResponse"] = betterproto.message_field(1)
    # pagination defines the pagination in the response.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPinnedCodesRequest(betterproto.Message):
    """
    QueryPinnedCodesRequest is the request type for the Query/PinnedCodes RPC
    method
    """

    # pagination defines an optional pagination for the request.
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QueryPinnedCodesResponse(betterproto.Message):
    """
    QueryPinnedCodesResponse is the response type for the Query/PinnedCodes RPC
    method
    """

    code_ids: List[int] = betterproto.uint64_field(1)
    # pagination defines the pagination in the response.
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState - genesis state of x/wasm"""

    params: "Params" = betterproto.message_field(1)
    codes: List["Code"] = betterproto.message_field(2)
    contracts: List["Contract"] = betterproto.message_field(3)
    sequences: List["Sequence"] = betterproto.message_field(4)
    gen_msgs: List["GenesisStateGenMsgs"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class GenesisStateGenMsgs(betterproto.Message):
    """
    GenMsgs define the messages that can be executed during genesis phase in
    order. The intention is to have more human readable data that is auditable.
    """

    store_code: "MsgStoreCode" = betterproto.message_field(1, group="sum")
    instantiate_contract: "MsgInstantiateContract" = betterproto.message_field(
        2, group="sum"
    )
    execute_contract: "MsgExecuteContract" = betterproto.message_field(3, group="sum")


@dataclass(eq=False, repr=False)
class Code(betterproto.Message):
    """Code struct encompasses CodeInfo and CodeBytes"""

    code_id: int = betterproto.uint64_field(1)
    code_info: "CodeInfo" = betterproto.message_field(2)
    code_bytes: bytes = betterproto.bytes_field(3)
    # Pinned to wasmvm cache
    pinned: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class Contract(betterproto.Message):
    """
    Contract struct encompasses ContractAddress, ContractInfo, and
    ContractState
    """

    contract_address: str = betterproto.string_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)
    contract_state: List["Model"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Sequence(betterproto.Message):
    """Sequence key and value of an id generation counter"""

    id_key: bytes = betterproto.bytes_field(1)
    value: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class StoreCodeProposal(betterproto.Message):
    """
    StoreCodeProposal gov proposal content type to submit WASM code to the
    system
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # RunAs is the address that is passed to the contract's environment as sender
    run_as: str = betterproto.string_field(3)
    # WASMByteCode can be raw or gzip compressed
    wasm_byte_code: bytes = betterproto.bytes_field(4)
    # InstantiatePermission to apply on contract creation, optional
    instantiate_permission: "AccessConfig" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class InstantiateContractProposal(betterproto.Message):
    """
    InstantiateContractProposal gov proposal content type to instantiate a
    contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # RunAs is the address that is passed to the contract's environment as sender
    run_as: str = betterproto.string_field(3)
    # Admin is an optional address that can execute migrations
    admin: str = betterproto.string_field(4)
    # CodeID is the reference to the stored WASM code
    code_id: int = betterproto.uint64_field(5)
    # Label is optional metadata to be stored with a constract instance.
    label: str = betterproto.string_field(6)
    # Msg json encoded message to be passed to the contract on instantiation
    msg: bytes = betterproto.bytes_field(7)
    # Funds coins that are transferred to the contract on instantiation
    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(8)


@dataclass(eq=False, repr=False)
class MigrateContractProposal(betterproto.Message):
    """
    MigrateContractProposal gov proposal content type to migrate a contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(4)
    # CodeID references the new WASM code
    code_id: int = betterproto.uint64_field(5)
    # Msg json encoded message to be passed to the contract on migration
    msg: bytes = betterproto.bytes_field(6)


@dataclass(eq=False, repr=False)
class SudoContractProposal(betterproto.Message):
    """
    SudoContractProposal gov proposal content type to call sudo on a contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(3)
    # Msg json encoded message to be passed to the contract as sudo
    msg: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class ExecuteContractProposal(betterproto.Message):
    """
    ExecuteContractProposal gov proposal content type to call execute on a
    contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # RunAs is the address that is passed to the contract's environment as sender
    run_as: str = betterproto.string_field(3)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(4)
    # Msg json encoded message to be passed to the contract as execute
    msg: bytes = betterproto.bytes_field(5)
    # Funds coins that are transferred to the contract on instantiation
    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class UpdateAdminProposal(betterproto.Message):
    """
    UpdateAdminProposal gov proposal content type to set an admin for a
    contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # NewAdmin address to be set
    new_admin: str = betterproto.string_field(3)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ClearAdminProposal(betterproto.Message):
    """
    ClearAdminProposal gov proposal content type to clear the admin of a
    contract.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # Contract is the address of the smart contract
    contract: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class PinCodesProposal(betterproto.Message):
    """
    PinCodesProposal gov proposal content type to pin a set of code ids in the
    wasmvm cache.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # CodeIDs references the new WASM codes
    code_ids: List[int] = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class UnpinCodesProposal(betterproto.Message):
    """
    UnpinCodesProposal gov proposal content type to unpin a set of code ids in
    the wasmvm cache.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # CodeIDs references the WASM codes
    code_ids: List[int] = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class AccessConfigUpdate(betterproto.Message):
    """
    AccessConfigUpdate contains the code id and the access config to be
    applied.
    """

    # CodeID is the reference to the stored WASM code to be updated
    code_id: int = betterproto.uint64_field(1)
    # InstantiatePermission to apply to the set of code ids
    instantiate_permission: "AccessConfig" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class UpdateInstantiateConfigProposal(betterproto.Message):
    """
    UpdateInstantiateConfigProposal gov proposal content type to update
    instantiate config to a  set of code ids.
    """

    # Title is a short summary
    title: str = betterproto.string_field(1)
    # Description is a human readable text
    description: str = betterproto.string_field(2)
    # AccessConfigUpdate contains the list of code ids and the access config to
    # be applied.
    access_config_updates: List["AccessConfigUpdate"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgIbcSend(betterproto.Message):
    """MsgIBCSend"""

    # the channel by which the packet will be sent
    channel: str = betterproto.string_field(2)
    # Timeout height relative to the current block height. The timeout is
    # disabled when set to 0.
    timeout_height: int = betterproto.uint64_field(4)
    # Timeout timestamp (in nanoseconds) relative to the current block timestamp.
    # The timeout is disabled when set to 0.
    timeout_timestamp: int = betterproto.uint64_field(5)
    # Data is the payload to transfer. We must not make assumption what format or
    # content is in here.
    data: bytes = betterproto.bytes_field(6)


@dataclass(eq=False, repr=False)
class MsgIbcCloseChannel(betterproto.Message):
    """MsgIBCCloseChannel port and channel need to be owned by the contract"""

    channel: str = betterproto.string_field(2)


class MsgStub(betterproto.ServiceStub):
    async def store_code(
        self,
        *,
        sender: str = "",
        wasm_byte_code: bytes = b"",
        instantiate_permission: "AccessConfig" = None
    ) -> "MsgStoreCodeResponse":

        request = MsgStoreCode()
        request.sender = sender
        request.wasm_byte_code = wasm_byte_code
        if instantiate_permission is not None:
            request.instantiate_permission = instantiate_permission

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/StoreCode", request, MsgStoreCodeResponse
        )

    async def instantiate_contract(
        self,
        *,
        sender: str = "",
        admin: str = "",
        code_id: int = 0,
        label: str = "",
        msg: bytes = b"",
        funds: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgInstantiateContractResponse":
        funds = funds or []

        request = MsgInstantiateContract()
        request.sender = sender
        request.admin = admin
        request.code_id = code_id
        request.label = label
        request.msg = msg
        if funds is not None:
            request.funds = funds

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/InstantiateContract",
            request,
            MsgInstantiateContractResponse,
        )

    async def execute_contract(
        self,
        *,
        sender: str = "",
        contract: str = "",
        msg: bytes = b"",
        funds: Optional[List["___cosmos_base_v1_beta1__.Coin"]] = None
    ) -> "MsgExecuteContractResponse":
        funds = funds or []

        request = MsgExecuteContract()
        request.sender = sender
        request.contract = contract
        request.msg = msg
        if funds is not None:
            request.funds = funds

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/ExecuteContract", request, MsgExecuteContractResponse
        )

    async def migrate_contract(
        self,
        *,
        sender: str = "",
        contract: str = "",
        code_id: int = 0,
        msg: bytes = b""
    ) -> "MsgMigrateContractResponse":

        request = MsgMigrateContract()
        request.sender = sender
        request.contract = contract
        request.code_id = code_id
        request.msg = msg

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/MigrateContract", request, MsgMigrateContractResponse
        )

    async def update_admin(
        self, *, sender: str = "", new_admin: str = "", contract: str = ""
    ) -> "MsgUpdateAdminResponse":

        request = MsgUpdateAdmin()
        request.sender = sender
        request.new_admin = new_admin
        request.contract = contract

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/UpdateAdmin", request, MsgUpdateAdminResponse
        )

    async def clear_admin(
        self, *, sender: str = "", contract: str = ""
    ) -> "MsgClearAdminResponse":

        request = MsgClearAdmin()
        request.sender = sender
        request.contract = contract

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/ClearAdmin", request, MsgClearAdminResponse
        )


class QueryStub(betterproto.ServiceStub):
    async def contract_info(self, *, address: str = "") -> "QueryContractInfoResponse":

        request = QueryContractInfoRequest()
        request.address = address

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractInfo", request, QueryContractInfoResponse
        )

    async def contract_history(
        self,
        *,
        address: str = "",
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryContractHistoryResponse":

        request = QueryContractHistoryRequest()
        request.address = address
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractHistory",
            request,
            QueryContractHistoryResponse,
        )

    async def contracts_by_code(
        self,
        *,
        code_id: int = 0,
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryContractsByCodeResponse":

        request = QueryContractsByCodeRequest()
        request.code_id = code_id
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractsByCode",
            request,
            QueryContractsByCodeResponse,
        )

    async def all_contract_state(
        self,
        *,
        address: str = "",
        pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryAllContractStateResponse":

        request = QueryAllContractStateRequest()
        request.address = address
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/AllContractState",
            request,
            QueryAllContractStateResponse,
        )

    async def raw_contract_state(
        self, *, address: str = "", query_data: bytes = b""
    ) -> "QueryRawContractStateResponse":

        request = QueryRawContractStateRequest()
        request.address = address
        request.query_data = query_data

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/RawContractState",
            request,
            QueryRawContractStateResponse,
        )

    async def smart_contract_state(
        self, *, address: str = "", query_data: bytes = b""
    ) -> "QuerySmartContractStateResponse":

        request = QuerySmartContractStateRequest()
        request.address = address
        request.query_data = query_data

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/SmartContractState",
            request,
            QuerySmartContractStateResponse,
        )

    async def code(self, *, code_id: int = 0) -> "QueryCodeResponse":

        request = QueryCodeRequest()
        request.code_id = code_id

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/Code", request, QueryCodeResponse
        )

    async def codes(
        self, *, pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryCodesResponse":

        request = QueryCodesRequest()
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/Codes", request, QueryCodesResponse
        )

    async def pinned_codes(
        self, *, pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = None
    ) -> "QueryPinnedCodesResponse":

        request = QueryPinnedCodesRequest()
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/PinnedCodes", request, QueryPinnedCodesResponse
        )


class MsgBase(ServiceBase):
    async def store_code(
        self, sender: str, wasm_byte_code: bytes, instantiate_permission: "AccessConfig"
    ) -> "MsgStoreCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def instantiate_contract(
        self,
        sender: str,
        admin: str,
        code_id: int,
        label: str,
        msg: bytes,
        funds: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgInstantiateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def execute_contract(
        self,
        sender: str,
        contract: str,
        msg: bytes,
        funds: Optional[List["___cosmos_base_v1_beta1__.Coin"]],
    ) -> "MsgExecuteContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def migrate_contract(
        self, sender: str, contract: str, code_id: int, msg: bytes
    ) -> "MsgMigrateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_admin(
        self, sender: str, new_admin: str, contract: str
    ) -> "MsgUpdateAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def clear_admin(self, sender: str, contract: str) -> "MsgClearAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_store_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "wasm_byte_code": request.wasm_byte_code,
            "instantiate_permission": request.instantiate_permission,
        }

        response = await self.store_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_instantiate_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "admin": request.admin,
            "code_id": request.code_id,
            "label": request.label,
            "msg": request.msg,
            "funds": request.funds,
        }

        response = await self.instantiate_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_execute_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "contract": request.contract,
            "msg": request.msg,
            "funds": request.funds,
        }

        response = await self.execute_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_migrate_contract(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "contract": request.contract,
            "code_id": request.code_id,
            "msg": request.msg,
        }

        response = await self.migrate_contract(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_update_admin(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "new_admin": request.new_admin,
            "contract": request.contract,
        }

        response = await self.update_admin(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_clear_admin(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "sender": request.sender,
            "contract": request.contract,
        }

        response = await self.clear_admin(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmwasm.wasm.v1.Msg/StoreCode": grpclib.const.Handler(
                self.__rpc_store_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgStoreCode,
                MsgStoreCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/InstantiateContract": grpclib.const.Handler(
                self.__rpc_instantiate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgInstantiateContract,
                MsgInstantiateContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/ExecuteContract": grpclib.const.Handler(
                self.__rpc_execute_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgExecuteContract,
                MsgExecuteContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/MigrateContract": grpclib.const.Handler(
                self.__rpc_migrate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMigrateContract,
                MsgMigrateContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/UpdateAdmin": grpclib.const.Handler(
                self.__rpc_update_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUpdateAdmin,
                MsgUpdateAdminResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/ClearAdmin": grpclib.const.Handler(
                self.__rpc_clear_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgClearAdmin,
                MsgClearAdminResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def contract_info(self, address: str) -> "QueryContractInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contract_history(
        self, address: str, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryContractHistoryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contracts_by_code(
        self, code_id: int, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryContractsByCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def all_contract_state(
        self, address: str, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryAllContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def raw_contract_state(
        self, address: str, query_data: bytes
    ) -> "QueryRawContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def smart_contract_state(
        self, address: str, query_data: bytes
    ) -> "QuerySmartContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def code(self, code_id: int) -> "QueryCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def codes(
        self, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryCodesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pinned_codes(
        self, pagination: "___cosmos_base_query_v1_beta1__.PageRequest"
    ) -> "QueryPinnedCodesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_contract_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
        }

        response = await self.contract_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contract_history(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "pagination": request.pagination,
        }

        response = await self.contract_history(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contracts_by_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
            "pagination": request.pagination,
        }

        response = await self.contracts_by_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_all_contract_state(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "pagination": request.pagination,
        }

        response = await self.all_contract_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_raw_contract_state(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "query_data": request.query_data,
        }

        response = await self.raw_contract_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_smart_contract_state(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "query_data": request.query_data,
        }

        response = await self.smart_contract_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
        }

        response = await self.code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_codes(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
        }

        response = await self.codes(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_pinned_codes(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
        }

        response = await self.pinned_codes(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmwasm.wasm.v1.Query/ContractInfo": grpclib.const.Handler(
                self.__rpc_contract_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractInfoRequest,
                QueryContractInfoResponse,
            ),
            "/cosmwasm.wasm.v1.Query/ContractHistory": grpclib.const.Handler(
                self.__rpc_contract_history,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractHistoryRequest,
                QueryContractHistoryResponse,
            ),
            "/cosmwasm.wasm.v1.Query/ContractsByCode": grpclib.const.Handler(
                self.__rpc_contracts_by_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractsByCodeRequest,
                QueryContractsByCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Query/AllContractState": grpclib.const.Handler(
                self.__rpc_all_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryAllContractStateRequest,
                QueryAllContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/RawContractState": grpclib.const.Handler(
                self.__rpc_raw_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRawContractStateRequest,
                QueryRawContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/SmartContractState": grpclib.const.Handler(
                self.__rpc_smart_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySmartContractStateRequest,
                QuerySmartContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/Code": grpclib.const.Handler(
                self.__rpc_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodeRequest,
                QueryCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Query/Codes": grpclib.const.Handler(
                self.__rpc_codes,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodesRequest,
                QueryCodesResponse,
            ),
            "/cosmwasm.wasm.v1.Query/PinnedCodes": grpclib.const.Handler(
                self.__rpc_pinned_codes,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPinnedCodesRequest,
                QueryPinnedCodesResponse,
            ),
        }


from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
from ....cosmos.base.query import v1beta1 as ___cosmos_base_query_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
