# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/mint/v1beta1/genesis.proto, cosmos/mint/v1beta1/mint.proto, cosmos/mint/v1beta1/query.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class Minter(betterproto.Message):
    """Minter represents the minting state."""

    # current annual inflation rate
    inflation: str = betterproto.string_field(1)
    # current annual expected provisions
    annual_provisions: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params holds parameters for the mint module."""

    # type of coin to mint
    mint_denom: str = betterproto.string_field(1)
    # maximum annual change in inflation rate
    inflation_rate_change: str = betterproto.string_field(2)
    # maximum inflation rate
    inflation_max: str = betterproto.string_field(3)
    # minimum inflation rate
    inflation_min: str = betterproto.string_field(4)
    # goal of percent bonded atoms
    goal_bonded: str = betterproto.string_field(5)
    # expected blocks per year
    blocks_per_year: int = betterproto.uint64_field(6)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    # params defines the parameters of the module.
    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryInflationRequest(betterproto.Message):
    """
    QueryInflationRequest is the request type for the Query/Inflation RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryInflationResponse(betterproto.Message):
    """
    QueryInflationResponse is the response type for the Query/Inflation RPC
    method.
    """

    # inflation is the current minting inflation value.
    inflation: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryAnnualProvisionsRequest(betterproto.Message):
    """
    QueryAnnualProvisionsRequest is the request type for the
    Query/AnnualProvisions RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryAnnualProvisionsResponse(betterproto.Message):
    """
    QueryAnnualProvisionsResponse is the response type for the
    Query/AnnualProvisions RPC method.
    """

    # annual_provisions is the current minting annual provisions value.
    annual_provisions: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the mint module's genesis state."""

    # minter is a space for holding current inflation information.
    minter: "Minter" = betterproto.message_field(1)
    # params defines all the paramaters of the module.
    params: "Params" = betterproto.message_field(2)


class QueryStub(betterproto.ServiceStub):
    async def params(self) -> "QueryParamsResponse":

        request = QueryParamsRequest()

        return await self._unary_unary(
            "/cosmos.mint.v1beta1.Query/Params", request, QueryParamsResponse
        )

    async def inflation(self) -> "QueryInflationResponse":

        request = QueryInflationRequest()

        return await self._unary_unary(
            "/cosmos.mint.v1beta1.Query/Inflation", request, QueryInflationResponse
        )

    async def annual_provisions(self) -> "QueryAnnualProvisionsResponse":

        request = QueryAnnualProvisionsRequest()

        return await self._unary_unary(
            "/cosmos.mint.v1beta1.Query/AnnualProvisions",
            request,
            QueryAnnualProvisionsResponse,
        )


class QueryBase(ServiceBase):
    async def params(self) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inflation(self) -> "QueryInflationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def annual_provisions(self) -> "QueryAnnualProvisionsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.params(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_inflation(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.inflation(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_annual_provisions(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.annual_provisions(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.mint.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/cosmos.mint.v1beta1.Query/Inflation": grpclib.const.Handler(
                self.__rpc_inflation,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryInflationRequest,
                QueryInflationResponse,
            ),
            "/cosmos.mint.v1beta1.Query/AnnualProvisions": grpclib.const.Handler(
                self.__rpc_annual_provisions,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryAnnualProvisionsRequest,
                QueryAnnualProvisionsResponse,
            ),
        }
