# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/base/tendermint/v1beta1/query.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class GetValidatorSetByHeightRequest(betterproto.Message):
    """
    GetValidatorSetByHeightRequest is the request type for the
    Query/GetValidatorSetByHeight RPC method.
    """

    height: int = betterproto.int64_field(1)
    # pagination defines an pagination for the request.
    pagination: "__query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetValidatorSetByHeightResponse(betterproto.Message):
    """
    GetValidatorSetByHeightResponse is the response type for the
    Query/GetValidatorSetByHeight RPC method.
    """

    block_height: int = betterproto.int64_field(1)
    validators: List["Validator"] = betterproto.message_field(2)
    # pagination defines an pagination for the response.
    pagination: "__query_v1_beta1__.PageResponse" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class GetLatestValidatorSetRequest(betterproto.Message):
    """
    GetLatestValidatorSetRequest is the request type for the
    Query/GetValidatorSetByHeight RPC method.
    """

    # pagination defines an pagination for the request.
    pagination: "__query_v1_beta1__.PageRequest" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetLatestValidatorSetResponse(betterproto.Message):
    """
    GetLatestValidatorSetResponse is the response type for the
    Query/GetValidatorSetByHeight RPC method.
    """

    block_height: int = betterproto.int64_field(1)
    validators: List["Validator"] = betterproto.message_field(2)
    # pagination defines an pagination for the response.
    pagination: "__query_v1_beta1__.PageResponse" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Validator(betterproto.Message):
    """Validator is the type for the validator-set."""

    address: str = betterproto.string_field(1)
    pub_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    voting_power: int = betterproto.int64_field(3)
    proposer_priority: int = betterproto.int64_field(4)


@dataclass(eq=False, repr=False)
class GetBlockByHeightRequest(betterproto.Message):
    """
    GetBlockByHeightRequest is the request type for the Query/GetBlockByHeight
    RPC method.
    """

    height: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class GetBlockByHeightResponse(betterproto.Message):
    """
    GetBlockByHeightResponse is the response type for the
    Query/GetBlockByHeight RPC method.
    """

    block_id: "____tendermint_types__.BlockId" = betterproto.message_field(1)
    block: "____tendermint_types__.Block" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetLatestBlockRequest(betterproto.Message):
    """
    GetLatestBlockRequest is the request type for the Query/GetLatestBlock RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class GetLatestBlockResponse(betterproto.Message):
    """
    GetLatestBlockResponse is the response type for the Query/GetLatestBlock
    RPC method.
    """

    block_id: "____tendermint_types__.BlockId" = betterproto.message_field(1)
    block: "____tendermint_types__.Block" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetSyncingRequest(betterproto.Message):
    """
    GetSyncingRequest is the request type for the Query/GetSyncing RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class GetSyncingResponse(betterproto.Message):
    """
    GetSyncingResponse is the response type for the Query/GetSyncing RPC
    method.
    """

    syncing: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class GetNodeInfoRequest(betterproto.Message):
    """
    GetNodeInfoRequest is the request type for the Query/GetNodeInfo RPC
    method.
    """

    pass


@dataclass(eq=False, repr=False)
class GetNodeInfoResponse(betterproto.Message):
    """
    GetNodeInfoResponse is the request type for the Query/GetNodeInfo RPC
    method.
    """

    default_node_info: "____tendermint_p2_p__.DefaultNodeInfo" = (
        betterproto.message_field(1)
    )
    application_version: "VersionInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class VersionInfo(betterproto.Message):
    """VersionInfo is the type for the GetNodeInfoResponse message."""

    name: str = betterproto.string_field(1)
    app_name: str = betterproto.string_field(2)
    version: str = betterproto.string_field(3)
    git_commit: str = betterproto.string_field(4)
    build_tags: str = betterproto.string_field(5)
    go_version: str = betterproto.string_field(6)
    build_deps: List["Module"] = betterproto.message_field(7)
    # Since: cosmos-sdk 0.43
    cosmos_sdk_version: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class Module(betterproto.Message):
    """Module is the type for VersionInfo"""

    # module path
    path: str = betterproto.string_field(1)
    # module version
    version: str = betterproto.string_field(2)
    # checksum
    sum: str = betterproto.string_field(3)


class ServiceStub(betterproto.ServiceStub):
    async def get_node_info(self) -> "GetNodeInfoResponse":

        request = GetNodeInfoRequest()

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetNodeInfo",
            request,
            GetNodeInfoResponse,
        )

    async def get_syncing(self) -> "GetSyncingResponse":

        request = GetSyncingRequest()

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetSyncing",
            request,
            GetSyncingResponse,
        )

    async def get_latest_block(self) -> "GetLatestBlockResponse":

        request = GetLatestBlockRequest()

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetLatestBlock",
            request,
            GetLatestBlockResponse,
        )

    async def get_block_by_height(
        self, *, height: int = 0
    ) -> "GetBlockByHeightResponse":

        request = GetBlockByHeightRequest()
        request.height = height

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetBlockByHeight",
            request,
            GetBlockByHeightResponse,
        )

    async def get_latest_validator_set(
        self, *, pagination: "__query_v1_beta1__.PageRequest" = None
    ) -> "GetLatestValidatorSetResponse":

        request = GetLatestValidatorSetRequest()
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetLatestValidatorSet",
            request,
            GetLatestValidatorSetResponse,
        )

    async def get_validator_set_by_height(
        self, *, height: int = 0, pagination: "__query_v1_beta1__.PageRequest" = None
    ) -> "GetValidatorSetByHeightResponse":

        request = GetValidatorSetByHeightRequest()
        request.height = height
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.base.tendermint.v1beta1.Service/GetValidatorSetByHeight",
            request,
            GetValidatorSetByHeightResponse,
        )


class ServiceBase(ServiceBase):
    async def get_node_info(self) -> "GetNodeInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_syncing(self) -> "GetSyncingResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_latest_block(self) -> "GetLatestBlockResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_block_by_height(self, height: int) -> "GetBlockByHeightResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_latest_validator_set(
        self, pagination: "__query_v1_beta1__.PageRequest"
    ) -> "GetLatestValidatorSetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_validator_set_by_height(
        self, height: int, pagination: "__query_v1_beta1__.PageRequest"
    ) -> "GetValidatorSetByHeightResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_node_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_node_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_syncing(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_syncing(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_latest_block(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_latest_block(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_block_by_height(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
        }

        response = await self.get_block_by_height(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_latest_validator_set(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "pagination": request.pagination,
        }

        response = await self.get_latest_validator_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_validator_set_by_height(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
            "pagination": request.pagination,
        }

        response = await self.get_validator_set_by_height(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.base.tendermint.v1beta1.Service/GetNodeInfo": grpclib.const.Handler(
                self.__rpc_get_node_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNodeInfoRequest,
                GetNodeInfoResponse,
            ),
            "/cosmos.base.tendermint.v1beta1.Service/GetSyncing": grpclib.const.Handler(
                self.__rpc_get_syncing,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetSyncingRequest,
                GetSyncingResponse,
            ),
            "/cosmos.base.tendermint.v1beta1.Service/GetLatestBlock": grpclib.const.Handler(
                self.__rpc_get_latest_block,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetLatestBlockRequest,
                GetLatestBlockResponse,
            ),
            "/cosmos.base.tendermint.v1beta1.Service/GetBlockByHeight": grpclib.const.Handler(
                self.__rpc_get_block_by_height,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetBlockByHeightRequest,
                GetBlockByHeightResponse,
            ),
            "/cosmos.base.tendermint.v1beta1.Service/GetLatestValidatorSet": grpclib.const.Handler(
                self.__rpc_get_latest_validator_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetLatestValidatorSetRequest,
                GetLatestValidatorSetResponse,
            ),
            "/cosmos.base.tendermint.v1beta1.Service/GetValidatorSetByHeight": grpclib.const.Handler(
                self.__rpc_get_validator_set_by_height,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetValidatorSetByHeightRequest,
                GetValidatorSetByHeightResponse,
            ),
        }


from .....tendermint import p2p as ____tendermint_p2_p__
from .....tendermint import types as ____tendermint_types__
from ...query import v1beta1 as __query_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
