# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/base/reflection/v1beta1/reflection.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class ListAllInterfacesRequest(betterproto.Message):
    """
    ListAllInterfacesRequest is the request type of the ListAllInterfaces RPC.
    """

    pass


@dataclass(eq=False, repr=False)
class ListAllInterfacesResponse(betterproto.Message):
    """
    ListAllInterfacesResponse is the response type of the ListAllInterfaces
    RPC.
    """

    # interface_names is an array of all the registered interfaces.
    interface_names: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListImplementationsRequest(betterproto.Message):
    """
    ListImplementationsRequest is the request type of the ListImplementations
    RPC.
    """

    # interface_name defines the interface to query the implementations for.
    interface_name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListImplementationsResponse(betterproto.Message):
    """
    ListImplementationsResponse is the response type of the ListImplementations
    RPC.
    """

    implementation_message_names: List[str] = betterproto.string_field(1)


class ReflectionServiceStub(betterproto.ServiceStub):
    async def list_all_interfaces(self) -> "ListAllInterfacesResponse":

        request = ListAllInterfacesRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v1beta1.ReflectionService/ListAllInterfaces",
            request,
            ListAllInterfacesResponse,
        )

    async def list_implementations(
        self, *, interface_name: str = ""
    ) -> "ListImplementationsResponse":

        request = ListImplementationsRequest()
        request.interface_name = interface_name

        return await self._unary_unary(
            "/cosmos.base.reflection.v1beta1.ReflectionService/ListImplementations",
            request,
            ListImplementationsResponse,
        )


class ReflectionServiceBase(ServiceBase):
    async def list_all_interfaces(self) -> "ListAllInterfacesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_implementations(
        self, interface_name: str
    ) -> "ListImplementationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_list_all_interfaces(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.list_all_interfaces(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_implementations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "interface_name": request.interface_name,
        }

        response = await self.list_implementations(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.base.reflection.v1beta1.ReflectionService/ListAllInterfaces": grpclib.const.Handler(
                self.__rpc_list_all_interfaces,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListAllInterfacesRequest,
                ListAllInterfacesResponse,
            ),
            "/cosmos.base.reflection.v1beta1.ReflectionService/ListImplementations": grpclib.const.Handler(
                self.__rpc_list_implementations,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListImplementationsRequest,
                ListImplementationsResponse,
            ),
        }
