# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['Record', 'Role', 'Status', 'readlen', 'recv_record', 'params', 'send_record', 'send_stream', 'FcgiHandler',
           'TextWrapper']

# Cell
from fastcore.foundation import *
from fastcore.utils import *
from fastcore.meta import *

import struct
from socketserver import StreamRequestHandler,BaseRequestHandler,UnixStreamServer,TCPServer
from enum import Enum
from io import BytesIO,TextIOWrapper,StringIO

# Cell
Record = Enum('Record', 'BEGIN_REQUEST ABORT_REQUEST END_REQUEST PARAMS STDIN '
               'STDOUT STDERR DATA GET_VALUES GET_VALUES_RESULT')
Role = Enum('Role', 'RESPONDER AUTHORIZER FILTER')
Status = Enum('Status', 'REQUEST_COMPLETE CANT_MPX_CONN OVERLOADED UNKNOWN_ROLE')

# Cell
def _S(fmt): return struct.Struct('!'+fmt) # use `struct` "network order"
_rec_struct,_endreq_struct,_begreq_struct,_long_struct = _S('BBHHbb'),_S('LBxxx'),_S('Hb5s'),_S('L')
_streams_data = Record.STDIN,Record.DATA
_streams_in  = (Record.PARAMS,) + _streams_data
_streams_out = Record.STDOUT,Record.STDERR
_streams = _streams_in + _streams_out + (Record.END_REQUEST,)

# Cell
def readlen(r):
    "Read the length of the next fcgi parameter"
    # See http://www.mit.edu/~yandros/doc/specs/fcgi-spec.html#S3.4
    a = r(1)
    res = a[0]
    if res>>7: res =_long_struct.unpack(a+r(3))[0] & 0x7fffffff
    return res

# Cell
def _recv_struct(recv, fmt):
    if not isinstance(fmt,struct.Struct): fmt = _S(fmt)
    res = fmt.unpack(recv(fmt.size))
    return res[0] if len(res)==1 else res

# Cell
def recv_record(r):
    "Receive one fastcgi record from `r`"
    _,typ,_,contentlen,padlen,_ = _recv_struct(r, _rec_struct)
    c = _recv_struct(r, f'{contentlen}s{"x"*padlen}')
    typ = Record(typ)
    if   typ==Record.BEGIN_REQUEST: c = _begreq_struct.unpack(c)[:2]
    elif typ==Record.ABORT_REQUEST: c = ()
    return typ,c

# Cell
def _params(s):
    b = BytesIO(s)
    r = b.read
    while b.tell()<len(s):
        lk,lv = readlen(r),readlen(r)
        yield _recv_struct(r, f'{lk}s{lv}s')

def params(s:bytes)->dict:
    "Parse fastcgi parameters from `s`"
    return {k.decode():v.decode() for k,v in _params(s)}

# Cell
def send_record(typ, w, c=b''):
    "Send fastcgi binary record of `typ` to `w`"
    for o in chunked(c, 64000): w(_rec_struct.pack(1, typ.value, 1, len(o), 0, 0) + bytes(o))

# Cell
def send_stream(typ, w, s):
    "Send fastcgi stream of `typ` to `w`"
    v = s.getvalue()
    if not v: return
    send_record(typ, w, v)
    send_record(typ, w)

# Cell
class FcgiHandler(StreamRequestHandler):
    "A request handler that processes FastCGI streams and parameters"
    rbufsize = wbufsize = 2**16
    def setup(self):
        super().setup()
        self.streams = {o:BytesIO() for o in _streams}
        sz,self.length = 0,1
        while sz<self.length: sz += ifnone(self._recv(), 0)
        self['stdin'].seek(0)

    def finish(self):
        for o in _streams_out: send_stream(o, self.wfile.write, self[o])
        rec = _endreq_struct.pack(0, Status.REQUEST_COMPLETE.value)
        send_record(Record.END_REQUEST, self.wfile.write, rec)
        super().finish()

    def _recv(self):
        typ,c = recv_record(self.rfile.read)
        if typ in _streams_in:
            self[typ].write(c)
            if typ==Record.PARAMS and not c:
                self.environ = params(self[typ].getbuffer())
                self.length = int(self.environ.get('HTTP_CONTENT_LENGTH',0) or 0)
        if typ in _streams_data: return len(c)

    def __getitem__(self,k): return self.streams[Record[k.upper()] if isinstance(k,str) else k]

# Cell
class TextWrapper(TextIOWrapper): close=TextIOWrapper.flush

def _print_bytes(s:str, stream):
    "Convert `s` to `bytes`, using `\r\n` for newlines"
    print(s, file=TextWrapper(stream, newline='\r\n', encoding='utf8'))

# Cell
@patch
def print(self:FcgiHandler,s=""):
    "Write a `str` to `self.stdout` as bytes, converting line endings to `\r\n`"
    _print_bytes(s, self['stdout'])

# Cell
@patch
def err(self:FcgiHandler,s=""):
    "Write a `str` to `self.stderr` as bytes, converting line endings to `\r\n`"
    _print_bytes(s, self['stderr'])

# Cell
@patch
def content(self:FcgiHandler)->str:
    "Contents of stdin"
    return self['stdin'].getvalue().decode()

# Cell
@patch
def write(self:FcgiHandler, b:bytes, err=False):
    "Write `b` to stderr (if `err`) or stdout (otherwise)"
    self['stderr' if err else 'stdout'].write(b)