"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouter = exports.TransitRouterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouter; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouter`
 */
class TransitRouter extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouter`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouter = new cen_generated_1.RosTransitRouter(this, id, {
            cenId: props.cenId,
            transitRouterName: props.transitRouterName,
            transitRouterDescription: props.transitRouterDescription,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouter;
        this.attrAliUid = rosTransitRouter.attrAliUid;
        this.attrCenId = rosTransitRouter.attrCenId;
        this.attrSystemTransitRouterRouteTableId = rosTransitRouter.attrSystemTransitRouterRouteTableId;
        this.attrTransitRouterDescription = rosTransitRouter.attrTransitRouterDescription;
        this.attrTransitRouterId = rosTransitRouter.attrTransitRouterId;
        this.attrTransitRouterName = rosTransitRouter.attrTransitRouterName;
        this.attrType = rosTransitRouter.attrType;
    }
}
exports.TransitRouter = TransitRouter;
//# sourceMappingURL=data:application/json;base64,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