# reNotize
[![CircleCI](https://circleci.com/gh/kobaltcore/renotize.svg?style=svg)](https://circleci.com/gh/kobaltcore/renotize)
[![Downloads](https://pepy.tech/badge/renotize)](https://pepy.tech/project/renotize)

A utility script for quickly and automatically notarizing Ren'Py applications for macOS.

reNotize supports the entire pipeline of app notarization, starting with the basic ZIP file generated by Ren'Py's build process and automatically generating a fully-notarized DMG for distribution to your users.

## Installation
reNotize can be installed via pip:
```bash
$ pip install renotize
```

Please note that reNotize requires Python 3 and will not provide backwards compatibility for Python 2 for the foreseeable future.

## Usage
reNotize operates in stages. Each stage can be executed standalone, making it easy to add intermediary steps if required. For convenience, the subcommand `full-run` offers full automation, executing all stages in order as well as waiting for notarization to finish at the particular steps that require it.

The general process flow is as follows:
- `unpack-app`: Takes the ZIP file of the macOS build generated by Ren'Py's build process and unpacks it into a directory.
- `sign-app`: Signs the `.app` bundle using the provided developer identity.
- `notarize-app`: Repacks the signed app bundle into a new ZIP file and uploads it to Apple's notarization service for review.
- `staple-app`: Staples the ticket generated by the notarization service to the `.app` bundle.
- `pack-dmg`: Creates a DMG file containing the signed and stapled `.app` bundle.
- `sign-dmg`: Signs the DMG file using the provided developer identity.
- `notarize-dmg`: Uploads the DMG file to Apple's notarization service for review.
- `staple-dmg`: Staples the ticket generated by the notarization service to the DMG file.

The output of this process will be a properly signed and stapled DMG file which can be distributed to your users.


### Configuration
reNotize requires a configuration file to be supplied containing the information required to sign apps on macOS. An empty template is provided in this repository under the name `config.empty.yml`

It consists of the following keys:
- `apple_id`: The e-Mail address belonging to the Apple ID you want to use for signing applications.
- `password`: An app-specific password generated through the [management portal](https://appleid.apple.com/account/manage) of your Apple ID.
- `identity`: The identity associated with your Developer Certificate which can be found in `Keychain Access` under the category "My Certificates". It starts with `Developer ID Application:`, however it suffices to provide the 10-character code in the title of the certificate.
- `bundle`: The internal name for your app. This is typically the reverse domain notation of your website plus your application name, i.e. `com.example.mygame`.
- `altool_extra`: An optional string that will be passed on to all `altool` runs in all commands. Useful for selecting an organization when your Apple ID belongs to multiple, for example. Typically you will not have to touch this and you can leave it empty.

### Example
```bash
renotize -c config.yaml MyGame-1.0-mac.zip full-run
```

### Command Line Interface
```
Usage: renotize [OPTIONS] PROJECT COMMAND [ARGS]...

  A utility script for quickly and automatically notarizing Ren'Py
  applications for macOS.

  Commands can be abbreviated by the shortest unique string.

  For example:
      unpack-app -> u
      sign-app -> sign-a
      sign-dmg -> sign-d

  The fully automatic process can be started using:
      renotize -c <path_to_config> <path_to_ZIP_file> full-run

Options:
  -c, --config TEXT
  -d, --debug / -nd, --no-debug  Print debug information or only regular
                                 output

  --help                         Show this message and exit.

Commands:
  full-run
  notarize-app
  notarize-dmg
  pack-dmg
  sign-app
  sign-dmg
  staple-app
  staple-dmg
  status
  unpack-app
```

# Disclaimer
reNotize is a hobby project and not in any way affiliated with Ren'Py. This means that there is no way I can guarantee that it will work at all, or continue to work once it does.
