/*! For license information please see extension.js.LICENSE.txt */
define(["base/js/namespace","jquery"],((e,t)=>(()=>{var n={227:(e,t,n)=>{(t=n(352)(!1)).push([e.id,"#bxy-outer-control-panel {\n  position: absolute;\n  padding: 6px 6px 6px 4px;\n  top: 120px;\n  right: 16px;\n  background-color: rgba(245, 245, 245, 0.9);\n  border-radius: 4px;\n  border: 1px solid #aaa;\n  z-index: 110;\n  user-select: none;\n}\n\n#bxy-inner-control-panel {\n  display: flex;\n  /* cursor: grab; */\n}\n\n/* #bxy-inner-control-panel:active {\n  cursor: grabbing;\n} */\n\n/* \nhttp://www.patternify.com/\n*/\n.bxy-small-dot-pattern {\n  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAADCAYAAABWKLW/AAAAF0lEQVQYV2NkYGD4z8DAwMgAI0AMDA4AI3EBBMY7CTgAAAAASUVORK5CYII=)\n    repeat;\n}\n\n#bxy-drag-handle {\n  cursor: grab;\n  margin-left: 0px;\n  margin-right: 4px;\n  width: 10px;\n}\n\n#bxy-drag-handle:active {\n  cursor: grabbing;\n}\n\n.bxy-control-panel {\n  display: none;\n  margin-top: 4px;\n}\n\n.bxy-control-panel .btn {\n  padding: 3px 4px;\n}\n\n#bxy-notifier {\n  max-width: 160px;\n  font-size: 0.9em;\n}\n\n#bxy-control-panel-title {\n  /* cursor: grab; */\n  display: flex;\n  align-items: center;\n  color: #666;\n  text-transform: uppercase;\n  text-align: center;\n  width: 100%;\n  margin-top: 0px;\n  margin-bottom: 0px;\n  font-size: 0.8em;\n}\n\n/* #bxy-control-panel-title:active {\n  cursor: grabbing;\n} */\n\n/* #bxy-control-panel-title div {\n  margin-right: 5px;\n} */\n\n#bxy-control-panel-title #bxy-logo-text {\n  /* transform: scale(1.05, 1.25); */\n  /* margin-left: 6px; */\n  /* margin-top: -4px; */\n  /* letter-spacing: 0.9em; */\n  width: 100%;\n  text-align-last: justify;\n}\n\n#bxy-control-panel-title img {\n  width: 22px;\n  padding: 0 2px 0 2px;\n}\n\n.bxy-config-title {\n  font-weight: bold;\n  /* font-size: 15px; */\n}\n\n.bxy-form-item {\n  display: flex;\n  align-items: center;\n  margin-top: 6px;\n  max-width: 200px;\n}\n\n.bxy-form-item span {\n  white-space: nowrap;\n  margin-right: 4px;\n}\n\n.bxy-sticker-inner {\n  /*  border:2px dashed red;*/\n  pointer-events: none;\n}\n\n.bxy-sticker-inner div {\n  position: absolute;\n  left: 0px;\n  top: 0px;\n  margin-top: 3px;\n  margin-left: 3px;\n}\n\n.bxy-right-side-marker {\n  opacity: 0.5;\n  cursor: pointer;\n}\n\n#bxy-config-btns {\n  display: flex;\n  justify-content: center;\n}\n\n#bxy-config-btns button {\n  margin: 4px 4px 0;\n}\n",""]),e.exports=t},781:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t){void 0===t&&(t="download");var n="data:text/plain;charset=utf-8,"+encodeURIComponent(JSON.stringify(e)),r=document.createElement("a");r.href=n,r.download=t+".ipynb",document.body.appendChild(r),r.click(),document.body.removeChild(r)}},270:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.extractErrorMessage=t.ERROR_INFO_MAP=void 0,t.ERROR_INFO_MAP={SyntaxError:"#### 什么是 `SyntaxError` ?\n\n语法错误，情况比较复杂。下面列出一些可能的情况。\n\n* 示例代码\n\n```python\nif True\n    print(1)\n```\n\n**错误分析**：`if` 语句的冒号缺失\n\n* 示例代码\n\n```python\nprint(\"a string)\n```\n\n**错误分析**：`\"a string` 的引号缺失\n\n* 示例代码\n\n```python\nif 3 = 3:\n    print('True')\n```\n\n**错误分析**：使用 `=` 而非 `==` 判断相等",NameError:"#### 什么是 `NameError` ?\n\n访问未定义的对象\n\n* 示例代码\n\n```python\n>>> print(a)\nTraceback (most recent call last):\n    File \"<stdin>\", line 1, in <module>\nNameError: name 'a' is not defined\n```\n\n**错误分析**：变量 `a` 未定义\n\n* 示例代码\n\n```python\n>>> prnit(1)\nTraceback (most recent call last):\n    File \"<stdin>\", line 1, in <module>\nNameError: name 'prnit' is not defined\n```\n\n**错误分析**：输出函数拼写错误，`prnit` 在是一个未定义的函数",IndentationError:"#### 什么是 `IndentationError` ?\n\n代码缩进错误，检查是否有多余的空格。",TypeError:"#### 什么是 `TypeError` ?\n\n类型错误。\n\n* 示例代码\n\n```python\n>>> for i in len(a_list):\n>>>     print(i)\nTraceback (most recent call last):\n  File \"<stdin>\", line 1, in <module>\nTypeError: 'int' object is not iterable\n```\n\n**错误分析**：在 `for` 语句中遗漏了 `range`，而 `len(a_list)` 的类型是整数，是不可迭代的。",IndexError:'#### 什么是 `IndexError` ?\n\n访问列表或元组元素时，索引下标超出范围\n\n* 示例代码\n\n```python\n>>> a_list = [1, 2, 3]\n>>> print(a_list[4])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nIndexError: list index out of range\n```\n\n**错误分析**：`a_list` 的合法下标是 0, 1, 2 （或者 -1, -2, -3），4 超出下标范围\n\n* 示例代码\n\n```python\n>>> a_tuple = (1, 2, 3)\n>>> print(a_tuple[4])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nIndexError: tuple index out of range\n```\n\n**错误分析**：`a_tuple` 的合法下标是 0, 1, 2 （或者 -1, -2, -3），4 超出下标范围',KeyError:'#### 什么是 `KeyError` ?\n\n使用不存在的键访问字典中的元素\n\n* 示例代码\n\n```python\n>>> student = {"name": "Allen", "age": 16}\n>>> print(student["major"])\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nKeyError: \'major\'\n```\n\n**错误分析**：`"major"` 不是 `student`  中的键（key）',ModuleNotFoundError:"#### 什么是 `ModuleNotFoundError` ?\n\n导入未安装的第三方库\n\n* 示例代码\n\n```python\n>>> import pandas\nTraceback (most recent call last):\n  File \"<stdin>\", line 1, in <module>\nModuleNotFoundError: No module named 'pandas'\n```\n\n**错误分析**：尝试导入 `pandas` ，但实际上未安装这个库，需要先完成安装才能使用",ValueError:'#### 什么是 `ValueError` ?\n\n类型正确但是值不合适\n\n* 示例代码\n\n```python\n>>> import math\n>>> math.log(-1)\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: math domain error\n```\n\n**错误分析**：对于取对数函数 `log`，传入 `-1`，参数类型正确，但是不合法，因为参数需要是正数\n\n* 示例代码\n\n```python\n>>> int("123")\n123\n>>> int("123.0")\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: invalid literal for int() with base 10: \'123.0\'\n```\n\n**错误分析**：`int` 函数用于将字符串转换为整数，传入 `"123"` 可以完成转换，但传入 `"123.0"` 无法完成转换',ZeroDivisionError:'#### 什么是 `ZeroDivisionError` ?\n\n除数为 0\n\n* 示例代码\n\n```python\n>>> print(1 / 0)\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nZeroDivisionError: division by zero\n```\n\n**错误分析**：除法运算的除数不能为 0',FileNotFoundError:'##### 什么是 `FileNotFoundError` ?\n\n访问不存在的文件或目录\n\n* 示例代码\n\n```python\n>>> file = open("a.txt")\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileNotFoundError: [Errno 2] No such file or directory: \'a.txt\'\n```\n\n**错误分析**：当前目录下不存在文件 a.txt\n\n* 示例代码\n\n```python\n>>> import os\n>>> print(os.listdir("."))  # 列出当前目录的全部文件和目录\n[]\n>>> print(os.listdir("./tmp"))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileNotFoundError: [Errno 2] No such file or directory: \'./tmp\'\n```\n\n**错误分析**：尝试列出 ./tmp（即当前目录下的 tmp 目录）中的全部文件和目录，然而当前目录下并不存在 tmp 目录',FileExistsError:'#### 什么是 `FileExistsError` ?\n\n文件或目录已存在\n\n* 示例代码\n\n```python\n>>> import os\n>>> print(os.listdir("."))\n[]\n>>> os.mkdir("./tmp")  # 在当前目录下创建tmp目录\n>>> print(os.listdir("."))\n[\'tmp\']\n>>> os.mkdir("./tmp")  # 再次创建tmp目录\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nFileExistsError: [Errno 17] File exists: \'./tmp\'\n```\n\n**错误分析**：在 ./tmp 目录存在的情况下，尝试创建 ./tmp 目录'},t.extractErrorMessage=function(e){if("error"!==e.output_type)throw Error("output must be error");return e.ename&&t.ERROR_INFO_MAP[e.ename]?{type:e.ename,explain:t.ERROR_INFO_MAP[e.ename]}:null}},419:function(e,t,n){"use strict";var r=this&&this.__createBinding||(Object.create?function(e,t,n,r){void 0===r&&(r=n),Object.defineProperty(e,r,{enumerable:!0,get:function(){return t[n]}})}:function(e,t,n,r){void 0===r&&(r=n),e[r]=t[n]}),o=this&&this.__exportStar||function(e,t){for(var n in e)"default"===n||t.hasOwnProperty(n)||r(t,e,n)};Object.defineProperty(t,"__esModule",{value:!0}),o(n(498),t),o(n(830),t),o(n(393),t),o(n(549),t);var i=n(781);Object.defineProperty(t,"download",{enumerable:!0,get:function(){return i.default}})},970:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseOJProblemIdsFromVerify=t.fixOverwrittenChars=t.autoLinkUrls=t.ansispan=void 0;var n=["ansi-black","ansi-red","ansi-green","ansi-yellow","ansi-blue","ansi-magenta","ansi-cyan","ansi-white","ansi-black-intense","ansi-red-intense","ansi-green-intense","ansi-yellow-intense","ansi-blue-intense","ansi-magenta-intense","ansi-cyan-intense","ansi-white-intense"];function r(e,t,r,o,i,a,l,c){var u;if(e){if(c)return void l.push(e);var s=[],f=[];o&&"number"==typeof t&&0<=t&&t<8&&(t+=8),a&&(t=(u=[r,t])[0],r=u[1]),"number"==typeof t?s.push(n[t]+"-fg"):t.length?f.push("color: rgb("+t+")"):a&&s.push("ansi-default-inverse-fg"),"number"==typeof r?s.push(n[r]+"-bg"):r.length?f.push("background-color: rgb("+r+")"):a&&s.push("ansi-default-inverse-bg"),o&&s.push("ansi-bold"),i&&s.push("ansi-underline"),s.length||f.length?(l.push("<span"),s.length&&l.push(' class="'+s.join(" ")+'"'),f.length&&l.push(' style="'+f.join("; ")+'"'),l.push(">"),l.push(e),l.push("</span>")):l.push(e)}}function o(e){var t,n,r,o=e.shift();if(2===o&&e.length>=3){if([t=e.shift(),n=e.shift(),r=e.shift()].some((function(e){return e<0||255<e})))throw new RangeError("Invalid range for RGB colors")}else{if(!(5===o&&e.length>=1))throw new RangeError("Invalid extended color specification");var i=e.shift();if(i<0)throw new RangeError("Color index must be >= 0");if(i<16)return i;if(i<232)t=(t=Math.floor((i-16)/36))>0?55+40*t:0,n=(n=Math.floor((i-16)%36/6))>0?55+40*n:0,r=(r=(i-16)%6)>0?55+40*r:0;else{if(!(i<256))throw new RangeError("Color index must be < 256");t=n=r=10*(i-232)+8}}return[t,n,r]}t.ansispan=function(e,t){void 0===t&&(t=!1);var n,i=/\x1b\[(.*?)([@-~])/g,a=[],l=[],c=!1,u=!1,s=!1,f=[],p=[],d=0;for(e+="[m";n=i.exec(e);){if("m"===n[2])for(var h=n[1].split(";"),v=0;v<h.length;v++){var g=h[v];if(""===g)p.push(0);else{if(-1===g.search(/^\d+$/)){p.length=0;break}p.push(parseInt(g))}}for(r(e.substring(d,n.index),a,l,c,u,s,f,t),d=i.lastIndex;p.length;){var y=p.shift();switch(y){case 0:a=l=[],c=!1,u=!1,s=!1;break;case 1:case 5:c=!0;break;case 4:u=!0;break;case 7:s=!0;break;case 21:case 22:c=!1;break;case 24:u=!1;break;case 27:s=!1;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:a=y-30;break;case 38:try{a=o(p)}catch(e){p.length=0}break;case 39:a=[];break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:l=y-40;break;case 48:try{l=o(p)}catch(e){p.length=0}break;case 49:l=[];break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:a=y-90+8;break;case 100:case 101:case 102:case 103:case 104:case 105:case 106:case 107:l=y-100+8}}}return f.join("")},t.autoLinkUrls=function(e){return e.replace(/(^|\s)(https?|ftp)(:[^'"<>\s]+)/gi,'$1<a target="_blank" href="$2$3">$2$3</a>')},t.fixOverwrittenChars=function(e){return function(e){for(e=e.replace(/\r+\n/gm,"\n");e.search(/\r[^$]/g)>-1;){var t=e.match(/^(.*)\r+/m)[1],n=e.match(/\r+(.*)$/m)[1];n+=t.slice(n.length,t.length),e=e.replace(/\r+.*$/m,"\r").replace(/^.*\r/m,n)}return e}(function(e){var t=e;do{t=(e=t).replace(/[^\n]\x08/gm,"")}while(t.length<e.length);return e}(e))},t.parseOJProblemIdsFromVerify=function(e){var t=/ONLINE_JUDGE_PROBLEM_ID=([^;]*)/.exec(e),n=/ONLINE_JUDGE_PROBLEM_REAL_ID=([^;]*)/.exec(e);return!t&&!n||!(null==t?void 0:t[1])&&!(null==n?void 0:n[1])?[void 0,void 0]:[null==t?void 0:t[1],null==n?void 0:n[1]]}},498:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.codeCellStringify=t.parseCodeCell=void 0,t.parseCodeCell=function(e){var t="string"==typeof e?e:e.join("");return t=t.replace(/^\/\/\s?platform-/g,"# platform-"),/^#\s?platform-edit-answer.*\n/.test(t)?{type:"edit-answer",code:t.replace(/^#\s?platform-edit-answer.*\n{1,2}/,"")}:/^#\s?platform-edit.*\n/.test(t)?{type:"edit",code:t.replace(/^#\s?platform-edit.*\n{1,2}/,"")}:/^#\s?platform-lock-hidden.*\n/.test(t)?{type:"lock-hidden",code:t.replace(/^#\s?platform-lock-hidden.*\n{1,2}/,"")}:/^#\s?platform-lock.*\n/.test(t)?{type:"lock",code:t.replace(/^#\s?platform-lock.*\n{1,2}/,"")}:/^#\s?platform-verify.*\n/.test(t)?{type:"verify",code:t.replace(/^#\s?platform-verify.*\n{1,2}/,"")}:/^#\s?platform-desc.*\n/.test(t)?{type:"desc",code:t.replace(/^#\s?platform-desc.*\n{1,2}/,"")}:/^#\s?platform-quiz.*\n/.test(t)?{type:"quiz",code:t.replace(/^#\s?platform-quiz.*\n{1,2}/,"")}:/^#\s?platform-blank-answer.*\n/.test(t)?{type:"blank-answer",code:t.replace(/^#\s?platform-blank-answer.*\n{1,2}/,"")}:/^#\s?platform-blank.*\n/.test(t)?{type:"blank",code:t.replace(/^#\s?platform-blank.*\n{1,2}/,"")}:{type:null,code:t}},t.codeCellStringify=function(e,t){void 0===t&&(t="#");var n=e.type,r=e.code;if(!n)return r;var o="";return"edit-answer"===n?o="platform-edit-answer":"edit"===n?o="platform-edit":"lock-hidden"===n?o="platform-lock-hidden":"lock"===n?o="platform-lock":"verify"===n?o="platform-verify":"desc"===n?o="platform-desc":"quiz"===n?o="platform-quiz":"blank-answer"===n?o="platform-blank-answer":"blank"===n&&(o="platform-blank"),t+" "+o+"\n\n"+r}},830:function(e,t,n){"use strict";var r,o=this&&this.__extends||(r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),i=this&&this.__assign||function(){return(i=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};Object.defineProperty(t,"__esModule",{value:!0}),t.trimOutputs=t.parseStepsFromCells=t.ParseJupyterCellException=void 0;var a=n(498),l=n(270),c=n(970),u=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.isParseJupyterCellError=!0,t}return o(t,e),t}(Error);function s(e,n,r,o,i,a){var u=t.trimOutputs(e),s={result:!1},p=!1,d=!1;if("v1"===r.version)if(r.codeCells.some((function(e){return e[n]&&e[n].some((function(t){var n;return(p="error"===t.output_type)&&(s.result=!1,s.text="代码执行出错",s.errorExplainInfo=l.extractErrorMessage(t),s.errorMessage=c.ansispan(null===(n=t.traceback)||void 0===n?void 0:n.join("\n"),!0)),"verify"===e.$codeType&&(d=!0),p}))})),s.hasError=p,s.verifyCellError=d,!i&&o)s.result=!1;else if(!p)if(a&&a.outputs.length)try{var h=JSON.parse(a.outputs[a.outputs.length-1].text);s.result=h.result,s.text=h.displayResult}catch(e){try{var v=a.outputs[a.outputs.length-1].text.trim().split("\n");h=JSON.parse(v[v.length-1]),s.result=h.result,s.text=h.displayResult}catch(e){s.result=!1,s.text="验证函数执行出错"}}else if(r.verify){s.verifyType="verify",s.output=u.join("");var g=/ONLINE_JUDGE_RESULT=([^;]*)/.exec(s.output);if(g&&g[1]){var y=/ONLINE_JUDGE_SUBMISSION_ID=([^;]*)/.exec(s.output);y&&(s.submissionId=y[1]);var m=/ONLINE_JUDGE_STATUS=([^;]*)/.exec(s.output),x=m?m[1]:"WAITING";s.result="SUCCESS"===x;var b=/ONLINE_JUDGE_OUTPUTS=([^;]*)/.exec(s.output);b&&b[1]&&(s.ojOutputs=JSON.parse(b[1])),s.output=Number(g[1]),s.isOnlineJudge=!0}else{var _=t.trimOutputs([r.verify]).join("");s.result=f(s.output,_)}}else s.verifyType="empty",s.output=null==u?void 0:u.join(""),s.result=(null==u?void 0:u.length)>0;return s}t.ParseJupyterCellException=u,t.parseStepsFromCells=function(e,n,r){var o=[],l=-1,c=-1;e.cells.map((function(e){var t;return Array.isArray(e.source)?i(i({},e),{source:null===(t=null==e?void 0:e.source)||void 0===t?void 0:t.join("")}):e})).map((function(e){if(e.outputs){var t=e.outputs.map((function(e){return i(i({},e),{text:Array.isArray(e.text)?e.text.join(""):e.text})}));return i(i({},e),{outputs:t})}return e})).forEach((function(e,t){if("markdown"===e.cell_type&&/^###[^#]+/.test(e.source)){l++;var n=e.metadata;o[l]={version:"v1",metadata:n,$index:l,title:e.source.replace(/###\s*/,""),codeCells:[],codeAnswerCells:[],mdCells:[],descCodeCells:[]}}else if(-1!==l){var r=o[l];if(!r)throw new u("未知错误："+l+"的步骤不存在");if("v1"===r.version)if("markdown"===e.cell_type)r.mdCells.push(i(i({},e),{$cellIndex:t}));else if("code"===e.cell_type){var s=a.parseCodeCell(e.source),f=s.type,p=s.code;if(!f){var d=new u("错误的code cell格式");throw d.cellIndex=t,d}if("desc"===f)r.descCodeCells.push(i(i({},e),{$codeType:f,$code:p,$cellIndex:t}));else if("quiz"===f)r.quizCell=i(i({},e),{$codeType:f,$code:p,$cellIndex:t}),e.metadata.quizLog&&(r.quizLog=e.metadata.quizLog);else if("edit-answer"===f||"blank-answer"===f)r.codeAnswerCells.push(i(i({},e),{$codeType:f,$code:p,$cellIndex:t}));else{var h=i(i({},e),{$codeType:f,$code:p,$cellIndex:t,$codeIndex:"verify"===f?-1:++c});e.metadata.inputs&&(h.$inputs=e.metadata.inputs),r.codeCells.push(h)}}}})),(o=o.map((function(e){if("v1"===e.version){var t=e.codeCells.length&&e.codeCells[0].$cellIndex||0,n=e.codeCells.length&&e.codeCells[e.codeCells.length-1].$cellIndex||0,r=e.mdCells[0]?e.mdCells[0].source:"",o="",a=e.descCodeCells.find((function(e){return e.$code&&e.$code.indexOf("Player")>=0}));if(a){var l=/vid='(\w*)'/.exec(a.$code);l&&(o=l[1])}var c=e.mdCells.filter((function(e){return e.$cellIndex>t&&e.$cellIndex<n})),u=e.mdCells.find((function(e){return e.$cellIndex>n})),s=(null==u?void 0:u.source)||"";return i(i({},e),{desc:r,video:o,mdCells:c,verify:s,isOnlineJudge:/ONLINE_JUDGE_PROBLEM_ID=([^;]*)/.test(s)||/ONLINE_JUDGE_PROBLEM_REAL_ID=([^;]*)/.test(s)})}return e}))).forEach((function(e){if("v1"===e.version){var t;if(e.codeAnswerCells.length>e.codeCells.length)throw(t=new u("参考答案数量不能多于代码框数量")).stepIndex=e.$index,t;if(e.quizCell&&e.codeCells.length)throw(t=new u("步骤中不能同时包含quiz和代码")).stepIndex=e.$index,t;if(!e.quizCell&&!e.codeCells.length)throw(t=new u("步骤中需要包含quiz或代码")).stepIndex=e.$index,t;if(!e.title.length)throw(t=new u("步骤标题必须指定")).stepIndex=e.$index,t}}));var f=!1;if(!(o=o.map((function(e,o){var a,l,c,u;if("v1"===e.version){var p=e.codeCells.filter((function(e){return"verify"!==e.$codeType})),d=e.codeCells.find((function(e){return"verify"===e.$codeType})),h=null===(l=null===(a=p[p.length-1])||void 0===a?void 0:a.outputs)||void 0===l?void 0:l.filter((function(e){return"stdout"===e.name&&null!=e.text})).map((function(e){return e.text})),v=null===(u=null===(c=p[p.length-1])||void 0===c?void 0:c.$dryrunOutputs)||void 0===u?void 0:u.filter((function(e){return"stdout"===e.name&&null!=e.text})).map((function(e){return e.text})),g=s(h,"outputs",e,f,n,d),y=null==r?void 0:r[o],m=s(v||[],"$dryrunOutputs",i(i({},e),{verify:t.trimOutputs([null==y?void 0:y.dryrunOutput]).join("")}),!1);return e.quizCell&&e.quizLog&&e.quizLog.content&&(g.result=!0,g.verifyType="quiz"),e.quizCell||g.result||(f=!0),i(i({},e),{normalCodes:p,verifyCode:d,verifyResult:g,$dryrunVerifyResult:m,stepType:e.quizCell?"quiz":"code"})}return e}))).length)throw new u("至少需要包含一个步骤");return o},t.trimOutputs=function(e){if(!Array.isArray(e)||0===(null==e?void 0:e.length))return[];var t=e.filter((function(e){return"string"==typeof e})).join("").split("\n");if(!t.length)return[];String.prototype.trimEnd||(String.prototype.trimEnd=function(){return this.replace(new RegExp(/[\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF]+/.source+"$","g"),"")});var n=t.reverse().findIndex((function(e){return e&&e.trimEnd()})),r=t.slice(n).reverse();return r.map((function(e,t){return t===r.length-1?e.trimEnd():e.trimEnd()+"\n"}))};var f=function(e,t){return!(!e||!t)&&e===t}},966:function(e,t,n){"use strict";var r,o=this&&this.__extends||(r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),i=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.parseQuizOptionSlots=t.markQuizOptionSlots=t.RelParseError=t.getQuizAnswersFromCell=t.getCodeFromCell=t.getMaterials=void 0;var a=i(n(59)),l=n(498),c=n(830);t.getMaterials=function(e){var t={};return e.cells.forEach((function(e){var n=e.metadata.bxyPosterSlotId;n&&(t[n]=e)})),c.parseStepsFromCells(e).forEach((function(e){var n,r,o=null===(r=null===(n=e.quizCell)||void 0===n?void 0:n.metadata.bxyQuizStep)||void 0===r?void 0:r.options;o&&Object.values(o).forEach((function(n){n.posterSlotId&&(t[n.posterSlotId]=e.quizCell)}))})),t},t.getCodeFromCell=function(e){return e&&e.source?l.parseCodeCell(e.source).code.split("\n").filter((function(e){return e.indexOf("!blank-answer:")<0})).join("\n").trim():""},t.getQuizAnswersFromCell=function(e,t){var n;if(!e||!e.metadata.quizLog||!e.metadata.quizLog.content)return[];var r,o=null===(n=e.metadata.bxyQuizStep)||void 0===n?void 0:n.options;return o?(Object.entries(o).forEach((function(e){var n=e[0];e[1].posterSlotId===t&&(r=n)})),r?e.metadata.quizLog.content[r]:[]):[]};var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(Error);t.RelParseError=u,t.markQuizOptionSlots=function(e,t){for(var n={},r=0,o=t.replaceAll("，",",").split(",").map((function(e){return e.trim()})).filter(Boolean);r<o.length;r++){var i=o[r],l=i.indexOf(":");if(l<=0||l>=i.length-1)throw new u("格式错误："+i);var c=i.slice(0,l).trim(),s=i.slice(l+1).trim();n[c]=s}var f=a.default.cloneDeep(e);return f.bxyQuizStep||(f.bxyQuizStep={options:{}}),f.bxyQuizStep.options||(f.bxyQuizStep.options={}),Object.values(f.bxyQuizStep.options).forEach((function(e){delete e.posterSlotId})),Object.entries(n).forEach((function(e){var t=e[0],n=e[1];f.bxyQuizStep.options[t]||(f.bxyQuizStep.options[t]={}),f.bxyQuizStep.options[t].posterSlotId=n})),f},t.parseQuizOptionSlots=function(e){var t,n="";return(null===(t=e.bxyQuizStep)||void 0===t?void 0:t.options)&&Object.entries(e.bxyQuizStep.options).forEach((function(e){var t=e[0],r=e[1];r.posterSlotId&&(n+=t+":"+r.posterSlotId+", ")})),n.endsWith(", ")&&(n=n.slice(0,n.length-2)),n}},471:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseQuestionOptions=void 0,t.parseQuestionOptions=function(e){var t=[];return e?(Object.entries(e).forEach((function(e){var n=e[0],r=e[1];n.startsWith("option")&&"string"==typeof r&&t.push({value:n.charAt(n.length-1),text:r})})),t):t}},393:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},549:function(e,t){"use strict";var n,r=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var t;e.done?o(e.value):(t=e.value,t instanceof n?t:new n((function(e){e(t)}))).then(a,l)}c((r=r.apply(e,t||[])).next())}))},o=this&&this.__generator||function(e,t){var n,r,o,i,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return i={next:l(0),throw:l(1),return:l(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function l(i){return function(l){return function(i){if(n)throw new TypeError("Generator is already executing.");for(;a;)try{if(n=1,r&&(o=2&i[0]?r.return:i[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,i[1])).done)return o;switch(r=0,o&&(i=[2&i[0],o.value]),i[0]){case 0:case 1:o=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,r=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!((o=(o=a.trys).length>0&&o[o.length-1])||6!==i[0]&&2!==i[0])){a=0;continue}if(3===i[0]&&(!o||i[1]>o[0]&&i[1]<o[3])){a.label=i[1];break}if(6===i[0]&&a.label<o[1]){a.label=o[1],o=i;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(i);break}o[2]&&a.ops.pop(),a.trys.pop();continue}i=t.call(e,a)}catch(e){i=[6,e],r=0}finally{n=o=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,l])}}};Object.defineProperty(t,"__esModule",{value:!0}),t.validateStepPoints=void 0,function(e){e.FILL="FILL",e.SELECT="SELECT"}(n||(n={})),t.validateStepPoints=function(e){return e.steps,e.quizParser,r(this,void 0,void 0,(function(){return o(this,(function(e){return[2,{passed:!0}]}))}))}},352:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n=function(e,t){var n,r,o,i=e[1]||"",a=e[3];if(!a)return i;if(t&&"function"==typeof btoa){var l=(n=a,r=btoa(unescape(encodeURIComponent(JSON.stringify(n)))),o="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(r),"/*# ".concat(o," */")),c=a.sources.map((function(e){return"/*# sourceURL=".concat(a.sourceRoot||"").concat(e," */")}));return[i].concat(c).concat([l]).join("\n")}return[i].join("\n")}(t,e);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n})).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var o={};if(r)for(var i=0;i<this.length;i++){var a=this[i][0];null!=a&&(o[a]=!0)}for(var l=0;l<e.length;l++){var c=[].concat(e[l]);r&&o[c[0]]||(n&&(c[2]?c[2]="".concat(n," and ").concat(c[2]):c[2]=n),t.push(c))}},t}},59:function(e,t,n){var r;e=n.nmd(e),function(){var o,i="Expected a function",a="__lodash_hash_undefined__",l="__lodash_placeholder__",c=32,u=128,s=1/0,f=9007199254740991,p=NaN,d=4294967295,h=[["ary",u],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",c],["partialRight",64],["rearg",256]],v="[object Arguments]",g="[object Array]",y="[object Boolean]",m="[object Date]",x="[object Error]",b="[object Function]",_="[object GeneratorFunction]",w="[object Map]",k="[object Number]",C="[object Object]",A="[object Promise]",M="[object RegExp]",z="[object Set]",L="[object String]",S="[object Symbol]",I="[object WeakMap]",P="[object ArrayBuffer]",E="[object DataView]",O="[object Float32Array]",B="[object Float64Array]",j="[object Int8Array]",T="[object Int16Array]",R="[object Int32Array]",N="[object Uint8Array]",W="[object Uint8ClampedArray]",D="[object Uint16Array]",U="[object Uint32Array]",F=/\b__p \+= '';/g,Q=/\b(__p \+=) '' \+/g,q=/(__e\(.*?\)|\b__t\)) \+\n'';/g,$=/&(?:amp|lt|gt|quot|#39);/g,H=/[&<>"']/g,V=RegExp($.source),G=RegExp(H.source),J=/<%-([\s\S]+?)%>/g,Z=/<%([\s\S]+?)%>/g,K=/<%=([\s\S]+?)%>/g,Y=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,X=/^\w*$/,ee=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,te=/[\\^$.*+?()[\]{}|]/g,ne=RegExp(te.source),re=/^\s+/,oe=/\s/,ie=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,ae=/\{\n\/\* \[wrapped with (.+)\] \*/,le=/,? & /,ce=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ue=/[()=,{}\[\]\/\s]/,se=/\\(\\)?/g,fe=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,pe=/\w*$/,de=/^[-+]0x[0-9a-f]+$/i,he=/^0b[01]+$/i,ve=/^\[object .+?Constructor\]$/,ge=/^0o[0-7]+$/i,ye=/^(?:0|[1-9]\d*)$/,me=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,xe=/($^)/,be=/['\n\r\u2028\u2029\\]/g,_e="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",we="a-z\\xdf-\\xf6\\xf8-\\xff",ke="A-Z\\xc0-\\xd6\\xd8-\\xde",Ce="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",Ae="["+Ce+"]",Me="["+_e+"]",ze="\\d+",Le="["+we+"]",Se="[^\\ud800-\\udfff"+Ce+ze+"\\u2700-\\u27bf"+we+ke+"]",Ie="\\ud83c[\\udffb-\\udfff]",Pe="[^\\ud800-\\udfff]",Ee="(?:\\ud83c[\\udde6-\\uddff]){2}",Oe="[\\ud800-\\udbff][\\udc00-\\udfff]",Be="["+ke+"]",je="(?:"+Le+"|"+Se+")",Te="(?:"+Be+"|"+Se+")",Re="(?:['’](?:d|ll|m|re|s|t|ve))?",Ne="(?:['’](?:D|LL|M|RE|S|T|VE))?",We="(?:"+Me+"|"+Ie+")?",De="[\\ufe0e\\ufe0f]?",Ue=De+We+"(?:\\u200d(?:"+[Pe,Ee,Oe].join("|")+")"+De+We+")*",Fe="(?:"+["[\\u2700-\\u27bf]",Ee,Oe].join("|")+")"+Ue,Qe="(?:"+[Pe+Me+"?",Me,Ee,Oe,"[\\ud800-\\udfff]"].join("|")+")",qe=RegExp("['’]","g"),$e=RegExp(Me,"g"),He=RegExp(Ie+"(?="+Ie+")|"+Qe+Ue,"g"),Ve=RegExp([Be+"?"+Le+"+"+Re+"(?="+[Ae,Be,"$"].join("|")+")",Te+"+"+Ne+"(?="+[Ae,Be+je,"$"].join("|")+")",Be+"?"+je+"+"+Re,Be+"+"+Ne,"\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",ze,Fe].join("|"),"g"),Ge=RegExp("[\\u200d\\ud800-\\udfff"+_e+"\\ufe0e\\ufe0f]"),Je=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Ze=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Ke=-1,Ye={};Ye[O]=Ye[B]=Ye[j]=Ye[T]=Ye[R]=Ye[N]=Ye[W]=Ye[D]=Ye[U]=!0,Ye[v]=Ye[g]=Ye[P]=Ye[y]=Ye[E]=Ye[m]=Ye[x]=Ye[b]=Ye[w]=Ye[k]=Ye[C]=Ye[M]=Ye[z]=Ye[L]=Ye[I]=!1;var Xe={};Xe[v]=Xe[g]=Xe[P]=Xe[E]=Xe[y]=Xe[m]=Xe[O]=Xe[B]=Xe[j]=Xe[T]=Xe[R]=Xe[w]=Xe[k]=Xe[C]=Xe[M]=Xe[z]=Xe[L]=Xe[S]=Xe[N]=Xe[W]=Xe[D]=Xe[U]=!0,Xe[x]=Xe[b]=Xe[I]=!1;var et={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},tt=parseFloat,nt=parseInt,rt="object"==typeof n.g&&n.g&&n.g.Object===Object&&n.g,ot="object"==typeof self&&self&&self.Object===Object&&self,it=rt||ot||Function("return this")(),at=t&&!t.nodeType&&t,lt=at&&e&&!e.nodeType&&e,ct=lt&&lt.exports===at,ut=ct&&rt.process,st=function(){try{return lt&&lt.require&&lt.require("util").types||ut&&ut.binding&&ut.binding("util")}catch(e){}}(),ft=st&&st.isArrayBuffer,pt=st&&st.isDate,dt=st&&st.isMap,ht=st&&st.isRegExp,vt=st&&st.isSet,gt=st&&st.isTypedArray;function yt(e,t,n){switch(n.length){case 0:return e.call(t);case 1:return e.call(t,n[0]);case 2:return e.call(t,n[0],n[1]);case 3:return e.call(t,n[0],n[1],n[2])}return e.apply(t,n)}function mt(e,t,n,r){for(var o=-1,i=null==e?0:e.length;++o<i;){var a=e[o];t(r,a,n(a),e)}return r}function xt(e,t){for(var n=-1,r=null==e?0:e.length;++n<r&&!1!==t(e[n],n,e););return e}function bt(e,t){for(var n=null==e?0:e.length;n--&&!1!==t(e[n],n,e););return e}function _t(e,t){for(var n=-1,r=null==e?0:e.length;++n<r;)if(!t(e[n],n,e))return!1;return!0}function wt(e,t){for(var n=-1,r=null==e?0:e.length,o=0,i=[];++n<r;){var a=e[n];t(a,n,e)&&(i[o++]=a)}return i}function kt(e,t){return!(null==e||!e.length)&&Ot(e,t,0)>-1}function Ct(e,t,n){for(var r=-1,o=null==e?0:e.length;++r<o;)if(n(t,e[r]))return!0;return!1}function At(e,t){for(var n=-1,r=null==e?0:e.length,o=Array(r);++n<r;)o[n]=t(e[n],n,e);return o}function Mt(e,t){for(var n=-1,r=t.length,o=e.length;++n<r;)e[o+n]=t[n];return e}function zt(e,t,n,r){var o=-1,i=null==e?0:e.length;for(r&&i&&(n=e[++o]);++o<i;)n=t(n,e[o],o,e);return n}function Lt(e,t,n,r){var o=null==e?0:e.length;for(r&&o&&(n=e[--o]);o--;)n=t(n,e[o],o,e);return n}function St(e,t){for(var n=-1,r=null==e?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}var It=Rt("length");function Pt(e,t,n){var r;return n(e,(function(e,n,o){if(t(e,n,o))return r=n,!1})),r}function Et(e,t,n,r){for(var o=e.length,i=n+(r?1:-1);r?i--:++i<o;)if(t(e[i],i,e))return i;return-1}function Ot(e,t,n){return t==t?function(e,t,n){for(var r=n-1,o=e.length;++r<o;)if(e[r]===t)return r;return-1}(e,t,n):Et(e,jt,n)}function Bt(e,t,n,r){for(var o=n-1,i=e.length;++o<i;)if(r(e[o],t))return o;return-1}function jt(e){return e!=e}function Tt(e,t){var n=null==e?0:e.length;return n?Dt(e,t)/n:p}function Rt(e){return function(t){return null==t?o:t[e]}}function Nt(e){return function(t){return null==e?o:e[t]}}function Wt(e,t,n,r,o){return o(e,(function(e,o,i){n=r?(r=!1,e):t(n,e,o,i)})),n}function Dt(e,t){for(var n,r=-1,i=e.length;++r<i;){var a=t(e[r]);a!==o&&(n=n===o?a:n+a)}return n}function Ut(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}function Ft(e){return e?e.slice(0,ln(e)+1).replace(re,""):e}function Qt(e){return function(t){return e(t)}}function qt(e,t){return At(t,(function(t){return e[t]}))}function $t(e,t){return e.has(t)}function Ht(e,t){for(var n=-1,r=e.length;++n<r&&Ot(t,e[n],0)>-1;);return n}function Vt(e,t){for(var n=e.length;n--&&Ot(t,e[n],0)>-1;);return n}function Gt(e,t){for(var n=e.length,r=0;n--;)e[n]===t&&++r;return r}var Jt=Nt({À:"A",Á:"A",Â:"A",Ã:"A",Ä:"A",Å:"A",à:"a",á:"a",â:"a",ã:"a",ä:"a",å:"a",Ç:"C",ç:"c",Ð:"D",ð:"d",È:"E",É:"E",Ê:"E",Ë:"E",è:"e",é:"e",ê:"e",ë:"e",Ì:"I",Í:"I",Î:"I",Ï:"I",ì:"i",í:"i",î:"i",ï:"i",Ñ:"N",ñ:"n",Ò:"O",Ó:"O",Ô:"O",Õ:"O",Ö:"O",Ø:"O",ò:"o",ó:"o",ô:"o",õ:"o",ö:"o",ø:"o",Ù:"U",Ú:"U",Û:"U",Ü:"U",ù:"u",ú:"u",û:"u",ü:"u",Ý:"Y",ý:"y",ÿ:"y",Æ:"Ae",æ:"ae",Þ:"Th",þ:"th",ß:"ss",Ā:"A",Ă:"A",Ą:"A",ā:"a",ă:"a",ą:"a",Ć:"C",Ĉ:"C",Ċ:"C",Č:"C",ć:"c",ĉ:"c",ċ:"c",č:"c",Ď:"D",Đ:"D",ď:"d",đ:"d",Ē:"E",Ĕ:"E",Ė:"E",Ę:"E",Ě:"E",ē:"e",ĕ:"e",ė:"e",ę:"e",ě:"e",Ĝ:"G",Ğ:"G",Ġ:"G",Ģ:"G",ĝ:"g",ğ:"g",ġ:"g",ģ:"g",Ĥ:"H",Ħ:"H",ĥ:"h",ħ:"h",Ĩ:"I",Ī:"I",Ĭ:"I",Į:"I",İ:"I",ĩ:"i",ī:"i",ĭ:"i",į:"i",ı:"i",Ĵ:"J",ĵ:"j",Ķ:"K",ķ:"k",ĸ:"k",Ĺ:"L",Ļ:"L",Ľ:"L",Ŀ:"L",Ł:"L",ĺ:"l",ļ:"l",ľ:"l",ŀ:"l",ł:"l",Ń:"N",Ņ:"N",Ň:"N",Ŋ:"N",ń:"n",ņ:"n",ň:"n",ŋ:"n",Ō:"O",Ŏ:"O",Ő:"O",ō:"o",ŏ:"o",ő:"o",Ŕ:"R",Ŗ:"R",Ř:"R",ŕ:"r",ŗ:"r",ř:"r",Ś:"S",Ŝ:"S",Ş:"S",Š:"S",ś:"s",ŝ:"s",ş:"s",š:"s",Ţ:"T",Ť:"T",Ŧ:"T",ţ:"t",ť:"t",ŧ:"t",Ũ:"U",Ū:"U",Ŭ:"U",Ů:"U",Ű:"U",Ų:"U",ũ:"u",ū:"u",ŭ:"u",ů:"u",ű:"u",ų:"u",Ŵ:"W",ŵ:"w",Ŷ:"Y",ŷ:"y",Ÿ:"Y",Ź:"Z",Ż:"Z",Ž:"Z",ź:"z",ż:"z",ž:"z",Ĳ:"IJ",ĳ:"ij",Œ:"Oe",œ:"oe",ŉ:"'n",ſ:"s"}),Zt=Nt({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function Kt(e){return"\\"+et[e]}function Yt(e){return Ge.test(e)}function Xt(e){var t=-1,n=Array(e.size);return e.forEach((function(e,r){n[++t]=[r,e]})),n}function en(e,t){return function(n){return e(t(n))}}function tn(e,t){for(var n=-1,r=e.length,o=0,i=[];++n<r;){var a=e[n];a!==t&&a!==l||(e[n]=l,i[o++]=n)}return i}function nn(e){var t=-1,n=Array(e.size);return e.forEach((function(e){n[++t]=e})),n}function rn(e){var t=-1,n=Array(e.size);return e.forEach((function(e){n[++t]=[e,e]})),n}function on(e){return Yt(e)?function(e){for(var t=He.lastIndex=0;He.test(e);)++t;return t}(e):It(e)}function an(e){return Yt(e)?function(e){return e.match(He)||[]}(e):function(e){return e.split("")}(e)}function ln(e){for(var t=e.length;t--&&oe.test(e.charAt(t)););return t}var cn=Nt({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"}),un=function e(t){var n,r=(t=null==t?it:un.defaults(it.Object(),t,un.pick(it,Ze))).Array,oe=t.Date,_e=t.Error,we=t.Function,ke=t.Math,Ce=t.Object,Ae=t.RegExp,Me=t.String,ze=t.TypeError,Le=r.prototype,Se=we.prototype,Ie=Ce.prototype,Pe=t["__core-js_shared__"],Ee=Se.toString,Oe=Ie.hasOwnProperty,Be=0,je=(n=/[^.]+$/.exec(Pe&&Pe.keys&&Pe.keys.IE_PROTO||""))?"Symbol(src)_1."+n:"",Te=Ie.toString,Re=Ee.call(Ce),Ne=it._,We=Ae("^"+Ee.call(Oe).replace(te,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),De=ct?t.Buffer:o,Ue=t.Symbol,Fe=t.Uint8Array,Qe=De?De.allocUnsafe:o,He=en(Ce.getPrototypeOf,Ce),Ge=Ce.create,et=Ie.propertyIsEnumerable,rt=Le.splice,ot=Ue?Ue.isConcatSpreadable:o,at=Ue?Ue.iterator:o,lt=Ue?Ue.toStringTag:o,ut=function(){try{var e=si(Ce,"defineProperty");return e({},"",{}),e}catch(e){}}(),st=t.clearTimeout!==it.clearTimeout&&t.clearTimeout,It=oe&&oe.now!==it.Date.now&&oe.now,Nt=t.setTimeout!==it.setTimeout&&t.setTimeout,sn=ke.ceil,fn=ke.floor,pn=Ce.getOwnPropertySymbols,dn=De?De.isBuffer:o,hn=t.isFinite,vn=Le.join,gn=en(Ce.keys,Ce),yn=ke.max,mn=ke.min,xn=oe.now,bn=t.parseInt,_n=ke.random,wn=Le.reverse,kn=si(t,"DataView"),Cn=si(t,"Map"),An=si(t,"Promise"),Mn=si(t,"Set"),zn=si(t,"WeakMap"),Ln=si(Ce,"create"),Sn=zn&&new zn,In={},Pn=Wi(kn),En=Wi(Cn),On=Wi(An),Bn=Wi(Mn),jn=Wi(zn),Tn=Ue?Ue.prototype:o,Rn=Tn?Tn.valueOf:o,Nn=Tn?Tn.toString:o;function Wn(e){if(nl(e)&&!$a(e)&&!(e instanceof Qn)){if(e instanceof Fn)return e;if(Oe.call(e,"__wrapped__"))return Di(e)}return new Fn(e)}var Dn=function(){function e(){}return function(t){if(!tl(t))return{};if(Ge)return Ge(t);e.prototype=t;var n=new e;return e.prototype=o,n}}();function Un(){}function Fn(e,t){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!t,this.__index__=0,this.__values__=o}function Qn(e){this.__wrapped__=e,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=d,this.__views__=[]}function qn(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function $n(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function Hn(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function Vn(e){var t=-1,n=null==e?0:e.length;for(this.__data__=new Hn;++t<n;)this.add(e[t])}function Gn(e){var t=this.__data__=new $n(e);this.size=t.size}function Jn(e,t){var n=$a(e),r=!n&&qa(e),o=!n&&!r&&Ja(e),i=!n&&!r&&!o&&sl(e),a=n||r||o||i,l=a?Ut(e.length,Me):[],c=l.length;for(var u in e)!t&&!Oe.call(e,u)||a&&("length"==u||o&&("offset"==u||"parent"==u)||i&&("buffer"==u||"byteLength"==u||"byteOffset"==u)||yi(u,c))||l.push(u);return l}function Zn(e){var t=e.length;return t?e[Hr(0,t-1)]:o}function Kn(e,t){return Bi(Lo(e),ar(t,0,e.length))}function Yn(e){return Bi(Lo(e))}function Xn(e,t,n){(n!==o&&!Ua(e[t],n)||n===o&&!(t in e))&&or(e,t,n)}function er(e,t,n){var r=e[t];Oe.call(e,t)&&Ua(r,n)&&(n!==o||t in e)||or(e,t,n)}function tr(e,t){for(var n=e.length;n--;)if(Ua(e[n][0],t))return n;return-1}function nr(e,t,n,r){return fr(e,(function(e,o,i){t(r,e,n(e),i)})),r}function rr(e,t){return e&&So(t,El(t),e)}function or(e,t,n){"__proto__"==t&&ut?ut(e,t,{configurable:!0,enumerable:!0,value:n,writable:!0}):e[t]=n}function ir(e,t){for(var n=-1,i=t.length,a=r(i),l=null==e;++n<i;)a[n]=l?o:zl(e,t[n]);return a}function ar(e,t,n){return e==e&&(n!==o&&(e=e<=n?e:n),t!==o&&(e=e>=t?e:t)),e}function lr(e,t,n,r,i,a){var l,c=1&t,u=2&t,s=4&t;if(n&&(l=i?n(e,r,i,a):n(e)),l!==o)return l;if(!tl(e))return e;var f=$a(e);if(f){if(l=function(e){var t=e.length,n=new e.constructor(t);return t&&"string"==typeof e[0]&&Oe.call(e,"index")&&(n.index=e.index,n.input=e.input),n}(e),!c)return Lo(e,l)}else{var p=di(e),d=p==b||p==_;if(Ja(e))return wo(e,c);if(p==C||p==v||d&&!i){if(l=u||d?{}:vi(e),!c)return u?function(e,t){return So(e,pi(e),t)}(e,function(e,t){return e&&So(t,Ol(t),e)}(l,e)):function(e,t){return So(e,fi(e),t)}(e,rr(l,e))}else{if(!Xe[p])return i?e:{};l=function(e,t,n){var r,o=e.constructor;switch(t){case P:return ko(e);case y:case m:return new o(+e);case E:return function(e,t){var n=t?ko(e.buffer):e.buffer;return new e.constructor(n,e.byteOffset,e.byteLength)}(e,n);case O:case B:case j:case T:case R:case N:case W:case D:case U:return Co(e,n);case w:return new o;case k:case L:return new o(e);case M:return function(e){var t=new e.constructor(e.source,pe.exec(e));return t.lastIndex=e.lastIndex,t}(e);case z:return new o;case S:return r=e,Rn?Ce(Rn.call(r)):{}}}(e,p,c)}}a||(a=new Gn);var h=a.get(e);if(h)return h;a.set(e,l),ll(e)?e.forEach((function(r){l.add(lr(r,t,n,r,e,a))})):rl(e)&&e.forEach((function(r,o){l.set(o,lr(r,t,n,o,e,a))}));var g=f?o:(s?u?ri:ni:u?Ol:El)(e);return xt(g||e,(function(r,o){g&&(r=e[o=r]),er(l,o,lr(r,t,n,o,e,a))})),l}function cr(e,t,n){var r=n.length;if(null==e)return!r;for(e=Ce(e);r--;){var i=n[r],a=t[i],l=e[i];if(l===o&&!(i in e)||!a(l))return!1}return!0}function ur(e,t,n){if("function"!=typeof e)throw new ze(i);return Ii((function(){e.apply(o,n)}),t)}function sr(e,t,n,r){var o=-1,i=kt,a=!0,l=e.length,c=[],u=t.length;if(!l)return c;n&&(t=At(t,Qt(n))),r?(i=Ct,a=!1):t.length>=200&&(i=$t,a=!1,t=new Vn(t));e:for(;++o<l;){var s=e[o],f=null==n?s:n(s);if(s=r||0!==s?s:0,a&&f==f){for(var p=u;p--;)if(t[p]===f)continue e;c.push(s)}else i(t,f,r)||c.push(s)}return c}Wn.templateSettings={escape:J,evaluate:Z,interpolate:K,variable:"",imports:{_:Wn}},Wn.prototype=Un.prototype,Wn.prototype.constructor=Wn,Fn.prototype=Dn(Un.prototype),Fn.prototype.constructor=Fn,Qn.prototype=Dn(Un.prototype),Qn.prototype.constructor=Qn,qn.prototype.clear=function(){this.__data__=Ln?Ln(null):{},this.size=0},qn.prototype.delete=function(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t},qn.prototype.get=function(e){var t=this.__data__;if(Ln){var n=t[e];return n===a?o:n}return Oe.call(t,e)?t[e]:o},qn.prototype.has=function(e){var t=this.__data__;return Ln?t[e]!==o:Oe.call(t,e)},qn.prototype.set=function(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=Ln&&t===o?a:t,this},$n.prototype.clear=function(){this.__data__=[],this.size=0},$n.prototype.delete=function(e){var t=this.__data__,n=tr(t,e);return!(n<0||(n==t.length-1?t.pop():rt.call(t,n,1),--this.size,0))},$n.prototype.get=function(e){var t=this.__data__,n=tr(t,e);return n<0?o:t[n][1]},$n.prototype.has=function(e){return tr(this.__data__,e)>-1},$n.prototype.set=function(e,t){var n=this.__data__,r=tr(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this},Hn.prototype.clear=function(){this.size=0,this.__data__={hash:new qn,map:new(Cn||$n),string:new qn}},Hn.prototype.delete=function(e){var t=ci(this,e).delete(e);return this.size-=t?1:0,t},Hn.prototype.get=function(e){return ci(this,e).get(e)},Hn.prototype.has=function(e){return ci(this,e).has(e)},Hn.prototype.set=function(e,t){var n=ci(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this},Vn.prototype.add=Vn.prototype.push=function(e){return this.__data__.set(e,a),this},Vn.prototype.has=function(e){return this.__data__.has(e)},Gn.prototype.clear=function(){this.__data__=new $n,this.size=0},Gn.prototype.delete=function(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n},Gn.prototype.get=function(e){return this.__data__.get(e)},Gn.prototype.has=function(e){return this.__data__.has(e)},Gn.prototype.set=function(e,t){var n=this.__data__;if(n instanceof $n){var r=n.__data__;if(!Cn||r.length<199)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new Hn(r)}return n.set(e,t),this.size=n.size,this};var fr=Eo(xr),pr=Eo(br,!0);function dr(e,t){var n=!0;return fr(e,(function(e,r,o){return n=!!t(e,r,o)})),n}function hr(e,t,n){for(var r=-1,i=e.length;++r<i;){var a=e[r],l=t(a);if(null!=l&&(c===o?l==l&&!ul(l):n(l,c)))var c=l,u=a}return u}function vr(e,t){var n=[];return fr(e,(function(e,r,o){t(e,r,o)&&n.push(e)})),n}function gr(e,t,n,r,o){var i=-1,a=e.length;for(n||(n=gi),o||(o=[]);++i<a;){var l=e[i];t>0&&n(l)?t>1?gr(l,t-1,n,r,o):Mt(o,l):r||(o[o.length]=l)}return o}var yr=Oo(),mr=Oo(!0);function xr(e,t){return e&&yr(e,t,El)}function br(e,t){return e&&mr(e,t,El)}function _r(e,t){return wt(t,(function(t){return Ya(e[t])}))}function wr(e,t){for(var n=0,r=(t=mo(t,e)).length;null!=e&&n<r;)e=e[Ni(t[n++])];return n&&n==r?e:o}function kr(e,t,n){var r=t(e);return $a(e)?r:Mt(r,n(e))}function Cr(e){return null==e?e===o?"[object Undefined]":"[object Null]":lt&&lt in Ce(e)?function(e){var t=Oe.call(e,lt),n=e[lt];try{e[lt]=o;var r=!0}catch(e){}var i=Te.call(e);return r&&(t?e[lt]=n:delete e[lt]),i}(e):function(e){return Te.call(e)}(e)}function Ar(e,t){return e>t}function Mr(e,t){return null!=e&&Oe.call(e,t)}function zr(e,t){return null!=e&&t in Ce(e)}function Lr(e,t,n){for(var i=n?Ct:kt,a=e[0].length,l=e.length,c=l,u=r(l),s=1/0,f=[];c--;){var p=e[c];c&&t&&(p=At(p,Qt(t))),s=mn(p.length,s),u[c]=!n&&(t||a>=120&&p.length>=120)?new Vn(c&&p):o}p=e[0];var d=-1,h=u[0];e:for(;++d<a&&f.length<s;){var v=p[d],g=t?t(v):v;if(v=n||0!==v?v:0,!(h?$t(h,g):i(f,g,n))){for(c=l;--c;){var y=u[c];if(!(y?$t(y,g):i(e[c],g,n)))continue e}h&&h.push(g),f.push(v)}}return f}function Sr(e,t,n){var r=null==(e=Mi(e,t=mo(t,e)))?e:e[Ni(Ki(t))];return null==r?o:yt(r,e,n)}function Ir(e){return nl(e)&&Cr(e)==v}function Pr(e,t,n,r,i){return e===t||(null==e||null==t||!nl(e)&&!nl(t)?e!=e&&t!=t:function(e,t,n,r,i,a){var l=$a(e),c=$a(t),u=l?g:di(e),s=c?g:di(t),f=(u=u==v?C:u)==C,p=(s=s==v?C:s)==C,d=u==s;if(d&&Ja(e)){if(!Ja(t))return!1;l=!0,f=!1}if(d&&!f)return a||(a=new Gn),l||sl(e)?ei(e,t,n,r,i,a):function(e,t,n,r,o,i,a){switch(n){case E:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case P:return!(e.byteLength!=t.byteLength||!i(new Fe(e),new Fe(t)));case y:case m:case k:return Ua(+e,+t);case x:return e.name==t.name&&e.message==t.message;case M:case L:return e==t+"";case w:var l=Xt;case z:var c=1&r;if(l||(l=nn),e.size!=t.size&&!c)return!1;var u=a.get(e);if(u)return u==t;r|=2,a.set(e,t);var s=ei(l(e),l(t),r,o,i,a);return a.delete(e),s;case S:if(Rn)return Rn.call(e)==Rn.call(t)}return!1}(e,t,u,n,r,i,a);if(!(1&n)){var h=f&&Oe.call(e,"__wrapped__"),b=p&&Oe.call(t,"__wrapped__");if(h||b){var _=h?e.value():e,A=b?t.value():t;return a||(a=new Gn),i(_,A,n,r,a)}}return!!d&&(a||(a=new Gn),function(e,t,n,r,i,a){var l=1&n,c=ni(e),u=c.length;if(u!=ni(t).length&&!l)return!1;for(var s=u;s--;){var f=c[s];if(!(l?f in t:Oe.call(t,f)))return!1}var p=a.get(e),d=a.get(t);if(p&&d)return p==t&&d==e;var h=!0;a.set(e,t),a.set(t,e);for(var v=l;++s<u;){var g=e[f=c[s]],y=t[f];if(r)var m=l?r(y,g,f,t,e,a):r(g,y,f,e,t,a);if(!(m===o?g===y||i(g,y,n,r,a):m)){h=!1;break}v||(v="constructor"==f)}if(h&&!v){var x=e.constructor,b=t.constructor;x==b||!("constructor"in e)||!("constructor"in t)||"function"==typeof x&&x instanceof x&&"function"==typeof b&&b instanceof b||(h=!1)}return a.delete(e),a.delete(t),h}(e,t,n,r,i,a))}(e,t,n,r,Pr,i))}function Er(e,t,n,r){var i=n.length,a=i,l=!r;if(null==e)return!a;for(e=Ce(e);i--;){var c=n[i];if(l&&c[2]?c[1]!==e[c[0]]:!(c[0]in e))return!1}for(;++i<a;){var u=(c=n[i])[0],s=e[u],f=c[1];if(l&&c[2]){if(s===o&&!(u in e))return!1}else{var p=new Gn;if(r)var d=r(s,f,u,e,t,p);if(!(d===o?Pr(f,s,3,r,p):d))return!1}}return!0}function Or(e){return!(!tl(e)||(t=e,je&&je in t))&&(Ya(e)?We:ve).test(Wi(e));var t}function Br(e){return"function"==typeof e?e:null==e?oc:"object"==typeof e?$a(e)?Wr(e[0],e[1]):Nr(e):dc(e)}function jr(e){if(!wi(e))return gn(e);var t=[];for(var n in Ce(e))Oe.call(e,n)&&"constructor"!=n&&t.push(n);return t}function Tr(e,t){return e<t}function Rr(e,t){var n=-1,o=Va(e)?r(e.length):[];return fr(e,(function(e,r,i){o[++n]=t(e,r,i)})),o}function Nr(e){var t=ui(e);return 1==t.length&&t[0][2]?Ci(t[0][0],t[0][1]):function(n){return n===e||Er(n,e,t)}}function Wr(e,t){return xi(e)&&ki(t)?Ci(Ni(e),t):function(n){var r=zl(n,e);return r===o&&r===t?Ll(n,e):Pr(t,r,3)}}function Dr(e,t,n,r,i){e!==t&&yr(t,(function(a,l){if(i||(i=new Gn),tl(a))!function(e,t,n,r,i,a,l){var c=Li(e,n),u=Li(t,n),s=l.get(u);if(s)Xn(e,n,s);else{var f=a?a(c,u,n+"",e,t,l):o,p=f===o;if(p){var d=$a(u),h=!d&&Ja(u),v=!d&&!h&&sl(u);f=u,d||h||v?$a(c)?f=c:Ga(c)?f=Lo(c):h?(p=!1,f=wo(u,!0)):v?(p=!1,f=Co(u,!0)):f=[]:il(u)||qa(u)?(f=c,qa(c)?f=ml(c):tl(c)&&!Ya(c)||(f=vi(u))):p=!1}p&&(l.set(u,f),i(f,u,r,a,l),l.delete(u)),Xn(e,n,f)}}(e,t,l,n,Dr,r,i);else{var c=r?r(Li(e,l),a,l+"",e,t,i):o;c===o&&(c=a),Xn(e,l,c)}}),Ol)}function Ur(e,t){var n=e.length;if(n)return yi(t+=t<0?n:0,n)?e[t]:o}function Fr(e,t,n){t=t.length?At(t,(function(e){return $a(e)?function(t){return wr(t,1===e.length?e[0]:e)}:e})):[oc];var r=-1;return t=At(t,Qt(li())),function(e,t){var r=e.length;for(e.sort((function(e,t){return function(e,t,n){for(var r=-1,o=e.criteria,i=t.criteria,a=o.length,l=n.length;++r<a;){var c=Ao(o[r],i[r]);if(c)return r>=l?c:c*("desc"==n[r]?-1:1)}return e.index-t.index}(e,t,n)}));r--;)e[r]=e[r].value;return e}(Rr(e,(function(e,n,o){return{criteria:At(t,(function(t){return t(e)})),index:++r,value:e}})))}function Qr(e,t,n){for(var r=-1,o=t.length,i={};++r<o;){var a=t[r],l=wr(e,a);n(l,a)&&Kr(i,mo(a,e),l)}return i}function qr(e,t,n,r){var o=r?Bt:Ot,i=-1,a=t.length,l=e;for(e===t&&(t=Lo(t)),n&&(l=At(e,Qt(n)));++i<a;)for(var c=0,u=t[i],s=n?n(u):u;(c=o(l,s,c,r))>-1;)l!==e&&rt.call(l,c,1),rt.call(e,c,1);return e}function $r(e,t){for(var n=e?t.length:0,r=n-1;n--;){var o=t[n];if(n==r||o!==i){var i=o;yi(o)?rt.call(e,o,1):uo(e,o)}}return e}function Hr(e,t){return e+fn(_n()*(t-e+1))}function Vr(e,t){var n="";if(!e||t<1||t>f)return n;do{t%2&&(n+=e),(t=fn(t/2))&&(e+=e)}while(t);return n}function Gr(e,t){return Pi(Ai(e,t,oc),e+"")}function Jr(e){return Zn(Ul(e))}function Zr(e,t){var n=Ul(e);return Bi(n,ar(t,0,n.length))}function Kr(e,t,n,r){if(!tl(e))return e;for(var i=-1,a=(t=mo(t,e)).length,l=a-1,c=e;null!=c&&++i<a;){var u=Ni(t[i]),s=n;if("__proto__"===u||"constructor"===u||"prototype"===u)return e;if(i!=l){var f=c[u];(s=r?r(f,u,c):o)===o&&(s=tl(f)?f:yi(t[i+1])?[]:{})}er(c,u,s),c=c[u]}return e}var Yr=Sn?function(e,t){return Sn.set(e,t),e}:oc,Xr=ut?function(e,t){return ut(e,"toString",{configurable:!0,enumerable:!1,value:tc(t),writable:!0})}:oc;function eo(e){return Bi(Ul(e))}function to(e,t,n){var o=-1,i=e.length;t<0&&(t=-t>i?0:i+t),(n=n>i?i:n)<0&&(n+=i),i=t>n?0:n-t>>>0,t>>>=0;for(var a=r(i);++o<i;)a[o]=e[o+t];return a}function no(e,t){var n;return fr(e,(function(e,r,o){return!(n=t(e,r,o))})),!!n}function ro(e,t,n){var r=0,o=null==e?r:e.length;if("number"==typeof t&&t==t&&o<=2147483647){for(;r<o;){var i=r+o>>>1,a=e[i];null!==a&&!ul(a)&&(n?a<=t:a<t)?r=i+1:o=i}return o}return oo(e,t,oc,n)}function oo(e,t,n,r){var i=0,a=null==e?0:e.length;if(0===a)return 0;for(var l=(t=n(t))!=t,c=null===t,u=ul(t),s=t===o;i<a;){var f=fn((i+a)/2),p=n(e[f]),d=p!==o,h=null===p,v=p==p,g=ul(p);if(l)var y=r||v;else y=s?v&&(r||d):c?v&&d&&(r||!h):u?v&&d&&!h&&(r||!g):!h&&!g&&(r?p<=t:p<t);y?i=f+1:a=f}return mn(a,4294967294)}function io(e,t){for(var n=-1,r=e.length,o=0,i=[];++n<r;){var a=e[n],l=t?t(a):a;if(!n||!Ua(l,c)){var c=l;i[o++]=0===a?0:a}}return i}function ao(e){return"number"==typeof e?e:ul(e)?p:+e}function lo(e){if("string"==typeof e)return e;if($a(e))return At(e,lo)+"";if(ul(e))return Nn?Nn.call(e):"";var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}function co(e,t,n){var r=-1,o=kt,i=e.length,a=!0,l=[],c=l;if(n)a=!1,o=Ct;else if(i>=200){var u=t?null:Go(e);if(u)return nn(u);a=!1,o=$t,c=new Vn}else c=t?[]:l;e:for(;++r<i;){var s=e[r],f=t?t(s):s;if(s=n||0!==s?s:0,a&&f==f){for(var p=c.length;p--;)if(c[p]===f)continue e;t&&c.push(f),l.push(s)}else o(c,f,n)||(c!==l&&c.push(f),l.push(s))}return l}function uo(e,t){return null==(e=Mi(e,t=mo(t,e)))||delete e[Ni(Ki(t))]}function so(e,t,n,r){return Kr(e,t,n(wr(e,t)),r)}function fo(e,t,n,r){for(var o=e.length,i=r?o:-1;(r?i--:++i<o)&&t(e[i],i,e););return n?to(e,r?0:i,r?i+1:o):to(e,r?i+1:0,r?o:i)}function po(e,t){var n=e;return n instanceof Qn&&(n=n.value()),zt(t,(function(e,t){return t.func.apply(t.thisArg,Mt([e],t.args))}),n)}function ho(e,t,n){var o=e.length;if(o<2)return o?co(e[0]):[];for(var i=-1,a=r(o);++i<o;)for(var l=e[i],c=-1;++c<o;)c!=i&&(a[i]=sr(a[i]||l,e[c],t,n));return co(gr(a,1),t,n)}function vo(e,t,n){for(var r=-1,i=e.length,a=t.length,l={};++r<i;){var c=r<a?t[r]:o;n(l,e[r],c)}return l}function go(e){return Ga(e)?e:[]}function yo(e){return"function"==typeof e?e:oc}function mo(e,t){return $a(e)?e:xi(e,t)?[e]:Ri(xl(e))}var xo=Gr;function bo(e,t,n){var r=e.length;return n=n===o?r:n,!t&&n>=r?e:to(e,t,n)}var _o=st||function(e){return it.clearTimeout(e)};function wo(e,t){if(t)return e.slice();var n=e.length,r=Qe?Qe(n):new e.constructor(n);return e.copy(r),r}function ko(e){var t=new e.constructor(e.byteLength);return new Fe(t).set(new Fe(e)),t}function Co(e,t){var n=t?ko(e.buffer):e.buffer;return new e.constructor(n,e.byteOffset,e.length)}function Ao(e,t){if(e!==t){var n=e!==o,r=null===e,i=e==e,a=ul(e),l=t!==o,c=null===t,u=t==t,s=ul(t);if(!c&&!s&&!a&&e>t||a&&l&&u&&!c&&!s||r&&l&&u||!n&&u||!i)return 1;if(!r&&!a&&!s&&e<t||s&&n&&i&&!r&&!a||c&&n&&i||!l&&i||!u)return-1}return 0}function Mo(e,t,n,o){for(var i=-1,a=e.length,l=n.length,c=-1,u=t.length,s=yn(a-l,0),f=r(u+s),p=!o;++c<u;)f[c]=t[c];for(;++i<l;)(p||i<a)&&(f[n[i]]=e[i]);for(;s--;)f[c++]=e[i++];return f}function zo(e,t,n,o){for(var i=-1,a=e.length,l=-1,c=n.length,u=-1,s=t.length,f=yn(a-c,0),p=r(f+s),d=!o;++i<f;)p[i]=e[i];for(var h=i;++u<s;)p[h+u]=t[u];for(;++l<c;)(d||i<a)&&(p[h+n[l]]=e[i++]);return p}function Lo(e,t){var n=-1,o=e.length;for(t||(t=r(o));++n<o;)t[n]=e[n];return t}function So(e,t,n,r){var i=!n;n||(n={});for(var a=-1,l=t.length;++a<l;){var c=t[a],u=r?r(n[c],e[c],c,n,e):o;u===o&&(u=e[c]),i?or(n,c,u):er(n,c,u)}return n}function Io(e,t){return function(n,r){var o=$a(n)?mt:nr,i=t?t():{};return o(n,e,li(r,2),i)}}function Po(e){return Gr((function(t,n){var r=-1,i=n.length,a=i>1?n[i-1]:o,l=i>2?n[2]:o;for(a=e.length>3&&"function"==typeof a?(i--,a):o,l&&mi(n[0],n[1],l)&&(a=i<3?o:a,i=1),t=Ce(t);++r<i;){var c=n[r];c&&e(t,c,r,a)}return t}))}function Eo(e,t){return function(n,r){if(null==n)return n;if(!Va(n))return e(n,r);for(var o=n.length,i=t?o:-1,a=Ce(n);(t?i--:++i<o)&&!1!==r(a[i],i,a););return n}}function Oo(e){return function(t,n,r){for(var o=-1,i=Ce(t),a=r(t),l=a.length;l--;){var c=a[e?l:++o];if(!1===n(i[c],c,i))break}return t}}function Bo(e){return function(t){var n=Yt(t=xl(t))?an(t):o,r=n?n[0]:t.charAt(0),i=n?bo(n,1).join(""):t.slice(1);return r[e]()+i}}function jo(e){return function(t){return zt(Yl(ql(t).replace(qe,"")),e,"")}}function To(e){return function(){var t=arguments;switch(t.length){case 0:return new e;case 1:return new e(t[0]);case 2:return new e(t[0],t[1]);case 3:return new e(t[0],t[1],t[2]);case 4:return new e(t[0],t[1],t[2],t[3]);case 5:return new e(t[0],t[1],t[2],t[3],t[4]);case 6:return new e(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new e(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var n=Dn(e.prototype),r=e.apply(n,t);return tl(r)?r:n}}function Ro(e){return function(t,n,r){var i=Ce(t);if(!Va(t)){var a=li(n,3);t=El(t),n=function(e){return a(i[e],e,i)}}var l=e(t,n,r);return l>-1?i[a?t[l]:l]:o}}function No(e){return ti((function(t){var n=t.length,r=n,a=Fn.prototype.thru;for(e&&t.reverse();r--;){var l=t[r];if("function"!=typeof l)throw new ze(i);if(a&&!c&&"wrapper"==ii(l))var c=new Fn([],!0)}for(r=c?r:n;++r<n;){var u=ii(l=t[r]),s="wrapper"==u?oi(l):o;c=s&&bi(s[0])&&424==s[1]&&!s[4].length&&1==s[9]?c[ii(s[0])].apply(c,s[3]):1==l.length&&bi(l)?c[u]():c.thru(l)}return function(){var e=arguments,r=e[0];if(c&&1==e.length&&$a(r))return c.plant(r).value();for(var o=0,i=n?t[o].apply(this,e):r;++o<n;)i=t[o].call(this,i);return i}}))}function Wo(e,t,n,i,a,l,c,s,f,p){var d=t&u,h=1&t,v=2&t,g=24&t,y=512&t,m=v?o:To(e);return function o(){for(var u=arguments.length,x=r(u),b=u;b--;)x[b]=arguments[b];if(g)var _=ai(o),w=Gt(x,_);if(i&&(x=Mo(x,i,a,g)),l&&(x=zo(x,l,c,g)),u-=w,g&&u<p){var k=tn(x,_);return Ho(e,t,Wo,o.placeholder,n,x,k,s,f,p-u)}var C=h?n:this,A=v?C[e]:e;return u=x.length,s?x=zi(x,s):y&&u>1&&x.reverse(),d&&f<u&&(x.length=f),this&&this!==it&&this instanceof o&&(A=m||To(A)),A.apply(C,x)}}function Do(e,t){return function(n,r){return function(e,t,n,r){return xr(e,(function(e,o,i){t(r,n(e),o,i)})),r}(n,e,t(r),{})}}function Uo(e,t){return function(n,r){var i;if(n===o&&r===o)return t;if(n!==o&&(i=n),r!==o){if(i===o)return r;"string"==typeof n||"string"==typeof r?(n=lo(n),r=lo(r)):(n=ao(n),r=ao(r)),i=e(n,r)}return i}}function Fo(e){return ti((function(t){return t=At(t,Qt(li())),Gr((function(n){var r=this;return e(t,(function(e){return yt(e,r,n)}))}))}))}function Qo(e,t){var n=(t=t===o?" ":lo(t)).length;if(n<2)return n?Vr(t,e):t;var r=Vr(t,sn(e/on(t)));return Yt(t)?bo(an(r),0,e).join(""):r.slice(0,e)}function qo(e){return function(t,n,i){return i&&"number"!=typeof i&&mi(t,n,i)&&(n=i=o),t=hl(t),n===o?(n=t,t=0):n=hl(n),function(e,t,n,o){for(var i=-1,a=yn(sn((t-e)/(n||1)),0),l=r(a);a--;)l[o?a:++i]=e,e+=n;return l}(t,n,i=i===o?t<n?1:-1:hl(i),e)}}function $o(e){return function(t,n){return"string"==typeof t&&"string"==typeof n||(t=yl(t),n=yl(n)),e(t,n)}}function Ho(e,t,n,r,i,a,l,u,s,f){var p=8&t;t|=p?c:64,4&(t&=~(p?64:c))||(t&=-4);var d=[e,t,i,p?a:o,p?l:o,p?o:a,p?o:l,u,s,f],h=n.apply(o,d);return bi(e)&&Si(h,d),h.placeholder=r,Ei(h,e,t)}function Vo(e){var t=ke[e];return function(e,n){if(e=yl(e),(n=null==n?0:mn(vl(n),292))&&hn(e)){var r=(xl(e)+"e").split("e");return+((r=(xl(t(r[0]+"e"+(+r[1]+n)))+"e").split("e"))[0]+"e"+(+r[1]-n))}return t(e)}}var Go=Mn&&1/nn(new Mn([,-0]))[1]==s?function(e){return new Mn(e)}:uc;function Jo(e){return function(t){var n=di(t);return n==w?Xt(t):n==z?rn(t):function(e,t){return At(t,(function(t){return[t,e[t]]}))}(t,e(t))}}function Zo(e,t,n,a,s,f,p,d){var h=2&t;if(!h&&"function"!=typeof e)throw new ze(i);var v=a?a.length:0;if(v||(t&=-97,a=s=o),p=p===o?p:yn(vl(p),0),d=d===o?d:vl(d),v-=s?s.length:0,64&t){var g=a,y=s;a=s=o}var m=h?o:oi(e),x=[e,t,n,a,s,g,y,f,p,d];if(m&&function(e,t){var n=e[1],r=t[1],o=n|r,i=o<131,a=r==u&&8==n||r==u&&256==n&&e[7].length<=t[8]||384==r&&t[7].length<=t[8]&&8==n;if(!i&&!a)return e;1&r&&(e[2]=t[2],o|=1&n?0:4);var c=t[3];if(c){var s=e[3];e[3]=s?Mo(s,c,t[4]):c,e[4]=s?tn(e[3],l):t[4]}(c=t[5])&&(s=e[5],e[5]=s?zo(s,c,t[6]):c,e[6]=s?tn(e[5],l):t[6]),(c=t[7])&&(e[7]=c),r&u&&(e[8]=null==e[8]?t[8]:mn(e[8],t[8])),null==e[9]&&(e[9]=t[9]),e[0]=t[0],e[1]=o}(x,m),e=x[0],t=x[1],n=x[2],a=x[3],s=x[4],!(d=x[9]=x[9]===o?h?0:e.length:yn(x[9]-v,0))&&24&t&&(t&=-25),t&&1!=t)b=8==t||16==t?function(e,t,n){var i=To(e);return function a(){for(var l=arguments.length,c=r(l),u=l,s=ai(a);u--;)c[u]=arguments[u];var f=l<3&&c[0]!==s&&c[l-1]!==s?[]:tn(c,s);return(l-=f.length)<n?Ho(e,t,Wo,a.placeholder,o,c,f,o,o,n-l):yt(this&&this!==it&&this instanceof a?i:e,this,c)}}(e,t,d):t!=c&&33!=t||s.length?Wo.apply(o,x):function(e,t,n,o){var i=1&t,a=To(e);return function t(){for(var l=-1,c=arguments.length,u=-1,s=o.length,f=r(s+c),p=this&&this!==it&&this instanceof t?a:e;++u<s;)f[u]=o[u];for(;c--;)f[u++]=arguments[++l];return yt(p,i?n:this,f)}}(e,t,n,a);else var b=function(e,t,n){var r=1&t,o=To(e);return function t(){return(this&&this!==it&&this instanceof t?o:e).apply(r?n:this,arguments)}}(e,t,n);return Ei((m?Yr:Si)(b,x),e,t)}function Ko(e,t,n,r){return e===o||Ua(e,Ie[n])&&!Oe.call(r,n)?t:e}function Yo(e,t,n,r,i,a){return tl(e)&&tl(t)&&(a.set(t,e),Dr(e,t,o,Yo,a),a.delete(t)),e}function Xo(e){return il(e)?o:e}function ei(e,t,n,r,i,a){var l=1&n,c=e.length,u=t.length;if(c!=u&&!(l&&u>c))return!1;var s=a.get(e),f=a.get(t);if(s&&f)return s==t&&f==e;var p=-1,d=!0,h=2&n?new Vn:o;for(a.set(e,t),a.set(t,e);++p<c;){var v=e[p],g=t[p];if(r)var y=l?r(g,v,p,t,e,a):r(v,g,p,e,t,a);if(y!==o){if(y)continue;d=!1;break}if(h){if(!St(t,(function(e,t){if(!$t(h,t)&&(v===e||i(v,e,n,r,a)))return h.push(t)}))){d=!1;break}}else if(v!==g&&!i(v,g,n,r,a)){d=!1;break}}return a.delete(e),a.delete(t),d}function ti(e){return Pi(Ai(e,o,Hi),e+"")}function ni(e){return kr(e,El,fi)}function ri(e){return kr(e,Ol,pi)}var oi=Sn?function(e){return Sn.get(e)}:uc;function ii(e){for(var t=e.name+"",n=In[t],r=Oe.call(In,t)?n.length:0;r--;){var o=n[r],i=o.func;if(null==i||i==e)return o.name}return t}function ai(e){return(Oe.call(Wn,"placeholder")?Wn:e).placeholder}function li(){var e=Wn.iteratee||ic;return e=e===ic?Br:e,arguments.length?e(arguments[0],arguments[1]):e}function ci(e,t){var n,r,o=e.__data__;return("string"==(r=typeof(n=t))||"number"==r||"symbol"==r||"boolean"==r?"__proto__"!==n:null===n)?o["string"==typeof t?"string":"hash"]:o.map}function ui(e){for(var t=El(e),n=t.length;n--;){var r=t[n],o=e[r];t[n]=[r,o,ki(o)]}return t}function si(e,t){var n=function(e,t){return null==e?o:e[t]}(e,t);return Or(n)?n:o}var fi=pn?function(e){return null==e?[]:(e=Ce(e),wt(pn(e),(function(t){return et.call(e,t)})))}:gc,pi=pn?function(e){for(var t=[];e;)Mt(t,fi(e)),e=He(e);return t}:gc,di=Cr;function hi(e,t,n){for(var r=-1,o=(t=mo(t,e)).length,i=!1;++r<o;){var a=Ni(t[r]);if(!(i=null!=e&&n(e,a)))break;e=e[a]}return i||++r!=o?i:!!(o=null==e?0:e.length)&&el(o)&&yi(a,o)&&($a(e)||qa(e))}function vi(e){return"function"!=typeof e.constructor||wi(e)?{}:Dn(He(e))}function gi(e){return $a(e)||qa(e)||!!(ot&&e&&e[ot])}function yi(e,t){var n=typeof e;return!!(t=null==t?f:t)&&("number"==n||"symbol"!=n&&ye.test(e))&&e>-1&&e%1==0&&e<t}function mi(e,t,n){if(!tl(n))return!1;var r=typeof t;return!!("number"==r?Va(n)&&yi(t,n.length):"string"==r&&t in n)&&Ua(n[t],e)}function xi(e,t){if($a(e))return!1;var n=typeof e;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=e&&!ul(e))||X.test(e)||!Y.test(e)||null!=t&&e in Ce(t)}function bi(e){var t=ii(e),n=Wn[t];if("function"!=typeof n||!(t in Qn.prototype))return!1;if(e===n)return!0;var r=oi(n);return!!r&&e===r[0]}(kn&&di(new kn(new ArrayBuffer(1)))!=E||Cn&&di(new Cn)!=w||An&&di(An.resolve())!=A||Mn&&di(new Mn)!=z||zn&&di(new zn)!=I)&&(di=function(e){var t=Cr(e),n=t==C?e.constructor:o,r=n?Wi(n):"";if(r)switch(r){case Pn:return E;case En:return w;case On:return A;case Bn:return z;case jn:return I}return t});var _i=Pe?Ya:yc;function wi(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||Ie)}function ki(e){return e==e&&!tl(e)}function Ci(e,t){return function(n){return null!=n&&n[e]===t&&(t!==o||e in Ce(n))}}function Ai(e,t,n){return t=yn(t===o?e.length-1:t,0),function(){for(var o=arguments,i=-1,a=yn(o.length-t,0),l=r(a);++i<a;)l[i]=o[t+i];i=-1;for(var c=r(t+1);++i<t;)c[i]=o[i];return c[t]=n(l),yt(e,this,c)}}function Mi(e,t){return t.length<2?e:wr(e,to(t,0,-1))}function zi(e,t){for(var n=e.length,r=mn(t.length,n),i=Lo(e);r--;){var a=t[r];e[r]=yi(a,n)?i[a]:o}return e}function Li(e,t){if(("constructor"!==t||"function"!=typeof e[t])&&"__proto__"!=t)return e[t]}var Si=Oi(Yr),Ii=Nt||function(e,t){return it.setTimeout(e,t)},Pi=Oi(Xr);function Ei(e,t,n){var r=t+"";return Pi(e,function(e,t){var n=t.length;if(!n)return e;var r=n-1;return t[r]=(n>1?"& ":"")+t[r],t=t.join(n>2?", ":" "),e.replace(ie,"{\n/* [wrapped with "+t+"] */\n")}(r,function(e,t){return xt(h,(function(n){var r="_."+n[0];t&n[1]&&!kt(e,r)&&e.push(r)})),e.sort()}(function(e){var t=e.match(ae);return t?t[1].split(le):[]}(r),n)))}function Oi(e){var t=0,n=0;return function(){var r=xn(),i=16-(r-n);if(n=r,i>0){if(++t>=800)return arguments[0]}else t=0;return e.apply(o,arguments)}}function Bi(e,t){var n=-1,r=e.length,i=r-1;for(t=t===o?r:t;++n<t;){var a=Hr(n,i),l=e[a];e[a]=e[n],e[n]=l}return e.length=t,e}var ji,Ti,Ri=(ji=ja((function(e){var t=[];return 46===e.charCodeAt(0)&&t.push(""),e.replace(ee,(function(e,n,r,o){t.push(r?o.replace(se,"$1"):n||e)})),t}),(function(e){return 500===Ti.size&&Ti.clear(),e})),Ti=ji.cache,ji);function Ni(e){if("string"==typeof e||ul(e))return e;var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}function Wi(e){if(null!=e){try{return Ee.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function Di(e){if(e instanceof Qn)return e.clone();var t=new Fn(e.__wrapped__,e.__chain__);return t.__actions__=Lo(e.__actions__),t.__index__=e.__index__,t.__values__=e.__values__,t}var Ui=Gr((function(e,t){return Ga(e)?sr(e,gr(t,1,Ga,!0)):[]})),Fi=Gr((function(e,t){var n=Ki(t);return Ga(n)&&(n=o),Ga(e)?sr(e,gr(t,1,Ga,!0),li(n,2)):[]})),Qi=Gr((function(e,t){var n=Ki(t);return Ga(n)&&(n=o),Ga(e)?sr(e,gr(t,1,Ga,!0),o,n):[]}));function qi(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var o=null==n?0:vl(n);return o<0&&(o=yn(r+o,0)),Et(e,li(t,3),o)}function $i(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=r-1;return n!==o&&(i=vl(n),i=n<0?yn(r+i,0):mn(i,r-1)),Et(e,li(t,3),i,!0)}function Hi(e){return null!=e&&e.length?gr(e,1):[]}function Vi(e){return e&&e.length?e[0]:o}var Gi=Gr((function(e){var t=At(e,go);return t.length&&t[0]===e[0]?Lr(t):[]})),Ji=Gr((function(e){var t=Ki(e),n=At(e,go);return t===Ki(n)?t=o:n.pop(),n.length&&n[0]===e[0]?Lr(n,li(t,2)):[]})),Zi=Gr((function(e){var t=Ki(e),n=At(e,go);return(t="function"==typeof t?t:o)&&n.pop(),n.length&&n[0]===e[0]?Lr(n,o,t):[]}));function Ki(e){var t=null==e?0:e.length;return t?e[t-1]:o}var Yi=Gr(Xi);function Xi(e,t){return e&&e.length&&t&&t.length?qr(e,t):e}var ea=ti((function(e,t){var n=null==e?0:e.length,r=ir(e,t);return $r(e,At(t,(function(e){return yi(e,n)?+e:e})).sort(Ao)),r}));function ta(e){return null==e?e:wn.call(e)}var na=Gr((function(e){return co(gr(e,1,Ga,!0))})),ra=Gr((function(e){var t=Ki(e);return Ga(t)&&(t=o),co(gr(e,1,Ga,!0),li(t,2))})),oa=Gr((function(e){var t=Ki(e);return t="function"==typeof t?t:o,co(gr(e,1,Ga,!0),o,t)}));function ia(e){if(!e||!e.length)return[];var t=0;return e=wt(e,(function(e){if(Ga(e))return t=yn(e.length,t),!0})),Ut(t,(function(t){return At(e,Rt(t))}))}function aa(e,t){if(!e||!e.length)return[];var n=ia(e);return null==t?n:At(n,(function(e){return yt(t,o,e)}))}var la=Gr((function(e,t){return Ga(e)?sr(e,t):[]})),ca=Gr((function(e){return ho(wt(e,Ga))})),ua=Gr((function(e){var t=Ki(e);return Ga(t)&&(t=o),ho(wt(e,Ga),li(t,2))})),sa=Gr((function(e){var t=Ki(e);return t="function"==typeof t?t:o,ho(wt(e,Ga),o,t)})),fa=Gr(ia),pa=Gr((function(e){var t=e.length,n=t>1?e[t-1]:o;return n="function"==typeof n?(e.pop(),n):o,aa(e,n)}));function da(e){var t=Wn(e);return t.__chain__=!0,t}function ha(e,t){return t(e)}var va=ti((function(e){var t=e.length,n=t?e[0]:0,r=this.__wrapped__,i=function(t){return ir(t,e)};return!(t>1||this.__actions__.length)&&r instanceof Qn&&yi(n)?((r=r.slice(n,+n+(t?1:0))).__actions__.push({func:ha,args:[i],thisArg:o}),new Fn(r,this.__chain__).thru((function(e){return t&&!e.length&&e.push(o),e}))):this.thru(i)})),ga=Io((function(e,t,n){Oe.call(e,n)?++e[n]:or(e,n,1)})),ya=Ro(qi),ma=Ro($i);function xa(e,t){return($a(e)?xt:fr)(e,li(t,3))}function ba(e,t){return($a(e)?bt:pr)(e,li(t,3))}var _a=Io((function(e,t,n){Oe.call(e,n)?e[n].push(t):or(e,n,[t])})),wa=Gr((function(e,t,n){var o=-1,i="function"==typeof t,a=Va(e)?r(e.length):[];return fr(e,(function(e){a[++o]=i?yt(t,e,n):Sr(e,t,n)})),a})),ka=Io((function(e,t,n){or(e,n,t)}));function Ca(e,t){return($a(e)?At:Rr)(e,li(t,3))}var Aa=Io((function(e,t,n){e[n?0:1].push(t)}),(function(){return[[],[]]})),Ma=Gr((function(e,t){if(null==e)return[];var n=t.length;return n>1&&mi(e,t[0],t[1])?t=[]:n>2&&mi(t[0],t[1],t[2])&&(t=[t[0]]),Fr(e,gr(t,1),[])})),za=It||function(){return it.Date.now()};function La(e,t,n){return t=n?o:t,t=e&&null==t?e.length:t,Zo(e,u,o,o,o,o,t)}function Sa(e,t){var n;if("function"!=typeof t)throw new ze(i);return e=vl(e),function(){return--e>0&&(n=t.apply(this,arguments)),e<=1&&(t=o),n}}var Ia=Gr((function(e,t,n){var r=1;if(n.length){var o=tn(n,ai(Ia));r|=c}return Zo(e,r,t,n,o)})),Pa=Gr((function(e,t,n){var r=3;if(n.length){var o=tn(n,ai(Pa));r|=c}return Zo(t,r,e,n,o)}));function Ea(e,t,n){var r,a,l,c,u,s,f=0,p=!1,d=!1,h=!0;if("function"!=typeof e)throw new ze(i);function v(t){var n=r,i=a;return r=a=o,f=t,c=e.apply(i,n)}function g(e){return f=e,u=Ii(m,t),p?v(e):c}function y(e){var n=e-s;return s===o||n>=t||n<0||d&&e-f>=l}function m(){var e=za();if(y(e))return x(e);u=Ii(m,function(e){var n=t-(e-s);return d?mn(n,l-(e-f)):n}(e))}function x(e){return u=o,h&&r?v(e):(r=a=o,c)}function b(){var e=za(),n=y(e);if(r=arguments,a=this,s=e,n){if(u===o)return g(s);if(d)return _o(u),u=Ii(m,t),v(s)}return u===o&&(u=Ii(m,t)),c}return t=yl(t)||0,tl(n)&&(p=!!n.leading,l=(d="maxWait"in n)?yn(yl(n.maxWait)||0,t):l,h="trailing"in n?!!n.trailing:h),b.cancel=function(){u!==o&&_o(u),f=0,r=s=a=u=o},b.flush=function(){return u===o?c:x(za())},b}var Oa=Gr((function(e,t){return ur(e,1,t)})),Ba=Gr((function(e,t,n){return ur(e,yl(t)||0,n)}));function ja(e,t){if("function"!=typeof e||null!=t&&"function"!=typeof t)throw new ze(i);var n=function(){var r=arguments,o=t?t.apply(this,r):r[0],i=n.cache;if(i.has(o))return i.get(o);var a=e.apply(this,r);return n.cache=i.set(o,a)||i,a};return n.cache=new(ja.Cache||Hn),n}function Ta(e){if("function"!=typeof e)throw new ze(i);return function(){var t=arguments;switch(t.length){case 0:return!e.call(this);case 1:return!e.call(this,t[0]);case 2:return!e.call(this,t[0],t[1]);case 3:return!e.call(this,t[0],t[1],t[2])}return!e.apply(this,t)}}ja.Cache=Hn;var Ra=xo((function(e,t){var n=(t=1==t.length&&$a(t[0])?At(t[0],Qt(li())):At(gr(t,1),Qt(li()))).length;return Gr((function(r){for(var o=-1,i=mn(r.length,n);++o<i;)r[o]=t[o].call(this,r[o]);return yt(e,this,r)}))})),Na=Gr((function(e,t){var n=tn(t,ai(Na));return Zo(e,c,o,t,n)})),Wa=Gr((function(e,t){var n=tn(t,ai(Wa));return Zo(e,64,o,t,n)})),Da=ti((function(e,t){return Zo(e,256,o,o,o,t)}));function Ua(e,t){return e===t||e!=e&&t!=t}var Fa=$o(Ar),Qa=$o((function(e,t){return e>=t})),qa=Ir(function(){return arguments}())?Ir:function(e){return nl(e)&&Oe.call(e,"callee")&&!et.call(e,"callee")},$a=r.isArray,Ha=ft?Qt(ft):function(e){return nl(e)&&Cr(e)==P};function Va(e){return null!=e&&el(e.length)&&!Ya(e)}function Ga(e){return nl(e)&&Va(e)}var Ja=dn||yc,Za=pt?Qt(pt):function(e){return nl(e)&&Cr(e)==m};function Ka(e){if(!nl(e))return!1;var t=Cr(e);return t==x||"[object DOMException]"==t||"string"==typeof e.message&&"string"==typeof e.name&&!il(e)}function Ya(e){if(!tl(e))return!1;var t=Cr(e);return t==b||t==_||"[object AsyncFunction]"==t||"[object Proxy]"==t}function Xa(e){return"number"==typeof e&&e==vl(e)}function el(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=f}function tl(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)}function nl(e){return null!=e&&"object"==typeof e}var rl=dt?Qt(dt):function(e){return nl(e)&&di(e)==w};function ol(e){return"number"==typeof e||nl(e)&&Cr(e)==k}function il(e){if(!nl(e)||Cr(e)!=C)return!1;var t=He(e);if(null===t)return!0;var n=Oe.call(t,"constructor")&&t.constructor;return"function"==typeof n&&n instanceof n&&Ee.call(n)==Re}var al=ht?Qt(ht):function(e){return nl(e)&&Cr(e)==M},ll=vt?Qt(vt):function(e){return nl(e)&&di(e)==z};function cl(e){return"string"==typeof e||!$a(e)&&nl(e)&&Cr(e)==L}function ul(e){return"symbol"==typeof e||nl(e)&&Cr(e)==S}var sl=gt?Qt(gt):function(e){return nl(e)&&el(e.length)&&!!Ye[Cr(e)]},fl=$o(Tr),pl=$o((function(e,t){return e<=t}));function dl(e){if(!e)return[];if(Va(e))return cl(e)?an(e):Lo(e);if(at&&e[at])return function(e){for(var t,n=[];!(t=e.next()).done;)n.push(t.value);return n}(e[at]());var t=di(e);return(t==w?Xt:t==z?nn:Ul)(e)}function hl(e){return e?(e=yl(e))===s||e===-1/0?17976931348623157e292*(e<0?-1:1):e==e?e:0:0===e?e:0}function vl(e){var t=hl(e),n=t%1;return t==t?n?t-n:t:0}function gl(e){return e?ar(vl(e),0,d):0}function yl(e){if("number"==typeof e)return e;if(ul(e))return p;if(tl(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=tl(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=Ft(e);var n=he.test(e);return n||ge.test(e)?nt(e.slice(2),n?2:8):de.test(e)?p:+e}function ml(e){return So(e,Ol(e))}function xl(e){return null==e?"":lo(e)}var bl=Po((function(e,t){if(wi(t)||Va(t))So(t,El(t),e);else for(var n in t)Oe.call(t,n)&&er(e,n,t[n])})),_l=Po((function(e,t){So(t,Ol(t),e)})),wl=Po((function(e,t,n,r){So(t,Ol(t),e,r)})),kl=Po((function(e,t,n,r){So(t,El(t),e,r)})),Cl=ti(ir),Al=Gr((function(e,t){e=Ce(e);var n=-1,r=t.length,i=r>2?t[2]:o;for(i&&mi(t[0],t[1],i)&&(r=1);++n<r;)for(var a=t[n],l=Ol(a),c=-1,u=l.length;++c<u;){var s=l[c],f=e[s];(f===o||Ua(f,Ie[s])&&!Oe.call(e,s))&&(e[s]=a[s])}return e})),Ml=Gr((function(e){return e.push(o,Yo),yt(jl,o,e)}));function zl(e,t,n){var r=null==e?o:wr(e,t);return r===o?n:r}function Ll(e,t){return null!=e&&hi(e,t,zr)}var Sl=Do((function(e,t,n){null!=t&&"function"!=typeof t.toString&&(t=Te.call(t)),e[t]=n}),tc(oc)),Il=Do((function(e,t,n){null!=t&&"function"!=typeof t.toString&&(t=Te.call(t)),Oe.call(e,t)?e[t].push(n):e[t]=[n]}),li),Pl=Gr(Sr);function El(e){return Va(e)?Jn(e):jr(e)}function Ol(e){return Va(e)?Jn(e,!0):function(e){if(!tl(e))return function(e){var t=[];if(null!=e)for(var n in Ce(e))t.push(n);return t}(e);var t=wi(e),n=[];for(var r in e)("constructor"!=r||!t&&Oe.call(e,r))&&n.push(r);return n}(e)}var Bl=Po((function(e,t,n){Dr(e,t,n)})),jl=Po((function(e,t,n,r){Dr(e,t,n,r)})),Tl=ti((function(e,t){var n={};if(null==e)return n;var r=!1;t=At(t,(function(t){return t=mo(t,e),r||(r=t.length>1),t})),So(e,ri(e),n),r&&(n=lr(n,7,Xo));for(var o=t.length;o--;)uo(n,t[o]);return n})),Rl=ti((function(e,t){return null==e?{}:function(e,t){return Qr(e,t,(function(t,n){return Ll(e,n)}))}(e,t)}));function Nl(e,t){if(null==e)return{};var n=At(ri(e),(function(e){return[e]}));return t=li(t),Qr(e,n,(function(e,n){return t(e,n[0])}))}var Wl=Jo(El),Dl=Jo(Ol);function Ul(e){return null==e?[]:qt(e,El(e))}var Fl=jo((function(e,t,n){return t=t.toLowerCase(),e+(n?Ql(t):t)}));function Ql(e){return Kl(xl(e).toLowerCase())}function ql(e){return(e=xl(e))&&e.replace(me,Jt).replace($e,"")}var $l=jo((function(e,t,n){return e+(n?"-":"")+t.toLowerCase()})),Hl=jo((function(e,t,n){return e+(n?" ":"")+t.toLowerCase()})),Vl=Bo("toLowerCase"),Gl=jo((function(e,t,n){return e+(n?"_":"")+t.toLowerCase()})),Jl=jo((function(e,t,n){return e+(n?" ":"")+Kl(t)})),Zl=jo((function(e,t,n){return e+(n?" ":"")+t.toUpperCase()})),Kl=Bo("toUpperCase");function Yl(e,t,n){return e=xl(e),(t=n?o:t)===o?function(e){return Je.test(e)}(e)?function(e){return e.match(Ve)||[]}(e):function(e){return e.match(ce)||[]}(e):e.match(t)||[]}var Xl=Gr((function(e,t){try{return yt(e,o,t)}catch(e){return Ka(e)?e:new _e(e)}})),ec=ti((function(e,t){return xt(t,(function(t){t=Ni(t),or(e,t,Ia(e[t],e))})),e}));function tc(e){return function(){return e}}var nc=No(),rc=No(!0);function oc(e){return e}function ic(e){return Br("function"==typeof e?e:lr(e,1))}var ac=Gr((function(e,t){return function(n){return Sr(n,e,t)}})),lc=Gr((function(e,t){return function(n){return Sr(e,n,t)}}));function cc(e,t,n){var r=El(t),o=_r(t,r);null!=n||tl(t)&&(o.length||!r.length)||(n=t,t=e,e=this,o=_r(t,El(t)));var i=!(tl(n)&&"chain"in n&&!n.chain),a=Ya(e);return xt(o,(function(n){var r=t[n];e[n]=r,a&&(e.prototype[n]=function(){var t=this.__chain__;if(i||t){var n=e(this.__wrapped__),o=n.__actions__=Lo(this.__actions__);return o.push({func:r,args:arguments,thisArg:e}),n.__chain__=t,n}return r.apply(e,Mt([this.value()],arguments))})})),e}function uc(){}var sc=Fo(At),fc=Fo(_t),pc=Fo(St);function dc(e){return xi(e)?Rt(Ni(e)):function(e){return function(t){return wr(t,e)}}(e)}var hc=qo(),vc=qo(!0);function gc(){return[]}function yc(){return!1}var mc,xc=Uo((function(e,t){return e+t}),0),bc=Vo("ceil"),_c=Uo((function(e,t){return e/t}),1),wc=Vo("floor"),kc=Uo((function(e,t){return e*t}),1),Cc=Vo("round"),Ac=Uo((function(e,t){return e-t}),0);return Wn.after=function(e,t){if("function"!=typeof t)throw new ze(i);return e=vl(e),function(){if(--e<1)return t.apply(this,arguments)}},Wn.ary=La,Wn.assign=bl,Wn.assignIn=_l,Wn.assignInWith=wl,Wn.assignWith=kl,Wn.at=Cl,Wn.before=Sa,Wn.bind=Ia,Wn.bindAll=ec,Wn.bindKey=Pa,Wn.castArray=function(){if(!arguments.length)return[];var e=arguments[0];return $a(e)?e:[e]},Wn.chain=da,Wn.chunk=function(e,t,n){t=(n?mi(e,t,n):t===o)?1:yn(vl(t),0);var i=null==e?0:e.length;if(!i||t<1)return[];for(var a=0,l=0,c=r(sn(i/t));a<i;)c[l++]=to(e,a,a+=t);return c},Wn.compact=function(e){for(var t=-1,n=null==e?0:e.length,r=0,o=[];++t<n;){var i=e[t];i&&(o[r++]=i)}return o},Wn.concat=function(){var e=arguments.length;if(!e)return[];for(var t=r(e-1),n=arguments[0],o=e;o--;)t[o-1]=arguments[o];return Mt($a(n)?Lo(n):[n],gr(t,1))},Wn.cond=function(e){var t=null==e?0:e.length,n=li();return e=t?At(e,(function(e){if("function"!=typeof e[1])throw new ze(i);return[n(e[0]),e[1]]})):[],Gr((function(n){for(var r=-1;++r<t;){var o=e[r];if(yt(o[0],this,n))return yt(o[1],this,n)}}))},Wn.conforms=function(e){return function(e){var t=El(e);return function(n){return cr(n,e,t)}}(lr(e,1))},Wn.constant=tc,Wn.countBy=ga,Wn.create=function(e,t){var n=Dn(e);return null==t?n:rr(n,t)},Wn.curry=function e(t,n,r){var i=Zo(t,8,o,o,o,o,o,n=r?o:n);return i.placeholder=e.placeholder,i},Wn.curryRight=function e(t,n,r){var i=Zo(t,16,o,o,o,o,o,n=r?o:n);return i.placeholder=e.placeholder,i},Wn.debounce=Ea,Wn.defaults=Al,Wn.defaultsDeep=Ml,Wn.defer=Oa,Wn.delay=Ba,Wn.difference=Ui,Wn.differenceBy=Fi,Wn.differenceWith=Qi,Wn.drop=function(e,t,n){var r=null==e?0:e.length;return r?to(e,(t=n||t===o?1:vl(t))<0?0:t,r):[]},Wn.dropRight=function(e,t,n){var r=null==e?0:e.length;return r?to(e,0,(t=r-(t=n||t===o?1:vl(t)))<0?0:t):[]},Wn.dropRightWhile=function(e,t){return e&&e.length?fo(e,li(t,3),!0,!0):[]},Wn.dropWhile=function(e,t){return e&&e.length?fo(e,li(t,3),!0):[]},Wn.fill=function(e,t,n,r){var i=null==e?0:e.length;return i?(n&&"number"!=typeof n&&mi(e,t,n)&&(n=0,r=i),function(e,t,n,r){var i=e.length;for((n=vl(n))<0&&(n=-n>i?0:i+n),(r=r===o||r>i?i:vl(r))<0&&(r+=i),r=n>r?0:gl(r);n<r;)e[n++]=t;return e}(e,t,n,r)):[]},Wn.filter=function(e,t){return($a(e)?wt:vr)(e,li(t,3))},Wn.flatMap=function(e,t){return gr(Ca(e,t),1)},Wn.flatMapDeep=function(e,t){return gr(Ca(e,t),s)},Wn.flatMapDepth=function(e,t,n){return n=n===o?1:vl(n),gr(Ca(e,t),n)},Wn.flatten=Hi,Wn.flattenDeep=function(e){return null!=e&&e.length?gr(e,s):[]},Wn.flattenDepth=function(e,t){return null!=e&&e.length?gr(e,t=t===o?1:vl(t)):[]},Wn.flip=function(e){return Zo(e,512)},Wn.flow=nc,Wn.flowRight=rc,Wn.fromPairs=function(e){for(var t=-1,n=null==e?0:e.length,r={};++t<n;){var o=e[t];r[o[0]]=o[1]}return r},Wn.functions=function(e){return null==e?[]:_r(e,El(e))},Wn.functionsIn=function(e){return null==e?[]:_r(e,Ol(e))},Wn.groupBy=_a,Wn.initial=function(e){return null!=e&&e.length?to(e,0,-1):[]},Wn.intersection=Gi,Wn.intersectionBy=Ji,Wn.intersectionWith=Zi,Wn.invert=Sl,Wn.invertBy=Il,Wn.invokeMap=wa,Wn.iteratee=ic,Wn.keyBy=ka,Wn.keys=El,Wn.keysIn=Ol,Wn.map=Ca,Wn.mapKeys=function(e,t){var n={};return t=li(t,3),xr(e,(function(e,r,o){or(n,t(e,r,o),e)})),n},Wn.mapValues=function(e,t){var n={};return t=li(t,3),xr(e,(function(e,r,o){or(n,r,t(e,r,o))})),n},Wn.matches=function(e){return Nr(lr(e,1))},Wn.matchesProperty=function(e,t){return Wr(e,lr(t,1))},Wn.memoize=ja,Wn.merge=Bl,Wn.mergeWith=jl,Wn.method=ac,Wn.methodOf=lc,Wn.mixin=cc,Wn.negate=Ta,Wn.nthArg=function(e){return e=vl(e),Gr((function(t){return Ur(t,e)}))},Wn.omit=Tl,Wn.omitBy=function(e,t){return Nl(e,Ta(li(t)))},Wn.once=function(e){return Sa(2,e)},Wn.orderBy=function(e,t,n,r){return null==e?[]:($a(t)||(t=null==t?[]:[t]),$a(n=r?o:n)||(n=null==n?[]:[n]),Fr(e,t,n))},Wn.over=sc,Wn.overArgs=Ra,Wn.overEvery=fc,Wn.overSome=pc,Wn.partial=Na,Wn.partialRight=Wa,Wn.partition=Aa,Wn.pick=Rl,Wn.pickBy=Nl,Wn.property=dc,Wn.propertyOf=function(e){return function(t){return null==e?o:wr(e,t)}},Wn.pull=Yi,Wn.pullAll=Xi,Wn.pullAllBy=function(e,t,n){return e&&e.length&&t&&t.length?qr(e,t,li(n,2)):e},Wn.pullAllWith=function(e,t,n){return e&&e.length&&t&&t.length?qr(e,t,o,n):e},Wn.pullAt=ea,Wn.range=hc,Wn.rangeRight=vc,Wn.rearg=Da,Wn.reject=function(e,t){return($a(e)?wt:vr)(e,Ta(li(t,3)))},Wn.remove=function(e,t){var n=[];if(!e||!e.length)return n;var r=-1,o=[],i=e.length;for(t=li(t,3);++r<i;){var a=e[r];t(a,r,e)&&(n.push(a),o.push(r))}return $r(e,o),n},Wn.rest=function(e,t){if("function"!=typeof e)throw new ze(i);return Gr(e,t=t===o?t:vl(t))},Wn.reverse=ta,Wn.sampleSize=function(e,t,n){return t=(n?mi(e,t,n):t===o)?1:vl(t),($a(e)?Kn:Zr)(e,t)},Wn.set=function(e,t,n){return null==e?e:Kr(e,t,n)},Wn.setWith=function(e,t,n,r){return r="function"==typeof r?r:o,null==e?e:Kr(e,t,n,r)},Wn.shuffle=function(e){return($a(e)?Yn:eo)(e)},Wn.slice=function(e,t,n){var r=null==e?0:e.length;return r?(n&&"number"!=typeof n&&mi(e,t,n)?(t=0,n=r):(t=null==t?0:vl(t),n=n===o?r:vl(n)),to(e,t,n)):[]},Wn.sortBy=Ma,Wn.sortedUniq=function(e){return e&&e.length?io(e):[]},Wn.sortedUniqBy=function(e,t){return e&&e.length?io(e,li(t,2)):[]},Wn.split=function(e,t,n){return n&&"number"!=typeof n&&mi(e,t,n)&&(t=n=o),(n=n===o?d:n>>>0)?(e=xl(e))&&("string"==typeof t||null!=t&&!al(t))&&!(t=lo(t))&&Yt(e)?bo(an(e),0,n):e.split(t,n):[]},Wn.spread=function(e,t){if("function"!=typeof e)throw new ze(i);return t=null==t?0:yn(vl(t),0),Gr((function(n){var r=n[t],o=bo(n,0,t);return r&&Mt(o,r),yt(e,this,o)}))},Wn.tail=function(e){var t=null==e?0:e.length;return t?to(e,1,t):[]},Wn.take=function(e,t,n){return e&&e.length?to(e,0,(t=n||t===o?1:vl(t))<0?0:t):[]},Wn.takeRight=function(e,t,n){var r=null==e?0:e.length;return r?to(e,(t=r-(t=n||t===o?1:vl(t)))<0?0:t,r):[]},Wn.takeRightWhile=function(e,t){return e&&e.length?fo(e,li(t,3),!1,!0):[]},Wn.takeWhile=function(e,t){return e&&e.length?fo(e,li(t,3)):[]},Wn.tap=function(e,t){return t(e),e},Wn.throttle=function(e,t,n){var r=!0,o=!0;if("function"!=typeof e)throw new ze(i);return tl(n)&&(r="leading"in n?!!n.leading:r,o="trailing"in n?!!n.trailing:o),Ea(e,t,{leading:r,maxWait:t,trailing:o})},Wn.thru=ha,Wn.toArray=dl,Wn.toPairs=Wl,Wn.toPairsIn=Dl,Wn.toPath=function(e){return $a(e)?At(e,Ni):ul(e)?[e]:Lo(Ri(xl(e)))},Wn.toPlainObject=ml,Wn.transform=function(e,t,n){var r=$a(e),o=r||Ja(e)||sl(e);if(t=li(t,4),null==n){var i=e&&e.constructor;n=o?r?new i:[]:tl(e)&&Ya(i)?Dn(He(e)):{}}return(o?xt:xr)(e,(function(e,r,o){return t(n,e,r,o)})),n},Wn.unary=function(e){return La(e,1)},Wn.union=na,Wn.unionBy=ra,Wn.unionWith=oa,Wn.uniq=function(e){return e&&e.length?co(e):[]},Wn.uniqBy=function(e,t){return e&&e.length?co(e,li(t,2)):[]},Wn.uniqWith=function(e,t){return t="function"==typeof t?t:o,e&&e.length?co(e,o,t):[]},Wn.unset=function(e,t){return null==e||uo(e,t)},Wn.unzip=ia,Wn.unzipWith=aa,Wn.update=function(e,t,n){return null==e?e:so(e,t,yo(n))},Wn.updateWith=function(e,t,n,r){return r="function"==typeof r?r:o,null==e?e:so(e,t,yo(n),r)},Wn.values=Ul,Wn.valuesIn=function(e){return null==e?[]:qt(e,Ol(e))},Wn.without=la,Wn.words=Yl,Wn.wrap=function(e,t){return Na(yo(t),e)},Wn.xor=ca,Wn.xorBy=ua,Wn.xorWith=sa,Wn.zip=fa,Wn.zipObject=function(e,t){return vo(e||[],t||[],er)},Wn.zipObjectDeep=function(e,t){return vo(e||[],t||[],Kr)},Wn.zipWith=pa,Wn.entries=Wl,Wn.entriesIn=Dl,Wn.extend=_l,Wn.extendWith=wl,cc(Wn,Wn),Wn.add=xc,Wn.attempt=Xl,Wn.camelCase=Fl,Wn.capitalize=Ql,Wn.ceil=bc,Wn.clamp=function(e,t,n){return n===o&&(n=t,t=o),n!==o&&(n=(n=yl(n))==n?n:0),t!==o&&(t=(t=yl(t))==t?t:0),ar(yl(e),t,n)},Wn.clone=function(e){return lr(e,4)},Wn.cloneDeep=function(e){return lr(e,5)},Wn.cloneDeepWith=function(e,t){return lr(e,5,t="function"==typeof t?t:o)},Wn.cloneWith=function(e,t){return lr(e,4,t="function"==typeof t?t:o)},Wn.conformsTo=function(e,t){return null==t||cr(e,t,El(t))},Wn.deburr=ql,Wn.defaultTo=function(e,t){return null==e||e!=e?t:e},Wn.divide=_c,Wn.endsWith=function(e,t,n){e=xl(e),t=lo(t);var r=e.length,i=n=n===o?r:ar(vl(n),0,r);return(n-=t.length)>=0&&e.slice(n,i)==t},Wn.eq=Ua,Wn.escape=function(e){return(e=xl(e))&&G.test(e)?e.replace(H,Zt):e},Wn.escapeRegExp=function(e){return(e=xl(e))&&ne.test(e)?e.replace(te,"\\$&"):e},Wn.every=function(e,t,n){var r=$a(e)?_t:dr;return n&&mi(e,t,n)&&(t=o),r(e,li(t,3))},Wn.find=ya,Wn.findIndex=qi,Wn.findKey=function(e,t){return Pt(e,li(t,3),xr)},Wn.findLast=ma,Wn.findLastIndex=$i,Wn.findLastKey=function(e,t){return Pt(e,li(t,3),br)},Wn.floor=wc,Wn.forEach=xa,Wn.forEachRight=ba,Wn.forIn=function(e,t){return null==e?e:yr(e,li(t,3),Ol)},Wn.forInRight=function(e,t){return null==e?e:mr(e,li(t,3),Ol)},Wn.forOwn=function(e,t){return e&&xr(e,li(t,3))},Wn.forOwnRight=function(e,t){return e&&br(e,li(t,3))},Wn.get=zl,Wn.gt=Fa,Wn.gte=Qa,Wn.has=function(e,t){return null!=e&&hi(e,t,Mr)},Wn.hasIn=Ll,Wn.head=Vi,Wn.identity=oc,Wn.includes=function(e,t,n,r){e=Va(e)?e:Ul(e),n=n&&!r?vl(n):0;var o=e.length;return n<0&&(n=yn(o+n,0)),cl(e)?n<=o&&e.indexOf(t,n)>-1:!!o&&Ot(e,t,n)>-1},Wn.indexOf=function(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var o=null==n?0:vl(n);return o<0&&(o=yn(r+o,0)),Ot(e,t,o)},Wn.inRange=function(e,t,n){return t=hl(t),n===o?(n=t,t=0):n=hl(n),function(e,t,n){return e>=mn(t,n)&&e<yn(t,n)}(e=yl(e),t,n)},Wn.invoke=Pl,Wn.isArguments=qa,Wn.isArray=$a,Wn.isArrayBuffer=Ha,Wn.isArrayLike=Va,Wn.isArrayLikeObject=Ga,Wn.isBoolean=function(e){return!0===e||!1===e||nl(e)&&Cr(e)==y},Wn.isBuffer=Ja,Wn.isDate=Za,Wn.isElement=function(e){return nl(e)&&1===e.nodeType&&!il(e)},Wn.isEmpty=function(e){if(null==e)return!0;if(Va(e)&&($a(e)||"string"==typeof e||"function"==typeof e.splice||Ja(e)||sl(e)||qa(e)))return!e.length;var t=di(e);if(t==w||t==z)return!e.size;if(wi(e))return!jr(e).length;for(var n in e)if(Oe.call(e,n))return!1;return!0},Wn.isEqual=function(e,t){return Pr(e,t)},Wn.isEqualWith=function(e,t,n){var r=(n="function"==typeof n?n:o)?n(e,t):o;return r===o?Pr(e,t,o,n):!!r},Wn.isError=Ka,Wn.isFinite=function(e){return"number"==typeof e&&hn(e)},Wn.isFunction=Ya,Wn.isInteger=Xa,Wn.isLength=el,Wn.isMap=rl,Wn.isMatch=function(e,t){return e===t||Er(e,t,ui(t))},Wn.isMatchWith=function(e,t,n){return n="function"==typeof n?n:o,Er(e,t,ui(t),n)},Wn.isNaN=function(e){return ol(e)&&e!=+e},Wn.isNative=function(e){if(_i(e))throw new _e("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return Or(e)},Wn.isNil=function(e){return null==e},Wn.isNull=function(e){return null===e},Wn.isNumber=ol,Wn.isObject=tl,Wn.isObjectLike=nl,Wn.isPlainObject=il,Wn.isRegExp=al,Wn.isSafeInteger=function(e){return Xa(e)&&e>=-9007199254740991&&e<=f},Wn.isSet=ll,Wn.isString=cl,Wn.isSymbol=ul,Wn.isTypedArray=sl,Wn.isUndefined=function(e){return e===o},Wn.isWeakMap=function(e){return nl(e)&&di(e)==I},Wn.isWeakSet=function(e){return nl(e)&&"[object WeakSet]"==Cr(e)},Wn.join=function(e,t){return null==e?"":vn.call(e,t)},Wn.kebabCase=$l,Wn.last=Ki,Wn.lastIndexOf=function(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=r;return n!==o&&(i=(i=vl(n))<0?yn(r+i,0):mn(i,r-1)),t==t?function(e,t,n){for(var r=n+1;r--;)if(e[r]===t)return r;return r}(e,t,i):Et(e,jt,i,!0)},Wn.lowerCase=Hl,Wn.lowerFirst=Vl,Wn.lt=fl,Wn.lte=pl,Wn.max=function(e){return e&&e.length?hr(e,oc,Ar):o},Wn.maxBy=function(e,t){return e&&e.length?hr(e,li(t,2),Ar):o},Wn.mean=function(e){return Tt(e,oc)},Wn.meanBy=function(e,t){return Tt(e,li(t,2))},Wn.min=function(e){return e&&e.length?hr(e,oc,Tr):o},Wn.minBy=function(e,t){return e&&e.length?hr(e,li(t,2),Tr):o},Wn.stubArray=gc,Wn.stubFalse=yc,Wn.stubObject=function(){return{}},Wn.stubString=function(){return""},Wn.stubTrue=function(){return!0},Wn.multiply=kc,Wn.nth=function(e,t){return e&&e.length?Ur(e,vl(t)):o},Wn.noConflict=function(){return it._===this&&(it._=Ne),this},Wn.noop=uc,Wn.now=za,Wn.pad=function(e,t,n){e=xl(e);var r=(t=vl(t))?on(e):0;if(!t||r>=t)return e;var o=(t-r)/2;return Qo(fn(o),n)+e+Qo(sn(o),n)},Wn.padEnd=function(e,t,n){e=xl(e);var r=(t=vl(t))?on(e):0;return t&&r<t?e+Qo(t-r,n):e},Wn.padStart=function(e,t,n){e=xl(e);var r=(t=vl(t))?on(e):0;return t&&r<t?Qo(t-r,n)+e:e},Wn.parseInt=function(e,t,n){return n||null==t?t=0:t&&(t=+t),bn(xl(e).replace(re,""),t||0)},Wn.random=function(e,t,n){if(n&&"boolean"!=typeof n&&mi(e,t,n)&&(t=n=o),n===o&&("boolean"==typeof t?(n=t,t=o):"boolean"==typeof e&&(n=e,e=o)),e===o&&t===o?(e=0,t=1):(e=hl(e),t===o?(t=e,e=0):t=hl(t)),e>t){var r=e;e=t,t=r}if(n||e%1||t%1){var i=_n();return mn(e+i*(t-e+tt("1e-"+((i+"").length-1))),t)}return Hr(e,t)},Wn.reduce=function(e,t,n){var r=$a(e)?zt:Wt,o=arguments.length<3;return r(e,li(t,4),n,o,fr)},Wn.reduceRight=function(e,t,n){var r=$a(e)?Lt:Wt,o=arguments.length<3;return r(e,li(t,4),n,o,pr)},Wn.repeat=function(e,t,n){return t=(n?mi(e,t,n):t===o)?1:vl(t),Vr(xl(e),t)},Wn.replace=function(){var e=arguments,t=xl(e[0]);return e.length<3?t:t.replace(e[1],e[2])},Wn.result=function(e,t,n){var r=-1,i=(t=mo(t,e)).length;for(i||(i=1,e=o);++r<i;){var a=null==e?o:e[Ni(t[r])];a===o&&(r=i,a=n),e=Ya(a)?a.call(e):a}return e},Wn.round=Cc,Wn.runInContext=e,Wn.sample=function(e){return($a(e)?Zn:Jr)(e)},Wn.size=function(e){if(null==e)return 0;if(Va(e))return cl(e)?on(e):e.length;var t=di(e);return t==w||t==z?e.size:jr(e).length},Wn.snakeCase=Gl,Wn.some=function(e,t,n){var r=$a(e)?St:no;return n&&mi(e,t,n)&&(t=o),r(e,li(t,3))},Wn.sortedIndex=function(e,t){return ro(e,t)},Wn.sortedIndexBy=function(e,t,n){return oo(e,t,li(n,2))},Wn.sortedIndexOf=function(e,t){var n=null==e?0:e.length;if(n){var r=ro(e,t);if(r<n&&Ua(e[r],t))return r}return-1},Wn.sortedLastIndex=function(e,t){return ro(e,t,!0)},Wn.sortedLastIndexBy=function(e,t,n){return oo(e,t,li(n,2),!0)},Wn.sortedLastIndexOf=function(e,t){if(null!=e&&e.length){var n=ro(e,t,!0)-1;if(Ua(e[n],t))return n}return-1},Wn.startCase=Jl,Wn.startsWith=function(e,t,n){return e=xl(e),n=null==n?0:ar(vl(n),0,e.length),t=lo(t),e.slice(n,n+t.length)==t},Wn.subtract=Ac,Wn.sum=function(e){return e&&e.length?Dt(e,oc):0},Wn.sumBy=function(e,t){return e&&e.length?Dt(e,li(t,2)):0},Wn.template=function(e,t,n){var r=Wn.templateSettings;n&&mi(e,t,n)&&(t=o),e=xl(e),t=wl({},t,r,Ko);var i,a,l=wl({},t.imports,r.imports,Ko),c=El(l),u=qt(l,c),s=0,f=t.interpolate||xe,p="__p += '",d=Ae((t.escape||xe).source+"|"+f.source+"|"+(f===K?fe:xe).source+"|"+(t.evaluate||xe).source+"|$","g"),h="//# sourceURL="+(Oe.call(t,"sourceURL")?(t.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Ke+"]")+"\n";e.replace(d,(function(t,n,r,o,l,c){return r||(r=o),p+=e.slice(s,c).replace(be,Kt),n&&(i=!0,p+="' +\n__e("+n+") +\n'"),l&&(a=!0,p+="';\n"+l+";\n__p += '"),r&&(p+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),s=c+t.length,t})),p+="';\n";var v=Oe.call(t,"variable")&&t.variable;if(v){if(ue.test(v))throw new _e("Invalid `variable` option passed into `_.template`")}else p="with (obj) {\n"+p+"\n}\n";p=(a?p.replace(F,""):p).replace(Q,"$1").replace(q,"$1;"),p="function("+(v||"obj")+") {\n"+(v?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(i?", __e = _.escape":"")+(a?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+p+"return __p\n}";var g=Xl((function(){return we(c,h+"return "+p).apply(o,u)}));if(g.source=p,Ka(g))throw g;return g},Wn.times=function(e,t){if((e=vl(e))<1||e>f)return[];var n=d,r=mn(e,d);t=li(t),e-=d;for(var o=Ut(r,t);++n<e;)t(n);return o},Wn.toFinite=hl,Wn.toInteger=vl,Wn.toLength=gl,Wn.toLower=function(e){return xl(e).toLowerCase()},Wn.toNumber=yl,Wn.toSafeInteger=function(e){return e?ar(vl(e),-9007199254740991,f):0===e?e:0},Wn.toString=xl,Wn.toUpper=function(e){return xl(e).toUpperCase()},Wn.trim=function(e,t,n){if((e=xl(e))&&(n||t===o))return Ft(e);if(!e||!(t=lo(t)))return e;var r=an(e),i=an(t);return bo(r,Ht(r,i),Vt(r,i)+1).join("")},Wn.trimEnd=function(e,t,n){if((e=xl(e))&&(n||t===o))return e.slice(0,ln(e)+1);if(!e||!(t=lo(t)))return e;var r=an(e);return bo(r,0,Vt(r,an(t))+1).join("")},Wn.trimStart=function(e,t,n){if((e=xl(e))&&(n||t===o))return e.replace(re,"");if(!e||!(t=lo(t)))return e;var r=an(e);return bo(r,Ht(r,an(t))).join("")},Wn.truncate=function(e,t){var n=30,r="...";if(tl(t)){var i="separator"in t?t.separator:i;n="length"in t?vl(t.length):n,r="omission"in t?lo(t.omission):r}var a=(e=xl(e)).length;if(Yt(e)){var l=an(e);a=l.length}if(n>=a)return e;var c=n-on(r);if(c<1)return r;var u=l?bo(l,0,c).join(""):e.slice(0,c);if(i===o)return u+r;if(l&&(c+=u.length-c),al(i)){if(e.slice(c).search(i)){var s,f=u;for(i.global||(i=Ae(i.source,xl(pe.exec(i))+"g")),i.lastIndex=0;s=i.exec(f);)var p=s.index;u=u.slice(0,p===o?c:p)}}else if(e.indexOf(lo(i),c)!=c){var d=u.lastIndexOf(i);d>-1&&(u=u.slice(0,d))}return u+r},Wn.unescape=function(e){return(e=xl(e))&&V.test(e)?e.replace($,cn):e},Wn.uniqueId=function(e){var t=++Be;return xl(e)+t},Wn.upperCase=Zl,Wn.upperFirst=Kl,Wn.each=xa,Wn.eachRight=ba,Wn.first=Vi,cc(Wn,(mc={},xr(Wn,(function(e,t){Oe.call(Wn.prototype,t)||(mc[t]=e)})),mc),{chain:!1}),Wn.VERSION="4.17.21",xt(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(e){Wn[e].placeholder=Wn})),xt(["drop","take"],(function(e,t){Qn.prototype[e]=function(n){n=n===o?1:yn(vl(n),0);var r=this.__filtered__&&!t?new Qn(this):this.clone();return r.__filtered__?r.__takeCount__=mn(n,r.__takeCount__):r.__views__.push({size:mn(n,d),type:e+(r.__dir__<0?"Right":"")}),r},Qn.prototype[e+"Right"]=function(t){return this.reverse()[e](t).reverse()}})),xt(["filter","map","takeWhile"],(function(e,t){var n=t+1,r=1==n||3==n;Qn.prototype[e]=function(e){var t=this.clone();return t.__iteratees__.push({iteratee:li(e,3),type:n}),t.__filtered__=t.__filtered__||r,t}})),xt(["head","last"],(function(e,t){var n="take"+(t?"Right":"");Qn.prototype[e]=function(){return this[n](1).value()[0]}})),xt(["initial","tail"],(function(e,t){var n="drop"+(t?"":"Right");Qn.prototype[e]=function(){return this.__filtered__?new Qn(this):this[n](1)}})),Qn.prototype.compact=function(){return this.filter(oc)},Qn.prototype.find=function(e){return this.filter(e).head()},Qn.prototype.findLast=function(e){return this.reverse().find(e)},Qn.prototype.invokeMap=Gr((function(e,t){return"function"==typeof e?new Qn(this):this.map((function(n){return Sr(n,e,t)}))})),Qn.prototype.reject=function(e){return this.filter(Ta(li(e)))},Qn.prototype.slice=function(e,t){e=vl(e);var n=this;return n.__filtered__&&(e>0||t<0)?new Qn(n):(e<0?n=n.takeRight(-e):e&&(n=n.drop(e)),t!==o&&(n=(t=vl(t))<0?n.dropRight(-t):n.take(t-e)),n)},Qn.prototype.takeRightWhile=function(e){return this.reverse().takeWhile(e).reverse()},Qn.prototype.toArray=function(){return this.take(d)},xr(Qn.prototype,(function(e,t){var n=/^(?:filter|find|map|reject)|While$/.test(t),r=/^(?:head|last)$/.test(t),i=Wn[r?"take"+("last"==t?"Right":""):t],a=r||/^find/.test(t);i&&(Wn.prototype[t]=function(){var t=this.__wrapped__,l=r?[1]:arguments,c=t instanceof Qn,u=l[0],s=c||$a(t),f=function(e){var t=i.apply(Wn,Mt([e],l));return r&&p?t[0]:t};s&&n&&"function"==typeof u&&1!=u.length&&(c=s=!1);var p=this.__chain__,d=!!this.__actions__.length,h=a&&!p,v=c&&!d;if(!a&&s){t=v?t:new Qn(this);var g=e.apply(t,l);return g.__actions__.push({func:ha,args:[f],thisArg:o}),new Fn(g,p)}return h&&v?e.apply(this,l):(g=this.thru(f),h?r?g.value()[0]:g.value():g)})})),xt(["pop","push","shift","sort","splice","unshift"],(function(e){var t=Le[e],n=/^(?:push|sort|unshift)$/.test(e)?"tap":"thru",r=/^(?:pop|shift)$/.test(e);Wn.prototype[e]=function(){var e=arguments;if(r&&!this.__chain__){var o=this.value();return t.apply($a(o)?o:[],e)}return this[n]((function(n){return t.apply($a(n)?n:[],e)}))}})),xr(Qn.prototype,(function(e,t){var n=Wn[t];if(n){var r=n.name+"";Oe.call(In,r)||(In[r]=[]),In[r].push({name:t,func:n})}})),In[Wo(o,2).name]=[{name:"wrapper",func:o}],Qn.prototype.clone=function(){var e=new Qn(this.__wrapped__);return e.__actions__=Lo(this.__actions__),e.__dir__=this.__dir__,e.__filtered__=this.__filtered__,e.__iteratees__=Lo(this.__iteratees__),e.__takeCount__=this.__takeCount__,e.__views__=Lo(this.__views__),e},Qn.prototype.reverse=function(){if(this.__filtered__){var e=new Qn(this);e.__dir__=-1,e.__filtered__=!0}else(e=this.clone()).__dir__*=-1;return e},Qn.prototype.value=function(){var e=this.__wrapped__.value(),t=this.__dir__,n=$a(e),r=t<0,o=n?e.length:0,i=function(e,t,n){for(var r=-1,o=n.length;++r<o;){var i=n[r],a=i.size;switch(i.type){case"drop":e+=a;break;case"dropRight":t-=a;break;case"take":t=mn(t,e+a);break;case"takeRight":e=yn(e,t-a)}}return{start:e,end:t}}(0,o,this.__views__),a=i.start,l=i.end,c=l-a,u=r?l:a-1,s=this.__iteratees__,f=s.length,p=0,d=mn(c,this.__takeCount__);if(!n||!r&&o==c&&d==c)return po(e,this.__actions__);var h=[];e:for(;c--&&p<d;){for(var v=-1,g=e[u+=t];++v<f;){var y=s[v],m=y.iteratee,x=y.type,b=m(g);if(2==x)g=b;else if(!b){if(1==x)continue e;break e}}h[p++]=g}return h},Wn.prototype.at=va,Wn.prototype.chain=function(){return da(this)},Wn.prototype.commit=function(){return new Fn(this.value(),this.__chain__)},Wn.prototype.next=function(){this.__values__===o&&(this.__values__=dl(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?o:this.__values__[this.__index__++]}},Wn.prototype.plant=function(e){for(var t,n=this;n instanceof Un;){var r=Di(n);r.__index__=0,r.__values__=o,t?i.__wrapped__=r:t=r;var i=r;n=n.__wrapped__}return i.__wrapped__=e,t},Wn.prototype.reverse=function(){var e=this.__wrapped__;if(e instanceof Qn){var t=e;return this.__actions__.length&&(t=new Qn(this)),(t=t.reverse()).__actions__.push({func:ha,args:[ta],thisArg:o}),new Fn(t,this.__chain__)}return this.thru(ta)},Wn.prototype.toJSON=Wn.prototype.valueOf=Wn.prototype.value=function(){return po(this.__wrapped__,this.__actions__)},Wn.prototype.first=Wn.prototype.head,at&&(Wn.prototype[at]=function(){return this}),Wn}();it._=un,(r=function(){return un}.call(t,n,t,e))===o||(e.exports=r)}.call(this)},666:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>i});const r=window.$,o={minBracketWidth:6,interpretDashing:(e,t)=>{void 0!==e.dashed&&"dashed"===e.dashed&&(e.dashWidth?t["stroke-dasharray"]=e.dashWidth:t["stroke-dasharray"]=4)},generateArrowHeadElem:(e,t)=>{const n="arrowHead-"+(new Date).getTime(),r=document.createElementNS("http://www.w3.org/2000/svg","defs"),i=o.makeSvgElement("marker",{id:n,viewBox:"0 0 10 10",refX:8.7,refY:3,markerUnits:"strokeWidth",markerWidth:t,markerHeight:t,orient:"auto",stroke:e,fill:e}),a=o.makeSvgElement("path",{d:"M 0,0 L0,6 L9,3 z"});return i.appendChild(a),r.appendChild(i),{arrowHeadId:n,defs:r}},makeElementHtml:(e,t,n)=>{let o="<"+e+" ";"svg"===e&&(o+='xmlns="http://www.w3.org/2000/svg" version="1.1" class="bxySvg" ');let i="";return void 0!==t&&(i=r.map(t,((e,t)=>t+'="'+e+'"')).join(" ")),o+=void 0!==n?i+">"+n+"</"+e+">":i+"></"+e+">",o},makeSvgElement:(e,t)=>{const n=document.createElementNS("http://www.w3.org/2000/svg",e);"svg"===e&&(n.setAttribute("xmlns","http://www.w3.org/2000/svg"),n.setAttribute("version","1.1"),n.setAttribute("preserveAspectRatio","none"));for(let e in t)n.setAttribute(e,t[e]);return void 0!==t.text&&(n.textContent=t.text),n},makeDomElement:(e,t)=>{const n=document.createElement(e);for(let e in t)n.setAttribute(e,t[e]);return n},renderSvg:(e,t,n,i,a,l,c)=>{let u,s,f,p,d=r("#bxySvgGenerator");0===d.length&&(r("body").append(r('<div id="bxySvgGenerator"></div>')),d=r("#bxySvgGenerator"));for(let t of e){let e="";t.hasOwnProperty("cssTransform")&&(e="transform:"+t.cssTransform);let n="";t.hasOwnProperty("backgroundColor")&&(n="background:"+t.backgroundColor+";");let r="";t.hasOwnProperty("border")&&(r="border:"+t.border+";"),f={class:t.outerClass,style:"position:absolute;left:"+parseInt(t.x)+"px;top:"+parseInt(t.y)+"px;width:"+parseInt(t.width)+"px;height:"+parseInt(t.height)+"px;"+e+n+r},t.hasOwnProperty("title")&&(f.title=t.title),t.hasOwnProperty("metaTag")&&(p=t.metaTag.split("|"),f[p[0]]=p[1]),u=o.makeDomElement("div",f),s=o.makeSvgElement("svg",{width:t.width,height:t.height,viewBox:t.viewBox}),t.usesArrow&&s.appendChild(t.arrowHeadRecord.defs),s.appendChild(t.el),u.appendChild(s),d[0].appendChild(u)}const h=d[0].innerHTML;return d.empty(),h},makeLine:e=>{const t=e.endpoints,n=t.p1,r=t.p2,i={p1:{x:Math.min(n.x,r.x),y:Math.min(n.y,r.y)},p2:{x:Math.max(n.x,r.x),y:Math.max(n.y,r.y)}},a=void 0===e.color?"#000":e.color,l=void 0===e.strokeWidth?3:e.strokeWidth;let c;c=r.x<n.x&&r.y<n.y?{p1:{x:i.p2.x,y:i.p2.y},p2:{x:i.p1.x,y:i.p1.y}}:r.x<n.x?{p1:{x:i.p2.x,y:i.p1.y},p2:{x:i.p1.x,y:i.p2.y}}:r.y<n.y?{p1:{x:i.p1.x,y:i.p2.y},p2:{x:i.p2.x,y:i.p1.y}}:{p1:{x:i.p1.x,y:i.p1.y},p2:{x:i.p2.x,y:i.p2.y}};let u,s={"vector-effect":"non-scaling-stroke","stroke-width":l,stroke:a,fill:a,d:"M "+(c.p1.x-i.p1.x)+" "+(c.p1.y-i.p1.y)+" L "+(c.p2.x-i.p1.x)+" "+(c.p2.y-i.p1.y)};void 0!==e.usesArrow&&(u=o.generateArrowHeadElem(e.color,e.arrowHeadSize),s["marker-end"]="url(#"+u.arrowHeadId+")"),o.interpretDashing(e,s);const f=o.makeSvgElement("path",s),p=[-10,-10,Math.max(20,Math.abs(i.p2.x-i.p1.x)+20),Math.max(20,Math.abs(i.p2.y-i.p1.y)+20)];return o.renderSvg([{el:f,x:i.p1.x+e.lineStartOffset.x-10,y:i.p1.y+e.lineStartOffset.y-10,width:p[2],height:p[3],color:a,viewBox:p.join(" "),usesArrow:e.usesArrow,arrowHeadRecord:u,arrowHeadSize:e.arrowHeadSize}])},makeEllipse:e=>{const t=e.dimensions,n=e.buffer||4,r="0 0 "+t.width+" "+t.height,i=o.makeBufferedViewBox({buffer:n,bufferAllSides:!0,viewBox:r});let a={cx:t.width/2,cy:t.height/2,rx:Math.max(0,t.width/2-e.buffer),ry:Math.max(0,t.height/2-e.buffer),stroke:e.color,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity,fill:e.color};o.interpretDashing(e,a);const l={el:o.makeSvgElement("ellipse",a),x:t.x,y:t.y,width:t.width,height:t.height,viewBox:i};return o.renderSvg([l])},makeBullsEye:e=>{const t=e.dimensions,n=e.buffer||4,r="0 0 "+t.width+" "+t.height,i=o.makeBufferedViewBox({buffer:n,bufferAllSides:!0,viewBox:r});let a,l,c=[];const u=[1,5,9,13,17,3,7,11,15],s=void 0!==e.innerRingsColor?e.innerRingsColor:e.color,f=[e.color,e.color,e.color,e.color,e.color,s,s,s,s],p=[e.color,e.color,e.color,e.color,e.color,s,s,s,s];for(let n=0;n<u.length;++n)a={cx:t.width/2,cy:t.height/2,rx:u[n],ry:u[n],stroke:f[n],"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity,fill:p[n]},l=o.makeSvgElement("ellipse",a),c.push({el:l,x:t.x,y:t.y,width:t.width,height:t.height,viewBox:i});return o.renderSvg(c)},makeBufferedViewBox:e=>{const t=2*e.buffer;let n,r;return r="string"==typeof e.viewBox?e.viewBox.split(" "):e.viewBox,n=e.bufferAllSides?[parseInt(r[0])-e.buffer,parseInt(r[1])-e.buffer,parseInt(r[2])+t,parseInt(r[3])+t]:[parseInt(r[0]),parseInt(r[1]),parseInt(r[2])+t,parseInt(r[3])+t],n.join(" ")},makeSimplePath:e=>{const t=void 0===e.buffer?4:e.buffer,n=2*t,r=o.makeBufferedViewBox({buffer:t,bufferAllSides:!0,viewBox:e.viewBox}),i=void 0===e.color?"#000":e.color,a=void 0===e.strokeWidth?3:e.strokeWidth,l=void 0===e.outerClass?"bxy-sticker-inner":e.outerClass;let c,u,s,f=[];for(let p of e.d)c={"vector-effect":"non-scaling-stroke","stroke-width":a,stroke:i,d:p},void 0!==e.fill?c.fill=e.fill:c["fill-opacity"]=0,void 0!==e.transform&&(c.transform=e.transform),void 0!==e.fillOpacity&&(c["fill-opacity"]=e.fillOpacity,c.fill=e.color),o.interpretDashing(e,c),u=o.makeSvgElement("path",c),s={el:u,x:e.dimensions.x-t,y:e.dimensions.y-t,width:e.dimensions.width+n,height:e.dimensions.height+n,outerClass:l,title:e.title,viewBox:r},void 0!==e.cssTransform&&(s.cssTransform=e.cssTransform),void 0!==e.metaTag&&(s.metaTag=e.metaTag),f.push(s);return o.renderSvg(f)},makeRightCurlyBracePath:e=>{let t={stroke:e.color,"stroke-width":e.strokeWidth||"3","vector-effect":"non-scaling-stroke","fill-opacity":0,d:"M0,0 A100, 173.20508075688772 0 0 1  100, 173.20508075688772 A100, 173.20508075688772 0 0 0 200 346.41016151377545 A100, 173.20508075688772 0 0 0 100, 519.6152422706632 A100, 173.20508075688772 0 0 1 0, 692.8203230275509"};return o.interpretDashing(e,t),o.makeSvgElement("path",t)},makeLeftCurlyBrace:e=>{const t=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:t,width:8,height:e.dimensions.height,viewBox:"0 0 200 692",x:e.dimensions.x,y:e.dimensions.y,cssTransform:"scaleX(-1)"}])},makeRightCurlyBrace:e=>{const t=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:t,width:8,height:e.dimensions.height,viewBox:"0 0 200 692",x:e.dimensions.x,y:e.dimensions.y}])},makeSymmetricCurlyBraces:e=>{const t="0 0 200 692",n=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth}),r=o.makeRightCurlyBracePath({dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth});return o.renderSvg([{el:n,width:8,height:e.dimensions.height,viewBox:t,x:e.dimensions.x-1,y:e.dimensions.y,cssTransform:"scaleX(-1)"},{el:r,width:8,height:e.dimensions.height,viewBox:t,x:e.dimensions.x+e.dimensions.width-8+1,y:e.dimensions.y,dashed:e.dashed,color:e.color,strokeWidth:e.strokeWidth}])},makeTopBracket:e=>{const t=e.dimensions.width,n=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,t,n],d:["M 0 "+n+" L 0 0 L "+t+" 0 L "+t+" "+n]}))},makeBottomBracket:e=>{const t=e.dimensions.width,n=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,t,n],d:["M 0 0 L 0 "+n+" L "+t+" "+n+" L "+t+"0"]}))},makeLeftBracket:e=>{const t=e.dimensions.width,n=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,t,n],d:["M "+t+" "+n+" L 0 "+n+" L 0 0 L "+t+" 0"]}))},makeRightBracket:e=>{const t=e.dimensions.width,n=e.dimensions.height;return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,t,n],d:["M 0 0 L "+t+" 0 L "+t+" "+n+" L 0 "+n]}))},makeHorizontalBrackets:e=>{const t=e.dimensions.width,n=e.dimensions.height,i=Math.min(o.minBracketWidth,parseInt(n/10)),a=Math.max(n-o.minBracketWidth,n-parseInt(n/10));return o.makeSimplePath(r.extend({},!0,e,{buffer:0,viewBox:[0,0,t,n],d:["M 0 "+i+" L 0 0 L "+t+" 0 L "+t+" "+i,"M 0 "+a+" L 0 "+n+" L "+t+" "+n+" L "+t+" "+a]}))},makeVerticalBrackets:e=>{const t=e.dimensions.width,n=e.dimensions.height,i=Math.min(o.minBracketWidth,parseInt(t/10)),a=Math.max(t-o.minBracketWidth,t-parseInt(t/10));return o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,t,n],d:["M "+i+" 0 L 0 0 L 0 "+n+" L "+i+" "+n,"M "+a+" 0 L "+t+" 0 L "+t+" "+n+" L "+a+" "+n]}))},makeRectangle:e=>{const t=e.dimensions,n=e.buffer||4,r="0 0 "+t.width+" "+t.height,i=o.makeBufferedViewBox({buffer:n,bufferAllSides:!0,viewBox:r});let a={x:0,y:0,width:t.width,height:t.height,stroke:e.color,fill:e.color,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity};o.interpretDashing(e,a),void 0!==e.rx&&(a.rx=e.rx,a.ry=e.ry);const l={el:o.makeSvgElement("rect",a),x:t.x,y:t.y,width:t.width,height:t.height,viewBox:i};return o.renderSvg([l])},makeRightTriangle:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 0 0 Z"]})),makeIsocelesTriangle:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 50 0 Z"]})),makeTheta:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,469,700],d:["M469 334c-2,440 -453,468 -469,2 -13,-435 472,-460 469,-2zm-383 -20l298 0c-9,-366 -288,-376 -298,-6l0 6zm297 46l-297 0c16,345 279,397 297,11 0,-4 0,-7 0,-11z"],fill:e.color})),makeSigma:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,16,16],d:["M2,1l5.46,7.27L2,15h12v-4h-1v1c0,0.552-0.448,1-1,1H4.97l4.39-5.52L5.25,2H12c0.552,0,1,0.448,1,1v1h1V1H2z"],fill:e.color})),makeSmiley:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,49,49],d:["M25,1A24,24,0,1,0,49,25,24,24,0,0,0,25,1Zm0,46A22,22,0,1,1,47,25,22,22,0,0,1,25,47ZM35.77,33.32a1,1,0,0,1-.13,1.41C31.73,38,28.06,39.1,24.9,39.1a16,16,0,0,1-10.63-4.45,1,1,0,0,1,1.45-1.38c0.34,0.35,8.35,8.52,18.63-.08A1,1,0,0,1,35.77,33.32ZM15,19a3,3,0,1,1,3,3A3,3,0,0,1,15,19Zm14,0a3,3,0,1,1,3,3A3,3,0,0,1,29,19Z"],fill:e.color})),makeFrowney:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,125],d:["M50,2.5C23.809,2.5,2.5,23.809,2.5,50S23.809,97.5,50,97.5S97.5,76.191,97.5,50S76.191,2.5,50,2.5z M50,91.684    C27.016,91.684,8.316,72.984,8.316,50S27.016,8.316,50,8.316S91.684,27.016,91.684,50S72.984,91.684,50,91.684z M37.489,41.386    c2.964,0,5.369-2.403,5.369-5.369c0-2.966-2.405-5.368-5.369-5.368c-2.966,0-5.369,2.402-5.369,5.368    C32.12,38.982,34.523,41.386,37.489,41.386z M62.511,41.386c2.965,0,5.369-2.403,5.369-5.369c0-2.966-2.404-5.368-5.369-5.368    c-2.966,0-5.368,2.402-5.368,5.368C57.143,38.982,59.545,41.386,62.511,41.386z M50.001,51.186    c-13.939,0-20.525,9.548-22.06,14.597c-0.467,1.537,0.399,3.161,1.936,3.628c1.539,0.471,3.161-0.399,3.628-1.936    c0.032-0.105,3.336-10.473,16.496-10.473c13.015,0,16.363,10.061,16.494,10.472c0.381,1.255,1.534,2.063,2.781,2.063    c0.28,0,0.564-0.04,0.846-0.127c1.538-0.467,2.405-2.091,1.938-3.627C70.524,60.733,63.939,51.186,50.001,51.186z"]})),makeThumbsUp:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,218,346.25],d:["M28 263l31 -9c64,42 77,13 92,10 4,0 1,4 17,0 22,-7 31,-19 23,-35 19,-6 21,-18 15,-33 15,-9 15,-26 3,-38 19,-37 -11,-67 -80,-48 -5,-36 11,-59 5,-80 -7,-27 -25,-31 -50,-30 3,68 8,35 -25,101 -27,55 -3,48 -57,63 -6,36 4,70 26,99zm4 -12c-16,-24 -23,-49 -21,-77 48,-14 33,-15 57,-65 33,-71 31,-34 27,-97 31,1 32,26 26,50 -7,27 -6,40 -1,62 26,-7 74,-21 82,6 7,27 -22,40 -35,41l-42 -7c9,-28 36,-19 44,-19l10 -3 7 -13c-29,8 -10,3 -31,4 -24,1 -40,15 -43,40l8 1c-8,7 -13,16 -14,28l9 1c-5,6 -10,15 -12,26l14 3c-5,7 -9,15 -11,26l29 4c-29,10 -50,-1 -74,-20l-29 9zm87 -58c12,-30 27,-10 49,-12 5,0 27,-7 33,-14 24,20 -36,32 -39,33l-43 -7zm-2 27l10 -15c44,7 28,8 70,-4 10,19 -35,26 -35,26l-45 -7zm3 30l9 -17c36,5 26,7 53,0 4,16 -17,22 -23,22l-39 -5z"],fill:e.color})),makeThumbsDown:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,226,357.5],d:["M18 27l33 4c59,-51 77,-23 92,-23 5,0 0,-4 18,-2 23,3 33,15 28,32 20,4 24,15 20,32 17,7 19,23 8,37 25,36 -1,70 -74,60 0,38 19,59 16,82 -3,27 -21,34 -46,37 -6,-70 3,-37 -40,-99 -35,-52 -10,-48 -67,-56 -11,-36 -6,-71 12,-104zm6 12c-13,26 -16,53 -10,81 51,7 35,11 67,58 44,66 36,29 41,95 32,-7 29,-32 19,-55 -11,-27 -11,-40 -9,-63 27,4 78,10 82,-18 4,-28 -28,-37 -41,-36l-42 13c13,27 39,14 48,13l10 1 9 12c-30,-4 -10,-1 -33,1 -23,2 -41,-9 -49,-34l8 -3c-8,-6 -15,-14 -18,-26l9 -3c-6,-5 -11,-13 -16,-24l15 -5c-7,-6 -12,-15 -15,-25l28 -8c-30,-7 -50,8 -72,30l-31 -4zm96 46c17,28 30,7 52,5 6,-1 29,4 36,9 21,-23 -42,-27 -44,-27l-44 13zm-5 -27l12 14c44,-13 27,-12 72,-6 7,-21 -39,-22 -40,-22l-44 14zm-1 -31l11 16c36,-11 26,-11 54,-7 2,-18 -20,-20 -27,-20l-38 11z"],fill:e.color})),makeStar:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,1024,1280],d:["M521.19122173 257.59668148l48.67463902 112.36592198c10.61521383 24.46677333 33.65799506 41.42522469 60.32548344 44.14375505l123.62840495 12.55702124-92.30057877 79.48464988c-20.71261235 17.86462815-29.90383408 45.43829333-23.8195042 72.10578173l27.44421136 121.68659752-105.37541531-64.20909827c-11.52139061-6.99050667-24.85513482-10.74466765-38.31833283-10.74466765-13.59265185 0-26.79694222 3.75416098-38.31833286 10.74466765l-105.37541529 64.20909827 27.44421135-121.68659752c5.95487605-26.66748839-3.10689185-54.24115358-23.8195042-72.10578173l-92.30057876-79.48464988 123.62840494-12.55702124c26.53803457-2.71853037 49.71026963-19.5475279 60.32548346-44.14375505l48.1568237-112.36592198m0-117.80298272c-6.2137837 0-12.55702124 3.3657995-15.40500543 10.09739852l-85.43952593 197.28763258c-2.45962272 5.56651457-7.63777581 9.45012939-13.72210568 10.09739853l-216.446799 22.00715063c-14.7577363 1.55344592-20.45370469 19.80643555-9.32067556 29.51547258l163.11182222 140.45740248c4.66033778 4.01306864 6.86105283 10.35630617 5.43706074 16.44063605l-48.1568237 213.98717629c-2.58907653 11.26248297 6.34323753 20.58315852 16.44063604 20.58315852 2.84798419 0 5.95487605-0.77672297 8.67340642-2.45962272l186.15460346-113.40155259c2.71853037-1.68289975 5.69596839-2.45962272 8.80286024-2.45962272s6.08432987 0.77672297 8.80286026 2.45962272l186.15460344 113.40155259c2.84798419 1.68289975 5.82542222 2.45962272 8.67340644 2.45962272 10.09739852 0 19.02971259-9.32067555 16.44063604-20.58315852L693.23535803 565.69679013c-1.4239921-6.08432987 0.77672297-12.42756741 5.43706073-16.44063605l163.11182222-140.45740248c11.26248297-9.70903703 5.43706075-27.96202667-9.32067555-29.51547258l-216.44679901-22.00715063c-6.08432987-0.64726914-11.26248297-4.40143013-13.72210567-10.09739853l-85.43952593-197.28763258c-3.23634569-6.73159902-9.45012939-10.09739852-15.66391309-10.09739852z"],fill:e.color})),makeRibbon:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:"0 0 100 100",d:["M76.979,12.22c-0.366-0.579-1.004-0.93-1.689-0.93H59.165c-0.768,0-1.468,0.439-1.802,1.132l-6.634,13.76l-7.117-13.808  c-0.343-0.666-1.028-1.084-1.777-1.084H24.71c-0.686,0-1.323,0.351-1.689,0.93c-0.367,0.579-0.411,1.306-0.118,1.926l15.213,32.151  c-6.585,4.021-10.99,11.274-10.99,19.538C27.125,78.448,37.387,88.71,50,88.71s22.875-10.262,22.875-22.875  c0-8.264-4.405-15.518-10.99-19.538l15.213-32.151C77.391,13.525,77.347,12.799,76.979,12.22z M27.869,15.29h12.747l14.572,28.271  C53.521,43.172,51.785,42.96,50,42.96c-2.927,0-5.724,0.559-8.299,1.564L27.869,15.29z M68.875,65.835  c0,10.407-8.468,18.875-18.875,18.875s-18.875-8.468-18.875-18.875S39.593,46.96,50,46.96S68.875,55.428,68.875,65.835z   M59.201,42.617l-6.178-11.984l7.397-15.343h11.71L59.201,42.617z M48.207,53.277l-2.999,6.074l-6.703,0.973  c-0.754,0.109-1.38,0.638-1.615,1.361s-0.039,1.519,0.506,2.051l4.852,4.728l-1.146,6.677c-0.128,0.75,0.181,1.509,0.796,1.956  c0.349,0.253,0.762,0.382,1.176,0.382c0.318,0,0.638-0.076,0.931-0.229L50,74.098l5.994,3.151c0.675,0.353,1.491,0.295,2.106-0.152  s0.924-1.206,0.796-1.956l-1.145-6.677l4.852-4.728c0.545-0.532,0.741-1.327,0.506-2.051s-0.861-1.252-1.615-1.361l-6.703-0.973  l-2.997-6.074c-0.337-0.683-1.032-1.115-1.794-1.115C49.239,52.162,48.544,52.595,48.207,53.277z M51.669,62.064  c0.292,0.591,0.855,1,1.507,1.095l3.732,0.542l-2.7,2.632c-0.472,0.46-0.687,1.122-0.576,1.771l0.638,3.72l-3.339-1.756  c-0.582-0.307-1.279-0.307-1.861,0l-3.34,1.756l0.638-3.72c0.11-0.648-0.104-1.311-0.575-1.771l-2.701-2.632l3.732-0.542  c0.651-0.095,1.215-0.504,1.506-1.095L50,58.682L51.669,62.064z"],fill:e.color})),makeAxis:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 90 90",d:["M89.7,85.7c0,0.2-0.1,0.3-0.2,0.4l-3.2,2.2c-0.1,0.1-0.2,0.1-0.3,0.1c-0.1,0-0.2,0-0.2-0.1c-0.2-0.1-0.3-0.3-0.3-0.4v-1.2  H13c-0.6,0-1-0.4-1-1V15.8h-1.2c-0.2,0-0.4-0.1-0.4-0.3c-0.1-0.2-0.1-0.4,0-0.5l2.2-3.2c0.2-0.3,0.6-0.3,0.8,0l2.2,3.2  c0.1,0.2,0.1,0.4,0,0.5c-0.1,0.2-0.3,0.3-0.4,0.3H14v68.9h71.4v-1.2c0-0.2,0.1-0.4,0.3-0.4c0.2-0.1,0.4-0.1,0.5,0l3.2,2.2  C89.6,85.4,89.7,85.6,89.7,85.7z"],fill:"solid"})),makeBomb:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 100 100",d:["M44.5,44.4v-3.9c0-1.1-0.9-2-2-2h-5.6c0-2.2,0.3-5.1,1.8-6.9c1.1-1.3,2.6-1.9,4.7-1.9c3.1,0,6.1,1.2,8.9,2.3  c5.4,2.2,11.1,4.4,16.9-1.6c0.6-0.6,0.6-1.5,0-2.1c-0.6-0.6-1.5-0.6-2.1,0c-4.4,4.6-8.5,3-13.6,0.9c-3.1-1.3-6.4-2.6-10-2.6  c-3,0-5.3,1-7,3c-2.2,2.6-2.5,6.3-2.5,8.8h-5.1c-1.1,0-2,0.9-2,2v3.9C18.3,47.9,12.3,56.3,12.3,66c0,12.9,10.4,23.3,23.3,23.3  S59,78.9,59,66C59,56.3,53,47.9,44.5,44.4z M32.9,80.3c-0.2,0.6-0.8,1.1-1.4,1.1c-0.1,0-0.3,0-0.4-0.1c-6.8-2-11.3-8.2-11.3-15.3  c0-3.5,1.1-6.9,3.3-9.7c0.5-0.7,1.4-0.8,2.1-0.3c0.7,0.5,0.8,1.4,0.3,2.1c-1.7,2.3-2.7,5-2.7,7.9c0,5.7,3.8,10.8,9.2,12.4  C32.7,78.6,33.2,79.5,32.9,80.3z","M82.3,14.5c0.5-0.6,0.5-1.6-0.2-2.1c-0.6-0.5-1.6-0.5-2.1,0.2l-8.6,10.1c-0.5,0.6-0.5,1.6,0.2,2.1c0.3,0.2,0.6,0.4,1,0.4  c0.4,0,0.8-0.2,1.1-0.5L82.3,14.5z","M60.7,13.9C60.7,13.9,60.7,13.9,60.7,13.9l3.9,8.7c0,0,0,0,0,0l0.5,1.1c0.3,0.6,0.8,0.9,1.4,0.9c0.2,0,0.4,0,0.6-0.1  c0.8-0.3,1.1-1.2,0.7-2l-0.5-1.1c0,0,0,0,0,0l-3.9-8.7c0,0,0,0,0,0l-0.5-1.1c-0.3-0.8-1.2-1.1-2-0.7c-0.8,0.3-1.1,1.2-0.7,2  L60.7,13.9z","M75.5,32.4c-0.6-0.6-1.6-0.5-2.1,0.1c-0.6,0.6-0.5,1.6,0.1,2.1l9.7,9.2c0.3,0.3,0.7,0.4,1,0.4c0.4,0,0.8-0.2,1.1-0.5  c0.6-0.6,0.5-1.6-0.1-2.1L75.5,32.4z","M86.2,26.6l-10.5,0c-0.8,0-1.5,0.7-1.5,1.5c0,0.8,0.7,1.5,1.5,1.5l10.5,0c0.8,0,1.5-0.7,1.5-1.5  C87.7,27.3,87,26.6,86.2,26.6z","M50.9,21.7l11.6,5.4c0.2,0.1,0.4,0.1,0.6,0.1c0.6,0,1.1-0.3,1.4-0.9c0.4-0.8,0-1.6-0.7-2L52.2,19c-0.7-0.4-1.6,0-2,0.7  C49.9,20.5,50.2,21.3,50.9,21.7z","M69.5,34.8c-0.8,0-1.5,0.7-1.5,1.5l0,11.3c0,0.8,0.7,1.5,1.5,1.5c0.8,0,1.5-0.7,1.5-1.5l0-11.3C71,35.4,70.4,34.8,69.5,34.8  z"],fill:e.color})),makeCheckmark:e=>{let t;return t=e.iconUsage?r.extend({},e.dimensions):{x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25),height:Math.max(e.dimensions.height,25)},o.makeSimplePath(r.extend({},!0,e,{strokeWidth:e.strokeWidth,viewBox:"0 0 587 783.75",d:["M0 303c61,65 122,129 184,194 134,-166 227,-376 403,-497 -181,160 -285,402 -400,627 -62,-108 -125,-216 -187,-324z"],color:"#090",fill:"#4f4",dimensions:t,dashed:void 0}))},makeXmark:e=>{let t,n;return e.iconUsage?(t=r.extend({},e.dimensions),n=e.strokeWidth):(n=5,t={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25),height:Math.max(e.dimensions.height,25)}),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:n,viewBox:"0 0 100 100",d:["M10 10 L 80 80 M 80 10 L 10 80"],color:"red",dimensions:t,dashed:void 0}))},makePi:e=>{let t,n;return e.iconUsage?(t=r.extend({},e.dimensions),n=e.strokeWidth):(n=1,t={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},t.height=t.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:n,viewBox:"0 0 110 137.5",d:["M21.33,40.487h-3.057c0,0,2.938-21.636,19.974-21.636s53.479,0,53.479,0v11.337H74.157c0,0-3.265,22.259-3.265,34.25  c0,11.989,7.242,14.363,10.091,14.363s7.479-5.46,7.479-6.528c0-1.069,0-2.612,0-2.612h3.265c0,0-1.009,21.487-15.848,21.487  c-14.84,0-13.415-24.93-13.296-25.761c0.118-0.831,3.087-35.021,3.087-35.021H47.15c0,0-0.514,26.395-2.256,34.151  c-1.741,7.756-3.481,26.631-13.139,26.631c-9.654,0-6.171-8.586-6.013-9.379c0.157-0.791,7.122-10.289,8.705-14.72  c1.582-4.432,3.799-36.723,3.799-36.723s-9.676-1.613-13.296,4.273C21.33,40.487,21.33,40.487,21.33,40.487z"],color:e.color,fill:e.color,dimensions:t,dashed:void 0}))},makeAlpha:e=>{let t,n;return e.iconUsage?(t=r.extend({},e.dimensions),n=e.strokeWidth):(n=1,t={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},t.height=t.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:n,viewBox:"0 0 1000 1250",d:["M893 755c14,-17 39,-19 56,-5 17,15 19,40 4,57 -181,211 -273,23 -329,-153 -254,411 -603,196 -586,-174 16,-346 418,-629 607,-33 47,-101 88,-205 131,-308 9,-20 32,-30 52,-22 21,9 30,32 22,53 -54,130 -106,263 -172,388 37,123 74,361 215,197zm-300 -204c-166,-554 -461,-392 -476,-68 -15,337 264,458 476,68z"],color:e.color,fill:e.color,dimensions:t,dashed:void 0}))},makeBeta:e=>{let t,n;return e.iconUsage?(t=r.extend({},e.dimensions),n=e.strokeWidth):(n=1,t={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},t.height=t.width),o.makeSimplePath(r.extend({},!0,e,{strokeWidth:n,viewBox:"0 0 1000 1250",d:["M291 982c-15,8 -33,2 -40,-13 -8,-14 -3,-32 12,-40 64,-34 46,-199 28,-374 -13,-118 -26,-241 -14,-338 16,-131 74,-218 227,-200 10,2 21,4 32,8 32,11 64,34 86,66 23,33 35,75 29,126 -2,16 -6,33 -12,51 -6,15 -12,30 -20,44 23,10 44,26 63,46 28,31 50,73 61,118 12,45 14,93 2,137 -28,111 -133,196 -358,138 -10,-2 -17,-9 -21,-18 5,118 -8,213 -75,249zm61 -448c6,56 12,112 15,164 5,-15 21,-24 36,-20 182,46 265,-14 286,-95 9,-34 8,-72 -2,-108 -9,-35 -25,-68 -47,-92 -17,-17 -36,-30 -58,-34 -12,13 -24,23 -36,32 -15,11 -29,18 -42,22 -19,5 -36,4 -50,-6 -8,-6 -15,-15 -18,-27 -3,-11 1,-23 9,-30l0 0c38,-35 76,-52 112,-55 11,-15 21,-33 27,-52 5,-14 8,-27 10,-39 4,-34 -4,-63 -19,-84 -15,-21 -36,-36 -57,-44 -7,-2 -13,-4 -20,-4 -107,-14 -148,50 -160,147 -11,91 2,210 14,325z"],color:e.color,fill:e.color,dimensions:t,dashed:void 0}))},makeGrid:e=>{let t,n;e.iconUsage?(t=r.extend({},e.dimensions),n=e.strokeWidth):(n=1,t={x:e.dimensions.x,y:e.dimensions.y,width:Math.max(e.dimensions.width,25)},t.height=t.width);const i=o.makeBufferedViewBox({buffer:5,viewBox:[0,0,100,100]});let a,l,c="";for(a=0;a<=10;++a)l=10*a,c+="M 0 "+l+" L 100 "+l+" ",c+="M "+l+" 0 L "+l+" 100 ";return o.makeSimplePath(r.extend({},!0,e,{strokeWidth:n,viewBox:i,d:[c],dimensions:t,dashed:void 0}))},makeRightSideMarker:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,50],d:["M 0 25 L 25 0 L 100 0 L 100 50 L 25 50 Z"],fill:e.color,outerClass:"bxy-right-side-marker",buffer:0})),makeAngle:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,30,35],transform:"translate(-390 -560)",d:["M401.883,578.324l12.971-12.971l-0.707-0.707L390.793,588H419v-1h-13.524    C405.357,583.749,404.098,580.706,401.883,578.324z M393.207,587l7.969-7.969c2.026,2.192,3.183,4.984,3.3,7.969H393.207z"],fill:e.color})),makeTrophy:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:2,viewBox:[0,0,100,125],d:["M69.402,82.288H30.598c-0.855,0-1.548,0.692-1.548,1.548v8.462c0,0.857,0.693,1.55,1.548,1.55h38.804  c0.854,0,1.549-0.693,1.549-1.55v-8.462C70.951,82.98,70.258,82.288,69.402,82.288z","M93.357,15.879c-1.635-2.293-5.112-4.738-12.479-4.309c0.062-1.208,0.104-2.446,0.123-3.716  c0.017-0.94-0.681-1.703-1.537-1.703H20.536c-0.856,0-1.551,0.762-1.537,1.703c0.019,1.271,0.061,2.508,0.123,3.717  c-7.363-0.43-10.845,2.013-12.479,4.307c-2.331,3.271-2.174,8,0.428,12.978c3.722,7.119,12.165,14.247,22.486,16.61  C36.188,54.68,43.49,57.225,43.49,57.225h13.021c0,0,7.301-2.545,13.934-11.759c10.32-2.365,18.764-9.492,22.486-16.61  C95.532,23.88,95.688,19.15,93.357,15.879z M11.381,26.603c-1.723-3.295-2.007-6.175-0.778-7.9c1.311-1.838,4.444-2.606,8.914-2.228  c1.002,9.551,3.36,16.971,6.236,22.688C19.17,36.406,13.945,31.507,11.381,26.603z M63.782,24.541l-6.49,6.326l1.532,8.933  c0.105,0.611-0.256,0.872-0.803,0.584L50,36.166l-8.023,4.218c-0.547,0.288-0.907,0.026-0.803-0.584l1.533-8.933l-6.49-6.326  c-0.444-0.433-0.306-0.856,0.307-0.945l8.968-1.303l4.011-8.129c0.274-0.556,0.719-0.556,0.993,0l4.011,8.129l8.968,1.303  C64.088,23.685,64.227,24.109,63.782,24.541z M88.619,26.603c-2.564,4.904-7.789,9.804-14.372,12.561  c2.876-5.717,5.233-13.137,6.235-22.688c4.472-0.379,7.604,0.39,8.914,2.228C90.626,20.428,90.342,23.308,88.619,26.603z","M61.506,78.811c-6.724-9.961-5.283-18.379-5.283-18.379H43.777c0,0,1.44,8.418-5.284,18.379H61.506z"],fill:e.color})),makeButtonWithCursor:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 128 120" enable-background="new 0 0 128 128" xml:space="preserve"><path d="M120,28H8c-4.4,0-8,3.6-8,8v32c0,4.4,3.6,8,8,8h81.264l-0.955-4H8c-2.206,0-4-1.794-4-4V36c0-2.206,1.794-4,4-4h112  c2.206,0,4,1.794,4,4v32c0,1.907-1.343,3.5-3.132,3.898l0.358,0.109c1.417,0.431,2.569,1.364,3.32,2.56  C126.629,73.119,128,70.714,128,68V36C128,31.6,124.4,28,120,28z"/><path d="M114.174,81.744l5.973-2.11c0.815-0.288,1.353-1.066,1.333-1.931c-0.019-0.863-0.591-1.617-1.417-1.868l-25.48-7.748  c-0.686-0.21-1.431-0.034-1.952,0.456c-0.522,0.491-0.741,1.225-0.575,1.922l5.773,24.184c0.192,0.805,0.86,1.408,1.681,1.518  c0.82,0.106,1.623-0.297,2.02-1.023l3.009-5.509l9.558,9.766c0.391,0.398,0.909,0.601,1.431,0.601c0.452,0,0.907-0.153,1.28-0.464  l6.476-5.4c0.429-0.357,0.688-0.878,0.716-1.436c0.028-0.557-0.178-1.101-0.567-1.5L114.174,81.744z M115.662,95.281l-10.156-10.377  c-0.379-0.387-0.896-0.601-1.43-0.601c-0.091,0-0.183,0.006-0.274,0.019c-0.628,0.087-1.177,0.467-1.48,1.022l-1.811,3.315  l-3.756-15.732l16.32,4.963l-3.189,1.127c-0.645,0.228-1.128,0.768-1.282,1.434c-0.154,0.665,0.041,1.363,0.519,1.852l9.934,10.148  L115.662,95.281z"/></svg>',makeButton:e=>'<div class="button-icon" style="width:'+e.width+"px;height:"+e.height+'px;">'+e.contents+"</div>",makeTerminal:e=>{const t=parseInt(.9*e.width);return'<div class="terminal-icon" style="width:'+e.width+"px;height:"+t+'px;">&gt;_</div>'},makeLock:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M77.9,41.2h-0.3v-8.9c0-15-11.7-27.6-26.7-28.1c-15.5-0.5-28.3,12-28.3,27.5c0,1.2,1,2.1,2.1,2.1H33c0.9,0,1.7-0.7,1.7-1.7  c0-8.3,6.4-15.5,14.7-15.9c8.9-0.4,16.2,6.7,16.2,15.4v9.4H34.7h-12h-0.6c-4,0-7.3,3.2-7.3,7.3v40c0,4,3.2,7.2,7.2,7.2h55.8  c4,0,7.3-3.2,7.3-7.3v-40C85.1,44.5,81.9,41.2,77.9,41.2z M22.9,87.7v-7l5.5,7H22.9z M34.7,87.7L22.9,72.6v-2.9h4l14.1,18H34.7z   M47.3,87.7l-14.1-18h6.3l14.1,18H47.3z M60,87.7l-14.1-18h6.3l14.1,18H60z M77.1,87.7h-4.5l-14.1-18h6.3l12.3,15.7V87.7z   M77.1,77.3l-5.9-7.6h5.9V77.3z"],fill:e.color})),makeSimpleX:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M75.1,7.3L50,32.3L24.9,7.3c-1.2-1.2-3.1-1.2-4.2,0L5.8,22.1L33,49.3L5.8,76.5l14.8,14.8c1.2,1.2,3.1,1.2,4.2,0L50,66.3  l25.1,25.1c1.2,1.2,3.1,1.2,4.2,0l14.8-14.8L67,49.3l27.2-27.2L79.3,7.3C78.1,6.1,76.2,6.1,75.1,7.3z"],fill:e.color})),makeHidden:e=>o.makeSimplePath(r.extend({},!0,e,{strokeWidth:1,viewBox:[0,0,100,100],d:["M 8.9 46.05 Q 7.3 46.05 6.15 47.2 5 48.35 5 50 5 51.6 6.15 52.75 7.3 53.9 8.9 53.9 L 25.65 53.9 Q 27.3 53.9 28.45 52.75 29.6 51.6 29.6 50 29.6 48.35 28.45 47.2 27.3 46.05 25.65 46.05 L 8.9 46.05 M 37.05 68.5 Q 38.2 67.35 38.2 65.75 38.2 64.1 37.05 62.95 35.9 61.85 34.25 61.85 32.65 61.85 31.5 62.95 L 18.2 76.25 Q 17.05 77.4 17.05 79.05 17.05 80.65 18.2 81.8 19.35 82.95 20.95 82.95 22.6 82.95 23.75 81.8 L 37.05 68.5 M 52.75 71.55 Q 51.6 70.4 50 70.4 48.4 70.4 47.25 71.55 46.1 72.7 46.1 74.35 L 46.1 91.05 Q 46.1 92.7 47.25 93.85 48.4 95 50 95 51.6 95 52.75 93.85 53.9 92.7 53.9 91.05 L 53.9 74.35 Q 53.9 72.7 52.75 71.55 M 93.85 47.2 Q 92.7 46.05 91.1 46.05 L 74.35 46.05 Q 72.75 46.05 71.55 47.2 70.4 48.35 70.4 50 70.4 51.6 71.55 52.75 72.75 53.9 74.35 53.9 L 91.1 53.9 Q 92.7 53.9 93.85 52.75 95 51.6 95 50 95 48.35 93.85 47.2 M 81.8 81.8 Q 82.95 80.65 82.95 79.05 82.95 77.4 81.8 76.25 L 68.5 62.95 Q 67.4 61.85 65.75 61.85 64.1 61.85 62.95 62.95 61.85 64.1 61.85 65.75 61.85 67.35 62.95 68.5 L 76.3 81.8 Q 77.4 82.95 79.05 82.95 80.65 82.95 81.8 81.8 M 82.95 20.95 Q 82.95 19.3 81.8 18.15 80.65 17 79.05 17 77.4 17 76.3 18.15 L 62.95 31.45 Q 61.85 32.6 61.85 34.25 61.85 35.85 62.95 37 64.1 38.15 65.75 38.15 67.4 38.15 68.5 37 L 81.8 23.7 Q 82.95 22.55 82.95 20.95 M 53.9 8.9 Q 53.9 7.3 52.75 6.15 51.6 5 50 5 48.4 5 47.25 6.15 46.1 7.3 46.1 8.9 L 46.1 25.65 Q 46.1 27.25 47.25 28.4 48.4 29.55 50 29.55 51.6 29.55 52.75 28.4 53.9 27.25 53.9 25.65 L 53.9 8.9 M 23.75 18.15 Q 22.6 17 20.95 17 19.35 17 18.2 18.15 17.05 19.3 17.05 20.95 17.05 22.55 18.2 23.7 L 31.5 37 Q 32.65 38.15 34.25 38.15 35.9 38.15 37.05 37 38.2 35.85 38.2 34.25 38.2 32.6 37.05 31.45 L 23.75 18.15 Z"],fill:e.color})),makeRunningMan:e=>'<svg xmlns:x="http://ns.adobe.com/Extensibility/1.0/" xmlns:i="http://ns.adobe.com/AdobeIllustrator/10.0/" xmlns:graph="http://ns.adobe.com/Graphs/1.0/" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 85" style="enable-background:new 10 10 100 70;" xml:space="preserve"><switch><foreignObject requiredExtensions="http://ns.adobe.com/AdobeIllustrator/10.0/" x="0" y="0" width="1" height="1"/><g i:extraneous="self"><g fill-rule="evenodd" fill="'+e+'"><path d="M48.8,57.3c-0.8-0.5-1.4-1.2-1.8-2c-1.5,4.3-3.6,9.6-4.7,12.2c-2.9,0.1-9.5-0.6-14.9-1.5c-2.3-0.4-4.5,1.2-4.8,3.5     c-0.4,2.3,1.2,4.5,3.5,4.8c0.2,0,4.6,0.7,9.2,1.2c2.5,0.3,4.6,0.4,6.4,0.4c3.9,0,6.2-0.8,7.4-3c0.9-1.6,3-7.1,4.9-12.2     c-1.2-0.8-2.5-1.7-4-2.7C49.4,57.7,49,57.4,48.8,57.3z"/><path d="M97.4,43.5c-0.5-1.7-2.2-2.8-4-2.3c-0.8,0.2-6.7,1.8-10.3,2.8c-0.1-0.4-0.3-0.8-0.4-1.1c-1.4-4.1-3.5-10.3-8.9-12.4     c-1.2-0.5-4-1.7-5.8-2.5c-7.6-3.3-20.8,0.3-22.5,0.9c-0.9,0.4-2.9,1.1-8.7,12.5C36,43,36.7,45,38.3,45.8c0.5,0.2,1,0.4,1.5,0.4     c1.2,0,2.3-0.7,2.9-1.8c1.9-3.7,4.5-8.2,5.5-9.4c1.3-0.4,4.4-1.1,7.8-1.5c-3.7,5.1-7,13.2-7.6,16.1c-0.8,4.2,1,5.6,1.6,6     c1.4,1,14.2,9.5,16.1,11.5c-0.5,2.9-3.1,11.4-5.4,18.4c-0.7,2.2,0.5,4.6,2.7,5.3c0.4,0.1,0.9,0.2,1.3,0.2c1.8,0,3.4-1.1,4-2.9     c2.2-6.8,6-18.6,5.9-22c-0.1-3.3-3.1-6.2-9.7-10.7c2.1-5.2,5.6-12.7,8.9-16.6c1.2,1.8,2.1,4.3,2.7,6.2c1,2.8,1.6,4.8,3.5,5.7     c0.5,0.3,1.1,0.4,1.6,0.4c0.4,0,0.9-0.1,1.3-0.2c1.4-0.5,8-2.3,12.1-3.4C96.8,47,97.8,45.3,97.4,43.5z"/><ellipse transform="matrix(0.3937 -0.9192 0.9192 0.3937 28.3646 78.9709)" cx="74" cy="18" rx="9" ry="9"/><path d="M10.8,34.5h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H10.8c-1.4,0-2.5,1.1-2.5,2.5S9.5,34.5,10.8,34.5z"/><path d="M7.9,45h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H7.9c-1.4,0-2.5,1.1-2.5,2.5S6.5,45,7.9,45z"/><path d="M28.1,53c0-1.4-1.1-2.5-2.5-2.5H5c-1.4,0-2.5,1.1-2.5,2.5c0,1.4,1.1,2.5,2.5,2.5h20.7C27,55.5,28.1,54.4,28.1,53z"/></g></g></switch></svg>',makeScan:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><g><g fill-rule="evenodd" fill="'+e+'"><path d="M23.3,62.8H9.2C6.9,62.8,5,64.7,5,67v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C27.5,64.7,25.6,62.8,23.3,62.8z"/><path d="M90.8,62.8H76.7c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C95,64.7,93.1,62.8,90.8,62.8z"/><path d="M57.1,62.8H42.9c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C61.2,64.7,59.4,62.8,57.1,62.8z M57.1,81.1C57.1,81.1,57.1,81.1,57.1,81.1l-14.2,0c0,0,0,0,0,0l0-14.2c0,0,0,0,0,0h14.2    c0,0,0,0,0,0L57.1,81.1z"/><path d="M87.5,52.5l5-24.4l-9,3c-3.4-4.6-7.8-8.4-12.9-11.2c-6.2-3.4-13.3-5.2-20.6-5.2c-22.4,0-40.6,17-40.6,37.8    c0,1.7,1.4,3.1,3.1,3.1s3.1-1.4,3.1-3.1C15.6,35.1,31,20.9,50,20.9c10.7,0,20.7,4.6,27.2,12.2L68.8,36L87.5,52.5z"/></g></g></svg>',makeRabbit:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns" viewBox="0 0 100 75" version="1.1" x="0px" y="10px"><g stroke="none" stroke-width="1" fill-rule="evenodd" sketch:type="MSPage"><g sketch:type="MSArtboardGroup" transform="translate(0.000000, -7.000000)" fill="'+e+'"><path d="M60.1164483,76.5101184 C60.1164483,77.7869765 61.1184016,79.097951 62.3543737,79.4324469 L72.798828,82.2590697 C74.9502082,82.841306 76.9428079,85.1218308 77.229578,87.3473934 L77.4381368,88.9659749 L61.2268002,86.7611761 C59.0007748,86.4584288 55.762595,85.1122528 53.9830021,83.7528954 L30.0193357,65.4480423 C18.6673757,64.6909954 9.4627489,56.133214 7.77382209,45.1160791 L4.34635739,45.1647777 C1.94608449,45.1988816 -1.83318034e-16,43.2833095 -1.07537429e-17,40.8862227 L12.0835739,27.3645101 C17.4743573,21.3386402 23.6068695,17.4194231 31.6593886,17.4194231 C32.7498041,17.4194231 33.8233498,17.4912885 34.8755022,17.6305187 C36.0956627,17.7349159 37.3050822,17.9433886 38.4888396,18.2605754 C54.0954993,22.4423673 65.570761,42.6024939 65.570761,42.6024939 C66.516058,44.0861571 68.636741,45.6806441 70.3388841,46.136732 L71.0643059,46.3311082 C72.7686884,46.7877961 75.036606,46.0402598 76.1348435,44.6627794 L79.3667959,40.6090557 L69.0683577,35.5886404 C54.9830017,29.5 58.824985,11.8109045 58.824985,11.8109045 C58.9924242,10.7260817 59.7843012,10.4649372 60.587326,11.2216236 L82.7393229,32.0953411 L64.7779732,12.0675015 C65.0289152,8.20500861 68.1652109,7 68.1652109,7 L85.5324488,34.7272898 L86.921334,36.0360295 L96.0521825,42.4677019 C98.138955,43.9376022 99.8625925,47.2144004 99.8888571,49.7773535 L100.007257,61.3310185 L99.3236978,61.8899026 C97.5857982,63.3108255 94.5445704,63.6651439 92.5224884,62.6881932 L89.3807164,61.1702742 C86.2103299,59.6385304 81.4523901,60.2321429 78.7512966,62.4950512 L69.6842316,70.0912108 C68.6969982,70.9182902 67.3970043,71.7079683 65.972973,72.3860195 C65.450814,57.828347 59.4984737,45.9574271 46.7248907,37.1161254 C45.6127483,36.4326524 43.9592431,38.4195836 44.7777067,39.1109172 C56.0407574,49.2817354 60.1164483,60.3235994 60.1164483,74.5177084 L60.1164483,76.5101184 Z M95.0509461,53.9162538 C96.1764172,53.9162538 97.0887918,53.0084656 97.0887918,51.8886521 C97.0887918,50.7688386 96.1764172,49.8610504 95.0509461,49.8610504 C93.925475,49.8610504 93.0131004,50.7688386 93.0131004,51.8886521 C93.0131004,53.0084656 93.925475,53.9162538 95.0509461,53.9162538 L95.0509461,53.9162538 Z M19.9417759,92 L19.9417759,89.8393536 C19.9417758,87.5932185 21.6918837,85.2820263 23.828826,84.6248277 C23.828826,84.6248277 35.0800582,81.8619915 38.1368268,76.9378159 C38.1368268,76.9378159 46.7248911,83.7447645 46.7248911,83.7447645 C34.7889374,89.6827409 19.9417759,92 19.9417759,92 L19.9417759,92 Z" sketch:type="MSShapeGroup"/></g></g></svg>',makeTurtle:()=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 75 70" enable-background="new 0 0 95 95" xml:space="preserve"><path d="M87.242,46.239c-5.27,0-9.811,1.512-10.09,1.061c-0.281-0.445,1.796-1.456,3.025-2.802  C69.529,35.867,66.388,23.76,47.223,23.76c-19.398,0-24.78,18.723-35.316,28.476l1.905,1.904c0,0-3.586,1.238-6.277,1.57  c-2.691,0.336-6.951,0.741-6.951,1.348c0,0.531,5.606,0.896,8.407,0.896c2.804,0,7.513-0.338,7.513-0.338s0.337,0.445-2.47,1.342  c-2.804,0.9-3.471,1.686-5.49,4.266c-2.014,2.578-4.215,4.748-4.215,5.713c0,1.09,0.445,1.812,2.014,1.812S9.034,71,10.551,71  c2.909,0,2.909-1.807,3.694-3.152c0.789-1.348,1.362-2.158,2.258-2.943c0.901-0.787,2.02-1.008,3.474-1.568  c1.456-0.564,3.702-1.686,3.702-1.686s3.813,1.461,10.424,1.461c6.617,0,18.836-0.34,24.327-0.34c5.493,0,6.562-2.295,7.906-2.295  c0.672,0,3.981,1.965,3.981,2.748c0,1.117-5.161,4.93-5.161,6.051c0,1.125,1.795,1.965,5.05,1.965c4.653,0,5.205-2.605,6.501-4.207  c1.401-1.734,2.572-3.363,2.572-5.383c0-2.521-5.042-4.818-5.042-4.818s1.011-1.571,3.025-1.571c2.017,0,6.056,0.45,10.428,0.45  c4.373,0,6.727,0.56,6.727-3.589C94.417,47.976,92.514,46.239,87.242,46.239z M89.167,50.5c-0.553,0-1-0.447-1-1s0.447-1,1-1  s1,0.447,1,1S89.72,50.5,89.167,50.5z"/></svg>',makeSnail:()=>'<svg style="transform:scaleX(-1.0)" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:cc="http://creativecommons.org/ns#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" version="1.1" x="0px" y="5px" viewBox="0 0 75 75"><g transform="translate(0,-952.36218)"><path style="text-indent:0;text-transform:none;direction:ltr;block-progression:tb;baseline-shift:baseline;color:#000000;enable-background:accumulate;" d="m 63.748703,971.36229 c -5.43917,0.046 -12.9678,1.9026 -17.33056,4.9688 -5.33006,3.7325 -9.84923,9.9737 -12.23149,20.2812 -1.91437,7.74631 -1.56839,15.38211 1.72054,19.75001 5.65023,-0.3712 12.79569,-0.6555 19.30136,-0.4375 -5.52288,-4.5469 -7.39127,-10.3988 -7.25756,-17.56251 -0.0291,-9.4042 7.41348,-15 14.82795,-15 6.96147,0.06 12.98292,5.6893 12.88842,13 -0.0443,5.72511 -4.66524,9.92801 -9.91658,10.00001 -3.86287,-0.055 -8.81178,-2.1402 -8.91553,-7.00003 0.012,-3.41788 2.27613,-6.76628 5.94369,-6.99998 0.52311,-0.01 1.00104,0.4716 1.00104,1 0,0.5284 -0.47793,1.01 -1.00104,1 -2.58389,0.4032 -3.81164,2.1726 -3.94161,4.99998 0.0869,3.54803 4.10317,4.92403 6.91345,5.00003 4.15393,-0.085 7.88782,-3.7511 7.94578,-8.00001 -0.0251,-5.3606 -4.55816,-11 -10.91762,-11 -6.44788,0 -12.88287,4.6227 -12.85715,12.9688 -0.0323,6.38281 1.10231,13.05131 8.54015,17.68741 10.33074,0.4959 17.71944,1.8254 22.77372,2.625 3.622699,-1.5245 6.11839,-4.1742 7.789365,-8 1.71466,-3.9255 2.5026,-9.064 2.5026,-15.25001 0,-13.3656 -12.517635,-24.0313 -27.778925,-24.0312 z m -45.73514,1 c -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.59787,0 1.15869,-0.1992 1.62669,-0.5 1.92801,1.5462 3.44429,3.6637 3.409799,5.9375 -0.0532,2.3056 -1.432899,5.3535 -2.09593,10.1875 -0.37363,-0.053 -0.78261,-0.094 -1.18874,-0.094 -0.58486,0.01 -1.18456,0.1249 -1.81439,0.2813 0.087,-2.7692 -0.50124,-4.9363 -1.34515,-7.0625 -0.88646,-2.2334 -2.73222,-4.4208 -5.91241,-7.5 0.18193,-0.3868 0.31283,-0.7944 0.31283,-1.25 0,-1.6569 -1.3445495,-3 -3.0031295,-3 -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.46283,0 0.89106,-0.1257 1.28258,-0.3125 3.0970895,3.0036 4.7355995,4.9984 5.4431695,6.7813 0.74291,1.8716 1.40489,3.8601 1.15746,7 -0.16002,0.067 -0.31086,0.1478 -0.46924,0.2187 -0.89952,8.26371 -0.58523,17.83861 2.47133,25.28131 3.12374,7.606 8.840111,13.0022 19.30135,13.0312 l 57.810216,0 c -0.672391,-1.924 -2.13834,-4.398 -4.410841,-6.7188 -2.40769,-2.4191 -5.888875,-4.6967 -9.635035,-6 -8.34215,-1.2926 -22.74908,-3.8874 -46.07925,-2.2187 -2.51776,-0.2143 -4.76029,-1.7063 -6.06882,-3.6563 -3.74447,-5.5541 -3.29333,-13.0509 -5.25548,-19.75001 -0.18057,-0.1675 -0.39608,-0.3318 -0.65693,-0.4687 0.62315,-4.7755 2.09036,-7.7341 2.1585,-10.6875 -0.1,-3.42 -1.90212,-5.6714 -4.19187,-7.5938 0.0934,-0.2898 0.15641,-0.5852 0.15641,-0.9062 0.0525,-1.7066 -1.59672,-2.9573 -3.00312,-2.9998 z" fill="#000000" fill-opacity="1" stroke="none" marker="none" visibility="visible" display="inline" overflow="visible"/></g></svg>',makeSprayCanIcon:()=>'<span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" style="width:20px;height:12px;" viewBox="0 0 88 88" enable-background="new 0 0 100 100" xml:space="preserve"><path d="M30.292,91.893c-0.277,0-0.552-0.114-0.75-0.338l-2.614-2.956  c-0.366-0.413-0.327-1.046,0.086-1.411c0.414-0.365,1.047-0.327,1.412,0.087l2.614,2.956c0.366,0.413,0.327,1.046-0.086,1.411  C30.764,91.81,30.528,91.893,30.292,91.893z M26.219,85.882c-0.332,0-0.656-0.165-0.847-0.466l-1.656-2.622  c-0.295-0.467-0.155-1.085,0.312-1.38c0.465-0.295,1.084-0.156,1.379,0.312l1.656,2.622c0.295,0.467,0.155,1.085-0.312,1.38  C26.586,85.832,26.402,85.882,26.219,85.882z M10.305,85.543c-0.413,0-0.799-0.257-0.943-0.668L8.17,81.488  c-0.183-0.521,0.091-1.092,0.612-1.275c0.519-0.188,1.092,0.091,1.275,0.611l1.191,3.387c0.183,0.521-0.091,1.092-0.612,1.275  C10.527,85.525,10.415,85.543,10.305,85.543z M84.585,81.594c-0.552,0-1-0.447-1-1v-2.37c0-0.553,0.448-1,1-1s1,0.447,1,1v2.37  C85.585,81.146,85.137,81.594,84.585,81.594z M23.399,79.747c-0.364,0-0.715-0.199-0.892-0.546  c-5.812-11.412-2.957-18.242-0.737-21.298c0.626-0.862,1.326-1.614,2.066-2.26c-0.73-1.527-1.142-3.388-0.999-5.575  c0.398-6.072,3.779-9.768,7.464-11.549c-0.075-0.425-0.104-0.851-0.079-1.273c0.373-6.19,3.492-11.47,9.269-15.692  c0.446-0.325,1.071-0.229,1.397,0.218c0.326,0.445,0.229,1.071-0.217,1.397c-5.273,3.854-8.117,8.631-8.453,14.198  c-0.008,0.129-0.006,0.263,0.004,0.398c0.222-0.067,0.444-0.129,0.665-0.185c3.565-0.885,6.866-0.192,8.028,1.689  c0.469,0.759,0.976,2.358-0.893,4.539c-1.135,1.327-2.825,1.668-4.636,0.935c-1.701-0.688-3.474-2.361-4.438-4.311  c-2.501,1.267-5.737,4.008-6.114,9.766c-0.107,1.637,0.158,3.044,0.651,4.221c2.304-1.447,4.773-1.989,6.625-1.696  c1.512,0.238,2.556,1.021,2.941,2.201c0.958,2.938-0.12,4.43-0.848,5.059c-1.396,1.204-3.763,1.251-6.033,0.122  c-1.153-0.574-2.318-1.482-3.266-2.72c-0.546,0.499-1.059,1.064-1.516,1.693c-3.367,4.637-3.047,11.46,0.901,19.214  c0.25,0.492,0.055,1.095-0.438,1.346C23.707,79.712,23.552,79.747,23.399,79.747z M26.495,56.169  c0.748,0.979,1.662,1.695,2.567,2.146c1.498,0.745,3.075,0.81,3.834,0.153c0.819-0.707,0.51-2.136,0.253-2.925  c-0.18-0.551-0.834-0.764-1.352-0.845C30.364,54.474,28.363,54.982,26.495,56.169z M32.819,39.677  c0.718,1.374,1.986,2.676,3.316,3.213c1.519,0.616,2.158-0.135,2.368-0.381c0.447-0.522,1.134-1.501,0.71-2.188  c-0.581-0.94-2.979-1.512-5.843-0.799C33.215,39.562,33.029,39.611,32.819,39.677z M8.299,77.702c-0.497,0-0.927-0.369-0.991-0.875  L6.76,72.481c-0.069-0.548,0.319-1.048,0.867-1.117c0.546-0.063,1.048,0.318,1.117,0.867l0.548,4.346  c0.069,0.548-0.319,1.048-0.867,1.117C8.383,77.699,8.341,77.702,8.299,77.702z M84.585,75.176c-0.552,0-1-0.447-1-1v-7.112  c0-0.553,0.448-1,1-1s1,0.447,1,1v7.112C85.585,74.729,85.137,75.176,84.585,75.176z M7.632,68.187c-0.552,0-1-0.447-1-1v-4.063  c0-0.553,0.448-1,1-1s1,0.447,1,1v4.063C8.632,67.739,8.185,68.187,7.632,68.187z M84.585,63.322c-0.552,0-1-0.447-1-1V37.405  c0-0.553,0.448-1,1-1s1,0.447,1,1v24.917C85.585,62.875,85.137,63.322,84.585,63.322z M7.658,59.402c-0.009,0-0.018,0-0.027,0  c-0.552-0.016-0.988-0.475-0.973-1.026c0.345-12.844,4.494-18.087,7.337-20.179c0.154-0.413,0.33-0.842,0.53-1.288  c3.832-8.567,13.136-16.174,25.527-20.871c0.517-0.194,1.094,0.064,1.29,0.581s-0.064,1.094-0.581,1.29  c-11.451,4.34-20.123,11.193-23.981,18.909c1.926-0.503,3.74-0.106,4.861,1.103c1.118,1.207,1.284,3.004,0.442,4.807  c-1.462,3.134-4.531,4.828-6.84,3.769c-1.321-0.604-2.312-2.105-2.115-4.675c-2.346,3.048-4.25,8.389-4.471,16.607  C8.643,58.972,8.198,59.402,7.658,59.402z M15.668,39.46c-1.003,3-0.587,4.764,0.406,5.218c1.131,0.513,3.128-0.506,4.196-2.796  c0.5-1.071,0.465-1.995-0.097-2.603c-0.686-0.739-2.026-0.88-3.414-0.357C16.398,39.058,16.033,39.236,15.668,39.46z M44.426,20.661  c-0.358,0-0.705-0.192-0.884-0.531c-0.259-0.487-0.074-1.093,0.414-1.352c1.179-0.627,2.449-1.23,3.774-1.794  c0.51-0.218,1.096,0.021,1.312,0.528c0.216,0.508-0.02,1.096-0.528,1.312c-1.272,0.542-2.49,1.12-3.619,1.72  C44.745,20.624,44.584,20.661,44.426,20.661z M43.329,16.909c-0.403,0-0.784-0.246-0.935-0.646c-0.196-0.517,0.064-1.094,0.581-1.29  c0.439-0.166,0.782-0.279,1.084-0.294c0.085-0.022,0.199-0.055,0.351-0.1c0.527-0.157,1.085,0.147,1.241,0.679  c0.156,0.53-0.148,1.085-0.678,1.241c-0.34,0.1-0.648,0.189-0.925,0.207c-0.085,0.031-0.203,0.076-0.364,0.138  C43.566,16.889,43.447,16.909,43.329,16.909z M55.574,16.296c-0.435,0-0.834-0.285-0.96-0.724c-0.153-0.531,0.154-1.085,0.685-1.237  c0.778-0.224,1.567-0.438,2.365-0.641c0.539-0.138,1.08,0.188,1.216,0.722c0.137,0.535-0.187,1.079-0.722,1.216  c-0.779,0.199-1.548,0.407-2.308,0.625C55.758,16.283,55.665,16.296,55.574,16.296z M48.571,15.53c-0.456,0-0.868-0.313-0.974-0.777  c-0.124-0.538,0.213-1.074,0.751-1.197c1.599-0.366,3.268-0.689,4.961-0.96c0.542-0.093,1.058,0.284,1.146,0.829  c0.087,0.546-0.284,1.059-0.829,1.146c-1.65,0.265-3.276,0.579-4.832,0.935C48.72,15.522,48.645,15.53,48.571,15.53z M61.835,13.657  c-0.522,0-0.962-0.406-0.997-0.935c-0.036-0.552,0.382-1.027,0.933-1.063c0.938-0.061,1.89-0.11,2.857-0.146  c0.543-0.049,1.017,0.409,1.037,0.961c0.021,0.553-0.41,1.017-0.962,1.037c-0.949,0.036-1.883,0.084-2.803,0.145  C61.879,13.656,61.857,13.657,61.835,13.657z M90.627,90.353H60.354c-2.063,0-3.74-1.578-3.74-3.519v-55.19  c0-0.67,0.2-1.297,0.547-1.831c-0.36-0.715-0.547-1.488-0.547-2.153v-1.615c0-1.949,1.587-4.036,3.95-4.036h0.668  c0.846-2.483,2.916-6.444,6.424-6.444h0.961V9.107c0-1.104,0.896-2,2-2h9.747c1.104,0,2,0.896,2,2v6.456h1.303  c3.528,0,5.423,3.941,6.154,6.444h0.243c2.424,0,4.304,2.17,4.304,4.036v1.668c0,0.616-0.217,1.336-0.606,2.014  c0.383,0.552,0.606,1.211,0.606,1.918v55.19C94.368,88.774,92.69,90.353,90.627,90.353z M60.614,86.353h29.753V32.125H60.614V86.353  z M60.795,28.125h29.177c0.135-0.088,0.331-0.344,0.395-0.516v-1.386c-0.081-0.105-0.237-0.216-0.304-0.216h-29.42  c-0.015,0.026-0.027,0.057-0.031,0.077l0.002,1.574C60.624,27.772,60.71,27.991,60.795,28.125z M65.55,22.008h20.043  c-0.534-1.222-1.322-2.444-1.926-2.444h-16.01C67.005,19.563,66.162,20.775,65.55,22.008z M72.618,15.563h5.747v-4.456h-5.747  V15.563z"/>',makeSettingsIcon:e=>o.makeSimplePath(r.extend({},!0,e,{viewBox:[0,0,100,100],d:["M49.71,95c-2.757,0-3.253-2.49-3.871-5.594c-0.733-3.752-2.109-5.723-4.478-6.466    c-0.056-0.018-0.139-0.054-0.214-0.094c-0.562-0.147-1.115-0.307-1.663-0.486c-2.331-0.595-4.53,0.338-7.074,3.036    c-2.354,2.489-4.2,4.437-6.758,2.393l-1.186-0.943c-0.333-0.264-0.585-0.462-2.394-1.91c-0.025-0.018-0.049-0.037-0.073-0.057    c-0.01-0.008-0.02-0.015-0.03-0.023l-2.008-1.615c-0.456-0.368-0.456-0.368-1.456-1.162l-0.12-0.096    c-2.544-2.051-1.06-4.266,0.817-7.071c2.121-3.157,2.54-5.525,1.394-7.735l0.001,0c-0.024-0.048-0.047-0.101-0.066-0.154    c-0.294-0.508-0.566-1.032-0.834-1.552c-1.227-2.076-3.449-2.978-7.166-2.882c-3.442,0.089-6.108,0.155-6.471-3.086l-0.16-1.458    c-0.049-0.451-0.075-0.697-0.345-3.105l0.961-0.217l-0.972,0.109l-0.508-4.569c-0.361-3.253,2.258-3.767,5.575-4.418    c3.736-0.741,5.708-2.121,6.453-4.485c0.015-0.05,0.045-0.118,0.077-0.182c0.133-0.503,0.305-1.122,0.513-1.732    c0.568-2.3-0.366-4.495-3.051-7.035c-2.499-2.37-4.433-4.204-2.394-6.764l2.871-3.585c0.018-0.027,0.046-0.064,0.066-0.089    l2.877-3.583c2.039-2.558,4.261-1.065,7.075,0.827c3.153,2.112,5.524,2.529,7.722,1.38c0.038-0.02,0.087-0.04,0.138-0.058    c0.542-0.31,1.052-0.571,1.571-0.833c2.074-1.219,2.98-3.443,2.882-7.181c-0.09-3.432-0.16-6.087,3.084-6.464l9.241-1.029    c3.239-0.354,3.773,2.269,4.426,5.593c0.725,3.714,2.104,5.686,4.478,6.437c0.056,0.018,0.141,0.056,0.218,0.096    c0.544,0.141,1.092,0.304,1.628,0.473c2.345,0.607,4.551-0.321,7.092-3.028c2.38-2.499,4.214-4.425,6.761-2.394l1.256,1.001    c0.307,0.243,0.642,0.509,2.327,1.858c0.018,0.013,0.035,0.027,0.052,0.042c0.02,0.015,0.038,0.031,0.053,0.043l3.58,2.864    c2.535,2.039,1.069,4.237-0.785,7.021l-0.064,0.096c-2.087,3.111-2.507,5.481-1.361,7.686c0.022,0.042,0.045,0.1,0.065,0.16    c0.26,0.453,0.498,0.918,0.741,1.393l0.021,0.04c0.008,0.012,0.016,0.025,0.023,0.038c1.246,2.152,3.475,3.058,7.215,2.955    c3.451-0.087,6.11-0.156,6.469,3.088l0.506,4.527c0.008,0.041,0.013,0.082,0.016,0.122c0.001,0.011,0.003,0.021,0.004,0.031    l0.134,1.238c0.17,1.562,0.17,1.562,0.235,2.134l0.136,1.196c0,0.002,0,0.004,0,0.006c0.348,3.233-2.248,3.751-5.535,4.407    l-0.1,0.02c-3.676,0.719-5.647,2.096-6.396,4.465c-0.018,0.057-0.06,0.151-0.1,0.229c-0.126,0.489-0.289,1.049-0.469,1.616    c-0.61,2.336,0.321,4.543,3.033,7.107c2.489,2.365,4.424,4.205,2.39,6.755c-0.684,0.853-0.836,1.045-1.038,1.301    c-0.236,0.299-0.541,0.684-1.831,2.297c-0.018,0.023-0.04,0.047-0.062,0.071l-2.883,3.598c-2.032,2.537-4.235,1.07-7.025-0.786    l-0.089-0.059c-3.109-2.091-5.479-2.513-7.687-1.368c-0.039,0.02-0.094,0.043-0.15,0.063c-0.478,0.275-1.001,0.555-1.536,0.818    c-2.089,1.218-3,3.445-2.896,7.188c0.095,3.422,0.169,6.102-3.088,6.466l-1.591,0.182c-0.389,0.046-0.814,0.096-2.977,0.339    c-0.034,0.004-0.069,0.006-0.103,0.006v0c-0.001,0-0.008,0.003-0.041,0.005c-1.837,0.205-2.403,0.266-2.773,0.306    c-0.386,0.042-0.558,0.06-1.752,0.197C50.07,94.99,49.885,95,49.71,95z M42.039,81.104c4,1.332,5.169,5.109,5.704,7.848    c0.741,3.722,1.019,4.213,2.307,4.072c1.195-0.137,1.367-0.155,1.757-0.197c0.372-0.04,0.942-0.102,2.807-0.31    c0.014-0.002,0.028-0.003,0.043-0.004c0.043-0.005,0.093-0.009,0.128-0.009c2.086-0.236,2.511-0.286,2.898-0.331l1.601-0.183    c1.291-0.145,1.455-0.684,1.351-4.438c-0.08-2.851,0.242-6.851,3.927-8.995c0.573-0.285,1.075-0.553,1.569-0.838    c0.056-0.032,0.136-0.066,0.212-0.091c3.785-1.889,7.288-0.046,9.604,1.513l0.085,0.056c3.078,2.049,3.614,2.192,4.415,1.192    l2.875-3.589c0.013-0.016,0.074-0.088,0.088-0.104c0.008-0.009,0.016-0.017,0.024-0.025l0.003-0.003    c1.239-1.552,1.543-1.936,1.778-2.234c0.204-0.258,0.357-0.451,1.045-1.309c0.803-1.006,0.539-1.502-2.173-4.079    c-2.079-1.965-4.673-5.008-3.601-9.104c0.188-0.596,0.345-1.137,0.492-1.692c0.019-0.074,0.066-0.181,0.112-0.267    c1.32-4.013,5.112-5.19,7.86-5.728l0.097-0.019c3.625-0.724,4.11-1.001,3.973-2.277l-0.136-1.191    c-0.066-0.575-0.066-0.575-0.236-2.145l-0.134-1.233c-0.002-0.013-0.003-0.026-0.005-0.039c-0.004-0.024-0.008-0.048-0.011-0.072    l-0.511-4.57c-0.141-1.279-0.675-1.445-4.392-1.349c-2.88,0.083-6.843-0.229-8.992-3.846c-0.029-0.04-0.055-0.082-0.078-0.127    l-0.063-0.123c-0.243-0.475-0.48-0.94-0.744-1.393c-0.036-0.062-0.073-0.151-0.099-0.235c-1.907-3.722-0.053-7.256,1.514-9.59    l0.063-0.094c2.045-3.068,2.19-3.604,1.189-4.409L76.8,16.676c-0.096-0.053-0.175-0.118-0.238-0.192    c-1.56-1.248-1.884-1.505-2.181-1.741l-1.261-1.006c-1.004-0.8-1.499-0.541-4.068,2.157c-3.053,3.252-6.017,4.42-9.104,3.617    c-0.592-0.185-1.151-0.35-1.701-0.49c-0.07-0.018-0.138-0.043-0.203-0.076c-0.019-0.01-0.05-0.028-0.081-0.047    c-4.002-1.32-5.176-5.11-5.712-7.857c-0.73-3.718-1.007-4.21-2.298-4.066l-9.238,1.029c-1.295,0.15-1.447,0.644-1.349,4.399    c0.076,2.885-0.248,6.876-3.9,9.019c-0.584,0.297-1.105,0.564-1.616,0.858c-0.057,0.033-0.136,0.067-0.212,0.093    c-3.699,1.921-7.246,0.064-9.588-1.507c-3.15-2.118-3.691-2.267-4.497-1.257l-2.879,3.586c0.016-0.014-0.011,0.02-0.065,0.088    l-2.87,3.584c-0.806,1.012-0.544,1.507,2.163,4.074c2.071,1.959,4.643,4.975,3.63,9.053c-0.213,0.634-0.373,1.211-0.525,1.786    c-0.019,0.071-0.058,0.165-0.101,0.246c-1.297,3.988-5.099,5.177-7.854,5.724c-3.725,0.731-4.212,1.008-4.07,2.293l0.508,4.568    l0.011,0.108c0.27,2.414,0.297,2.66,0.346,3.111l0.159,1.453c0.143,1.278,0.675,1.441,4.406,1.348    c2.867-0.079,6.849,0.247,8.999,3.893c0.296,0.574,0.57,1.101,0.868,1.609c0.042,0.071,0.074,0.146,0.097,0.225    c1.893,3.754,0.046,7.266-1.514,9.587c-2.112,3.155-2.26,3.697-1.255,4.507l0.114,0.091c1.008,0.8,1.008,0.8,1.468,1.171    l1.993,1.603c0.051,0.033,0.1,0.071,0.144,0.114c1.773,1.419,2.022,1.616,2.352,1.877l1.193,0.949    c1.012,0.809,1.511,0.545,4.099-2.19c1.935-2.052,4.959-4.639,9.06-3.588c0.61,0.198,1.165,0.356,1.729,0.502    c0.057,0.015,0.112,0.034,0.165,0.059C41.954,81.056,41.998,81.08,42.039,81.104z M21.972,84.854c0,0.001,0.002,0.002,0.006,0.005    C21.976,84.858,21.974,84.856,21.972,84.854z M41.9,81.059c0.027,0.008,0.054,0.017,0.08,0.025    C41.956,81.075,41.929,81.066,41.9,81.059z M66.309,77.644c-0.026,0.011-0.054,0.025-0.083,0.043    C66.254,77.673,66.282,77.658,66.309,77.644z M22.277,66.181c0,0,0.001,0.001,0.001,0.002    C22.278,66.182,22.277,66.181,22.277,66.181z M81.071,58.039c-0.004,0.011-0.008,0.024-0.011,0.036    C81.064,58.064,81.068,58.051,81.071,58.039z M92.594,45.606c0,0.001,0,0.001,0.001,0.002    C92.595,45.608,92.595,45.607,92.594,45.606z M92.593,45.605L92.593,45.605L92.593,45.605z M92.502,45.268    c0,0.011,0,0.028,0.003,0.051C92.504,45.301,92.503,45.283,92.502,45.268z M58.046,18.927c0.004,0.001,0.009,0.003,0.013,0.004    C58.055,18.929,58.051,18.928,58.046,18.927z M76.969,16.756C76.969,16.756,76.969,16.756,76.969,16.756    C76.969,16.756,76.969,16.756,76.969,16.756z M76.967,16.755L76.967,16.755L76.967,16.755z M76.965,16.754    C76.965,16.754,76.965,16.755,76.965,16.754C76.965,16.755,76.965,16.754,76.965,16.754z M76.963,16.754    C76.963,16.754,76.963,16.754,76.963,16.754C76.963,16.754,76.963,16.754,76.963,16.754z M76.961,16.753L76.961,16.753    L76.961,16.753z M49.964,65.65c-3.537,0-6.945-1.189-9.747-3.43c-3.266-2.611-5.318-6.337-5.777-10.491    c-0.951-8.579,5.252-16.333,13.827-17.286c4.16-0.464,8.243,0.721,11.506,3.332c3.264,2.612,5.315,6.34,5.777,10.499    c0.462,4.154-0.722,8.24-3.335,11.504s-6.339,5.315-10.492,5.774C51.134,65.617,50.547,65.65,49.964,65.65z M50.025,36.301    c-0.512,0-1.026,0.029-1.543,0.086c-7.503,0.834-12.93,7.62-12.098,15.126c0.402,3.634,2.197,6.893,5.054,9.178    c2.857,2.284,6.433,3.32,10.069,2.916c0,0,0,0,0,0c3.633-0.401,6.893-2.195,9.179-5.051c2.287-2.857,3.323-6.432,2.919-10.066    c-0.405-3.639-2.2-6.902-5.055-9.188C56.099,37.342,53.119,36.301,50.025,36.301z"],fill:e.color})),makeNoEntryIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><g fill-rule="evenodd" fill="'+e+'"><path data-name="Compound Path" d="M50,89.11A39.11,39.11,0,1,0,22.33,77.66,39,39,0,0,0,50,89.11ZM72,72a31.17,31.17,0,0,1-41.28,2.42l43.71-43.7A31.17,31.17,0,0,1,72,72ZM28,28a31.16,31.16,0,0,1,40.72-2.86L25.14,68.71A31.17,31.17,0,0,1,28,28Z"/></g></svg>',makeTrashIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 26" version="1.1" x="0px" y="0px"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="scale(1.2 1.2) translate(-2 0)"><rect x="0" y="0" width="24" height="24"/><path d="M5,6 L5.73274082,20.8571429 C5.73274082,20.8571429 5.99625939,22 6.98958614,22 L11.598019,22 L12.4359159,22 L17.0443487,22 C18.0380944,22 18.301613,20.8571429 18.301613,20.8571429 L19,6 L5,6 Z M15.5,8 L15.5,8 L15.5,8 C15.2205531,8 14.9908183,8.22036187 14.9791847,8.49956654 L14.5208153,19.5004335 L14.5208153,19.5004335 C14.5097883,19.7650799 14.7153876,19.9885573 14.980034,19.9995842 C14.9866857,19.9998614 14.9933425,20 15,20 L15,20 L15,20 C15.2794469,20 15.5091817,19.7796381 15.5208153,19.5004335 L15.9791847,8.49956654 L15.9791847,8.49956654 C15.9902117,8.23492012 15.7846124,8.01144271 15.519966,8.00041578 C15.5133143,8.00013862 15.5066575,8 15.5,8 Z M9.47918818,19.5003499 L9.02097843,8.49965006 L9.02097843,8.49965006 C9.00934688,8.22039979 8.77957571,8 8.50008331,8 L8.50008331,8 L8.50008331,8 C8.23515945,8 8.02039624,8.21476322 8.02039624,8.47968707 C8.02039624,8.48634356 8.02053479,8.49299933 8.02081182,8.49965006 L8.47902157,19.5003499 L8.47902157,19.5003499 C8.49065312,19.7796002 8.72042429,20 8.99991669,20 L8.99991669,20 L8.99991669,20 C9.26484055,20 9.47960376,19.7852368 9.47960376,19.5203129 C9.47960376,19.5136564 9.47946521,19.5070007 9.47918818,19.5003499 Z M8.00719509,3 L5.11111111,3 L5.11111111,3 C4.49746139,3 4,3.49746139 4,4.11111111 L4,4.11111111 L4,5 L20,5 L20,4.11111111 C20,3.49746139 19.5025386,3 18.8888889,3 L15.9926121,3 C15.9368649,2.4385197 15.4631369,2 14.8869871,2 L9.11301289,2 C8.99358834,2 8.87494478,2.0192532 8.76164871,2.05701856 C8.33332638,2.19979267 8.04982846,2.57814658 8.00719509,3 Z M12,8 C12.2761424,8 12.5,8.22385763 12.5,8.5 L12.5,19.5 C12.5,19.7761424 12.2761424,20 12,20 C11.7238576,20 11.5,19.7761424 11.5,19.5 L11.5,8.5 C11.5,8.22385763 11.7238576,8 12,8 Z" fill="#000000"/></g></g></svg>',makeCompressTimeIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="-434 236 90 80" style="enable-background:new -434 236 90 90;" xml:space="preserve"><g fill-rule="evenodd" fill="'+e+'"><path d="M-354.9,251.1h-5.3h-2.6v2.6v27.8c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3   v29.1c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3v60.4c0,0.7,0.2,1.1,0.5,1.3   c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1c0.2-0.2,0.4-0.5,0.5-0.8v29.1c0,0.7,0.2,1.1,0.5,1.3c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1   c0.2-0.2,0.4-0.5,0.5-0.8v27.8v2.6h2.6h5.3h2.6v-2.6v-57.8v-2.6H-354.9z"/></g></svg>',makeSmallUdacityIcon:e=>'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="'+e.width+'px" height="'+e.height+'px" viewBox="0 0 32 32" enable-background="new 0 0 32 32"><image x="0" y="0" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAABGdBTUEAALGPC/xhBQAAACBjSFJN AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAABOFBMVEUAs+YAsuYKvOkSveo1 xezR8vv6/v6I3PQowuu+7Pn///+V4PUCu+my6Pgdv+u66/ln0/Hv+v31/P531/P9/v8At+j3/f7a 9PxLy+/+//8twuzM8Pv8/v9t1fLt+v3u+v1v1fIAtOeY4fXg9vxKy+6S3/UAuOgAtecAs+f2/P4g v+ut5/d21/NXzvCg4/ZWzvDi9/zT8vs9yO3l+PwAuenc9fuX4fWG3PPC7frD7fpHyu4zxez7/v84 xu3s+f0MvOp42POo5fdUzu/U8vxZz/CR3/Wr5vfS8vvn+P0rw+wPvOokwOv5/f606fgAuunX8/xr 1PLQ8ftSze8AtugnwuuU4PUEu+nW8/yJ3PQYv+qQ3/TP8fuq5vfh9vzB7fq/7Pn0/P5w1fI3xu2s 5/fm+PyN3vQ5x+0xxOwxFuTVAAAAAWJLR0QKaND0VgAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAAd0 SU1FB+IKHAUqGL3rdjoAAAFBSURBVDjL5dPZUsIwFAbgBMTqj6BiF0FcsGLdEaniUtwVVMR93/f3 fwPbkpS0Os5wbW7Sk/NN0ov/EEL/XIQ0AUgo0Az7QUukVRLbbe2ICqAjBns12vHOes0A6epGokf2 gCKp0HqTHkj1AbEQTXPQP4DBoQz1wLAMfcQ+9wCQHbU3DwCSQf3ArQUwRv8RUINgPAB0TIhAgRYA k5gSwTRmGEgj457nMOt+EBeQPOYYKMCsR2oeC85uwn6cFrHIE7WE5frVKxaydl1CnpJicnWNg3Vs sN/ftLC1bexgN1dGZc8L7b4lHzBR0oGq5aTtsCakOoojhQnj+MRpF059sT8rIxLmeTyvQL7gnof2 8grq9Y07C7dV3KV+Do5yb9/78PikAc8v4rA1Buf1LeE8/v5h+qZLHD0j/vlVo4HV1PD+Dr4BCLwn yyZy1tMAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTgtMTAtMjhUMTI6NDI6MjQtMDc6MDC16UJJAAAA JXRFWHRkYXRlOm1vZGlmeQAyMDE4LTEwLTI4VDEyOjQyOjI0LTA3OjAwxLT69QAAAABJRU5ErkJg gg==" width="32" height="32"></image></svg>',makeLabelHtml:e=>{const t=e.dimensions,n={style:"width:"+t.width+"px;height:"+t.height+"px;left:"+t.x+"px;top:"+t.y+"px;opacity:"+e.opacity+";color:"+e.color+";padding-top:10px;"};return'<div class="bxy-sticker-inner">'+o.makeElementHtml("div",n,"<div>"+e.label+"</div>")+"</div>"},makeHomeFolderIcon:e=>'<svg xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://www.w3.org/2000/svg" xmlns:cc="http://creativecommons.org/ns#" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" version="1.1" x="0px" y="0px" viewBox="10 10 75 75"><g transform="translate(0,-952.36218)"><path style="baseline-shift:baseline;block-progression:tb;color:#000000;direction:ltr;text-indent:0;enable-background:accumulate;text-transform:none;" fill="#000" d="m13.812,968.89c-0.51636,0.005-0.86248,0.14455-1.0312,0.28125-0.16877,0.1367-0.25,0.26805-0.25,0.65625v3.8125,1h-1-1.5312c-0.41876,0.003-0.66765,0.1155-0.8125,0.25-0.13976,0.1297-0.2422,0.34985-0.25,0.78125,0.000058,0.017-0.000057,0.0143,0,0.0312,0.0088,2.6282,0.0011,3.3996,0,4.8438h82.125v-4.875c0-0.4119-0.12605-0.606-0.28125-0.75s-0.3925-0.29125-0.875-0.28125h-0.03125-44.562-1v-1-3.7188c0-0.4015-0.08843-0.6006-0.25-0.75s-0.44128-0.28125-0.875-0.28125h-29.375zm-5.4688,13.656c-0.050524,0.004-0.098821,0.0172-0.15625,0.0312-0.064504,0.012-0.13338,0.0425-0.1875,0.0625-0.34403,0.1268-0.49236,0.38875-0.5,0.78125-0.000232,0.012,0,0.0193,0,0.0312l1.7812,51.437a1.0001,1.0001,0,0,1,0,0.062c0,0.1465,0.079205,0.3075,0.34375,0.5,0.26454,0.1926,0.71304,0.3438,1.0938,0.3438l79.031,0.031a1.0001,1.0001,0,0,1,0.03125,0c0.56827,0.011,0.65633-0.094,0.65625-0.094-0.00008,0.0001,0.10538-0.1587,0.09375-0.7188a1.0001,1.0001,0,0,1,0,-0.062l1.97-51.44c0-0.012,0.000232-0.0192,0-0.0312-0.0077-0.3976-0.14181-0.6885-0.5-0.8125h-0.03125c-0.11803-0.036-0.27448-0.0625-0.4375-0.0625h-0.03125-83.031a1.0001,1.0001,0,0,1,-0.0625,0c-0.023769,0.0009-0.039804,0-0.0625,0zm41.656,8.375,20.219,20.219-3.9062,3.9375-3.2812-3.2812,0,15.656-10.438,0,0-7.8125c0-1.4454-1.1484-2.625-2.5938-2.625s-2.625,1.1796-2.625,2.625v7.8125h-10.438v-15.656l-3.25,3.2812-3.9062-3.9375,20.22-20.18zm7.8125,2.625,5.2188,0,0,7.1562-5.2188-5.2187,0-1.9375z"/></g></svg>',makeLabelSvg:e=>{const t=e.dimensions,n=e.buffer||4,r="0 0 "+t.width+" "+t.height,i=o.makeBufferedViewBox({buffer:n,bufferAllSides:!0,viewBox:r});let a={x:0,y:16,text:e.label,"font-size":18,width:t.width,height:t.height,stroke:e.color,fill:e.color,dashed:e.dashed,"stroke-width":e.strokeWidth,"fill-opacity":e.fillOpacity};o.interpretDashing(e,a);const l={el:o.makeSvgElement("text",a),x:t.x,y:t.y,width:t.width,height:t.height,viewBox:i};return o.renderSvg([l])},makeCustom:e=>{const t=e.dimensions;let n='<img src="'+e.imageUrl+'" style="width:'+t.width+"px;height:"+t.height+"px;top:"+t.y+"px;left:"+t.x+"px;opacity:1.0;";return void 0!==e.cssTransform&&(n+="transform:"+e.cssTransform),n+='">',n}},i=o},55:(e,t,n)=>{var r=n(994),o=n(227);"string"==typeof(o=o.__esModule?o.default:o)&&(o=[[e.id,o,""]]);r(o,{insert:"head",singleton:!1}),e.exports=o.locals||{}},994:(e,t,n)=>{"use strict";var r,o=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),i=[];function a(e){for(var t=-1,n=0;n<i.length;n++)if(i[n].identifier===e){t=n;break}return t}function l(e,t){for(var n={},r=[],o=0;o<e.length;o++){var l=e[o],c=t.base?l[0]+t.base:l[0],u=n[c]||0,s="".concat(c," ").concat(u);n[c]=u+1;var f=a(s),p={css:l[1],media:l[2],sourceMap:l[3]};-1!==f?(i[f].references++,i[f].updater(p)):i.push({identifier:s,updater:v(p,t),references:1}),r.push(s)}return r}function c(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=n.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach((function(e){t.setAttribute(e,r[e])})),"function"==typeof e.insert)e.insert(t);else{var a=o(e.insert||"head");if(!a)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");a.appendChild(t)}return t}var u,s=(u=[],function(e,t){return u[e]=t,u.filter(Boolean).join("\n")});function f(e,t,n,r){var o=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=s(t,o);else{var i=document.createTextNode(o),a=e.childNodes;a[t]&&e.removeChild(a[t]),a.length?e.insertBefore(i,a[t]):e.appendChild(i)}}function p(e,t,n){var r=n.css,o=n.media,i=n.sourceMap;if(o?e.setAttribute("media",o):e.removeAttribute("media"),i&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var d=null,h=0;function v(e,t){var n,r,o;if(t.singleton){var i=h++;n=d||(d=c(t)),r=f.bind(null,n,i,!1),o=f.bind(null,n,i,!0)}else n=c(t),r=p.bind(null,n,t),o=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else o()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=(void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r));var n=l(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var o=a(n[r]);i[o].references--}for(var c=l(e,t),u=0;u<n.length;u++){var s=a(n[u]);0===i[s].references&&(i[s].updater(),i.splice(s,1))}n=c}}}},379:function(e,t,n){"use strict";var r=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var t;e.done?o(e.value):(t=e.value,t instanceof n?t:new n((function(e){e(t)}))).then(a,l)}c((r=r.apply(e,t||[])).next())}))},o=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,n=e[Symbol.asyncIterator];return n?n.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),t={},r("next"),r("throw"),r("return"),t[Symbol.asyncIterator]=function(){return this},t);function r(n){t[n]=e[n]&&function(t){return new Promise((function(r,o){!function(e,t,n,r){Promise.resolve(r).then((function(t){e({value:t,done:n})}),t)}(r,o,(t=e[n](t)).done,t.value)}))}}};Object.defineProperty(t,"__esModule",{value:!0}),t.registerBbyButtons=t.workRegx=void 0;const i=n(419),a=n(471),l=n(475),c=window.Jupyter;t.workRegx=/work\/lessons-(\d+)-(\w+)\.ipynb/,t.registerBbyButtons=()=>{c.toolbar.add_buttons_group([c.keyboard_manager.actions.register({help:"同步课程",icon:"fa-retweet",handler:x},"sync-lesson","ipybbycell")]),c.toolbar.add_buttons_group([c.keyboard_manager.actions.register({help:"添加「课程」",icon:"fa-book",handler:d},"add-lesson","ipybbycell")]),c.toolbar.add_buttons_group([c.keyboard_manager.actions.register({help:"添加「普通 Step」",icon:"fa-font",handler:p},"add-string-step","ipybbycell"),c.keyboard_manager.actions.register({help:"添加「Verify Step」",icon:"fa-columns",handler:h},"add-verify-step","ipybbycell"),c.keyboard_manager.actions.register({help:"添加「Matplotlib Step」",icon:"fa-area-chart",handler:v},"add-matplotlib-step","ipybbycell"),c.keyboard_manager.actions.register({help:"添加「Turtle Step」",icon:"fa-pencil",handler:g},"add-turtle-step","ipybbycell"),c.keyboard_manager.actions.register({help:"添加「Quiz Step」",icon:"fa-question-circle",handler:y},"add-quiz-step","ipybbycell")]),c.toolbar.add_buttons_group([c.keyboard_manager.actions.register({help:"添加「文件 Cell」",icon:"fa-file",handler:m},"add-file-cell","ipybbycell")])};const u=function(e){c.notebook.insert_cell_below("code").set_text(e),c.notebook.select(c.notebook.get_selected_index()+1),c.notebook.focus_cell()},s=function(e){c.notebook.insert_cell_below("markdown").set_text(e),c.notebook.select(c.notebook.get_selected_index()+1),c.notebook.focus_cell()},f=function(){s("### 步骤标题"),u("#platform-desc\nfrom ipyaliplayer import Player\nPlayer(vid='--替换你的视频id，上传地址 https://www.boyuai.com/elites/admin/public-video', aspect_ratio=4/3)\n"),s("\x3c!--步骤描述 --\x3e\n\n#### 知识点\n- 总结视频中的知识点\n\n#### 代码练习说明\n- 代码练习题目说明\n\n#### 代码练习提示\n- 代码练习提示")},p=function(){f(),u("#platform-lock-hidden\n\n# platform-lock-hidden 的代码不会展示，但会被运行\n\ndef add(x):\n  return x + 1"),u("#platform-edit\n\n# platform-edit 可被学员编辑\n\n$$$"),u("#platform-edit-answer\n\n# 练习答案代码\n# 我们提供“一键填入”功能将答案复制到对应的代码块中\n# 建议 platform-edit-answer 块是直接在 platform-edit 块的基础上修改，并添加额外的解释说明\n\nx = add(0)"),u('#platform-lock\n\n# platform-lock 的代码会被展示和运行，无法修改\nprint("add(0) =", x)'),s("add(0) = 1")},d=function(){c.notebook.insert_cell_below("markdown").set_text("## 单元标题\n\n单元简介（目前不展示这部分，所以可以写的简单一点）"),c.notebook.delete_cells(),p()},h=function(){f(),u("#platform-edit\n\ndef add(x):\n  return x"),u("#platform-edit-answer\n\ndef add(x):\n  return x + 1"),u("#platform-lock\nprint(add(1))"),u('#platform-verify\nimport json\nif add(2) == 3 and add(-1) == 0:\n  print(json.dumps({"result": True, "displayResult": "good"}))\nelse:\n  print(json.dumps({"result": False, "displayResult": "bad"}))')},v=function(){f(),u("#platform-edit\n\nimport matplotlib.pyplot as plt\nplt.plot([1, 2, 3])\nplt.show()"),u("#platform-edit-answer\n\nimport matplotlib.pyplot as plt\nplt.plot([1, 2, 3, 4])\nplt.show()"),u('#platform-lock-hidden\n\n# 不要修改\nprint("#matplotlib#")'),s("#matplotlib#")},g=function(){f(),u("#platform-lock\nfrom ipyturtle2 import TurtleWidget\n\nt = TurtleWidget()\nt"),u("#platform-edit\n\nt.forward(100)\nt.left(90)\nt.pencolor('red')\nt.forward(100)\nt.left(90)\nt.forward(100)\nt.left(90)\nt.forward(100)"),u("#platform-edit-answer\n\nt.forward(100)\nt.left(90)\nt.pencolor('blue')\nt.forward(100)"),u('#platform-lock-hidden\n\n# 不要修改\nprint("#turtle#")'),s("#turtle#")},y=function(){s("### 步骤标题"),u("#platform-desc\nfrom ipyaliplayer import Player\nPlayer(vid='--替换你的视频id，上传地址 https://www.boyuai.com/elites/admin/public-video', aspect_ratio=4/3)\n"),s("\x3c!--步骤描述 --\x3e\n\n#### 知识点\n- 总结视频中的知识点"),u('#platform-quiz\nimport ipyquiz\nquizzes = []\n\nquizzes.append({\n  "id": "fill-1",\n  "type": "FILL",\n  "title": "学习是系统通过____提升性能的过程。",\n  "answer": "经验"\n})\n\nquizzes.append({\n  "id": "fill-2",\n  "type": "FILL",\n  "title": """\n试试**markdown**吧\n$x+1$\n""",\n  "answer": "1"\n})\n\nquizzes.append({\n  "id": "fill-3",\n  "type": "FILL",\n  "title": "填啥都行",\n  "answer": ""\n})\n\nquizzes.append({\n  "id": "choice-1",\n  "type": "SELECT",\n  "title": "matplotlib 绘制图形的基本组成包含文字部分和图形部分，以下说法错误的是：",\n  "answer": "1",\n  "options": [\n      {\n          "value": "0",\n          "text": "图形标题、图例是基本组成中的文字部分。"\n      },\n      {\n          "value": "1",\n          "text": "x、y 坐标轴、刻度标签是基本组成中的文字部分。"\n      },\n      {\n          "value": "2",\n          "text": "边框、网格是基本组成中的图形部分。"\n      },\n      {\n          "value": "3",\n          "text": "数据图形（折线图及散点图）是基本组成中的图形部分。"\n      },\n  ]\n})\n\nquizzes.append({\n  "id": "choice-2",\n  "type": "SELECT",\n  "title": "以下关于 matplotlib 绘制图形的层次的说法，错误的是：",\n  "answer": "3",\n  "options": [\n      {\n          "value": "0",\n          "text": "画架层（canvas）类似于在绘画时需要一个画架放置画板。"\n      },\n      {\n          "value": "1",\n          "text": "画板层（figure）是指在画板上可以铺上画纸，是允许绘图的最大空间"\n      },\n      {\n          "value": "2",\n          "text": "画纸层（axes）上可以进行各种图形的绘制，图形的组成元素在画纸上体现"\n      },\n      {\n          "value": "3",\n          "text": "画板层（figure）可以包含一张画纸绘制单个图，但是无法包含多张画纸绘制多个子图或者图中图。"\n      },\n  ]\n})\n\nipyquiz.QuizWidget(value=quizzes, quiz_id="__ipyquiz_quiz_id")\n')},m=function(){u("#platform-lock-hidden\n\nimport os\n# basepath与惠楚确认\nbasepath = os.path.expanduser('~/share/bby/')\n\n# 以下2选1, 请阅读博小鱼对接文档\n#os.chdir(basepath)\n#filepath = os.path.join(basepath, 'test.txt')")},x=function(){var e,n,u,s;return r(this,void 0,void 0,(function*(){const f=c.notebook.toJSON(),p=t.workRegx.exec(c.notebook.notebook_path),d=/user\/(dev-)?user-(\d+)/.exec(c.notebook.base_url);if(!p||!d)return void alert("工作路径匹配失败");const h="dev-"===d[1]?"dev.boyuai.com":"www.boyuai.com",v=Number(p[1]),g=p[2],y=`https://${h}/api/v1`,m=Number(d[2]),x=()=>r(this,void 0,void 0,(function*(){const e={content:f,userId:m,token:g};fetch(`${y}/learn/admin/lessons/${v}/jupyter`,{body:JSON.stringify(e),headers:{"content-type":"application/json"},method:"PUT"}).then((e=>{e.ok?alert("同步成功，请刷新博小鱼步骤页后查看，中途请不要运行代码"):e.json().then((e=>{const t=e.message||e.error||"原因未知";alert("同步失败, "+t)}))})).catch((e=>{console.error(e)}))}));try{i.parseStepsFromCells(f);try{for(var b,_=o(f.cells);!(b=yield _.next()).done;){const e=b.value;e.outputs&&(e.outputs=[],e.execution_count=null),Object.keys(e.metadata).forEach((t=>{t.startsWith("bxy")||delete e.metadata[t]}));const{type:t,code:n}=i.parseCodeCell(e.source);if("quiz"===t){const t=yield l.parseQuizQuestions({code:n,userId:m,lessonId:v,token:g,apiPrefix:y});if(null==t?void 0:t.statusCode){const e=new Error(`Quiz 解析失败: ${null==t?void 0:t.message}`);throw e.detail=n,e}if(!t.value||!t.value.length)throw new Error("Quiz 解析失败: 缺少选项");try{for(var w,k=(u=void 0,o(t.value));!(w=yield k.next()).done;){const n=w.value;if("string"==typeof n.id&&n.id.startsWith("uuid-")){const e=n.id.slice(5),r=yield l.getQuizQuestionByUUID({uuid:e,apiPrefix:y});if(!r.uuid)throw new Error(`Quiz 解析失败: 题库题目 ${e} 解析异常`);const o=t.value.findIndex((t=>t.id===`uuid-${e}`));if(-1===o)throw new Error(`Quiz 解析失败: 题库题目 ${e} 匹配失败`);const i=a.parseQuestionOptions(r);t.value[o]=Object.assign(Object.assign({},r),{id:r.uuid,options:i}),console.log("quiz quetion 更新完成",{question:t.value[o]})}e.metadata.bxyQuizStep||(e.metadata.bxyQuizStep={}),e.metadata.bxyQuizStep.json=t}}catch(e){u={error:e}}finally{try{w&&!w.done&&(s=k.return)&&(yield s.call(k))}finally{if(u)throw u.error}}}}}catch(t){e={error:t}}finally{try{b&&!b.done&&(n=_.return)&&(yield n.call(_))}finally{if(e)throw e.error}}x()}catch(e){c.dialog.modal({title:"可能存在错误，请确认是否同步",body:`<p style="margin-bottom: 8px">${(null==e?void 0:e.message)||"未知错误"}</p><pre>${(null==e?void 0:e.detail)||JSON.stringify(e)}</pre>`,sanitize:!1,buttons:{确认同步:{click:x},取消同步:{}}})}}))}},112:(e,t,n)=>{"use strict";var r,o;Object.defineProperty(t,"__esModule",{value:!0});const i=n(379),a=n(673);window.__webpack_public_path__=document.querySelector("body").getAttribute("data-base-url")+"nbextensions/ipybbycell",r=[n(636),n(273)],void 0===(o=((e,t)=>(window.requirejs.config({map:{"*":{ipybbycell:"nbextensions/ipybbycell/extension"}}}),{load_ipython_extension:function(){(i.workRegx.test(e.notebook.notebook_path)||location.host.includes("localhost"))&&(console.log("Current namespace:",e),i.registerBbyButtons(),t("#jupyter_bby_help").length>0||t("<li/>").append(t("<a/>").html("博小鱼文档").attr("title","博小鱼文档").attr("id","jupyter_bby_help").attr("href","https://fe9m1yda6v.feishu.cn/docs/doccnfjrG2MKIq7echn96kyuakc").attr("target","_blank").append(t("<i/>").addClass("fa fa-external-link menu-icon pull-right"))).insertBefore(t(t("#help_menu > .divider")[1])),a.registerBxyPanel())}})).apply(t,r))||(e.exports=o)},673:function(e,t,n){"use strict";var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.registerBxyPanel=void 0;const o=n(966),i=r(n(666)),a=window.Jupyter,l=window.$,c=window._;n(55),t.registerBxyPanel=()=>{f.init()};const u="显示博小鱼面板",s="隐藏博小鱼面板",f={init:()=>{console.log("bxy: Main constructor running.");const e=p.getAccessLevel();"create"===e&&d.ensureNotebookGetsBxyId(),f.initSetupButton(),a.notebook.metadata.bxyId&&d.loadManifest(e).then((()=>{f.initInteractivity()})).catch((e=>{console.log("bxy: Not setting up bxy because this notebook has never had any authoring done yet (no recordingId)."),console.log(e)}))},initSetupButton:()=>{let e,t=!1;if(a.notebook.metadata.bxyId)e=u;else{const n=l("#bxy-setup-button");n.length>0&&n.remove(),e="激活博小鱼面板",t=!0}const n=l('<div id="bxy-setup-button" style=display:none; class="btn-group"><button class="btn btn-default" title="博小鱼面板开关"><span>'+e+"</div></button></span>"),r=l("#maintoolbar-container");n.appendTo(r),t?l("#bxy-setup-button").click((()=>{f.firstTimeSetup()})):l("#bxy-setup-button").click((()=>{f.toggleAccessLevel()})),l("#bxy-setup-button").show()},initInteractivity:()=>{f.addEvents(),f.setupControlPanels(),f.updateControlPanels();for(const e of a.notebook.get_cells())f.refreshCellSideMarker(e)},firstTimeSetup:()=>{d.ensureNotebookGetsBxyId(),h.queueSaveNotebookCallback((()=>{f.initInteractivity(),f.toggleAccessLevel("create"),l("#bxy-setup-button").unbind("click").click((()=>{f.toggleAccessLevel()}))})),h.saveNotebookDebounced()},addEvents:()=>{a.notebook.events.on("select.Cell",((e,t)=>{console.log("bxy: cell select event fired, e, cell:",e,t.cell),f.updateControlPanels()})),a.notebook.events.on("create.Cell",((e,t)=>{const n=t.cell;void 0===h.getMetadataCellId(n.metadata)?h.setMetadataCellId(n.metadata,h.generateUniqueId()):h.getMetadataCellId(n.metadata),h.refreshCellMaps(),f.updateControlPanels()})),a.notebook.events.on("delete.Cell",((e,t)=>{console.log("bxy: cell delete event fired, e, cell:",e,t.cell),h.refreshCellMaps(),f.toggleAccessLevel("view")})),a.notebook.events.on("set_dirty.Notebook",((e,t)=>{h.refreshCellMaps()})),window.addEventListener("mousemove",(e=>{let t,n;p.setPointerPosition({x:e.clientX,y:e.clientY});const r=p.getPointerPosition(),o=f.sitePanel[0].getBoundingClientRect(),i=f.outerControlPanel.width(),a=f.outerControlPanel.height();if(p.getControlPanelDragging()){const e=p.getControlPanelDragOffset();t={x:r.x-e.left,y:r.y-e.top}}if(void 0!==t){n={x:Math.min(window.innerWidth-i-25,Math.max(0,t.x)),y:Math.min(o.bottom-a-25,Math.max(25,t.y))};const e={left:n.x+"px",top:n.y+"px",right:"unset"};f.outerControlPanel.css(e)}}))},changeAccessLevel:e=>{"create"===e?(d.ensureNotebookGetsBxyId(),h.assignCellIds(),h.queueSaveNotebookCallback((()=>{})),h.saveNotebookDebounced()):f.outerControlPanel.fadeOut(f.panelFadeTime),p.setAccessLevel(e),f.updateControlPanels()},toggleAccessLevel:e=>{let t;const n=void 0===e?p.getAccessLevel():e;void 0!==e?"create"===n?(t=s,f.changeAccessLevel("create")):(t=u,f.changeAccessLevel("view")):"create"===n?(t=u,f.changeAccessLevel("view")):(t=s,f.changeAccessLevel("create")),l("#bxy-setup-button span:last").text(t)},panelFadeTime:350,sitePanel:l(),outerControlPanel:l(),controlPanelsShell:l(),controlPanelIds:{},setupControlPanels:()=>{0===l("#bxy-outer-control-panel").length&&l('<div id="bxy-outer-control-panel">  <div id="bxy-inner-control-panel">    <div class="bxy-small-dot-pattern" id="bxy-drag-handle">&nbsp;&nbsp;</div>    <div id="bxy-control-panels-shell"></div>  </div></div>').appendTo(l("body")),f.sitePanel=l("#site"),f.outerControlPanel=l("#bxy-outer-control-panel"),f.outerControlPanel.hide(),f.controlPanelsShell=l("#bxy-control-panels-shell"),l("#bxy-drag-handle").on("mousedown",(e=>{f.startPanelDragging(e)})).on("mouseup",(e=>{p.getControlPanelDragging()&&(console.log("bxy: no longer dragging control panel"),p.setControlPanelDragging(!1),e.preventDefault(),e.stopPropagation())})),f.setupOneControlPanel("bxy-control-panel-title",'<div></div><div id="bxy-logo-text">博小鱼控制面板</div>'),f.setupOneControlPanel("bxy-notifier","<div />");const e=e=>e.on("focus",(()=>{a.keyboard_manager.disable()})).on("blur",(()=>{a.keyboard_manager.enable()})),t=(e,t)=>l('<div class="bxy-form-item" id="'+e+`"><span style="flex: 1;text-align-last: justify;">${t}</span></div>`);f.setupOneControlPanel("bxy-lesson-config",'<div class="bxy-config-title">单元配置</div>');const n=t("poster-template-item","海报模板ID");l("#bxy-lesson-config").append(n);const r=e(l('<input style="width: 130px;" />').attr("type","text").on("input",(e=>{const t=e.target.value;t?a.notebook.metadata.bxyPosterId=t:delete a.notebook.metadata.bxyPosterId})));l("#poster-template-item").append(r),f.setupOneControlPanel("bxy-cell-config",'<div class="bxy-config-title">Cell配置</div>');const i=t("poster-slot-item","海报素材占位ID");l("#bxy-cell-config").append(i);const c=e(l('<input style="width: 100px;" />').attr("type","text").on("input",(e=>{const t=e.target.value,n=a.notebook.get_selected_cell();t?n.metadata.bxyPosterSlotId=t:delete n.metadata.bxyPosterSlotId})));l("#poster-slot-item").append(c);const u=t("poster-quiz-option-item","海报Quiz占位ID");l("#bxy-cell-config").append(u);const s=e(l('<input style="width: 100px;" />').attr("type","text").on("input",(e=>{f.resetNotifier(),p.formHasError=!1;const t=e.target.value,n=a.notebook.get_selected_cell();try{n.metadata=o.markQuizOptionSlots(n.metadata,t)}catch(e){f.setNotifier((null==e?void 0:e.message)||"未知错误"),p.formHasError=!0}})));l("#poster-quiz-option-item").append(s),f.setupOneControlPanel("bxy-config-btns","");const d=()=>{h.saveNotebookDebounced();const e=a.notebook.get_selected_cell();f.refreshCellSideMarker(e),alert("保存成功")},v=l('<button class="bxy-save-btn">保存</button>').on("click",(()=>{p.formHasError?alert("请先改正配置"):d()})),g=l('<button class="bxy-close-btn">保存并关闭</button>').on("click",(()=>{p.formHasError?alert("请先改正配置"):(d(),f.toggleAccessLevel("view"))}));l("#bxy-config-btns").append(v),l("#bxy-config-btns").append(g)},updateControlPanels:()=>{const e=p.getAccessLevel(),t="none"===f.outerControlPanel.css("display");"create"===e&&t&&f.outerControlPanel.fadeIn(f.panelFadeTime),f.resetNotifier();const n=a.notebook.metadata.bxyPosterId;l("#poster-template-item input").val(n||"");const r=a.notebook.get_selected_cell().metadata,i=r.bxyPosterSlotId,c=o.parseQuizOptionSlots(r);l("#poster-slot-item input").val(i||""),l("#poster-quiz-option-item input").val(c||""),f.showControlPanels(["bxy-notifier","bxy-lesson-config","bxy-cell-config","bxy-config-btns"])},showControlPanels:e=>{f.controlPanelsShell.children().hide(),f.controlPanelIds["bxy-control-panel-title"].css({display:"flex"});for(const t of e)f.controlPanelIds[t].show()},setupOneControlPanel:(e,t,n)=>{void 0===f.controlPanelIds&&(f.controlPanelIds={}),l('<div class="bxy-control-panel" id="'+e+'">'+t+"</div>").appendTo(f.controlPanelsShell),f.controlPanelIds[e]=f.controlPanelsShell.find("#"+e),f.bindControlPanelCallbacks(f.controlPanelIds[e],n)},bindControlPanelCallbacks:(e,t)=>{if(void 0!==t){let n,r;for(n of t)for(r of n.ids)e.find("#"+r).on(n.event,n.fn)}},startPanelDragging:e=>{console.log("bxy: dragging control panel");const t=f.outerControlPanel.position(),n=p.getPointerPosition();p.setControlPanelDragging(!0),p.setControlPanelDragOffset({left:n.x-t.left,top:n.y-t.top}),e.preventDefault(),e.stopPropagation()},refreshCellSideMarker:e=>{const t=l(e.element[0]);if(t.find(".bxy-right-side-marker").unbind("mouseenter mouseleave click").remove(),!e.metadata.bxyCellId)return;if(Object.keys(e.metadata).filter((e=>e.startsWith("bxy"))).length<=1)return;const n=i.default.makeRightSideMarker({color:"#ffc963",dimensions:{x:t.width()+12,y:10,width:18,height:12},metaTag:"bxy-id|"+e.metadata.bxyCellId,title:"Cell 含有博小鱼特殊配置"});l(n).appendTo(t);const r=t.find(".bxy-right-side-marker");r.length>0&&r.on("click",(()=>{f.toggleAccessLevel("create")}))},notificationMsgs:{},setNotifier:(e,t)=>{const n=f.controlPanelIds["bxy-notifier"];if(n.show().children().hide(),!f.notificationMsgs.hasOwnProperty(e)){const r="bxy-notification-"+h.generateUniqueId();l('<div id="'+r+'">'+e+"</div>").appendTo(n);const o=n.find("#"+r);f.notificationMsgs[e]=o,f.bindControlPanelCallbacks(o,t)}f.notificationMsgs[e].show()},resetNotifier:()=>{f.setNotifier('<div><a target="_blank" href="https://fe9m1yda6v.feishu.cn/docs/doccnQKBB3HazZtDhZYcHaunUte">使用说明</a></div>')}},p={formHasError:!1,accessLevel:"view",getAccessLevel:()=>p.accessLevel,setAccessLevel:e=>p.accessLevel=e,manifest:{},getManifest:()=>p.manifest,controlPanelDragging:!1,getControlPanelDragging:()=>p.controlPanelDragging,setControlPanelDragging:e=>{p.controlPanelDragging=e},controlPanelDragOffset:{left:0,top:0},getControlPanelDragOffset:()=>p.controlPanelDragOffset,setControlPanelDragOffset:e=>{p.controlPanelDragOffset=e},pointer:{x:0,y:0},getPointerPosition:()=>p.pointer,setPointerPosition:e=>{p.pointer=e}},d={ensureNotebookGetsBxyId:()=>{const e=a.notebook;e.metadata.bxyId||(e.metadata.bxyId=h.generateUniqueId()),h.assignCellIds(),h.refreshCellMaps(),console.log("bxy: Notebook is now ready to use bxy.")},loadManifest:e=>{if(!a.notebook.metadata.bxyId){if("create"!==e)return console.log('bxy: loadManifest is bailing early because we are not in "create" mode and this notebook has no bxy id.'),Promise.reject();d.ensureNotebookGetsBxyId()}return Promise.resolve()}},h={saveNotebookCallbacks:[],queueSaveNotebookCallback:e=>{h.saveNotebookCallbacks.push(e)},generateUniqueId:()=>"id_"+Math.random().toString(36).substr(2,7),assignCellIds:()=>{const e=a.notebook.get_cells();let t,n;for(let r=0;r<e.length;++r)t=e[r],n=h.generateUniqueId(),void 0===h.getMetadataCellId(t.metadata)&&h.setMetadataCellId(t.metadata,n)},getMetadataCellId:e=>e.bxyCellId,setMetadataCellId:(e,t)=>(e.bxyCellId=t,t),processSaveNotebookCallbacks:()=>{let e;for(;h.saveNotebookCallbacks.length>0;)e=h.saveNotebookCallbacks.shift(),null==e||e();console.log("bxy: Notebook saved successfully.")},saveNotebook:()=>{a.notebook.save_notebook().then((()=>{h.processSaveNotebookCallbacks()})).catch((e=>{console.error("bxy: saveNotebook caught exception:",e)}))},saveDebounceTiming:1e3,saveNotebookDebounced:()=>{c.debounce(h.saveNotebook,h.saveDebounceTiming)()},createBxyTagRegex:()=>RegExp('<span class="bxy-highlight (bxy-[^"]+)">(.*?)</span>',"gm"),cellMaps:{},refreshCellMaps:()=>{let e,t,n,r,o;h.cellMaps={cells:a.notebook.get_cells(),maps:{},location:{}};const i=Object.keys(h.cellMaps.cells);for(let a=0;a<i.length;++a)if(e=h.cellMaps.cells[a],t=h.getMetadataCellId(e.metadata),h.cellMaps.maps[t]=a,e.hasOwnProperty("inner_cell")?n=l(e.inner_cell).parents(".cell"):e.hasOwnProperty("element")&&(n=l(e.element)),void 0!==n&&n.attr({"bxy-cell-id":h.getMetadataCellId(e.metadata)}),"markdown"===e.cell_type){const n=e.get_text();let i,a;for(r=h.createBxyTagRegex();null!==(i=r.exec(n));)a=i[1].match(/bxy-(id_.[^-]+)-(id_[^\s]+)/),o=(null==a?void 0:a[1])+"_"+(null==a?void 0:a[2]),h.cellMaps.location[o]=t}}}},475:function(e,t){"use strict";var n=this&&this.__awaiter||function(e,t,n,r){return new(n||(n=Promise))((function(o,i){function a(e){try{c(r.next(e))}catch(e){i(e)}}function l(e){try{c(r.throw(e))}catch(e){i(e)}}function c(e){var t;e.done?o(e.value):(t=e.value,t instanceof n?t:new n((function(e){e(t)}))).then(a,l)}c((r=r.apply(e,t||[])).next())}))};Object.defineProperty(t,"__esModule",{value:!0}),t.getQuizQuestionByUUID=t.parseQuizQuestions=void 0,t.parseQuizQuestions=({code:e,lessonId:t,userId:r,token:o,apiPrefix:i})=>n(void 0,void 0,void 0,(function*(){const n={code:e,lessonId:t,userId:r,token:o};return fetch(`${i}/jupyterhub/admin-widgets-parse/json`,{body:JSON.stringify(n),headers:{"content-type":"application/json"},method:"POST"}).then((e=>e.json()))})),t.getQuizQuestionByUUID=({uuid:e,apiPrefix:t})=>n(void 0,void 0,void 0,(function*(){return fetch(`${t}/quiz-questions/uuid/${e}`,{headers:{"content-type":"application/json"},method:"GET"}).then((e=>e.json()))}))},636:t=>{"use strict";t.exports=e},273:e=>{"use strict";e.exports=t}},r={};function o(e){var t=r[e];if(void 0!==t)return t.exports;var i=r[e]={id:e,loaded:!1,exports:{}};return n[e].call(i.exports,i,i.exports,o),i.loaded=!0,i.exports}return o.d=(e,t)=>{for(var n in t)o.o(t,n)&&!o.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),o.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),o.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),o(112)})()));
//# sourceMappingURL=extension.js.map