"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressBook = exports.AddressBookProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudfw_generated_1 = require("./cloudfw.generated");
Object.defineProperty(exports, "AddressBookProperty", { enumerable: true, get: function () { return cloudfw_generated_1.RosAddressBook; } });
/**
 * A ROS resource type:  `ALIYUN::CLOUDFW::AddressBook`
 */
class AddressBook extends ros.Resource {
    /**
     * Create a new `ALIYUN::CLOUDFW::AddressBook`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAddressBook = new cloudfw_generated_1.RosAddressBook(this, id, {
            groupName: props.groupName,
            description: props.description,
            tagRelation: props.tagRelation,
            groupType: props.groupType,
            tagList: props.tagList,
            regionId: props.regionId === undefined || props.regionId === null ? 'cn-hangzhou' : props.regionId,
            autoAddTagEcs: props.autoAddTagEcs === undefined || props.autoAddTagEcs === null ? false : props.autoAddTagEcs,
            addressList: props.addressList,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAddressBook;
        this.attrGroupUuid = rosAddressBook.attrGroupUuid;
    }
}
exports.AddressBook = AddressBook;
//# sourceMappingURL=data:application/json;base64,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