# coding: utf-8

"""
    EVR API

    OpenAPI Generator'i jaoks kohandatud EVR API kirjeldus. Kasuta seda juhul, kui spetsifikatsioonile vastava EVR API kirjeldusega ei õnnestu klienti genereerida.  # noqa: E501

    The version of the OpenAPI document: 1.5.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pyevr.openapi_client.api_client import ApiClient
from pyevr.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WaybillsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def waybills_add_shipments(self, number, add_shipments_to_waybill_request, **kwargs):  # noqa: E501
        """Veoselehele veose lisamine  # noqa: E501

        Lisab veoselehele uue veose. Veoseid saab lisada veoselehele vedaja ja veoselehe looja. Veoseid saab lisada ainult veos olevatele veoselehtedele.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_add_shipments(number, add_shipments_to_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param AddShipmentsToWaybillRequest add_shipments_to_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_add_shipments_with_http_info(number, add_shipments_to_waybill_request, **kwargs)  # noqa: E501

    def waybills_add_shipments_with_http_info(self, number, add_shipments_to_waybill_request, **kwargs):  # noqa: E501
        """Veoselehele veose lisamine  # noqa: E501

        Lisab veoselehele uue veose. Veoseid saab lisada veoselehele vedaja ja veoselehe looja. Veoseid saab lisada ainult veos olevatele veoselehtedele.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_add_shipments_with_http_info(number, add_shipments_to_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param AddShipmentsToWaybillRequest add_shipments_to_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'add_shipments_to_waybill_request',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_add_shipments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'number' is set
        if self.api_client.client_side_validation and ('number' not in local_var_params or  # noqa: E501
                                                        local_var_params['number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `number` when calling `waybills_add_shipments`")  # noqa: E501
        # verify the required parameter 'add_shipments_to_waybill_request' is set
        if self.api_client.client_side_validation and ('add_shipments_to_waybill_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_shipments_to_waybill_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_shipments_to_waybill_request` when calling `waybills_add_shipments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in local_var_params:
            path_params['number'] = local_var_params['number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_shipments_to_waybill_request' in local_var_params:
            body_params = local_var_params['add_shipments_to_waybill_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills/{number}/shipments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_cancel(self, number, cancel_waybill_request, **kwargs):  # noqa: E501
        """Veoselehe tühistamine  # noqa: E501

        Tühistab veoselehe. Veoselehe staatuseks märgitakse tühistatud (status: \"cancelled\"). Veoselehe saab tühistada veoselehe looja, kuni veoseleht pole veel vastu võetud.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_cancel(number, cancel_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param CancelWaybillRequest cancel_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_cancel_with_http_info(number, cancel_waybill_request, **kwargs)  # noqa: E501

    def waybills_cancel_with_http_info(self, number, cancel_waybill_request, **kwargs):  # noqa: E501
        """Veoselehe tühistamine  # noqa: E501

        Tühistab veoselehe. Veoselehe staatuseks märgitakse tühistatud (status: \"cancelled\"). Veoselehe saab tühistada veoselehe looja, kuni veoseleht pole veel vastu võetud.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_cancel_with_http_info(number, cancel_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param CancelWaybillRequest cancel_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'cancel_waybill_request',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_cancel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'number' is set
        if self.api_client.client_side_validation and ('number' not in local_var_params or  # noqa: E501
                                                        local_var_params['number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `number` when calling `waybills_cancel`")  # noqa: E501
        # verify the required parameter 'cancel_waybill_request' is set
        if self.api_client.client_side_validation and ('cancel_waybill_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['cancel_waybill_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `cancel_waybill_request` when calling `waybills_cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in local_var_params:
            path_params['number'] = local_var_params['number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cancel_waybill_request' in local_var_params:
            body_params = local_var_params['cancel_waybill_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills/{number}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_finish(self, number, **kwargs):  # noqa: E501
        """Veoselehe lõpetamine  # noqa: E501

        Lõpetab veoselehe ja veoselehe staatuseks märgitakse \"veoseleht lõpetatud\" (status: \"finished\"). Veoselehte saab lõpetada veoselehele märgitud saaja ja seda ainult \"koorem maas\" staatuses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_finish(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_finish_with_http_info(number, **kwargs)  # noqa: E501

    def waybills_finish_with_http_info(self, number, **kwargs):  # noqa: E501
        """Veoselehe lõpetamine  # noqa: E501

        Lõpetab veoselehe ja veoselehe staatuseks märgitakse \"veoseleht lõpetatud\" (status: \"finished\"). Veoselehte saab lõpetada veoselehele märgitud saaja ja seda ainult \"koorem maas\" staatuses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_finish_with_http_info(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_finish" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'number' is set
        if self.api_client.client_side_validation and ('number' not in local_var_params or  # noqa: E501
                                                        local_var_params['number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `number` when calling `waybills_finish`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in local_var_params:
            path_params['number'] = local_var_params['number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills/{number}/finish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_list(self, **kwargs):  # noqa: E501
        """Veoselehtede pärimine  # noqa: E501

        Tagastab filtritele vastavad veoselehed. Veoselehti saavad pärida ainult nendega seotud asutused.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime created_after: Filtreerib veoselehed, mis on loodud hiljem või samal ajal. Ajavahemik 'created_after' ning 'created_before' vahe peab jääma 1 kuu piiresse.
        :param datetime created_before: Filtreerib veoselehed, mis on loodud varem või samal ajal. Ajavahemik 'created_after' ning 'created_before' vahe peab jääma 1 kuu piiresse.
        :param datetime last_modified_after: Filtreerib veoselehed, mis on muutunud pärast määratud aega
        :param WaybillStatus status: Filtreerib veoselehed, mis vastavad määratud staatusele
        :param str owner_code: Filtreerib veoselehed, millel on sama omaniku kood
        :param str transporter_code: Filtreerib veoselehed, millel on sama transportija kood
        :param str receiver_code: Filtreerib veoselehed, millel on sama saaja kood
        :param str van_registration_number: Filtreerib veoselehed, millel on sama veoki registreerimisnumber (tõstutundlik)
        :param str trailer_registration_number: Filtreerib veoselehed, millel on sama haagise registreerimisnumber (tõstutundlik)
        :param str text: Vabateksti otsing. Toetatud on järgmine süntaks: * ilma jutumärkideta tekst: sõnade vahel rakendatakse loogiline JA. * jutumärkides tekst: otsitakse jutumärkides olevat lauset. * OR: loogiline VÕI operaator sõnade vahel. * -: loogiline EITUS.
        :param WaybillSortField sort: Sorteerib tulemused valitud välja järgi
        :param int page: Määrab tagastatava lehekülje
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResultOfWaybill
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_list_with_http_info(**kwargs)  # noqa: E501

    def waybills_list_with_http_info(self, **kwargs):  # noqa: E501
        """Veoselehtede pärimine  # noqa: E501

        Tagastab filtritele vastavad veoselehed. Veoselehti saavad pärida ainult nendega seotud asutused.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime created_after: Filtreerib veoselehed, mis on loodud hiljem või samal ajal. Ajavahemik 'created_after' ning 'created_before' vahe peab jääma 1 kuu piiresse.
        :param datetime created_before: Filtreerib veoselehed, mis on loodud varem või samal ajal. Ajavahemik 'created_after' ning 'created_before' vahe peab jääma 1 kuu piiresse.
        :param datetime last_modified_after: Filtreerib veoselehed, mis on muutunud pärast määratud aega
        :param WaybillStatus status: Filtreerib veoselehed, mis vastavad määratud staatusele
        :param str owner_code: Filtreerib veoselehed, millel on sama omaniku kood
        :param str transporter_code: Filtreerib veoselehed, millel on sama transportija kood
        :param str receiver_code: Filtreerib veoselehed, millel on sama saaja kood
        :param str van_registration_number: Filtreerib veoselehed, millel on sama veoki registreerimisnumber (tõstutundlik)
        :param str trailer_registration_number: Filtreerib veoselehed, millel on sama haagise registreerimisnumber (tõstutundlik)
        :param str text: Vabateksti otsing. Toetatud on järgmine süntaks: * ilma jutumärkideta tekst: sõnade vahel rakendatakse loogiline JA. * jutumärkides tekst: otsitakse jutumärkides olevat lauset. * OR: loogiline VÕI operaator sõnade vahel. * -: loogiline EITUS.
        :param WaybillSortField sort: Sorteerib tulemused valitud välja järgi
        :param int page: Määrab tagastatava lehekülje
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResultOfWaybill, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'created_after',
            'created_before',
            'last_modified_after',
            'status',
            'owner_code',
            'transporter_code',
            'receiver_code',
            'van_registration_number',
            'trailer_registration_number',
            'text',
            'sort',
            'page',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'created_after' in local_var_params and local_var_params['created_after'] is not None:  # noqa: E501
            query_params.append(('created_after', local_var_params['created_after']))  # noqa: E501
        if 'created_before' in local_var_params and local_var_params['created_before'] is not None:  # noqa: E501
            query_params.append(('created_before', local_var_params['created_before']))  # noqa: E501
        if 'last_modified_after' in local_var_params and local_var_params['last_modified_after'] is not None:  # noqa: E501
            query_params.append(('last_modified_after', local_var_params['last_modified_after']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'owner_code' in local_var_params and local_var_params['owner_code'] is not None:  # noqa: E501
            query_params.append(('owner_code', local_var_params['owner_code']))  # noqa: E501
        if 'transporter_code' in local_var_params and local_var_params['transporter_code'] is not None:  # noqa: E501
            query_params.append(('transporter_code', local_var_params['transporter_code']))  # noqa: E501
        if 'receiver_code' in local_var_params and local_var_params['receiver_code'] is not None:  # noqa: E501
            query_params.append(('receiver_code', local_var_params['receiver_code']))  # noqa: E501
        if 'van_registration_number' in local_var_params and local_var_params['van_registration_number'] is not None:  # noqa: E501
            query_params.append(('van_registration_number', local_var_params['van_registration_number']))  # noqa: E501
        if 'trailer_registration_number' in local_var_params and local_var_params['trailer_registration_number'] is not None:  # noqa: E501
            query_params.append(('trailer_registration_number', local_var_params['trailer_registration_number']))  # noqa: E501
        if 'text' in local_var_params and local_var_params['text'] is not None:  # noqa: E501
            query_params.append(('text', local_var_params['text']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultOfWaybill',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_get(self, number, **kwargs):  # noqa: E501
        """Veoselehe pärimine  # noqa: E501

        Tagastab numbrile vastava veoselehe. Veoselehte saavad pärida ainult sellega seotud asutused.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_get(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Päritava veoselehe number (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Waybill
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_get_with_http_info(number, **kwargs)  # noqa: E501

    def waybills_get_with_http_info(self, number, **kwargs):  # noqa: E501
        """Veoselehe pärimine  # noqa: E501

        Tagastab numbrile vastava veoselehe. Veoselehte saavad pärida ainult sellega seotud asutused.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_get_with_http_info(number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Päritava veoselehe number (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Waybill, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'number' is set
        if self.api_client.client_side_validation and ('number' not in local_var_params or  # noqa: E501
                                                        local_var_params['number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `number` when calling `waybills_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in local_var_params:
            path_params['number'] = local_var_params['number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Waybill',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_post(self, start_waybill_request, **kwargs):  # noqa: E501
        """Veoselehe loomine  # noqa: E501

        Loob veoselehe staatusega \"vedu alustatud\" (status: \"shipping\"). Veo alustaja peab olema ise märgitud veoselehele kas omanikuks või vedajaks. Toimingu õnnestumisel tagastatakse loodud veoselehe number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_post(start_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWaybillRequest start_waybill_request: Veoselehe andmed (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_post_with_http_info(start_waybill_request, **kwargs)  # noqa: E501

    def waybills_post_with_http_info(self, start_waybill_request, **kwargs):  # noqa: E501
        """Veoselehe loomine  # noqa: E501

        Loob veoselehe staatusega \"vedu alustatud\" (status: \"shipping\"). Veo alustaja peab olema ise märgitud veoselehele kas omanikuks või vedajaks. Toimingu õnnestumisel tagastatakse loodud veoselehe number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_post_with_http_info(start_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StartWaybillRequest start_waybill_request: Veoselehe andmed (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'start_waybill_request',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'start_waybill_request' is set
        if self.api_client.client_side_validation and ('start_waybill_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_waybill_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_waybill_request` when calling `waybills_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'start_waybill_request' in local_var_params:
            body_params = local_var_params['start_waybill_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def waybills_unload(self, number, unload_waybill_request, **kwargs):  # noqa: E501
        """Veoselehel veo lõpetamine  # noqa: E501

        Lõpetab veo veoselehel ja veoselehe staatuseks märgitakse \"koorem maas\" (status: \"unloaded\"). Vedu saab lõpetada veoselehe looja või vedaja ja seda ainult \"vedu alustatud\" (status: shipping) staatuses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_unload(number, unload_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param UnloadWaybillRequest unload_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.waybills_unload_with_http_info(number, unload_waybill_request, **kwargs)  # noqa: E501

    def waybills_unload_with_http_info(self, number, unload_waybill_request, **kwargs):  # noqa: E501
        """Veoselehel veo lõpetamine  # noqa: E501

        Lõpetab veo veoselehel ja veoselehe staatuseks märgitakse \"koorem maas\" (status: \"unloaded\"). Vedu saab lõpetada veoselehe looja või vedaja ja seda ainult \"vedu alustatud\" (status: shipping) staatuses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.waybills_unload_with_http_info(number, unload_waybill_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str number: Veoselehe number (required)
        :param UnloadWaybillRequest unload_waybill_request: (required)
        :param str evr_language: Defineerib keele tagastatavatele veateadetele (toetatud on väärtused \"et\" eesti keele ning \"en\" inglise keele jaoks).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'unload_waybill_request',
            'evr_language'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method waybills_unload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'number' is set
        if self.api_client.client_side_validation and ('number' not in local_var_params or  # noqa: E501
                                                        local_var_params['number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `number` when calling `waybills_unload`")  # noqa: E501
        # verify the required parameter 'unload_waybill_request' is set
        if self.api_client.client_side_validation and ('unload_waybill_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['unload_waybill_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unload_waybill_request` when calling `waybills_unload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'number' in local_var_params:
            path_params['number'] = local_var_params['number']  # noqa: E501

        query_params = []

        header_params = {}
        if 'evr_language' in local_var_params:
            header_params['EVR-LANGUAGE'] = local_var_params['evr_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unload_waybill_request' in local_var_params:
            body_params = local_var_params['unload_waybill_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['SecretApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/waybills/{number}/unload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
