import * as dynamodb from '@aws-cdk/aws-dynamodb';
import { Schedule } from '@aws-cdk/aws-events';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface CompliantDynamoDbProps extends dynamodb.TableProps {
    /**
     * @stability stable
     */
    readonly backupVaultName?: string;
    /**
     * @stability stable
     */
    readonly backupPlanStartTime?: Schedule;
}
/**
 * @stability stable
 * @description creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
export declare class CompliantDynamoDb extends dynamodb.Table {
    /**
     * @stability stable
     */
    readonly dynamodbTable: dynamodb.Table;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: CompliantDynamoDbProps);
}
