# Generated by Django 3.1.12 on 2021-07-07 12:23

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("authentication", "0017_remove_fleetup_permission"),
        ("structures", "0026_rework_update_status"),
    ]

    operations = [
        migrations.AlterField(
            model_name="notification",
            name="timestamp",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="owner",
            name="character_ownership",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="OUTDATED. Has been replaced by OwnerCharacter",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="authentication.characterownership",
            ),
        ),
        migrations.CreateModel(
            name="OwnerCharacter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "last_used_at",
                    models.DateTimeField(
                        db_index=True,
                        default=None,
                        editable=False,
                        help_text="when this character was last used for sync",
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "character_ownership",
                    models.ForeignKey(
                        help_text="character used for syncing",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="characters",
                        to="structures.owner",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="ownercharacter",
            constraint=models.UniqueConstraint(
                fields=("owner", "character_ownership"), name="functional_pk_ownertoken"
            ),
        ),
    ]
