# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class ApplicationComponentDeploymentParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        component_name: str = None,
        deploy_scope: str = None,
        node_group_id_list: List[str] = None,
        node_id_list: List[str] = None,
    ):
        # applicationName
        self.application_name = application_name
        # componentName
        self.component_name = component_name
        # deployScope
        self.deploy_scope = deploy_scope
        # nodeGroupIdList
        self.node_group_id_list = node_group_id_list
        # nodeIdList
        self.node_id_list = node_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.deploy_scope is not None:
            result['deployScope'] = self.deploy_scope
        if self.node_group_id_list is not None:
            result['nodeGroupIdList'] = self.node_group_id_list
        if self.node_id_list is not None:
            result['nodeIdList'] = self.node_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('deployScope') is not None:
            self.deploy_scope = m.get('deployScope')
        if m.get('nodeGroupIdList') is not None:
            self.node_group_id_list = m.get('nodeGroupIdList')
        if m.get('nodeIdList') is not None:
            self.node_id_list = m.get('nodeIdList')
        return self


class ApplicationConfigParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_item_value: str = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configItemValue
        self.config_item_value = config_item_value
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_value is not None:
            result['configItemValue'] = self.config_item_value
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemValue') is not None:
            self.config_item_value = m.get('configItemValue')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class ApplicationParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # applicationVersion
        self.application_version = application_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        return self


class AddApplicationParam(TeaModel):
    def __init__(
        self,
        application_component_deployment_list: List[ApplicationComponentDeploymentParam] = None,
        application_config_list: List[ApplicationConfigParam] = None,
        application_list: List[ApplicationParam] = None,
        auto_recommend_config: bool = None,
        client_token: str = None,
        cluster_id: str = None,
        description: str = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # 应用组件部署列表。
        self.application_component_deployment_list = application_component_deployment_list
        # 应用配置列表。
        self.application_config_list = application_config_list
        # 应用列表。
        self.application_list = application_list
        # 是否自动推荐配置。
        self.auto_recommend_config = auto_recommend_config
        # 请求幂等参数
        self.client_token = client_token
        # 集群ID。
        self.cluster_id = cluster_id
        # 描述。
        self.description = description
        # 操作人员ID。
        self.operate_user_id = operate_user_id
        # 产品角色。
        self.product_role_name = product_role_name
        # 资源所有者ID。
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.application_component_deployment_list:
            for k in self.application_component_deployment_list:
                if k:
                    k.validate()
        if self.application_config_list:
            for k in self.application_config_list:
                if k:
                    k.validate()
        if self.application_list:
            for k in self.application_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationComponentDeploymentList'] = []
        if self.application_component_deployment_list is not None:
            for k in self.application_component_deployment_list:
                result['applicationComponentDeploymentList'].append(k.to_map() if k else None)
        result['applicationConfigList'] = []
        if self.application_config_list is not None:
            for k in self.application_config_list:
                result['applicationConfigList'].append(k.to_map() if k else None)
        result['applicationList'] = []
        if self.application_list is not None:
            for k in self.application_list:
                result['applicationList'].append(k.to_map() if k else None)
        if self.auto_recommend_config is not None:
            result['autoRecommendConfig'] = self.auto_recommend_config
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_component_deployment_list = []
        if m.get('applicationComponentDeploymentList') is not None:
            for k in m.get('applicationComponentDeploymentList'):
                temp_model = ApplicationComponentDeploymentParam()
                self.application_component_deployment_list.append(temp_model.from_map(k))
        self.application_config_list = []
        if m.get('applicationConfigList') is not None:
            for k in m.get('applicationConfigList'):
                temp_model = ApplicationConfigParam()
                self.application_config_list.append(temp_model.from_map(k))
        self.application_list = []
        if m.get('applicationList') is not None:
            for k in m.get('applicationList'):
                temp_model = ApplicationParam()
                self.application_list.append(temp_model.from_map(k))
        if m.get('autoRecommendConfig') is not None:
            self.auto_recommend_config = m.get('autoRecommendConfig')
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class AddProductAndCallerParam(TeaModel):
    def __init__(
        self,
        product_caller_id: str = None,
        product_name: str = None,
    ):
        # productCallerId
        self.product_caller_id = product_caller_id
        # productName
        self.product_name = product_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_caller_id is not None:
            result['productCallerId'] = self.product_caller_id
        if self.product_name is not None:
            result['productName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('productCallerId') is not None:
            self.product_caller_id = m.get('productCallerId')
        if m.get('productName') is not None:
            self.product_name = m.get('productName')
        return self


class AddSuspendPointOnWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        last_suspend_activity_instance_id: int = None,
        range_closed: bool = None,
        workflow_instance_id: int = None,
    ):
        # 最后一个暂停点所在的活动实例Id
        self.last_suspend_activity_instance_id = last_suspend_activity_instance_id
        # 是否闭空间
        self.range_closed = range_closed
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_suspend_activity_instance_id is not None:
            result['lastSuspendActivityInstanceId'] = self.last_suspend_activity_instance_id
        if self.range_closed is not None:
            result['rangeClosed'] = self.range_closed
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lastSuspendActivityInstanceId') is not None:
            self.last_suspend_activity_instance_id = m.get('lastSuspendActivityInstanceId')
        if m.get('rangeClosed') is not None:
            self.range_closed = m.get('rangeClosed')
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class ApplicationAction(TeaModel):
    def __init__(
        self,
        component_name: str = None,
        description: str = None,
        name: str = None,
    ):
        # componentName
        self.component_name = component_name
        # description
        self.description = description
        # name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class AutoScalingConfig(TeaModel):
    def __init__(
        self,
        auto_scaling_metric_names: List[str] = None,
        load_measure_metric_name: str = None,
        max_adjustment_value: int = None,
        support_decommission_with_graceful: bool = None,
    ):
        # autoScalingMetricNames
        self.auto_scaling_metric_names = auto_scaling_metric_names
        # loadMeasureMetricName
        self.load_measure_metric_name = load_measure_metric_name
        # maxAdjustmentValue
        self.max_adjustment_value = max_adjustment_value
        # supportDecommissionWithGraceful
        self.support_decommission_with_graceful = support_decommission_with_graceful

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_scaling_metric_names is not None:
            result['autoScalingMetricNames'] = self.auto_scaling_metric_names
        if self.load_measure_metric_name is not None:
            result['loadMeasureMetricName'] = self.load_measure_metric_name
        if self.max_adjustment_value is not None:
            result['maxAdjustmentValue'] = self.max_adjustment_value
        if self.support_decommission_with_graceful is not None:
            result['supportDecommissionWithGraceful'] = self.support_decommission_with_graceful
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoScalingMetricNames') is not None:
            self.auto_scaling_metric_names = m.get('autoScalingMetricNames')
        if m.get('loadMeasureMetricName') is not None:
            self.load_measure_metric_name = m.get('loadMeasureMetricName')
        if m.get('maxAdjustmentValue') is not None:
            self.max_adjustment_value = m.get('maxAdjustmentValue')
        if m.get('supportDecommissionWithGraceful') is not None:
            self.support_decommission_with_graceful = m.get('supportDecommissionWithGraceful')
        return self


class IntValueConstraint(TeaModel):
    def __init__(
        self,
        default_value: int = None,
        max: int = None,
        min: int = None,
        step: int = None,
        type: str = None,
        values: List[int] = None,
    ):
        # defaultValue
        self.default_value = default_value
        # max
        self.max = max
        # min
        self.min = min
        # step
        self.step = step
        # type
        self.type = type
        # values
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['defaultValue'] = self.default_value
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.step is not None:
            result['step'] = self.step
        if self.type is not None:
            result['type'] = self.type
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultValue') is not None:
            self.default_value = m.get('defaultValue')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('step') is not None:
            self.step = m.get('step')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class DeployModeNodeCountConstraint(TeaModel):
    def __init__(
        self,
        deploy_mode: str = None,
        node_count_constraint: IntValueConstraint = None,
    ):
        # deployMode
        self.deploy_mode = deploy_mode
        # nodeCountConstraint
        self.node_count_constraint = node_count_constraint

    def validate(self):
        if self.node_count_constraint:
            self.node_count_constraint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.node_count_constraint is not None:
            result['nodeCountConstraint'] = self.node_count_constraint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('nodeCountConstraint') is not None:
            temp_model = IntValueConstraint()
            self.node_count_constraint = temp_model.from_map(m['nodeCountConstraint'])
        return self


class ComponentMeta(TeaModel):
    def __init__(
        self,
        affinity_components: List[str] = None,
        anti_affinity_components: List[str] = None,
        deploy_mode_node_count_constraints: List[DeployModeNodeCountConstraint] = None,
        description: str = None,
        layout_node_groups: List[str] = None,
        layout_type: str = None,
        name: str = None,
    ):
        # affinityComponents
        self.affinity_components = affinity_components
        # antiAffinityComponents
        self.anti_affinity_components = anti_affinity_components
        # deployModeNodeCountConstraints
        self.deploy_mode_node_count_constraints = deploy_mode_node_count_constraints
        # description
        self.description = description
        # layoutNodeGroups
        self.layout_node_groups = layout_node_groups
        # layoutType
        self.layout_type = layout_type
        # name
        self.name = name

    def validate(self):
        if self.deploy_mode_node_count_constraints:
            for k in self.deploy_mode_node_count_constraints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affinity_components is not None:
            result['affinityComponents'] = self.affinity_components
        if self.anti_affinity_components is not None:
            result['antiAffinityComponents'] = self.anti_affinity_components
        result['deployModeNodeCountConstraints'] = []
        if self.deploy_mode_node_count_constraints is not None:
            for k in self.deploy_mode_node_count_constraints:
                result['deployModeNodeCountConstraints'].append(k.to_map() if k else None)
        if self.description is not None:
            result['description'] = self.description
        if self.layout_node_groups is not None:
            result['layoutNodeGroups'] = self.layout_node_groups
        if self.layout_type is not None:
            result['layoutType'] = self.layout_type
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('affinityComponents') is not None:
            self.affinity_components = m.get('affinityComponents')
        if m.get('antiAffinityComponents') is not None:
            self.anti_affinity_components = m.get('antiAffinityComponents')
        self.deploy_mode_node_count_constraints = []
        if m.get('deployModeNodeCountConstraints') is not None:
            for k in m.get('deployModeNodeCountConstraints'):
                temp_model = DeployModeNodeCountConstraint()
                self.deploy_mode_node_count_constraints.append(temp_model.from_map(k))
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('layoutNodeGroups') is not None:
            self.layout_node_groups = m.get('layoutNodeGroups')
        if m.get('layoutType') is not None:
            self.layout_type = m.get('layoutType')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ConfigItemMeta(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        read_only: bool = None,
        tags: List[str] = None,
        visible: bool = None,
    ):
        # description
        self.description = description
        # name
        self.name = name
        # readOnly
        self.read_only = read_only
        # tags
        self.tags = tags
        # visible
        self.visible = visible

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.tags is not None:
            result['tags'] = self.tags
        if self.visible is not None:
            result['visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('visible') is not None:
            self.visible = m.get('visible')
        return self


class ConfigFileMeta(TeaModel):
    def __init__(
        self,
        config_items: List[ConfigItemMeta] = None,
        description: str = None,
        index: int = None,
        name: str = None,
        read_only: bool = None,
        visible: bool = None,
    ):
        # configItems
        self.config_items = config_items
        # description
        self.description = description
        # index
        self.index = index
        # name
        self.name = name
        # readOnly
        self.read_only = read_only
        # visible
        self.visible = visible

    def validate(self):
        if self.config_items:
            for k in self.config_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['configItems'] = []
        if self.config_items is not None:
            for k in self.config_items:
                result['configItems'].append(k.to_map() if k else None)
        if self.description is not None:
            result['description'] = self.description
        if self.index is not None:
            result['index'] = self.index
        if self.name is not None:
            result['name'] = self.name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.visible is not None:
            result['visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_items = []
        if m.get('configItems') is not None:
            for k in m.get('configItems'):
                temp_model = ConfigItemMeta()
                self.config_items.append(temp_model.from_map(k))
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('visible') is not None:
            self.visible = m.get('visible')
        return self


class ConfigItem(TeaModel):
    def __init__(
        self,
        config_item_default_value: str = None,
        config_item_key: str = None,
        config_item_type: str = None,
    ):
        # configItemDefaultValue
        self.config_item_default_value = config_item_default_value
        # configItemKey
        self.config_item_key = config_item_key
        # configItemType
        self.config_item_type = config_item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_item_default_value is not None:
            result['configItemDefaultValue'] = self.config_item_default_value
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_type is not None:
            result['configItemType'] = self.config_item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configItemDefaultValue') is not None:
            self.config_item_default_value = m.get('configItemDefaultValue')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemType') is not None:
            self.config_item_type = m.get('configItemType')
        return self


class DependConfig(TeaModel):
    def __init__(
        self,
        condition_targets: List[str] = None,
        condition_type: str = None,
        config_file_name: str = None,
        config_items: List[ConfigItem] = None,
    ):
        # conditionTargets
        self.condition_targets = condition_targets
        # conditionType
        self.condition_type = condition_type
        # configFileName
        self.config_file_name = config_file_name
        # configItems
        self.config_items = config_items

    def validate(self):
        if self.config_items:
            for k in self.config_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_targets is not None:
            result['conditionTargets'] = self.condition_targets
        if self.condition_type is not None:
            result['conditionType'] = self.condition_type
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        result['configItems'] = []
        if self.config_items is not None:
            for k in self.config_items:
                result['configItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditionTargets') is not None:
            self.condition_targets = m.get('conditionTargets')
        if m.get('conditionType') is not None:
            self.condition_type = m.get('conditionType')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        self.config_items = []
        if m.get('configItems') is not None:
            for k in m.get('configItems'):
                temp_model = ConfigItem()
                self.config_items.append(temp_model.from_map(k))
        return self


class DeployModeDependency(TeaModel):
    def __init__(
        self,
        depend_applications: List[str] = None,
        depend_configs: List[DependConfig] = None,
        deploy_mode: str = None,
    ):
        # dependApplications
        self.depend_applications = depend_applications
        # dependConfigs
        self.depend_configs = depend_configs
        # deployMode
        self.deploy_mode = deploy_mode

    def validate(self):
        if self.depend_configs:
            for k in self.depend_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depend_applications is not None:
            result['dependApplications'] = self.depend_applications
        result['dependConfigs'] = []
        if self.depend_configs is not None:
            for k in self.depend_configs:
                result['dependConfigs'].append(k.to_map() if k else None)
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dependApplications') is not None:
            self.depend_applications = m.get('dependApplications')
        self.depend_configs = []
        if m.get('dependConfigs') is not None:
            for k in m.get('dependConfigs'):
                temp_model = DependConfig()
                self.depend_configs.append(temp_model.from_map(k))
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        return self


class ApplicationMeta(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        application_actions: List[ApplicationAction] = None,
        auto_scaling_config: AutoScalingConfig = None,
        component_metas: List[ComponentMeta] = None,
        config_files: List[ConfigFileMeta] = None,
        deploy_mode_dependencies: List[DeployModeDependency] = None,
        description: str = None,
        iaas_type: str = None,
        meta_store_types: List[str] = None,
        name: str = None,
        version: str = None,
    ):
        # appType
        self.app_type = app_type
        # applicationActions
        self.application_actions = application_actions
        # autoScalingConfig
        self.auto_scaling_config = auto_scaling_config
        # componentMetas
        self.component_metas = component_metas
        # configFiles
        self.config_files = config_files
        # deployModeDependencies
        self.deploy_mode_dependencies = deploy_mode_dependencies
        # description
        self.description = description
        # iaasType
        self.iaas_type = iaas_type
        # metaStoreTypes
        self.meta_store_types = meta_store_types
        # name
        self.name = name
        # version
        self.version = version

    def validate(self):
        if self.application_actions:
            for k in self.application_actions:
                if k:
                    k.validate()
        if self.auto_scaling_config:
            self.auto_scaling_config.validate()
        if self.component_metas:
            for k in self.component_metas:
                if k:
                    k.validate()
        if self.config_files:
            for k in self.config_files:
                if k:
                    k.validate()
        if self.deploy_mode_dependencies:
            for k in self.deploy_mode_dependencies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['appType'] = self.app_type
        result['applicationActions'] = []
        if self.application_actions is not None:
            for k in self.application_actions:
                result['applicationActions'].append(k.to_map() if k else None)
        if self.auto_scaling_config is not None:
            result['autoScalingConfig'] = self.auto_scaling_config.to_map()
        result['componentMetas'] = []
        if self.component_metas is not None:
            for k in self.component_metas:
                result['componentMetas'].append(k.to_map() if k else None)
        result['configFiles'] = []
        if self.config_files is not None:
            for k in self.config_files:
                result['configFiles'].append(k.to_map() if k else None)
        result['deployModeDependencies'] = []
        if self.deploy_mode_dependencies is not None:
            for k in self.deploy_mode_dependencies:
                result['deployModeDependencies'].append(k.to_map() if k else None)
        if self.description is not None:
            result['description'] = self.description
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.meta_store_types is not None:
            result['metaStoreTypes'] = self.meta_store_types
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appType') is not None:
            self.app_type = m.get('appType')
        self.application_actions = []
        if m.get('applicationActions') is not None:
            for k in m.get('applicationActions'):
                temp_model = ApplicationAction()
                self.application_actions.append(temp_model.from_map(k))
        if m.get('autoScalingConfig') is not None:
            temp_model = AutoScalingConfig()
            self.auto_scaling_config = temp_model.from_map(m['autoScalingConfig'])
        self.component_metas = []
        if m.get('componentMetas') is not None:
            for k in m.get('componentMetas'):
                temp_model = ComponentMeta()
                self.component_metas.append(temp_model.from_map(k))
        self.config_files = []
        if m.get('configFiles') is not None:
            for k in m.get('configFiles'):
                temp_model = ConfigFileMeta()
                self.config_files.append(temp_model.from_map(k))
        self.deploy_mode_dependencies = []
        if m.get('deployModeDependencies') is not None:
            for k in m.get('deployModeDependencies'):
                temp_model = DeployModeDependency()
                self.deploy_mode_dependencies.append(temp_model.from_map(k))
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('metaStoreTypes') is not None:
            self.meta_store_types = m.get('metaStoreTypes')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class ApplicationMetaDTO(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        application_actions: List[ApplicationAction] = None,
        component_metas: List[ComponentMeta] = None,
        config_files: List[ConfigFileMeta] = None,
        deploy_mode_dependencies: List[DeployModeDependency] = None,
        description: str = None,
        iaas_type: str = None,
        meta_store_types: List[str] = None,
        name: str = None,
        version: str = None,
    ):
        # appType
        self.app_type = app_type
        # applicationActions
        self.application_actions = application_actions
        # componentMetas
        self.component_metas = component_metas
        # configFiles
        self.config_files = config_files
        # deployModeDependencies
        self.deploy_mode_dependencies = deploy_mode_dependencies
        # description
        self.description = description
        # iaasType
        self.iaas_type = iaas_type
        # metaStoreTypes
        self.meta_store_types = meta_store_types
        # name
        self.name = name
        # version
        self.version = version

    def validate(self):
        if self.application_actions:
            for k in self.application_actions:
                if k:
                    k.validate()
        if self.component_metas:
            for k in self.component_metas:
                if k:
                    k.validate()
        if self.config_files:
            for k in self.config_files:
                if k:
                    k.validate()
        if self.deploy_mode_dependencies:
            for k in self.deploy_mode_dependencies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['appType'] = self.app_type
        result['applicationActions'] = []
        if self.application_actions is not None:
            for k in self.application_actions:
                result['applicationActions'].append(k.to_map() if k else None)
        result['componentMetas'] = []
        if self.component_metas is not None:
            for k in self.component_metas:
                result['componentMetas'].append(k.to_map() if k else None)
        result['configFiles'] = []
        if self.config_files is not None:
            for k in self.config_files:
                result['configFiles'].append(k.to_map() if k else None)
        result['deployModeDependencies'] = []
        if self.deploy_mode_dependencies is not None:
            for k in self.deploy_mode_dependencies:
                result['deployModeDependencies'].append(k.to_map() if k else None)
        if self.description is not None:
            result['description'] = self.description
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.meta_store_types is not None:
            result['metaStoreTypes'] = self.meta_store_types
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appType') is not None:
            self.app_type = m.get('appType')
        self.application_actions = []
        if m.get('applicationActions') is not None:
            for k in m.get('applicationActions'):
                temp_model = ApplicationAction()
                self.application_actions.append(temp_model.from_map(k))
        self.component_metas = []
        if m.get('componentMetas') is not None:
            for k in m.get('componentMetas'):
                temp_model = ComponentMeta()
                self.component_metas.append(temp_model.from_map(k))
        self.config_files = []
        if m.get('configFiles') is not None:
            for k in m.get('configFiles'):
                temp_model = ConfigFileMeta()
                self.config_files.append(temp_model.from_map(k))
        self.deploy_mode_dependencies = []
        if m.get('deployModeDependencies') is not None:
            for k in m.get('deployModeDependencies'):
                temp_model = DeployModeDependency()
                self.deploy_mode_dependencies.append(temp_model.from_map(k))
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('metaStoreTypes') is not None:
            self.meta_store_types = m.get('metaStoreTypes')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class BooleanResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # data
        self.data = data
        # message
        self.message = message
        # requestId
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ByLoadScalingRule(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        evaluation_count: int = None,
        metric_name: str = None,
        statistics: str = None,
        threshold: float = None,
        time_window: int = None,
    ):
        # 比较符号
        self.comparison_operator = comparison_operator
        # 评估次数
        self.evaluation_count = evaluation_count
        # 指标名称
        self.metric_name = metric_name
        # 统计方式
        self.statistics = statistics
        # 阈值
        self.threshold = threshold
        # 时间窗口
        self.time_window = time_window

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['comparisonOperator'] = self.comparison_operator
        if self.evaluation_count is not None:
            result['evaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['metricName'] = self.metric_name
        if self.statistics is not None:
            result['statistics'] = self.statistics
        if self.threshold is not None:
            result['threshold'] = self.threshold
        if self.time_window is not None:
            result['timeWindow'] = self.time_window
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('comparisonOperator') is not None:
            self.comparison_operator = m.get('comparisonOperator')
        if m.get('evaluationCount') is not None:
            self.evaluation_count = m.get('evaluationCount')
        if m.get('metricName') is not None:
            self.metric_name = m.get('metricName')
        if m.get('statistics') is not None:
            self.statistics = m.get('statistics')
        if m.get('threshold') is not None:
            self.threshold = m.get('threshold')
        if m.get('timeWindow') is not None:
            self.time_window = m.get('timeWindow')
        return self


class ByLoadScalingRuleSpec(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        evaluation_count: int = None,
        metric_name: str = None,
        statistics: str = None,
        threshold: float = None,
        time_window: int = None,
    ):
        # 比较符号
        self.comparison_operator = comparison_operator
        # 评估次数
        self.evaluation_count = evaluation_count
        # 指标名称
        self.metric_name = metric_name
        # 统计方式
        self.statistics = statistics
        # 阈值
        self.threshold = threshold
        # 时间窗口
        self.time_window = time_window

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['comparisonOperator'] = self.comparison_operator
        if self.evaluation_count is not None:
            result['evaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['metricName'] = self.metric_name
        if self.statistics is not None:
            result['statistics'] = self.statistics
        if self.threshold is not None:
            result['threshold'] = self.threshold
        if self.time_window is not None:
            result['timeWindow'] = self.time_window
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('comparisonOperator') is not None:
            self.comparison_operator = m.get('comparisonOperator')
        if m.get('evaluationCount') is not None:
            self.evaluation_count = m.get('evaluationCount')
        if m.get('metricName') is not None:
            self.metric_name = m.get('metricName')
        if m.get('statistics') is not None:
            self.statistics = m.get('statistics')
        if m.get('threshold') is not None:
            self.threshold = m.get('threshold')
        if m.get('timeWindow') is not None:
            self.time_window = m.get('timeWindow')
        return self


class ByTimeScalingRule(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        launch_time: int = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
    ):
        # 结束时间戳（秒）
        self.end_time = end_time
        # 启动时间戳（秒）
        self.launch_time = launch_time
        # 指定时间规则的执行类型
        self.recurrence_type = recurrence_type
        # 重复执行定时任务的数值
        self.recurrence_value = recurrence_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.launch_time is not None:
            result['launchTime'] = self.launch_time
        if self.recurrence_type is not None:
            result['recurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['recurrenceValue'] = self.recurrence_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('launchTime') is not None:
            self.launch_time = m.get('launchTime')
        if m.get('recurrenceType') is not None:
            self.recurrence_type = m.get('recurrenceType')
        if m.get('recurrenceValue') is not None:
            self.recurrence_value = m.get('recurrenceValue')
        return self


class ByTimeScalingRuleSpec(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        launch_time: int = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
    ):
        # 结束时间戳（秒）
        self.end_time = end_time
        # 启动时间戳（秒）
        self.launch_time = launch_time
        # 指定时间规则的执行类型
        self.recurrence_type = recurrence_type
        # 重复执行定时任务的数值
        self.recurrence_value = recurrence_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.launch_time is not None:
            result['launchTime'] = self.launch_time
        if self.recurrence_type is not None:
            result['recurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['recurrenceValue'] = self.recurrence_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('launchTime') is not None:
            self.launch_time = m.get('launchTime')
        if m.get('recurrenceType') is not None:
            self.recurrence_type = m.get('recurrenceType')
        if m.get('recurrenceValue') is not None:
            self.recurrence_value = m.get('recurrenceValue')
        return self


class CancelClusterOrdersParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class CancelOrderGroupParam(TeaModel):
    def __init__(
        self,
        order_group_id: str = None,
        user_id: int = None,
    ):
        # 订单组ID
        self.order_group_id = order_group_id
        # 用户ID
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_group_id is not None:
            result['orderGroupId'] = self.order_group_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('orderGroupId') is not None:
            self.order_group_id = m.get('orderGroupId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class ClusterBaseParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        creator: str = None,
        modifier: str = None,
        product: str = None,
        region_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # creator
        self.creator = creator
        # modifier
        self.modifier = modifier
        # product
        self.product = product
        # regionId
        self.region_id = region_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.creator is not None:
            result['creator'] = self.creator
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.product is not None:
            result['product'] = self.product
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ClusterDTO(TeaModel):
    def __init__(
        self,
        auto_renew: bool = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_status: str = None,
        cluster_type: str = None,
        creator: str = None,
        deploy_mode: str = None,
        deployment_set_id: str = None,
        deposit_type: str = None,
        enable_deployment_set: bool = None,
        expire_time: int = None,
        fail_reason: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        has_uncompleted_order: bool = None,
        iaa_stype: str = None,
        main_version: str = None,
        modifier: str = None,
        node_ram_role: str = None,
        payment_type: str = None,
        product_role_name: str = None,
        region_id: str = None,
        resource_owner_id: str = None,
        security_mode: str = None,
        vpc_id: str = None,
    ):
        # autoRenew
        self.auto_renew = auto_renew
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # clusterStatus
        self.cluster_status = cluster_status
        # clusterType
        self.cluster_type = cluster_type
        # creator
        self.creator = creator
        # deployMode
        self.deploy_mode = deploy_mode
        # deploymentSetId
        self.deployment_set_id = deployment_set_id
        # depositType
        self.deposit_type = deposit_type
        # enableDeploymentSet
        self.enable_deployment_set = enable_deployment_set
        # expireTime
        self.expire_time = expire_time
        # failReason
        self.fail_reason = fail_reason
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # hasUncompletedOrder
        self.has_uncompleted_order = has_uncompleted_order
        # iaaSType
        self.iaa_stype = iaa_stype
        # mainVersion
        self.main_version = main_version
        # modifier
        self.modifier = modifier
        # nodeRamRole
        self.node_ram_role = node_ram_role
        # paymentType
        self.payment_type = payment_type
        # productRoleName
        self.product_role_name = product_role_name
        # regionId
        self.region_id = region_id
        # resourceOwnerId
        self.resource_owner_id = resource_owner_id
        # securityMode
        self.security_mode = security_mode
        # vpcId
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['autoRenew'] = self.auto_renew
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.cluster_status is not None:
            result['clusterStatus'] = self.cluster_status
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.creator is not None:
            result['creator'] = self.creator
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.deployment_set_id is not None:
            result['deploymentSetId'] = self.deployment_set_id
        if self.deposit_type is not None:
            result['depositType'] = self.deposit_type
        if self.enable_deployment_set is not None:
            result['enableDeploymentSet'] = self.enable_deployment_set
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.fail_reason is not None:
            result['failReason'] = self.fail_reason
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.has_uncompleted_order is not None:
            result['hasUncompletedOrder'] = self.has_uncompleted_order
        if self.iaa_stype is not None:
            result['iaaSType'] = self.iaa_stype
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.node_ram_role is not None:
            result['nodeRamRole'] = self.node_ram_role
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['resourceOwnerId'] = self.resource_owner_id
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoRenew') is not None:
            self.auto_renew = m.get('autoRenew')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('clusterStatus') is not None:
            self.cluster_status = m.get('clusterStatus')
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('deploymentSetId') is not None:
            self.deployment_set_id = m.get('deploymentSetId')
        if m.get('depositType') is not None:
            self.deposit_type = m.get('depositType')
        if m.get('enableDeploymentSet') is not None:
            self.enable_deployment_set = m.get('enableDeploymentSet')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('failReason') is not None:
            self.fail_reason = m.get('failReason')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('hasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('hasUncompletedOrder')
        if m.get('iaaSType') is not None:
            self.iaa_stype = m.get('iaaSType')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('nodeRamRole') is not None:
            self.node_ram_role = m.get('nodeRamRole')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('resourceOwnerId') is not None:
            self.resource_owner_id = m.get('resourceOwnerId')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class ClusterDisk(TeaModel):
    def __init__(
        self,
        category: str = None,
        device: str = None,
        disk_id: str = None,
        mount_path: str = None,
        node_id: str = None,
        payment_type: str = None,
        real_mount_path: str = None,
        serial_number: str = None,
        size: int = None,
        status: str = None,
        type: str = None,
    ):
        # category
        self.category = category
        # device
        self.device = device
        # diskId
        self.disk_id = disk_id
        # mountPath
        self.mount_path = mount_path
        # nodeId
        self.node_id = node_id
        # paymentType
        self.payment_type = payment_type
        # realMountPath
        self.real_mount_path = real_mount_path
        # serialNumber
        self.serial_number = serial_number
        # size
        self.size = size
        # status
        self.status = status
        # type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.device is not None:
            result['device'] = self.device
        if self.disk_id is not None:
            result['diskId'] = self.disk_id
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.real_mount_path is not None:
            result['realMountPath'] = self.real_mount_path
        if self.serial_number is not None:
            result['serialNumber'] = self.serial_number
        if self.size is not None:
            result['size'] = self.size
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('device') is not None:
            self.device = m.get('device')
        if m.get('diskId') is not None:
            self.disk_id = m.get('diskId')
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('realMountPath') is not None:
            self.real_mount_path = m.get('realMountPath')
        if m.get('serialNumber') is not None:
            self.serial_number = m.get('serialNumber')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ClusterPriceDTO(TeaModel):
    def __init__(
        self,
        code: str = None,
        currency: str = None,
        discount_amount: float = None,
        handling_fee_amount: float = None,
        message: str = None,
        original_amount: float = None,
        product: str = None,
        ri_cycle_amount: float = None,
        rule_ids: List[int] = None,
        tax_amount: float = None,
        trade_amount: float = None,
    ):
        # code
        self.code = code
        # currency
        self.currency = currency
        # discountAmount
        self.discount_amount = discount_amount
        # handlingFeeAmount
        self.handling_fee_amount = handling_fee_amount
        # message
        self.message = message
        # originalAmount
        self.original_amount = original_amount
        # product
        self.product = product
        # riCycleAmount
        self.ri_cycle_amount = ri_cycle_amount
        # ruleIds
        self.rule_ids = rule_ids
        # taxAmount
        self.tax_amount = tax_amount
        # tradeAmount
        self.trade_amount = trade_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.currency is not None:
            result['currency'] = self.currency
        if self.discount_amount is not None:
            result['discountAmount'] = self.discount_amount
        if self.handling_fee_amount is not None:
            result['handlingFeeAmount'] = self.handling_fee_amount
        if self.message is not None:
            result['message'] = self.message
        if self.original_amount is not None:
            result['originalAmount'] = self.original_amount
        if self.product is not None:
            result['product'] = self.product
        if self.ri_cycle_amount is not None:
            result['riCycleAmount'] = self.ri_cycle_amount
        if self.rule_ids is not None:
            result['ruleIds'] = self.rule_ids
        if self.tax_amount is not None:
            result['taxAmount'] = self.tax_amount
        if self.trade_amount is not None:
            result['tradeAmount'] = self.trade_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('discountAmount') is not None:
            self.discount_amount = m.get('discountAmount')
        if m.get('handlingFeeAmount') is not None:
            self.handling_fee_amount = m.get('handlingFeeAmount')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('originalAmount') is not None:
            self.original_amount = m.get('originalAmount')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('riCycleAmount') is not None:
            self.ri_cycle_amount = m.get('riCycleAmount')
        if m.get('ruleIds') is not None:
            self.rule_ids = m.get('ruleIds')
        if m.get('taxAmount') is not None:
            self.tax_amount = m.get('taxAmount')
        if m.get('tradeAmount') is not None:
            self.trade_amount = m.get('tradeAmount')
        return self


class ClusterScriptDTO(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        last_edit_time: int = None,
        script_args: str = None,
        script_content: str = None,
        script_content_spec: str = None,
        script_name: str = None,
        script_path: str = None,
        script_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # lastEditTime
        self.last_edit_time = last_edit_time
        # scriptArgs
        self.script_args = script_args
        # scriptContent
        self.script_content = script_content
        # scriptContentSpec
        self.script_content_spec = script_content_spec
        # scriptName
        self.script_name = script_name
        # scriptPath
        self.script_path = script_path
        # scriptType
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.last_edit_time is not None:
            result['lastEditTime'] = self.last_edit_time
        if self.script_args is not None:
            result['scriptArgs'] = self.script_args
        if self.script_content is not None:
            result['scriptContent'] = self.script_content
        if self.script_content_spec is not None:
            result['scriptContentSpec'] = self.script_content_spec
        if self.script_name is not None:
            result['scriptName'] = self.script_name
        if self.script_path is not None:
            result['scriptPath'] = self.script_path
        if self.script_type is not None:
            result['scriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('lastEditTime') is not None:
            self.last_edit_time = m.get('lastEditTime')
        if m.get('scriptArgs') is not None:
            self.script_args = m.get('scriptArgs')
        if m.get('scriptContent') is not None:
            self.script_content = m.get('scriptContent')
        if m.get('scriptContentSpec') is not None:
            self.script_content_spec = m.get('scriptContentSpec')
        if m.get('scriptName') is not None:
            self.script_name = m.get('scriptName')
        if m.get('scriptPath') is not None:
            self.script_path = m.get('scriptPath')
        if m.get('scriptType') is not None:
            self.script_type = m.get('scriptType')
        return self


class ExtraParamSpec(TeaModel):
    def __init__(
        self,
        default_value: str = None,
        key: str = None,
        readonly: bool = None,
    ):
        # defaultValue
        self.default_value = default_value
        # key
        self.key = key
        # readonly
        self.readonly = readonly

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['defaultValue'] = self.default_value
        if self.key is not None:
            result['key'] = self.key
        if self.readonly is not None:
            result['readonly'] = self.readonly
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultValue') is not None:
            self.default_value = m.get('defaultValue')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('readonly') is not None:
            self.readonly = m.get('readonly')
        return self


class Constraint(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        type: str = None,
        values: List[str] = None,
    ):
        # max
        self.max = max
        # min
        self.min = min
        # type
        self.type = type
        # values
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.type is not None:
            result['type'] = self.type
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class NodeCountConstraint(TeaModel):
    def __init__(
        self,
        biz_node_group_type: str = None,
        ha: Constraint = None,
        normal: Constraint = None,
    ):
        # bizNodeGroupType
        self.biz_node_group_type = biz_node_group_type
        self.ha = ha
        # normal
        self.normal = normal

    def validate(self):
        if self.ha:
            self.ha.validate()
        if self.normal:
            self.normal.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_node_group_type is not None:
            result['bizNodeGroupType'] = self.biz_node_group_type
        if self.ha is not None:
            result['ha'] = self.ha.to_map()
        if self.normal is not None:
            result['normal'] = self.normal.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizNodeGroupType') is not None:
            self.biz_node_group_type = m.get('bizNodeGroupType')
        if m.get('ha') is not None:
            temp_model = Constraint()
            self.ha = temp_model.from_map(m['ha'])
        if m.get('normal') is not None:
            temp_model = Constraint()
            self.normal = temp_model.from_map(m['normal'])
        return self


class NodeGroupSpec(TeaModel):
    def __init__(
        self,
        biz_node_group_type: str = None,
        component_label_list: List[str] = None,
        master: bool = None,
        node_count_constraints: NodeCountConstraint = None,
        node_count_max: int = None,
        node_count_min: int = None,
        node_data_disk_categories: List[str] = None,
        node_data_disk_count_default: int = None,
        node_data_disk_count_max: int = None,
        node_data_disk_count_min: int = None,
        node_data_disk_size_default: int = None,
        node_data_disk_size_max: int = None,
        node_data_disk_size_min: int = None,
        node_group_type: str = None,
        node_system_disk_categories: List[str] = None,
        node_system_disk_size_default: int = None,
        node_system_disk_size_max: int = None,
        node_system_disk_size_min: int = None,
        optional: bool = None,
        real_node_group_type: str = None,
    ):
        # bizNodeGroupType
        self.biz_node_group_type = biz_node_group_type
        # componentLabelList
        self.component_label_list = component_label_list
        # master
        self.master = master
        self.node_count_constraints = node_count_constraints
        # nodeCountMax
        self.node_count_max = node_count_max
        # nodeCountMin
        self.node_count_min = node_count_min
        # nodeDataDiskCategories
        self.node_data_disk_categories = node_data_disk_categories
        # nodeDataDiskCountDefault
        self.node_data_disk_count_default = node_data_disk_count_default
        # nodeDataDiskCountMax
        self.node_data_disk_count_max = node_data_disk_count_max
        # nodeDataDiskCountMin
        self.node_data_disk_count_min = node_data_disk_count_min
        # nodeDataDiskSizeDefault
        self.node_data_disk_size_default = node_data_disk_size_default
        # nodeDataDiskSizeMax
        self.node_data_disk_size_max = node_data_disk_size_max
        # nodeDataDiskSizeMin
        self.node_data_disk_size_min = node_data_disk_size_min
        # nodeGroupType
        self.node_group_type = node_group_type
        # nodeSystemDiskCategories
        self.node_system_disk_categories = node_system_disk_categories
        # nodeSystemDiskSizeDefault
        self.node_system_disk_size_default = node_system_disk_size_default
        # nodeSystemDiskSizeMax
        self.node_system_disk_size_max = node_system_disk_size_max
        # nodeSystemDiskSizeMin
        self.node_system_disk_size_min = node_system_disk_size_min
        # optional
        self.optional = optional
        # realNodeGroupType
        self.real_node_group_type = real_node_group_type

    def validate(self):
        if self.node_count_constraints:
            self.node_count_constraints.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_node_group_type is not None:
            result['bizNodeGroupType'] = self.biz_node_group_type
        if self.component_label_list is not None:
            result['componentLabelList'] = self.component_label_list
        if self.master is not None:
            result['master'] = self.master
        if self.node_count_constraints is not None:
            result['nodeCountConstraints'] = self.node_count_constraints.to_map()
        if self.node_count_max is not None:
            result['nodeCountMax'] = self.node_count_max
        if self.node_count_min is not None:
            result['nodeCountMin'] = self.node_count_min
        if self.node_data_disk_categories is not None:
            result['nodeDataDiskCategories'] = self.node_data_disk_categories
        if self.node_data_disk_count_default is not None:
            result['nodeDataDiskCountDefault'] = self.node_data_disk_count_default
        if self.node_data_disk_count_max is not None:
            result['nodeDataDiskCountMax'] = self.node_data_disk_count_max
        if self.node_data_disk_count_min is not None:
            result['nodeDataDiskCountMin'] = self.node_data_disk_count_min
        if self.node_data_disk_size_default is not None:
            result['nodeDataDiskSizeDefault'] = self.node_data_disk_size_default
        if self.node_data_disk_size_max is not None:
            result['nodeDataDiskSizeMax'] = self.node_data_disk_size_max
        if self.node_data_disk_size_min is not None:
            result['nodeDataDiskSizeMin'] = self.node_data_disk_size_min
        if self.node_group_type is not None:
            result['nodeGroupType'] = self.node_group_type
        if self.node_system_disk_categories is not None:
            result['nodeSystemDiskCategories'] = self.node_system_disk_categories
        if self.node_system_disk_size_default is not None:
            result['nodeSystemDiskSizeDefault'] = self.node_system_disk_size_default
        if self.node_system_disk_size_max is not None:
            result['nodeSystemDiskSizeMax'] = self.node_system_disk_size_max
        if self.node_system_disk_size_min is not None:
            result['nodeSystemDiskSizeMin'] = self.node_system_disk_size_min
        if self.optional is not None:
            result['optional'] = self.optional
        if self.real_node_group_type is not None:
            result['realNodeGroupType'] = self.real_node_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizNodeGroupType') is not None:
            self.biz_node_group_type = m.get('bizNodeGroupType')
        if m.get('componentLabelList') is not None:
            self.component_label_list = m.get('componentLabelList')
        if m.get('master') is not None:
            self.master = m.get('master')
        if m.get('nodeCountConstraints') is not None:
            temp_model = NodeCountConstraint()
            self.node_count_constraints = temp_model.from_map(m['nodeCountConstraints'])
        if m.get('nodeCountMax') is not None:
            self.node_count_max = m.get('nodeCountMax')
        if m.get('nodeCountMin') is not None:
            self.node_count_min = m.get('nodeCountMin')
        if m.get('nodeDataDiskCategories') is not None:
            self.node_data_disk_categories = m.get('nodeDataDiskCategories')
        if m.get('nodeDataDiskCountDefault') is not None:
            self.node_data_disk_count_default = m.get('nodeDataDiskCountDefault')
        if m.get('nodeDataDiskCountMax') is not None:
            self.node_data_disk_count_max = m.get('nodeDataDiskCountMax')
        if m.get('nodeDataDiskCountMin') is not None:
            self.node_data_disk_count_min = m.get('nodeDataDiskCountMin')
        if m.get('nodeDataDiskSizeDefault') is not None:
            self.node_data_disk_size_default = m.get('nodeDataDiskSizeDefault')
        if m.get('nodeDataDiskSizeMax') is not None:
            self.node_data_disk_size_max = m.get('nodeDataDiskSizeMax')
        if m.get('nodeDataDiskSizeMin') is not None:
            self.node_data_disk_size_min = m.get('nodeDataDiskSizeMin')
        if m.get('nodeGroupType') is not None:
            self.node_group_type = m.get('nodeGroupType')
        if m.get('nodeSystemDiskCategories') is not None:
            self.node_system_disk_categories = m.get('nodeSystemDiskCategories')
        if m.get('nodeSystemDiskSizeDefault') is not None:
            self.node_system_disk_size_default = m.get('nodeSystemDiskSizeDefault')
        if m.get('nodeSystemDiskSizeMax') is not None:
            self.node_system_disk_size_max = m.get('nodeSystemDiskSizeMax')
        if m.get('nodeSystemDiskSizeMin') is not None:
            self.node_system_disk_size_min = m.get('nodeSystemDiskSizeMin')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        if m.get('realNodeGroupType') is not None:
            self.real_node_group_type = m.get('realNodeGroupType')
        return self


class ClusterTypeSpec(TeaModel):
    def __init__(
        self,
        cluster_ram_role: str = None,
        cluster_type: str = None,
        extra_params: List[ExtraParamSpec] = None,
        ha_type: str = None,
        meta_store_types: List[str] = None,
        node_count_constraints: List[NodeCountConstraint] = None,
        node_group_specs: List[NodeGroupSpec] = None,
        realign: bool = None,
        scenario: str = None,
    ):
        # clusterRamRole
        self.cluster_ram_role = cluster_ram_role
        # clusterType
        self.cluster_type = cluster_type
        # extraParams
        self.extra_params = extra_params
        # haType
        self.ha_type = ha_type
        self.meta_store_types = meta_store_types
        # nodeCountConstraints
        self.node_count_constraints = node_count_constraints
        # nodeGroupSpecs
        self.node_group_specs = node_group_specs
        # realign
        self.realign = realign
        # scenario
        self.scenario = scenario

    def validate(self):
        if self.extra_params:
            for k in self.extra_params:
                if k:
                    k.validate()
        if self.node_count_constraints:
            for k in self.node_count_constraints:
                if k:
                    k.validate()
        if self.node_group_specs:
            for k in self.node_group_specs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_ram_role is not None:
            result['clusterRamRole'] = self.cluster_ram_role
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        result['extraParams'] = []
        if self.extra_params is not None:
            for k in self.extra_params:
                result['extraParams'].append(k.to_map() if k else None)
        if self.ha_type is not None:
            result['haType'] = self.ha_type
        if self.meta_store_types is not None:
            result['metaStoreTypes'] = self.meta_store_types
        result['nodeCountConstraints'] = []
        if self.node_count_constraints is not None:
            for k in self.node_count_constraints:
                result['nodeCountConstraints'].append(k.to_map() if k else None)
        result['nodeGroupSpecs'] = []
        if self.node_group_specs is not None:
            for k in self.node_group_specs:
                result['nodeGroupSpecs'].append(k.to_map() if k else None)
        if self.realign is not None:
            result['realign'] = self.realign
        if self.scenario is not None:
            result['scenario'] = self.scenario
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterRamRole') is not None:
            self.cluster_ram_role = m.get('clusterRamRole')
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        self.extra_params = []
        if m.get('extraParams') is not None:
            for k in m.get('extraParams'):
                temp_model = ExtraParamSpec()
                self.extra_params.append(temp_model.from_map(k))
        if m.get('haType') is not None:
            self.ha_type = m.get('haType')
        if m.get('metaStoreTypes') is not None:
            self.meta_store_types = m.get('metaStoreTypes')
        self.node_count_constraints = []
        if m.get('nodeCountConstraints') is not None:
            for k in m.get('nodeCountConstraints'):
                temp_model = NodeCountConstraint()
                self.node_count_constraints.append(temp_model.from_map(k))
        self.node_group_specs = []
        if m.get('nodeGroupSpecs') is not None:
            for k in m.get('nodeGroupSpecs'):
                temp_model = NodeGroupSpec()
                self.node_group_specs.append(temp_model.from_map(k))
        if m.get('realign') is not None:
            self.realign = m.get('realign')
        if m.get('scenario') is not None:
            self.scenario = m.get('scenario')
        return self


class MainVersionApplicationParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
        display: str = None,
        main_version: str = None,
        mandatory: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # applicationVersion
        self.application_version = application_version
        # display
        self.display = display
        # mainVersion
        self.main_version = main_version
        # mandatory
        self.mandatory = mandatory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        if self.display is not None:
            result['display'] = self.display
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.mandatory is not None:
            result['mandatory'] = self.mandatory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        if m.get('display') is not None:
            self.display = m.get('display')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('mandatory') is not None:
            self.mandatory = m.get('mandatory')
        return self


class ClusterType(TeaModel):
    def __init__(
        self,
        cluster_type_spec: ClusterTypeSpec = None,
        application_dtolist: List[MainVersionApplicationParam] = None,
        cluster_type: str = None,
        display: bool = None,
        exclude_user_list: str = None,
        white_user_ids: str = None,
    ):
        self.cluster_type_spec = cluster_type_spec
        # taihaoMainVersionApplicationParam
        self.application_dtolist = application_dtolist
        # clusterType
        self.cluster_type = cluster_type
        # display
        self.display = display
        # excludeUserList
        self.exclude_user_list = exclude_user_list
        # whiteUserIds
        self.white_user_ids = white_user_ids

    def validate(self):
        if self.cluster_type_spec:
            self.cluster_type_spec.validate()
        if self.application_dtolist:
            for k in self.application_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type_spec is not None:
            result['ClusterTypeSpec'] = self.cluster_type_spec.to_map()
        result['applicationDTOList'] = []
        if self.application_dtolist is not None:
            for k in self.application_dtolist:
                result['applicationDTOList'].append(k.to_map() if k else None)
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.display is not None:
            result['display'] = self.display
        if self.exclude_user_list is not None:
            result['excludeUserList'] = self.exclude_user_list
        if self.white_user_ids is not None:
            result['whiteUserIds'] = self.white_user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterTypeSpec') is not None:
            temp_model = ClusterTypeSpec()
            self.cluster_type_spec = temp_model.from_map(m['ClusterTypeSpec'])
        self.application_dtolist = []
        if m.get('applicationDTOList') is not None:
            for k in m.get('applicationDTOList'):
                temp_model = MainVersionApplicationParam()
                self.application_dtolist.append(temp_model.from_map(k))
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('display') is not None:
            self.display = m.get('display')
        if m.get('excludeUserList') is not None:
            self.exclude_user_list = m.get('excludeUserList')
        if m.get('whiteUserIds') is not None:
            self.white_user_ids = m.get('whiteUserIds')
        return self


class NodeConstraint(TeaModel):
    def __init__(
        self,
        deploy_mode: str = None,
        max: int = None,
        min: int = None,
        step: int = None,
        type: str = None,
        values: List[int] = None,
    ):
        # deployMode
        self.deploy_mode = deploy_mode
        # max
        self.max = max
        # min
        self.min = min
        # step
        self.step = step
        # type
        self.type = type
        # values
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.max is not None:
            result['max'] = self.max
        if self.min is not None:
            result['min'] = self.min
        if self.step is not None:
            result['step'] = self.step
        if self.type is not None:
            result['type'] = self.type
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('max') is not None:
            self.max = m.get('max')
        if m.get('min') is not None:
            self.min = m.get('min')
        if m.get('step') is not None:
            self.step = m.get('step')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class ComponentDTO(TeaModel):
    def __init__(
        self,
        affinity_components: List[str] = None,
        anti_affinity_components: List[str] = None,
        component_type: str = None,
        description: str = None,
        name: str = None,
        node_constraints: List[NodeConstraint] = None,
    ):
        # affinityComponents
        self.affinity_components = affinity_components
        # antiAffinityComponents
        self.anti_affinity_components = anti_affinity_components
        # componentType
        self.component_type = component_type
        # description
        self.description = description
        # name
        self.name = name
        # nodeConstraints
        self.node_constraints = node_constraints

    def validate(self):
        if self.node_constraints:
            for k in self.node_constraints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affinity_components is not None:
            result['affinityComponents'] = self.affinity_components
        if self.anti_affinity_components is not None:
            result['antiAffinityComponents'] = self.anti_affinity_components
        if self.component_type is not None:
            result['componentType'] = self.component_type
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        result['nodeConstraints'] = []
        if self.node_constraints is not None:
            for k in self.node_constraints:
                result['nodeConstraints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('affinityComponents') is not None:
            self.affinity_components = m.get('affinityComponents')
        if m.get('antiAffinityComponents') is not None:
            self.anti_affinity_components = m.get('antiAffinityComponents')
        if m.get('componentType') is not None:
            self.component_type = m.get('componentType')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        self.node_constraints = []
        if m.get('nodeConstraints') is not None:
            for k in m.get('nodeConstraints'):
                temp_model = NodeConstraint()
                self.node_constraints.append(temp_model.from_map(k))
        return self


class MainVersionApplicationDTO(TeaModel):
    def __init__(
        self,
        application_meta_dto: ApplicationMetaDTO = None,
        application_name: str = None,
        application_type: str = None,
        application_version: str = None,
        component_dtos: List[ComponentDTO] = None,
        deploy_mode_dependencies: List[DeployModeDependency] = None,
        iaas_type: str = None,
        mandatory: bool = None,
    ):
        # applicationMetaDTO
        self.application_meta_dto = application_meta_dto
        # applicationName
        self.application_name = application_name
        # applicationType
        self.application_type = application_type
        # applicationVersion
        self.application_version = application_version
        # componentDTOs
        self.component_dtos = component_dtos
        # deployModeDependencies
        self.deploy_mode_dependencies = deploy_mode_dependencies
        # iaasType
        self.iaas_type = iaas_type
        # mandatory
        self.mandatory = mandatory

    def validate(self):
        if self.application_meta_dto:
            self.application_meta_dto.validate()
        if self.component_dtos:
            for k in self.component_dtos:
                if k:
                    k.validate()
        if self.deploy_mode_dependencies:
            for k in self.deploy_mode_dependencies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_meta_dto is not None:
            result['applicationMetaDTO'] = self.application_meta_dto.to_map()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_type is not None:
            result['applicationType'] = self.application_type
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        result['componentDTOs'] = []
        if self.component_dtos is not None:
            for k in self.component_dtos:
                result['componentDTOs'].append(k.to_map() if k else None)
        result['deployModeDependencies'] = []
        if self.deploy_mode_dependencies is not None:
            for k in self.deploy_mode_dependencies:
                result['deployModeDependencies'].append(k.to_map() if k else None)
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.mandatory is not None:
            result['mandatory'] = self.mandatory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationMetaDTO') is not None:
            temp_model = ApplicationMetaDTO()
            self.application_meta_dto = temp_model.from_map(m['applicationMetaDTO'])
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationType') is not None:
            self.application_type = m.get('applicationType')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        self.component_dtos = []
        if m.get('componentDTOs') is not None:
            for k in m.get('componentDTOs'):
                temp_model = ComponentDTO()
                self.component_dtos.append(temp_model.from_map(k))
        self.deploy_mode_dependencies = []
        if m.get('deployModeDependencies') is not None:
            for k in m.get('deployModeDependencies'):
                temp_model = DeployModeDependency()
                self.deploy_mode_dependencies.append(temp_model.from_map(k))
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('mandatory') is not None:
            self.mandatory = m.get('mandatory')
        return self


class ClusterTypeDTO(TeaModel):
    def __init__(
        self,
        application_dtolist: List[MainVersionApplicationDTO] = None,
        cluster_type: str = None,
    ):
        # applicationDTOList
        self.application_dtolist = application_dtolist
        # clusterType
        self.cluster_type = cluster_type

    def validate(self):
        if self.application_dtolist:
            for k in self.application_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationDTOList'] = []
        if self.application_dtolist is not None:
            for k in self.application_dtolist:
                result['applicationDTOList'].append(k.to_map() if k else None)
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_dtolist = []
        if m.get('applicationDTOList') is not None:
            for k in m.get('applicationDTOList'):
                temp_model = MainVersionApplicationDTO()
                self.application_dtolist.append(temp_model.from_map(k))
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        return self


class ClusterTypeMeta(TeaModel):
    def __init__(
        self,
        application_names: List[str] = None,
        cluster_type: str = None,
        exclude_user_ids: str = None,
        iaas_type: str = None,
        visible_type: str = None,
        white_user_ids: str = None,
    ):
        # applicationNames
        self.application_names = application_names
        # clusterType
        self.cluster_type = cluster_type
        # excludeUserIds
        self.exclude_user_ids = exclude_user_ids
        # iaasType
        self.iaas_type = iaas_type
        # visibleType
        self.visible_type = visible_type
        # whiteUserIds
        self.white_user_ids = white_user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_names is not None:
            result['applicationNames'] = self.application_names
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.exclude_user_ids is not None:
            result['excludeUserIds'] = self.exclude_user_ids
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.visible_type is not None:
            result['visibleType'] = self.visible_type
        if self.white_user_ids is not None:
            result['whiteUserIds'] = self.white_user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationNames') is not None:
            self.application_names = m.get('applicationNames')
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('excludeUserIds') is not None:
            self.exclude_user_ids = m.get('excludeUserIds')
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('visibleType') is not None:
            self.visible_type = m.get('visibleType')
        if m.get('whiteUserIds') is not None:
            self.white_user_ids = m.get('whiteUserIds')
        return self


class ClusterUserDTO(TeaModel):
    def __init__(
        self,
        password: str = None,
        description: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: str = None,
    ):
        # password
        self.password = password
        # description
        self.description = description
        # userId
        self.user_id = user_id
        # userName
        self.user_name = user_name
        # userType
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.description is not None:
            result['description'] = self.description
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_name is not None:
            result['userName'] = self.user_name
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class ComponentMetaDTO(TeaModel):
    def __init__(
        self,
        affinity_components: List[str] = None,
        anti_affinity_components: List[str] = None,
        component_name: str = None,
        description: str = None,
        node_constraints: List[NodeConstraint] = None,
    ):
        # affinityComponents
        self.affinity_components = affinity_components
        # antiAffinityComponents
        self.anti_affinity_components = anti_affinity_components
        # componentName
        self.component_name = component_name
        # description
        self.description = description
        # nodeConstraint
        self.node_constraints = node_constraints

    def validate(self):
        if self.node_constraints:
            for k in self.node_constraints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affinity_components is not None:
            result['affinityComponents'] = self.affinity_components
        if self.anti_affinity_components is not None:
            result['antiAffinityComponents'] = self.anti_affinity_components
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.description is not None:
            result['description'] = self.description
        result['nodeConstraints'] = []
        if self.node_constraints is not None:
            for k in self.node_constraints:
                result['nodeConstraints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('affinityComponents') is not None:
            self.affinity_components = m.get('affinityComponents')
        if m.get('antiAffinityComponents') is not None:
            self.anti_affinity_components = m.get('antiAffinityComponents')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('description') is not None:
            self.description = m.get('description')
        self.node_constraints = []
        if m.get('nodeConstraints') is not None:
            for k in m.get('nodeConstraints'):
                temp_model = NodeConstraint()
                self.node_constraints.append(temp_model.from_map(k))
        return self


class ConfigItemKey(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
    ):
        # key
        self.key = key
        # name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class CostOptimizedConfig(TeaModel):
    def __init__(
        self,
        on_demand_base_capacity: int = None,
        on_demand_percentage_above_base_capacity: int = None,
        spot_instance_pools: int = None,
    ):
        # onDemandBaseCapacity
        self.on_demand_base_capacity = on_demand_base_capacity
        # onDemandPercentageAboveBaseCapacity
        self.on_demand_percentage_above_base_capacity = on_demand_percentage_above_base_capacity
        # spotInstancePools
        self.spot_instance_pools = spot_instance_pools

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.on_demand_base_capacity is not None:
            result['onDemandBaseCapacity'] = self.on_demand_base_capacity
        if self.on_demand_percentage_above_base_capacity is not None:
            result['onDemandPercentageAboveBaseCapacity'] = self.on_demand_percentage_above_base_capacity
        if self.spot_instance_pools is not None:
            result['spotInstancePools'] = self.spot_instance_pools
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('onDemandBaseCapacity') is not None:
            self.on_demand_base_capacity = m.get('onDemandBaseCapacity')
        if m.get('onDemandPercentageAboveBaseCapacity') is not None:
            self.on_demand_percentage_above_base_capacity = m.get('onDemandPercentageAboveBaseCapacity')
        if m.get('spotInstancePools') is not None:
            self.spot_instance_pools = m.get('spotInstancePools')
        return self


class ScalingRule(TeaModel):
    def __init__(
        self,
        adjustment_value: int = None,
        by_load_scaling_rule: ByLoadScalingRule = None,
        by_time_scaling_rule: ByTimeScalingRule = None,
        cool_down_interval: int = None,
        scaling_activity_type: str = None,
        scaling_rule_name: str = None,
        scaling_rule_type: str = None,
    ):
        # 伸缩数量
        self.adjustment_value = adjustment_value
        # 按负载伸缩参数描述
        self.by_load_scaling_rule = by_load_scaling_rule
        # 按时间伸缩参数描述
        self.by_time_scaling_rule = by_time_scaling_rule
        # 冷却时间
        self.cool_down_interval = cool_down_interval
        # 伸缩活动类型
        self.scaling_activity_type = scaling_activity_type
        # 规则名称
        self.scaling_rule_name = scaling_rule_name
        # 伸缩规则类型
        self.scaling_rule_type = scaling_rule_type

    def validate(self):
        if self.by_load_scaling_rule:
            self.by_load_scaling_rule.validate()
        if self.by_time_scaling_rule:
            self.by_time_scaling_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjustment_value is not None:
            result['adjustmentValue'] = self.adjustment_value
        if self.by_load_scaling_rule is not None:
            result['byLoadScalingRule'] = self.by_load_scaling_rule.to_map()
        if self.by_time_scaling_rule is not None:
            result['byTimeScalingRule'] = self.by_time_scaling_rule.to_map()
        if self.cool_down_interval is not None:
            result['coolDownInterval'] = self.cool_down_interval
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_rule_name is not None:
            result['scalingRuleName'] = self.scaling_rule_name
        if self.scaling_rule_type is not None:
            result['scalingRuleType'] = self.scaling_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjustmentValue') is not None:
            self.adjustment_value = m.get('adjustmentValue')
        if m.get('byLoadScalingRule') is not None:
            temp_model = ByLoadScalingRule()
            self.by_load_scaling_rule = temp_model.from_map(m['byLoadScalingRule'])
        if m.get('byTimeScalingRule') is not None:
            temp_model = ByTimeScalingRule()
            self.by_time_scaling_rule = temp_model.from_map(m['byTimeScalingRule'])
        if m.get('coolDownInterval') is not None:
            self.cool_down_interval = m.get('coolDownInterval')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingRuleName') is not None:
            self.scaling_rule_name = m.get('scalingRuleName')
        if m.get('scalingRuleType') is not None:
            self.scaling_rule_type = m.get('scalingRuleType')
        return self


class CreateAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_rules: List[ScalingRule] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # ACK集群 此字段为空
        self.node_group_id = node_group_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # 弹性伸缩规则列表
        self.scaling_rules = scaling_rules

    def validate(self):
        if self.scaling_rules:
            for k in self.scaling_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        result['scalingRules'] = []
        if self.scaling_rules is not None:
            for k in self.scaling_rules:
                result['scalingRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        self.scaling_rules = []
        if m.get('scalingRules') is not None:
            for k in m.get('scalingRules'):
                temp_model = ScalingRule()
                self.scaling_rules.append(temp_model.from_map(k))
        return self


class ScalingRuleSpec(TeaModel):
    def __init__(
        self,
        adjustment_value: int = None,
        by_load_scaling_rule_spec: ByLoadScalingRuleSpec = None,
        by_time_scaling_rule_spec: ByTimeScalingRuleSpec = None,
        cool_down_interval: int = None,
        scaling_activity_type: str = None,
        scaling_rule_name: str = None,
        scaling_rule_type: str = None,
    ):
        # 伸缩数量
        self.adjustment_value = adjustment_value
        # 按负载伸缩参数描述
        self.by_load_scaling_rule_spec = by_load_scaling_rule_spec
        # 按时间伸缩参数描述
        self.by_time_scaling_rule_spec = by_time_scaling_rule_spec
        # 冷却时间
        self.cool_down_interval = cool_down_interval
        # 伸缩活动类型
        self.scaling_activity_type = scaling_activity_type
        # 规则名称
        self.scaling_rule_name = scaling_rule_name
        # 伸缩规则类型
        self.scaling_rule_type = scaling_rule_type

    def validate(self):
        if self.by_load_scaling_rule_spec:
            self.by_load_scaling_rule_spec.validate()
        if self.by_time_scaling_rule_spec:
            self.by_time_scaling_rule_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjustment_value is not None:
            result['adjustmentValue'] = self.adjustment_value
        if self.by_load_scaling_rule_spec is not None:
            result['byLoadScalingRuleSpec'] = self.by_load_scaling_rule_spec.to_map()
        if self.by_time_scaling_rule_spec is not None:
            result['byTimeScalingRuleSpec'] = self.by_time_scaling_rule_spec.to_map()
        if self.cool_down_interval is not None:
            result['coolDownInterval'] = self.cool_down_interval
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_rule_name is not None:
            result['scalingRuleName'] = self.scaling_rule_name
        if self.scaling_rule_type is not None:
            result['scalingRuleType'] = self.scaling_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjustmentValue') is not None:
            self.adjustment_value = m.get('adjustmentValue')
        if m.get('byLoadScalingRuleSpec') is not None:
            temp_model = ByLoadScalingRuleSpec()
            self.by_load_scaling_rule_spec = temp_model.from_map(m['byLoadScalingRuleSpec'])
        if m.get('byTimeScalingRuleSpec') is not None:
            temp_model = ByTimeScalingRuleSpec()
            self.by_time_scaling_rule_spec = temp_model.from_map(m['byTimeScalingRuleSpec'])
        if m.get('coolDownInterval') is not None:
            self.cool_down_interval = m.get('coolDownInterval')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingRuleName') is not None:
            self.scaling_rule_name = m.get('scalingRuleName')
        if m.get('scalingRuleType') is not None:
            self.scaling_rule_type = m.get('scalingRuleType')
        return self


class CreateAutoScalingRuleParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
        scaling_rule_spec: ScalingRuleSpec = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id
        # scalingRuleSpec
        self.scaling_rule_spec = scaling_rule_spec

    def validate(self):
        if self.scaling_rule_spec:
            self.scaling_rule_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_rule_spec is not None:
            result['scalingRuleSpec'] = self.scaling_rule_spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingRuleSpec') is not None:
            temp_model = ScalingRuleSpec()
            self.scaling_rule_spec = temp_model.from_map(m['scalingRuleSpec'])
        return self


class NodeSelectorLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class NodeSelectorTaints(TeaModel):
    def __init__(
        self,
        effect: str = None,
        key: str = None,
        value: str = None,
    ):
        # effect
        self.effect = effect
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['effect'] = self.effect
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effect') is not None:
            self.effect = m.get('effect')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class NodeSelector(TeaModel):
    def __init__(
        self,
        labels: List[NodeSelectorLabels] = None,
        taints: List[NodeSelectorTaints] = None,
    ):
        # labels
        self.labels = labels
        # taints
        self.taints = taints

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()
        if self.taints:
            for k in self.taints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['labels'].append(k.to_map() if k else None)
        result['taints'] = []
        if self.taints is not None:
            for k in self.taints:
                result['taints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('labels') is not None:
            for k in m.get('labels'):
                temp_model = NodeSelectorLabels()
                self.labels.append(temp_model.from_map(k))
        self.taints = []
        if m.get('taints') is not None:
            for k in m.get('taints'):
                temp_model = NodeSelectorTaints()
                self.taints.append(temp_model.from_map(k))
        return self


class CreateBindingAckClusterParamAckNodePools(TeaModel):
    def __init__(
        self,
        node_pool_id: str = None,
        node_selector: NodeSelector = None,
    ):
        # nodePoolId
        self.node_pool_id = node_pool_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_pool_id is not None:
            result['nodePoolId'] = self.node_pool_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodePoolId') is not None:
            self.node_pool_id = m.get('nodePoolId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class CreateBindingAckClusterParamAckNodes(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        node_selector: NodeSelector = None,
    ):
        # nodeId
        self.node_id = node_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class CreateBindingAckClusterParamApplicationList(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # applicationVersion
        self.application_version = application_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        return self


class Label(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class Taint(TeaModel):
    def __init__(
        self,
        effect: str = None,
        key: str = None,
        value: str = None,
    ):
        # effect
        self.effect = effect
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['effect'] = self.effect
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effect') is not None:
            self.effect = m.get('effect')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class KubeNodeLabelDTO(TeaModel):
    def __init__(
        self,
        label: Label = None,
        taint: Taint = None,
    ):
        self.label = label
        self.taint = taint

    def validate(self):
        if self.label:
            self.label.validate()
        if self.taint:
            self.taint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['label'] = self.label.to_map()
        if self.taint is not None:
            result['taint'] = self.taint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('label') is not None:
            temp_model = Label()
            self.label = temp_model.from_map(m['label'])
        if m.get('taint') is not None:
            temp_model = Taint()
            self.taint = temp_model.from_map(m['taint'])
        return self


class CreateBindingAckClusterParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        ack_node_pools: List[CreateBindingAckClusterParamAckNodePools] = None,
        ack_nodes: List[CreateBindingAckClusterParamAckNodes] = None,
        application_list: List[CreateBindingAckClusterParamApplicationList] = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        namespace: str = None,
        node_label: KubeNodeLabelDTO = None,
        oauth_callback_url: str = None,
        operate_user_id: str = None,
        oss_path: str = None,
        product_role_name: str = None,
        product_selectors: NodeSelector = None,
        resource_group_id: str = None,
        resource_owner_uid: str = None,
        token: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # ackNodePools
        self.ack_node_pools = ack_node_pools
        # ackNodes
        self.ack_nodes = ack_nodes
        # applicationList
        self.application_list = application_list
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # clusterType
        self.cluster_type = cluster_type
        # namespace
        self.namespace = namespace
        self.node_label = node_label
        # oauthCallbackUrl
        self.oauth_callback_url = oauth_callback_url
        # operateUserId
        self.operate_user_id = operate_user_id
        # ossPath
        self.oss_path = oss_path
        # productRoleName
        self.product_role_name = product_role_name
        # productSelectors
        self.product_selectors = product_selectors
        # resourceGroupId
        self.resource_group_id = resource_group_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # token
        self.token = token

    def validate(self):
        if self.ack_node_pools:
            for k in self.ack_node_pools:
                if k:
                    k.validate()
        if self.ack_nodes:
            for k in self.ack_nodes:
                if k:
                    k.validate()
        if self.application_list:
            for k in self.application_list:
                if k:
                    k.validate()
        if self.node_label:
            self.node_label.validate()
        if self.product_selectors:
            self.product_selectors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        result['ackNodePools'] = []
        if self.ack_node_pools is not None:
            for k in self.ack_node_pools:
                result['ackNodePools'].append(k.to_map() if k else None)
        result['ackNodes'] = []
        if self.ack_nodes is not None:
            for k in self.ack_nodes:
                result['ackNodes'].append(k.to_map() if k else None)
        result['applicationList'] = []
        if self.application_list is not None:
            for k in self.application_list:
                result['applicationList'].append(k.to_map() if k else None)
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label.to_map()
        if self.oauth_callback_url is not None:
            result['oauthCallbackUrl'] = self.oauth_callback_url
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.oss_path is not None:
            result['ossPath'] = self.oss_path
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.product_selectors is not None:
            result['productSelectors'] = self.product_selectors.to_map()
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        self.ack_node_pools = []
        if m.get('ackNodePools') is not None:
            for k in m.get('ackNodePools'):
                temp_model = CreateBindingAckClusterParamAckNodePools()
                self.ack_node_pools.append(temp_model.from_map(k))
        self.ack_nodes = []
        if m.get('ackNodes') is not None:
            for k in m.get('ackNodes'):
                temp_model = CreateBindingAckClusterParamAckNodes()
                self.ack_nodes.append(temp_model.from_map(k))
        self.application_list = []
        if m.get('applicationList') is not None:
            for k in m.get('applicationList'):
                temp_model = CreateBindingAckClusterParamApplicationList()
                self.application_list.append(temp_model.from_map(k))
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('nodeLabel') is not None:
            temp_model = KubeNodeLabelDTO()
            self.node_label = temp_model.from_map(m['nodeLabel'])
        if m.get('oauthCallbackUrl') is not None:
            self.oauth_callback_url = m.get('oauthCallbackUrl')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('ossPath') is not None:
            self.oss_path = m.get('ossPath')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('productSelectors') is not None:
            temp_model = NodeSelector()
            self.product_selectors = temp_model.from_map(m['productSelectors'])
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class NodeGroupParam(TeaModel):
    def __init__(
        self,
        additional_security_group_ids: List[str] = None,
        auto_renew: bool = None,
        auto_renew_period: int = None,
        auto_renew_period_unit: str = None,
        component_tags: List[str] = None,
        cost_optimized_config: CostOptimizedConfig = None,
        data_disk_category: str = None,
        data_disk_count: int = None,
        data_disk_size: int = None,
        description: str = None,
        enable_decommission_gracefully: bool = None,
        image_id: str = None,
        instance_types: List[str] = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_out: int = None,
        key_pair_name: str = None,
        max_size: int = None,
        min_size: int = None,
        node_count: int = None,
        node_group_name: str = None,
        node_group_role: str = None,
        node_ram_role: str = None,
        node_resize_strategy: str = None,
        password: str = None,
        payment_type: str = None,
        period: int = None,
        period_unit: str = None,
        security_group_id: str = None,
        spot_instance_remedy: bool = None,
        spot_price_limits: List[float] = None,
        spot_strategy: str = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        tags: List[str] = None,
        vswitch_ids: List[str] = None,
        with_public_ip: bool = None,
        zone_id: str = None,
    ):
        # additionalSecurityGroupIds
        self.additional_security_group_ids = additional_security_group_ids
        # autoRenew
        self.auto_renew = auto_renew
        # autoRenewPeriod
        self.auto_renew_period = auto_renew_period
        # autoRenewPeriodUnit
        self.auto_renew_period_unit = auto_renew_period_unit
        # componentTags
        self.component_tags = component_tags
        self.cost_optimized_config = cost_optimized_config
        # dataDiskCategory
        self.data_disk_category = data_disk_category
        # dataDiskCount
        self.data_disk_count = data_disk_count
        # dataDiskSize
        self.data_disk_size = data_disk_size
        # description
        self.description = description
        # enableDecommissionGracefully
        self.enable_decommission_gracefully = enable_decommission_gracefully
        # imageId
        self.image_id = image_id
        # instanceTypes
        self.instance_types = instance_types
        # internetChargeType
        self.internet_charge_type = internet_charge_type
        # internetMaxBandwidthOut
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # keyPairName
        self.key_pair_name = key_pair_name
        # maxSize
        self.max_size = max_size
        # minSize
        self.min_size = min_size
        # nodeCount
        self.node_count = node_count
        # nodeGroupName
        self.node_group_name = node_group_name
        # nodeGroupRole
        self.node_group_role = node_group_role
        # nodeRamRole
        self.node_ram_role = node_ram_role
        # nodeResizeStrategy
        self.node_resize_strategy = node_resize_strategy
        # password
        self.password = password
        # paymentType
        self.payment_type = payment_type
        # period
        self.period = period
        # periodUnit
        self.period_unit = period_unit
        # securityGroupId
        self.security_group_id = security_group_id
        # spotInstanceRemedy
        self.spot_instance_remedy = spot_instance_remedy
        # spotPriceLimits
        self.spot_price_limits = spot_price_limits
        # spotStrategy
        self.spot_strategy = spot_strategy
        # systemDiskCategory
        self.system_disk_category = system_disk_category
        # systemDiskSize
        self.system_disk_size = system_disk_size
        # tags
        self.tags = tags
        # vswitchIds
        self.vswitch_ids = vswitch_ids
        # withPublicIp
        self.with_public_ip = with_public_ip
        # zoneId
        self.zone_id = zone_id

    def validate(self):
        if self.cost_optimized_config:
            self.cost_optimized_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_security_group_ids is not None:
            result['additionalSecurityGroupIds'] = self.additional_security_group_ids
        if self.auto_renew is not None:
            result['autoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['autoRenewPeriod'] = self.auto_renew_period
        if self.auto_renew_period_unit is not None:
            result['autoRenewPeriodUnit'] = self.auto_renew_period_unit
        if self.component_tags is not None:
            result['componentTags'] = self.component_tags
        if self.cost_optimized_config is not None:
            result['costOptimizedConfig'] = self.cost_optimized_config.to_map()
        if self.data_disk_category is not None:
            result['dataDiskCategory'] = self.data_disk_category
        if self.data_disk_count is not None:
            result['dataDiskCount'] = self.data_disk_count
        if self.data_disk_size is not None:
            result['dataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['description'] = self.description
        if self.enable_decommission_gracefully is not None:
            result['enableDecommissionGracefully'] = self.enable_decommission_gracefully
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.instance_types is not None:
            result['instanceTypes'] = self.instance_types
        if self.internet_charge_type is not None:
            result['internetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_out is not None:
            result['internetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.key_pair_name is not None:
            result['keyPairName'] = self.key_pair_name
        if self.max_size is not None:
            result['maxSize'] = self.max_size
        if self.min_size is not None:
            result['minSize'] = self.min_size
        if self.node_count is not None:
            result['nodeCount'] = self.node_count
        if self.node_group_name is not None:
            result['nodeGroupName'] = self.node_group_name
        if self.node_group_role is not None:
            result['nodeGroupRole'] = self.node_group_role
        if self.node_ram_role is not None:
            result['nodeRamRole'] = self.node_ram_role
        if self.node_resize_strategy is not None:
            result['nodeResizeStrategy'] = self.node_resize_strategy
        if self.password is not None:
            result['password'] = self.password
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.period is not None:
            result['period'] = self.period
        if self.period_unit is not None:
            result['periodUnit'] = self.period_unit
        if self.security_group_id is not None:
            result['securityGroupId'] = self.security_group_id
        if self.spot_instance_remedy is not None:
            result['spotInstanceRemedy'] = self.spot_instance_remedy
        if self.spot_price_limits is not None:
            result['spotPriceLimits'] = self.spot_price_limits
        if self.spot_strategy is not None:
            result['spotStrategy'] = self.spot_strategy
        if self.system_disk_category is not None:
            result['systemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['systemDiskSize'] = self.system_disk_size
        if self.tags is not None:
            result['tags'] = self.tags
        if self.vswitch_ids is not None:
            result['vswitchIds'] = self.vswitch_ids
        if self.with_public_ip is not None:
            result['withPublicIp'] = self.with_public_ip
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('additionalSecurityGroupIds') is not None:
            self.additional_security_group_ids = m.get('additionalSecurityGroupIds')
        if m.get('autoRenew') is not None:
            self.auto_renew = m.get('autoRenew')
        if m.get('autoRenewPeriod') is not None:
            self.auto_renew_period = m.get('autoRenewPeriod')
        if m.get('autoRenewPeriodUnit') is not None:
            self.auto_renew_period_unit = m.get('autoRenewPeriodUnit')
        if m.get('componentTags') is not None:
            self.component_tags = m.get('componentTags')
        if m.get('costOptimizedConfig') is not None:
            temp_model = CostOptimizedConfig()
            self.cost_optimized_config = temp_model.from_map(m['costOptimizedConfig'])
        if m.get('dataDiskCategory') is not None:
            self.data_disk_category = m.get('dataDiskCategory')
        if m.get('dataDiskCount') is not None:
            self.data_disk_count = m.get('dataDiskCount')
        if m.get('dataDiskSize') is not None:
            self.data_disk_size = m.get('dataDiskSize')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableDecommissionGracefully') is not None:
            self.enable_decommission_gracefully = m.get('enableDecommissionGracefully')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('instanceTypes') is not None:
            self.instance_types = m.get('instanceTypes')
        if m.get('internetChargeType') is not None:
            self.internet_charge_type = m.get('internetChargeType')
        if m.get('internetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('internetMaxBandwidthOut')
        if m.get('keyPairName') is not None:
            self.key_pair_name = m.get('keyPairName')
        if m.get('maxSize') is not None:
            self.max_size = m.get('maxSize')
        if m.get('minSize') is not None:
            self.min_size = m.get('minSize')
        if m.get('nodeCount') is not None:
            self.node_count = m.get('nodeCount')
        if m.get('nodeGroupName') is not None:
            self.node_group_name = m.get('nodeGroupName')
        if m.get('nodeGroupRole') is not None:
            self.node_group_role = m.get('nodeGroupRole')
        if m.get('nodeRamRole') is not None:
            self.node_ram_role = m.get('nodeRamRole')
        if m.get('nodeResizeStrategy') is not None:
            self.node_resize_strategy = m.get('nodeResizeStrategy')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('periodUnit') is not None:
            self.period_unit = m.get('periodUnit')
        if m.get('securityGroupId') is not None:
            self.security_group_id = m.get('securityGroupId')
        if m.get('spotInstanceRemedy') is not None:
            self.spot_instance_remedy = m.get('spotInstanceRemedy')
        if m.get('spotPriceLimits') is not None:
            self.spot_price_limits = m.get('spotPriceLimits')
        if m.get('spotStrategy') is not None:
            self.spot_strategy = m.get('spotStrategy')
        if m.get('systemDiskCategory') is not None:
            self.system_disk_category = m.get('systemDiskCategory')
        if m.get('systemDiskSize') is not None:
            self.system_disk_size = m.get('systemDiskSize')
        if m.get('tags') is not None:
            self.tags = m.get('tags')
        if m.get('vswitchIds') is not None:
            self.vswitch_ids = m.get('vswitchIds')
        if m.get('withPublicIp') is not None:
            self.with_public_ip = m.get('withPublicIp')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class CreateClusterNodeGroupParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_param: NodeGroupParam = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupParam
        self.node_group_param = node_group_param
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.node_group_param:
            self.node_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_param is not None:
            result['nodeGroupParam'] = self.node_group_param.to_map()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupParam') is not None:
            temp_model = NodeGroupParam()
            self.node_group_param = temp_model.from_map(m['nodeGroupParam'])
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class Tag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CreateClusterParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_script_list: List[ClusterScriptDTO] = None,
        cluster_type: str = None,
        deploy_mode: str = None,
        deposit_type: str = None,
        iaa_stype: str = None,
        operate_user_id: str = None,
        payment_type: str = None,
        resource_group_id: str = None,
        resource_owner_uid: str = None,
        security_mode: str = None,
        tag_list: List[Tag] = None,
        vpc_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # clusterScriptList
        self.cluster_script_list = cluster_script_list
        # clusterType
        self.cluster_type = cluster_type
        # deployMode
        self.deploy_mode = deploy_mode
        # depositType
        self.deposit_type = deposit_type
        # iaaSType
        self.iaa_stype = iaa_stype
        # operateUserId
        self.operate_user_id = operate_user_id
        # paymentType
        self.payment_type = payment_type
        # resourceGroupId
        self.resource_group_id = resource_group_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # securityMode
        self.security_mode = security_mode
        # tagList
        self.tag_list = tag_list
        # vpcId
        self.vpc_id = vpc_id

    def validate(self):
        if self.cluster_script_list:
            for k in self.cluster_script_list:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        result['clusterScriptList'] = []
        if self.cluster_script_list is not None:
            for k in self.cluster_script_list:
                result['clusterScriptList'].append(k.to_map() if k else None)
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.deposit_type is not None:
            result['depositType'] = self.deposit_type
        if self.iaa_stype is not None:
            result['iaaSType'] = self.iaa_stype
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        result['tagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['tagList'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        self.cluster_script_list = []
        if m.get('clusterScriptList') is not None:
            for k in m.get('clusterScriptList'):
                temp_model = ClusterScriptDTO()
                self.cluster_script_list.append(temp_model.from_map(k))
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('depositType') is not None:
            self.deposit_type = m.get('depositType')
        if m.get('iaaSType') is not None:
            self.iaa_stype = m.get('iaaSType')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        self.tag_list = []
        if m.get('tagList') is not None:
            for k in m.get('tagList'):
                temp_model = Tag()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class CreateClusterScriptParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        script_args: str = None,
        script_content: str = None,
        script_content_spec: str = None,
        script_name: str = None,
        script_path: str = None,
        script_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # clusterScriptArgs
        self.script_args = script_args
        # clusterScriptContent
        self.script_content = script_content
        # clusterScriptContentSpec
        self.script_content_spec = script_content_spec
        # clusterScriptName
        self.script_name = script_name
        # clusterScriptPath
        self.script_path = script_path
        # clusterScriptType
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.script_args is not None:
            result['scriptArgs'] = self.script_args
        if self.script_content is not None:
            result['scriptContent'] = self.script_content
        if self.script_content_spec is not None:
            result['scriptContentSpec'] = self.script_content_spec
        if self.script_name is not None:
            result['scriptName'] = self.script_name
        if self.script_path is not None:
            result['scriptPath'] = self.script_path
        if self.script_type is not None:
            result['scriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scriptArgs') is not None:
            self.script_args = m.get('scriptArgs')
        if m.get('scriptContent') is not None:
            self.script_content = m.get('scriptContent')
        if m.get('scriptContentSpec') is not None:
            self.script_content_spec = m.get('scriptContentSpec')
        if m.get('scriptName') is not None:
            self.script_name = m.get('scriptName')
        if m.get('scriptPath') is not None:
            self.script_path = m.get('scriptPath')
        if m.get('scriptType') is not None:
            self.script_type = m.get('scriptType')
        return self


class CreateClusterUserParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        description: str = None,
        operate_user_id: str = None,
        password: str = None,
        resource_owner_uid: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # description
        self.description = description
        # operateUserId
        self.operate_user_id = operate_user_id
        # password
        self.password = password
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # userId
        self.user_id = user_id
        # userId
        self.user_name = user_name
        # userType
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.password is not None:
            result['password'] = self.password
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_name is not None:
            result['userName'] = self.user_name
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class CreateFullClusterByMainVersionParam(TeaModel):
    def __init__(
        self,
        application_component_deployments: List[ApplicationComponentDeploymentParam] = None,
        application_configs: List[ApplicationConfigParam] = None,
        applications: List[ApplicationParam] = None,
        auto_recommend_config: bool = None,
        client_token: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_scripts: List[ClusterScriptDTO] = None,
        cluster_type: str = None,
        cluster_users: List[ClusterUserDTO] = None,
        deploy_mode: str = None,
        deposit_type: str = None,
        description: str = None,
        enable_deployment_set: bool = None,
        iaa_stype: str = None,
        main_version: str = None,
        node_group_params: List[NodeGroupParam] = None,
        operate_user_id: str = None,
        optional_applications: List[ApplicationParam] = None,
        payment_type: str = None,
        product_role_name: str = None,
        resource_group_id: str = None,
        resource_owner_uid: str = None,
        security_mode: str = None,
        tag_list: List[Tag] = None,
        vpc_id: str = None,
    ):
        # applicationComponentDeployments
        self.application_component_deployments = application_component_deployments
        # applicationConfigs
        self.application_configs = application_configs
        # applications
        self.applications = applications
        # autoRecommendConfig
        self.auto_recommend_config = auto_recommend_config
        # clientToken
        self.client_token = client_token
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # clusterScripts
        self.cluster_scripts = cluster_scripts
        # clusterType
        self.cluster_type = cluster_type
        # clusterUsers
        self.cluster_users = cluster_users
        # deployMode
        self.deploy_mode = deploy_mode
        # depositType
        self.deposit_type = deposit_type
        # description
        self.description = description
        # enableDeploymentSet
        self.enable_deployment_set = enable_deployment_set
        # iaaSType
        self.iaa_stype = iaa_stype
        # mainVersion
        self.main_version = main_version
        # nodeGroupParams
        self.node_group_params = node_group_params
        # operateUserId
        self.operate_user_id = operate_user_id
        # optionalApplications
        self.optional_applications = optional_applications
        # paymentType
        self.payment_type = payment_type
        # productRoleName
        self.product_role_name = product_role_name
        # resourceGroupId
        self.resource_group_id = resource_group_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # securityMode
        self.security_mode = security_mode
        # tagList
        self.tag_list = tag_list
        # vpcId
        self.vpc_id = vpc_id

    def validate(self):
        if self.application_component_deployments:
            for k in self.application_component_deployments:
                if k:
                    k.validate()
        if self.application_configs:
            for k in self.application_configs:
                if k:
                    k.validate()
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()
        if self.cluster_scripts:
            for k in self.cluster_scripts:
                if k:
                    k.validate()
        if self.cluster_users:
            for k in self.cluster_users:
                if k:
                    k.validate()
        if self.node_group_params:
            for k in self.node_group_params:
                if k:
                    k.validate()
        if self.optional_applications:
            for k in self.optional_applications:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationComponentDeployments'] = []
        if self.application_component_deployments is not None:
            for k in self.application_component_deployments:
                result['applicationComponentDeployments'].append(k.to_map() if k else None)
        result['applicationConfigs'] = []
        if self.application_configs is not None:
            for k in self.application_configs:
                result['applicationConfigs'].append(k.to_map() if k else None)
        result['applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['applications'].append(k.to_map() if k else None)
        if self.auto_recommend_config is not None:
            result['autoRecommendConfig'] = self.auto_recommend_config
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        result['clusterScripts'] = []
        if self.cluster_scripts is not None:
            for k in self.cluster_scripts:
                result['clusterScripts'].append(k.to_map() if k else None)
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        result['clusterUsers'] = []
        if self.cluster_users is not None:
            for k in self.cluster_users:
                result['clusterUsers'].append(k.to_map() if k else None)
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.deposit_type is not None:
            result['depositType'] = self.deposit_type
        if self.description is not None:
            result['description'] = self.description
        if self.enable_deployment_set is not None:
            result['enableDeploymentSet'] = self.enable_deployment_set
        if self.iaa_stype is not None:
            result['iaaSType'] = self.iaa_stype
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        result['nodeGroupParams'] = []
        if self.node_group_params is not None:
            for k in self.node_group_params:
                result['nodeGroupParams'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        result['optionalApplications'] = []
        if self.optional_applications is not None:
            for k in self.optional_applications:
                result['optionalApplications'].append(k.to_map() if k else None)
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        result['tagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['tagList'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_component_deployments = []
        if m.get('applicationComponentDeployments') is not None:
            for k in m.get('applicationComponentDeployments'):
                temp_model = ApplicationComponentDeploymentParam()
                self.application_component_deployments.append(temp_model.from_map(k))
        self.application_configs = []
        if m.get('applicationConfigs') is not None:
            for k in m.get('applicationConfigs'):
                temp_model = ApplicationConfigParam()
                self.application_configs.append(temp_model.from_map(k))
        self.applications = []
        if m.get('applications') is not None:
            for k in m.get('applications'):
                temp_model = ApplicationParam()
                self.applications.append(temp_model.from_map(k))
        if m.get('autoRecommendConfig') is not None:
            self.auto_recommend_config = m.get('autoRecommendConfig')
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        self.cluster_scripts = []
        if m.get('clusterScripts') is not None:
            for k in m.get('clusterScripts'):
                temp_model = ClusterScriptDTO()
                self.cluster_scripts.append(temp_model.from_map(k))
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        self.cluster_users = []
        if m.get('clusterUsers') is not None:
            for k in m.get('clusterUsers'):
                temp_model = ClusterUserDTO()
                self.cluster_users.append(temp_model.from_map(k))
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('depositType') is not None:
            self.deposit_type = m.get('depositType')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableDeploymentSet') is not None:
            self.enable_deployment_set = m.get('enableDeploymentSet')
        if m.get('iaaSType') is not None:
            self.iaa_stype = m.get('iaaSType')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        self.node_group_params = []
        if m.get('nodeGroupParams') is not None:
            for k in m.get('nodeGroupParams'):
                temp_model = NodeGroupParam()
                self.node_group_params.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        self.optional_applications = []
        if m.get('optionalApplications') is not None:
            for k in m.get('optionalApplications'):
                temp_model = ApplicationParam()
                self.optional_applications.append(temp_model.from_map(k))
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        self.tag_list = []
        if m.get('tagList') is not None:
            for k in m.get('tagList'):
                temp_model = Tag()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class CreateFullClusterParam(TeaModel):
    def __init__(
        self,
        application_component_deployments: List[ApplicationComponentDeploymentParam] = None,
        application_configs: List[ApplicationConfigParam] = None,
        applications: List[ApplicationParam] = None,
        auto_recommend_config: bool = None,
        client_token: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_scripts: List[ClusterScriptDTO] = None,
        cluster_type: str = None,
        deploy_mode: str = None,
        deposit_type: str = None,
        description: str = None,
        enable_deployment_set: bool = None,
        iaa_stype: str = None,
        main_version: str = None,
        node_group_params: List[NodeGroupParam] = None,
        operate_user_id: str = None,
        optional_applications: List[ApplicationParam] = None,
        payment_type: str = None,
        product_role_name: str = None,
        resource_group_id: str = None,
        resource_owner_uid: str = None,
        security_mode: str = None,
        tag_list: List[Tag] = None,
        vpc_id: str = None,
    ):
        # applicationComponentDeployments
        self.application_component_deployments = application_component_deployments
        # applicationConfigs
        self.application_configs = application_configs
        # applications
        self.applications = applications
        # autoRecommendConfig
        self.auto_recommend_config = auto_recommend_config
        # clientToken
        self.client_token = client_token
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # clusterScripts
        self.cluster_scripts = cluster_scripts
        # clusterType
        self.cluster_type = cluster_type
        # deployMode
        self.deploy_mode = deploy_mode
        # depositType
        self.deposit_type = deposit_type
        # description
        self.description = description
        # enableDeploymentSet
        self.enable_deployment_set = enable_deployment_set
        # iaaSType
        self.iaa_stype = iaa_stype
        # mainVersion
        self.main_version = main_version
        # nodeGroupParams
        self.node_group_params = node_group_params
        # operateUserId
        self.operate_user_id = operate_user_id
        # optionalApplications
        self.optional_applications = optional_applications
        # paymentType
        self.payment_type = payment_type
        # productRoleName
        self.product_role_name = product_role_name
        # resourceGroupId
        self.resource_group_id = resource_group_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # securityMode
        self.security_mode = security_mode
        # tagList
        self.tag_list = tag_list
        # vpcId
        self.vpc_id = vpc_id

    def validate(self):
        if self.application_component_deployments:
            for k in self.application_component_deployments:
                if k:
                    k.validate()
        if self.application_configs:
            for k in self.application_configs:
                if k:
                    k.validate()
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()
        if self.cluster_scripts:
            for k in self.cluster_scripts:
                if k:
                    k.validate()
        if self.node_group_params:
            for k in self.node_group_params:
                if k:
                    k.validate()
        if self.optional_applications:
            for k in self.optional_applications:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationComponentDeployments'] = []
        if self.application_component_deployments is not None:
            for k in self.application_component_deployments:
                result['applicationComponentDeployments'].append(k.to_map() if k else None)
        result['applicationConfigs'] = []
        if self.application_configs is not None:
            for k in self.application_configs:
                result['applicationConfigs'].append(k.to_map() if k else None)
        result['applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['applications'].append(k.to_map() if k else None)
        if self.auto_recommend_config is not None:
            result['autoRecommendConfig'] = self.auto_recommend_config
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        result['clusterScripts'] = []
        if self.cluster_scripts is not None:
            for k in self.cluster_scripts:
                result['clusterScripts'].append(k.to_map() if k else None)
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.deposit_type is not None:
            result['depositType'] = self.deposit_type
        if self.description is not None:
            result['description'] = self.description
        if self.enable_deployment_set is not None:
            result['enableDeploymentSet'] = self.enable_deployment_set
        if self.iaa_stype is not None:
            result['iaaSType'] = self.iaa_stype
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        result['nodeGroupParams'] = []
        if self.node_group_params is not None:
            for k in self.node_group_params:
                result['nodeGroupParams'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        result['optionalApplications'] = []
        if self.optional_applications is not None:
            for k in self.optional_applications:
                result['optionalApplications'].append(k.to_map() if k else None)
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        result['tagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['tagList'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_component_deployments = []
        if m.get('applicationComponentDeployments') is not None:
            for k in m.get('applicationComponentDeployments'):
                temp_model = ApplicationComponentDeploymentParam()
                self.application_component_deployments.append(temp_model.from_map(k))
        self.application_configs = []
        if m.get('applicationConfigs') is not None:
            for k in m.get('applicationConfigs'):
                temp_model = ApplicationConfigParam()
                self.application_configs.append(temp_model.from_map(k))
        self.applications = []
        if m.get('applications') is not None:
            for k in m.get('applications'):
                temp_model = ApplicationParam()
                self.applications.append(temp_model.from_map(k))
        if m.get('autoRecommendConfig') is not None:
            self.auto_recommend_config = m.get('autoRecommendConfig')
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        self.cluster_scripts = []
        if m.get('clusterScripts') is not None:
            for k in m.get('clusterScripts'):
                temp_model = ClusterScriptDTO()
                self.cluster_scripts.append(temp_model.from_map(k))
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('depositType') is not None:
            self.deposit_type = m.get('depositType')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableDeploymentSet') is not None:
            self.enable_deployment_set = m.get('enableDeploymentSet')
        if m.get('iaaSType') is not None:
            self.iaa_stype = m.get('iaaSType')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        self.node_group_params = []
        if m.get('nodeGroupParams') is not None:
            for k in m.get('nodeGroupParams'):
                temp_model = NodeGroupParam()
                self.node_group_params.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        self.optional_applications = []
        if m.get('optionalApplications') is not None:
            for k in m.get('optionalApplications'):
                temp_model = ApplicationParam()
                self.optional_applications.append(temp_model.from_map(k))
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        self.tag_list = []
        if m.get('tagList') is not None:
            for k in m.get('tagList'):
                temp_model = Tag()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class DiskConstraint(TeaModel):
    def __init__(
        self,
        categories: List[str] = None,
        disk_count_constraint: IntValueConstraint = None,
        disk_size_constraint: IntValueConstraint = None,
    ):
        # DiskCategoryEnum
        self.categories = categories
        # diskCountConstraint
        self.disk_count_constraint = disk_count_constraint
        # diskSizeConstraint
        self.disk_size_constraint = disk_size_constraint

    def validate(self):
        if self.disk_count_constraint:
            self.disk_count_constraint.validate()
        if self.disk_size_constraint:
            self.disk_size_constraint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.categories is not None:
            result['categories'] = self.categories
        if self.disk_count_constraint is not None:
            result['diskCountConstraint'] = self.disk_count_constraint.to_map()
        if self.disk_size_constraint is not None:
            result['diskSizeConstraint'] = self.disk_size_constraint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('categories') is not None:
            self.categories = m.get('categories')
        if m.get('diskCountConstraint') is not None:
            temp_model = IntValueConstraint()
            self.disk_count_constraint = temp_model.from_map(m['diskCountConstraint'])
        if m.get('diskSizeConstraint') is not None:
            temp_model = IntValueConstraint()
            self.disk_size_constraint = temp_model.from_map(m['diskSizeConstraint'])
        return self


class NodeGroupMeta(TeaModel):
    def __init__(
        self,
        component_tags: List[str] = None,
        data_disk_constraint: DiskConstraint = None,
        mandatory: bool = None,
        node_group_type: str = None,
        priority: int = None,
        support_actions: List[str] = None,
        system_disk_constraint: DiskConstraint = None,
    ):
        # componentTags
        self.component_tags = component_tags
        self.data_disk_constraint = data_disk_constraint
        # mandatory
        self.mandatory = mandatory
        # nodeGroupType
        self.node_group_type = node_group_type
        # priority
        self.priority = priority
        # supportActions
        self.support_actions = support_actions
        self.system_disk_constraint = system_disk_constraint

    def validate(self):
        if self.data_disk_constraint:
            self.data_disk_constraint.validate()
        if self.system_disk_constraint:
            self.system_disk_constraint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_tags is not None:
            result['componentTags'] = self.component_tags
        if self.data_disk_constraint is not None:
            result['dataDiskConstraint'] = self.data_disk_constraint.to_map()
        if self.mandatory is not None:
            result['mandatory'] = self.mandatory
        if self.node_group_type is not None:
            result['nodeGroupType'] = self.node_group_type
        if self.priority is not None:
            result['priority'] = self.priority
        if self.support_actions is not None:
            result['supportActions'] = self.support_actions
        if self.system_disk_constraint is not None:
            result['systemDiskConstraint'] = self.system_disk_constraint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentTags') is not None:
            self.component_tags = m.get('componentTags')
        if m.get('dataDiskConstraint') is not None:
            temp_model = DiskConstraint()
            self.data_disk_constraint = temp_model.from_map(m['dataDiskConstraint'])
        if m.get('mandatory') is not None:
            self.mandatory = m.get('mandatory')
        if m.get('nodeGroupType') is not None:
            self.node_group_type = m.get('nodeGroupType')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('supportActions') is not None:
            self.support_actions = m.get('supportActions')
        if m.get('systemDiskConstraint') is not None:
            temp_model = DiskConstraint()
            self.system_disk_constraint = temp_model.from_map(m['systemDiskConstraint'])
        return self


class PasswordLessLoginSpec(TeaModel):
    def __init__(
        self,
        from_node_groups: List[str] = None,
        from_node_indexes: List[str] = None,
        user_name: str = None,
    ):
        # fromNodeGroups
        self.from_node_groups = from_node_groups
        # fromNodeIndexes
        self.from_node_indexes = from_node_indexes
        # userName
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_node_groups is not None:
            result['fromNodeGroups'] = self.from_node_groups
        if self.from_node_indexes is not None:
            result['fromNodeIndexes'] = self.from_node_indexes
        if self.user_name is not None:
            result['userName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fromNodeGroups') is not None:
            self.from_node_groups = m.get('fromNodeGroups')
        if m.get('fromNodeIndexes') is not None:
            self.from_node_indexes = m.get('fromNodeIndexes')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        return self


class MainVersionMeta(TeaModel):
    def __init__(
        self,
        application_metas: List[ApplicationMeta] = None,
        cluster_type_metas: List[ClusterTypeMeta] = None,
        ecs_ram_role: str = None,
        gmt_modified: int = None,
        node_group_metas: List[NodeGroupMeta] = None,
        password_less_logins: List[PasswordLessLoginSpec] = None,
    ):
        # applicationMetas
        self.application_metas = application_metas
        # clusterTypeMetas
        self.cluster_type_metas = cluster_type_metas
        # ecsRamRole
        self.ecs_ram_role = ecs_ram_role
        # gmtModified
        self.gmt_modified = gmt_modified
        # nodeGroupMetas
        self.node_group_metas = node_group_metas
        # passwordLessLogins
        self.password_less_logins = password_less_logins

    def validate(self):
        if self.application_metas:
            for k in self.application_metas:
                if k:
                    k.validate()
        if self.cluster_type_metas:
            for k in self.cluster_type_metas:
                if k:
                    k.validate()
        if self.node_group_metas:
            for k in self.node_group_metas:
                if k:
                    k.validate()
        if self.password_less_logins:
            for k in self.password_less_logins:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationMetas'] = []
        if self.application_metas is not None:
            for k in self.application_metas:
                result['applicationMetas'].append(k.to_map() if k else None)
        result['clusterTypeMetas'] = []
        if self.cluster_type_metas is not None:
            for k in self.cluster_type_metas:
                result['clusterTypeMetas'].append(k.to_map() if k else None)
        if self.ecs_ram_role is not None:
            result['ecsRamRole'] = self.ecs_ram_role
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        result['nodeGroupMetas'] = []
        if self.node_group_metas is not None:
            for k in self.node_group_metas:
                result['nodeGroupMetas'].append(k.to_map() if k else None)
        result['passwordLessLogins'] = []
        if self.password_less_logins is not None:
            for k in self.password_less_logins:
                result['passwordLessLogins'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_metas = []
        if m.get('applicationMetas') is not None:
            for k in m.get('applicationMetas'):
                temp_model = ApplicationMeta()
                self.application_metas.append(temp_model.from_map(k))
        self.cluster_type_metas = []
        if m.get('clusterTypeMetas') is not None:
            for k in m.get('clusterTypeMetas'):
                temp_model = ClusterTypeMeta()
                self.cluster_type_metas.append(temp_model.from_map(k))
        if m.get('ecsRamRole') is not None:
            self.ecs_ram_role = m.get('ecsRamRole')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        self.node_group_metas = []
        if m.get('nodeGroupMetas') is not None:
            for k in m.get('nodeGroupMetas'):
                temp_model = NodeGroupMeta()
                self.node_group_metas.append(temp_model.from_map(k))
        self.password_less_logins = []
        if m.get('passwordLessLogins') is not None:
            for k in m.get('passwordLessLogins'):
                temp_model = PasswordLessLoginSpec()
                self.password_less_logins.append(temp_model.from_map(k))
        return self


class CreateMainVersionParam(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        main_version: str = None,
        main_version_meta: MainVersionMeta = None,
        release_type: str = None,
        uuid: str = None,
    ):
        # status
        self.image_id = image_id
        # mainVersion
        self.main_version = main_version
        self.main_version_meta = main_version_meta
        # imageId
        self.release_type = release_type
        # type
        self.uuid = uuid

    def validate(self):
        if self.main_version_meta:
            self.main_version_meta.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.main_version_meta is not None:
            result['mainVersionMeta'] = self.main_version_meta.to_map()
        if self.release_type is not None:
            result['releaseType'] = self.release_type
        if self.uuid is not None:
            result['uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('mainVersionMeta') is not None:
            temp_model = MainVersionMeta()
            self.main_version_meta = temp_model.from_map(m['mainVersionMeta'])
        if m.get('releaseType') is not None:
            self.release_type = m.get('releaseType')
        if m.get('uuid') is not None:
            self.uuid = m.get('uuid')
        return self


class CreateStackApplicationParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        version: str = None,
    ):
        # 应用名称
        self.name = name
        # 应用版本
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class DecreaseNodeGroupParam(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        cluster_id: str = None,
        delete_node_ids: List[str] = None,
        delete_number: int = None,
        node_group_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clientToken
        self.client_token = client_token
        # clusterId
        self.cluster_id = cluster_id
        # deleteNodeIds
        self.delete_node_ids = delete_node_ids
        # deleteNumber
        self.delete_number = delete_number
        # nodeGroupId
        self.node_group_id = node_group_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.delete_node_ids is not None:
            result['deleteNodeIds'] = self.delete_node_ids
        if self.delete_number is not None:
            result['deleteNumber'] = self.delete_number
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('deleteNodeIds') is not None:
            self.delete_node_ids = m.get('deleteNodeIds')
        if m.get('deleteNumber') is not None:
            self.delete_number = m.get('deleteNumber')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class DeleteAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        return self


class DeleteAutoScalingRuleParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_rule_id: str = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingRuleId
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_rule_id is not None:
            result['scalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingRuleId') is not None:
            self.scaling_rule_id = m.get('scalingRuleId')
        return self


class DeleteClusterScriptParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        script_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # clusterScriptId
        self.script_id = script_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.script_id is not None:
            result['scriptId'] = self.script_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scriptId') is not None:
            self.script_id = m.get('scriptId')
        return self


class DeleteClusterUserParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        user_id: str = None,
        user_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # userId
        self.user_id = user_id
        # userType
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class DeleteKubeCustomerResourcesParam(TeaModel):
    def __init__(
        self,
        api_group: str = None,
        api_plural: str = None,
        api_version: str = None,
        cluster_id: str = None,
        name: str = None,
        namespace: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # apiGroup
        self.api_group = api_group
        # apiPlural
        self.api_plural = api_plural
        # apiVersion
        self.api_version = api_version
        # clusterId
        self.cluster_id = cluster_id
        # name
        self.name = name
        # namespace
        self.namespace = namespace
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_plural is not None:
            result['apiPlural'] = self.api_plural
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiPlural') is not None:
            self.api_plural = m.get('apiPlural')
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class DeleteKubeNativeResourcesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        field_selector: str = None,
        label_selector: str = None,
        name: str = None,
        namespace: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        resource_type_plural: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # fieldSelector
        self.field_selector = field_selector
        # labelSelector
        self.label_selector = label_selector
        # name
        self.name = name
        # namespace
        self.namespace = namespace
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # resourceTypePlural
        self.resource_type_plural = resource_type_plural

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.field_selector is not None:
            result['fieldSelector'] = self.field_selector
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.resource_type_plural is not None:
            result['resourceTypePlural'] = self.resource_type_plural
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('fieldSelector') is not None:
            self.field_selector = m.get('fieldSelector')
        if m.get('labelSelector') is not None:
            self.label_selector = m.get('labelSelector')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('resourceTypePlural') is not None:
            self.resource_type_plural = m.get('resourceTypePlural')
        return self


class DeleteNodeGroupParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        description: str = None,
        node_group_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # description
        self.description = description
        # nodeGroupId
        self.node_group_id = node_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        return self


class DeleteStackApplicationParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        version: str = None,
    ):
        # 应用名称
        self.name = name
        # 应用版本
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class DeployApplicationParamApplicationComponentDeploymentList(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        component_name: str = None,
        deploy_scope: str = None,
        node_group_id_list: List[str] = None,
        node_id_list: List[str] = None,
    ):
        # applicationName
        self.application_name = application_name
        # componentName
        self.component_name = component_name
        # deployScope
        self.deploy_scope = deploy_scope
        # nodeGroupIdList
        self.node_group_id_list = node_group_id_list
        # nodeIdList
        self.node_id_list = node_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.deploy_scope is not None:
            result['deployScope'] = self.deploy_scope
        if self.node_group_id_list is not None:
            result['nodeGroupIdList'] = self.node_group_id_list
        if self.node_id_list is not None:
            result['nodeIdList'] = self.node_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('deployScope') is not None:
            self.deploy_scope = m.get('deployScope')
        if m.get('nodeGroupIdList') is not None:
            self.node_group_id_list = m.get('nodeGroupIdList')
        if m.get('nodeIdList') is not None:
            self.node_id_list = m.get('nodeIdList')
        return self


class DeployApplicationParamApplicationConfigList(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_item_value: str = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configItemValue
        self.config_item_value = config_item_value
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_value is not None:
            result['configItemValue'] = self.config_item_value
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemValue') is not None:
            self.config_item_value = m.get('configItemValue')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class DeployApplicationParamApplicationList(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # applicationVersion
        self.application_version = application_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        return self


class DeployApplicationParam(TeaModel):
    def __init__(
        self,
        application_component_deployment_list: List[DeployApplicationParamApplicationComponentDeploymentList] = None,
        application_config_list: List[DeployApplicationParamApplicationConfigList] = None,
        application_list: List[DeployApplicationParamApplicationList] = None,
        auto_recommend_config: bool = None,
        cluster_id: str = None,
        description: str = None,
        node_id_list: List[str] = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # applicationComponentDeploymentList
        self.application_component_deployment_list = application_component_deployment_list
        # applicationConfigList
        self.application_config_list = application_config_list
        # applicationList
        self.application_list = application_list
        # autoRecommendConfig
        self.auto_recommend_config = auto_recommend_config
        # clusterId
        self.cluster_id = cluster_id
        # description
        self.description = description
        # nodeIdList
        self.node_id_list = node_id_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.application_component_deployment_list:
            for k in self.application_component_deployment_list:
                if k:
                    k.validate()
        if self.application_config_list:
            for k in self.application_config_list:
                if k:
                    k.validate()
        if self.application_list:
            for k in self.application_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationComponentDeploymentList'] = []
        if self.application_component_deployment_list is not None:
            for k in self.application_component_deployment_list:
                result['applicationComponentDeploymentList'].append(k.to_map() if k else None)
        result['applicationConfigList'] = []
        if self.application_config_list is not None:
            for k in self.application_config_list:
                result['applicationConfigList'].append(k.to_map() if k else None)
        result['applicationList'] = []
        if self.application_list is not None:
            for k in self.application_list:
                result['applicationList'].append(k.to_map() if k else None)
        if self.auto_recommend_config is not None:
            result['autoRecommendConfig'] = self.auto_recommend_config
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.node_id_list is not None:
            result['nodeIdList'] = self.node_id_list
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_component_deployment_list = []
        if m.get('applicationComponentDeploymentList') is not None:
            for k in m.get('applicationComponentDeploymentList'):
                temp_model = DeployApplicationParamApplicationComponentDeploymentList()
                self.application_component_deployment_list.append(temp_model.from_map(k))
        self.application_config_list = []
        if m.get('applicationConfigList') is not None:
            for k in m.get('applicationConfigList'):
                temp_model = DeployApplicationParamApplicationConfigList()
                self.application_config_list.append(temp_model.from_map(k))
        self.application_list = []
        if m.get('applicationList') is not None:
            for k in m.get('applicationList'):
                temp_model = DeployApplicationParamApplicationList()
                self.application_list.append(temp_model.from_map(k))
        if m.get('autoRecommendConfig') is not None:
            self.auto_recommend_config = m.get('autoRecommendConfig')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('nodeIdList') is not None:
            self.node_id_list = m.get('nodeIdList')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class DeployModeSpec(TeaModel):
    def __init__(
        self,
        application_dtolist: List[MainVersionApplicationDTO] = None,
        deploy_mode: str = None,
    ):
        # applicationDTOList
        self.application_dtolist = application_dtolist
        # deployMode
        self.deploy_mode = deploy_mode

    def validate(self):
        if self.application_dtolist:
            for k in self.application_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplicationDTOList'] = []
        if self.application_dtolist is not None:
            for k in self.application_dtolist:
                result['ApplicationDTOList'].append(k.to_map() if k else None)
        if self.deploy_mode is not None:
            result['DeployMode'] = self.deploy_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_dtolist = []
        if m.get('ApplicationDTOList') is not None:
            for k in m.get('ApplicationDTOList'):
                temp_model = MainVersionApplicationDTO()
                self.application_dtolist.append(temp_model.from_map(k))
        if m.get('DeployMode') is not None:
            self.deploy_mode = m.get('DeployMode')
        return self


class DisableAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        return self


class DiskConstraintSpec(TeaModel):
    def __init__(
        self,
        default_value: int = None,
        end: int = None,
        start: int = None,
        step: int = None,
        type: str = None,
    ):
        # defaultValue
        self.default_value = default_value
        # end
        self.end = end
        # start
        self.start = start
        # step
        self.step = step
        # type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['defaultValue'] = self.default_value
        if self.end is not None:
            result['end'] = self.end
        if self.start is not None:
            result['start'] = self.start
        if self.step is not None:
            result['step'] = self.step
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultValue') is not None:
            self.default_value = m.get('defaultValue')
        if m.get('end') is not None:
            self.end = m.get('end')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('step') is not None:
            self.step = m.get('step')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EnableAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        return self


class ExecuteClusterScriptParam(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        script_ids: List[str] = None,
    ):
        # clientToken
        self.client_token = client_token
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scriptIds
        self.script_ids = script_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.script_ids is not None:
            result['scriptIds'] = self.script_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scriptIds') is not None:
            self.script_ids = m.get('scriptIds')
        return self


class GetApplicationActionsParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        component_name: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # componentName
        self.component_name = component_name
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetAutoScalingActivityParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_activity_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # 弹性伸缩活动ID
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_activity_id is not None:
            result['scalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingActivityId') is not None:
            self.scaling_activity_id = m.get('scalingActivityId')
        return self


class GetAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # 弹性伸缩策略ID
        self.scaling_policy_id = scaling_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        return self


class GetClusterOperationNodeParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetClusterOperationParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetClusterOperationTaskLogParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        operation_task_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # operationTaskId
        self.operation_task_id = operation_task_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.operation_task_id is not None:
            result['operationTaskId'] = self.operation_task_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('operationTaskId') is not None:
            self.operation_task_id = m.get('operationTaskId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetClusterOperationsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetClusterScriptDetailParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_script_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # clusterScriptId
        self.cluster_script_id = cluster_script_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_script_id is not None:
            result['clusterScriptId'] = self.cluster_script_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterScriptId') is not None:
            self.cluster_script_id = m.get('clusterScriptId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetConfigTagsParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class GetDependApplicationsParam(TeaModel):
    def __init__(
        self,
        application_list: List[ApplicationParam] = None,
        deploy_mode: str = None,
        main_version: str = None,
    ):
        self.application_list = application_list
        # 部署类型。
        self.deploy_mode = deploy_mode
        # 主版本。
        self.main_version = main_version

    def validate(self):
        if self.application_list:
            for k in self.application_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationList'] = []
        if self.application_list is not None:
            for k in self.application_list:
                result['applicationList'].append(k.to_map() if k else None)
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_list = []
        if m.get('applicationList') is not None:
            for k in m.get('applicationList'):
                temp_model = ApplicationParam()
                self.application_list.append(temp_model.from_map(k))
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        return self


class GetInstanceParam(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        resource_type: str = None,
        user_id: int = None,
    ):
        # instanceIds
        self.instance_ids = instance_ids
        # resourceType
        self.resource_type = resource_type
        # userId
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['instanceIds'] = self.instance_ids
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceIds') is not None:
            self.instance_ids = m.get('instanceIds')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetMainVersionDetailParam(TeaModel):
    def __init__(
        self,
        main_version: str = None,
        resource_owner_uid: str = None,
    ):
        # mainVersion
        self.main_version = main_version
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ViewChild(TeaModel):
    def __init__(
        self,
        name: str = None,
        title: str = None,
    ):
        # name
        self.name = name
        # title
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetReport(TeaModel):
    def __init__(
        self,
        children: List[ViewChild] = None,
        name: str = None,
        title: str = None,
    ):
        # children
        self.children = children
        # name
        self.name = name
        # title
        self.title = title

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['children'] = []
        if self.children is not None:
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.children = []
        if m.get('children') is not None:
            for k in m.get('children'):
                temp_model = ViewChild()
                self.children.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetReportDataParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        detail_data: bool = None,
        name: str = None,
        report_id: str = None,
        resource_owner_uid: str = None,
    ):
        # cluster id
        self.cluster_id = cluster_id
        # is deatil
        self.detail_data = detail_data
        # view name
        self.name = name
        # report Id
        self.report_id = report_id
        # user id
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.detail_data is not None:
            result['detailData'] = self.detail_data
        if self.name is not None:
            result['name'] = self.name
        if self.report_id is not None:
            result['reportId'] = self.report_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('detailData') is not None:
            self.detail_data = m.get('detailData')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('reportId') is not None:
            self.report_id = m.get('reportId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ReportData(TeaModel):
    def __init__(
        self,
        data: str = None,
        score: int = None,
        status: str = None,
        type: str = None,
    ):
        # data
        self.data = data
        # score
        self.score = score
        # status
        self.status = status
        # type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.score is not None:
            result['score'] = self.score
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('score') is not None:
            self.score = m.get('score')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetReportDataResult(TeaModel):
    def __init__(
        self,
        report_datas: List[ReportData] = None,
        time: int = None,
    ):
        # data
        self.report_datas = report_datas
        # time
        self.time = time

    def validate(self):
        if self.report_datas:
            for k in self.report_datas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['reportDatas'] = []
        if self.report_datas is not None:
            for k in self.report_datas:
                result['reportDatas'].append(k.to_map() if k else None)
        if self.time is not None:
            result['time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.report_datas = []
        if m.get('reportDatas') is not None:
            for k in m.get('reportDatas'):
                temp_model = ReportData()
                self.report_datas.append(temp_model.from_map(k))
        if m.get('time') is not None:
            self.time = m.get('time')
        return self


class GetReportParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        report_id: str = None,
        resource_owner_uid: str = None,
    ):
        # cluster id
        self.cluster_id = cluster_id
        # report id
        self.report_id = report_id
        # uid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.report_id is not None:
            result['reportId'] = self.report_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('reportId') is not None:
            self.report_id = m.get('reportId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class GetReportResult(TeaModel):
    def __init__(
        self,
        children: List[ViewChild] = None,
        name: str = None,
        report_time: int = None,
        title: str = None,
    ):
        # children
        self.children = children
        # name
        self.name = name
        # report time
        self.report_time = report_time
        # title
        self.title = title

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['children'] = []
        if self.children is not None:
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.report_time is not None:
            result['reportTime'] = self.report_time
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.children = []
        if m.get('children') is not None:
            for k in m.get('children'):
                temp_model = ViewChild()
                self.children.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('reportTime') is not None:
            self.report_time = m.get('reportTime')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class GetStackApplicationParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        version: str = None,
    ):
        # 应用名称
        self.name = name
        # 应用版本
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class GetWorkflowDefinitionParam(TeaModel):
    def __init__(
        self,
        workflow_definition_id: int = None,
    ):
        # 工作流定义Id
        self.workflow_definition_id = workflow_definition_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_definition_id is not None:
            result['workflowDefinitionId'] = self.workflow_definition_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowDefinitionId') is not None:
            self.workflow_definition_id = m.get('workflowDefinitionId')
        return self


class GetWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class HealthSummary(TeaModel):
    def __init__(
        self,
        bad_count: int = None,
        good_count: int = None,
        none_count: int = None,
        resource_type: str = None,
        stopped_count: int = None,
        total_count: int = None,
        unknown_count: int = None,
        warning_count: int = None,
    ):
        # 异常数
        self.bad_count = bad_count
        # 良好数
        self.good_count = good_count
        # 无状态数
        self.none_count = none_count
        # 资源类型
        self.resource_type = resource_type
        # 停止数
        self.stopped_count = stopped_count
        # 组件实例总数
        self.total_count = total_count
        # 未知数
        self.unknown_count = unknown_count
        # 警告数
        self.warning_count = warning_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bad_count is not None:
            result['badCount'] = self.bad_count
        if self.good_count is not None:
            result['goodCount'] = self.good_count
        if self.none_count is not None:
            result['noneCount'] = self.none_count
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.stopped_count is not None:
            result['stoppedCount'] = self.stopped_count
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        if self.unknown_count is not None:
            result['unknownCount'] = self.unknown_count
        if self.warning_count is not None:
            result['warningCount'] = self.warning_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('badCount') is not None:
            self.bad_count = m.get('badCount')
        if m.get('goodCount') is not None:
            self.good_count = m.get('goodCount')
        if m.get('noneCount') is not None:
            self.none_count = m.get('noneCount')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('stoppedCount') is not None:
            self.stopped_count = m.get('stoppedCount')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        if m.get('unknownCount') is not None:
            self.unknown_count = m.get('unknownCount')
        if m.get('warningCount') is not None:
            self.warning_count = m.get('warningCount')
        return self


class IncreaseDiskParamNodeGroupDiskResizeInfos(TeaModel):
    def __init__(
        self,
        new_disk_size: str = None,
        node_group_id: str = None,
    ):
        # newDiskSize
        self.new_disk_size = new_disk_size
        # nodeGroupId
        self.node_group_id = node_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_disk_size is not None:
            result['newDiskSize'] = self.new_disk_size
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('newDiskSize') is not None:
            self.new_disk_size = m.get('newDiskSize')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        return self


class IncreaseDiskParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_disk_resize_infos: List[IncreaseDiskParamNodeGroupDiskResizeInfos] = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        rolling_restart: bool = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupDiskResizeInfos
        self.node_group_disk_resize_infos = node_group_disk_resize_infos
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # rollingRestart
        self.rolling_restart = rolling_restart
        # token
        self.token = token

    def validate(self):
        if self.node_group_disk_resize_infos:
            for k in self.node_group_disk_resize_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        result['nodeGroupDiskResizeInfos'] = []
        if self.node_group_disk_resize_infos is not None:
            for k in self.node_group_disk_resize_infos:
                result['nodeGroupDiskResizeInfos'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.rolling_restart is not None:
            result['rollingRestart'] = self.rolling_restart
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        self.node_group_disk_resize_infos = []
        if m.get('nodeGroupDiskResizeInfos') is not None:
            for k in m.get('nodeGroupDiskResizeInfos'):
                temp_model = IncreaseDiskParamNodeGroupDiskResizeInfos()
                self.node_group_disk_resize_infos.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('rollingRestart') is not None:
            self.rolling_restart = m.get('rollingRestart')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class IncreaseNodeGroupParam(TeaModel):
    def __init__(
        self,
        add_count: int = None,
        application_configs: List[ApplicationConfigParam] = None,
        auto_renew: bool = None,
        auto_renew_period: int = None,
        auto_renew_period_unit: str = None,
        client_token: str = None,
        cluster_id: str = None,
        node_group_id: str = None,
        operate_user_id: str = None,
        period: int = None,
        period_unit: str = None,
        resource_owner_uid: str = None,
    ):
        # addCount
        self.add_count = add_count
        # applicationConfigs
        self.application_configs = application_configs
        # autoRenew
        self.auto_renew = auto_renew
        # autoRenewPeriod
        self.auto_renew_period = auto_renew_period
        # autoRenewPeriodUnit
        self.auto_renew_period_unit = auto_renew_period_unit
        # clientToken
        self.client_token = client_token
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupId
        self.node_group_id = node_group_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # period
        self.period = period
        # periodUnit
        self.period_unit = period_unit
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.application_configs:
            for k in self.application_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_count is not None:
            result['addCount'] = self.add_count
        result['applicationConfigs'] = []
        if self.application_configs is not None:
            for k in self.application_configs:
                result['applicationConfigs'].append(k.to_map() if k else None)
        if self.auto_renew is not None:
            result['autoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['autoRenewPeriod'] = self.auto_renew_period
        if self.auto_renew_period_unit is not None:
            result['autoRenewPeriodUnit'] = self.auto_renew_period_unit
        if self.client_token is not None:
            result['clientToken'] = self.client_token
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.period is not None:
            result['period'] = self.period
        if self.period_unit is not None:
            result['periodUnit'] = self.period_unit
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addCount') is not None:
            self.add_count = m.get('addCount')
        self.application_configs = []
        if m.get('applicationConfigs') is not None:
            for k in m.get('applicationConfigs'):
                temp_model = ApplicationConfigParam()
                self.application_configs.append(temp_model.from_map(k))
        if m.get('autoRenew') is not None:
            self.auto_renew = m.get('autoRenew')
        if m.get('autoRenewPeriod') is not None:
            self.auto_renew_period = m.get('autoRenewPeriod')
        if m.get('autoRenewPeriodUnit') is not None:
            self.auto_renew_period_unit = m.get('autoRenewPeriodUnit')
        if m.get('clientToken') is not None:
            self.client_token = m.get('clientToken')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('periodUnit') is not None:
            self.period_unit = m.get('periodUnit')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class InstanceDTO(TeaModel):
    def __init__(
        self,
        auto_renewal: bool = None,
        auto_renewal_duration: int = None,
        bid: str = None,
        commodity_code: str = None,
        end_time: int = None,
        instance_id: str = None,
        market_type: str = None,
        order_id: int = None,
        payment_type: str = None,
        region_id: str = None,
        release_time: int = None,
        resource_type: str = None,
        status: str = None,
        user_id: int = None,
    ):
        # autoRenewal
        self.auto_renewal = auto_renewal
        # autoRenewalDuration
        self.auto_renewal_duration = auto_renewal_duration
        # bid
        self.bid = bid
        # commodityCode
        self.commodity_code = commodity_code
        # endTime
        self.end_time = end_time
        # instanceId
        self.instance_id = instance_id
        # marketType
        self.market_type = market_type
        # orderId
        self.order_id = order_id
        # paymentType
        self.payment_type = payment_type
        # regionId
        self.region_id = region_id
        # releaseTime
        self.release_time = release_time
        # resourceType
        self.resource_type = resource_type
        # status
        self.status = status
        # userId
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renewal is not None:
            result['autoRenewal'] = self.auto_renewal
        if self.auto_renewal_duration is not None:
            result['autoRenewalDuration'] = self.auto_renewal_duration
        if self.bid is not None:
            result['bid'] = self.bid
        if self.commodity_code is not None:
            result['commodityCode'] = self.commodity_code
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.market_type is not None:
            result['marketType'] = self.market_type
        if self.order_id is not None:
            result['orderId'] = self.order_id
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.release_time is not None:
            result['releaseTime'] = self.release_time
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.status is not None:
            result['status'] = self.status
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoRenewal') is not None:
            self.auto_renewal = m.get('autoRenewal')
        if m.get('autoRenewalDuration') is not None:
            self.auto_renewal_duration = m.get('autoRenewalDuration')
        if m.get('bid') is not None:
            self.bid = m.get('bid')
        if m.get('commodityCode') is not None:
            self.commodity_code = m.get('commodityCode')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('marketType') is not None:
            self.market_type = m.get('marketType')
        if m.get('orderId') is not None:
            self.order_id = m.get('orderId')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('releaseTime') is not None:
            self.release_time = m.get('releaseTime')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class JoinResourceGroupParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_group_id: str = None,
        resource_id: str = None,
        resource_owner_uid: str = None,
        resource_type: str = None,
    ):
        # 操作人员ID
        self.operate_user_id = operate_user_id
        # 目标资源组ID
        self.resource_group_id = resource_group_id
        # 资源ID
        self.resource_id = resource_id
        # 资源所有者ID
        self.resource_owner_uid = resource_owner_uid
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.resource_id is not None:
            result['resourceId'] = self.resource_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('resourceId') is not None:
            self.resource_id = m.get('resourceId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        return self


class ListAckClusterNodePoolsParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        operate_user_id: str = None,
        product: str = None,
        product_role_name: str = None,
        product_selectors: NodeSelector = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # product
        self.product = product
        # productRoleName
        self.product_role_name = product_role_name
        self.product_selectors = product_selectors
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.product_selectors:
            self.product_selectors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product is not None:
            result['product'] = self.product
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.product_selectors is not None:
            result['productSelectors'] = self.product_selectors.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('productSelectors') is not None:
            temp_model = NodeSelector()
            self.product_selectors = temp_model.from_map(m['productSelectors'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListAckClusterNodesParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        operate_user_id: str = None,
        product_selectors: NodeSelector = None,
        resource_owner_uid: str = None,
        skipped_node_pools: List[str] = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # operateUserId
        self.operate_user_id = operate_user_id
        self.product_selectors = product_selectors
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # skippedNodePools
        self.skipped_node_pools = skipped_node_pools

    def validate(self):
        if self.product_selectors:
            self.product_selectors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_selectors is not None:
            result['productSelectors'] = self.product_selectors.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.skipped_node_pools is not None:
            result['skippedNodePools'] = self.skipped_node_pools
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productSelectors') is not None:
            temp_model = NodeSelector()
            self.product_selectors = temp_model.from_map(m['productSelectors'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('skippedNodePools') is not None:
            self.skipped_node_pools = m.get('skippedNodePools')
        return self


class ListApplicationMetaParam(TeaModel):
    def __init__(
        self,
        application_names: List[str] = None,
        deploy_mode: str = None,
        main_version: str = None,
    ):
        # applicationNames
        self.application_names = application_names
        # deployMode
        self.deploy_mode = deploy_mode
        # mainVersion
        self.main_version = main_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_names is not None:
            result['applicationNames'] = self.application_names
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationNames') is not None:
            self.application_names = m.get('applicationNames')
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        return self


class ListApplicationsParam(TeaModel):
    def __init__(
        self,
        application_name_list: List[str] = None,
        cluster_id: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
    ):
        # applicationNameList
        self.application_name_list = application_name_list
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name_list is not None:
            result['applicationNameList'] = self.application_name_list
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationNameList') is not None:
            self.application_name_list = m.get('applicationNameList')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class ListAutoScalingActivitiesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        end_time: int = None,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        scaling_activity_states: List[str] = None,
        scaling_activity_type: str = None,
        scaling_policy_id: str = None,
        start_time: int = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # endTime
        self.end_time = end_time
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingActivityStates
        self.scaling_activity_states = scaling_activity_states
        # scalingActivityType
        self.scaling_activity_type = scaling_activity_type
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id
        # startTime
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_activity_states is not None:
            result['scalingActivityStates'] = self.scaling_activity_states
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingActivityStates') is not None:
            self.scaling_activity_states = m.get('scalingActivityStates')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        return self


class ListAutoScalingMetricsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListAutoScalingPoliciesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_id: str = None,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        scaling_policy_status: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupId
        self.node_group_id = node_group_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyStatus
        self.scaling_policy_status = scaling_policy_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_status is not None:
            result['scalingPolicyStatus'] = self.scaling_policy_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyStatus') is not None:
            self.scaling_policy_status = m.get('scalingPolicyStatus')
        return self


class ListAutoScalingRulesParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
        scaling_rule_status: str = None,
        scaling_rule_type: str = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingPolicyId
        self.scaling_policy_id = scaling_policy_id
        # scalingRuleStatus
        self.scaling_rule_status = scaling_rule_status
        # scalingRuleType
        self.scaling_rule_type = scaling_rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_rule_status is not None:
            result['scalingRuleStatus'] = self.scaling_rule_status
        if self.scaling_rule_type is not None:
            result['scalingRuleType'] = self.scaling_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingRuleStatus') is not None:
            self.scaling_rule_status = m.get('scalingRuleStatus')
        if m.get('scalingRuleType') is not None:
            self.scaling_rule_type = m.get('scalingRuleType')
        return self


class ListClusterAckByInstanceIdsParam(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
    ):
        # instanceIds
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['instanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceIds') is not None:
            self.instance_ids = m.get('instanceIds')
        return self


class ListClusterAckClusterByClusterIdsParam(TeaModel):
    def __init__(
        self,
        cluster_ids: List[str] = None,
    ):
        # clusterIds
        self.cluster_ids = cluster_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_ids is not None:
            result['clusterIds'] = self.cluster_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterIds') is not None:
            self.cluster_ids = m.get('clusterIds')
        return self


class ListClusterNodeGroupsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_id_list: List[str] = None,
        node_group_name_list: List[str] = None,
        node_group_type_list: List[str] = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
        status_list: List[str] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupIdList
        self.node_group_id_list = node_group_id_list
        # nodeGroupNameList
        self.node_group_name_list = node_group_name_list
        # nodeGroupTypeList
        self.node_group_type_list = node_group_type_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort
        # statusList
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id_list is not None:
            result['nodeGroupIdList'] = self.node_group_id_list
        if self.node_group_name_list is not None:
            result['nodeGroupNameList'] = self.node_group_name_list
        if self.node_group_type_list is not None:
            result['nodeGroupTypeList'] = self.node_group_type_list
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        if self.status_list is not None:
            result['statusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupIdList') is not None:
            self.node_group_id_list = m.get('nodeGroupIdList')
        if m.get('nodeGroupNameList') is not None:
            self.node_group_name_list = m.get('nodeGroupNameList')
        if m.get('nodeGroupTypeList') is not None:
            self.node_group_type_list = m.get('nodeGroupTypeList')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        return self


class ListClusterOperationNodesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        parent_operation_node_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # parentOperationNodeId
        self.parent_operation_node_id = parent_operation_node_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.parent_operation_node_id is not None:
            result['parentOperationNodeId'] = self.parent_operation_node_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('parentOperationNodeId') is not None:
            self.parent_operation_node_id = m.get('parentOperationNodeId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListClusterOperationTasksParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
        status_list: List[str] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeId
        self.node_id = node_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort
        # statusList
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        if self.status_list is not None:
            result['statusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        return self


class ListClusterOperationsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_type: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        product: str = None,
        query_end_time: int = None,
        query_start_time: int = None,
        resource_owner_uid: str = None,
        resource_type: str = None,
        sort: str = None,
        status_list: List[str] = None,
        tokens: List[str] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationType
        self.operation_type = operation_type
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # product
        self.product = product
        # queryEndTime
        self.query_end_time = query_end_time
        # queryStartTime
        self.query_start_time = query_start_time
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # resourceType
        self.resource_type = resource_type
        # sort
        self.sort = sort
        # statusList
        self.status_list = status_list
        # tokens
        self.tokens = tokens

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_type is not None:
            result['operationType'] = self.operation_type
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.product is not None:
            result['product'] = self.product
        if self.query_end_time is not None:
            result['queryEndTime'] = self.query_end_time
        if self.query_start_time is not None:
            result['queryStartTime'] = self.query_start_time
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.sort is not None:
            result['sort'] = self.sort
        if self.status_list is not None:
            result['statusList'] = self.status_list
        if self.tokens is not None:
            result['tokens'] = self.tokens
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationType') is not None:
            self.operation_type = m.get('operationType')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('queryEndTime') is not None:
            self.query_end_time = m.get('queryEndTime')
        if m.get('queryStartTime') is not None:
            self.query_start_time = m.get('queryStartTime')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        if m.get('tokens') is not None:
            self.tokens = m.get('tokens')
        return self


class ListClusterOrdersParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        order_status: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # orderStatus
        self.order_status = order_status
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.order_status is not None:
            result['orderStatus'] = self.order_status
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('orderStatus') is not None:
            self.order_status = m.get('orderStatus')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListClusterScriptsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        operate_user_id: str = None,
        query_end_time: int = None,
        query_start_time: int = None,
        resource_owner_uid: str = None,
        script_name: str = None,
        script_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # operateUserId
        self.operate_user_id = operate_user_id
        # queryEndTime
        self.query_end_time = query_end_time
        # queryStartTime
        self.query_start_time = query_start_time
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # clusterScriptName
        self.script_name = script_name
        # clusterScriptType
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.query_end_time is not None:
            result['queryEndTime'] = self.query_end_time
        if self.query_start_time is not None:
            result['queryStartTime'] = self.query_start_time
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.script_name is not None:
            result['scriptName'] = self.script_name
        if self.script_type is not None:
            result['scriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('queryEndTime') is not None:
            self.query_end_time = m.get('queryEndTime')
        if m.get('queryStartTime') is not None:
            self.query_start_time = m.get('queryStartTime')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scriptName') is not None:
            self.script_name = m.get('scriptName')
        if m.get('scriptType') is not None:
            self.script_type = m.get('scriptType')
        return self


class ListClusterUserParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # userId
        self.user_id = user_id
        # userName
        self.user_name = user_name
        # userType
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_name is not None:
            result['userName'] = self.user_name
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class ListClustersParam(TeaModel):
    def __init__(
        self,
        cluster_id_list: List[str] = None,
        cluster_name: str = None,
        cluster_types: List[str] = None,
        iaa_stypes: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        payment_type_list: List[str] = None,
        query_end_time: int = None,
        query_start_time: int = None,
        resource_group_ids: List[str] = None,
        resource_owner_uid: str = None,
        sort: str = None,
        status_list: List[str] = None,
    ):
        # clusterIdList
        self.cluster_id_list = cluster_id_list
        # clusterName
        self.cluster_name = cluster_name
        # clusterTypes
        self.cluster_types = cluster_types
        # iaaSTypes
        self.iaa_stypes = iaa_stypes
        # pageSize
        self.max_results = max_results
        # pageNumber
        self.next_token = next_token
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # paymentTypeList
        self.payment_type_list = payment_type_list
        # queryEndTime
        self.query_end_time = query_end_time
        # queryStartTime
        self.query_start_time = query_start_time
        # resourceGroupIds
        self.resource_group_ids = resource_group_ids
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort
        # statusList
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id_list is not None:
            result['clusterIdList'] = self.cluster_id_list
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.cluster_types is not None:
            result['clusterTypes'] = self.cluster_types
        if self.iaa_stypes is not None:
            result['iaaSTypes'] = self.iaa_stypes
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.payment_type_list is not None:
            result['paymentTypeList'] = self.payment_type_list
        if self.query_end_time is not None:
            result['queryEndTime'] = self.query_end_time
        if self.query_start_time is not None:
            result['queryStartTime'] = self.query_start_time
        if self.resource_group_ids is not None:
            result['resourceGroupIds'] = self.resource_group_ids
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        if self.status_list is not None:
            result['statusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterIdList') is not None:
            self.cluster_id_list = m.get('clusterIdList')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('clusterTypes') is not None:
            self.cluster_types = m.get('clusterTypes')
        if m.get('iaaSTypes') is not None:
            self.iaa_stypes = m.get('iaaSTypes')
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('paymentTypeList') is not None:
            self.payment_type_list = m.get('paymentTypeList')
        if m.get('queryEndTime') is not None:
            self.query_end_time = m.get('queryEndTime')
        if m.get('queryStartTime') is not None:
            self.query_start_time = m.get('queryStartTime')
        if m.get('resourceGroupIds') is not None:
            self.resource_group_ids = m.get('resourceGroupIds')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        return self


class ListComponentInstancesParam(TeaModel):
    def __init__(
        self,
        application_name_list: List[str] = None,
        cluster_id: str = None,
        component_name_list: List[str] = None,
        component_status_list: List[str] = None,
        node_id_list: List[str] = None,
        node_name_list: List[str] = None,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
    ):
        # applicationNameList
        self.application_name_list = application_name_list
        # clusterId
        self.cluster_id = cluster_id
        # componentNameList
        self.component_name_list = component_name_list
        # componentStatusList
        self.component_status_list = component_status_list
        # nodeIdList
        self.node_id_list = node_id_list
        # nodeNameList
        self.node_name_list = node_name_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name_list is not None:
            result['applicationNameList'] = self.application_name_list
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.component_name_list is not None:
            result['componentNameList'] = self.component_name_list
        if self.component_status_list is not None:
            result['componentStatusList'] = self.component_status_list
        if self.node_id_list is not None:
            result['nodeIdList'] = self.node_id_list
        if self.node_name_list is not None:
            result['nodeNameList'] = self.node_name_list
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationNameList') is not None:
            self.application_name_list = m.get('applicationNameList')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('componentNameList') is not None:
            self.component_name_list = m.get('componentNameList')
        if m.get('componentStatusList') is not None:
            self.component_status_list = m.get('componentStatusList')
        if m.get('nodeIdList') is not None:
            self.node_id_list = m.get('nodeIdList')
        if m.get('nodeNameList') is not None:
            self.node_name_list = m.get('nodeNameList')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListComponentsParam(TeaModel):
    def __init__(
        self,
        application_name_list: List[str] = None,
        cluster_id: str = None,
        component_name_list: List[str] = None,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
    ):
        # applicationNameList
        self.application_name_list = application_name_list
        # clusterId
        self.cluster_id = cluster_id
        # componentNameList
        self.component_name_list = component_name_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name_list is not None:
            result['applicationNameList'] = self.application_name_list
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.component_name_list is not None:
            result['componentNameList'] = self.component_name_list
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationNameList') is not None:
            self.application_name_list = m.get('applicationNameList')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('componentNameList') is not None:
            self.component_name_list = m.get('componentNameList')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListConfigFilesParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        node_group_id: str = None,
        node_id: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class ListConfigHistoryParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_version: str = None,
        description: str = None,
        node_group_id: str = None,
        node_id: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configVersion
        self.config_version = config_version
        # description
        self.description = description
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        if self.description is not None:
            result['description'] = self.description
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class ListConfigVersionsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        config_version: str = None,
        description: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # configVersion
        self.config_version = config_version
        # description
        self.description = description
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        if self.description is not None:
            result['description'] = self.description
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        return self


class ListConfigsParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_scope: str = None,
        config_type: str = None,
        node_group_id: str = None,
        node_id: str = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        sort: str = None,
        tag_names: List[str] = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configScope
        self.config_scope = config_scope
        # configType
        self.config_type = config_type
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort
        # tagName
        self.tag_names = tag_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_scope is not None:
            result['configScope'] = self.config_scope
        if self.config_type is not None:
            result['configType'] = self.config_type
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        if self.tag_names is not None:
            result['tagNames'] = self.tag_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configScope') is not None:
            self.config_scope = m.get('configScope')
        if m.get('configType') is not None:
            self.config_type = m.get('configType')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('tagNames') is not None:
            self.tag_names = m.get('tagNames')
        return self


class ListKubeCustomerResourcesParam(TeaModel):
    def __init__(
        self,
        api_group: str = None,
        api_plural: str = None,
        api_version: str = None,
        cluster_id: str = None,
        field_selector: str = None,
        label_selector: str = None,
        name: str = None,
        namespace: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # apiGroup
        self.api_group = api_group
        # apiPlural
        self.api_plural = api_plural
        # apiVersion
        self.api_version = api_version
        # clusterId
        self.cluster_id = cluster_id
        # fieldSelector
        self.field_selector = field_selector
        # labelSelector
        self.label_selector = label_selector
        # name
        self.name = name
        # namespace
        self.namespace = namespace
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.api_plural is not None:
            result['apiPlural'] = self.api_plural
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.field_selector is not None:
            result['fieldSelector'] = self.field_selector
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('apiPlural') is not None:
            self.api_plural = m.get('apiPlural')
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('fieldSelector') is not None:
            self.field_selector = m.get('fieldSelector')
        if m.get('labelSelector') is not None:
            self.label_selector = m.get('labelSelector')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListKubeNativeResourcesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        field_selector: str = None,
        label_selector: str = None,
        name: str = None,
        namespace: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        resource_type_plural: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # fieldSelector
        self.field_selector = field_selector
        # labelSelector
        self.label_selector = label_selector
        # name
        self.name = name
        # namespace
        self.namespace = namespace
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # resourceTypePlural
        self.resource_type_plural = resource_type_plural

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.field_selector is not None:
            result['fieldSelector'] = self.field_selector
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.resource_type_plural is not None:
            result['resourceTypePlural'] = self.resource_type_plural
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('fieldSelector') is not None:
            self.field_selector = m.get('fieldSelector')
        if m.get('labelSelector') is not None:
            self.label_selector = m.get('labelSelector')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('resourceTypePlural') is not None:
            self.resource_type_plural = m.get('resourceTypePlural')
        return self


class ListMainVersionDTO(TeaModel):
    def __init__(
        self,
        iaas_type: str = None,
        create_time: str = None,
        main_version: str = None,
        release_type: str = None,
        status: str = None,
        type: str = None,
    ):
        # iaasType
        self.iaas_type = iaas_type
        # createTime
        self.create_time = create_time
        # mainVersion
        self.main_version = main_version
        # releaseType
        self.release_type = release_type
        # status
        self.status = status
        # type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iaas_type is not None:
            result['IaasType'] = self.iaas_type
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.release_type is not None:
            result['releaseType'] = self.release_type
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IaasType') is not None:
            self.iaas_type = m.get('IaasType')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('releaseType') is not None:
            self.release_type = m.get('releaseType')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListMainVersionsParam(TeaModel):
    def __init__(
        self,
        cluster_type: str = None,
        iaas_type: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterType
        self.cluster_type = cluster_type
        # iaasType
        self.iaas_type = iaas_type
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListNodeDiskParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_id_list: List[str] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeIdList
        self.node_id_list = node_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_id_list is not None:
            result['nodeIdList'] = self.node_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeIdList') is not None:
            self.node_id_list = m.get('nodeIdList')
        return self


class ListNodeGroupMetaParam(TeaModel):
    def __init__(
        self,
        component_names: List[str] = None,
        main_version: str = None,
    ):
        # componentNames
        self.component_names = component_names
        # mainVersion
        self.main_version = main_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_names is not None:
            result['componentNames'] = self.component_names
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentNames') is not None:
            self.component_names = m.get('componentNames')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        return self


class ListNodesParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        component_name: List[str] = None,
        node_fleet_id_list: List[str] = None,
        node_group_id_list: List[str] = None,
        node_ids: List[str] = None,
        node_name_list: List[str] = None,
        operate_user_id: str = None,
        order_by: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        private_ip: str = None,
        public_ip: str = None,
        resource_owner_uid: str = None,
        sort: str = None,
        status_list: List[str] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # componentName
        self.component_name = component_name
        # nodeFleetIdList
        self.node_fleet_id_list = node_fleet_id_list
        # nodeGroupIdList
        self.node_group_id_list = node_group_id_list
        # nodeIds
        self.node_ids = node_ids
        # nodeNameList
        self.node_name_list = node_name_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # orderBy
        self.order_by = order_by
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # privateIp
        self.private_ip = private_ip
        # publicIp
        self.public_ip = public_ip
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # sort
        self.sort = sort
        # statusList
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.node_fleet_id_list is not None:
            result['nodeFleetIdList'] = self.node_fleet_id_list
        if self.node_group_id_list is not None:
            result['nodeGroupIdList'] = self.node_group_id_list
        if self.node_ids is not None:
            result['nodeIds'] = self.node_ids
        if self.node_name_list is not None:
            result['nodeNameList'] = self.node_name_list
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.order_by is not None:
            result['orderBy'] = self.order_by
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.private_ip is not None:
            result['privateIp'] = self.private_ip
        if self.public_ip is not None:
            result['publicIp'] = self.public_ip
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.sort is not None:
            result['sort'] = self.sort
        if self.status_list is not None:
            result['statusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('nodeFleetIdList') is not None:
            self.node_fleet_id_list = m.get('nodeFleetIdList')
        if m.get('nodeGroupIdList') is not None:
            self.node_group_id_list = m.get('nodeGroupIdList')
        if m.get('nodeIds') is not None:
            self.node_ids = m.get('nodeIds')
        if m.get('nodeNameList') is not None:
            self.node_name_list = m.get('nodeNameList')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('orderBy') is not None:
            self.order_by = m.get('orderBy')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('privateIp') is not None:
            self.private_ip = m.get('privateIp')
        if m.get('publicIp') is not None:
            self.public_ip = m.get('publicIp')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        if m.get('statusList') is not None:
            self.status_list = m.get('statusList')
        return self


class ListOnKubeDedicatedNodesParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        cluster_id: str = None,
        desire_dedicated_node_pools: List[str] = None,
        node_label: KubeNodeLabelDTO = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # clusterId
        self.cluster_id = cluster_id
        # desireDedicatedNodePools
        self.desire_dedicated_node_pools = desire_dedicated_node_pools
        self.node_label = node_label
        # operateUserId
        self.operate_user_id = operate_user_id
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.node_label:
            self.node_label.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.desire_dedicated_node_pools is not None:
            result['desireDedicatedNodePools'] = self.desire_dedicated_node_pools
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label.to_map()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('desireDedicatedNodePools') is not None:
            self.desire_dedicated_node_pools = m.get('desireDedicatedNodePools')
        if m.get('nodeLabel') is not None:
            temp_model = KubeNodeLabelDTO()
            self.node_label = temp_model.from_map(m['nodeLabel'])
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListReportsParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ListReportsResult(TeaModel):
    def __init__(
        self,
        report_id: str = None,
        report_time: int = None,
        score: int = None,
    ):
        # reportId
        self.report_id = report_id
        # reportTime
        self.report_time = report_time
        # score
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['reportId'] = self.report_id
        if self.report_time is not None:
            result['reportTime'] = self.report_time
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('reportId') is not None:
            self.report_id = m.get('reportId')
        if m.get('reportTime') is not None:
            self.report_time = m.get('reportTime')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class ListResourceHealthParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        component_name: str = None,
        health_statuses: List[str] = None,
        node_ids: List[str] = None,
        node_names: List[str] = None,
        operate_user_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_owner_uid: str = None,
        resource_type: str = None,
    ):
        # 应用名称
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # 组件名称
        self.component_name = component_name
        # 健康状态
        self.health_statuses = health_statuses
        # 节点Id列表
        self.node_ids = node_ids
        # 节点名称列表
        self.node_names = node_names
        # operateUserId
        self.operate_user_id = operate_user_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # 查询的目标资源类型，合法值：APPLICATION, COMPONENT, COMPONENT_INSTANCE
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.health_statuses is not None:
            result['healthStatuses'] = self.health_statuses
        if self.node_ids is not None:
            result['nodeIds'] = self.node_ids
        if self.node_names is not None:
            result['nodeNames'] = self.node_names
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('healthStatuses') is not None:
            self.health_statuses = m.get('healthStatuses')
        if m.get('nodeIds') is not None:
            self.node_ids = m.get('nodeIds')
        if m.get('nodeNames') is not None:
            self.node_names = m.get('nodeNames')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        return self


class ListStackApplicationParam(TeaModel):
    def __init__(
        self,
        create_time_end: int = None,
        create_time_start: int = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # createTimeEnd
        self.create_time_end = create_time_end
        # createTimeStart
        self.create_time_start = create_time_start
        # name
        self.name = name
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['createTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['createTimeStart'] = self.create_time_start
        if self.name is not None:
            result['name'] = self.name
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTimeEnd') is not None:
            self.create_time_end = m.get('createTimeEnd')
        if m.get('createTimeStart') is not None:
            self.create_time_start = m.get('createTimeStart')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class ListWorkflowActivityInstancesParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class NodeGroupMetaDTO(TeaModel):
    def __init__(
        self,
        component_tags: List[str] = None,
        component_taints: List[str] = None,
        data_disk_constraint: DiskConstraint = None,
        node_group_type: str = None,
        support_actions: List[str] = None,
        system_disk_constraint: DiskConstraint = None,
    ):
        # componentTags
        self.component_tags = component_tags
        # componentTaints
        self.component_taints = component_taints
        # dataDiskConstraint
        self.data_disk_constraint = data_disk_constraint
        # nodeGroupType
        self.node_group_type = node_group_type
        # supportActions
        self.support_actions = support_actions
        # systemDiskConstraint
        self.system_disk_constraint = system_disk_constraint

    def validate(self):
        if self.data_disk_constraint:
            self.data_disk_constraint.validate()
        if self.system_disk_constraint:
            self.system_disk_constraint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_tags is not None:
            result['componentTags'] = self.component_tags
        if self.component_taints is not None:
            result['componentTaints'] = self.component_taints
        if self.data_disk_constraint is not None:
            result['dataDiskConstraint'] = self.data_disk_constraint.to_map()
        if self.node_group_type is not None:
            result['nodeGroupType'] = self.node_group_type
        if self.support_actions is not None:
            result['supportActions'] = self.support_actions
        if self.system_disk_constraint is not None:
            result['systemDiskConstraint'] = self.system_disk_constraint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentTags') is not None:
            self.component_tags = m.get('componentTags')
        if m.get('componentTaints') is not None:
            self.component_taints = m.get('componentTaints')
        if m.get('dataDiskConstraint') is not None:
            temp_model = DiskConstraint()
            self.data_disk_constraint = temp_model.from_map(m['dataDiskConstraint'])
        if m.get('nodeGroupType') is not None:
            self.node_group_type = m.get('nodeGroupType')
        if m.get('supportActions') is not None:
            self.support_actions = m.get('supportActions')
        if m.get('systemDiskConstraint') is not None:
            temp_model = DiskConstraint()
            self.system_disk_constraint = temp_model.from_map(m['systemDiskConstraint'])
        return self


class SshSpec(TeaModel):
    def __init__(
        self,
        password_less_logins: List[PasswordLessLoginSpec] = None,
    ):
        # passwordLessLogins
        self.password_less_logins = password_less_logins

    def validate(self):
        if self.password_less_logins:
            for k in self.password_less_logins:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['passwordLessLogins'] = []
        if self.password_less_logins is not None:
            for k in self.password_less_logins:
                result['passwordLessLogins'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.password_less_logins = []
        if m.get('passwordLessLogins') is not None:
            for k in m.get('passwordLessLogins'):
                temp_model = PasswordLessLoginSpec()
                self.password_less_logins.append(temp_model.from_map(k))
        return self


class MainVersionDTO(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        iaas_type: str = None,
        cluster_type_dtos: List[ClusterTypeDTO] = None,
        ecs_ram_role: str = None,
        image_id: str = None,
        main_version: str = None,
        node_group_spec_dtos: List[NodeGroupMetaDTO] = None,
        ssh_spec: SshSpec = None,
        status: str = None,
        type: str = None,
    ):
        # createTime
        self.create_time = create_time
        # iaasType
        self.iaas_type = iaas_type
        # clusterTypeDTOS
        self.cluster_type_dtos = cluster_type_dtos
        # ecsRamRole
        self.ecs_ram_role = ecs_ram_role
        # imageId
        self.image_id = image_id
        # mainVersion
        self.main_version = main_version
        # nodeGroupSpecDTOS
        self.node_group_spec_dtos = node_group_spec_dtos
        self.ssh_spec = ssh_spec
        # status
        self.status = status
        # type
        self.type = type

    def validate(self):
        if self.cluster_type_dtos:
            for k in self.cluster_type_dtos:
                if k:
                    k.validate()
        if self.node_group_spec_dtos:
            for k in self.node_group_spec_dtos:
                if k:
                    k.validate()
        if self.ssh_spec:
            self.ssh_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.iaas_type is not None:
            result['IaasType'] = self.iaas_type
        result['clusterTypeDTOS'] = []
        if self.cluster_type_dtos is not None:
            for k in self.cluster_type_dtos:
                result['clusterTypeDTOS'].append(k.to_map() if k else None)
        if self.ecs_ram_role is not None:
            result['ecsRamRole'] = self.ecs_ram_role
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        result['nodeGroupSpecDTOS'] = []
        if self.node_group_spec_dtos is not None:
            for k in self.node_group_spec_dtos:
                result['nodeGroupSpecDTOS'].append(k.to_map() if k else None)
        if self.ssh_spec is not None:
            result['sshSpec'] = self.ssh_spec.to_map()
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IaasType') is not None:
            self.iaas_type = m.get('IaasType')
        self.cluster_type_dtos = []
        if m.get('clusterTypeDTOS') is not None:
            for k in m.get('clusterTypeDTOS'):
                temp_model = ClusterTypeDTO()
                self.cluster_type_dtos.append(temp_model.from_map(k))
        if m.get('ecsRamRole') is not None:
            self.ecs_ram_role = m.get('ecsRamRole')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        self.node_group_spec_dtos = []
        if m.get('nodeGroupSpecDTOS') is not None:
            for k in m.get('nodeGroupSpecDTOS'):
                temp_model = NodeGroupMetaDTO()
                self.node_group_spec_dtos.append(temp_model.from_map(k))
        if m.get('sshSpec') is not None:
            temp_model = SshSpec()
            self.ssh_spec = temp_model.from_map(m['sshSpec'])
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class MainVersionDetailDTO(TeaModel):
    def __init__(
        self,
        application_meta_dtos: List[ApplicationMeta] = None,
        cluster_type_metas: List[ClusterTypeMeta] = None,
        ecs_ram_role: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        image_id: str = None,
        main_version: str = None,
        node_group_meta_dtos: List[NodeGroupMeta] = None,
        password_less_logins: List[PasswordLessLoginSpec] = None,
        product: str = None,
        release_type: str = None,
        status: str = None,
        uuid: str = None,
    ):
        # applicationMetaDTOS
        self.application_meta_dtos = application_meta_dtos
        # clusterTypeMetas
        self.cluster_type_metas = cluster_type_metas
        # ecsRamRole
        self.ecs_ram_role = ecs_ram_role
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # imageId
        self.image_id = image_id
        # mainVersion
        self.main_version = main_version
        # nodeGroupMetaDTOS
        self.node_group_meta_dtos = node_group_meta_dtos
        # passwordLessLogins
        self.password_less_logins = password_less_logins
        # product
        self.product = product
        # releaseType
        self.release_type = release_type
        # status
        self.status = status
        # uuid
        self.uuid = uuid

    def validate(self):
        if self.application_meta_dtos:
            for k in self.application_meta_dtos:
                if k:
                    k.validate()
        if self.cluster_type_metas:
            for k in self.cluster_type_metas:
                if k:
                    k.validate()
        if self.node_group_meta_dtos:
            for k in self.node_group_meta_dtos:
                if k:
                    k.validate()
        if self.password_less_logins:
            for k in self.password_less_logins:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applicationMetaDTOS'] = []
        if self.application_meta_dtos is not None:
            for k in self.application_meta_dtos:
                result['applicationMetaDTOS'].append(k.to_map() if k else None)
        result['clusterTypeMetas'] = []
        if self.cluster_type_metas is not None:
            for k in self.cluster_type_metas:
                result['clusterTypeMetas'].append(k.to_map() if k else None)
        if self.ecs_ram_role is not None:
            result['ecsRamRole'] = self.ecs_ram_role
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        result['nodeGroupMetaDTOS'] = []
        if self.node_group_meta_dtos is not None:
            for k in self.node_group_meta_dtos:
                result['nodeGroupMetaDTOS'].append(k.to_map() if k else None)
        result['passwordLessLogins'] = []
        if self.password_less_logins is not None:
            for k in self.password_less_logins:
                result['passwordLessLogins'].append(k.to_map() if k else None)
        if self.product is not None:
            result['product'] = self.product
        if self.release_type is not None:
            result['releaseType'] = self.release_type
        if self.status is not None:
            result['status'] = self.status
        if self.uuid is not None:
            result['uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_meta_dtos = []
        if m.get('applicationMetaDTOS') is not None:
            for k in m.get('applicationMetaDTOS'):
                temp_model = ApplicationMeta()
                self.application_meta_dtos.append(temp_model.from_map(k))
        self.cluster_type_metas = []
        if m.get('clusterTypeMetas') is not None:
            for k in m.get('clusterTypeMetas'):
                temp_model = ClusterTypeMeta()
                self.cluster_type_metas.append(temp_model.from_map(k))
        if m.get('ecsRamRole') is not None:
            self.ecs_ram_role = m.get('ecsRamRole')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        self.node_group_meta_dtos = []
        if m.get('nodeGroupMetaDTOS') is not None:
            for k in m.get('nodeGroupMetaDTOS'):
                temp_model = NodeGroupMeta()
                self.node_group_meta_dtos.append(temp_model.from_map(k))
        self.password_less_logins = []
        if m.get('passwordLessLogins') is not None:
            for k in m.get('passwordLessLogins'):
                temp_model = PasswordLessLoginSpec()
                self.password_less_logins.append(temp_model.from_map(k))
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('releaseType') is not None:
            self.release_type = m.get('releaseType')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('uuid') is not None:
            self.uuid = m.get('uuid')
        return self


class Meta(TeaModel):
    def __init__(
        self,
        score: int = None,
        status: str = None,
    ):
        # score
        self.score = score
        # status
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.score is not None:
            result['score'] = self.score
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('score') is not None:
            self.score = m.get('score')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ModifyClusterScriptParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_script_args: str = None,
        cluster_script_content: str = None,
        cluster_script_content_spec: str = None,
        cluster_script_id: str = None,
        cluster_script_name: str = None,
        cluster_script_path: str = None,
        cluster_script_type: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # clusterScriptArgs
        self.cluster_script_args = cluster_script_args
        # clusterScriptContent
        self.cluster_script_content = cluster_script_content
        # clusterScriptContentSpec
        self.cluster_script_content_spec = cluster_script_content_spec
        # clusterScriptId
        self.cluster_script_id = cluster_script_id
        # clusterScriptName
        self.cluster_script_name = cluster_script_name
        # clusterScriptPath
        self.cluster_script_path = cluster_script_path
        # clusterScriptType
        self.cluster_script_type = cluster_script_type
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_script_args is not None:
            result['clusterScriptArgs'] = self.cluster_script_args
        if self.cluster_script_content is not None:
            result['clusterScriptContent'] = self.cluster_script_content
        if self.cluster_script_content_spec is not None:
            result['clusterScriptContentSpec'] = self.cluster_script_content_spec
        if self.cluster_script_id is not None:
            result['clusterScriptId'] = self.cluster_script_id
        if self.cluster_script_name is not None:
            result['clusterScriptName'] = self.cluster_script_name
        if self.cluster_script_path is not None:
            result['clusterScriptPath'] = self.cluster_script_path
        if self.cluster_script_type is not None:
            result['clusterScriptType'] = self.cluster_script_type
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterScriptArgs') is not None:
            self.cluster_script_args = m.get('clusterScriptArgs')
        if m.get('clusterScriptContent') is not None:
            self.cluster_script_content = m.get('clusterScriptContent')
        if m.get('clusterScriptContentSpec') is not None:
            self.cluster_script_content_spec = m.get('clusterScriptContentSpec')
        if m.get('clusterScriptId') is not None:
            self.cluster_script_id = m.get('clusterScriptId')
        if m.get('clusterScriptName') is not None:
            self.cluster_script_name = m.get('clusterScriptName')
        if m.get('clusterScriptPath') is not None:
            self.cluster_script_path = m.get('clusterScriptPath')
        if m.get('clusterScriptType') is not None:
            self.cluster_script_type = m.get('clusterScriptType')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ModifyPrepayInstanceSpecParamInstanceTypeConfig(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        node_group_id: str = None,
    ):
        # instanceType
        self.instance_type = instance_type
        # nodeGroupId
        self.node_group_id = node_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['instanceType'] = self.instance_type
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceType') is not None:
            self.instance_type = m.get('instanceType')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        return self


class ModifyPrepayInstanceSpecParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        instance_type_config: List[ModifyPrepayInstanceSpecParamInstanceTypeConfig] = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        rolling_restart: bool = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # instanceTypeConfig
        self.instance_type_config = instance_type_config
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # rollingRestart
        self.rolling_restart = rolling_restart
        # token
        self.token = token

    def validate(self):
        if self.instance_type_config:
            for k in self.instance_type_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        result['instanceTypeConfig'] = []
        if self.instance_type_config is not None:
            for k in self.instance_type_config:
                result['instanceTypeConfig'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.rolling_restart is not None:
            result['rollingRestart'] = self.rolling_restart
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        self.instance_type_config = []
        if m.get('instanceTypeConfig') is not None:
            for k in m.get('instanceTypeConfig'):
                temp_model = ModifyPrepayInstanceSpecParamInstanceTypeConfig()
                self.instance_type_config.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('rollingRestart') is not None:
            self.rolling_restart = m.get('rollingRestart')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class NoneResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # requestId
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class PayOrderCallbackParam(TeaModel):
    def __init__(
        self,
        data: str = None,
    ):
        # 支付回调数据体
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class PreCheckDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        result: bool = None,
    ):
        # 校验类型
        self.key = key
        # 校验结果
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class PreCheckParam(TeaModel):
    def __init__(
        self,
        keys: List[str] = None,
        user_id: int = None,
    ):
        # 校验类型
        self.keys = keys
        # 用户ID
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keys is not None:
            result['keys'] = self.keys
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keys') is not None:
            self.keys = m.get('keys')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class ProductCallerIdParam(TeaModel):
    def __init__(
        self,
        product_caller_id: str = None,
    ):
        # productCallerId
        self.product_caller_id = product_caller_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_caller_id is not None:
            result['productCallerId'] = self.product_caller_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('productCallerId') is not None:
            self.product_caller_id = m.get('productCallerId')
        return self


class ProductCallerMappingDTO(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        product_caller_id: str = None,
        product_name: str = None,
    ):
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # productCallerId
        self.product_caller_id = product_caller_id
        # productName
        self.product_name = product_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.product_caller_id is not None:
            result['productCallerId'] = self.product_caller_id
        if self.product_name is not None:
            result['productName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('productCallerId') is not None:
            self.product_caller_id = m.get('productCallerId')
        if m.get('productName') is not None:
            self.product_name = m.get('productName')
        return self


class ProductNameParam(TeaModel):
    def __init__(
        self,
        product_name: str = None,
    ):
        # productName
        self.product_name = product_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['productName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('productName') is not None:
            self.product_name = m.get('productName')
        return self


class PromotionOption(TeaModel):
    def __init__(
        self,
        product_code: str = None,
        promotion_option_code: str = None,
        promotion_option_no: str = None,
    ):
        # productCode
        self.product_code = product_code
        # promotionOptionCode
        self.promotion_option_code = promotion_option_code
        # promotionOptionNo
        self.promotion_option_no = promotion_option_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['productCode'] = self.product_code
        if self.promotion_option_code is not None:
            result['promotionOptionCode'] = self.promotion_option_code
        if self.promotion_option_no is not None:
            result['promotionOptionNo'] = self.promotion_option_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('productCode') is not None:
            self.product_code = m.get('productCode')
        if m.get('promotionOptionCode') is not None:
            self.promotion_option_code = m.get('promotionOptionCode')
        if m.get('promotionOptionNo') is not None:
            self.promotion_option_no = m.get('promotionOptionNo')
        return self


class QueryGrafanaDataParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # data
        self.data = data
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.data is not None:
            result['data'] = self.data
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class RefreshStackApplicationParam(TeaModel):
    def __init__(
        self,
        name: str = None,
        version: str = None,
    ):
        # 应用名称
        self.name = name
        # 应用版本
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class RegisterClusterAckResourceParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        cluster_id: str = None,
        namespace: str = None,
        node_label: str = None,
        operate_user_id: str = None,
        oss_path: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # clusterId
        self.cluster_id = cluster_id
        # namespace
        self.namespace = namespace
        # nodeLabel
        self.node_label = node_label
        # operateUserId
        self.operate_user_id = operate_user_id
        # ossPath
        self.oss_path = oss_path
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.oss_path is not None:
            result['ossPath'] = self.oss_path
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('nodeLabel') is not None:
            self.node_label = m.get('nodeLabel')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('ossPath') is not None:
            self.oss_path = m.get('ossPath')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ReleaseBindingAckClusterParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # token
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class ReleaseClusterParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class ReleaseOnEcsClusterParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class RemoveSuspendPointOnWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # workflowInstanceId
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class RenewClusterParamNodeList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        period: int = None,
        period_unit: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # period
        self.period = period
        # periodUnit
        self.period_unit = period_unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.period is not None:
            result['period'] = self.period
        if self.period_unit is not None:
            result['periodUnit'] = self.period_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('periodUnit') is not None:
            self.period_unit = m.get('periodUnit')
        return self


class RenewClusterParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_id_list: List[str] = None,
        node_list: List[RenewClusterParamNodeList] = None,
        operate_user_id: str = None,
        period: int = None,
        period_unit: str = None,
        promotion_option: PromotionOption = None,
        resource_owner_uid: str = None,
        scope: str = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupIdList
        self.node_group_id_list = node_group_id_list
        # nodeList
        self.node_list = node_list
        # operateUserId
        self.operate_user_id = operate_user_id
        # period
        self.period = period
        # periodUnit
        self.period_unit = period_unit
        # promotionOption
        self.promotion_option = promotion_option
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scope
        self.scope = scope
        # token
        self.token = token

    def validate(self):
        if self.node_list:
            for k in self.node_list:
                if k:
                    k.validate()
        if self.promotion_option:
            self.promotion_option.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id_list is not None:
            result['nodeGroupIdList'] = self.node_group_id_list
        result['nodeList'] = []
        if self.node_list is not None:
            for k in self.node_list:
                result['nodeList'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.period is not None:
            result['period'] = self.period
        if self.period_unit is not None:
            result['periodUnit'] = self.period_unit
        if self.promotion_option is not None:
            result['promotionOption'] = self.promotion_option.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scope is not None:
            result['scope'] = self.scope
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupIdList') is not None:
            self.node_group_id_list = m.get('nodeGroupIdList')
        self.node_list = []
        if m.get('nodeList') is not None:
            for k in m.get('nodeList'):
                temp_model = RenewClusterParamNodeList()
                self.node_list.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('periodUnit') is not None:
            self.period_unit = m.get('periodUnit')
        if m.get('promotionOption') is not None:
            temp_model = PromotionOption()
            self.promotion_option = temp_model.from_map(m['promotionOption'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class Report(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        report_id: str = None,
        report_time: int = None,
        score: int = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # reportId
        self.report_id = report_id
        # reportTime
        self.report_time = report_time
        # score
        self.score = score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.report_id is not None:
            result['reportId'] = self.report_id
        if self.report_time is not None:
            result['reportTime'] = self.report_time
        if self.score is not None:
            result['score'] = self.score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('reportId') is not None:
            self.report_id = m.get('reportId')
        if m.get('reportTime') is not None:
            self.report_time = m.get('reportTime')
        if m.get('score') is not None:
            self.score = m.get('score')
        return self


class RestartWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class ResumeWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class RetryClusterOperationParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class RetryClusterOperationTaskParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        operation_task_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # operationTaskId
        self.operation_task_id = operation_task_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.operation_task_id is not None:
            result['operationTaskId'] = self.operation_task_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('operationTaskId') is not None:
            self.operation_task_id = m.get('operationTaskId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class RetryWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        execution_context: str = None,
        signal_biz_code_collection: str = None,
        start_activity_instance_id: int = None,
        workflow_instance_id: int = None,
        workflow_retry_policy: str = None,
    ):
        # ExecutionContext
        self.execution_context = execution_context
        # SignalBizCodeCollectionSignalBizCodeCollection
        self.signal_biz_code_collection = signal_biz_code_collection
        # startActivityInstanceId
        self.start_activity_instance_id = start_activity_instance_id
        # workflowInstanceId
        self.workflow_instance_id = workflow_instance_id
        # WorkflowRetryPolicy
        self.workflow_retry_policy = workflow_retry_policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_context is not None:
            result['executionContext'] = self.execution_context
        if self.signal_biz_code_collection is not None:
            result['signalBizCodeCollection'] = self.signal_biz_code_collection
        if self.start_activity_instance_id is not None:
            result['startActivityInstanceId'] = self.start_activity_instance_id
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        if self.workflow_retry_policy is not None:
            result['workflowRetryPolicy'] = self.workflow_retry_policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executionContext') is not None:
            self.execution_context = m.get('executionContext')
        if m.get('signalBizCodeCollection') is not None:
            self.signal_biz_code_collection = m.get('signalBizCodeCollection')
        if m.get('startActivityInstanceId') is not None:
            self.start_activity_instance_id = m.get('startActivityInstanceId')
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        if m.get('workflowRetryPolicy') is not None:
            self.workflow_retry_policy = m.get('workflowRetryPolicy')
        return self


class RollbackWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        execution_context: str = None,
        start_rollback_activity_instance_id: int = None,
        workflow_instance_id: int = None,
        workflow_rollback_policy: str = None,
    ):
        # ExecutionContext
        self.execution_context = execution_context
        # StartRollbackActivityInstanceId
        self.start_rollback_activity_instance_id = start_rollback_activity_instance_id
        # WorkflowInstanceId
        self.workflow_instance_id = workflow_instance_id
        # WorkflowRollbackPolicy
        self.workflow_rollback_policy = workflow_rollback_policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_context is not None:
            result['executionContext'] = self.execution_context
        if self.start_rollback_activity_instance_id is not None:
            result['startRollbackActivityInstanceId'] = self.start_rollback_activity_instance_id
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        if self.workflow_rollback_policy is not None:
            result['workflowRollbackPolicy'] = self.workflow_rollback_policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executionContext') is not None:
            self.execution_context = m.get('executionContext')
        if m.get('startRollbackActivityInstanceId') is not None:
            self.start_rollback_activity_instance_id = m.get('startRollbackActivityInstanceId')
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        if m.get('workflowRollbackPolicy') is not None:
            self.workflow_rollback_policy = m.get('workflowRollbackPolicy')
        return self


class RunActionParamComponentInstanceParams(TeaModel):
    def __init__(
        self,
        component_name: str = None,
        node_id: str = None,
    ):
        # componentName
        self.component_name = component_name
        # nodeId
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class RunActionParam(TeaModel):
    def __init__(
        self,
        action_name: str = None,
        action_params: Dict[str, str] = None,
        application_name: str = None,
        cluster_id: str = None,
        component_instance_params: List[RunActionParamComponentInstanceParams] = None,
        component_names: List[str] = None,
        description: str = None,
        execute_fail_strategy: str = None,
        interval: int = None,
        node_count_per_batch: int = None,
        node_group_ids: List[str] = None,
        node_ids: List[str] = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        run_action_scope: str = None,
        turn_on_maintenance_mode: bool = None,
    ):
        # actionName
        self.action_name = action_name
        # actionParams
        self.action_params = action_params
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # componentInstanceParams
        self.component_instance_params = component_instance_params
        # componentNames
        self.component_names = component_names
        # description
        self.description = description
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # interval
        self.interval = interval
        # nodeCountPerBatch
        self.node_count_per_batch = node_count_per_batch
        # nodeGroupIds
        self.node_group_ids = node_group_ids
        # nodeIds
        self.node_ids = node_ids
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # runActionScope
        self.run_action_scope = run_action_scope
        # turnOnMaintenanceMode
        self.turn_on_maintenance_mode = turn_on_maintenance_mode

    def validate(self):
        if self.component_instance_params:
            for k in self.component_instance_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_name is not None:
            result['actionName'] = self.action_name
        if self.action_params is not None:
            result['actionParams'] = self.action_params
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        result['componentInstanceParams'] = []
        if self.component_instance_params is not None:
            for k in self.component_instance_params:
                result['componentInstanceParams'].append(k.to_map() if k else None)
        if self.component_names is not None:
            result['componentNames'] = self.component_names
        if self.description is not None:
            result['description'] = self.description
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.interval is not None:
            result['interval'] = self.interval
        if self.node_count_per_batch is not None:
            result['nodeCountPerBatch'] = self.node_count_per_batch
        if self.node_group_ids is not None:
            result['nodeGroupIds'] = self.node_group_ids
        if self.node_ids is not None:
            result['nodeIds'] = self.node_ids
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.run_action_scope is not None:
            result['runActionScope'] = self.run_action_scope
        if self.turn_on_maintenance_mode is not None:
            result['turnOnMaintenanceMode'] = self.turn_on_maintenance_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actionName') is not None:
            self.action_name = m.get('actionName')
        if m.get('actionParams') is not None:
            self.action_params = m.get('actionParams')
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        self.component_instance_params = []
        if m.get('componentInstanceParams') is not None:
            for k in m.get('componentInstanceParams'):
                temp_model = RunActionParamComponentInstanceParams()
                self.component_instance_params.append(temp_model.from_map(k))
        if m.get('componentNames') is not None:
            self.component_names = m.get('componentNames')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        if m.get('nodeCountPerBatch') is not None:
            self.node_count_per_batch = m.get('nodeCountPerBatch')
        if m.get('nodeGroupIds') is not None:
            self.node_group_ids = m.get('nodeGroupIds')
        if m.get('nodeIds') is not None:
            self.node_ids = m.get('nodeIds')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('runActionScope') is not None:
            self.run_action_scope = m.get('runActionScope')
        if m.get('turnOnMaintenanceMode') is not None:
            self.turn_on_maintenance_mode = m.get('turnOnMaintenanceMode')
        return self


class SignalWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        activity_end_status: str = None,
        delay_mills: int = None,
        signal_biz_code_collection: List[str] = None,
        workflow_instance_id: int = None,
    ):
        # ActivityEndStatus
        self.activity_end_status = activity_end_status
        # DelayMills
        self.delay_mills = delay_mills
        # SignalBizCodeCollection
        self.signal_biz_code_collection = signal_biz_code_collection
        # WorkflowInstanceId
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_end_status is not None:
            result['activityEndStatus'] = self.activity_end_status
        if self.delay_mills is not None:
            result['delayMills'] = self.delay_mills
        if self.signal_biz_code_collection is not None:
            result['signalBizCodeCollection'] = self.signal_biz_code_collection
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activityEndStatus') is not None:
            self.activity_end_status = m.get('activityEndStatus')
        if m.get('delayMills') is not None:
            self.delay_mills = m.get('delayMills')
        if m.get('signalBizCodeCollection') is not None:
            self.signal_biz_code_collection = m.get('signalBizCodeCollection')
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class SkipClusterOperationTaskParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        operation_node_id: int = None,
        operation_task_id: int = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # operationTaskId
        self.operation_task_id = operation_task_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.operation_task_id is not None:
            result['operationTaskId'] = self.operation_task_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('operationTaskId') is not None:
            self.operation_task_id = m.get('operationTaskId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class SkipWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        activity_id_collection_required_skip: List[int] = None,
        workflow_instance_id: int = None,
    ):
        # ActivityIdCollectionRequiredSkip
        self.activity_id_collection_required_skip = activity_id_collection_required_skip
        # WorkflowInstanceId
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_id_collection_required_skip is not None:
            result['ActivityIdCollectionRequiredSkip'] = self.activity_id_collection_required_skip
        if self.workflow_instance_id is not None:
            result['WorkflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActivityIdCollectionRequiredSkip') is not None:
            self.activity_id_collection_required_skip = m.get('ActivityIdCollectionRequiredSkip')
        if m.get('WorkflowInstanceId') is not None:
            self.workflow_instance_id = m.get('WorkflowInstanceId')
        return self


class StringResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # data
        self.data = data
        # message
        self.message = message
        # requestId
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class SuspendWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class TerminateClusterOperationParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        operation_id: str = None,
        resource_owner_uid: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # operationId
        self.operation_id = operation_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class TerminateWorkflowInstanceParam(TeaModel):
    def __init__(
        self,
        workflow_instance_id: int = None,
    ):
        # 工作流实例Id
        self.workflow_instance_id = workflow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        return self


class UnRegisterClusterAckResourceParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        cluster_id: str = None,
        namespace: str = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # clusterId
        self.cluster_id = cluster_id
        # namespace
        self.namespace = namespace
        # operateUserId
        self.operate_user_id = operate_user_id
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class UpdateAckClusterNodePoolsParamAckNodePools(TeaModel):
    def __init__(
        self,
        node_pool_id: str = None,
        node_selector: NodeSelector = None,
    ):
        # nodePoolId
        self.node_pool_id = node_pool_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_pool_id is not None:
            result['nodePoolId'] = self.node_pool_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodePoolId') is not None:
            self.node_pool_id = m.get('nodePoolId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class UpdateAckClusterNodePoolsParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        ack_node_pools: List[UpdateAckClusterNodePoolsParamAckNodePools] = None,
        operate_user_id: str = None,
        product: str = None,
        product_role_name: str = None,
        product_selectors: NodeSelector = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # ackNodePools
        self.ack_node_pools = ack_node_pools
        # operateUserId
        self.operate_user_id = operate_user_id
        # product
        self.product = product
        # productRoleName
        self.product_role_name = product_role_name
        self.product_selectors = product_selectors
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.ack_node_pools:
            for k in self.ack_node_pools:
                if k:
                    k.validate()
        if self.product_selectors:
            self.product_selectors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        result['ackNodePools'] = []
        if self.ack_node_pools is not None:
            for k in self.ack_node_pools:
                result['ackNodePools'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product is not None:
            result['product'] = self.product
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.product_selectors is not None:
            result['productSelectors'] = self.product_selectors.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        self.ack_node_pools = []
        if m.get('ackNodePools') is not None:
            for k in m.get('ackNodePools'):
                temp_model = UpdateAckClusterNodePoolsParamAckNodePools()
                self.ack_node_pools.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('productSelectors') is not None:
            temp_model = NodeSelector()
            self.product_selectors = temp_model.from_map(m['productSelectors'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class UpdateAckClusterNodesParamAckNodes(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        node_selector: NodeSelector = None,
    ):
        # nodeId
        self.node_id = node_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class UpdateAckClusterNodesParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        ack_nodes: List[UpdateAckClusterNodesParamAckNodes] = None,
        operate_user_id: str = None,
        product_selectors: NodeSelector = None,
        resource_owner_uid: str = None,
        skipped_node_pools: List[str] = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # ackNodes
        self.ack_nodes = ack_nodes
        # operateUserId
        self.operate_user_id = operate_user_id
        self.product_selectors = product_selectors
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # skippedNodePools
        self.skipped_node_pools = skipped_node_pools

    def validate(self):
        if self.ack_nodes:
            for k in self.ack_nodes:
                if k:
                    k.validate()
        if self.product_selectors:
            self.product_selectors.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        result['ackNodes'] = []
        if self.ack_nodes is not None:
            for k in self.ack_nodes:
                result['ackNodes'].append(k.to_map() if k else None)
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_selectors is not None:
            result['productSelectors'] = self.product_selectors.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.skipped_node_pools is not None:
            result['skippedNodePools'] = self.skipped_node_pools
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        self.ack_nodes = []
        if m.get('ackNodes') is not None:
            for k in m.get('ackNodes'):
                temp_model = UpdateAckClusterNodesParamAckNodes()
                self.ack_nodes.append(temp_model.from_map(k))
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productSelectors') is not None:
            temp_model = NodeSelector()
            self.product_selectors = temp_model.from_map(m['productSelectors'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('skippedNodePools') is not None:
            self.skipped_node_pools = m.get('skippedNodePools')
        return self


class UpdateAutoRenewParam(TeaModel):
    def __init__(
        self,
        auto_renew: bool = None,
        instance_ids: List[str] = None,
        offset_days: int = None,
        operate_user_id: str = None,
        renew_duration: int = None,
        renew_duration_unit: str = None,
        resource_owner_uid: str = None,
        user_id: int = None,
    ):
        # 是否自动续费
        self.auto_renew = auto_renew
        # 机器ID
        self.instance_ids = instance_ids
        # 抵扣天数
        self.offset_days = offset_days
        # 操作用户
        self.operate_user_id = operate_user_id
        # 续费时长
        self.renew_duration = renew_duration
        # 续费时长单位
        self.renew_duration_unit = renew_duration_unit
        # 主账号
        self.resource_owner_uid = resource_owner_uid
        # 用户ID
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['autoRenew'] = self.auto_renew
        if self.instance_ids is not None:
            result['instanceIds'] = self.instance_ids
        if self.offset_days is not None:
            result['offsetDays'] = self.offset_days
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.renew_duration is not None:
            result['renewDuration'] = self.renew_duration
        if self.renew_duration_unit is not None:
            result['renewDurationUnit'] = self.renew_duration_unit
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoRenew') is not None:
            self.auto_renew = m.get('autoRenew')
        if m.get('instanceIds') is not None:
            self.instance_ids = m.get('instanceIds')
        if m.get('offsetDays') is not None:
            self.offset_days = m.get('offsetDays')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('renewDuration') is not None:
            self.renew_duration = m.get('renewDuration')
        if m.get('renewDurationUnit') is not None:
            self.renew_duration_unit = m.get('renewDurationUnit')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class UpdateAutoScalingPolicyParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_policy_id: str = None,
        scaling_rules: List[ScalingRule] = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # 弹性伸缩策略ID
        self.scaling_policy_id = scaling_policy_id
        # 弹性伸缩规则列表
        self.scaling_rules = scaling_rules

    def validate(self):
        if self.scaling_rules:
            for k in self.scaling_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        result['scalingRules'] = []
        if self.scaling_rules is not None:
            for k in self.scaling_rules:
                result['scalingRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        self.scaling_rules = []
        if m.get('scalingRules') is not None:
            for k in m.get('scalingRules'):
                temp_model = ScalingRule()
                self.scaling_rules.append(temp_model.from_map(k))
        return self


class UpdateAutoScalingRuleParam(TeaModel):
    def __init__(
        self,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        scaling_rule_id: str = None,
        scaling_rule_spec: ScalingRuleSpec = None,
    ):
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # scalingRuleId
        self.scaling_rule_id = scaling_rule_id
        # scalingRuleSpec
        self.scaling_rule_spec = scaling_rule_spec

    def validate(self):
        if self.scaling_rule_spec:
            self.scaling_rule_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.scaling_rule_id is not None:
            result['scalingRuleId'] = self.scaling_rule_id
        if self.scaling_rule_spec is not None:
            result['scalingRuleSpec'] = self.scaling_rule_spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scalingRuleId') is not None:
            self.scaling_rule_id = m.get('scalingRuleId')
        if m.get('scalingRuleSpec') is not None:
            temp_model = ScalingRuleSpec()
            self.scaling_rule_spec = temp_model.from_map(m['scalingRuleSpec'])
        return self


class UpdateClusterAttributeParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # clusterName
        self.cluster_name = cluster_name
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # token
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class UpdateClusterNodeGroupParam(TeaModel):
    def __init__(
        self,
        additional_security_group_ids: List[str] = None,
        cluster_id: str = None,
        cost_optimized_config: CostOptimizedConfig = None,
        data_disk_category: str = None,
        description: str = None,
        enable_decommission_gracefully: bool = None,
        fleet_id: str = None,
        image_id: str = None,
        instance_type_list: List[str] = None,
        max_size: int = None,
        min_size: int = None,
        node_group_id: str = None,
        node_name: str = None,
        node_resize_strategy: str = None,
        spot_instance_remedy: bool = None,
        system_disk_category: str = None,
        vsw_id_list: List[str] = None,
        with_public_ip: bool = None,
        zone_id: str = None,
    ):
        # securityGroupId
        self.additional_security_group_ids = additional_security_group_ids
        # clusterId
        self.cluster_id = cluster_id
        self.cost_optimized_config = cost_optimized_config
        # dataDiskCategory
        self.data_disk_category = data_disk_category
        # description
        self.description = description
        # enableDecommissionGracefully
        self.enable_decommission_gracefully = enable_decommission_gracefully
        # fleetId
        self.fleet_id = fleet_id
        # imageId
        self.image_id = image_id
        # instanceTypeList
        self.instance_type_list = instance_type_list
        # maxSize
        self.max_size = max_size
        # minSize
        self.min_size = min_size
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeName
        self.node_name = node_name
        # nodeResizeStrategy
        self.node_resize_strategy = node_resize_strategy
        # spotInstanceRemedy
        self.spot_instance_remedy = spot_instance_remedy
        # systemDiskCategory
        self.system_disk_category = system_disk_category
        # vswIdList
        self.vsw_id_list = vsw_id_list
        # withPublicIp
        self.with_public_ip = with_public_ip
        # zoneId
        self.zone_id = zone_id

    def validate(self):
        if self.cost_optimized_config:
            self.cost_optimized_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_security_group_ids is not None:
            result['additionalSecurityGroupIds'] = self.additional_security_group_ids
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cost_optimized_config is not None:
            result['costOptimizedConfig'] = self.cost_optimized_config.to_map()
        if self.data_disk_category is not None:
            result['dataDiskCategory'] = self.data_disk_category
        if self.description is not None:
            result['description'] = self.description
        if self.enable_decommission_gracefully is not None:
            result['enableDecommissionGracefully'] = self.enable_decommission_gracefully
        if self.fleet_id is not None:
            result['fleetId'] = self.fleet_id
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.instance_type_list is not None:
            result['instanceTypeList'] = self.instance_type_list
        if self.max_size is not None:
            result['maxSize'] = self.max_size
        if self.min_size is not None:
            result['minSize'] = self.min_size
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.node_resize_strategy is not None:
            result['nodeResizeStrategy'] = self.node_resize_strategy
        if self.spot_instance_remedy is not None:
            result['spotInstanceRemedy'] = self.spot_instance_remedy
        if self.system_disk_category is not None:
            result['systemDiskCategory'] = self.system_disk_category
        if self.vsw_id_list is not None:
            result['vswIdList'] = self.vsw_id_list
        if self.with_public_ip is not None:
            result['withPublicIp'] = self.with_public_ip
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('additionalSecurityGroupIds') is not None:
            self.additional_security_group_ids = m.get('additionalSecurityGroupIds')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('costOptimizedConfig') is not None:
            temp_model = CostOptimizedConfig()
            self.cost_optimized_config = temp_model.from_map(m['costOptimizedConfig'])
        if m.get('dataDiskCategory') is not None:
            self.data_disk_category = m.get('dataDiskCategory')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableDecommissionGracefully') is not None:
            self.enable_decommission_gracefully = m.get('enableDecommissionGracefully')
        if m.get('fleetId') is not None:
            self.fleet_id = m.get('fleetId')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('instanceTypeList') is not None:
            self.instance_type_list = m.get('instanceTypeList')
        if m.get('maxSize') is not None:
            self.max_size = m.get('maxSize')
        if m.get('minSize') is not None:
            self.min_size = m.get('minSize')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('nodeResizeStrategy') is not None:
            self.node_resize_strategy = m.get('nodeResizeStrategy')
        if m.get('spotInstanceRemedy') is not None:
            self.spot_instance_remedy = m.get('spotInstanceRemedy')
        if m.get('systemDiskCategory') is not None:
            self.system_disk_category = m.get('systemDiskCategory')
        if m.get('vswIdList') is not None:
            self.vsw_id_list = m.get('vswIdList')
        if m.get('withPublicIp') is not None:
            self.with_public_ip = m.get('withPublicIp')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class UpdateClusterPaymentTypeParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_ids: List[str] = None,
        operate_user_id: str = None,
        payment_type: str = None,
        period: int = None,
        period_unit: str = None,
        promotion_option: PromotionOption = None,
        resource_owner_uid: str = None,
        target_expire_time_millis: int = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # nodeGroupId
        self.node_group_ids = node_group_ids
        # operateUserId
        self.operate_user_id = operate_user_id
        # paymentType
        self.payment_type = payment_type
        # period
        self.period = period
        # periodUnit
        self.period_unit = period_unit
        # promotionOption
        self.promotion_option = promotion_option
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # targetExpireTimeMillis
        self.target_expire_time_millis = target_expire_time_millis
        # token
        self.token = token

    def validate(self):
        if self.promotion_option:
            self.promotion_option.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_ids is not None:
            result['nodeGroupIds'] = self.node_group_ids
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.period is not None:
            result['period'] = self.period
        if self.period_unit is not None:
            result['periodUnit'] = self.period_unit
        if self.promotion_option is not None:
            result['promotionOption'] = self.promotion_option.to_map()
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.target_expire_time_millis is not None:
            result['targetExpireTimeMillis'] = self.target_expire_time_millis
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupIds') is not None:
            self.node_group_ids = m.get('nodeGroupIds')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('period') is not None:
            self.period = m.get('period')
        if m.get('periodUnit') is not None:
            self.period_unit = m.get('periodUnit')
        if m.get('promotionOption') is not None:
            temp_model = PromotionOption()
            self.promotion_option = temp_model.from_map(m['promotionOption'])
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('targetExpireTimeMillis') is not None:
            self.target_expire_time_millis = m.get('targetExpireTimeMillis')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class UpdateClusterScriptParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        script_args: str = None,
        script_content: str = None,
        script_content_spec: str = None,
        script_id: str = None,
        script_name: str = None,
        script_path: str = None,
        script_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # clusterScriptArgs
        self.script_args = script_args
        # clusterScriptContent
        self.script_content = script_content
        # clusterScriptContentSpec
        self.script_content_spec = script_content_spec
        # clusterScriptId
        self.script_id = script_id
        # clusterScriptName
        self.script_name = script_name
        # clusterScriptPath
        self.script_path = script_path
        # clusterScriptType
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.script_args is not None:
            result['scriptArgs'] = self.script_args
        if self.script_content is not None:
            result['scriptContent'] = self.script_content
        if self.script_content_spec is not None:
            result['scriptContentSpec'] = self.script_content_spec
        if self.script_id is not None:
            result['scriptId'] = self.script_id
        if self.script_name is not None:
            result['scriptName'] = self.script_name
        if self.script_path is not None:
            result['scriptPath'] = self.script_path
        if self.script_type is not None:
            result['scriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('scriptArgs') is not None:
            self.script_args = m.get('scriptArgs')
        if m.get('scriptContent') is not None:
            self.script_content = m.get('scriptContent')
        if m.get('scriptContentSpec') is not None:
            self.script_content_spec = m.get('scriptContentSpec')
        if m.get('scriptId') is not None:
            self.script_id = m.get('scriptId')
        if m.get('scriptName') is not None:
            self.script_name = m.get('scriptName')
        if m.get('scriptPath') is not None:
            self.script_path = m.get('scriptPath')
        if m.get('scriptType') is not None:
            self.script_type = m.get('scriptType')
        return self


class UpdateClusterUserParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        description: str = None,
        operate_user_id: str = None,
        password: str = None,
        resource_owner_uid: str = None,
        user_id: str = None,
        user_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # description
        self.description = description
        # operateUserId
        self.operate_user_id = operate_user_id
        # password
        self.password = password
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid
        # userId
        self.user_id = user_id
        # userType
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.password is not None:
            result['password'] = self.password
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class UpdateConfigParamConfigItemActions(TeaModel):
    def __init__(
        self,
        config_action: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_item_value: str = None,
        effective_actions: str = None,
        effective_type: str = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        # configAction
        self.config_action = config_action
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configItemValue
        self.config_item_value = config_item_value
        # effectiveActions
        self.effective_actions = effective_actions
        # effectiveType
        self.effective_type = effective_type
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_action is not None:
            result['configAction'] = self.config_action
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_value is not None:
            result['configItemValue'] = self.config_item_value
        if self.effective_actions is not None:
            result['effectiveActions'] = self.effective_actions
        if self.effective_type is not None:
            result['effectiveType'] = self.effective_type
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configAction') is not None:
            self.config_action = m.get('configAction')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemValue') is not None:
            self.config_item_value = m.get('configItemValue')
        if m.get('effectiveActions') is not None:
            self.effective_actions = m.get('effectiveActions')
        if m.get('effectiveType') is not None:
            self.effective_type = m.get('effectiveType')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class UpdateConfigParam(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        config_item_actions: List[UpdateConfigParamConfigItemActions] = None,
        description: str = None,
        dry_run: bool = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # clusterId
        self.cluster_id = cluster_id
        # configItemActions
        self.config_item_actions = config_item_actions
        # description
        self.description = description
        # dryRun
        self.dry_run = dry_run
        # operateUserId
        self.operate_user_id = operate_user_id
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.config_item_actions:
            for k in self.config_item_actions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        result['configItemActions'] = []
        if self.config_item_actions is not None:
            for k in self.config_item_actions:
                result['configItemActions'].append(k.to_map() if k else None)
        if self.description is not None:
            result['description'] = self.description
        if self.dry_run is not None:
            result['dryRun'] = self.dry_run
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        self.config_item_actions = []
        if m.get('configItemActions') is not None:
            for k in m.get('configItemActions'):
                temp_model = UpdateConfigParamConfigItemActions()
                self.config_item_actions.append(temp_model.from_map(k))
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('dryRun') is not None:
            self.dry_run = m.get('dryRun')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class UpdateConfigResultReactivelyChangedConfigs(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        config_action: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        config_item_value: str = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        # applicationName
        self.application_name = application_name
        # configAction
        self.config_action = config_action
        # configFileName
        self.config_file_name = config_file_name
        # configItemKey
        self.config_item_key = config_item_key
        # configItemValue
        self.config_item_value = config_item_value
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeId
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.config_action is not None:
            result['configAction'] = self.config_action
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_value is not None:
            result['configItemValue'] = self.config_item_value
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('configAction') is not None:
            self.config_action = m.get('configAction')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemValue') is not None:
            self.config_item_value = m.get('configItemValue')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class UpdateConfigResult(TeaModel):
    def __init__(
        self,
        config_version: str = None,
        reactively_changed_configs: List[UpdateConfigResultReactivelyChangedConfigs] = None,
    ):
        # configVersion
        self.config_version = config_version
        # reactivelyChangedConfigs
        self.reactively_changed_configs = reactively_changed_configs

    def validate(self):
        if self.reactively_changed_configs:
            for k in self.reactively_changed_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        result['reactivelyChangedConfigs'] = []
        if self.reactively_changed_configs is not None:
            for k in self.reactively_changed_configs:
                result['reactivelyChangedConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        self.reactively_changed_configs = []
        if m.get('reactivelyChangedConfigs') is not None:
            for k in m.get('reactivelyChangedConfigs'):
                temp_model = UpdateConfigResultReactivelyChangedConfigs()
                self.reactively_changed_configs.append(temp_model.from_map(k))
        return self


class UpdateOnKubeDedicatedNodePoolsParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        cluster_id: str = None,
        desire_dedicated_node_pools: List[str] = None,
        full_node_labels: List[KubeNodeLabelDTO] = None,
        node_label: KubeNodeLabelDTO = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # clusterId
        self.cluster_id = cluster_id
        # desireDedicatedNodePools
        self.desire_dedicated_node_pools = desire_dedicated_node_pools
        # fullNodeLabels
        self.full_node_labels = full_node_labels
        self.node_label = node_label
        # operateUserId
        self.operate_user_id = operate_user_id
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.full_node_labels:
            for k in self.full_node_labels:
                if k:
                    k.validate()
        if self.node_label:
            self.node_label.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.desire_dedicated_node_pools is not None:
            result['desireDedicatedNodePools'] = self.desire_dedicated_node_pools
        result['fullNodeLabels'] = []
        if self.full_node_labels is not None:
            for k in self.full_node_labels:
                result['fullNodeLabels'].append(k.to_map() if k else None)
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label.to_map()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('desireDedicatedNodePools') is not None:
            self.desire_dedicated_node_pools = m.get('desireDedicatedNodePools')
        self.full_node_labels = []
        if m.get('fullNodeLabels') is not None:
            for k in m.get('fullNodeLabels'):
                temp_model = KubeNodeLabelDTO()
                self.full_node_labels.append(temp_model.from_map(k))
        if m.get('nodeLabel') is not None:
            temp_model = KubeNodeLabelDTO()
            self.node_label = temp_model.from_map(m['nodeLabel'])
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class UpdateOnKubeDedicatedNodesParam(TeaModel):
    def __init__(
        self,
        ack_instance_id: str = None,
        cluster_id: str = None,
        desire_dedicated_node_pools: List[str] = None,
        desire_dedicated_nodes: List[str] = None,
        full_node_labels: List[KubeNodeLabelDTO] = None,
        node_label: KubeNodeLabelDTO = None,
        operate_user_id: str = None,
        product_role_name: str = None,
        resource_owner_uid: str = None,
    ):
        # ackInstanceId
        self.ack_instance_id = ack_instance_id
        # clusterId
        self.cluster_id = cluster_id
        # desireDedicatedNodePools
        self.desire_dedicated_node_pools = desire_dedicated_node_pools
        # desireDedicatedNodes
        self.desire_dedicated_nodes = desire_dedicated_nodes
        # fullNodeLabels
        self.full_node_labels = full_node_labels
        self.node_label = node_label
        # operateUserId
        self.operate_user_id = operate_user_id
        # productRoleName
        self.product_role_name = product_role_name
        # resourceOwnerUid
        self.resource_owner_uid = resource_owner_uid

    def validate(self):
        if self.full_node_labels:
            for k in self.full_node_labels:
                if k:
                    k.validate()
        if self.node_label:
            self.node_label.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.desire_dedicated_node_pools is not None:
            result['desireDedicatedNodePools'] = self.desire_dedicated_node_pools
        if self.desire_dedicated_nodes is not None:
            result['desireDedicatedNodes'] = self.desire_dedicated_nodes
        result['fullNodeLabels'] = []
        if self.full_node_labels is not None:
            for k in self.full_node_labels:
                result['fullNodeLabels'].append(k.to_map() if k else None)
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label.to_map()
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.product_role_name is not None:
            result['productRoleName'] = self.product_role_name
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('desireDedicatedNodePools') is not None:
            self.desire_dedicated_node_pools = m.get('desireDedicatedNodePools')
        if m.get('desireDedicatedNodes') is not None:
            self.desire_dedicated_nodes = m.get('desireDedicatedNodes')
        self.full_node_labels = []
        if m.get('fullNodeLabels') is not None:
            for k in m.get('fullNodeLabels'):
                temp_model = KubeNodeLabelDTO()
                self.full_node_labels.append(temp_model.from_map(k))
        if m.get('nodeLabel') is not None:
            temp_model = KubeNodeLabelDTO()
            self.node_label = temp_model.from_map(m['nodeLabel'])
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('productRoleName') is not None:
            self.product_role_name = m.get('productRoleName')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        return self


class UpdateSecurityModeParam(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operate_user_id: str = None,
        resource_owner_uid: str = None,
        security_mode: str = None,
    ):
        # 集群ID。
        self.cluster_id = cluster_id
        # 操作用户ID。
        self.operate_user_id = operate_user_id
        # 资源所有者ID。
        self.resource_owner_uid = resource_owner_uid
        # 安全模式。
        self.security_mode = security_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operate_user_id is not None:
            result['operateUserId'] = self.operate_user_id
        if self.resource_owner_uid is not None:
            result['resourceOwnerUid'] = self.resource_owner_uid
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operateUserId') is not None:
            self.operate_user_id = m.get('operateUserId')
        if m.get('resourceOwnerUid') is not None:
            self.resource_owner_uid = m.get('resourceOwnerUid')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        return self


class AddClusterApplicationRequest(TeaModel):
    def __init__(
        self,
        add_application_param: AddApplicationParam = None,
    ):
        self.add_application_param = add_application_param

    def validate(self):
        if self.add_application_param:
            self.add_application_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_application_param is not None:
            result['addApplicationParam'] = self.add_application_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addApplicationParam') is not None:
            temp_model = AddApplicationParam()
            self.add_application_param = temp_model.from_map(m['addApplicationParam'])
        return self


class AddClusterApplicationShrinkRequest(TeaModel):
    def __init__(
        self,
        add_application_param_shrink: str = None,
    ):
        self.add_application_param_shrink = add_application_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_application_param_shrink is not None:
            result['addApplicationParam'] = self.add_application_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addApplicationParam') is not None:
            self.add_application_param_shrink = m.get('addApplicationParam')
        return self


class AddClusterApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSuspendPointOnWorkflowInstanceRequest(TeaModel):
    def __init__(
        self,
        add_suspend_on_workflow_instance_param: AddSuspendPointOnWorkflowInstanceParam = None,
    ):
        # 添加暂停点参数
        self.add_suspend_on_workflow_instance_param = add_suspend_on_workflow_instance_param

    def validate(self):
        if self.add_suspend_on_workflow_instance_param:
            self.add_suspend_on_workflow_instance_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_suspend_on_workflow_instance_param is not None:
            result['addSuspendOnWorkflowInstanceParam'] = self.add_suspend_on_workflow_instance_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addSuspendOnWorkflowInstanceParam') is not None:
            temp_model = AddSuspendPointOnWorkflowInstanceParam()
            self.add_suspend_on_workflow_instance_param = temp_model.from_map(m['addSuspendOnWorkflowInstanceParam'])
        return self


class AddSuspendPointOnWorkflowInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        add_suspend_on_workflow_instance_param_shrink: str = None,
    ):
        # 添加暂停点参数
        self.add_suspend_on_workflow_instance_param_shrink = add_suspend_on_workflow_instance_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_suspend_on_workflow_instance_param_shrink is not None:
            result['addSuspendOnWorkflowInstanceParam'] = self.add_suspend_on_workflow_instance_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('addSuspendOnWorkflowInstanceParam') is not None:
            self.add_suspend_on_workflow_instance_param_shrink = m.get('addSuspendOnWorkflowInstanceParam')
        return self


class AddSuspendPointOnWorkflowInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelClusterOrdersRequest(TeaModel):
    def __init__(
        self,
        cancel_cluster_orders_param: CancelClusterOrdersParam = None,
    ):
        # cancelClusterOrdersParam
        self.cancel_cluster_orders_param = cancel_cluster_orders_param

    def validate(self):
        if self.cancel_cluster_orders_param:
            self.cancel_cluster_orders_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_cluster_orders_param is not None:
            result['cancelClusterOrdersParam'] = self.cancel_cluster_orders_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cancelClusterOrdersParam') is not None:
            temp_model = CancelClusterOrdersParam()
            self.cancel_cluster_orders_param = temp_model.from_map(m['cancelClusterOrdersParam'])
        return self


class CancelClusterOrdersShrinkRequest(TeaModel):
    def __init__(
        self,
        cancel_cluster_orders_param_shrink: str = None,
    ):
        # cancelClusterOrdersParam
        self.cancel_cluster_orders_param_shrink = cancel_cluster_orders_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_cluster_orders_param_shrink is not None:
            result['cancelClusterOrdersParam'] = self.cancel_cluster_orders_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cancelClusterOrdersParam') is not None:
            self.cancel_cluster_orders_param_shrink = m.get('cancelClusterOrdersParam')
        return self


class CancelClusterOrdersResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[str] = None,
    ):
        self.items = items

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = self.items
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = m.get('items')
        return self


class CancelClusterOrdersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CancelClusterOrdersResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CancelClusterOrdersResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CancelClusterOrdersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelClusterOrdersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelClusterOrdersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ComAlibabaTccResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ComAlibabaTccResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ComAlibabaTccResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ComAlibabaTccResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoScalingPolicyRequest(TeaModel):
    def __init__(
        self,
        create_auto_scaling_policy_param: CreateAutoScalingPolicyParam = None,
    ):
        # createAutoScalingPolicyParam
        self.create_auto_scaling_policy_param = create_auto_scaling_policy_param

    def validate(self):
        if self.create_auto_scaling_policy_param:
            self.create_auto_scaling_policy_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_auto_scaling_policy_param is not None:
            result['createAutoScalingPolicyParam'] = self.create_auto_scaling_policy_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createAutoScalingPolicyParam') is not None:
            temp_model = CreateAutoScalingPolicyParam()
            self.create_auto_scaling_policy_param = temp_model.from_map(m['createAutoScalingPolicyParam'])
        return self


class CreateAutoScalingPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        create_auto_scaling_policy_param_shrink: str = None,
    ):
        # createAutoScalingPolicyParam
        self.create_auto_scaling_policy_param_shrink = create_auto_scaling_policy_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_auto_scaling_policy_param_shrink is not None:
            result['createAutoScalingPolicyParam'] = self.create_auto_scaling_policy_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createAutoScalingPolicyParam') is not None:
            self.create_auto_scaling_policy_param_shrink = m.get('createAutoScalingPolicyParam')
        return self


class CreateAutoScalingPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoScalingRuleRequest(TeaModel):
    def __init__(
        self,
        create_auto_scaling_rule_param: CreateAutoScalingRuleParam = None,
    ):
        # createAutoScalingRuleParam
        self.create_auto_scaling_rule_param = create_auto_scaling_rule_param

    def validate(self):
        if self.create_auto_scaling_rule_param:
            self.create_auto_scaling_rule_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_auto_scaling_rule_param is not None:
            result['createAutoScalingRuleParam'] = self.create_auto_scaling_rule_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createAutoScalingRuleParam') is not None:
            temp_model = CreateAutoScalingRuleParam()
            self.create_auto_scaling_rule_param = temp_model.from_map(m['createAutoScalingRuleParam'])
        return self


class CreateAutoScalingRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        create_auto_scaling_rule_param_shrink: str = None,
    ):
        # createAutoScalingRuleParam
        self.create_auto_scaling_rule_param_shrink = create_auto_scaling_rule_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_auto_scaling_rule_param_shrink is not None:
            result['createAutoScalingRuleParam'] = self.create_auto_scaling_rule_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createAutoScalingRuleParam') is not None:
            self.create_auto_scaling_rule_param_shrink = m.get('createAutoScalingRuleParam')
        return self


class CreateAutoScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBindingAckClusterRequest(TeaModel):
    def __init__(
        self,
        create_binding_ack_cluster_param: CreateBindingAckClusterParam = None,
    ):
        # createBindingAckClusterParam
        self.create_binding_ack_cluster_param = create_binding_ack_cluster_param

    def validate(self):
        if self.create_binding_ack_cluster_param:
            self.create_binding_ack_cluster_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_binding_ack_cluster_param is not None:
            result['createBindingAckClusterParam'] = self.create_binding_ack_cluster_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createBindingAckClusterParam') is not None:
            temp_model = CreateBindingAckClusterParam()
            self.create_binding_ack_cluster_param = temp_model.from_map(m['createBindingAckClusterParam'])
        return self


class CreateBindingAckClusterShrinkRequest(TeaModel):
    def __init__(
        self,
        create_binding_ack_cluster_param_shrink: str = None,
    ):
        # createBindingAckClusterParam
        self.create_binding_ack_cluster_param_shrink = create_binding_ack_cluster_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_binding_ack_cluster_param_shrink is not None:
            result['createBindingAckClusterParam'] = self.create_binding_ack_cluster_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createBindingAckClusterParam') is not None:
            self.create_binding_ack_cluster_param_shrink = m.get('createBindingAckClusterParam')
        return self


class CreateBindingAckClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterRequest(TeaModel):
    def __init__(
        self,
        create_cluster_param: CreateClusterParam = None,
    ):
        self.create_cluster_param = create_cluster_param

    def validate(self):
        if self.create_cluster_param:
            self.create_cluster_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_param is not None:
            result['createClusterParam'] = self.create_cluster_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterParam') is not None:
            temp_model = CreateClusterParam()
            self.create_cluster_param = temp_model.from_map(m['createClusterParam'])
        return self


class CreateClusterShrinkRequest(TeaModel):
    def __init__(
        self,
        create_cluster_param_shrink: str = None,
    ):
        self.create_cluster_param_shrink = create_cluster_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_param_shrink is not None:
            result['createClusterParam'] = self.create_cluster_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterParam') is not None:
            self.create_cluster_param_shrink = m.get('createClusterParam')
        return self


class CreateClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterNodeGroupRequest(TeaModel):
    def __init__(
        self,
        create_cluster_node_group_param: CreateClusterNodeGroupParam = None,
    ):
        self.create_cluster_node_group_param = create_cluster_node_group_param

    def validate(self):
        if self.create_cluster_node_group_param:
            self.create_cluster_node_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_node_group_param is not None:
            result['createClusterNodeGroupParam'] = self.create_cluster_node_group_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterNodeGroupParam') is not None:
            temp_model = CreateClusterNodeGroupParam()
            self.create_cluster_node_group_param = temp_model.from_map(m['createClusterNodeGroupParam'])
        return self


class CreateClusterNodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # data
        self.data = data
        # Id of the request
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateClusterNodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterNodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterNodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterScriptRequest(TeaModel):
    def __init__(
        self,
        create_cluster_script_param: CreateClusterScriptParam = None,
    ):
        # createClusterScriptParam
        self.create_cluster_script_param = create_cluster_script_param

    def validate(self):
        if self.create_cluster_script_param:
            self.create_cluster_script_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_script_param is not None:
            result['createClusterScriptParam'] = self.create_cluster_script_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterScriptParam') is not None:
            temp_model = CreateClusterScriptParam()
            self.create_cluster_script_param = temp_model.from_map(m['createClusterScriptParam'])
        return self


class CreateClusterScriptShrinkRequest(TeaModel):
    def __init__(
        self,
        create_cluster_script_param_shrink: str = None,
    ):
        # createClusterScriptParam
        self.create_cluster_script_param_shrink = create_cluster_script_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_script_param_shrink is not None:
            result['createClusterScriptParam'] = self.create_cluster_script_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterScriptParam') is not None:
            self.create_cluster_script_param_shrink = m.get('createClusterScriptParam')
        return self


class CreateClusterScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterUserRequest(TeaModel):
    def __init__(
        self,
        create_cluster_user_param: CreateClusterUserParam = None,
    ):
        self.create_cluster_user_param = create_cluster_user_param

    def validate(self):
        if self.create_cluster_user_param:
            self.create_cluster_user_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_user_param is not None:
            result['createClusterUserParam'] = self.create_cluster_user_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterUserParam') is not None:
            temp_model = CreateClusterUserParam()
            self.create_cluster_user_param = temp_model.from_map(m['createClusterUserParam'])
        return self


class CreateClusterUserShrinkRequest(TeaModel):
    def __init__(
        self,
        create_cluster_user_param_shrink: str = None,
    ):
        self.create_cluster_user_param_shrink = create_cluster_user_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_cluster_user_param_shrink is not None:
            result['createClusterUserParam'] = self.create_cluster_user_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createClusterUserParam') is not None:
            self.create_cluster_user_param_shrink = m.get('createClusterUserParam')
        return self


class CreateClusterUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateClusterUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFullClusterRequest(TeaModel):
    def __init__(
        self,
        create_full_cluster_param: CreateFullClusterParam = None,
    ):
        self.create_full_cluster_param = create_full_cluster_param

    def validate(self):
        if self.create_full_cluster_param:
            self.create_full_cluster_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_full_cluster_param is not None:
            result['createFullClusterParam'] = self.create_full_cluster_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createFullClusterParam') is not None:
            temp_model = CreateFullClusterParam()
            self.create_full_cluster_param = temp_model.from_map(m['createFullClusterParam'])
        return self


class CreateFullClusterShrinkRequest(TeaModel):
    def __init__(
        self,
        create_full_cluster_param_shrink: str = None,
    ):
        self.create_full_cluster_param_shrink = create_full_cluster_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_full_cluster_param_shrink is not None:
            result['createFullClusterParam'] = self.create_full_cluster_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createFullClusterParam') is not None:
            self.create_full_cluster_param_shrink = m.get('createFullClusterParam')
        return self


class CreateFullClusterResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operation_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.operation_id = operation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        return self


class CreateFullClusterResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateFullClusterResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CreateFullClusterResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateFullClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFullClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFullClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFullClusterByMainVersionRequest(TeaModel):
    def __init__(
        self,
        create_full_cluster_by_main_version_param: CreateFullClusterByMainVersionParam = None,
    ):
        self.create_full_cluster_by_main_version_param = create_full_cluster_by_main_version_param

    def validate(self):
        if self.create_full_cluster_by_main_version_param:
            self.create_full_cluster_by_main_version_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_full_cluster_by_main_version_param is not None:
            result['createFullClusterByMainVersionParam'] = self.create_full_cluster_by_main_version_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createFullClusterByMainVersionParam') is not None:
            temp_model = CreateFullClusterByMainVersionParam()
            self.create_full_cluster_by_main_version_param = temp_model.from_map(m['createFullClusterByMainVersionParam'])
        return self


class CreateFullClusterByMainVersionShrinkRequest(TeaModel):
    def __init__(
        self,
        create_full_cluster_by_main_version_param_shrink: str = None,
    ):
        self.create_full_cluster_by_main_version_param_shrink = create_full_cluster_by_main_version_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_full_cluster_by_main_version_param_shrink is not None:
            result['createFullClusterByMainVersionParam'] = self.create_full_cluster_by_main_version_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createFullClusterByMainVersionParam') is not None:
            self.create_full_cluster_by_main_version_param_shrink = m.get('createFullClusterByMainVersionParam')
        return self


class CreateFullClusterByMainVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operation_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.operation_id = operation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        return self


class CreateFullClusterByMainVersionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateFullClusterByMainVersionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CreateFullClusterByMainVersionResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateFullClusterByMainVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFullClusterByMainVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFullClusterByMainVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMainVersionRequest(TeaModel):
    def __init__(
        self,
        create_main_version_param: CreateMainVersionParam = None,
    ):
        # CreateMainVersionParam
        self.create_main_version_param = create_main_version_param

    def validate(self):
        if self.create_main_version_param:
            self.create_main_version_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_main_version_param is not None:
            result['CreateMainVersionParam'] = self.create_main_version_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateMainVersionParam') is not None:
            temp_model = CreateMainVersionParam()
            self.create_main_version_param = temp_model.from_map(m['CreateMainVersionParam'])
        return self


class CreateMainVersionShrinkRequest(TeaModel):
    def __init__(
        self,
        create_main_version_param_shrink: str = None,
    ):
        # CreateMainVersionParam
        self.create_main_version_param_shrink = create_main_version_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_main_version_param_shrink is not None:
            result['CreateMainVersionParam'] = self.create_main_version_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateMainVersionParam') is not None:
            self.create_main_version_param_shrink = m.get('CreateMainVersionParam')
        return self


class CreateMainVersionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateMainVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMainVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMainVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStackApplicationRequest(TeaModel):
    def __init__(
        self,
        create_stack_application_param: CreateStackApplicationParam = None,
    ):
        # createApplicationParam
        self.create_stack_application_param = create_stack_application_param

    def validate(self):
        if self.create_stack_application_param:
            self.create_stack_application_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_stack_application_param is not None:
            result['createStackApplicationParam'] = self.create_stack_application_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createStackApplicationParam') is not None:
            temp_model = CreateStackApplicationParam()
            self.create_stack_application_param = temp_model.from_map(m['createStackApplicationParam'])
        return self


class CreateStackApplicationShrinkRequest(TeaModel):
    def __init__(
        self,
        create_stack_application_param_shrink: str = None,
    ):
        # createApplicationParam
        self.create_stack_application_param_shrink = create_stack_application_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_stack_application_param_shrink is not None:
            result['createStackApplicationParam'] = self.create_stack_application_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createStackApplicationParam') is not None:
            self.create_stack_application_param_shrink = m.get('createStackApplicationParam')
        return self


class CreateStackApplicationResponseBodyDataApplicationSpec(TeaModel):
    def __init__(
        self,
        iaas_type: str = None,
        name: str = None,
        version: str = None,
    ):
        self.iaas_type = iaas_type
        self.name = name
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class CreateStackApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        application_spec: CreateStackApplicationResponseBodyDataApplicationSpec = None,
        create_time: int = None,
    ):
        self.application_spec = application_spec
        self.create_time = create_time

    def validate(self):
        if self.application_spec:
            self.application_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_spec is not None:
            result['applicationSpec'] = self.application_spec.to_map()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationSpec') is not None:
            temp_model = CreateStackApplicationResponseBodyDataApplicationSpec()
            self.application_spec = temp_model.from_map(m['applicationSpec'])
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class CreateStackApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateStackApplicationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CreateStackApplicationResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateStackApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateStackApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateStackApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecreaseNodeGroupRequest(TeaModel):
    def __init__(
        self,
        decrease_node_group_param: DecreaseNodeGroupParam = None,
    ):
        # DecreaseNodeGroupParam
        self.decrease_node_group_param = decrease_node_group_param

    def validate(self):
        if self.decrease_node_group_param:
            self.decrease_node_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decrease_node_group_param is not None:
            result['DecreaseNodeGroupParam'] = self.decrease_node_group_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DecreaseNodeGroupParam') is not None:
            temp_model = DecreaseNodeGroupParam()
            self.decrease_node_group_param = temp_model.from_map(m['DecreaseNodeGroupParam'])
        return self


class DecreaseNodeGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        decrease_node_group_param_shrink: str = None,
    ):
        # DecreaseNodeGroupParam
        self.decrease_node_group_param_shrink = decrease_node_group_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.decrease_node_group_param_shrink is not None:
            result['DecreaseNodeGroupParam'] = self.decrease_node_group_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DecreaseNodeGroupParam') is not None:
            self.decrease_node_group_param_shrink = m.get('DecreaseNodeGroupParam')
        return self


class DecreaseNodeGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operation_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operationId
        self.operation_id = operation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        return self


class DecreaseNodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        data: DecreaseNodeGroupResponseBodyData = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # requestId
        self.request_id = request_id
        # data
        self.data = data
        # success
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('data') is not None:
            temp_model = DecreaseNodeGroupResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DecreaseNodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DecreaseNodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DecreaseNodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoScalingPolicyRequest(TeaModel):
    def __init__(
        self,
        delete_auto_scaling_policy_param: DeleteAutoScalingPolicyParam = None,
    ):
        # deleteAutoScalingPolicyParam
        self.delete_auto_scaling_policy_param = delete_auto_scaling_policy_param

    def validate(self):
        if self.delete_auto_scaling_policy_param:
            self.delete_auto_scaling_policy_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_auto_scaling_policy_param is not None:
            result['deleteAutoScalingPolicyParam'] = self.delete_auto_scaling_policy_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteAutoScalingPolicyParam') is not None:
            temp_model = DeleteAutoScalingPolicyParam()
            self.delete_auto_scaling_policy_param = temp_model.from_map(m['deleteAutoScalingPolicyParam'])
        return self


class DeleteAutoScalingPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_auto_scaling_policy_param_shrink: str = None,
    ):
        # deleteAutoScalingPolicyParam
        self.delete_auto_scaling_policy_param_shrink = delete_auto_scaling_policy_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_auto_scaling_policy_param_shrink is not None:
            result['deleteAutoScalingPolicyParam'] = self.delete_auto_scaling_policy_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteAutoScalingPolicyParam') is not None:
            self.delete_auto_scaling_policy_param_shrink = m.get('deleteAutoScalingPolicyParam')
        return self


class DeleteAutoScalingPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoScalingRuleRequest(TeaModel):
    def __init__(
        self,
        delete_auto_scaling_rule_param: DeleteAutoScalingRuleParam = None,
    ):
        # deleteAutoScalingRuleParam
        self.delete_auto_scaling_rule_param = delete_auto_scaling_rule_param

    def validate(self):
        if self.delete_auto_scaling_rule_param:
            self.delete_auto_scaling_rule_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_auto_scaling_rule_param is not None:
            result['deleteAutoScalingRuleParam'] = self.delete_auto_scaling_rule_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteAutoScalingRuleParam') is not None:
            temp_model = DeleteAutoScalingRuleParam()
            self.delete_auto_scaling_rule_param = temp_model.from_map(m['deleteAutoScalingRuleParam'])
        return self


class DeleteAutoScalingRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_auto_scaling_rule_param_shrink: str = None,
    ):
        # deleteAutoScalingRuleParam
        self.delete_auto_scaling_rule_param_shrink = delete_auto_scaling_rule_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_auto_scaling_rule_param_shrink is not None:
            result['deleteAutoScalingRuleParam'] = self.delete_auto_scaling_rule_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteAutoScalingRuleParam') is not None:
            self.delete_auto_scaling_rule_param_shrink = m.get('deleteAutoScalingRuleParam')
        return self


class DeleteAutoScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterNodeGroupRequest(TeaModel):
    def __init__(
        self,
        delete_node_group_param: DeleteNodeGroupParam = None,
    ):
        # deleteClusterNodeGroupParam
        self.delete_node_group_param = delete_node_group_param

    def validate(self):
        if self.delete_node_group_param:
            self.delete_node_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_node_group_param is not None:
            result['deleteNodeGroupParam'] = self.delete_node_group_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteNodeGroupParam') is not None:
            temp_model = DeleteNodeGroupParam()
            self.delete_node_group_param = temp_model.from_map(m['deleteNodeGroupParam'])
        return self


class DeleteClusterNodeGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_node_group_param_shrink: str = None,
    ):
        # deleteClusterNodeGroupParam
        self.delete_node_group_param_shrink = delete_node_group_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_node_group_param_shrink is not None:
            result['deleteNodeGroupParam'] = self.delete_node_group_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteNodeGroupParam') is not None:
            self.delete_node_group_param_shrink = m.get('deleteNodeGroupParam')
        return self


class DeleteClusterNodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        data: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # Id of the request
        self.request_id = request_id
        # data
        self.data = data
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteClusterNodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteClusterNodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClusterNodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterScriptRequest(TeaModel):
    def __init__(
        self,
        delete_cluster_script_param: DeleteClusterScriptParam = None,
    ):
        # deleteClusterScriptParam
        self.delete_cluster_script_param = delete_cluster_script_param

    def validate(self):
        if self.delete_cluster_script_param:
            self.delete_cluster_script_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cluster_script_param is not None:
            result['deleteClusterScriptParam'] = self.delete_cluster_script_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteClusterScriptParam') is not None:
            temp_model = DeleteClusterScriptParam()
            self.delete_cluster_script_param = temp_model.from_map(m['deleteClusterScriptParam'])
        return self


class DeleteClusterScriptShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_cluster_script_param_shrink: str = None,
    ):
        # deleteClusterScriptParam
        self.delete_cluster_script_param_shrink = delete_cluster_script_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cluster_script_param_shrink is not None:
            result['deleteClusterScriptParam'] = self.delete_cluster_script_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteClusterScriptParam') is not None:
            self.delete_cluster_script_param_shrink = m.get('deleteClusterScriptParam')
        return self


class DeleteClusterScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterUserRequest(TeaModel):
    def __init__(
        self,
        delete_cluster_user_param: DeleteClusterUserParam = None,
    ):
        self.delete_cluster_user_param = delete_cluster_user_param

    def validate(self):
        if self.delete_cluster_user_param:
            self.delete_cluster_user_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cluster_user_param is not None:
            result['deleteClusterUserParam'] = self.delete_cluster_user_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteClusterUserParam') is not None:
            temp_model = DeleteClusterUserParam()
            self.delete_cluster_user_param = temp_model.from_map(m['deleteClusterUserParam'])
        return self


class DeleteClusterUserShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_cluster_user_param_shrink: str = None,
    ):
        self.delete_cluster_user_param_shrink = delete_cluster_user_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_cluster_user_param_shrink is not None:
            result['deleteClusterUserParam'] = self.delete_cluster_user_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteClusterUserParam') is not None:
            self.delete_cluster_user_param_shrink = m.get('deleteClusterUserParam')
        return self


class DeleteClusterUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteClusterUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteClusterUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClusterUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKubeCustomerResourceRequest(TeaModel):
    def __init__(
        self,
        delete_kube_customer_resources_param: DeleteKubeCustomerResourcesParam = None,
    ):
        # deleteKubeCustomerResourcesParam
        self.delete_kube_customer_resources_param = delete_kube_customer_resources_param

    def validate(self):
        if self.delete_kube_customer_resources_param:
            self.delete_kube_customer_resources_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_kube_customer_resources_param is not None:
            result['deleteKubeCustomerResourcesParam'] = self.delete_kube_customer_resources_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteKubeCustomerResourcesParam') is not None:
            temp_model = DeleteKubeCustomerResourcesParam()
            self.delete_kube_customer_resources_param = temp_model.from_map(m['deleteKubeCustomerResourcesParam'])
        return self


class DeleteKubeCustomerResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_kube_customer_resources_param_shrink: str = None,
    ):
        # deleteKubeCustomerResourcesParam
        self.delete_kube_customer_resources_param_shrink = delete_kube_customer_resources_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_kube_customer_resources_param_shrink is not None:
            result['deleteKubeCustomerResourcesParam'] = self.delete_kube_customer_resources_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteKubeCustomerResourcesParam') is not None:
            self.delete_kube_customer_resources_param_shrink = m.get('deleteKubeCustomerResourcesParam')
        return self


class DeleteKubeCustomerResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKubeNativeResourcesRequest(TeaModel):
    def __init__(
        self,
        delete_kube_native_resources_param: DeleteKubeNativeResourcesParam = None,
    ):
        # deleteKubeNativeResourcesParam
        self.delete_kube_native_resources_param = delete_kube_native_resources_param

    def validate(self):
        if self.delete_kube_native_resources_param:
            self.delete_kube_native_resources_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_kube_native_resources_param is not None:
            result['deleteKubeNativeResourcesParam'] = self.delete_kube_native_resources_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteKubeNativeResourcesParam') is not None:
            temp_model = DeleteKubeNativeResourcesParam()
            self.delete_kube_native_resources_param = temp_model.from_map(m['deleteKubeNativeResourcesParam'])
        return self


class DeleteKubeNativeResourcesShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_kube_native_resources_param_shrink: str = None,
    ):
        # deleteKubeNativeResourcesParam
        self.delete_kube_native_resources_param_shrink = delete_kube_native_resources_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_kube_native_resources_param_shrink is not None:
            result['deleteKubeNativeResourcesParam'] = self.delete_kube_native_resources_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteKubeNativeResourcesParam') is not None:
            self.delete_kube_native_resources_param_shrink = m.get('deleteKubeNativeResourcesParam')
        return self


class DeleteKubeNativeResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStackApplicationRequest(TeaModel):
    def __init__(
        self,
        delete_stack_application_param: DeleteStackApplicationParam = None,
    ):
        self.delete_stack_application_param = delete_stack_application_param

    def validate(self):
        if self.delete_stack_application_param:
            self.delete_stack_application_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_stack_application_param is not None:
            result['deleteStackApplicationParam'] = self.delete_stack_application_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteStackApplicationParam') is not None:
            temp_model = DeleteStackApplicationParam()
            self.delete_stack_application_param = temp_model.from_map(m['deleteStackApplicationParam'])
        return self


class DeleteStackApplicationShrinkRequest(TeaModel):
    def __init__(
        self,
        delete_stack_application_param_shrink: str = None,
    ):
        self.delete_stack_application_param_shrink = delete_stack_application_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_stack_application_param_shrink is not None:
            result['deleteStackApplicationParam'] = self.delete_stack_application_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deleteStackApplicationParam') is not None:
            self.delete_stack_application_param_shrink = m.get('deleteStackApplicationParam')
        return self


class DeleteStackApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteStackApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteStackApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStackApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployApplicationsRequest(TeaModel):
    def __init__(
        self,
        deploy_application_param: DeployApplicationParam = None,
    ):
        # deployApplicationParam
        self.deploy_application_param = deploy_application_param

    def validate(self):
        if self.deploy_application_param:
            self.deploy_application_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_application_param is not None:
            result['deployApplicationParam'] = self.deploy_application_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployApplicationParam') is not None:
            temp_model = DeployApplicationParam()
            self.deploy_application_param = temp_model.from_map(m['deployApplicationParam'])
        return self


class DeployApplicationsShrinkRequest(TeaModel):
    def __init__(
        self,
        deploy_application_param_shrink: str = None,
    ):
        # deployApplicationParam
        self.deploy_application_param_shrink = deploy_application_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deploy_application_param_shrink is not None:
            result['deployApplicationParam'] = self.deploy_application_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deployApplicationParam') is not None:
            self.deploy_application_param_shrink = m.get('deployApplicationParam')
        return self


class DeployApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableAutoScalingPolicyRequest(TeaModel):
    def __init__(
        self,
        disable_auto_scaling_policy_param: DisableAutoScalingPolicyParam = None,
    ):
        # disableAutoScalingPolicyParam
        self.disable_auto_scaling_policy_param = disable_auto_scaling_policy_param

    def validate(self):
        if self.disable_auto_scaling_policy_param:
            self.disable_auto_scaling_policy_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_auto_scaling_policy_param is not None:
            result['disableAutoScalingPolicyParam'] = self.disable_auto_scaling_policy_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disableAutoScalingPolicyParam') is not None:
            temp_model = DisableAutoScalingPolicyParam()
            self.disable_auto_scaling_policy_param = temp_model.from_map(m['disableAutoScalingPolicyParam'])
        return self


class DisableAutoScalingPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        disable_auto_scaling_policy_param_shrink: str = None,
    ):
        # disableAutoScalingPolicyParam
        self.disable_auto_scaling_policy_param_shrink = disable_auto_scaling_policy_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_auto_scaling_policy_param_shrink is not None:
            result['disableAutoScalingPolicyParam'] = self.disable_auto_scaling_policy_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disableAutoScalingPolicyParam') is not None:
            self.disable_auto_scaling_policy_param_shrink = m.get('disableAutoScalingPolicyParam')
        return self


class DisableAutoScalingPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableAutoScalingPolicyRequest(TeaModel):
    def __init__(
        self,
        enable_auto_scaling_policy_param: EnableAutoScalingPolicyParam = None,
    ):
        # enableAutoScalingPolicyParam
        self.enable_auto_scaling_policy_param = enable_auto_scaling_policy_param

    def validate(self):
        if self.enable_auto_scaling_policy_param:
            self.enable_auto_scaling_policy_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_auto_scaling_policy_param is not None:
            result['enableAutoScalingPolicyParam'] = self.enable_auto_scaling_policy_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableAutoScalingPolicyParam') is not None:
            temp_model = EnableAutoScalingPolicyParam()
            self.enable_auto_scaling_policy_param = temp_model.from_map(m['enableAutoScalingPolicyParam'])
        return self


class EnableAutoScalingPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        enable_auto_scaling_policy_param_shrink: str = None,
    ):
        # enableAutoScalingPolicyParam
        self.enable_auto_scaling_policy_param_shrink = enable_auto_scaling_policy_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_auto_scaling_policy_param_shrink is not None:
            result['enableAutoScalingPolicyParam'] = self.enable_auto_scaling_policy_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableAutoScalingPolicyParam') is not None:
            self.enable_auto_scaling_policy_param_shrink = m.get('enableAutoScalingPolicyParam')
        return self


class EnableAutoScalingPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class ExecuteClusterScriptRequest(TeaModel):
    def __init__(
        self,
        execute_cluster_script_param: ExecuteClusterScriptParam = None,
    ):
        # executeClusterScriptParam
        self.execute_cluster_script_param = execute_cluster_script_param

    def validate(self):
        if self.execute_cluster_script_param:
            self.execute_cluster_script_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execute_cluster_script_param is not None:
            result['executeClusterScriptParam'] = self.execute_cluster_script_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executeClusterScriptParam') is not None:
            temp_model = ExecuteClusterScriptParam()
            self.execute_cluster_script_param = temp_model.from_map(m['executeClusterScriptParam'])
        return self


class ExecuteClusterScriptShrinkRequest(TeaModel):
    def __init__(
        self,
        execute_cluster_script_param_shrink: str = None,
    ):
        # executeClusterScriptParam
        self.execute_cluster_script_param_shrink = execute_cluster_script_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execute_cluster_script_param_shrink is not None:
            result['executeClusterScriptParam'] = self.execute_cluster_script_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('executeClusterScriptParam') is not None:
            self.execute_cluster_script_param_shrink = m.get('executeClusterScriptParam')
        return self


class ExecuteClusterScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationActionsRequest(TeaModel):
    def __init__(
        self,
        get_application_actions_param: GetApplicationActionsParam = None,
    ):
        # getApplicationActionsParam
        self.get_application_actions_param = get_application_actions_param

    def validate(self):
        if self.get_application_actions_param:
            self.get_application_actions_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_application_actions_param is not None:
            result['getApplicationActionsParam'] = self.get_application_actions_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getApplicationActionsParam') is not None:
            temp_model = GetApplicationActionsParam()
            self.get_application_actions_param = temp_model.from_map(m['getApplicationActionsParam'])
        return self


class GetApplicationActionsShrinkRequest(TeaModel):
    def __init__(
        self,
        get_application_actions_param_shrink: str = None,
    ):
        # getApplicationActionsParam
        self.get_application_actions_param_shrink = get_application_actions_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_application_actions_param_shrink is not None:
            result['getApplicationActionsParam'] = self.get_application_actions_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getApplicationActionsParam') is not None:
            self.get_application_actions_param_shrink = m.get('getApplicationActionsParam')
        return self


class GetApplicationActionsResponseBodyDataActionConfigs(TeaModel):
    def __init__(
        self,
        description: str = None,
        key: str = None,
        value: str = None,
        value_attribute: str = None,
        value_type: str = None,
    ):
        self.description = description
        self.key = key
        self.value = value
        self.value_attribute = value_attribute
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        if self.value_attribute is not None:
            result['valueAttribute'] = self.value_attribute
        if self.value_type is not None:
            result['valueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueAttribute') is not None:
            self.value_attribute = m.get('valueAttribute')
        if m.get('valueType') is not None:
            self.value_type = m.get('valueType')
        return self


class GetApplicationActionsResponseBodyData(TeaModel):
    def __init__(
        self,
        action_configs: List[GetApplicationActionsResponseBodyDataActionConfigs] = None,
        action_name: str = None,
        component_name: str = None,
        description: str = None,
    ):
        self.action_configs = action_configs
        self.action_name = action_name
        self.component_name = component_name
        self.description = description

    def validate(self):
        if self.action_configs:
            for k in self.action_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['actionConfigs'] = []
        if self.action_configs is not None:
            for k in self.action_configs:
                result['actionConfigs'].append(k.to_map() if k else None)
        if self.action_name is not None:
            result['actionName'] = self.action_name
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.description is not None:
            result['description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.action_configs = []
        if m.get('actionConfigs') is not None:
            for k in m.get('actionConfigs'):
                temp_model = GetApplicationActionsResponseBodyDataActionConfigs()
                self.action_configs.append(temp_model.from_map(k))
        if m.get('actionName') is not None:
            self.action_name = m.get('actionName')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('description') is not None:
            self.description = m.get('description')
        return self


class GetApplicationActionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetApplicationActionsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = GetApplicationActionsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetApplicationActionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetApplicationActionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetApplicationActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoScalingActivityRequest(TeaModel):
    def __init__(
        self,
        get_auto_scaling_activity_param: GetAutoScalingActivityParam = None,
    ):
        self.get_auto_scaling_activity_param = get_auto_scaling_activity_param

    def validate(self):
        if self.get_auto_scaling_activity_param:
            self.get_auto_scaling_activity_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_auto_scaling_activity_param is not None:
            result['getAutoScalingActivityParam'] = self.get_auto_scaling_activity_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getAutoScalingActivityParam') is not None:
            temp_model = GetAutoScalingActivityParam()
            self.get_auto_scaling_activity_param = temp_model.from_map(m['getAutoScalingActivityParam'])
        return self


class GetAutoScalingActivityShrinkRequest(TeaModel):
    def __init__(
        self,
        get_auto_scaling_activity_param_shrink: str = None,
    ):
        self.get_auto_scaling_activity_param_shrink = get_auto_scaling_activity_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_auto_scaling_activity_param_shrink is not None:
            result['getAutoScalingActivityParam'] = self.get_auto_scaling_activity_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getAutoScalingActivityParam') is not None:
            self.get_auto_scaling_activity_param_shrink = m.get('getAutoScalingActivityParam')
        return self


class GetAutoScalingActivityResponseBodyDataScalingActivityResults(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        return self


class GetAutoScalingActivityResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        description: str = None,
        end_time: int = None,
        expect_num: int = None,
        node_group_id: str = None,
        node_group_name: str = None,
        operation_id: str = None,
        scaling_activity_id: str = None,
        scaling_activity_results: List[GetAutoScalingActivityResponseBodyDataScalingActivityResults] = None,
        scaling_activity_state: str = None,
        scaling_activity_type: str = None,
        scaling_policy_id: str = None,
        scaling_rule_detail: ScalingRule = None,
        scaling_rule_name: str = None,
        start_time: int = None,
    ):
        # 集群Id
        self.cluster_id = cluster_id
        # 本次伸缩活动描述 如果状态为 FAILED 则为失败原因
        self.description = description
        # 伸缩结束时间
        self.end_time = end_time
        self.expect_num = expect_num
        # 节点组Id
        self.node_group_id = node_group_id
        # 节点组Id
        self.node_group_name = node_group_name
        # 异步操作时的操作Id
        self.operation_id = operation_id
        # 伸缩活动id
        self.scaling_activity_id = scaling_activity_id
        self.scaling_activity_results = scaling_activity_results
        # InProgress/Failed/Rejected/Successful/\
        self.scaling_activity_state = scaling_activity_state
        # 伸缩活动类型
        self.scaling_activity_type = scaling_activity_type
        # 伸缩策略Id
        self.scaling_policy_id = scaling_policy_id
        self.scaling_rule_detail = scaling_rule_detail
        # 伸缩规则id
        self.scaling_rule_name = scaling_rule_name
        # 伸缩启动时间
        self.start_time = start_time

    def validate(self):
        if self.scaling_activity_results:
            for k in self.scaling_activity_results:
                if k:
                    k.validate()
        if self.scaling_rule_detail:
            self.scaling_rule_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.expect_num is not None:
            result['expectNum'] = self.expect_num
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_group_name is not None:
            result['nodeGroupName'] = self.node_group_name
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.scaling_activity_id is not None:
            result['scalingActivityId'] = self.scaling_activity_id
        result['scalingActivityResults'] = []
        if self.scaling_activity_results is not None:
            for k in self.scaling_activity_results:
                result['scalingActivityResults'].append(k.to_map() if k else None)
        if self.scaling_activity_state is not None:
            result['scalingActivityState'] = self.scaling_activity_state
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_rule_detail is not None:
            result['scalingRuleDetail'] = self.scaling_rule_detail.to_map()
        if self.scaling_rule_name is not None:
            result['scalingRuleName'] = self.scaling_rule_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('expectNum') is not None:
            self.expect_num = m.get('expectNum')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeGroupName') is not None:
            self.node_group_name = m.get('nodeGroupName')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('scalingActivityId') is not None:
            self.scaling_activity_id = m.get('scalingActivityId')
        self.scaling_activity_results = []
        if m.get('scalingActivityResults') is not None:
            for k in m.get('scalingActivityResults'):
                temp_model = GetAutoScalingActivityResponseBodyDataScalingActivityResults()
                self.scaling_activity_results.append(temp_model.from_map(k))
        if m.get('scalingActivityState') is not None:
            self.scaling_activity_state = m.get('scalingActivityState')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingRuleDetail') is not None:
            temp_model = ScalingRule()
            self.scaling_rule_detail = temp_model.from_map(m['scalingRuleDetail'])
        if m.get('scalingRuleName') is not None:
            self.scaling_rule_name = m.get('scalingRuleName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        return self


class GetAutoScalingActivityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAutoScalingActivityResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetAutoScalingActivityResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetAutoScalingActivityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetAutoScalingActivityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAutoScalingActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoScalingPolicyRequest(TeaModel):
    def __init__(
        self,
        get_auto_scaling_policy_param: GetAutoScalingPolicyParam = None,
    ):
        self.get_auto_scaling_policy_param = get_auto_scaling_policy_param

    def validate(self):
        if self.get_auto_scaling_policy_param:
            self.get_auto_scaling_policy_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_auto_scaling_policy_param is not None:
            result['getAutoScalingPolicyParam'] = self.get_auto_scaling_policy_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getAutoScalingPolicyParam') is not None:
            temp_model = GetAutoScalingPolicyParam()
            self.get_auto_scaling_policy_param = temp_model.from_map(m['getAutoScalingPolicyParam'])
        return self


class GetAutoScalingPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        get_auto_scaling_policy_param_shrink: str = None,
    ):
        self.get_auto_scaling_policy_param_shrink = get_auto_scaling_policy_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_auto_scaling_policy_param_shrink is not None:
            result['getAutoScalingPolicyParam'] = self.get_auto_scaling_policy_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getAutoScalingPolicyParam') is not None:
            self.get_auto_scaling_policy_param_shrink = m.get('getAutoScalingPolicyParam')
        return self


class GetAutoScalingPolicyResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        node_group_id: str = None,
        scaling_policy_id: str = None,
        scaling_rules: List[ScalingRule] = None,
    ):
        self.cluster_id = cluster_id
        # clusterScriptId
        self.node_group_id = node_group_id
        # clusterScriptId
        self.scaling_policy_id = scaling_policy_id
        self.scaling_rules = scaling_rules

    def validate(self):
        if self.scaling_rules:
            for k in self.scaling_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        result['scalingRules'] = []
        if self.scaling_rules is not None:
            for k in self.scaling_rules:
                result['scalingRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        self.scaling_rules = []
        if m.get('scalingRules') is not None:
            for k in m.get('scalingRules'):
                temp_model = ScalingRule()
                self.scaling_rules.append(temp_model.from_map(k))
        return self


class GetAutoScalingPolicyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAutoScalingPolicyResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetAutoScalingPolicyResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetAutoScalingPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetAutoScalingPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAutoScalingPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterRequest(TeaModel):
    def __init__(
        self,
        cluster_base_param: ClusterBaseParam = None,
    ):
        self.cluster_base_param = cluster_base_param

    def validate(self):
        if self.cluster_base_param:
            self.cluster_base_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_base_param is not None:
            result['clusterBaseParam'] = self.cluster_base_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterBaseParam') is not None:
            temp_model = ClusterBaseParam()
            self.cluster_base_param = temp_model.from_map(m['clusterBaseParam'])
        return self


class GetClusterShrinkRequest(TeaModel):
    def __init__(
        self,
        cluster_base_param_shrink: str = None,
    ):
        self.cluster_base_param_shrink = cluster_base_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_base_param_shrink is not None:
            result['clusterBaseParam'] = self.cluster_base_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterBaseParam') is not None:
            self.cluster_base_param_shrink = m.get('clusterBaseParam')
        return self


class GetClusterResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ClusterDTO = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ClusterDTO()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterOperationRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_param: GetClusterOperationParam = None,
    ):
        # getClusterOperationParam
        self.get_cluster_operation_param = get_cluster_operation_param

    def validate(self):
        if self.get_cluster_operation_param:
            self.get_cluster_operation_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_param is not None:
            result['getClusterOperationParam'] = self.get_cluster_operation_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationParam') is not None:
            temp_model = GetClusterOperationParam()
            self.get_cluster_operation_param = temp_model.from_map(m['getClusterOperationParam'])
        return self


class GetClusterOperationShrinkRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_param_shrink: str = None,
    ):
        # getClusterOperationParam
        self.get_cluster_operation_param_shrink = get_cluster_operation_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_param_shrink is not None:
            result['getClusterOperationParam'] = self.get_cluster_operation_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationParam') is not None:
            self.get_cluster_operation_param_shrink = m.get('getClusterOperationParam')
        return self


class GetClusterOperationResponseBodyDataFailReason(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
    ):
        self.error_code = error_code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        return self


class GetClusterOperationResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        creator: str = None,
        end_time: int = None,
        fail_reason: GetClusterOperationResponseBodyDataFailReason = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        modifier: str = None,
        operation_id: str = None,
        operation_type: str = None,
        resource_ids: str = None,
        resource_type: str = None,
        start_time: int = None,
        status: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        self.creator = creator
        # endTime
        self.end_time = end_time
        self.fail_reason = fail_reason
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # modifier
        self.modifier = modifier
        # operationId
        self.operation_id = operation_id
        # operationType
        self.operation_type = operation_type
        # resourceIds
        self.resource_ids = resource_ids
        # resourceType
        self.resource_type = resource_type
        # startTime
        self.start_time = start_time
        # status
        self.status = status

    def validate(self):
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.creator is not None:
            result['creator'] = self.creator
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.fail_reason is not None:
            result['failReason'] = self.fail_reason.to_map()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_type is not None:
            result['operationType'] = self.operation_type
        if self.resource_ids is not None:
            result['resourceIds'] = self.resource_ids
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('failReason') is not None:
            temp_model = GetClusterOperationResponseBodyDataFailReason()
            self.fail_reason = temp_model.from_map(m['failReason'])
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationType') is not None:
            self.operation_type = m.get('operationType')
        if m.get('resourceIds') is not None:
            self.resource_ids = m.get('resourceIds')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetClusterOperationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetClusterOperationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetClusterOperationResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetClusterOperationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetClusterOperationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetClusterOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterOperationNodeRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_node_param: GetClusterOperationNodeParam = None,
    ):
        # getClusterOperationNodeParam
        self.get_cluster_operation_node_param = get_cluster_operation_node_param

    def validate(self):
        if self.get_cluster_operation_node_param:
            self.get_cluster_operation_node_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_node_param is not None:
            result['getClusterOperationNodeParam'] = self.get_cluster_operation_node_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationNodeParam') is not None:
            temp_model = GetClusterOperationNodeParam()
            self.get_cluster_operation_node_param = temp_model.from_map(m['getClusterOperationNodeParam'])
        return self


class GetClusterOperationNodeShrinkRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_node_param_shrink: str = None,
    ):
        # getClusterOperationNodeParam
        self.get_cluster_operation_node_param_shrink = get_cluster_operation_node_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_node_param_shrink is not None:
            result['getClusterOperationNodeParam'] = self.get_cluster_operation_node_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationNodeParam') is not None:
            self.get_cluster_operation_node_param_shrink = m.get('getClusterOperationNodeParam')
        return self


class GetClusterOperationNodeResponseBodyData(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        has_child_operation_nodes: bool = None,
        has_operation_task: bool = None,
        operation_id: str = None,
        operation_node_id: str = None,
        operation_node_name: str = None,
        start_time: int = None,
        status: str = None,
    ):
        # endTime
        self.end_time = end_time
        # hasChildOperationNodes
        self.has_child_operation_nodes = has_child_operation_nodes
        # hasOperationTask
        self.has_operation_task = has_operation_task
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # operationNodeName
        self.operation_node_name = operation_node_name
        # startTime
        self.start_time = start_time
        # status
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.has_child_operation_nodes is not None:
            result['hasChildOperationNodes'] = self.has_child_operation_nodes
        if self.has_operation_task is not None:
            result['hasOperationTask'] = self.has_operation_task
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.operation_node_name is not None:
            result['operationNodeName'] = self.operation_node_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('hasChildOperationNodes') is not None:
            self.has_child_operation_nodes = m.get('hasChildOperationNodes')
        if m.get('hasOperationTask') is not None:
            self.has_operation_task = m.get('hasOperationTask')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('operationNodeName') is not None:
            self.operation_node_name = m.get('operationNodeName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class GetClusterOperationNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetClusterOperationNodeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetClusterOperationNodeResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetClusterOperationNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetClusterOperationNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetClusterOperationNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterOperationTaskLogRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_task_log_param: GetClusterOperationTaskLogParam = None,
    ):
        # getClusterOperationTaskLogParam
        self.get_cluster_operation_task_log_param = get_cluster_operation_task_log_param

    def validate(self):
        if self.get_cluster_operation_task_log_param:
            self.get_cluster_operation_task_log_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_task_log_param is not None:
            result['getClusterOperationTaskLogParam'] = self.get_cluster_operation_task_log_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationTaskLogParam') is not None:
            temp_model = GetClusterOperationTaskLogParam()
            self.get_cluster_operation_task_log_param = temp_model.from_map(m['getClusterOperationTaskLogParam'])
        return self


class GetClusterOperationTaskLogShrinkRequest(TeaModel):
    def __init__(
        self,
        get_cluster_operation_task_log_param_shrink: str = None,
    ):
        # getClusterOperationTaskLogParam
        self.get_cluster_operation_task_log_param_shrink = get_cluster_operation_task_log_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_operation_task_log_param_shrink is not None:
            result['getClusterOperationTaskLogParam'] = self.get_cluster_operation_task_log_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterOperationTaskLogParam') is not None:
            self.get_cluster_operation_task_log_param_shrink = m.get('getClusterOperationTaskLogParam')
        return self


class GetClusterOperationTaskLogResponseBodyData(TeaModel):
    def __init__(
        self,
        result: str = None,
        stderr: str = None,
        stdout: str = None,
    ):
        # result
        self.result = result
        # stderr
        self.stderr = stderr
        # stdout
        self.stdout = stdout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['result'] = self.result
        if self.stderr is not None:
            result['stderr'] = self.stderr
        if self.stdout is not None:
            result['stdout'] = self.stdout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('stderr') is not None:
            self.stderr = m.get('stderr')
        if m.get('stdout') is not None:
            self.stdout = m.get('stdout')
        return self


class GetClusterOperationTaskLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetClusterOperationTaskLogResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetClusterOperationTaskLogResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetClusterOperationTaskLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetClusterOperationTaskLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetClusterOperationTaskLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterScriptDetailRequest(TeaModel):
    def __init__(
        self,
        get_cluster_script_detail_param: GetClusterScriptDetailParam = None,
    ):
        # getClusterScriptDetailParam
        self.get_cluster_script_detail_param = get_cluster_script_detail_param

    def validate(self):
        if self.get_cluster_script_detail_param:
            self.get_cluster_script_detail_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_script_detail_param is not None:
            result['getClusterScriptDetailParam'] = self.get_cluster_script_detail_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterScriptDetailParam') is not None:
            temp_model = GetClusterScriptDetailParam()
            self.get_cluster_script_detail_param = temp_model.from_map(m['getClusterScriptDetailParam'])
        return self


class GetClusterScriptDetailShrinkRequest(TeaModel):
    def __init__(
        self,
        get_cluster_script_detail_param_shrink: str = None,
    ):
        # getClusterScriptDetailParam
        self.get_cluster_script_detail_param_shrink = get_cluster_script_detail_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_cluster_script_detail_param_shrink is not None:
            result['getClusterScriptDetailParam'] = self.get_cluster_script_detail_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getClusterScriptDetailParam') is not None:
            self.get_cluster_script_detail_param_shrink = m.get('getClusterScriptDetailParam')
        return self


class GetClusterScriptDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_script_args: str = None,
        cluster_script_content: str = None,
        cluster_script_content_spec: str = None,
        cluster_script_id: str = None,
        cluster_script_name: str = None,
        cluster_script_path: str = None,
        cluster_script_type: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        last_edit_time: int = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # clusterScriptArgs
        self.cluster_script_args = cluster_script_args
        # clusterScriptContent
        self.cluster_script_content = cluster_script_content
        # clusterScriptContentSpec
        self.cluster_script_content_spec = cluster_script_content_spec
        # clusterScriptId
        self.cluster_script_id = cluster_script_id
        # clusterScriptName
        self.cluster_script_name = cluster_script_name
        # clusterScriptPath
        self.cluster_script_path = cluster_script_path
        # clusterScriptType
        self.cluster_script_type = cluster_script_type
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # lastEditTime
        self.last_edit_time = last_edit_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_script_args is not None:
            result['clusterScriptArgs'] = self.cluster_script_args
        if self.cluster_script_content is not None:
            result['clusterScriptContent'] = self.cluster_script_content
        if self.cluster_script_content_spec is not None:
            result['clusterScriptContentSpec'] = self.cluster_script_content_spec
        if self.cluster_script_id is not None:
            result['clusterScriptId'] = self.cluster_script_id
        if self.cluster_script_name is not None:
            result['clusterScriptName'] = self.cluster_script_name
        if self.cluster_script_path is not None:
            result['clusterScriptPath'] = self.cluster_script_path
        if self.cluster_script_type is not None:
            result['clusterScriptType'] = self.cluster_script_type
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.last_edit_time is not None:
            result['lastEditTime'] = self.last_edit_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterScriptArgs') is not None:
            self.cluster_script_args = m.get('clusterScriptArgs')
        if m.get('clusterScriptContent') is not None:
            self.cluster_script_content = m.get('clusterScriptContent')
        if m.get('clusterScriptContentSpec') is not None:
            self.cluster_script_content_spec = m.get('clusterScriptContentSpec')
        if m.get('clusterScriptId') is not None:
            self.cluster_script_id = m.get('clusterScriptId')
        if m.get('clusterScriptName') is not None:
            self.cluster_script_name = m.get('clusterScriptName')
        if m.get('clusterScriptPath') is not None:
            self.cluster_script_path = m.get('clusterScriptPath')
        if m.get('clusterScriptType') is not None:
            self.cluster_script_type = m.get('clusterScriptType')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('lastEditTime') is not None:
            self.last_edit_time = m.get('lastEditTime')
        return self


class GetClusterScriptDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetClusterScriptDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetClusterScriptDetailResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetClusterScriptDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetClusterScriptDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetClusterScriptDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigTagsRequest(TeaModel):
    def __init__(
        self,
        get_config_tags_param: GetConfigTagsParam = None,
    ):
        # getConfigTagsParam
        self.get_config_tags_param = get_config_tags_param

    def validate(self):
        if self.get_config_tags_param:
            self.get_config_tags_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_config_tags_param is not None:
            result['getConfigTagsParam'] = self.get_config_tags_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getConfigTagsParam') is not None:
            temp_model = GetConfigTagsParam()
            self.get_config_tags_param = temp_model.from_map(m['getConfigTagsParam'])
        return self


class GetConfigTagsShrinkRequest(TeaModel):
    def __init__(
        self,
        get_config_tags_param_shrink: str = None,
    ):
        # getConfigTagsParam
        self.get_config_tags_param_shrink = get_config_tags_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_config_tags_param_shrink is not None:
            result['getConfigTagsParam'] = self.get_config_tags_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getConfigTagsParam') is not None:
            self.get_config_tags_param_shrink = m.get('getConfigTagsParam')
        return self


class GetConfigTagsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetConfigTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConfigTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDependApplicationsRequest(TeaModel):
    def __init__(
        self,
        get_depend_applications_param: GetDependApplicationsParam = None,
    ):
        # listApplicationsParam
        self.get_depend_applications_param = get_depend_applications_param

    def validate(self):
        if self.get_depend_applications_param:
            self.get_depend_applications_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_depend_applications_param is not None:
            result['getDependApplicationsParam'] = self.get_depend_applications_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getDependApplicationsParam') is not None:
            temp_model = GetDependApplicationsParam()
            self.get_depend_applications_param = temp_model.from_map(m['getDependApplicationsParam'])
        return self


class GetDependApplicationsShrinkRequest(TeaModel):
    def __init__(
        self,
        get_depend_applications_param_shrink: str = None,
    ):
        # listApplicationsParam
        self.get_depend_applications_param_shrink = get_depend_applications_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_depend_applications_param_shrink is not None:
            result['getDependApplicationsParam'] = self.get_depend_applications_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getDependApplicationsParam') is not None:
            self.get_depend_applications_param_shrink = m.get('getDependApplicationsParam')
        return self


class GetDependApplicationsResponseBodyData(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
    ):
        self.application_name = application_name
        self.application_version = application_version
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        return self


class GetDependApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetDependApplicationsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = GetDependApplicationsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetDependApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDependApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDependApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMainVersionDetailRequest(TeaModel):
    def __init__(
        self,
        get_main_version_detail_param: GetMainVersionDetailParam = None,
    ):
        self.get_main_version_detail_param = get_main_version_detail_param

    def validate(self):
        if self.get_main_version_detail_param:
            self.get_main_version_detail_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_main_version_detail_param is not None:
            result['getMainVersionDetailParam'] = self.get_main_version_detail_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getMainVersionDetailParam') is not None:
            temp_model = GetMainVersionDetailParam()
            self.get_main_version_detail_param = temp_model.from_map(m['getMainVersionDetailParam'])
        return self


class GetMainVersionDetailShrinkRequest(TeaModel):
    def __init__(
        self,
        get_main_version_detail_param_shrink: str = None,
    ):
        self.get_main_version_detail_param_shrink = get_main_version_detail_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_main_version_detail_param_shrink is not None:
            result['getMainVersionDetailParam'] = self.get_main_version_detail_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getMainVersionDetailParam') is not None:
            self.get_main_version_detail_param_shrink = m.get('getMainVersionDetailParam')
        return self


class GetMainVersionDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: MainVersionMeta = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = MainVersionMeta()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetMainVersionDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMainVersionDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMainVersionDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetReportRequest(TeaModel):
    def __init__(
        self,
        get_report_param: GetReportParam = None,
    ):
        self.get_report_param = get_report_param

    def validate(self):
        if self.get_report_param:
            self.get_report_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_report_param is not None:
            result['getReportParam'] = self.get_report_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getReportParam') is not None:
            temp_model = GetReportParam()
            self.get_report_param = temp_model.from_map(m['getReportParam'])
        return self


class GetReportShrinkRequest(TeaModel):
    def __init__(
        self,
        get_report_param_shrink: str = None,
    ):
        self.get_report_param_shrink = get_report_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_report_param_shrink is not None:
            result['getReportParam'] = self.get_report_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getReportParam') is not None:
            self.get_report_param_shrink = m.get('getReportParam')
        return self


class GetReportResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetReportResult = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetReportResult()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetReportResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetReportDataRequest(TeaModel):
    def __init__(
        self,
        get_report_data_param: GetReportDataParam = None,
    ):
        self.get_report_data_param = get_report_data_param

    def validate(self):
        if self.get_report_data_param:
            self.get_report_data_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_report_data_param is not None:
            result['getReportDataParam'] = self.get_report_data_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getReportDataParam') is not None:
            temp_model = GetReportDataParam()
            self.get_report_data_param = temp_model.from_map(m['getReportDataParam'])
        return self


class GetReportDataShrinkRequest(TeaModel):
    def __init__(
        self,
        get_report_data_param_shrink: str = None,
    ):
        self.get_report_data_param_shrink = get_report_data_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_report_data_param_shrink is not None:
            result['getReportDataParam'] = self.get_report_data_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getReportDataParam') is not None:
            self.get_report_data_param_shrink = m.get('getReportDataParam')
        return self


class GetReportDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetReportDataResult = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetReportDataResult()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetReportDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetReportDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetReportDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStackApplicationRequest(TeaModel):
    def __init__(
        self,
        get_stack_application_param: GetStackApplicationParam = None,
    ):
        self.get_stack_application_param = get_stack_application_param

    def validate(self):
        if self.get_stack_application_param:
            self.get_stack_application_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_stack_application_param is not None:
            result['getStackApplicationParam'] = self.get_stack_application_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getStackApplicationParam') is not None:
            temp_model = GetStackApplicationParam()
            self.get_stack_application_param = temp_model.from_map(m['getStackApplicationParam'])
        return self


class GetStackApplicationShrinkRequest(TeaModel):
    def __init__(
        self,
        get_stack_application_param_shrink: str = None,
    ):
        self.get_stack_application_param_shrink = get_stack_application_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_stack_application_param_shrink is not None:
            result['getStackApplicationParam'] = self.get_stack_application_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getStackApplicationParam') is not None:
            self.get_stack_application_param_shrink = m.get('getStackApplicationParam')
        return self


class GetStackApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        iaas_type: str = None,
        name: str = None,
        version: str = None,
    ):
        self.create_time = create_time
        self.iaas_type = iaas_type
        self.name = name
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.iaas_type is not None:
            result['iaasType'] = self.iaas_type
        if self.name is not None:
            result['name'] = self.name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('iaasType') is not None:
            self.iaas_type = m.get('iaasType')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class GetStackApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetStackApplicationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetStackApplicationResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetStackApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetStackApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetStackApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkflowDefinitionRequest(TeaModel):
    def __init__(
        self,
        get_workflow_definition_param: GetWorkflowDefinitionParam = None,
    ):
        # 获取工作流定义对象
        self.get_workflow_definition_param = get_workflow_definition_param

    def validate(self):
        if self.get_workflow_definition_param:
            self.get_workflow_definition_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_workflow_definition_param is not None:
            result['getWorkflowDefinitionParam'] = self.get_workflow_definition_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getWorkflowDefinitionParam') is not None:
            temp_model = GetWorkflowDefinitionParam()
            self.get_workflow_definition_param = temp_model.from_map(m['getWorkflowDefinitionParam'])
        return self


class GetWorkflowDefinitionShrinkRequest(TeaModel):
    def __init__(
        self,
        get_workflow_definition_param_shrink: str = None,
    ):
        # 获取工作流定义对象
        self.get_workflow_definition_param_shrink = get_workflow_definition_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_workflow_definition_param_shrink is not None:
            result['getWorkflowDefinitionParam'] = self.get_workflow_definition_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getWorkflowDefinitionParam') is not None:
            self.get_workflow_definition_param_shrink = m.get('getWorkflowDefinitionParam')
        return self


class GetWorkflowDefinitionResponseBodyData(TeaModel):
    def __init__(
        self,
        definition_variables: str = None,
        description: str = None,
        namespace: str = None,
        workflow_dag: str = None,
        workflow_definition_display_name: str = None,
        workflow_definition_id: int = None,
        workflow_definition_label: str = None,
        workflow_definition_name: str = None,
        workflow_definition_version: str = None,
    ):
        self.definition_variables = definition_variables
        self.description = description
        self.namespace = namespace
        self.workflow_dag = workflow_dag
        self.workflow_definition_display_name = workflow_definition_display_name
        self.workflow_definition_id = workflow_definition_id
        self.workflow_definition_label = workflow_definition_label
        self.workflow_definition_name = workflow_definition_name
        self.workflow_definition_version = workflow_definition_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definition_variables is not None:
            result['definitionVariables'] = self.definition_variables
        if self.description is not None:
            result['description'] = self.description
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.workflow_dag is not None:
            result['workflowDAG'] = self.workflow_dag
        if self.workflow_definition_display_name is not None:
            result['workflowDefinitionDisplayName'] = self.workflow_definition_display_name
        if self.workflow_definition_id is not None:
            result['workflowDefinitionId'] = self.workflow_definition_id
        if self.workflow_definition_label is not None:
            result['workflowDefinitionLabel'] = self.workflow_definition_label
        if self.workflow_definition_name is not None:
            result['workflowDefinitionName'] = self.workflow_definition_name
        if self.workflow_definition_version is not None:
            result['workflowDefinitionVersion'] = self.workflow_definition_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('definitionVariables') is not None:
            self.definition_variables = m.get('definitionVariables')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('workflowDAG') is not None:
            self.workflow_dag = m.get('workflowDAG')
        if m.get('workflowDefinitionDisplayName') is not None:
            self.workflow_definition_display_name = m.get('workflowDefinitionDisplayName')
        if m.get('workflowDefinitionId') is not None:
            self.workflow_definition_id = m.get('workflowDefinitionId')
        if m.get('workflowDefinitionLabel') is not None:
            self.workflow_definition_label = m.get('workflowDefinitionLabel')
        if m.get('workflowDefinitionName') is not None:
            self.workflow_definition_name = m.get('workflowDefinitionName')
        if m.get('workflowDefinitionVersion') is not None:
            self.workflow_definition_version = m.get('workflowDefinitionVersion')
        return self


class GetWorkflowDefinitionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetWorkflowDefinitionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetWorkflowDefinitionResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetWorkflowDefinitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetWorkflowDefinitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetWorkflowDefinitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkflowInstanceRequest(TeaModel):
    def __init__(
        self,
        get_workflow_instance_param: GetWorkflowInstanceParam = None,
    ):
        self.get_workflow_instance_param = get_workflow_instance_param

    def validate(self):
        if self.get_workflow_instance_param:
            self.get_workflow_instance_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_workflow_instance_param is not None:
            result['getWorkflowInstanceParam'] = self.get_workflow_instance_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getWorkflowInstanceParam') is not None:
            temp_model = GetWorkflowInstanceParam()
            self.get_workflow_instance_param = temp_model.from_map(m['getWorkflowInstanceParam'])
        return self


class GetWorkflowInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        get_workflow_instance_param_shrink: str = None,
    ):
        self.get_workflow_instance_param_shrink = get_workflow_instance_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.get_workflow_instance_param_shrink is not None:
            result['getWorkflowInstanceParam'] = self.get_workflow_instance_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('getWorkflowInstanceParam') is not None:
            self.get_workflow_instance_param_shrink = m.get('getWorkflowInstanceParam')
        return self


class GetWorkflowInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        parent_activity_id: int = None,
        parent_workflow_instance_id: int = None,
        token: str = None,
        workflow_definition_id: int = None,
        workflow_instance_display_name: str = None,
        workflow_instance_id: int = None,
        workflow_instance_name: str = None,
        workflow_instance_status: str = None,
    ):
        self.namespace = namespace
        self.parent_activity_id = parent_activity_id
        self.parent_workflow_instance_id = parent_workflow_instance_id
        self.token = token
        self.workflow_definition_id = workflow_definition_id
        self.workflow_instance_display_name = workflow_instance_display_name
        self.workflow_instance_id = workflow_instance_id
        self.workflow_instance_name = workflow_instance_name
        self.workflow_instance_status = workflow_instance_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.parent_activity_id is not None:
            result['parentActivityId'] = self.parent_activity_id
        if self.parent_workflow_instance_id is not None:
            result['parentWorkflowInstanceId'] = self.parent_workflow_instance_id
        if self.token is not None:
            result['token'] = self.token
        if self.workflow_definition_id is not None:
            result['workflowDefinitionId'] = self.workflow_definition_id
        if self.workflow_instance_display_name is not None:
            result['workflowInstanceDisplayName'] = self.workflow_instance_display_name
        if self.workflow_instance_id is not None:
            result['workflowInstanceId'] = self.workflow_instance_id
        if self.workflow_instance_name is not None:
            result['workflowInstanceName'] = self.workflow_instance_name
        if self.workflow_instance_status is not None:
            result['workflowInstanceStatus'] = self.workflow_instance_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('parentActivityId') is not None:
            self.parent_activity_id = m.get('parentActivityId')
        if m.get('parentWorkflowInstanceId') is not None:
            self.parent_workflow_instance_id = m.get('parentWorkflowInstanceId')
        if m.get('token') is not None:
            self.token = m.get('token')
        if m.get('workflowDefinitionId') is not None:
            self.workflow_definition_id = m.get('workflowDefinitionId')
        if m.get('workflowInstanceDisplayName') is not None:
            self.workflow_instance_display_name = m.get('workflowInstanceDisplayName')
        if m.get('workflowInstanceId') is not None:
            self.workflow_instance_id = m.get('workflowInstanceId')
        if m.get('workflowInstanceName') is not None:
            self.workflow_instance_name = m.get('workflowInstanceName')
        if m.get('workflowInstanceStatus') is not None:
            self.workflow_instance_status = m.get('workflowInstanceStatus')
        return self


class GetWorkflowInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetWorkflowInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = GetWorkflowInstanceResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetWorkflowInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetWorkflowInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetWorkflowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IncreaseNodeGroupRequest(TeaModel):
    def __init__(
        self,
        increase_node_group_param: IncreaseNodeGroupParam = None,
    ):
        # increaseNodeGroupParam
        self.increase_node_group_param = increase_node_group_param

    def validate(self):
        if self.increase_node_group_param:
            self.increase_node_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.increase_node_group_param is not None:
            result['increaseNodeGroupParam'] = self.increase_node_group_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('increaseNodeGroupParam') is not None:
            temp_model = IncreaseNodeGroupParam()
            self.increase_node_group_param = temp_model.from_map(m['increaseNodeGroupParam'])
        return self


class IncreaseNodeGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        increase_node_group_param_shrink: str = None,
    ):
        # increaseNodeGroupParam
        self.increase_node_group_param_shrink = increase_node_group_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.increase_node_group_param_shrink is not None:
            result['increaseNodeGroupParam'] = self.increase_node_group_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('increaseNodeGroupParam') is not None:
            self.increase_node_group_param_shrink = m.get('increaseNodeGroupParam')
        return self


class IncreaseNodeGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        operation_id: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # operationId
        self.operation_id = operation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        return self


class IncreaseNodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        data: IncreaseNodeGroupResponseBodyData = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # requestId
        self.request_id = request_id
        # data
        self.data = data
        # success
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('data') is not None:
            temp_model = IncreaseNodeGroupResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IncreaseNodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: IncreaseNodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = IncreaseNodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IncreaseNodeGroupDiskRequest(TeaModel):
    def __init__(
        self,
        increase_disk_param: IncreaseDiskParam = None,
    ):
        # IncreaseDiskParam
        self.increase_disk_param = increase_disk_param

    def validate(self):
        if self.increase_disk_param:
            self.increase_disk_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.increase_disk_param is not None:
            result['increaseDiskParam'] = self.increase_disk_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('increaseDiskParam') is not None:
            temp_model = IncreaseDiskParam()
            self.increase_disk_param = temp_model.from_map(m['increaseDiskParam'])
        return self


class IncreaseNodeGroupDiskShrinkRequest(TeaModel):
    def __init__(
        self,
        increase_disk_param_shrink: str = None,
    ):
        # IncreaseDiskParam
        self.increase_disk_param_shrink = increase_disk_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.increase_disk_param_shrink is not None:
            result['increaseDiskParam'] = self.increase_disk_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('increaseDiskParam') is not None:
            self.increase_disk_param_shrink = m.get('increaseDiskParam')
        return self


class IncreaseNodeGroupDiskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # data
        self.data = data
        # requestId
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class IncreaseNodeGroupDiskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: IncreaseNodeGroupDiskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = IncreaseNodeGroupDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinResourceGroupRequest(TeaModel):
    def __init__(
        self,
        join_resource_group_param: JoinResourceGroupParam = None,
    ):
        self.join_resource_group_param = join_resource_group_param

    def validate(self):
        if self.join_resource_group_param:
            self.join_resource_group_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.join_resource_group_param is not None:
            result['joinResourceGroupParam'] = self.join_resource_group_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('joinResourceGroupParam') is not None:
            temp_model = JoinResourceGroupParam()
            self.join_resource_group_param = temp_model.from_map(m['joinResourceGroupParam'])
        return self


class JoinResourceGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        join_resource_group_param_shrink: str = None,
    ):
        self.join_resource_group_param_shrink = join_resource_group_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.join_resource_group_param_shrink is not None:
            result['joinResourceGroupParam'] = self.join_resource_group_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('joinResourceGroupParam') is not None:
            self.join_resource_group_param_shrink = m.get('joinResourceGroupParam')
        return self


class JoinResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BooleanResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BooleanResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAckClusterNodePoolsRequest(TeaModel):
    def __init__(
        self,
        list_ack_cluster_node_pools_param: ListAckClusterNodePoolsParam = None,
    ):
        # listAckClusterNodePoolsParam
        self.list_ack_cluster_node_pools_param = list_ack_cluster_node_pools_param

    def validate(self):
        if self.list_ack_cluster_node_pools_param:
            self.list_ack_cluster_node_pools_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_ack_cluster_node_pools_param is not None:
            result['listAckClusterNodePoolsParam'] = self.list_ack_cluster_node_pools_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAckClusterNodePoolsParam') is not None:
            temp_model = ListAckClusterNodePoolsParam()
            self.list_ack_cluster_node_pools_param = temp_model.from_map(m['listAckClusterNodePoolsParam'])
        return self


class ListAckClusterNodePoolsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_ack_cluster_node_pools_param_shrink: str = None,
    ):
        # listAckClusterNodePoolsParam
        self.list_ack_cluster_node_pools_param_shrink = list_ack_cluster_node_pools_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_ack_cluster_node_pools_param_shrink is not None:
            result['listAckClusterNodePoolsParam'] = self.list_ack_cluster_node_pools_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAckClusterNodePoolsParam') is not None:
            self.list_ack_cluster_node_pools_param_shrink = m.get('listAckClusterNodePoolsParam')
        return self


class ListAckClusterNodePoolsResponseBodyData(TeaModel):
    def __init__(
        self,
        node_pool_id: str = None,
        node_selector: NodeSelector = None,
    ):
        self.node_pool_id = node_pool_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_pool_id is not None:
            result['nodePoolId'] = self.node_pool_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodePoolId') is not None:
            self.node_pool_id = m.get('nodePoolId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class ListAckClusterNodePoolsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAckClusterNodePoolsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListAckClusterNodePoolsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAckClusterNodePoolsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAckClusterNodePoolsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAckClusterNodePoolsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAckClusterNodesRequest(TeaModel):
    def __init__(
        self,
        list_ack_cluster_nodes_param: ListAckClusterNodesParam = None,
    ):
        # listAckClusterNodesParam
        self.list_ack_cluster_nodes_param = list_ack_cluster_nodes_param

    def validate(self):
        if self.list_ack_cluster_nodes_param:
            self.list_ack_cluster_nodes_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_ack_cluster_nodes_param is not None:
            result['listAckClusterNodesParam'] = self.list_ack_cluster_nodes_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAckClusterNodesParam') is not None:
            temp_model = ListAckClusterNodesParam()
            self.list_ack_cluster_nodes_param = temp_model.from_map(m['listAckClusterNodesParam'])
        return self


class ListAckClusterNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_ack_cluster_nodes_param_shrink: str = None,
    ):
        # listAckClusterNodesParam
        self.list_ack_cluster_nodes_param_shrink = list_ack_cluster_nodes_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_ack_cluster_nodes_param_shrink is not None:
            result['listAckClusterNodesParam'] = self.list_ack_cluster_nodes_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAckClusterNodesParam') is not None:
            self.list_ack_cluster_nodes_param_shrink = m.get('listAckClusterNodesParam')
        return self


class ListAckClusterNodesResponseBodyData(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        node_selector: NodeSelector = None,
    ):
        self.node_id = node_id
        self.node_selector = node_selector

    def validate(self):
        if self.node_selector:
            self.node_selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeSelector') is not None:
            temp_model = NodeSelector()
            self.node_selector = temp_model.from_map(m['nodeSelector'])
        return self


class ListAckClusterNodesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAckClusterNodesResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListAckClusterNodesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAckClusterNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAckClusterNodesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAckClusterNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationMetaRequest(TeaModel):
    def __init__(
        self,
        list_application_meta_param: ListApplicationMetaParam = None,
    ):
        # listApplicationMetaParam
        self.list_application_meta_param = list_application_meta_param

    def validate(self):
        if self.list_application_meta_param:
            self.list_application_meta_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_application_meta_param is not None:
            result['listApplicationMetaParam'] = self.list_application_meta_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listApplicationMetaParam') is not None:
            temp_model = ListApplicationMetaParam()
            self.list_application_meta_param = temp_model.from_map(m['listApplicationMetaParam'])
        return self


class ListApplicationMetaShrinkRequest(TeaModel):
    def __init__(
        self,
        list_application_meta_param_shrink: str = None,
    ):
        # listApplicationMetaParam
        self.list_application_meta_param_shrink = list_application_meta_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_application_meta_param_shrink is not None:
            result['listApplicationMetaParam'] = self.list_application_meta_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listApplicationMetaParam') is not None:
            self.list_application_meta_param_shrink = m.get('listApplicationMetaParam')
        return self


class ListApplicationMetaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ApplicationMetaDTO] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ApplicationMetaDTO()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListApplicationMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListApplicationMetaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListApplicationMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsRequest(TeaModel):
    def __init__(
        self,
        list_applications_param: ListApplicationsParam = None,
    ):
        # listApplicationsParam
        self.list_applications_param = list_applications_param

    def validate(self):
        if self.list_applications_param:
            self.list_applications_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_applications_param is not None:
            result['listApplicationsParam'] = self.list_applications_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listApplicationsParam') is not None:
            temp_model = ListApplicationsParam()
            self.list_applications_param = temp_model.from_map(m['listApplicationsParam'])
        return self


class ListApplicationsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_applications_param_shrink: str = None,
    ):
        # listApplicationsParam
        self.list_applications_param_shrink = list_applications_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_applications_param_shrink is not None:
            result['listApplicationsParam'] = self.list_applications_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listApplicationsParam') is not None:
            self.list_applications_param_shrink = m.get('listApplicationsParam')
        return self


class ListApplicationsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_version: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
    ):
        self.application_name = application_name
        self.application_version = application_version
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.application_version is not None:
            result['applicationVersion'] = self.application_version
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('applicationVersion') is not None:
            self.application_version = m.get('applicationVersion')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        return self


class ListApplicationsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListApplicationsResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListApplicationsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListApplicationsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListApplicationsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAutoScalingActivitiesRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_activities_param: ListAutoScalingActivitiesParam = None,
    ):
        # listAutoScalingActivitiesParam
        self.list_auto_scaling_activities_param = list_auto_scaling_activities_param

    def validate(self):
        if self.list_auto_scaling_activities_param:
            self.list_auto_scaling_activities_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_activities_param is not None:
            result['listAutoScalingActivitiesParam'] = self.list_auto_scaling_activities_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingActivitiesParam') is not None:
            temp_model = ListAutoScalingActivitiesParam()
            self.list_auto_scaling_activities_param = temp_model.from_map(m['listAutoScalingActivitiesParam'])
        return self


class ListAutoScalingActivitiesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_activities_param_shrink: str = None,
    ):
        # listAutoScalingActivitiesParam
        self.list_auto_scaling_activities_param_shrink = list_auto_scaling_activities_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_activities_param_shrink is not None:
            result['listAutoScalingActivitiesParam'] = self.list_auto_scaling_activities_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingActivitiesParam') is not None:
            self.list_auto_scaling_activities_param_shrink = m.get('listAutoScalingActivitiesParam')
        return self


class ListAutoScalingActivitiesResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        description: str = None,
        end_time: int = None,
        expect_num: int = None,
        node_group_id: str = None,
        node_group_name: str = None,
        operation_id: str = None,
        scaling_activity_id: str = None,
        scaling_activity_state: str = None,
        scaling_activity_type: str = None,
        scaling_policy_id: str = None,
        scaling_rule_name: str = None,
        start_time: int = None,
    ):
        # 集群Id
        self.cluster_id = cluster_id
        # 本次伸缩活动描述 如果状态为 FAILED 则为失败原因
        self.description = description
        # 伸缩结束时间
        self.end_time = end_time
        self.expect_num = expect_num
        # 节点组Id
        self.node_group_id = node_group_id
        # 节点组Id
        self.node_group_name = node_group_name
        # 异步操作时的操作Id
        self.operation_id = operation_id
        # 伸缩活动id
        self.scaling_activity_id = scaling_activity_id
        # InProgress/Failed/Rejected/Successful/\
        self.scaling_activity_state = scaling_activity_state
        # 伸缩活动类型
        self.scaling_activity_type = scaling_activity_type
        # 伸缩策略Id
        self.scaling_policy_id = scaling_policy_id
        # 伸缩规则id
        self.scaling_rule_name = scaling_rule_name
        # 伸缩启动时间
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.expect_num is not None:
            result['expectNum'] = self.expect_num
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_group_name is not None:
            result['nodeGroupName'] = self.node_group_name
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.scaling_activity_id is not None:
            result['scalingActivityId'] = self.scaling_activity_id
        if self.scaling_activity_state is not None:
            result['scalingActivityState'] = self.scaling_activity_state
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_rule_name is not None:
            result['scalingRuleName'] = self.scaling_rule_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('expectNum') is not None:
            self.expect_num = m.get('expectNum')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeGroupName') is not None:
            self.node_group_name = m.get('nodeGroupName')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('scalingActivityId') is not None:
            self.scaling_activity_id = m.get('scalingActivityId')
        if m.get('scalingActivityState') is not None:
            self.scaling_activity_state = m.get('scalingActivityState')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingRuleName') is not None:
            self.scaling_rule_name = m.get('scalingRuleName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        return self


class ListAutoScalingActivitiesResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListAutoScalingActivitiesResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListAutoScalingActivitiesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListAutoScalingActivitiesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListAutoScalingActivitiesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListAutoScalingActivitiesResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAutoScalingActivitiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAutoScalingActivitiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAutoScalingActivitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAutoScalingMetricsRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_metrics_param: ListAutoScalingMetricsParam = None,
    ):
        # listAutoScalingMetricsParam
        self.list_auto_scaling_metrics_param = list_auto_scaling_metrics_param

    def validate(self):
        if self.list_auto_scaling_metrics_param:
            self.list_auto_scaling_metrics_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_metrics_param is not None:
            result['listAutoScalingMetricsParam'] = self.list_auto_scaling_metrics_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingMetricsParam') is not None:
            temp_model = ListAutoScalingMetricsParam()
            self.list_auto_scaling_metrics_param = temp_model.from_map(m['listAutoScalingMetricsParam'])
        return self


class ListAutoScalingMetricsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_metrics_param_shrink: str = None,
    ):
        # listAutoScalingMetricsParam
        self.list_auto_scaling_metrics_param_shrink = list_auto_scaling_metrics_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_metrics_param_shrink is not None:
            result['listAutoScalingMetricsParam'] = self.list_auto_scaling_metrics_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingMetricsParam') is not None:
            self.list_auto_scaling_metrics_param_shrink = m.get('listAutoScalingMetricsParam')
        return self


class ListAutoScalingMetricsResponseBodyData(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
    ):
        # 指标名称
        self.metric_name = metric_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['metricName'] = self.metric_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metricName') is not None:
            self.metric_name = m.get('metricName')
        return self


class ListAutoScalingMetricsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAutoScalingMetricsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListAutoScalingMetricsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAutoScalingMetricsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAutoScalingMetricsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAutoScalingMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAutoScalingPoliciesRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_policies_param: ListAutoScalingPoliciesParam = None,
    ):
        # listAutoScalingPoliciesParam
        self.list_auto_scaling_policies_param = list_auto_scaling_policies_param

    def validate(self):
        if self.list_auto_scaling_policies_param:
            self.list_auto_scaling_policies_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_policies_param is not None:
            result['listAutoScalingPoliciesParam'] = self.list_auto_scaling_policies_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingPoliciesParam') is not None:
            temp_model = ListAutoScalingPoliciesParam()
            self.list_auto_scaling_policies_param = temp_model.from_map(m['listAutoScalingPoliciesParam'])
        return self


class ListAutoScalingPoliciesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_policies_param_shrink: str = None,
    ):
        # listAutoScalingPoliciesParam
        self.list_auto_scaling_policies_param_shrink = list_auto_scaling_policies_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_policies_param_shrink is not None:
            result['listAutoScalingPoliciesParam'] = self.list_auto_scaling_policies_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingPoliciesParam') is not None:
            self.list_auto_scaling_policies_param_shrink = m.get('listAutoScalingPoliciesParam')
        return self


class ListAutoScalingPoliciesResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        defrost_time: int = None,
        frost_reason: str = None,
        node_group_id: str = None,
        scaling_policy_id: str = None,
        scaling_policy_status: str = None,
    ):
        # 集群Id
        self.cluster_id = cluster_id
        # 解冻时间
        self.defrost_time = defrost_time
        # 拒绝原因
        self.frost_reason = frost_reason
        # 节点组Id
        self.node_group_id = node_group_id
        # 伸缩策略Id
        self.scaling_policy_id = scaling_policy_id
        # INACTIVE/ACTIVE
        self.scaling_policy_status = scaling_policy_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.defrost_time is not None:
            result['defrostTime'] = self.defrost_time
        if self.frost_reason is not None:
            result['frostReason'] = self.frost_reason
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_policy_status is not None:
            result['scalingPolicyStatus'] = self.scaling_policy_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('defrostTime') is not None:
            self.defrost_time = m.get('defrostTime')
        if m.get('frostReason') is not None:
            self.frost_reason = m.get('frostReason')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingPolicyStatus') is not None:
            self.scaling_policy_status = m.get('scalingPolicyStatus')
        return self


class ListAutoScalingPoliciesResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListAutoScalingPoliciesResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListAutoScalingPoliciesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListAutoScalingPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListAutoScalingPoliciesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListAutoScalingPoliciesResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAutoScalingPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAutoScalingPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAutoScalingPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAutoScalingRulesRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_rules_param: ListAutoScalingRulesParam = None,
    ):
        # listAutoScalingRulesParam
        self.list_auto_scaling_rules_param = list_auto_scaling_rules_param

    def validate(self):
        if self.list_auto_scaling_rules_param:
            self.list_auto_scaling_rules_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_rules_param is not None:
            result['listAutoScalingRulesParam'] = self.list_auto_scaling_rules_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingRulesParam') is not None:
            temp_model = ListAutoScalingRulesParam()
            self.list_auto_scaling_rules_param = temp_model.from_map(m['listAutoScalingRulesParam'])
        return self


class ListAutoScalingRulesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_auto_scaling_rules_param_shrink: str = None,
    ):
        # listAutoScalingRulesParam
        self.list_auto_scaling_rules_param_shrink = list_auto_scaling_rules_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_auto_scaling_rules_param_shrink is not None:
            result['listAutoScalingRulesParam'] = self.list_auto_scaling_rules_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listAutoScalingRulesParam') is not None:
            self.list_auto_scaling_rules_param_shrink = m.get('listAutoScalingRulesParam')
        return self


class ListAutoScalingRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        adjustment_value: int = None,
        by_load_scaling_rule_spec: ByLoadScalingRuleSpec = None,
        by_time_scaling_rule_spec: ByTimeScalingRuleSpec = None,
        cluster_id: str = None,
        cool_down_interval: int = None,
        node_group_id: str = None,
        scaling_activity_type: str = None,
        scaling_policy_id: str = None,
        scaling_rule_id: str = None,
        scaling_rule_name: str = None,
        scaling_rule_status: str = None,
        scaling_rule_type: str = None,
    ):
        # 调整数量
        self.adjustment_value = adjustment_value
        self.by_load_scaling_rule_spec = by_load_scaling_rule_spec
        self.by_time_scaling_rule_spec = by_time_scaling_rule_spec
        # 集群Id
        self.cluster_id = cluster_id
        # 冷却时间 单位为妙
        self.cool_down_interval = cool_down_interval
        # 节点组Id
        self.node_group_id = node_group_id
        # 伸缩活动类型
        self.scaling_activity_type = scaling_activity_type
        # 所属弹性伸缩策略 Id
        self.scaling_policy_id = scaling_policy_id
        # 伸缩规则Id
        self.scaling_rule_id = scaling_rule_id
        # 伸缩规则名称
        self.scaling_rule_name = scaling_rule_name
        # INACTIVE/ACTIVE
        self.scaling_rule_status = scaling_rule_status
        # 伸缩规则类型
        self.scaling_rule_type = scaling_rule_type

    def validate(self):
        if self.by_load_scaling_rule_spec:
            self.by_load_scaling_rule_spec.validate()
        if self.by_time_scaling_rule_spec:
            self.by_time_scaling_rule_spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjustment_value is not None:
            result['adjustmentValue'] = self.adjustment_value
        if self.by_load_scaling_rule_spec is not None:
            result['byLoadScalingRuleSpec'] = self.by_load_scaling_rule_spec.to_map()
        if self.by_time_scaling_rule_spec is not None:
            result['byTimeScalingRuleSpec'] = self.by_time_scaling_rule_spec.to_map()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cool_down_interval is not None:
            result['coolDownInterval'] = self.cool_down_interval
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.scaling_activity_type is not None:
            result['scalingActivityType'] = self.scaling_activity_type
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.scaling_rule_id is not None:
            result['scalingRuleId'] = self.scaling_rule_id
        if self.scaling_rule_name is not None:
            result['scalingRuleName'] = self.scaling_rule_name
        if self.scaling_rule_status is not None:
            result['scalingRuleStatus'] = self.scaling_rule_status
        if self.scaling_rule_type is not None:
            result['scalingRuleType'] = self.scaling_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjustmentValue') is not None:
            self.adjustment_value = m.get('adjustmentValue')
        if m.get('byLoadScalingRuleSpec') is not None:
            temp_model = ByLoadScalingRuleSpec()
            self.by_load_scaling_rule_spec = temp_model.from_map(m['byLoadScalingRuleSpec'])
        if m.get('byTimeScalingRuleSpec') is not None:
            temp_model = ByTimeScalingRuleSpec()
            self.by_time_scaling_rule_spec = temp_model.from_map(m['byTimeScalingRuleSpec'])
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('coolDownInterval') is not None:
            self.cool_down_interval = m.get('coolDownInterval')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('scalingActivityType') is not None:
            self.scaling_activity_type = m.get('scalingActivityType')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('scalingRuleId') is not None:
            self.scaling_rule_id = m.get('scalingRuleId')
        if m.get('scalingRuleName') is not None:
            self.scaling_rule_name = m.get('scalingRuleName')
        if m.get('scalingRuleStatus') is not None:
            self.scaling_rule_status = m.get('scalingRuleStatus')
        if m.get('scalingRuleType') is not None:
            self.scaling_rule_type = m.get('scalingRuleType')
        return self


class ListAutoScalingRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAutoScalingRulesResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListAutoScalingRulesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListAutoScalingRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAutoScalingRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAutoScalingRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterAckByAckInstanceIdsRequest(TeaModel):
    def __init__(
        self,
        list_cluster_ack_by_instance_ids_param: ListClusterAckByInstanceIdsParam = None,
    ):
        # listClusterAckByInstanceIdsParam
        self.list_cluster_ack_by_instance_ids_param = list_cluster_ack_by_instance_ids_param

    def validate(self):
        if self.list_cluster_ack_by_instance_ids_param:
            self.list_cluster_ack_by_instance_ids_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_ack_by_instance_ids_param is not None:
            result['listClusterAckByInstanceIdsParam'] = self.list_cluster_ack_by_instance_ids_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterAckByInstanceIdsParam') is not None:
            temp_model = ListClusterAckByInstanceIdsParam()
            self.list_cluster_ack_by_instance_ids_param = temp_model.from_map(m['listClusterAckByInstanceIdsParam'])
        return self


class ListClusterAckByAckInstanceIdsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_ack_by_instance_ids_param_shrink: str = None,
    ):
        # listClusterAckByInstanceIdsParam
        self.list_cluster_ack_by_instance_ids_param_shrink = list_cluster_ack_by_instance_ids_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_ack_by_instance_ids_param_shrink is not None:
            result['listClusterAckByInstanceIdsParam'] = self.list_cluster_ack_by_instance_ids_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterAckByInstanceIdsParam') is not None:
            self.list_cluster_ack_by_instance_ids_param_shrink = m.get('listClusterAckByInstanceIdsParam')
        return self


class ListClusterAckByAckInstanceIdsResponseBodyData(TeaModel):
    def __init__(
        self,
        ack_cluster_type: str = None,
        ack_id: str = None,
        ack_instance_id: str = None,
        cluster_id: str = None,
        namespace: str = None,
        node_label: str = None,
        oss_path: str = None,
        product: str = None,
        status: str = None,
        vpc_id: str = None,
        vswitch_id: str = None,
    ):
        self.ack_cluster_type = ack_cluster_type
        self.ack_id = ack_id
        self.ack_instance_id = ack_instance_id
        self.cluster_id = cluster_id
        self.namespace = namespace
        self.node_label = node_label
        self.oss_path = oss_path
        self.product = product
        self.status = status
        self.vpc_id = vpc_id
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_type is not None:
            result['ackClusterType'] = self.ack_cluster_type
        if self.ack_id is not None:
            result['ackId'] = self.ack_id
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label
        if self.oss_path is not None:
            result['ossPath'] = self.oss_path
        if self.product is not None:
            result['product'] = self.product
        if self.status is not None:
            result['status'] = self.status
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['vswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackClusterType') is not None:
            self.ack_cluster_type = m.get('ackClusterType')
        if m.get('ackId') is not None:
            self.ack_id = m.get('ackId')
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('nodeLabel') is not None:
            self.node_label = m.get('nodeLabel')
        if m.get('ossPath') is not None:
            self.oss_path = m.get('ossPath')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        if m.get('vswitchId') is not None:
            self.vswitch_id = m.get('vswitchId')
        return self


class ListClusterAckByAckInstanceIdsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListClusterAckByAckInstanceIdsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListClusterAckByAckInstanceIdsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterAckByAckInstanceIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterAckByAckInstanceIdsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterAckByAckInstanceIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterAckByClusterIdsRequest(TeaModel):
    def __init__(
        self,
        list_cluster_ack_cluster_by_cluster_ids_param: ListClusterAckClusterByClusterIdsParam = None,
    ):
        # listClusterAckClusterByClusterIdsParam
        self.list_cluster_ack_cluster_by_cluster_ids_param = list_cluster_ack_cluster_by_cluster_ids_param

    def validate(self):
        if self.list_cluster_ack_cluster_by_cluster_ids_param:
            self.list_cluster_ack_cluster_by_cluster_ids_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_ack_cluster_by_cluster_ids_param is not None:
            result['listClusterAckClusterByClusterIdsParam'] = self.list_cluster_ack_cluster_by_cluster_ids_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterAckClusterByClusterIdsParam') is not None:
            temp_model = ListClusterAckClusterByClusterIdsParam()
            self.list_cluster_ack_cluster_by_cluster_ids_param = temp_model.from_map(m['listClusterAckClusterByClusterIdsParam'])
        return self


class ListClusterAckByClusterIdsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_ack_cluster_by_cluster_ids_param_shrink: str = None,
    ):
        # listClusterAckClusterByClusterIdsParam
        self.list_cluster_ack_cluster_by_cluster_ids_param_shrink = list_cluster_ack_cluster_by_cluster_ids_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_ack_cluster_by_cluster_ids_param_shrink is not None:
            result['listClusterAckClusterByClusterIdsParam'] = self.list_cluster_ack_cluster_by_cluster_ids_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterAckClusterByClusterIdsParam') is not None:
            self.list_cluster_ack_cluster_by_cluster_ids_param_shrink = m.get('listClusterAckClusterByClusterIdsParam')
        return self


class ListClusterAckByClusterIdsResponseBodyData(TeaModel):
    def __init__(
        self,
        ack_cluster_type: str = None,
        ack_id: str = None,
        ack_instance_id: str = None,
        cluster_id: str = None,
        namespace: str = None,
        node_label: str = None,
        oss_path: str = None,
        product: str = None,
        status: str = None,
        vpc_id: str = None,
        vswitch_id: str = None,
    ):
        self.ack_cluster_type = ack_cluster_type
        self.ack_id = ack_id
        self.ack_instance_id = ack_instance_id
        self.cluster_id = cluster_id
        self.namespace = namespace
        self.node_label = node_label
        self.oss_path = oss_path
        self.product = product
        self.status = status
        self.vpc_id = vpc_id
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_type is not None:
            result['ackClusterType'] = self.ack_cluster_type
        if self.ack_id is not None:
            result['ackId'] = self.ack_id
        if self.ack_instance_id is not None:
            result['ackInstanceId'] = self.ack_instance_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.node_label is not None:
            result['nodeLabel'] = self.node_label
        if self.oss_path is not None:
            result['ossPath'] = self.oss_path
        if self.product is not None:
            result['product'] = self.product
        if self.status is not None:
            result['status'] = self.status
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['vswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ackClusterType') is not None:
            self.ack_cluster_type = m.get('ackClusterType')
        if m.get('ackId') is not None:
            self.ack_id = m.get('ackId')
        if m.get('ackInstanceId') is not None:
            self.ack_instance_id = m.get('ackInstanceId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('nodeLabel') is not None:
            self.node_label = m.get('nodeLabel')
        if m.get('ossPath') is not None:
            self.oss_path = m.get('ossPath')
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        if m.get('vswitchId') is not None:
            self.vswitch_id = m.get('vswitchId')
        return self


class ListClusterAckByClusterIdsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListClusterAckByClusterIdsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListClusterAckByClusterIdsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterAckByClusterIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterAckByClusterIdsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterAckByClusterIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterNodeGroupRequest(TeaModel):
    def __init__(
        self,
        list_cluster_node_groups_param: ListClusterNodeGroupsParam = None,
    ):
        # listClusterNodeGroupsParam
        self.list_cluster_node_groups_param = list_cluster_node_groups_param

    def validate(self):
        if self.list_cluster_node_groups_param:
            self.list_cluster_node_groups_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_node_groups_param is not None:
            result['listClusterNodeGroupsParam'] = self.list_cluster_node_groups_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterNodeGroupsParam') is not None:
            temp_model = ListClusterNodeGroupsParam()
            self.list_cluster_node_groups_param = temp_model.from_map(m['listClusterNodeGroupsParam'])
        return self


class ListClusterNodeGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_node_groups_param_shrink: str = None,
    ):
        # listClusterNodeGroupsParam
        self.list_cluster_node_groups_param_shrink = list_cluster_node_groups_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_node_groups_param_shrink is not None:
            result['listClusterNodeGroupsParam'] = self.list_cluster_node_groups_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterNodeGroupsParam') is not None:
            self.list_cluster_node_groups_param_shrink = m.get('listClusterNodeGroupsParam')
        return self


class ListClusterNodeGroupResponseBodyDataItemsCostOptimizedConfig(TeaModel):
    def __init__(
        self,
        on_demand_base_capacity: int = None,
        on_demand_percentage_above_base_capacity: int = None,
        spot_instance_pools: int = None,
    ):
        self.on_demand_base_capacity = on_demand_base_capacity
        self.on_demand_percentage_above_base_capacity = on_demand_percentage_above_base_capacity
        self.spot_instance_pools = spot_instance_pools

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.on_demand_base_capacity is not None:
            result['onDemandBaseCapacity'] = self.on_demand_base_capacity
        if self.on_demand_percentage_above_base_capacity is not None:
            result['onDemandPercentageAboveBaseCapacity'] = self.on_demand_percentage_above_base_capacity
        if self.spot_instance_pools is not None:
            result['spotInstancePools'] = self.spot_instance_pools
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('onDemandBaseCapacity') is not None:
            self.on_demand_base_capacity = m.get('onDemandBaseCapacity')
        if m.get('onDemandPercentageAboveBaseCapacity') is not None:
            self.on_demand_percentage_above_base_capacity = m.get('onDemandPercentageAboveBaseCapacity')
        if m.get('spotInstancePools') is not None:
            self.spot_instance_pools = m.get('spotInstancePools')
        return self


class ListClusterNodeGroupResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        additional_security_group_ids: List[str] = None,
        cost_optimized_config: ListClusterNodeGroupResponseBodyDataItemsCostOptimizedConfig = None,
        data_disk_count: int = None,
        data_disk_size: int = None,
        description: str = None,
        enable_decommission_gracefully: bool = None,
        fleet_id: str = None,
        image_id: str = None,
        instance_type_list: List[str] = None,
        keypair_name: str = None,
        max_size: int = None,
        min_size: int = None,
        node_group_id: str = None,
        node_group_name: str = None,
        node_group_type: str = None,
        node_ram_role: str = None,
        node_resize_strategy: str = None,
        payment_type: str = None,
        sata_disk_category: str = None,
        scaling_policy_id: str = None,
        security_group_id: str = None,
        spot_instance_remedy: bool = None,
        spot_price_limits: List[float] = None,
        spot_strategy: str = None,
        system_disk_category: str = None,
        system_disk_size: int = None,
        vswitch_id: str = None,
        with_public_ip: bool = None,
        zone_id: str = None,
    ):
        self.additional_security_group_ids = additional_security_group_ids
        self.cost_optimized_config = cost_optimized_config
        self.data_disk_count = data_disk_count
        self.data_disk_size = data_disk_size
        self.description = description
        self.enable_decommission_gracefully = enable_decommission_gracefully
        self.fleet_id = fleet_id
        self.image_id = image_id
        self.instance_type_list = instance_type_list
        self.keypair_name = keypair_name
        self.max_size = max_size
        self.min_size = min_size
        self.node_group_id = node_group_id
        self.node_group_name = node_group_name
        self.node_group_type = node_group_type
        self.node_ram_role = node_ram_role
        self.node_resize_strategy = node_resize_strategy
        self.payment_type = payment_type
        self.sata_disk_category = sata_disk_category
        self.scaling_policy_id = scaling_policy_id
        self.security_group_id = security_group_id
        self.spot_instance_remedy = spot_instance_remedy
        self.spot_price_limits = spot_price_limits
        self.spot_strategy = spot_strategy
        self.system_disk_category = system_disk_category
        self.system_disk_size = system_disk_size
        self.vswitch_id = vswitch_id
        self.with_public_ip = with_public_ip
        self.zone_id = zone_id

    def validate(self):
        if self.cost_optimized_config:
            self.cost_optimized_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_security_group_ids is not None:
            result['additionalSecurityGroupIds'] = self.additional_security_group_ids
        if self.cost_optimized_config is not None:
            result['costOptimizedConfig'] = self.cost_optimized_config.to_map()
        if self.data_disk_count is not None:
            result['dataDiskCount'] = self.data_disk_count
        if self.data_disk_size is not None:
            result['dataDiskSize'] = self.data_disk_size
        if self.description is not None:
            result['description'] = self.description
        if self.enable_decommission_gracefully is not None:
            result['enableDecommissionGracefully'] = self.enable_decommission_gracefully
        if self.fleet_id is not None:
            result['fleetId'] = self.fleet_id
        if self.image_id is not None:
            result['imageId'] = self.image_id
        if self.instance_type_list is not None:
            result['instanceTypeList'] = self.instance_type_list
        if self.keypair_name is not None:
            result['keypairName'] = self.keypair_name
        if self.max_size is not None:
            result['maxSize'] = self.max_size
        if self.min_size is not None:
            result['minSize'] = self.min_size
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_group_name is not None:
            result['nodeGroupName'] = self.node_group_name
        if self.node_group_type is not None:
            result['nodeGroupType'] = self.node_group_type
        if self.node_ram_role is not None:
            result['nodeRamRole'] = self.node_ram_role
        if self.node_resize_strategy is not None:
            result['nodeResizeStrategy'] = self.node_resize_strategy
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.sata_disk_category is not None:
            result['sataDiskCategory'] = self.sata_disk_category
        if self.scaling_policy_id is not None:
            result['scalingPolicyId'] = self.scaling_policy_id
        if self.security_group_id is not None:
            result['securityGroupId'] = self.security_group_id
        if self.spot_instance_remedy is not None:
            result['spotInstanceRemedy'] = self.spot_instance_remedy
        if self.spot_price_limits is not None:
            result['spotPriceLimits'] = self.spot_price_limits
        if self.spot_strategy is not None:
            result['spotStrategy'] = self.spot_strategy
        if self.system_disk_category is not None:
            result['systemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['systemDiskSize'] = self.system_disk_size
        if self.vswitch_id is not None:
            result['vswitchId'] = self.vswitch_id
        if self.with_public_ip is not None:
            result['withPublicIp'] = self.with_public_ip
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('additionalSecurityGroupIds') is not None:
            self.additional_security_group_ids = m.get('additionalSecurityGroupIds')
        if m.get('costOptimizedConfig') is not None:
            temp_model = ListClusterNodeGroupResponseBodyDataItemsCostOptimizedConfig()
            self.cost_optimized_config = temp_model.from_map(m['costOptimizedConfig'])
        if m.get('dataDiskCount') is not None:
            self.data_disk_count = m.get('dataDiskCount')
        if m.get('dataDiskSize') is not None:
            self.data_disk_size = m.get('dataDiskSize')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('enableDecommissionGracefully') is not None:
            self.enable_decommission_gracefully = m.get('enableDecommissionGracefully')
        if m.get('fleetId') is not None:
            self.fleet_id = m.get('fleetId')
        if m.get('imageId') is not None:
            self.image_id = m.get('imageId')
        if m.get('instanceTypeList') is not None:
            self.instance_type_list = m.get('instanceTypeList')
        if m.get('keypairName') is not None:
            self.keypair_name = m.get('keypairName')
        if m.get('maxSize') is not None:
            self.max_size = m.get('maxSize')
        if m.get('minSize') is not None:
            self.min_size = m.get('minSize')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeGroupName') is not None:
            self.node_group_name = m.get('nodeGroupName')
        if m.get('nodeGroupType') is not None:
            self.node_group_type = m.get('nodeGroupType')
        if m.get('nodeRamRole') is not None:
            self.node_ram_role = m.get('nodeRamRole')
        if m.get('nodeResizeStrategy') is not None:
            self.node_resize_strategy = m.get('nodeResizeStrategy')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('sataDiskCategory') is not None:
            self.sata_disk_category = m.get('sataDiskCategory')
        if m.get('scalingPolicyId') is not None:
            self.scaling_policy_id = m.get('scalingPolicyId')
        if m.get('securityGroupId') is not None:
            self.security_group_id = m.get('securityGroupId')
        if m.get('spotInstanceRemedy') is not None:
            self.spot_instance_remedy = m.get('spotInstanceRemedy')
        if m.get('spotPriceLimits') is not None:
            self.spot_price_limits = m.get('spotPriceLimits')
        if m.get('spotStrategy') is not None:
            self.spot_strategy = m.get('spotStrategy')
        if m.get('systemDiskCategory') is not None:
            self.system_disk_category = m.get('systemDiskCategory')
        if m.get('systemDiskSize') is not None:
            self.system_disk_size = m.get('systemDiskSize')
        if m.get('vswitchId') is not None:
            self.vswitch_id = m.get('vswitchId')
        if m.get('withPublicIp') is not None:
            self.with_public_ip = m.get('withPublicIp')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class ListClusterNodeGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClusterNodeGroupResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClusterNodeGroupResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListClusterNodeGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListClusterNodeGroupResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListClusterNodeGroupResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterNodeGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterNodeGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterNodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationNodesRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operation_nodes_param: ListClusterOperationNodesParam = None,
    ):
        # listClusterOperationNodesParam
        self.list_cluster_operation_nodes_param = list_cluster_operation_nodes_param

    def validate(self):
        if self.list_cluster_operation_nodes_param:
            self.list_cluster_operation_nodes_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operation_nodes_param is not None:
            result['listClusterOperationNodesParam'] = self.list_cluster_operation_nodes_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationNodesParam') is not None:
            temp_model = ListClusterOperationNodesParam()
            self.list_cluster_operation_nodes_param = temp_model.from_map(m['listClusterOperationNodesParam'])
        return self


class ListClusterOperationNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operation_nodes_param_shrink: str = None,
    ):
        # listClusterOperationNodesParam
        self.list_cluster_operation_nodes_param_shrink = list_cluster_operation_nodes_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operation_nodes_param_shrink is not None:
            result['listClusterOperationNodesParam'] = self.list_cluster_operation_nodes_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationNodesParam') is not None:
            self.list_cluster_operation_nodes_param_shrink = m.get('listClusterOperationNodesParam')
        return self


class ListClusterOperationNodesResponseBodyData(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        has_child_operation_nodes: bool = None,
        has_operation_task: bool = None,
        operation_id: str = None,
        operation_node_id: str = None,
        operation_node_name: str = None,
        start_time: int = None,
        status: str = None,
    ):
        # endTime
        self.end_time = end_time
        # hasChildOperationNodes
        self.has_child_operation_nodes = has_child_operation_nodes
        # hasOperationTask
        self.has_operation_task = has_operation_task
        # operationId
        self.operation_id = operation_id
        # operationNodeId
        self.operation_node_id = operation_node_id
        # operationNodeName
        self.operation_node_name = operation_node_name
        # startTime
        self.start_time = start_time
        # status
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.has_child_operation_nodes is not None:
            result['hasChildOperationNodes'] = self.has_child_operation_nodes
        if self.has_operation_task is not None:
            result['hasOperationTask'] = self.has_operation_task
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_node_id is not None:
            result['operationNodeId'] = self.operation_node_id
        if self.operation_node_name is not None:
            result['operationNodeName'] = self.operation_node_name
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('hasChildOperationNodes') is not None:
            self.has_child_operation_nodes = m.get('hasChildOperationNodes')
        if m.get('hasOperationTask') is not None:
            self.has_operation_task = m.get('hasOperationTask')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationNodeId') is not None:
            self.operation_node_id = m.get('operationNodeId')
        if m.get('operationNodeName') is not None:
            self.operation_node_name = m.get('operationNodeName')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ListClusterOperationNodesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListClusterOperationNodesResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListClusterOperationNodesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterOperationNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationNodesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationTasksRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operation_tasks_param: ListClusterOperationTasksParam = None,
    ):
        # listClusterOperationTasksParam
        self.list_cluster_operation_tasks_param = list_cluster_operation_tasks_param

    def validate(self):
        if self.list_cluster_operation_tasks_param:
            self.list_cluster_operation_tasks_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operation_tasks_param is not None:
            result['listClusterOperationTasksParam'] = self.list_cluster_operation_tasks_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationTasksParam') is not None:
            temp_model = ListClusterOperationTasksParam()
            self.list_cluster_operation_tasks_param = temp_model.from_map(m['listClusterOperationTasksParam'])
        return self


class ListClusterOperationTasksShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operation_tasks_param_shrink: str = None,
    ):
        # listClusterOperationTasksParam
        self.list_cluster_operation_tasks_param_shrink = list_cluster_operation_tasks_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operation_tasks_param_shrink is not None:
            result['listClusterOperationTasksParam'] = self.list_cluster_operation_tasks_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationTasksParam') is not None:
            self.list_cluster_operation_tasks_param_shrink = m.get('listClusterOperationTasksParam')
        return self


class ListClusterOperationTasksResponseBodyOperationTasks(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        node_id: str = None,
        operation_task_id: int = None,
        operation_task_name: str = None,
        start_time: int = None,
        status: str = None,
    ):
        # 结束时间。 结束时间。 ```1592837465784```
        self.end_time = end_time
        # 创建时间。 创建时间。 ```1592837465784```
        self.gmt_create = gmt_create
        # 修改时间。 修改时间。 ```1592837465784```
        self.gmt_modified = gmt_modified
        # 执行节点ID。 执行节点ID。 ```i-xxx```
        self.node_id = node_id
        # 任务ID。 任务ID。 ```1592837465784```
        self.operation_task_id = operation_task_id
        # 任务名称。 任务名称。 ``` Install@Flink@FlinkRunime```
        self.operation_task_name = operation_task_name
        # 开始时间。 开始时间。 ```1592837465784```
        self.start_time = start_time
        # 状态。 状态。 ```RUNNING```
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.operation_task_id is not None:
            result['OperationTaskId'] = self.operation_task_id
        if self.operation_task_name is not None:
            result['OperationTaskName'] = self.operation_task_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('OperationTaskId') is not None:
            self.operation_task_id = m.get('OperationTaskId')
        if m.get('OperationTaskName') is not None:
            self.operation_task_name = m.get('OperationTaskName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListClusterOperationTasksResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        operation_tasks: List[ListClusterOperationTasksResponseBodyOperationTasks] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 一次获取的最大记录数。 一次获取的最大记录数。 ```20```
        self.max_results = max_results
        # 下一页TOKEN。 下一页TOKEN。 ```DD6B1B2A-5837-5237-ABE4-FF0C89568980```
        self.next_token = next_token
        self.operation_tasks = operation_tasks
        # 请求ID。 请求ID。 ```DD6B1B2A-5837-5237-ABE4-FF0C8944****```
        self.request_id = request_id
        # 记录总数。 记录总数。 ```200```
        self.total_count = total_count

    def validate(self):
        if self.operation_tasks:
            for k in self.operation_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['OperationTasks'] = []
        if self.operation_tasks is not None:
            for k in self.operation_tasks:
                result['OperationTasks'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.operation_tasks = []
        if m.get('OperationTasks') is not None:
            for k in m.get('OperationTasks'):
                temp_model = ListClusterOperationTasksResponseBodyOperationTasks()
                self.operation_tasks.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListClusterOperationTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationsRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operations_param: ListClusterOperationsParam = None,
    ):
        # listClusterOperationsParam
        self.list_cluster_operations_param = list_cluster_operations_param

    def validate(self):
        if self.list_cluster_operations_param:
            self.list_cluster_operations_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operations_param is not None:
            result['listClusterOperationsParam'] = self.list_cluster_operations_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationsParam') is not None:
            temp_model = ListClusterOperationsParam()
            self.list_cluster_operations_param = temp_model.from_map(m['listClusterOperationsParam'])
        return self


class ListClusterOperationsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_operations_param_shrink: str = None,
    ):
        # listClusterOperationsParam
        self.list_cluster_operations_param_shrink = list_cluster_operations_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_operations_param_shrink is not None:
            result['listClusterOperationsParam'] = self.list_cluster_operations_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOperationsParam') is not None:
            self.list_cluster_operations_param_shrink = m.get('listClusterOperationsParam')
        return self


class ListClusterOperationsResponseBodyDataItemsFailReason(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
    ):
        # errorCode
        self.error_code = error_code
        # errorMessage
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        return self


class ListClusterOperationsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        creator: str = None,
        end_time: int = None,
        fail_reason: ListClusterOperationsResponseBodyDataItemsFailReason = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        modifier: str = None,
        operation_id: str = None,
        operation_type: str = None,
        resource_ids: str = None,
        resource_type: str = None,
        start_time: int = None,
        status: str = None,
        token: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        self.creator = creator
        # endTime
        self.end_time = end_time
        self.fail_reason = fail_reason
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # modifier
        self.modifier = modifier
        # operationId
        self.operation_id = operation_id
        # operationType
        self.operation_type = operation_type
        # resourceIds
        self.resource_ids = resource_ids
        # resourceType
        self.resource_type = resource_type
        # startTime
        self.start_time = start_time
        # status
        self.status = status
        # token
        self.token = token

    def validate(self):
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.creator is not None:
            result['creator'] = self.creator
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.fail_reason is not None:
            result['failReason'] = self.fail_reason.to_map()
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.operation_id is not None:
            result['operationId'] = self.operation_id
        if self.operation_type is not None:
            result['operationType'] = self.operation_type
        if self.resource_ids is not None:
            result['resourceIds'] = self.resource_ids
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.status is not None:
            result['status'] = self.status
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('failReason') is not None:
            temp_model = ListClusterOperationsResponseBodyDataItemsFailReason()
            self.fail_reason = temp_model.from_map(m['failReason'])
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('operationId') is not None:
            self.operation_id = m.get('operationId')
        if m.get('operationType') is not None:
            self.operation_type = m.get('operationType')
        if m.get('resourceIds') is not None:
            self.resource_ids = m.get('resourceIds')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class ListClusterOperationsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClusterOperationsResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClusterOperationsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListClusterOperationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListClusterOperationsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListClusterOperationsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOrdersRequest(TeaModel):
    def __init__(
        self,
        list_cluster_orders_param: ListClusterOrdersParam = None,
    ):
        # listClusterOrdersParam
        self.list_cluster_orders_param = list_cluster_orders_param

    def validate(self):
        if self.list_cluster_orders_param:
            self.list_cluster_orders_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_orders_param is not None:
            result['listClusterOrdersParam'] = self.list_cluster_orders_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOrdersParam') is not None:
            temp_model = ListClusterOrdersParam()
            self.list_cluster_orders_param = temp_model.from_map(m['listClusterOrdersParam'])
        return self


class ListClusterOrdersShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_orders_param_shrink: str = None,
    ):
        # listClusterOrdersParam
        self.list_cluster_orders_param_shrink = list_cluster_orders_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_orders_param_shrink is not None:
            result['listClusterOrdersParam'] = self.list_cluster_orders_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterOrdersParam') is not None:
            self.list_cluster_orders_param_shrink = m.get('listClusterOrdersParam')
        return self


class ListClusterOrdersResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        order_id: str = None,
        order_status: str = None,
        order_type: str = None,
    ):
        # instanceIds
        self.instance_ids = instance_ids
        # orderId
        self.order_id = order_id
        # orderStatus
        self.order_status = order_status
        # orderType
        self.order_type = order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['instanceIds'] = self.instance_ids
        if self.order_id is not None:
            result['orderId'] = self.order_id
        if self.order_status is not None:
            result['orderStatus'] = self.order_status
        if self.order_type is not None:
            result['orderType'] = self.order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceIds') is not None:
            self.instance_ids = m.get('instanceIds')
        if m.get('orderId') is not None:
            self.order_id = m.get('orderId')
        if m.get('orderStatus') is not None:
            self.order_status = m.get('orderStatus')
        if m.get('orderType') is not None:
            self.order_type = m.get('orderType')
        return self


class ListClusterOrdersResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClusterOrdersResponseBodyDataItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClusterOrdersResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListClusterOrdersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListClusterOrdersResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListClusterOrdersResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterOrdersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOrdersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOrdersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterScriptsRequest(TeaModel):
    def __init__(
        self,
        list_cluster_scripts_param: ListClusterScriptsParam = None,
    ):
        # listClusterScriptsParam
        self.list_cluster_scripts_param = list_cluster_scripts_param

    def validate(self):
        if self.list_cluster_scripts_param:
            self.list_cluster_scripts_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_scripts_param is not None:
            result['listClusterScriptsParam'] = self.list_cluster_scripts_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterScriptsParam') is not None:
            temp_model = ListClusterScriptsParam()
            self.list_cluster_scripts_param = temp_model.from_map(m['listClusterScriptsParam'])
        return self


class ListClusterScriptsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_scripts_param_shrink: str = None,
    ):
        # listClusterScriptsParam
        self.list_cluster_scripts_param_shrink = list_cluster_scripts_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_scripts_param_shrink is not None:
            result['listClusterScriptsParam'] = self.list_cluster_scripts_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterScriptsParam') is not None:
            self.list_cluster_scripts_param_shrink = m.get('listClusterScriptsParam')
        return self


class ListClusterScriptsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        execute_fail_strategy: str = None,
        execute_moment: str = None,
        execute_scope: str = None,
        execute_scope_params: str = None,
        last_edit_time: int = None,
        script_args: str = None,
        script_content: str = None,
        script_content_spec: str = None,
        script_id: str = None,
        script_name: str = None,
        script_path: str = None,
        script_type: str = None,
    ):
        # clusterId
        self.cluster_id = cluster_id
        # executeFailStrategy
        self.execute_fail_strategy = execute_fail_strategy
        # executeMoment
        self.execute_moment = execute_moment
        # executeScope
        self.execute_scope = execute_scope
        # executeScopeParams
        self.execute_scope_params = execute_scope_params
        # lastEditTime
        self.last_edit_time = last_edit_time
        # clusterScriptArgs
        self.script_args = script_args
        # clusterScriptContent
        self.script_content = script_content
        # clusterScriptContentSpec
        self.script_content_spec = script_content_spec
        # clusterScriptId
        self.script_id = script_id
        # clusterScriptName
        self.script_name = script_name
        # clusterScriptPath
        self.script_path = script_path
        # clusterScriptType
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.execute_fail_strategy is not None:
            result['executeFailStrategy'] = self.execute_fail_strategy
        if self.execute_moment is not None:
            result['executeMoment'] = self.execute_moment
        if self.execute_scope is not None:
            result['executeScope'] = self.execute_scope
        if self.execute_scope_params is not None:
            result['executeScopeParams'] = self.execute_scope_params
        if self.last_edit_time is not None:
            result['lastEditTime'] = self.last_edit_time
        if self.script_args is not None:
            result['scriptArgs'] = self.script_args
        if self.script_content is not None:
            result['scriptContent'] = self.script_content
        if self.script_content_spec is not None:
            result['scriptContentSpec'] = self.script_content_spec
        if self.script_id is not None:
            result['scriptId'] = self.script_id
        if self.script_name is not None:
            result['scriptName'] = self.script_name
        if self.script_path is not None:
            result['scriptPath'] = self.script_path
        if self.script_type is not None:
            result['scriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('executeFailStrategy') is not None:
            self.execute_fail_strategy = m.get('executeFailStrategy')
        if m.get('executeMoment') is not None:
            self.execute_moment = m.get('executeMoment')
        if m.get('executeScope') is not None:
            self.execute_scope = m.get('executeScope')
        if m.get('executeScopeParams') is not None:
            self.execute_scope_params = m.get('executeScopeParams')
        if m.get('lastEditTime') is not None:
            self.last_edit_time = m.get('lastEditTime')
        if m.get('scriptArgs') is not None:
            self.script_args = m.get('scriptArgs')
        if m.get('scriptContent') is not None:
            self.script_content = m.get('scriptContent')
        if m.get('scriptContentSpec') is not None:
            self.script_content_spec = m.get('scriptContentSpec')
        if m.get('scriptId') is not None:
            self.script_id = m.get('scriptId')
        if m.get('scriptName') is not None:
            self.script_name = m.get('scriptName')
        if m.get('scriptPath') is not None:
            self.script_path = m.get('scriptPath')
        if m.get('scriptType') is not None:
            self.script_type = m.get('scriptType')
        return self


class ListClusterScriptsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClusterScriptsResponseBodyDataItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClusterScriptsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListClusterScriptsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListClusterScriptsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListClusterScriptsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterScriptsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterScriptsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterScriptsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterUsersRequest(TeaModel):
    def __init__(
        self,
        list_cluster_users_param: ListClusterUserParam = None,
    ):
        self.list_cluster_users_param = list_cluster_users_param

    def validate(self):
        if self.list_cluster_users_param:
            self.list_cluster_users_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_users_param is not None:
            result['listClusterUsersParam'] = self.list_cluster_users_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterUsersParam') is not None:
            temp_model = ListClusterUserParam()
            self.list_cluster_users_param = temp_model.from_map(m['listClusterUsersParam'])
        return self


class ListClusterUsersShrinkRequest(TeaModel):
    def __init__(
        self,
        list_cluster_users_param_shrink: str = None,
    ):
        self.list_cluster_users_param_shrink = list_cluster_users_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_cluster_users_param_shrink is not None:
            result['listClusterUsersParam'] = self.list_cluster_users_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClusterUsersParam') is not None:
            self.list_cluster_users_param_shrink = m.get('listClusterUsersParam')
        return self


class ListClusterUsersResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        ldap_url: str = None,
        status: str = None,
        user_group: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.ldap_url = ldap_url
        self.status = status
        self.user_group = user_group
        self.user_id = user_id
        self.user_name = user_name
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.ldap_url is not None:
            result['ldapUrl'] = self.ldap_url
        if self.status is not None:
            result['status'] = self.status
        if self.user_group is not None:
            result['userGroup'] = self.user_group
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.user_name is not None:
            result['userName'] = self.user_name
        if self.user_type is not None:
            result['userType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('ldapUrl') is not None:
            self.ldap_url = m.get('ldapUrl')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('userGroup') is not None:
            self.user_group = m.get('userGroup')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        if m.get('userType') is not None:
            self.user_type = m.get('userType')
        return self


class ListClusterUsersResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClusterUsersResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClusterUsersResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListClusterUsersResponseBody(TeaModel):
    def __init__(
        self,
        data: ListClusterUsersResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            temp_model = ListClusterUsersResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClusterUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterUsersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClustersRequest(TeaModel):
    def __init__(
        self,
        list_clusters_param: ListClustersParam = None,
    ):
        # listClustersParam
        self.list_clusters_param = list_clusters_param

    def validate(self):
        if self.list_clusters_param:
            self.list_clusters_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_clusters_param is not None:
            result['listClustersParam'] = self.list_clusters_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClustersParam') is not None:
            temp_model = ListClustersParam()
            self.list_clusters_param = temp_model.from_map(m['listClustersParam'])
        return self


class ListClustersShrinkRequest(TeaModel):
    def __init__(
        self,
        list_clusters_param_shrink: str = None,
    ):
        # listClustersParam
        self.list_clusters_param_shrink = list_clusters_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_clusters_param_shrink is not None:
            result['listClustersParam'] = self.list_clusters_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listClustersParam') is not None:
            self.list_clusters_param_shrink = m.get('listClustersParam')
        return self


class ListClustersResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_status: str = None,
        cluster_type: str = None,
        creator: str = None,
        deploy_mode: str = None,
        deposit_type: str = None,
        expire_time: int = None,
        fail_reason: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        has_uncompleted_order: bool = None,
        iaa_stype: str = None,
        main_version: str = None,
        modifier: str = None,
        payment_status: str = None,
        payment_type: str = None,
        region_id: str = None,
        resource_owner_id: str = None,
        security_mode: str = None,
        vpc_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_status = cluster_status
        self.cluster_type = cluster_type
        self.creator = creator
        self.deploy_mode = deploy_mode
        self.deposit_type = deposit_type
        # 过期时间
        self.expire_time = expire_time
        self.fail_reason = fail_reason
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.has_uncompleted_order = has_uncompleted_order
        self.iaa_stype = iaa_stype
        self.main_version = main_version
        self.modifier = modifier
        self.payment_status = payment_status
        self.payment_type = payment_type
        self.region_id = region_id
        self.resource_owner_id = resource_owner_id
        self.security_mode = security_mode
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.cluster_status is not None:
            result['clusterStatus'] = self.cluster_status
        if self.cluster_type is not None:
            result['clusterType'] = self.cluster_type
        if self.creator is not None:
            result['creator'] = self.creator
        if self.deploy_mode is not None:
            result['deployMode'] = self.deploy_mode
        if self.deposit_type is not None:
            result['depositType'] = self.deposit_type
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.fail_reason is not None:
            result['failReason'] = self.fail_reason
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.has_uncompleted_order is not None:
            result['hasUncompletedOrder'] = self.has_uncompleted_order
        if self.iaa_stype is not None:
            result['iaaSType'] = self.iaa_stype
        if self.main_version is not None:
            result['mainVersion'] = self.main_version
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.payment_status is not None:
            result['paymentStatus'] = self.payment_status
        if self.payment_type is not None:
            result['paymentType'] = self.payment_type
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['resourceOwnerId'] = self.resource_owner_id
        if self.security_mode is not None:
            result['securityMode'] = self.security_mode
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('clusterStatus') is not None:
            self.cluster_status = m.get('clusterStatus')
        if m.get('clusterType') is not None:
            self.cluster_type = m.get('clusterType')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('deployMode') is not None:
            self.deploy_mode = m.get('deployMode')
        if m.get('depositType') is not None:
            self.deposit_type = m.get('depositType')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('failReason') is not None:
            self.fail_reason = m.get('failReason')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('hasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('hasUncompletedOrder')
        if m.get('iaaSType') is not None:
            self.iaa_stype = m.get('iaaSType')
        if m.get('mainVersion') is not None:
            self.main_version = m.get('mainVersion')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('paymentStatus') is not None:
            self.payment_status = m.get('paymentStatus')
        if m.get('paymentType') is not None:
            self.payment_type = m.get('paymentType')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('resourceOwnerId') is not None:
            self.resource_owner_id = m.get('resourceOwnerId')
        if m.get('securityMode') is not None:
            self.security_mode = m.get('securityMode')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class ListClustersResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListClustersResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['maxResults'] = self.max_results
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListClustersResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('maxResults') is not None:
            self.max_results = m.get('maxResults')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListClustersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListClustersResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListClustersResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListComponentInstancesRequest(TeaModel):
    def __init__(
        self,
        list_component_instances_param: ListComponentInstancesParam = None,
    ):
        # listComponentsParam
        self.list_component_instances_param = list_component_instances_param

    def validate(self):
        if self.list_component_instances_param:
            self.list_component_instances_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_component_instances_param is not None:
            result['listComponentInstancesParam'] = self.list_component_instances_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listComponentInstancesParam') is not None:
            temp_model = ListComponentInstancesParam()
            self.list_component_instances_param = temp_model.from_map(m['listComponentInstancesParam'])
        return self


class ListComponentInstancesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_component_instances_param_shrink: str = None,
    ):
        # listComponentsParam
        self.list_component_instances_param_shrink = list_component_instances_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_component_instances_param_shrink is not None:
            result['listComponentInstancesParam'] = self.list_component_instances_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listComponentInstancesParam') is not None:
            self.list_component_instances_param_shrink = m.get('listComponentInstancesParam')
        return self


class ListComponentInstancesResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        biz_state: str = None,
        commission_state: str = None,
        component_instance_status: str = None,
        component_name: str = None,
        description: str = None,
        desired_state: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        maintenance_state: str = None,
        node_id: str = None,
        node_name: str = None,
        replica: int = None,
        status_report_time: int = None,
    ):
        self.application_name = application_name
        self.biz_state = biz_state
        self.commission_state = commission_state
        self.component_instance_status = component_instance_status
        self.component_name = component_name
        self.description = description
        self.desired_state = desired_state
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.maintenance_state = maintenance_state
        self.node_id = node_id
        self.node_name = node_name
        self.replica = replica
        self.status_report_time = status_report_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.biz_state is not None:
            result['bizState'] = self.biz_state
        if self.commission_state is not None:
            result['commissionState'] = self.commission_state
        if self.component_instance_status is not None:
            result['componentInstanceStatus'] = self.component_instance_status
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.description is not None:
            result['description'] = self.description
        if self.desired_state is not None:
            result['desiredState'] = self.desired_state
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.maintenance_state is not None:
            result['maintenanceState'] = self.maintenance_state
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.replica is not None:
            result['replica'] = self.replica
        if self.status_report_time is not None:
            result['statusReportTime'] = self.status_report_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('bizState') is not None:
            self.biz_state = m.get('bizState')
        if m.get('commissionState') is not None:
            self.commission_state = m.get('commissionState')
        if m.get('componentInstanceStatus') is not None:
            self.component_instance_status = m.get('componentInstanceStatus')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('desiredState') is not None:
            self.desired_state = m.get('desiredState')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('maintenanceState') is not None:
            self.maintenance_state = m.get('maintenanceState')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('replica') is not None:
            self.replica = m.get('replica')
        if m.get('statusReportTime') is not None:
            self.status_report_time = m.get('statusReportTime')
        return self


class ListComponentInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListComponentInstancesResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListComponentInstancesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListComponentInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListComponentInstancesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListComponentInstancesResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListComponentInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListComponentInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListComponentInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListComponentsRequest(TeaModel):
    def __init__(
        self,
        list_components_param: ListComponentsParam = None,
    ):
        # listComponentsParam
        self.list_components_param = list_components_param

    def validate(self):
        if self.list_components_param:
            self.list_components_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_components_param is not None:
            result['listComponentsParam'] = self.list_components_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listComponentsParam') is not None:
            temp_model = ListComponentsParam()
            self.list_components_param = temp_model.from_map(m['listComponentsParam'])
        return self


class ListComponentsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_components_param_shrink: str = None,
    ):
        # listComponentsParam
        self.list_components_param_shrink = list_components_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_components_param_shrink is not None:
            result['listComponentsParam'] = self.list_components_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listComponentsParam') is not None:
            self.list_components_param_shrink = m.get('listComponentsParam')
        return self


class ListComponentsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        component_name: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        replica: int = None,
    ):
        self.application_name = application_name
        self.component_name = component_name
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.replica = replica

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.replica is not None:
            result['replica'] = self.replica
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('replica') is not None:
            self.replica = m.get('replica')
        return self


class ListComponentsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListComponentsResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListComponentsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListComponentsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListComponentsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListComponentsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListComponentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListComponentsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListComponentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigFilesRequest(TeaModel):
    def __init__(
        self,
        list_config_files_param: ListConfigFilesParam = None,
    ):
        # listConfigFilesParam
        self.list_config_files_param = list_config_files_param

    def validate(self):
        if self.list_config_files_param:
            self.list_config_files_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_files_param is not None:
            result['listConfigFilesParam'] = self.list_config_files_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigFilesParam') is not None:
            temp_model = ListConfigFilesParam()
            self.list_config_files_param = temp_model.from_map(m['listConfigFilesParam'])
        return self


class ListConfigFilesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_config_files_param_shrink: str = None,
    ):
        # listConfigFilesParam
        self.list_config_files_param_shrink = list_config_files_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_files_param_shrink is not None:
            result['listConfigFilesParam'] = self.list_config_files_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigFilesParam') is not None:
            self.list_config_files_param_shrink = m.get('listConfigFilesParam')
        return self


class ListConfigFilesResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cluster_id: str = None,
        description: str = None,
        file_format: str = None,
        file_group: str = None,
        file_link: str = None,
        file_mode: str = None,
        file_name: str = None,
        file_owner: str = None,
        file_path: str = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        self.application_name = application_name
        self.cluster_id = cluster_id
        self.description = description
        self.file_format = file_format
        self.file_group = file_group
        self.file_link = file_link
        self.file_mode = file_mode
        self.file_name = file_name
        self.file_owner = file_owner
        self.file_path = file_path
        self.node_group_id = node_group_id
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.description is not None:
            result['description'] = self.description
        if self.file_format is not None:
            result['fileFormat'] = self.file_format
        if self.file_group is not None:
            result['fileGroup'] = self.file_group
        if self.file_link is not None:
            result['fileLink'] = self.file_link
        if self.file_mode is not None:
            result['fileMode'] = self.file_mode
        if self.file_name is not None:
            result['fileName'] = self.file_name
        if self.file_owner is not None:
            result['fileOwner'] = self.file_owner
        if self.file_path is not None:
            result['filePath'] = self.file_path
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('fileFormat') is not None:
            self.file_format = m.get('fileFormat')
        if m.get('fileGroup') is not None:
            self.file_group = m.get('fileGroup')
        if m.get('fileLink') is not None:
            self.file_link = m.get('fileLink')
        if m.get('fileMode') is not None:
            self.file_mode = m.get('fileMode')
        if m.get('fileName') is not None:
            self.file_name = m.get('fileName')
        if m.get('fileOwner') is not None:
            self.file_owner = m.get('fileOwner')
        if m.get('filePath') is not None:
            self.file_path = m.get('filePath')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class ListConfigFilesResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListConfigFilesResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListConfigFilesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListConfigFilesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListConfigFilesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListConfigFilesResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListConfigFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigHistoryRequest(TeaModel):
    def __init__(
        self,
        list_config_history_param: ListConfigHistoryParam = None,
    ):
        # listConfigHistoryParam
        self.list_config_history_param = list_config_history_param

    def validate(self):
        if self.list_config_history_param:
            self.list_config_history_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_history_param is not None:
            result['listConfigHistoryParam'] = self.list_config_history_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigHistoryParam') is not None:
            temp_model = ListConfigHistoryParam()
            self.list_config_history_param = temp_model.from_map(m['listConfigHistoryParam'])
        return self


class ListConfigHistoryShrinkRequest(TeaModel):
    def __init__(
        self,
        list_config_history_param_shrink: str = None,
    ):
        # listConfigHistoryParam
        self.list_config_history_param_shrink = list_config_history_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_history_param_shrink is not None:
            result['listConfigHistoryParam'] = self.list_config_history_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigHistoryParam') is not None:
            self.list_config_history_param_shrink = m.get('listConfigHistoryParam')
        return self


class ListConfigHistoryResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        change_type: str = None,
        cluster_id: str = None,
        config_file_name: str = None,
        config_group_id: str = None,
        config_item_key: str = None,
        config_version: str = None,
        creator: str = None,
        description: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        modifier: str = None,
        new_value: str = None,
        node_group_id: str = None,
        node_id: str = None,
        old_value: str = None,
    ):
        self.application_name = application_name
        self.change_type = change_type
        self.cluster_id = cluster_id
        self.config_file_name = config_file_name
        self.config_group_id = config_group_id
        self.config_item_key = config_item_key
        self.config_version = config_version
        self.creator = creator
        self.description = description
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.modifier = modifier
        self.new_value = new_value
        self.node_group_id = node_group_id
        self.node_id = node_id
        self.old_value = old_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.change_type is not None:
            result['changeType'] = self.change_type
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_group_id is not None:
            result['configGroupId'] = self.config_group_id
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.new_value is not None:
            result['newValue'] = self.new_value
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.old_value is not None:
            result['oldValue'] = self.old_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('changeType') is not None:
            self.change_type = m.get('changeType')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configGroupId') is not None:
            self.config_group_id = m.get('configGroupId')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('newValue') is not None:
            self.new_value = m.get('newValue')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('oldValue') is not None:
            self.old_value = m.get('oldValue')
        return self


class ListConfigHistoryResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListConfigHistoryResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListConfigHistoryResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListConfigHistoryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListConfigHistoryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListConfigHistoryResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListConfigHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigVersionsRequest(TeaModel):
    def __init__(
        self,
        list_config_versions_param: ListConfigVersionsParam = None,
    ):
        # listConfigVersionsParam
        self.list_config_versions_param = list_config_versions_param

    def validate(self):
        if self.list_config_versions_param:
            self.list_config_versions_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_versions_param is not None:
            result['listConfigVersionsParam'] = self.list_config_versions_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigVersionsParam') is not None:
            temp_model = ListConfigVersionsParam()
            self.list_config_versions_param = temp_model.from_map(m['listConfigVersionsParam'])
        return self


class ListConfigVersionsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_config_versions_param_shrink: str = None,
    ):
        # listConfigVersionsParam
        self.list_config_versions_param_shrink = list_config_versions_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_config_versions_param_shrink is not None:
            result['listConfigVersionsParam'] = self.list_config_versions_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigVersionsParam') is not None:
            self.list_config_versions_param_shrink = m.get('listConfigVersionsParam')
        return self


class ListConfigVersionsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        config_version: str = None,
        creator: str = None,
        description: str = None,
        gmt_create: int = None,
    ):
        self.cluster_id = cluster_id
        self.config_version = config_version
        self.creator = creator
        self.description = description
        self.gmt_create = gmt_create

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        if self.creator is not None:
            result['creator'] = self.creator
        if self.description is not None:
            result['description'] = self.description
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        return self


class ListConfigVersionsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListConfigVersionsResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListConfigVersionsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListConfigVersionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListConfigVersionsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListConfigVersionsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListConfigVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigVersionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigsRequest(TeaModel):
    def __init__(
        self,
        list_configs_param: ListConfigsParam = None,
    ):
        # listConfigsParam
        self.list_configs_param = list_configs_param

    def validate(self):
        if self.list_configs_param:
            self.list_configs_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_configs_param is not None:
            result['listConfigsParam'] = self.list_configs_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigsParam') is not None:
            temp_model = ListConfigsParam()
            self.list_configs_param = temp_model.from_map(m['listConfigsParam'])
        return self


class ListConfigsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_configs_param_shrink: str = None,
    ):
        # listConfigsParam
        self.list_configs_param_shrink = list_configs_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_configs_param_shrink is not None:
            result['listConfigsParam'] = self.list_configs_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listConfigsParam') is not None:
            self.list_configs_param_shrink = m.get('listConfigsParam')
        return self


class ListConfigsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        config_file_name: str = None,
        config_item_effective_actions: str = None,
        config_item_effective_type: str = None,
        config_item_key: str = None,
        config_item_value: str = None,
        config_item_value_increment_step: str = None,
        config_item_value_maximum: str = None,
        config_item_value_minimum: str = None,
        config_item_value_read_only: bool = None,
        config_item_value_type: str = None,
        config_item_value_unit: str = None,
        config_type: str = None,
        config_version: str = None,
        create_time: int = None,
        description: str = None,
        init_value: str = None,
        modifier: str = None,
        modify_time: int = None,
        node_group_id: str = None,
        node_id: str = None,
    ):
        self.application_name = application_name
        self.config_file_name = config_file_name
        self.config_item_effective_actions = config_item_effective_actions
        self.config_item_effective_type = config_item_effective_type
        self.config_item_key = config_item_key
        self.config_item_value = config_item_value
        self.config_item_value_increment_step = config_item_value_increment_step
        self.config_item_value_maximum = config_item_value_maximum
        self.config_item_value_minimum = config_item_value_minimum
        self.config_item_value_read_only = config_item_value_read_only
        self.config_item_value_type = config_item_value_type
        self.config_item_value_unit = config_item_value_unit
        self.config_type = config_type
        self.config_version = config_version
        self.create_time = create_time
        self.description = description
        self.init_value = init_value
        self.modifier = modifier
        self.modify_time = modify_time
        self.node_group_id = node_group_id
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.config_file_name is not None:
            result['configFileName'] = self.config_file_name
        if self.config_item_effective_actions is not None:
            result['configItemEffectiveActions'] = self.config_item_effective_actions
        if self.config_item_effective_type is not None:
            result['configItemEffectiveType'] = self.config_item_effective_type
        if self.config_item_key is not None:
            result['configItemKey'] = self.config_item_key
        if self.config_item_value is not None:
            result['configItemValue'] = self.config_item_value
        if self.config_item_value_increment_step is not None:
            result['configItemValueIncrementStep'] = self.config_item_value_increment_step
        if self.config_item_value_maximum is not None:
            result['configItemValueMaximum'] = self.config_item_value_maximum
        if self.config_item_value_minimum is not None:
            result['configItemValueMinimum'] = self.config_item_value_minimum
        if self.config_item_value_read_only is not None:
            result['configItemValueReadOnly'] = self.config_item_value_read_only
        if self.config_item_value_type is not None:
            result['configItemValueType'] = self.config_item_value_type
        if self.config_item_value_unit is not None:
            result['configItemValueUnit'] = self.config_item_value_unit
        if self.config_type is not None:
            result['configType'] = self.config_type
        if self.config_version is not None:
            result['configVersion'] = self.config_version
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.init_value is not None:
            result['initValue'] = self.init_value
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.modify_time is not None:
            result['modifyTime'] = self.modify_time
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('configFileName') is not None:
            self.config_file_name = m.get('configFileName')
        if m.get('configItemEffectiveActions') is not None:
            self.config_item_effective_actions = m.get('configItemEffectiveActions')
        if m.get('configItemEffectiveType') is not None:
            self.config_item_effective_type = m.get('configItemEffectiveType')
        if m.get('configItemKey') is not None:
            self.config_item_key = m.get('configItemKey')
        if m.get('configItemValue') is not None:
            self.config_item_value = m.get('configItemValue')
        if m.get('configItemValueIncrementStep') is not None:
            self.config_item_value_increment_step = m.get('configItemValueIncrementStep')
        if m.get('configItemValueMaximum') is not None:
            self.config_item_value_maximum = m.get('configItemValueMaximum')
        if m.get('configItemValueMinimum') is not None:
            self.config_item_value_minimum = m.get('configItemValueMinimum')
        if m.get('configItemValueReadOnly') is not None:
            self.config_item_value_read_only = m.get('configItemValueReadOnly')
        if m.get('configItemValueType') is not None:
            self.config_item_value_type = m.get('configItemValueType')
        if m.get('configItemValueUnit') is not None:
            self.config_item_value_unit = m.get('configItemValueUnit')
        if m.get('configType') is not None:
            self.config_type = m.get('configType')
        if m.get('configVersion') is not None:
            self.config_version = m.get('configVersion')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('initValue') is not None:
            self.init_value = m.get('initValue')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('modifyTime') is not None:
            self.modify_time = m.get('modifyTime')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        return self


class ListConfigsResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListConfigsResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListConfigsResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListConfigsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListConfigsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListConfigsResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListKubeCustomerResourceRequest(TeaModel):
    def __init__(
        self,
        list_kube_customer_resources_param: ListKubeCustomerResourcesParam = None,
    ):
        # listKubeCustomerResourcesParam
        self.list_kube_customer_resources_param = list_kube_customer_resources_param

    def validate(self):
        if self.list_kube_customer_resources_param:
            self.list_kube_customer_resources_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_kube_customer_resources_param is not None:
            result['listKubeCustomerResourcesParam'] = self.list_kube_customer_resources_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listKubeCustomerResourcesParam') is not None:
            temp_model = ListKubeCustomerResourcesParam()
            self.list_kube_customer_resources_param = temp_model.from_map(m['listKubeCustomerResourcesParam'])
        return self


class ListKubeCustomerResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        list_kube_customer_resources_param_shrink: str = None,
    ):
        # listKubeCustomerResourcesParam
        self.list_kube_customer_resources_param_shrink = list_kube_customer_resources_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_kube_customer_resources_param_shrink is not None:
            result['listKubeCustomerResourcesParam'] = self.list_kube_customer_resources_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listKubeCustomerResourcesParam') is not None:
            self.list_kube_customer_resources_param_shrink = m.get('listKubeCustomerResourcesParam')
        return self


class ListKubeCustomerResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class ListKubeNativeResourcesRequest(TeaModel):
    def __init__(
        self,
        list_kube_native_resources_param: ListKubeNativeResourcesParam = None,
    ):
        # listKubeNativeResourcesParam
        self.list_kube_native_resources_param = list_kube_native_resources_param

    def validate(self):
        if self.list_kube_native_resources_param:
            self.list_kube_native_resources_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_kube_native_resources_param is not None:
            result['listKubeNativeResourcesParam'] = self.list_kube_native_resources_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listKubeNativeResourcesParam') is not None:
            temp_model = ListKubeNativeResourcesParam()
            self.list_kube_native_resources_param = temp_model.from_map(m['listKubeNativeResourcesParam'])
        return self


class ListKubeNativeResourcesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_kube_native_resources_param_shrink: str = None,
    ):
        # listKubeNativeResourcesParam
        self.list_kube_native_resources_param_shrink = list_kube_native_resources_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_kube_native_resources_param_shrink is not None:
            result['listKubeNativeResourcesParam'] = self.list_kube_native_resources_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listKubeNativeResourcesParam') is not None:
            self.list_kube_native_resources_param_shrink = m.get('listKubeNativeResourcesParam')
        return self


class ListKubeNativeResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StringResponse = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StringResponse()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMainVersionsRequest(TeaModel):
    def __init__(
        self,
        list_main_versions_param: ListMainVersionsParam = None,
    ):
        self.list_main_versions_param = list_main_versions_param

    def validate(self):
        if self.list_main_versions_param:
            self.list_main_versions_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_main_versions_param is not None:
            result['listMainVersionsParam'] = self.list_main_versions_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listMainVersionsParam') is not None:
            temp_model = ListMainVersionsParam()
            self.list_main_versions_param = temp_model.from_map(m['listMainVersionsParam'])
        return self


class ListMainVersionsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_main_versions_param_shrink: str = None,
    ):
        self.list_main_versions_param_shrink = list_main_versions_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_main_versions_param_shrink is not None:
            result['listMainVersionsParam'] = self.list_main_versions_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listMainVersionsParam') is not None:
            self.list_main_versions_param_shrink = m.get('listMainVersionsParam')
        return self


class ListMainVersionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListMainVersionDTO] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListMainVersionDTO()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListMainVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMainVersionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMainVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNodeDisksRequest(TeaModel):
    def __init__(
        self,
        list_node_disk_param: ListNodeDiskParam = None,
    ):
        # listNodeDiskParam
        self.list_node_disk_param = list_node_disk_param

    def validate(self):
        if self.list_node_disk_param:
            self.list_node_disk_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_disk_param is not None:
            result['listNodeDiskParam'] = self.list_node_disk_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeDiskParam') is not None:
            temp_model = ListNodeDiskParam()
            self.list_node_disk_param = temp_model.from_map(m['listNodeDiskParam'])
        return self


class ListNodeDisksShrinkRequest(TeaModel):
    def __init__(
        self,
        list_node_disk_param_shrink: str = None,
    ):
        # listNodeDiskParam
        self.list_node_disk_param_shrink = list_node_disk_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_disk_param_shrink is not None:
            result['listNodeDiskParam'] = self.list_node_disk_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeDiskParam') is not None:
            self.list_node_disk_param_shrink = m.get('listNodeDiskParam')
        return self


class ListNodeDisksResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ClusterDisk] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # items
        self.items = items
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # totalCount
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ClusterDisk()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListNodeDisksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: ListNodeDisksResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # code
        self.code = code
        # message
        self.message = message
        # data
        self.data = data
        # requestId
        self.request_id = request_id
        # success
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('data') is not None:
            temp_model = ListNodeDisksResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListNodeDisksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListNodeDisksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListNodeDisksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNodeGroupMetaRequest(TeaModel):
    def __init__(
        self,
        list_node_group_meta_param: ListNodeGroupMetaParam = None,
    ):
        # listNodeGroupMetaParam
        self.list_node_group_meta_param = list_node_group_meta_param

    def validate(self):
        if self.list_node_group_meta_param:
            self.list_node_group_meta_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_group_meta_param is not None:
            result['listNodeGroupMetaParam'] = self.list_node_group_meta_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeGroupMetaParam') is not None:
            temp_model = ListNodeGroupMetaParam()
            self.list_node_group_meta_param = temp_model.from_map(m['listNodeGroupMetaParam'])
        return self


class ListNodeGroupMetaShrinkRequest(TeaModel):
    def __init__(
        self,
        list_node_group_meta_param_shrink: str = None,
    ):
        # listNodeGroupMetaParam
        self.list_node_group_meta_param_shrink = list_node_group_meta_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_group_meta_param_shrink is not None:
            result['listNodeGroupMetaParam'] = self.list_node_group_meta_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeGroupMetaParam') is not None:
            self.list_node_group_meta_param_shrink = m.get('listNodeGroupMetaParam')
        return self


class ListNodeGroupMetaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[NodeGroupMetaDTO] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        # List<NodeGroupMetaDTO>
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = NodeGroupMetaDTO()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListNodeGroupMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListNodeGroupMetaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListNodeGroupMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNodesRequest(TeaModel):
    def __init__(
        self,
        list_node_param: ListNodesParam = None,
    ):
        # listNodesParam
        self.list_node_param = list_node_param

    def validate(self):
        if self.list_node_param:
            self.list_node_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_param is not None:
            result['listNodeParam'] = self.list_node_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeParam') is not None:
            temp_model = ListNodesParam()
            self.list_node_param = temp_model.from_map(m['listNodeParam'])
        return self


class ListNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_node_param_shrink: str = None,
    ):
        # listNodesParam
        self.list_node_param_shrink = list_node_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_node_param_shrink is not None:
            result['listNodeParam'] = self.list_node_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listNodeParam') is not None:
            self.list_node_param_shrink = m.get('listNodeParam')
        return self


class ListNodesResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        auto_renew: bool = None,
        creator: str = None,
        data_disk_capacity: int = None,
        data_disk_count: int = None,
        data_disk_type: str = None,
        expire_time: int = None,
        fqdn: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        index: int = None,
        instance_type: str = None,
        modifier: str = None,
        node_group_id: str = None,
        node_group_type: str = None,
        node_id: str = None,
        node_name: str = None,
        node_resource_type: str = None,
        node_status: str = None,
        private_ip: str = None,
        public_ip: str = None,
        serial_number: str = None,
        system_disk_capacity: int = None,
        system_disk_type: str = None,
    ):
        # autoRenew
        self.auto_renew = auto_renew
        self.creator = creator
        self.data_disk_capacity = data_disk_capacity
        self.data_disk_count = data_disk_count
        self.data_disk_type = data_disk_type
        # expireTime
        self.expire_time = expire_time
        # fqdn
        self.fqdn = fqdn
        # gmtCreate
        self.gmt_create = gmt_create
        # gmtModified
        self.gmt_modified = gmt_modified
        # index
        self.index = index
        # instanceType
        self.instance_type = instance_type
        # modifier
        self.modifier = modifier
        # nodeGroupId
        self.node_group_id = node_group_id
        # nodeGroupType
        self.node_group_type = node_group_type
        # nodeId
        self.node_id = node_id
        # nodeName
        self.node_name = node_name
        # nodeResourceType
        self.node_resource_type = node_resource_type
        # nodeStatus
        self.node_status = node_status
        # privateIp
        self.private_ip = private_ip
        # publicIp
        self.public_ip = public_ip
        # serialNumber
        self.serial_number = serial_number
        self.system_disk_capacity = system_disk_capacity
        self.system_disk_type = system_disk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['autoRenew'] = self.auto_renew
        if self.creator is not None:
            result['creator'] = self.creator
        if self.data_disk_capacity is not None:
            result['dataDiskCapacity'] = self.data_disk_capacity
        if self.data_disk_count is not None:
            result['dataDiskCount'] = self.data_disk_count
        if self.data_disk_type is not None:
            result['dataDiskType'] = self.data_disk_type
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.fqdn is not None:
            result['fqdn'] = self.fqdn
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.index is not None:
            result['index'] = self.index
        if self.instance_type is not None:
            result['instanceType'] = self.instance_type
        if self.modifier is not None:
            result['modifier'] = self.modifier
        if self.node_group_id is not None:
            result['nodeGroupId'] = self.node_group_id
        if self.node_group_type is not None:
            result['nodeGroupType'] = self.node_group_type
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.node_resource_type is not None:
            result['nodeResourceType'] = self.node_resource_type
        if self.node_status is not None:
            result['nodeStatus'] = self.node_status
        if self.private_ip is not None:
            result['privateIp'] = self.private_ip
        if self.public_ip is not None:
            result['publicIp'] = self.public_ip
        if self.serial_number is not None:
            result['serialNumber'] = self.serial_number
        if self.system_disk_capacity is not None:
            result['systemDiskCapacity'] = self.system_disk_capacity
        if self.system_disk_type is not None:
            result['systemDiskType'] = self.system_disk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('autoRenew') is not None:
            self.auto_renew = m.get('autoRenew')
        if m.get('creator') is not None:
            self.creator = m.get('creator')
        if m.get('dataDiskCapacity') is not None:
            self.data_disk_capacity = m.get('dataDiskCapacity')
        if m.get('dataDiskCount') is not None:
            self.data_disk_count = m.get('dataDiskCount')
        if m.get('dataDiskType') is not None:
            self.data_disk_type = m.get('dataDiskType')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('fqdn') is not None:
            self.fqdn = m.get('fqdn')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('instanceType') is not None:
            self.instance_type = m.get('instanceType')
        if m.get('modifier') is not None:
            self.modifier = m.get('modifier')
        if m.get('nodeGroupId') is not None:
            self.node_group_id = m.get('nodeGroupId')
        if m.get('nodeGroupType') is not None:
            self.node_group_type = m.get('nodeGroupType')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('nodeResourceType') is not None:
            self.node_resource_type = m.get('nodeResourceType')
        if m.get('nodeStatus') is not None:
            self.node_status = m.get('nodeStatus')
        if m.get('privateIp') is not None:
            self.private_ip = m.get('privateIp')
        if m.get('publicIp') is not None:
            self.public_ip = m.get('publicIp')
        if m.get('serialNumber') is not None:
            self.serial_number = m.get('serialNumber')
        if m.get('systemDiskCapacity') is not None:
            self.system_disk_capacity = m.get('systemDiskCapacity')
        if m.get('systemDiskType') is not None:
            self.system_disk_type = m.get('systemDiskType')
        return self


class ListNodesResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListNodesResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListNodesResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListNodesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListNodesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListNodesResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListNodesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOnKubeDedicatedNodesRequest(TeaModel):
    def __init__(
        self,
        list_on_kube_dedicated_nodes_param: ListOnKubeDedicatedNodesParam = None,
    ):
        # listOnKubeDedicatedNodesParam
        self.list_on_kube_dedicated_nodes_param = list_on_kube_dedicated_nodes_param

    def validate(self):
        if self.list_on_kube_dedicated_nodes_param:
            self.list_on_kube_dedicated_nodes_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_on_kube_dedicated_nodes_param is not None:
            result['listOnKubeDedicatedNodesParam'] = self.list_on_kube_dedicated_nodes_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listOnKubeDedicatedNodesParam') is not None:
            temp_model = ListOnKubeDedicatedNodesParam()
            self.list_on_kube_dedicated_nodes_param = temp_model.from_map(m['listOnKubeDedicatedNodesParam'])
        return self


class ListOnKubeDedicatedNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        list_on_kube_dedicated_nodes_param_shrink: str = None,
    ):
        # listOnKubeDedicatedNodesParam
        self.list_on_kube_dedicated_nodes_param_shrink = list_on_kube_dedicated_nodes_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_on_kube_dedicated_nodes_param_shrink is not None:
            result['listOnKubeDedicatedNodesParam'] = self.list_on_kube_dedicated_nodes_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listOnKubeDedicatedNodesParam') is not None:
            self.list_on_kube_dedicated_nodes_param_shrink = m.get('listOnKubeDedicatedNodesParam')
        return self


class ListOnKubeDedicatedNodesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListOnKubeDedicatedNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOnKubeDedicatedNodesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOnKubeDedicatedNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListReportsRequest(TeaModel):
    def __init__(
        self,
        list_reports_param: ListReportsParam = None,
    ):
        self.list_reports_param = list_reports_param

    def validate(self):
        if self.list_reports_param:
            self.list_reports_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_reports_param is not None:
            result['listReportsParam'] = self.list_reports_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listReportsParam') is not None:
            temp_model = ListReportsParam()
            self.list_reports_param = temp_model.from_map(m['listReportsParam'])
        return self


class ListReportsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_reports_param_shrink: str = None,
    ):
        self.list_reports_param_shrink = list_reports_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_reports_param_shrink is not None:
            result['listReportsParam'] = self.list_reports_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listReportsParam') is not None:
            self.list_reports_param_shrink = m.get('listReportsParam')
        return self


class ListReportsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListReportsResult] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListReportsResult()
                self.data.append(temp_model.from_map(k))
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListReportsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListReportsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceHealthRequest(TeaModel):
    def __init__(
        self,
        list_resource_health_param: ListResourceHealthParam = None,
    ):
        # listResourceHealthParam
        self.list_resource_health_param = list_resource_health_param

    def validate(self):
        if self.list_resource_health_param:
            self.list_resource_health_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_resource_health_param is not None:
            result['listResourceHealthParam'] = self.list_resource_health_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listResourceHealthParam') is not None:
            temp_model = ListResourceHealthParam()
            self.list_resource_health_param = temp_model.from_map(m['listResourceHealthParam'])
        return self


class ListResourceHealthShrinkRequest(TeaModel):
    def __init__(
        self,
        list_resource_health_param_shrink: str = None,
    ):
        # listResourceHealthParam
        self.list_resource_health_param_shrink = list_resource_health_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_resource_health_param_shrink is not None:
            result['listResourceHealthParam'] = self.list_resource_health_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listResourceHealthParam') is not None:
            self.list_resource_health_param_shrink = m.get('listResourceHealthParam')
        return self


class ListResourceHealthResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        child_health_status_summary: HealthSummary = None,
        component_name: str = None,
        health_message: str = None,
        health_status: str = None,
        node_id: str = None,
        node_name: str = None,
        report_time: int = None,
    ):
        # 应用名
        self.application_name = application_name
        # 组件健康状态
        self.child_health_status_summary = child_health_status_summary
        # 组件名
        self.component_name = component_name
        # 健康信息
        self.health_message = health_message
        # 健康状态
        self.health_status = health_status
        # 节点id
        self.node_id = node_id
        # 节点名称
        self.node_name = node_name
        # 汇报时间
        self.report_time = report_time

    def validate(self):
        if self.child_health_status_summary:
            self.child_health_status_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.child_health_status_summary is not None:
            result['childHealthStatusSummary'] = self.child_health_status_summary.to_map()
        if self.component_name is not None:
            result['componentName'] = self.component_name
        if self.health_message is not None:
            result['healthMessage'] = self.health_message
        if self.health_status is not None:
            result['healthStatus'] = self.health_status
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.report_time is not None:
            result['reportTime'] = self.report_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('childHealthStatusSummary') is not None:
            temp_model = HealthSummary()
            self.child_health_status_summary = temp_model.from_map(m['childHealthStatusSummary'])
        if m.get('componentName') is not None:
            self.component_name = m.get('componentName')
        if m.get('healthMessage') is not None:
            self.health_message = m.get('healthMessage')
        if m.get('healthStatus') is not None:
            self.health_status = m.get('healthStatus')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('reportTime') is not None:
            self.report_time = m.get('reportTime')
        return self


class ListResourceHealthResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[ListResourceHealthResponseBodyDataItems] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.items = items
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListResourceHealthResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class ListResourceHealthResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListResourceHealthResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = ListResourceHealthResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class ListResourceHealthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceHealthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceHealthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceHealthInspectionsRequest(TeaModel):
    def __init__(
        self,
        list_resource_health_inspections_param: ListResourceHealthParam = None,
    ):
        # listResourceHealthInspectionsParam
        self.list_resource_health_inspections_param = list_resource_health_inspections_param

    def validate(self):
        if self.list_resource_health_inspections_param:
            self.list_resource_health_inspections_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_resource_health_inspections_param is not None:
            result['listResourceHealthInspectionsParam'] = self.list_resource_health_inspections_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listResourceHealthInspectionsParam') is not None:
            temp_model = ListResourceHealthParam()
            self.list_resource_health_inspections_param = temp_model.from_map(m['listResourceHealthInspectionsParam'])
        return self


class ListResourceHealthInspectionsShrinkRequest(TeaModel):
    def __init__(
        self,
        list_resource_health_inspections_param_shrink: str = None,
    ):
        # listResourceHealthInspectionsParam
        self.list_resource_health_inspections_param_shrink = list_resource_health_inspections_param_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list_resource_health_inspections_param_shrink is not None:
            result['listResourceHealthInspectionsParam'] = self.list_resource_health_inspections_param_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('listResourceHealthInspectionsParam') is not None:
            self.list_resource_health_inspections_param_shrink = m.get('listResourceHealthInspectionsParam')
        return self


class ListResourceHealthInspectionsResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        component_name: str = None,
        health_message: str = None,
        health_status: str = None,
        inspection_name: str = None,
        node_id: str = None,
        node_name: str = None,
        report_time: int = None,
        rule_name: str = None,
    ):
        # 应用名
        self.application_name = application_name
        # 组件名
        self.component_name = component_name
        # 健康信息
        self.health_message = health_message
        # 健康状态
        self.health_status = health_status
        # 巡检项名称
        self.inspection_name = inspection_name
        # 节点id
        self.node_id = node_id
        # 节点名称
        self.node_name = node_name
        # 汇报时间
        self.report_time = report_time
        # 巡检规则名称
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.component_name is not None:
      