"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3PutObjectAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const case_1 = require("case");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon S3 bucket.
 */
class S3PutObjectAction {
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_S3PutObjectActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3PutObjectAction);
            }
            throw error;
        }
        this.accessControl = props.accessControl;
        this.key = props.key;
        this.role = props.role;
    }
    bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            resources: [this.bucket.arnForObjects('*')],
        }));
        return {
            configuration: {
                s3: {
                    bucketName: this.bucket.bucketName,
                    cannedAcl: this.accessControl && case_1.kebab(this.accessControl.toString()),
                    key: this.key ?? '${topic()}/${timestamp()}',
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.S3PutObjectAction = S3PutObjectAction;
_a = JSII_RTTI_SYMBOL_1;
S3PutObjectAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.S3PutObjectAction", version: "1.181.1" };
//# sourceMappingURL=data:application/json;base64,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