"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lunrMutableIndexes = _interopRequireDefault(require("lunr-mutable-indexes"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Handle the search Indexer.
 */
class Search {
  // @ts-ignore

  /**
   * Constructor.
   */
  constructor() {
    _defineProperty(this, "index", void 0);

    _defineProperty(this, "storage", void 0);

    this.index = (0, _lunrMutableIndexes.default)(function () {
      // FIXME: there is no types for this library

      /* eslint no-invalid-this:off */
      // @ts-ignore
      this.field('name', {
        boost: 10
      }); // @ts-ignore

      this.field('description', {
        boost: 4
      }); // @ts-ignore

      this.field('author', {
        boost: 6
      }); // @ts-ignore

      this.field('keywords', {
        boost: 7
      }); // @ts-ignore

      this.field('version'); // @ts-ignore

      this.field('readme');
    });
  }
  /**
   * Performs a query to the indexer.
   * If the keyword is a * it returns all local elements
   * otherwise performs a search
   * @param {*} q the keyword
   * @return {Array} list of results.
   */


  query(query) {
    const localStorage = this.storage.localStorage;
    const hasScope = query.startsWith('@'); // FIXME: lunr-mutable-indexes ignored '@' during indexing

    if (hasScope) {
      query = query.replace('@', '');
    }

    const results = query === '*' ? localStorage.storagePlugin.get(items => {
      items.map(function (pkg) {
        return {
          ref: pkg,
          score: 1
        };
      });
    }) : this.index.search(`*${query}*`);
    return hasScope ? results.filter(({
      ref
    }) => ref.startsWith('@')) : results;
  }
  /**
   * Add a new element to index
   * @param {*} pkg the package
   */


  add(pkg) {
    this.index.add({
      id: pkg.name,
      name: pkg.name,
      description: pkg.description,
      version: `v${pkg.version}`,
      keywords: pkg.keywords,
      author: pkg._npmUser ? pkg._npmUser.name : '???'
    });
  }
  /**
   * Remove an element from the index.
   * @param {*} name the id element
   */


  remove(name) {
    this.index.remove({
      id: name
    });
  }
  /**
   * Force a re-index.
   */


  reindex() {
    this.storage.getLocalDatabase((error, packages) => {
      if (error) {
        // that function shouldn't produce any
        throw error;
      }

      let i = packages.length;

      while (i--) {
        this.add(packages[i]);
      }
    });
  }
  /**
   * Set up the {Storage}
   * @param {*} storage An storage reference.
   */


  configureStorage(storage) {
    this.storage = storage;
    this.reindex();
  }

}

var _default = new Search();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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