"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notifyRequest = notifyRequest;

var _debug = _interopRequireDefault(require("debug"));

var _isNil = _interopRequireDefault(require("lodash/isNil"));

var _request = _interopRequireDefault(require("request"));

var _constants = require("../constants");

var _logger = require("../logger");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = (0, _debug.default)('verdaccio:notify-request');

function notifyRequest(options, content) {
  return new Promise((resolve, reject) => {
    (0, _request.default)(options, function (err, response, body) {
      if (err || response.statusCode >= _constants.HTTP_STATUS.BAD_REQUEST) {
        const errorMessage = (0, _isNil.default)(err) ? response.body : err.message;

        _logger.logger.error({
          errorMessage
        }, 'notify service has thrown an error: @{errorMessage}');

        reject(errorMessage);
      }

      _logger.logger.info({
        content
      }, 'A notification has been shipped: @{content}');

      if ((0, _isNil.default)(body) === false) {
        _logger.logger.debug({
          body
        }, ' body: @{body}');

        resolve(body);
      }

      reject(Error('body is missing'));
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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