"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleNotify = handleNotify;
exports.notify = notify;
exports.sendNotification = sendNotification;

var _handlebars = _interopRequireDefault(require("handlebars"));

var _lodash = _interopRequireDefault(require("lodash"));

var _notifyRequest = require("./notify-request");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function handleNotify(metadata, notifyEntry, remoteUser, publishedPackage) {
  let regex;

  if (metadata.name && notifyEntry.packagePattern) {
    regex = new RegExp(notifyEntry.packagePattern, notifyEntry.packagePatternFlags || '');

    if (!regex.test(metadata.name)) {
      return;
    }
  }

  const template = _handlebars.default.compile(notifyEntry.content); // don't override 'publisher' if package.json already has that

  /* eslint no-unused-vars: 0 */

  /* eslint @typescript-eslint/no-unused-vars: 0 */
  // @ts-ignore


  if (_lodash.default.isNil(metadata.publisher)) {
    // @ts-ignore
    metadata = _objectSpread(_objectSpread({}, metadata), {}, {
      publishedPackage,
      publisher: {
        name: remoteUser.name
      }
    });
  }

  const content = template(metadata);
  const options = {
    body: content,
    url: ''
  }; // provides fallback support, it's accept an Object {} and Array of {}

  if (notifyEntry.headers && _lodash.default.isArray(notifyEntry.headers)) {
    const header = {};
    notifyEntry.headers.map(function (item) {
      if (Object.is(item, item)) {
        for (const key in item) {
          /* eslint no-prototype-builtins: 0 */
          if (item.hasOwnProperty(key)) {
            header[key] = item[key];
          }
        }
      }
    });
    options.headers = header;
  } else if (Object.is(notifyEntry.headers, notifyEntry.headers)) {
    options.headers = notifyEntry.headers;
  }

  options.method = notifyEntry.method;

  if (notifyEntry.endpoint) {
    options.url = notifyEntry.endpoint;
  }

  return (0, _notifyRequest.notifyRequest)(options, content);
}

function sendNotification(metadata, notify, remoteUser, publishedPackage) {
  return handleNotify(metadata, notify, remoteUser, publishedPackage);
}

function notify(metadata, config, remoteUser, publishedPackage) {
  if (config.notify) {
    // @ts-ignore
    if (config.notify.content) {
      return sendNotification(metadata, config.notify, remoteUser, publishedPackage);
    } // multiple notifications endpoints PR #108


    return Promise.all(_lodash.default.map(config.notify, key => sendNotification(metadata, key, remoteUser, publishedPackage)));
  }

  return Promise.resolve();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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