"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateLevel = calculateLevel;
exports.subSystemLevels = exports.levelsColors = void 0;

var _kleur = require("kleur");

function calculateLevel(levelCode) {
  switch (true) {
    case levelCode === 10:
      return 'trace';

    case levelCode === 20:
      return 'debug';

    case levelCode === 25:
      return 'http';

    case levelCode === 30:
      return 'info';

    case levelCode === 40:
      return 'warn';

    case levelCode === 50:
      return 'error';

    case levelCode === 60:
      return 'fatal';

    default:
      return 'fatal';
  }
}

const levelsColors = {
  fatal: _kleur.red,
  error: _kleur.red,
  warn: _kleur.yellow,
  http: _kleur.magenta,
  info: _kleur.cyan,
  debug: _kleur.green,
  trace: _kleur.white
};
exports.levelsColors = levelsColors;
var ARROWS;

(function (ARROWS) {
  ARROWS["LEFT"] = "<--";
  ARROWS["RIGHT"] = "-->";
  ARROWS["EQUAL"] = "-=-";
  ARROWS["NEUTRAL"] = "---";
})(ARROWS || (ARROWS = {}));

const subSystemLevels = {
  color: {
    in: (0, _kleur.green)(ARROWS.LEFT),
    out: (0, _kleur.yellow)(ARROWS.RIGHT),
    fs: (0, _kleur.black)(ARROWS.EQUAL),
    default: (0, _kleur.blue)(ARROWS.NEUTRAL)
  },
  white: {
    in: ARROWS.LEFT,
    out: ARROWS.RIGHT,
    fs: ARROWS.EQUAL,
    default: ARROWS.NEUTRAL
  }
};
exports.subSystemLevels = subSystemLevels;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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