"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FORMAT_DATE = exports.CUSTOM_PAD_LENGTH = void 0;
exports.fillInMsgTemplate = fillInMsgTemplate;
exports.formatLoggingDate = formatLoggingDate;
exports.isObject = isObject;
exports.printMessage = printMessage;

var _dayjs = _interopRequireDefault(require("dayjs"));

var _kleur = require("kleur");

var _lodash = _interopRequireDefault(require("lodash"));

var _util = require("util");

var _levels = require("../levels");

var _utils = require("../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const CUSTOM_PAD_LENGTH = 1;
exports.CUSTOM_PAD_LENGTH = CUSTOM_PAD_LENGTH;
const FORMAT_DATE = 'YYYY-MM-DD HH:mm:ss';
exports.FORMAT_DATE = FORMAT_DATE;

function isObject(obj) {
  return _lodash.default.isObject(obj) && _lodash.default.isNull(obj) === false && _lodash.default.isArray(obj) === false;
}

function formatLoggingDate(time, message) {
  const timeFormatted = (0, _dayjs.default)(time).format(FORMAT_DATE);
  return `[${timeFormatted}]${message}`;
}

let LEVEL_VALUE_MAX = 0; // eslint-disable-next-line guard-for-in

for (const l in _levels.levelsColors) {
  LEVEL_VALUE_MAX = Math.max(LEVEL_VALUE_MAX, l.length);
}

const ERROR_FLAG = '!';

function fillInMsgTemplate(msg, templateOptions, colors) {
  const templateRegex = /@{(!?[$A-Za-z_][$0-9A-Za-z\._]*)}/g;
  return msg.replace(templateRegex, (_, name) => {
    let str = templateOptions;
    let isError;

    if (name[0] === ERROR_FLAG) {
      name = name.substr(1);
      isError = true;
    } // object can be @{foo.bar.}


    const listAccessors = name.split('.');

    for (let property = 0; property < listAccessors.length; property++) {
      const id = listAccessors[property];

      if (isObject(str)) {
        str = str[id];
      }
    }

    if (typeof str === 'string') {
      if (colors === false || str.includes('\n')) {
        return str;
      } else if (isError) {
        return (0, _kleur.red)(str);
      }

      return (0, _kleur.green)(str);
    } // object, showHidden, depth, colors


    return (0, _util.inspect)(str, undefined, null, colors);
  });
}

function getMessage(debugLevel, msg, sub, templateObjects, hasColors) {
  const finalMessage = fillInMsgTemplate(msg, templateObjects, hasColors);
  const subSystemType = _levels.subSystemLevels.color[sub !== null && sub !== void 0 ? sub : 'default'];

  if (hasColors) {
    const logString = `${_levels.levelsColors[debugLevel]((0, _utils.padRight)(debugLevel, LEVEL_VALUE_MAX))}${(0, _kleur.white)(`${subSystemType} ${finalMessage}`)}`;
    return (0, _utils.padLeft)(logString);
  }

  const logString = `${(0, _utils.padRight)(debugLevel, LEVEL_VALUE_MAX)}${subSystemType} ${finalMessage}`;
  return (0, _utils.padRight)(logString);
}

function printMessage(templateObjects, options, hasColors = true) {
  const {
    prettyStamp
  } = options;
  const {
    level,
    msg,
    sub
  } = templateObjects;
  const debugLevel = (0, _levels.calculateLevel)(level);
  const logMessage = getMessage(debugLevel, msg, sub, templateObjects, hasColors);
  return prettyStamp ? formatLoggingDate(templateObjects.time, logMessage) : logMessage;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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