"use strict";

var _prettifier = require("./prettifier");

/*
 options eg:
 { messageKey: 'msg', levelFirst: true, prettyStamp: false }
 */
module.exports = function prettyFactory(options) {
  // the break line must happens in the prettify component
  const breakLike = '\n';
  return inputData => {
    return (0, _prettifier.printMessage)(inputData, options, options.colors) + breakLike;
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJtb2R1bGUiLCJleHBvcnRzIiwicHJldHR5RmFjdG9yeSIsIm9wdGlvbnMiLCJicmVha0xpa2UiLCJpbnB1dERhdGEiLCJwcmludE1lc3NhZ2UiLCJjb2xvcnMiXSwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2xvZ2dlci9mb3JtYXR0ZXIvaW5kZXgudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUHJldHR5T3B0aW9uc0V4dGVuZGVkLCBwcmludE1lc3NhZ2UgfSBmcm9tICcuL3ByZXR0aWZpZXInO1xuXG5leHBvcnQgdHlwZSBQcmV0dHlGYWN0b3J5ID0gKHBhcmFtKSA9PiBzdHJpbmc7XG5cbi8qXG4gb3B0aW9ucyBlZzpcbiB7IG1lc3NhZ2VLZXk6ICdtc2cnLCBsZXZlbEZpcnN0OiB0cnVlLCBwcmV0dHlTdGFtcDogZmFsc2UgfVxuICovXG5cbm1vZHVsZS5leHBvcnRzID0gZnVuY3Rpb24gcHJldHR5RmFjdG9yeShvcHRpb25zOiBQcmV0dHlPcHRpb25zRXh0ZW5kZWQpOiBQcmV0dHlGYWN0b3J5IHtcbiAgLy8gdGhlIGJyZWFrIGxpbmUgbXVzdCBoYXBwZW5zIGluIHRoZSBwcmV0dGlmeSBjb21wb25lbnRcbiAgY29uc3QgYnJlYWtMaWtlID0gJ1xcbic7XG4gIHJldHVybiAoaW5wdXREYXRhKTogc3RyaW5nID0+IHtcbiAgICByZXR1cm4gcHJpbnRNZXNzYWdlKGlucHV0RGF0YSwgb3B0aW9ucywgb3B0aW9ucy5jb2xvcnMpICsgYnJlYWtMaWtlO1xuICB9O1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUVBQSxNQUFNLENBQUNDLE9BQVAsR0FBaUIsU0FBU0MsYUFBVCxDQUF1QkMsT0FBdkIsRUFBc0U7RUFDckY7RUFDQSxNQUFNQyxTQUFTLEdBQUcsSUFBbEI7RUFDQSxPQUFRQyxTQUFELElBQXVCO0lBQzVCLE9BQU8sSUFBQUMsd0JBQUEsRUFBYUQsU0FBYixFQUF3QkYsT0FBeEIsRUFBaUNBLE9BQU8sQ0FBQ0ksTUFBekMsSUFBbURILFNBQTFEO0VBQ0QsQ0FGRDtBQUdELENBTkQifQ==