"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _assert = _interopRequireDefault(require("assert"));

var _lodash = _interopRequireDefault(require("lodash"));

var _authUtils = require("./auth-utils");

var _configUtils = require("./config-utils");

var _constants = require("./constants");

var _cryptoUtils = require("./crypto-utils");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const LoggerApi = require('./logger');

const strategicConfigProps = ['uplinks', 'packages'];
const allowedEnvConfig = ['http_proxy', 'https_proxy', 'no_proxy'];
/**
 * Coordinates the application configuration
 */

class Config {
  // @ts-ignore
  // @ts-ignore
  // @ts-ignore
  constructor(config) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "user_agent", void 0);

    _defineProperty(this, "secret", void 0);

    _defineProperty(this, "uplinks", void 0);

    _defineProperty(this, "packages", void 0);

    _defineProperty(this, "users", void 0);

    _defineProperty(this, "userRateLimit", void 0);

    _defineProperty(this, "server_id", void 0);

    _defineProperty(this, "self_path", void 0);

    _defineProperty(this, "storage", void 0);

    _defineProperty(this, "plugins", void 0);

    _defineProperty(this, "security", void 0);

    const self = this;
    this.logger = LoggerApi.logger;
    this.self_path = config.self_path;
    this.storage = process.env.VERDACCIO_STORAGE_PATH || config.storage;
    this.plugins = config.plugins;

    for (const configProp in config) {
      if (self[configProp] == null) {
        self[configProp] = config[configProp];
      }
    }

    if (config !== null && config !== void 0 && config.user_agent) {
      this.user_agent = (0, _utils.getUserAgent)(config === null || config === void 0 ? void 0 : config.user_agent);
    }

    this.userRateLimit = _objectSpread(_objectSpread({}, _authUtils.defaultUserRateLimiting), config === null || config === void 0 ? void 0 : config.userRateLimit); // some weird shell scripts are valid yaml files parsed as string

    (0, _assert.default)(_lodash.default.isObject(config), _constants.APP_ERROR.CONFIG_NOT_VALID); // sanity check for strategic config properties

    strategicConfigProps.forEach(function (x) {
      if (self[x] == null) {
        self[x] = {};
      }

      (0, _assert.default)((0, _utils.isObject)(self[x]), `CONFIG: bad "${x}" value (object expected)`);
    });
    this.uplinks = (0, _configUtils.sanityCheckUplinksProps)((0, _configUtils.uplinkSanityCheck)(this.uplinks));

    if (_lodash.default.isNil(this.users) === false) {
      this.logger.warn(`[users]: property on configuration file
      is not longer supported, property being ignored`);
    }

    this.packages = (0, _configUtils.normalisePackageAccess)(self.packages); // loading these from ENV if aren't in config

    allowedEnvConfig.forEach(envConf => {
      if (!(envConf in self)) {
        self[envConf] = process.env[envConf] || process.env[envConf.toUpperCase()];
      }
    }); // unique identifier of self server (or a cluster), used to avoid loops
    // @ts-ignore

    if (!this.server_id) {
      this.server_id = (0, _cryptoUtils.generateRandomHexString)(6);
    }
  }
  /**
   * Check for package spec
   */


  getMatchedPackagesSpec(pkgName) {
    return (0, _configUtils.getMatchedPackagesSpec)(pkgName, this.packages);
  }
  /**
   * Store or create whether receive a secret key
   */


  checkSecretKey(secret) {
    if (_lodash.default.isString(secret) && _lodash.default.isEmpty(secret) === false) {
      this.secret = secret;
      return secret;
    } // it generates a secret key
    // FUTURE: this might be an external secret key, perhaps within config file?


    this.secret = (0, _cryptoUtils.generateRandomHexString)(32);
    return this.secret;
  }

}

var _default = Config;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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