"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_NODE_VERSION = void 0;
exports.getListListenAddresses = getListListenAddresses;
exports.isVersionValid = isVersionValid;
exports.resolveConfigPath = void 0;

var _path = _interopRequireDefault(require("path"));

var _semver = _interopRequireDefault(require("semver"));

var _constants = require("../constants");

var _utils = require("../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const logger = require('../logger');

const resolveConfigPath = function (storageLocation, file) {
  return _path.default.resolve(_path.default.dirname(storageLocation), file);
};

exports.resolveConfigPath = resolveConfigPath;
const MIN_NODE_VERSION = '12';
exports.MIN_NODE_VERSION = MIN_NODE_VERSION;

function isVersionValid(version) {
  return _semver.default.satisfies(version, `>=${MIN_NODE_VERSION}`);
}
/**
 * Retrieve all addresses defined in the config file.
 * Verdaccio is able to listen multiple ports
 * @param {String} argListen
 * @param {String} configListen
 * eg:
 *  listen:
 - localhost:5555
 - localhost:5557
 @return {Array}
 */


function getListListenAddresses(argListen, configListen) {
  // command line || config file || default
  let addresses;

  if (argListen) {
    addresses = [argListen];
  } else if (Array.isArray(configListen)) {
    addresses = configListen;
    process.emitWarning('multiple addresses will be deprecated in the next major, only use one');
  } else if (configListen) {
    addresses = [configListen];
  } else {
    addresses = [_constants.DEFAULT_PORT];
  }

  addresses = addresses.map(function (addr) {
    const parsedAddr = (0, _utils.parseAddress)(addr);

    if (!parsedAddr) {
      logger.logger.warn({
        addr: addr
      }, 'invalid address - @{addr}, we expect a port (e.g. "4873"),' + ' host:port (e.g. "localhost:4873") or full url' + ' (e.g. "http://localhost:4873/")');
    }

    return parsedAddr;
  }).filter(Boolean);
  return addresses;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJsb2dnZXIiLCJyZXF1aXJlIiwicmVzb2x2ZUNvbmZpZ1BhdGgiLCJzdG9yYWdlTG9jYXRpb24iLCJmaWxlIiwicGF0aCIsInJlc29sdmUiLCJkaXJuYW1lIiwiTUlOX05PREVfVkVSU0lPTiIsImlzVmVyc2lvblZhbGlkIiwidmVyc2lvbiIsInNlbXZlciIsInNhdGlzZmllcyIsImdldExpc3RMaXN0ZW5BZGRyZXNzZXMiLCJhcmdMaXN0ZW4iLCJjb25maWdMaXN0ZW4iLCJhZGRyZXNzZXMiLCJBcnJheSIsImlzQXJyYXkiLCJwcm9jZXNzIiwiZW1pdFdhcm5pbmciLCJERUZBVUxUX1BPUlQiLCJtYXAiLCJhZGRyIiwicGFyc2VkQWRkciIsInBhcnNlQWRkcmVzcyIsIndhcm4iLCJmaWx0ZXIiLCJCb29sZWFuIl0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9jbGkvdXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgc2VtdmVyIGZyb20gJ3NlbXZlcic7XG5cbmltcG9ydCB7IERFRkFVTFRfUE9SVCB9IGZyb20gJy4uL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBwYXJzZUFkZHJlc3MgfSBmcm9tICcuLi91dGlscyc7XG5cbmNvbnN0IGxvZ2dlciA9IHJlcXVpcmUoJy4uL2xvZ2dlcicpO1xuXG5leHBvcnQgY29uc3QgcmVzb2x2ZUNvbmZpZ1BhdGggPSBmdW5jdGlvbiAoc3RvcmFnZUxvY2F0aW9uOiBzdHJpbmcsIGZpbGU6IHN0cmluZykge1xuICByZXR1cm4gcGF0aC5yZXNvbHZlKHBhdGguZGlybmFtZShzdG9yYWdlTG9jYXRpb24pLCBmaWxlKTtcbn07XG5cbmV4cG9ydCBjb25zdCBNSU5fTk9ERV9WRVJTSU9OID0gJzEyJztcblxuZXhwb3J0IGZ1bmN0aW9uIGlzVmVyc2lvblZhbGlkKHZlcnNpb24pIHtcbiAgcmV0dXJuIHNlbXZlci5zYXRpc2ZpZXModmVyc2lvbiwgYD49JHtNSU5fTk9ERV9WRVJTSU9OfWApO1xufVxuXG4vKipcbiAqIFJldHJpZXZlIGFsbCBhZGRyZXNzZXMgZGVmaW5lZCBpbiB0aGUgY29uZmlnIGZpbGUuXG4gKiBWZXJkYWNjaW8gaXMgYWJsZSB0byBsaXN0ZW4gbXVsdGlwbGUgcG9ydHNcbiAqIEBwYXJhbSB7U3RyaW5nfSBhcmdMaXN0ZW5cbiAqIEBwYXJhbSB7U3RyaW5nfSBjb25maWdMaXN0ZW5cbiAqIGVnOlxuICogIGxpc3RlbjpcbiAtIGxvY2FsaG9zdDo1NTU1XG4gLSBsb2NhbGhvc3Q6NTU1N1xuIEByZXR1cm4ge0FycmF5fVxuICovXG5leHBvcnQgZnVuY3Rpb24gZ2V0TGlzdExpc3RlbkFkZHJlc3NlcyhhcmdMaXN0ZW46IHN0cmluZyB8IHZvaWQsIGNvbmZpZ0xpc3RlbjogYW55KTogYW55IHtcbiAgLy8gY29tbWFuZCBsaW5lIHx8IGNvbmZpZyBmaWxlIHx8IGRlZmF1bHRcbiAgbGV0IGFkZHJlc3NlcztcbiAgaWYgKGFyZ0xpc3Rlbikge1xuICAgIGFkZHJlc3NlcyA9IFthcmdMaXN0ZW5dO1xuICB9IGVsc2UgaWYgKEFycmF5LmlzQXJyYXkoY29uZmlnTGlzdGVuKSkge1xuICAgIGFkZHJlc3NlcyA9IGNvbmZpZ0xpc3RlbjtcbiAgICBwcm9jZXNzLmVtaXRXYXJuaW5nKCdtdWx0aXBsZSBhZGRyZXNzZXMgd2lsbCBiZSBkZXByZWNhdGVkIGluIHRoZSBuZXh0IG1ham9yLCBvbmx5IHVzZSBvbmUnKTtcbiAgfSBlbHNlIGlmIChjb25maWdMaXN0ZW4pIHtcbiAgICBhZGRyZXNzZXMgPSBbY29uZmlnTGlzdGVuXTtcbiAgfSBlbHNlIHtcbiAgICBhZGRyZXNzZXMgPSBbREVGQVVMVF9QT1JUXTtcbiAgfVxuICBhZGRyZXNzZXMgPSBhZGRyZXNzZXNcbiAgICAubWFwKGZ1bmN0aW9uIChhZGRyKTogc3RyaW5nIHtcbiAgICAgIGNvbnN0IHBhcnNlZEFkZHIgPSBwYXJzZUFkZHJlc3MoYWRkcik7XG5cbiAgICAgIGlmICghcGFyc2VkQWRkcikge1xuICAgICAgICBsb2dnZXIubG9nZ2VyLndhcm4oXG4gICAgICAgICAgeyBhZGRyOiBhZGRyIH0sXG4gICAgICAgICAgJ2ludmFsaWQgYWRkcmVzcyAtIEB7YWRkcn0sIHdlIGV4cGVjdCBhIHBvcnQgKGUuZy4gXCI0ODczXCIpLCcgKyAnIGhvc3Q6cG9ydCAoZS5nLiBcImxvY2FsaG9zdDo0ODczXCIpIG9yIGZ1bGwgdXJsJyArICcgKGUuZy4gXCJodHRwOi8vbG9jYWxob3N0OjQ4NzMvXCIpJ1xuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICByZXR1cm4gcGFyc2VkQWRkcjtcbiAgICB9KVxuICAgIC5maWx0ZXIoQm9vbGVhbik7XG5cbiAgcmV0dXJuIGFkZHJlc3Nlcztcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUVBOztBQUNBOzs7O0FBRUEsTUFBTUEsTUFBTSxHQUFHQyxPQUFPLENBQUMsV0FBRCxDQUF0Qjs7QUFFTyxNQUFNQyxpQkFBaUIsR0FBRyxVQUFVQyxlQUFWLEVBQW1DQyxJQUFuQyxFQUFpRDtFQUNoRixPQUFPQyxhQUFBLENBQUtDLE9BQUwsQ0FBYUQsYUFBQSxDQUFLRSxPQUFMLENBQWFKLGVBQWIsQ0FBYixFQUE0Q0MsSUFBNUMsQ0FBUDtBQUNELENBRk07OztBQUlBLE1BQU1JLGdCQUFnQixHQUFHLElBQXpCOzs7QUFFQSxTQUFTQyxjQUFULENBQXdCQyxPQUF4QixFQUFpQztFQUN0QyxPQUFPQyxlQUFBLENBQU9DLFNBQVAsQ0FBaUJGLE9BQWpCLEVBQTJCLEtBQUlGLGdCQUFpQixFQUFoRCxDQUFQO0FBQ0Q7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7QUFDTyxTQUFTSyxzQkFBVCxDQUFnQ0MsU0FBaEMsRUFBMERDLFlBQTFELEVBQWtGO0VBQ3ZGO0VBQ0EsSUFBSUMsU0FBSjs7RUFDQSxJQUFJRixTQUFKLEVBQWU7SUFDYkUsU0FBUyxHQUFHLENBQUNGLFNBQUQsQ0FBWjtFQUNELENBRkQsTUFFTyxJQUFJRyxLQUFLLENBQUNDLE9BQU4sQ0FBY0gsWUFBZCxDQUFKLEVBQWlDO0lBQ3RDQyxTQUFTLEdBQUdELFlBQVo7SUFDQUksT0FBTyxDQUFDQyxXQUFSLENBQW9CLHVFQUFwQjtFQUNELENBSE0sTUFHQSxJQUFJTCxZQUFKLEVBQWtCO0lBQ3ZCQyxTQUFTLEdBQUcsQ0FBQ0QsWUFBRCxDQUFaO0VBQ0QsQ0FGTSxNQUVBO0lBQ0xDLFNBQVMsR0FBRyxDQUFDSyx1QkFBRCxDQUFaO0VBQ0Q7O0VBQ0RMLFNBQVMsR0FBR0EsU0FBUyxDQUNsQk0sR0FEUyxDQUNMLFVBQVVDLElBQVYsRUFBd0I7SUFDM0IsTUFBTUMsVUFBVSxHQUFHLElBQUFDLG1CQUFBLEVBQWFGLElBQWIsQ0FBbkI7O0lBRUEsSUFBSSxDQUFDQyxVQUFMLEVBQWlCO01BQ2Z4QixNQUFNLENBQUNBLE1BQVAsQ0FBYzBCLElBQWQsQ0FDRTtRQUFFSCxJQUFJLEVBQUVBO01BQVIsQ0FERixFQUVFLCtEQUErRCxnREFBL0QsR0FBa0gsa0NBRnBIO0lBSUQ7O0lBRUQsT0FBT0MsVUFBUDtFQUNELENBWlMsRUFhVEcsTUFiUyxDQWFGQyxPQWJFLENBQVo7RUFlQSxPQUFPWixTQUFQO0FBQ0QifQ==