"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitCommand = exports.DEFAULT_PROCESS_NAME = void 0;

var _clipanion = require("clipanion");

var _path = _interopRequireDefault(require("path"));

var _bootstrap = require("../../bootstrap");

var _configPath = _interopRequireDefault(require("../../config-path"));

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

require('pkginfo')(module);

const pkgVersion = module.exports.version;
const pkgName = module.exports.name;
const DEFAULT_PROCESS_NAME = 'verdaccio';
exports.DEFAULT_PROCESS_NAME = DEFAULT_PROCESS_NAME;

const logger = require('../../logger');

class InitCommand extends _clipanion.Command {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "listen", _clipanion.Option.String('-l,--listen', {
      description: 'host:port number to listen on (default: localhost:4873)'
    }));

    _defineProperty(this, "config", _clipanion.Option.String('-c,--config', {
      description: 'use this configuration file (default: ./config.yaml)'
    }));
  }

  async execute() {
    let configPathLocation;

    try {
      configPathLocation = (0, _configPath.default)(this.config);
      const verdaccioConfiguration = (0, _utils.parseConfigFile)(configPathLocation);

      if (!verdaccioConfiguration.self_path) {
        verdaccioConfiguration.self_path = _path.default.resolve(configPathLocation);
      }

      if (!verdaccioConfiguration.https) {
        verdaccioConfiguration.https = {
          enable: false
        };
      }

      logger.logger.warn({
        file: configPathLocation
      }, 'config file  - @{file}');
      process.title = verdaccioConfiguration.web && verdaccioConfiguration.web.title || 'verdaccio';
      (0, _bootstrap.startVerdaccio)(verdaccioConfiguration, this.listen, configPathLocation, pkgVersion, pkgName, _bootstrap.listenDefaultCallback);
    } catch (err) {
      logger.logger.fatal({
        file: configPathLocation,
        err: err
      }, 'cannot open config file @{file}: @{!err.message}');
      process.exit(1);
    }
  }

}

exports.InitCommand = InitCommand;

_defineProperty(InitCommand, "paths", [_clipanion.Command.Default]);

_defineProperty(InitCommand, "usage", _clipanion.Command.Usage({
  description: `launch the server`,
  details: `
      This start the registry in the default port.

      When used without arguments, it:

      - bootstrap the server at the port  \`4873\`

      The optional arguments are:

      - \`--listen\` to switch the default server port,
      - \`--config\` to define a different configuration path location,

    `,
  examples: [[`Runs the server with the default configuration`, `verdaccio`], [`Runs the server in the port 5000`, `verdaccio --listen 5000`], [`Runs the server by using a different absolute location of the configuration file`, `verdaccio --config /home/user/verdaccio/config.yaml`]]
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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