"use strict";

var _clipanion = require("clipanion");

var _info = require("./commands/info");

var _init = require("./commands/init");

var _version = require("./commands/version");

var _utils = require("./utils");

require('pkginfo')(module);

const pkgVersion = module.exports.version;

if (process.getuid && process.getuid() === 0) {
  process.emitWarning(`Verdaccio doesn't need superuser privileges. don't run it under root`);
}

if (!(0, _utils.isVersionValid)(process.version)) {
  throw new Error(`Verdaccio requires at least Node.js v${_utils.MIN_NODE_VERSION} or higher and you have installed ${process.version}, 
    please upgrade your Node.js distribution`);
}

const [node, app, ...args] = process.argv;
const cli = new _clipanion.Cli({
  binaryLabel: `verdaccio`,
  binaryName: `${node} ${app}`,
  binaryVersion: pkgVersion
});
cli.register(_info.InfoCommand);
cli.register(_init.InitCommand);
cli.register(_version.VersionCommand);
cli.runExit(args, _clipanion.Cli.defaultContext);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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