"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderTemplate;

var _debug = _interopRequireDefault(require("debug"));

var _manifest = require("./manifest");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = (0, _debug.default)('verdaccio');

function renderTemplate(template, manifest) {
  var _template$options$tit, _template$options;

  debug('template %o', template);
  debug('manifest %o', manifest);
  return `
    <!DOCTYPE html>
      <html lang="en-us"> 
      <head>
        <meta charset="utf-8">
        <base href="${template === null || template === void 0 ? void 0 : template.options.base}">
        <title>${(_template$options$tit = template === null || template === void 0 ? void 0 : (_template$options = template.options) === null || _template$options === void 0 ? void 0 : _template$options.title) !== null && _template$options$tit !== void 0 ? _template$options$tit : ''}</title>        
        <link rel="icon" href="${template === null || template === void 0 ? void 0 : template.options.base}-/static/favicon.ico"/>
        <meta name="viewport" content="width=device-width, initial-scale=1" /> 
        <script>
            window.__VERDACCIO_BASENAME_UI_OPTIONS=${JSON.stringify(template.options)}
        </script>
        ${template !== null && template !== void 0 && template.metaScripts ? template.metaScripts.join('') : ''}
      </head>    
      <body class="body">
      ${template !== null && template !== void 0 && template.scriptsbodyBefore ? template.scriptsbodyBefore.join('') : ''}
        <div id="root"></div>
        ${(0, _manifest.getManifestValue)(template.manifest.js, manifest, template === null || template === void 0 ? void 0 : template.options.base).map(item => `<script defer="defer" src="${item}"></script>`).join('')}
        ${template !== null && template !== void 0 && template.scriptsBodyAfter ? template.scriptsBodyAfter.join('') : ''}
      </body>
    </html>
  `;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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