"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _express = require("express");

var _lodash = _interopRequireDefault(require("lodash"));

var _authUtils = require("../../../lib/auth-utils");

var _constants = require("../../../lib/constants");

var _utils = require("../../../lib/utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function addUserAuthApi(auth, config) {
  const route = (0, _express.Router)();
  /* eslint new-cap: 0 */

  route.post('/login', function (req, res, next) {
    const {
      username,
      password
    } = req.body;
    auth.authenticate(username, password, async (err, user) => {
      if (err) {
        const errorCode = err.message ? _constants.HTTP_STATUS.UNAUTHORIZED : _constants.HTTP_STATUS.INTERNAL_ERROR;
        next(_utils.ErrorCode.getCode(errorCode, err.message));
      } else {
        req.remote_user = user;
        const jWTSignOptions = (0, _authUtils.getSecurity)(config).web.sign;
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        next({
          token: await auth.jwtEncrypt(user, jWTSignOptions),
          username: req.remote_user.name
        });
      }
    });
  });
  route.put('/reset_password', function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name)) {
      res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
      return next({
        // FUTURE: update to a more meaningful message
        message: _constants.API_ERROR.MUST_BE_LOGGED
      });
    }

    const {
      password
    } = req.body;
    const {
      name
    } = req.remote_user;

    if ((0, _authUtils.validatePassword)(password.new) === false) {
      auth.changePassword(name, password.old, password.new, (err, isUpdated) => {
        if (_lodash.default.isNil(err) && isUpdated) {
          next({
            ok: true
          });
        } else {
          return next(_utils.ErrorCode.getInternalError(_constants.API_ERROR.INTERNAL_SERVER_ERROR));
        }
      });
    } else {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.BAD_REQUEST, _constants.APP_ERROR.PASSWORD_VALIDATION));
    }
  });
  return route;
}

var _default = addUserAuthApi;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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