"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _express = require("express");

var _constants = require("../../../lib/constants");

var _search = _interopRequireDefault(require("../../../lib/search"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function addSearchWebApi(storage, auth) {
  const route = (0, _express.Router)();
  /* eslint new-cap: 0 */
  // Search package

  route.get('/search/:anything', function (req, res, next) {
    const results = _search.default.query(req.params.anything); // FUTURE: figure out here the correct type


    const packages = [];

    const getPackageInfo = function (i) {
      storage.getPackage({
        name: results[i].ref,
        uplinksLook: false,
        callback: (err, entry) => {
          if (!err && entry) {
            auth.allow_access({
              packageName: entry.name
            }, req.remote_user, function (err, allowed) {
              if (err || !allowed) {
                return;
              }

              packages.push(entry.versions[entry[_constants.DIST_TAGS].latest]);
            });
          }

          if (i >= results.length - 1) {
            next(packages);
          } else {
            getPackageInfo(i + 1);
          }
        }
      });
    };

    if (results.length) {
      getPackageInfo(0);
    } else {
      next([]);
    }
  });
  return route;
}

var _default = addSearchWebApi;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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