"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _express = require("express");

var _utils = require("../../../lib/utils");

var _rateLimiter = require("../../rate-limiter");

var _package = _interopRequireDefault(require("./package"));

var _search = _interopRequireDefault(require("./search"));

var _user = _interopRequireDefault(require("./user"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = (auth, storage, config) => {
  var _config$web;

  const route = (0, _express.Router)();
  /* eslint new-cap: 0 */

  route.use('/data/', (0, _rateLimiter.limiter)(_objectSpread({
    windowMs: 2 * 60 * 1000,
    // 2  minutes
    max: 5000
  }, config === null || config === void 0 ? void 0 : (_config$web = config.web) === null || _config$web === void 0 ? void 0 : _config$web.rateLimit)));
  route.use('/data/', (0, _package.default)(storage, auth, config));
  route.use('/data/', (0, _search.default)(storage, auth));
  route.use('/sec/', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit));

  if ((0, _utils.hasLogin)(config)) {
    route.use('/sec/', (0, _user.default)(auth, storage));
  }

  return route;
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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