"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _bodyParser = _interopRequireDefault(require("body-parser"));

var _express = require("express");

var _search = _interopRequireDefault(require("../../lib/search"));

var _middleware = require("../middleware");

var _endpoint = _interopRequireDefault(require("./endpoint"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const route = (0, _express.Router)();
/* eslint new-cap: 0 */

/*
 This file include all verdaccio only API(Web UI), for npm API please see ../endpoint/
*/

function _default(config, auth, storage) {
  _search.default.configureStorage(storage); // validate all of these params as a package name
  // this might be too harsh, so ask if it causes trouble


  route.param('package', _middleware.validatePackage);
  route.param('filename', _middleware.validateName);
  route.param('version', _middleware.validateName);
  route.param('anything', (0, _middleware.match)(/.*/));
  route.use(_bodyParser.default.urlencoded({
    extended: false
  }));
  route.use(auth.webUIJWTmiddleware());
  route.use(_middleware.setSecurityWebHeaders);
  route.use((0, _endpoint.default)(auth, storage, config));
  return route;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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