"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _lodash = _interopRequireDefault(require("lodash"));

var _mime = _interopRequireDefault(require("mime"));

var _constants = require("../../../lib/constants");

var _middleware = require("../../middleware");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(route, auth, storage) {
  const can = (0, _middleware.allow)(auth);

  const tag_package_version = function (req, res, next) {
    if (_lodash.default.isString(req.body) === false) {
      return next('route');
    }

    const tags = {};
    tags[req.params.tag] = req.body;
    storage.mergeTags(req.params.package, tags, function (err) {
      if (err) {
        return next(err);
      }

      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_ADDED
      });
    });
  }; // tagging a package


  route.put('/:package/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.post('/-/package/:package/dist-tags/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.put('/-/package/:package/dist-tags/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.delete('/-/package/:package/dist-tags/:tag', can('publish'), function (req, res, next) {
    const tags = {};
    tags[req.params.tag] = null;
    storage.mergeTags(req.params.package, tags, function (err) {
      if (err) {
        return next(err);
      }

      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_REMOVED
      });
    });
  });
  route.get('/-/package/:package/dist-tags', can('access'), function (req, res, next) {
    storage.getPackage({
      name: req.params.package,
      uplinksLook: true,
      req,
      callback: function (err, info) {
        if (err) {
          return next(err);
        }

        next(info[_constants.DIST_TAGS]);
      }
    });
  });
  route.post('/-/package/:package/dist-tags', can('publish'), function (req, res, next) {
    storage.mergeTags(req.params.package, req.body, function (err) {
      if (err) {
        return next(err);
      }

      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_UPDATED
      });
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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