# Security Policy

## Supported versions

The following table describes the versions of this project that are currently supported with security updates:

| Version | Supported                                |
| ------- | ---------------------------------------- |
| 2.x     | :x:                                      |
| 3.x     | :x:                                      |
| 4.x     | :white_check_mark: (until 1st July 2021) |
| 5.x     | :white_check_mark:                       |

## Responsible disclosure security policy

A responsible disclosure policy helps protect users of the project from publicly disclosed security vulnerabilities without a fix by employing a process where vulnerabilities are first triaged in a private manner, and only publicly disclosed after a reasonable time period that allows patching the vulnerability and provides an upgrade path for users.

When contacting us directly via email, we will do our best efforts to respond in a reasonable time to resolve the issue. When contacting a security program their disclosure policy will provide details on timeframe, processes and paid bounties.

We kindly ask you to refrain from malicious acts that put our users, the project, or any of the project’s team members at risk.

## Reporting a security issue

> Please do not use the provided email address to report issues which are not related to security vulnerabilities

At Verdaccio, we consider the security of our systems a top priority. But no matter how much effort we put into system security, there can still be vulnerabilities present.

If you discover a security vulnerability, please use one of the following means of communications to report it to us:

- Report the security issue to the Node.js Security WG through the [HackerOne program](https://hackerone.com/nodejs-ecosystem) for ecosystem modules on npm, or to [Snyk Security Team](https://snyk.io/vulnerability-disclosure). They will help triage the security issue and work with all involved parties to remediate and release a fix.

Note that time-frame and processes are subject to each program’s own policy.

- Report the security issue to the project maintainers directly at verdaccio@pm.me. If the report contains highly sensitive information, please be advised to encrypt your findings using our [PGP key](https://verdaccio.nyc3.digitaloceanspaces.com/gpg/publickey.verdaccio@pm.me.asc) which is also available in this document.

Your efforts to responsibly disclose your findings are sincerely appreciated and will be taken into account to acknowledge your contributions.

## PGP key

The following is this project’s PGP key which should be used to encrypt any sensitive information shared on unsecured medium such as e-mails:

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: OpenPGP.js v4.5.1
Comment: https://openpgpjs.org

xsBNBFzm3asBCACxnJDv1r6dxiM2e8iqS6B7fxY2I3X1Rc+3m8mhXOwVwRG4
AOrQ417oSzsVLf4iocg+DWrtxzY79odTLJEovVt79rxwqIIl4y96tH+29kLB
ao7eaYZacfstonVkBAmxBLaYv1x7cqWuukm6sBCOxapW1X9BcbR3vOghDziY
/1AwNjupAOPvKNMtghjrdh3w0iMfZS1hw28zjM1oCeezEil+CTjgQDN+69qS
UFG/BInJ7CVn9TvhU85inSwpxVa576fkhvFoNUrGvFvYRWtXRJndbRdBodVj
C9At/Gb2IeNf7xqXH2KloZ1yaVNVSzLX4jqrMWeF+9Z12SjUyL6G9TwDABEB
AAHNIXZlcmRhY2Npb0BwbS5tZSA8dmVyZGFjY2lvQHBtLm1lPsLAdQQQAQgA
HwUCXObdqwYLCQcIAwIEFQgKAgMWAgECGQECGwMCHgEACgkQpSvoGbwFJYhn
2wf+JF+yLQXh1EFMih6lpbx243hvglgOWmcigYVRh5mSfULcdW2pmkPQXqhE
DW73qqwN9G9piiPnGMw7sKoB7XJVuFKyvHOYKtem5UQVRvs2rTxnSc5qFcUJ
0w3Tw/pZ9B3fYAEYti2B/GsSOzaECfBKCFOg15xXGAdwfgff5FsorN1Gb6MG
eCO9c8faSF/+fQUCfokwMDVzxXQFZEMx3q/rHVJ/Fm+XelZ+00c9fdyiuPW5
dM9gATle7lz0iPtxaUDGLW8QZ/7b6O8IJ1kle0tL4AE++bXsVWxNdzhlNohH
Hn09sIdFnG4ySTz4YJjiDd70ZdQjOGEGvutymEIN1xcNq87ATQRc5t2rAQgA
yX2ZhUCtrz7lzK0992yveB+duVF//yo9Pei2ra9Z3GNmA+oWlRH1FTWpAmVH
uDdUchTnxAwaKntabt3Mb1AgEZwrdiG4LuHFbdx2ls93BJ5lXdp7vB6pVf3N
IrhHKyQ/Y5L5kMSj/GjrhO19zmj6mPPEgb3M3ZIZjQUF4pro0pExuAPA9Wxe
awn5+0BUYFs4mZQDtTdiVuz5tWA0fNtt1aBfOPA97tmn18y4b1b0iQIJQpep
BVVnFLeAZOevDcBJFbmQOdAjufWSSgpzX+FZ3rx6RVwwKxUiVQyUuwSQkKh5
RufZ5zE0y7Fe/YlWXbKoj4zNJqYtjPSPngQRWf7UpwARAQABwsBfBBgBCAAJ
BQJc5t2rAhsMAAoJEKUr6Bm8BSWIoYQH+QDw0Z84tZK4N1lh49hYyohs6vNU
9kG69nKLQA5NymPtTxh8YOJhdJL697FkvKI4OGEO2FXUmcJS3CBJ2nBVKMq2
1biDRKC4OhIU2RgFhS6bHy6VOn24EYs77T+zX8YXpz8ulYVln2b0QZCubN0Z
L50tEC8HnuVMVN+/pqITdD3FjzwGZgHdW8qkKgD6qhObHCl8/cW2buCsaIAY
eZWVPgPY1S1U0V608qYNtUCkrmUW5Sl6YLvz7JTvTsaym5mzyFXF3ErAURgI
/v4XaWmRgNGIxbIxsFGuEs+KIKBQDJmtvJCVpBNS5IYnFf5h/LA5cfkwMKJt
wXhyE0b/iDs60ZM=
=QWXs
-----END PGP PUBLIC KEY BLOCK-----
```
