"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.REGISTRY_DOMAIN = void 0;

var _https = _interopRequireDefault(require("https"));

var _nodeFetch = _interopRequireDefault(require("node-fetch"));

var _express = _interopRequireDefault(require("express"));

var _httpsProxyAgent = _interopRequireDefault(require("https-proxy-agent"));

var _bodyParser = require("body-parser");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// FUTURE: we should be able to overwrite this
const REGISTRY_DOMAIN = 'https://registry.npmjs.org';
exports.REGISTRY_DOMAIN = REGISTRY_DOMAIN;

class ProxyAudit {
  constructor(config, options) {
    _defineProperty(this, "enabled", void 0);

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "strict_ssl", void 0);

    this.enabled = config.enabled || false;
    this.strict_ssl = config.strict_ssl !== undefined ? config.strict_ssl : true;
    this.logger = options.logger;
  }

  register_middlewares(app, auth) {
    const fetchAudit = (req, res) => {
      var _auth$config;

      const headers = req.headers;
      headers['host'] = 'registry.npmjs.org';
      headers['content-encoding'] = 'gzip,deflate,br';
      let requestOptions = {
        agent: new _https.default.Agent({
          rejectUnauthorized: this.strict_ssl
        }),
        body: JSON.stringify(req.body),
        headers,
        method: req.method
      };

      if (auth !== null && auth !== void 0 && (_auth$config = auth.config) !== null && _auth$config !== void 0 && _auth$config.https_proxy) {
        var _auth$config2;

        // we should check whether this works fine after this migration
        // please notify if anyone is having issues
        const agent = (0, _httpsProxyAgent.default)(auth === null || auth === void 0 ? void 0 : (_auth$config2 = auth.config) === null || _auth$config2 === void 0 ? void 0 : _auth$config2.https_proxy);
        requestOptions = Object.assign({}, requestOptions, {
          agent
        });
      }

      (async () => {
        try {
          const auditEndpoint = `${REGISTRY_DOMAIN}${req.baseUrl}${req.route.path}`;
          this.logger.debug('fetching audit from ' + auditEndpoint);
          const response = await (0, _nodeFetch.default)(auditEndpoint, requestOptions);

          if (response.ok) {
            res.status(response.status).send(await response.json());
          } else {
            this.logger.warn('could not fetch audit: ' + JSON.stringify(await response.json()));
            res.status(response.status).end();
          }
        } catch (error) {
          this.logger.warn('could not fetch audit: ' + error);
          res.status(500).end();
        }
      })();
    };

    const handleAudit = (req, res) => {
      if (this.enabled) {
        fetchAudit(req, res);
      } else {
        res.status(500).end();
      }
    };
    /* eslint new-cap:off */


    const router = _express.default.Router();
    /* eslint new-cap:off */


    router.post('/audits', (0, _bodyParser.json)({
      limit: '10mb'
    }), handleAudit);
    router.post('/audits/quick', (0, _bodyParser.json)({
      limit: '10mb'
    }), handleAudit);
    router.post('/advisories/bulk', (0, _bodyParser.json)({
      limit: '10mb'
    }), handleAudit);
    app.use('/-/npm/v1/security', router);
  }

}

exports.default = ProxyAudit;
//# sourceMappingURL=audit.js.map