"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseReadme;

var _dompurify = _interopRequireDefault(require("dompurify"));

var _jsdom = require("jsdom");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DOMPurify = (0, _dompurify.default)(new _jsdom.JSDOM('').window);

const {
  marked
} = require('marked');

function parseReadme(readme, options = {}) {
  let result;

  if (readme) {
    result = DOMPurify.sanitize(marked(readme, {
      sanitize: false
    }).trim());

    if ('string' === typeof options.pathname) {
      result = result.replace(/href="#/gi, `href="${options.pathname}#`);
    }
  }

  return result;
}
//# sourceMappingURL=index.js.map