"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadPrivatePackages = loadPrivatePackages;

var _fs = _interopRequireDefault(require("fs"));

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function loadPrivatePackages(path, logger) {
  const list = [];
  const emptyDatabase = {
    list,
    secret: ''
  };

  const data = _fs.default.readFileSync(path, 'utf8');

  if (_lodash.default.isNil(data)) {
    // readFileSync is platform specific, FreeBSD might return null
    return emptyDatabase;
  }

  let db;

  try {
    db = JSON.parse(data);
  } catch (err) {
    logger.error({
      err: err.mesage,
      path
    }, // eslint-disable-next-line max-len
    `Package database file corrupted (invalid JSON), please check the error @{err}.\nFile Path: @{path}`);
    throw Error('Package database file corrupted (invalid JSON)');
  }

  if (_lodash.default.isEmpty(db)) {
    return emptyDatabase;
  }

  return db;
}
//# sourceMappingURL=pkg-utils.js.map