import React from 'react';
export function ProgressCircle(props) {
    const radius = 104;
    const d = (progress) => {
        const angle = Math.max(progress * 3.6, 0.1);
        const rad = (angle * Math.PI) / 180, x = Math.sin(rad) * radius, y = Math.cos(rad) * -radius, mid = angle < 180 ? 1 : 0, shape = `M 0 0 v -${radius} A ${radius} ${radius} 1 ` +
            mid +
            ' 0 ' +
            x.toFixed(4) +
            ' ' +
            y.toFixed(4) +
            ' z';
        return shape;
    };
    return (React.createElement("div", { className: 'jp-Statusbar-ProgressCircle', role: "progressbar", "aria-valuemin": 0, "aria-valuemax": 100, "aria-valuenow": props.progress },
        React.createElement("svg", { viewBox: "0 0 250 250" },
            React.createElement("circle", { cx: "125", cy: "125", r: `${radius}`, stroke: "var(--jp-inverse-layout-color3)", strokeWidth: "20", fill: "none" }),
            React.createElement("path", { transform: "translate(125,125) scale(.9)", d: d(props.progress), fill: 'var(--jp-inverse-layout-color3)' }))));
}
//# sourceMappingURL=progressCircle.js.map