import { ITranslator } from '@jupyterlab/translation';
import { Message } from '@lumino/messaging';
import { Widget } from '@lumino/widgets';
import { FileBrowserModel } from './model';
/**
 * A class which hosts folder breadcrumbs.
 */
export declare class BreadCrumbs extends Widget {
    /**
     * Construct a new file browser crumb widget.
     *
     * @param model - The file browser view model.
     */
    constructor(options: BreadCrumbs.IOptions);
    /**
     * Handle the DOM events for the bread crumbs.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event: Event): void;
    /**
     * A message handler invoked on an `'after-attach'` message.
     */
    protected onAfterAttach(msg: Message): void;
    /**
     * A message handler invoked on a `'before-detach'` message.
     */
    protected onBeforeDetach(msg: Message): void;
    /**
     * A handler invoked on an `'update-request'` message.
     */
    protected onUpdateRequest(msg: Message): void;
    /**
     * Handle the `'click'` event for the widget.
     */
    private _evtClick;
    /**
     * Handle the `'lm-dragenter'` event for the widget.
     */
    private _evtDragEnter;
    /**
     * Handle the `'lm-dragleave'` event for the widget.
     */
    private _evtDragLeave;
    /**
     * Handle the `'lm-dragover'` event for the widget.
     */
    private _evtDragOver;
    /**
     * Handle the `'lm-drop'` event for the widget.
     */
    private _evtDrop;
    protected translator: ITranslator;
    private _trans;
    private _model;
    private _hasPreferred;
    private _crumbs;
    private _crumbSeps;
}
/**
 * The namespace for the `BreadCrumbs` class statics.
 */
export declare namespace BreadCrumbs {
    /**
     * An options object for initializing a bread crumb widget.
     */
    interface IOptions {
        /**
         * A file browser model instance.
         */
        model: FileBrowserModel;
        /**
         * The application language translator.
         */
        translator?: ITranslator;
    }
}
