// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module codemirror
 */
import { CodeMirrorEditorFactory } from './factory';
import { CodeMirrorMimeTypeService } from './mimetype';
export * from './editor';
export * from './factory';
export * from './mimetype';
export * from './mode';
export * from './syntaxstatus';
export * from './tokens';
/**
 * The default editor services.
 */
export const editorServices = {
    factoryService: new CodeMirrorEditorFactory(),
    mimeTypeService: new CodeMirrorMimeTypeService()
};
/**
 * FIXME-TRANS: Maybe an option to be able to pass a translator to the factories?
 *

export function getEditorServices(translator: ITranslator): IEditorServices {
  return {
    factoryService: new CodeMirrorEditorFactory({}, translator),
    mimeTypeService: new CodeMirrorMimeTypeService(translator)
  };
}
 */
//# sourceMappingURL=index.js.map