`anyjsonthing`
==============



🧐 About
------------------------------------------------------------------------------------------------------------------------


This repository contains the code of `anyjsonthing`, a Python library that implements serialization of simple data
objects as JSON data.
For additional details on how to use the library, please have a look at the enclosed documentation.
(Notice that you currently have to build the documentation by yourself, as described below.)

**NOTICE:**
All tickets related to this project are available
[on JIRA](https://phohenecker.atlassian.net/jira/software/c/projects/AJT/boards/34).



🏁 Getting Started
------------------------------------------------------------------------------------------------------------------------


The repository uses [`just`](https://github.com/casey/just) (a build tool like `Makefile`) to automate common tasks such
as testing, building, etc.
To list all available recipes, run the following command in the project directory:

```bash
$ just -l
Available recipes:
    build-docs           # Builds the documentation.
    build-library        # Builds the anyjsonthing library.
    clean                # Cleans up all generated files.
    dev-env              # Creates a Conda environment (called "anyjsonthing") for local development/testing.
    print-version        # Prints the currently specified version of the library.
    publish-library      # Publishes the library in the PyPI.
    test                 # Runs all unit tests in the test directory.
    test-publish-library # Publishes the library in the TestPyPI.
```

Notice the recipe `dev-env` (which can be executed by running `just dev-env`), which creates a
[Conda](https://docs.conda.io/en/latest/) environment (called `anyjsonthing`) that contains all dependencies required
for local development and testing.



🚀 Building & Publishing
------------------------------------------------------------------------------------------------------------------------


There are ready-made `just` recipes for all build tasks:

* `just build-library` – Builds the library using Python's standard `build` module.
  The resulting files are placed in the `dist` folder, which is created in the project root.
* `just publish-library` – Publishes the built library in the PyPI.
  Notice that this recipe automatically runs the `build-library` recipe first.
  Furthermore, please notice the required configuration, as described below.
* `just test-publish-library` – This recipe exist for testing purposes and is identical to the `publish-library` recipe
  except that it publishes the library in the TestPyPI.
  Again, please consider the required configuration.
* `just build-docs` – Builds the documentation of the library, which is placed in `docs/build`.

In this repository, we follow the convention that the version of the library (as published in the PyPI) is specified in
the Python module `version.py` located in the project root.
Hence, you should never have any need to directly adjust the `setup.cfg`, which configures the details of the build
process used to assemble the created Python package.



🏗 CI/CD
------------------------------------------------------------------------------------------------------------------------


This project makes use of a simple CI/CD pipeline that consists of the following steps:

1. On every push, all unit tests in the test directory (`src/test`) are executed using `just test`.
2. If a push occurred on the `main` branch and the tests finished successfully, then the library is automatically built
   and published in the PyPI. Furthermore, the respective commit is tagged with the published version of the library
   (i.e., `vX.Y.Z`).



⚙️ Configuration
------------------------------------------------------------------------------------------------------------------------


The CI/CD pipeline of this project requires the following secrets (for GitHub actions) to be in place:

| Secret       | Description                                                                   |
|--------------|-------------------------------------------------------------------------------|
| `PYPI_TOKEN` | The access token of the PyPI account that is used for publishing the library. |

For local building and publishing, you further need to specify the following configuration values in an env file called
`.env` (without any name before the dot!), which has to be located in the project root:

| Env Variable      | Description                                                                                  |
|-------------------|----------------------------------------------------------------------------------------------|
| `PYPI_TOKEN`      | The access token of the PyPI account that is used for publishing the library.                |
| `PYPI_TEST_TOKEN` | The access token of the TestPyPI account that is used for testing publishing of the library. |



✍️ Authors
------------------------------------------------------------------------------------------------------------------------


* Patrick Hohenecker ([patrick.hohenecker@gmx.at](mailto:patrick.hohenecker@gmx.at))
