# Generated by xdrgen.py from ../xdr/ on Tue Aug 14 23:27:48 2018
from . import StellarXDR_const as const
class PublicKey:
    # XDR definition:
    # union PublicKey switch(PublicKeyType type) {
    #     case PUBLIC_KEY_TYPE_ED25519:
    #         uint256 ed25519;
    # };
    def __init__(self, type=None, ed25519=None):
        self.type = type
        self.ed25519 = ed25519

    switch = property(lambda s: {const.PUBLIC_KEY_TYPE_ED25519:s.ed25519,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.PublicKeyType.get(self.type, self.type)]
        if self.ed25519 is not None:
            out += ['ed25519=%s' % repr(self.ed25519)]
        return 'PublicKey(%s)' % ', '.join(out)
    __str__ = __repr__

class SignerKey:
    # XDR definition:
    # union SignerKey switch(SignerKeyType type) {
    #     case SIGNER_KEY_TYPE_ED25519:
    #         uint256 ed25519;
    #     case SIGNER_KEY_TYPE_PRE_AUTH_TX:
    #         uint256 preAuthTx;
    #     case SIGNER_KEY_TYPE_HASH_X:
    #         uint256 hashX;
    # };
    def __init__(self, type=None, ed25519=None, preAuthTx=None, hashX=None):
        self.type = type
        self.ed25519 = ed25519
        self.preAuthTx = preAuthTx
        self.hashX = hashX

    switch = property(lambda s: {const.SIGNER_KEY_TYPE_ED25519:s.ed25519,const.SIGNER_KEY_TYPE_PRE_AUTH_TX:s.preAuthTx,const.SIGNER_KEY_TYPE_HASH_X:s.hashX,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.SignerKeyType.get(self.type, self.type)]
        if self.ed25519 is not None:
            out += ['ed25519=%s' % repr(self.ed25519)]
        if self.preAuthTx is not None:
            out += ['preAuthTx=%s' % repr(self.preAuthTx)]
        if self.hashX is not None:
            out += ['hashX=%s' % repr(self.hashX)]
        return 'SignerKey(%s)' % ', '.join(out)
    __str__ = __repr__

NodeID = PublicKey
class Curve25519Secret:
    # XDR definition:
    # struct Curve25519Secret {
    #     opaque key[32];
    # };
    def __init__(self, key=None):
        self.key = key

    def __repr__(self):
        out = []
        if self.key is not None:
            out += ['key=%s' % repr(self.key)]
        return 'Curve25519Secret(%s)' % ', '.join(out)
    __str__ = __repr__

class Curve25519Public:
    # XDR definition:
    # struct Curve25519Public {
    #     opaque key[32];
    # };
    def __init__(self, key=None):
        self.key = key

    def __repr__(self):
        out = []
        if self.key is not None:
            out += ['key=%s' % repr(self.key)]
        return 'Curve25519Public(%s)' % ', '.join(out)
    __str__ = __repr__

class HmacSha256Key:
    # XDR definition:
    # struct HmacSha256Key {
    #     opaque key[32];
    # };
    def __init__(self, key=None):
        self.key = key

    def __repr__(self):
        out = []
        if self.key is not None:
            out += ['key=%s' % repr(self.key)]
        return 'HmacSha256Key(%s)' % ', '.join(out)
    __str__ = __repr__

class HmacSha256Mac:
    # XDR definition:
    # struct HmacSha256Mac {
    #     opaque mac[32];
    # };
    def __init__(self, mac=None):
        self.mac = mac

    def __repr__(self):
        out = []
        if self.mac is not None:
            out += ['mac=%s' % repr(self.mac)]
        return 'HmacSha256Mac(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPBallot:
    # XDR definition:
    # struct SCPBallot {
    #     uint32 counter;
    #     Value value;
    # };
    def __init__(self, counter=None, value=None):
        self.counter = counter
        self.value = value

    def __repr__(self):
        out = []
        if self.counter is not None:
            out += ['counter=%s' % repr(self.counter)]
        if self.value is not None:
            out += ['value=%s' % repr(self.value)]
        return 'SCPBallot(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPNomination:
    # XDR definition:
    # struct SCPNomination {
    #     Hash quorumSetHash;
    #     Value votes<>;
    #     Value accepted<>;
    # };
    def __init__(self, quorumSetHash=None, votes=None, accepted=None):
        self.quorumSetHash = quorumSetHash
        self.votes = votes
        self.accepted = accepted

    def __repr__(self):
        out = []
        if self.quorumSetHash is not None:
            out += ['quorumSetHash=%s' % repr(self.quorumSetHash)]
        if self.votes is not None:
            out += ['votes=%s' % repr(self.votes)]
        if self.accepted is not None:
            out += ['accepted=%s' % repr(self.accepted)]
        return 'SCPNomination(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPStatement:
    # XDR definition:
    # struct SCPStatement {
    #     NodeID nodeID;
    #     uint64 slotIndex;
    #     union switch(SCPStatementType type) {
    #         case SCP_ST_PREPARE:
    #             struct {
    #                 Hash quorumSetHash;
    #                 SCPBallot ballot;
    #                 SCPBallot prepared<1>;
    #                 SCPBallot preparedPrime<1>;
    #                 uint32 nC;
    #                 uint32 nH;
    #             } prepare;
    #         case SCP_ST_CONFIRM:
    #             struct {
    #                 SCPBallot ballot;
    #                 uint32 nPrepared;
    #                 uint32 nCommit;
    #                 uint32 nH;
    #                 Hash quorumSetHash;
    #             } confirm;
    #         case SCP_ST_EXTERNALIZE:
    #             struct {
    #                 SCPBallot commit;
    #                 uint32 nH;
    #                 Hash commitQuorumSetHash;
    #             } externalize;
    #         case SCP_ST_NOMINATE:
    #             SCPNomination nominate;
    #     } pledges;
    # };
    def __init__(self, nodeID=None, slotIndex=None, pledges=None):
        self.nodeID = nodeID
        self.slotIndex = slotIndex
        self.pledges = pledges

    def __repr__(self):
        out = []
        if self.nodeID is not None:
            out += ['nodeID=%s' % repr(self.nodeID)]
        if self.slotIndex is not None:
            out += ['slotIndex=%s' % repr(self.slotIndex)]
        if self.pledges is not None:
            out += ['pledges=%s' % repr(self.pledges)]
        return 'SCPStatement(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPEnvelope:
    # XDR definition:
    # struct SCPEnvelope {
    #     SCPStatement statement;
    #     Signature signature;
    # };
    def __init__(self, statement=None, signature=None):
        self.statement = statement
        self.signature = signature

    def __getattr__(self, attr):
        return getattr(self.statement, attr)

    def __repr__(self):
        out = []
        if self.statement is not None:
            out += ['statement=%s' % repr(self.statement)]
        if self.signature is not None:
            out += ['signature=%s' % repr(self.signature)]
        return 'SCPEnvelope(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPQuorumSet:
    # XDR definition:
    # struct SCPQuorumSet {
    #     uint32 threshold;
    #     PublicKey validators<>;
    #     SCPQuorumSet innerSets<>;
    # };
    def __init__(self, threshold=None, validators=None, innerSets=None):
        self.threshold = threshold
        self.validators = validators
        self.innerSets = innerSets

    def __repr__(self):
        out = []
        if self.threshold is not None:
            out += ['threshold=%s' % repr(self.threshold)]
        if self.validators is not None:
            out += ['validators=%s' % repr(self.validators)]
        if self.innerSets is not None:
            out += ['innerSets=%s' % repr(self.innerSets)]
        return 'SCPQuorumSet(%s)' % ', '.join(out)
    __str__ = __repr__

class StellarValue:
    # XDR definition:
    # struct StellarValue {
    #     Hash txSetHash;
    #     uint64 closeTime;
    #     UpgradeType upgrades<6>;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, txSetHash=None, closeTime=None, upgrades=None, ext=None):
        self.txSetHash = txSetHash
        self.closeTime = closeTime
        self.upgrades = upgrades
        self.ext = ext

    def __getattr__(self, attr):
        return getattr(self.ext, attr)

    def __repr__(self):
        out = []
        if self.txSetHash is not None:
            out += ['txSetHash=%s' % repr(self.txSetHash)]
        if self.closeTime is not None:
            out += ['closeTime=%s' % repr(self.closeTime)]
        if self.upgrades is not None:
            out += ['upgrades=%s' % repr(self.upgrades)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'StellarValue(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerHeader:
    # XDR definition:
    # struct LedgerHeader {
    #     uint32 ledgerVersion;
    #     Hash previousLedgerHash;
    #     StellarValue scpValue;
    #     Hash txSetResultHash;
    #     Hash bucketListHash;
    #     uint32 ledgerSeq;
    #     int64 totalCoins;
    #     int64 feePool;
    #     uint32 inflationSeq;
    #     uint64 idPool;
    #     uint32 baseFee;
    #     uint32 baseReserve;
    #     uint32 maxTxSetSize;
    #     Hash skipList[4];
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, ledgerVersion=None, previousLedgerHash=None, scpValue=None, txSetResultHash=None, bucketListHash=None, ledgerSeq=None, totalCoins=None, feePool=None, inflationSeq=None, idPool=None, baseFee=None, baseReserve=None, maxTxSetSize=None, skipList=None, ext=None):
        self.ledgerVersion = ledgerVersion
        self.previousLedgerHash = previousLedgerHash
        self.scpValue = scpValue
        self.txSetResultHash = txSetResultHash
        self.bucketListHash = bucketListHash
        self.ledgerSeq = ledgerSeq
        self.totalCoins = totalCoins
        self.feePool = feePool
        self.inflationSeq = inflationSeq
        self.idPool = idPool
        self.baseFee = baseFee
        self.baseReserve = baseReserve
        self.maxTxSetSize = maxTxSetSize
        self.skipList = skipList
        self.ext = ext

    def __repr__(self):
        out = []
        if self.ledgerVersion is not None:
            out += ['ledgerVersion=%s' % repr(self.ledgerVersion)]
        if self.previousLedgerHash is not None:
            out += ['previousLedgerHash=%s' % repr(self.previousLedgerHash)]
        if self.scpValue is not None:
            out += ['scpValue=%s' % repr(self.scpValue)]
        if self.txSetResultHash is not None:
            out += ['txSetResultHash=%s' % repr(self.txSetResultHash)]
        if self.bucketListHash is not None:
            out += ['bucketListHash=%s' % repr(self.bucketListHash)]
        if self.ledgerSeq is not None:
            out += ['ledgerSeq=%s' % repr(self.ledgerSeq)]
        if self.totalCoins is not None:
            out += ['totalCoins=%s' % repr(self.totalCoins)]
        if self.feePool is not None:
            out += ['feePool=%s' % repr(self.feePool)]
        if self.inflationSeq is not None:
            out += ['inflationSeq=%s' % repr(self.inflationSeq)]
        if self.idPool is not None:
            out += ['idPool=%s' % repr(self.idPool)]
        if self.baseFee is not None:
            out += ['baseFee=%s' % repr(self.baseFee)]
        if self.baseReserve is not None:
            out += ['baseReserve=%s' % repr(self.baseReserve)]
        if self.maxTxSetSize is not None:
            out += ['maxTxSetSize=%s' % repr(self.maxTxSetSize)]
        if self.skipList is not None:
            out += ['skipList=%s' % repr(self.skipList)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'LedgerHeader(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerUpgrade:
    # XDR definition:
    # union LedgerUpgrade switch(LedgerUpgradeType type) {
    #     case LEDGER_UPGRADE_VERSION:
    #         uint32 newLedgerVersion;
    #     case LEDGER_UPGRADE_BASE_FEE:
    #         uint32 newBaseFee;
    #     case LEDGER_UPGRADE_MAX_TX_SET_SIZE:
    #         uint32 newMaxTxSetSize;
    #     case LEDGER_UPGRADE_BASE_RESERVE:
    #         uint32 newBaseReserve;
    # };
    def __init__(self, type=None, newLedgerVersion=None, newBaseFee=None, newMaxTxSetSize=None, newBaseReserve=None):
        self.type = type
        self.newLedgerVersion = newLedgerVersion
        self.newBaseFee = newBaseFee
        self.newMaxTxSetSize = newMaxTxSetSize
        self.newBaseReserve = newBaseReserve

    switch = property(lambda s: {const.LEDGER_UPGRADE_VERSION:s.newLedgerVersion,const.LEDGER_UPGRADE_BASE_FEE:s.newBaseFee,const.LEDGER_UPGRADE_MAX_TX_SET_SIZE:s.newMaxTxSetSize,const.LEDGER_UPGRADE_BASE_RESERVE:s.newBaseReserve,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.LedgerUpgradeType.get(self.type, self.type)]
        if self.newLedgerVersion is not None:
            out += ['newLedgerVersion=%s' % repr(self.newLedgerVersion)]
        if self.newBaseFee is not None:
            out += ['newBaseFee=%s' % repr(self.newBaseFee)]
        if self.newMaxTxSetSize is not None:
            out += ['newMaxTxSetSize=%s' % repr(self.newMaxTxSetSize)]
        if self.newBaseReserve is not None:
            out += ['newBaseReserve=%s' % repr(self.newBaseReserve)]
        return 'LedgerUpgrade(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerKey:
    # XDR definition:
    # union LedgerKey switch(LedgerEntryType type) {
    #     case ACCOUNT:
    #         struct {
    #             AccountID accountID;
    #         } account;
    #     case TRUSTLINE:
    #         struct {
    #             AccountID accountID;
    #             Asset asset;
    #         } trustLine;
    #     case OFFER:
    #         struct {
    #             AccountID sellerID;
    #             uint64 offerID;
    #         } offer;
    #     case DATA:
    #         struct {
    #             AccountID accountID;
    #             string64 dataName;
    #         } data;
    # };
    def __init__(self, type=None, account=None, trustLine=None, offer=None, data=None):
        self.type = type
        self.account = account
        self.trustLine = trustLine
        self.offer = offer
        self.data = data

    switch = property(lambda s: {const.ACCOUNT:s.account,const.TRUSTLINE:s.trustLine,const.OFFER:s.offer,const.DATA:s.data,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.LedgerEntryType.get(self.type, self.type)]
        if self.account is not None:
            out += ['account=%s' % repr(self.account)]
        if self.trustLine is not None:
            out += ['trustLine=%s' % repr(self.trustLine)]
        if self.offer is not None:
            out += ['offer=%s' % repr(self.offer)]
        if self.data is not None:
            out += ['data=%s' % repr(self.data)]
        return 'LedgerKey(%s)' % ', '.join(out)
    __str__ = __repr__

class BucketEntry:
    # XDR definition:
    # union BucketEntry switch(BucketEntryType type) {
    #     case LIVEENTRY:
    #         LedgerEntry liveEntry;
    #     case DEADENTRY:
    #         LedgerKey deadEntry;
    # };
    def __init__(self, type=None, liveEntry=None, deadEntry=None):
        self.type = type
        self.liveEntry = liveEntry
        self.deadEntry = deadEntry

    switch = property(lambda s: {const.LIVEENTRY:s.liveEntry,const.DEADENTRY:s.deadEntry,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.BucketEntryType.get(self.type, self.type)]
        if self.liveEntry is not None:
            out += ['liveEntry=%s' % repr(self.liveEntry)]
        if self.deadEntry is not None:
            out += ['deadEntry=%s' % repr(self.deadEntry)]
        return 'BucketEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionSet:
    # XDR definition:
    # struct TransactionSet {
    #     Hash previousLedgerHash;
    #     TransactionEnvelope txs<>;
    # };
    def __init__(self, previousLedgerHash=None, txs=None):
        self.previousLedgerHash = previousLedgerHash
        self.txs = txs

    def __repr__(self):
        out = []
        if self.previousLedgerHash is not None:
            out += ['previousLedgerHash=%s' % repr(self.previousLedgerHash)]
        if self.txs is not None:
            out += ['txs=%s' % repr(self.txs)]
        return 'TransactionSet(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionResultPair:
    # XDR definition:
    # struct TransactionResultPair {
    #     Hash transactionHash;
    #     TransactionResult result;
    # };
    def __init__(self, transactionHash=None, result=None):
        self.transactionHash = transactionHash
        self.result = result

    def __getattr__(self, attr):
        return getattr(self.result, attr)

    def __repr__(self):
        out = []
        if self.transactionHash is not None:
            out += ['transactionHash=%s' % repr(self.transactionHash)]
        if self.result is not None:
            out += ['result=%s' % repr(self.result)]
        return 'TransactionResultPair(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionResultSet:
    # XDR definition:
    # struct TransactionResultSet {
    #     TransactionResultPair results<>;
    # };
    def __init__(self, results=None):
        self.results = results

    def __repr__(self):
        out = []
        if self.results is not None:
            out += ['results=%s' % repr(self.results)]
        return 'TransactionResultSet(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionHistoryEntry:
    # XDR definition:
    # struct TransactionHistoryEntry {
    #     uint32 ledgerSeq;
    #     TransactionSet txSet;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, ledgerSeq=None, txSet=None, ext=None):
        self.ledgerSeq = ledgerSeq
        self.txSet = txSet
        self.ext = ext

    def __repr__(self):
        out = []
        if self.ledgerSeq is not None:
            out += ['ledgerSeq=%s' % repr(self.ledgerSeq)]
        if self.txSet is not None:
            out += ['txSet=%s' % repr(self.txSet)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'TransactionHistoryEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionHistoryResultEntry:
    # XDR definition:
    # struct TransactionHistoryResultEntry {
    #     uint32 ledgerSeq;
    #     TransactionResultSet txResultSet;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, ledgerSeq=None, txResultSet=None, ext=None):
        self.ledgerSeq = ledgerSeq
        self.txResultSet = txResultSet
        self.ext = ext

    def __repr__(self):
        out = []
        if self.ledgerSeq is not None:
            out += ['ledgerSeq=%s' % repr(self.ledgerSeq)]
        if self.txResultSet is not None:
            out += ['txResultSet=%s' % repr(self.txResultSet)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'TransactionHistoryResultEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerHeaderHistoryEntry:
    # XDR definition:
    # struct LedgerHeaderHistoryEntry {
    #     Hash hash;
    #     LedgerHeader header;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, hash=None, header=None, ext=None):
        self.hash = hash
        self.header = header
        self.ext = ext

    def __repr__(self):
        out = []
        if self.hash is not None:
            out += ['hash=%s' % repr(self.hash)]
        if self.header is not None:
            out += ['header=%s' % repr(self.header)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'LedgerHeaderHistoryEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerSCPMessages:
    # XDR definition:
    # struct LedgerSCPMessages {
    #     uint32 ledgerSeq;
    #     SCPEnvelope messages<>;
    # };
    def __init__(self, ledgerSeq=None, messages=None):
        self.ledgerSeq = ledgerSeq
        self.messages = messages

    def __repr__(self):
        out = []
        if self.ledgerSeq is not None:
            out += ['ledgerSeq=%s' % repr(self.ledgerSeq)]
        if self.messages is not None:
            out += ['messages=%s' % repr(self.messages)]
        return 'LedgerSCPMessages(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPHistoryEntryV0:
    # XDR definition:
    # struct SCPHistoryEntryV0 {
    #     SCPQuorumSet quorumSets<>;
    #     LedgerSCPMessages ledgerMessages;
    # };
    def __init__(self, quorumSets=None, ledgerMessages=None):
        self.quorumSets = quorumSets
        self.ledgerMessages = ledgerMessages

    def __getattr__(self, attr):
        return getattr(self.ledgerMessages, attr)

    def __repr__(self):
        out = []
        if self.quorumSets is not None:
            out += ['quorumSets=%s' % repr(self.quorumSets)]
        if self.ledgerMessages is not None:
            out += ['ledgerMessages=%s' % repr(self.ledgerMessages)]
        return 'SCPHistoryEntryV0(%s)' % ', '.join(out)
    __str__ = __repr__

class SCPHistoryEntry:
    # XDR definition:
    # union SCPHistoryEntry switch(int v) {
    #     case 0:
    #         SCPHistoryEntryV0 v0;
    # };
    def __init__(self, v=None, v0=None):
        self.v = v
        self.v0 = v0

    switch = property(lambda s: {0:s.v0,}[s.v])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.v is not None:
            out += ['v=%s' % repr(self.v)]
        if self.v0 is not None:
            out += ['v0=%s' % repr(self.v0)]
        return 'SCPHistoryEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerEntryChange:
    # XDR definition:
    # union LedgerEntryChange switch(LedgerEntryChangeType type) {
    #     case LEDGER_ENTRY_CREATED:
    #         LedgerEntry created;
    #     case LEDGER_ENTRY_UPDATED:
    #         LedgerEntry updated;
    #     case LEDGER_ENTRY_REMOVED:
    #         LedgerKey removed;
    #     case LEDGER_ENTRY_STATE:
    #         LedgerEntry state;
    # };
    def __init__(self, type=None, created=None, updated=None, removed=None, state=None):
        self.type = type
        self.created = created
        self.updated = updated
        self.removed = removed
        self.state = state

    switch = property(lambda s: {const.LEDGER_ENTRY_CREATED:s.created,const.LEDGER_ENTRY_UPDATED:s.updated,const.LEDGER_ENTRY_REMOVED:s.removed,const.LEDGER_ENTRY_STATE:s.state,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.LedgerEntryChangeType.get(self.type, self.type)]
        if self.created is not None:
            out += ['created=%s' % repr(self.created)]
        if self.updated is not None:
            out += ['updated=%s' % repr(self.updated)]
        if self.removed is not None:
            out += ['removed=%s' % repr(self.removed)]
        if self.state is not None:
            out += ['state=%s' % repr(self.state)]
        return 'LedgerEntryChange(%s)' % ', '.join(out)
    __str__ = __repr__

class OperationMeta:
    # XDR definition:
    # struct OperationMeta {
    #     LedgerEntryChanges changes;
    # };
    def __init__(self, changes=None):
        self.changes = changes

    def __repr__(self):
        out = []
        if self.changes is not None:
            out += ['changes=%s' % repr(self.changes)]
        return 'OperationMeta(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionMetaV1:
    # XDR definition:
    # struct TransactionMetaV1 {
    #     LedgerEntryChanges txChanges;
    #     OperationMeta operations<>;
    # };
    def __init__(self, txChanges=None, operations=None):
        self.txChanges = txChanges
        self.operations = operations

    def __repr__(self):
        out = []
        if self.txChanges is not None:
            out += ['txChanges=%s' % repr(self.txChanges)]
        if self.operations is not None:
            out += ['operations=%s' % repr(self.operations)]
        return 'TransactionMetaV1(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionMeta:
    # XDR definition:
    # union TransactionMeta switch(int v) {
    #     case 0:
    #         OperationMeta operations<>;
    #     case 1:
    #         TransactionMetaV1 v1;
    # };
    def __init__(self, v=None, operations=None, v1=None):
        self.v = v
        self.operations = operations
        self.v1 = v1

    switch = property(lambda s: {0:s.operations,1:s.v1,}[s.v])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.v is not None:
            out += ['v=%s' % repr(self.v)]
        if self.operations is not None:
            out += ['operations=%s' % repr(self.operations)]
        if self.v1 is not None:
            out += ['v1=%s' % repr(self.v1)]
        return 'TransactionMeta(%s)' % ', '.join(out)
    __str__ = __repr__

AccountID = PublicKey
class Asset:
    # XDR definition:
    # union Asset switch(AssetType type) {
    #     case ASSET_TYPE_NATIVE:
    #         void;
    #     case ASSET_TYPE_CREDIT_ALPHANUM4:
    #         struct {
    #             opaque assetCode[4];
    #             AccountID issuer;
    #         } alphaNum4;
    #     case ASSET_TYPE_CREDIT_ALPHANUM12:
    #         struct {
    #             opaque assetCode[12];
    #             AccountID issuer;
    #         } alphaNum12;
    # };
    def __init__(self, type=None, alphaNum4=None, alphaNum12=None):
        self.type = type
        self.alphaNum4 = alphaNum4
        self.alphaNum12 = alphaNum12

    switch = property(lambda s: {const.ASSET_TYPE_NATIVE:None,const.ASSET_TYPE_CREDIT_ALPHANUM4:s.alphaNum4,const.ASSET_TYPE_CREDIT_ALPHANUM12:s.alphaNum12,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.AssetType.get(self.type, self.type)]
        if self.alphaNum4 is not None:
            out += ['alphaNum4=%s' % repr(self.alphaNum4)]
        if self.alphaNum12 is not None:
            out += ['alphaNum12=%s' % repr(self.alphaNum12)]
        return 'Asset(%s)' % ', '.join(out)
    __str__ = __repr__

class Price:
    # XDR definition:
    # struct Price {
    #     int32 n;
    #     int32 d;
    # };
    def __init__(self, n=None, d=None):
        self.n = n
        self.d = d

    def __repr__(self):
        out = []
        if self.n is not None:
            out += ['n=%s' % repr(self.n)]
        if self.d is not None:
            out += ['d=%s' % repr(self.d)]
        return 'Price(%s)' % ', '.join(out)
    __str__ = __repr__

class Liabilities:
    # XDR definition:
    # struct Liabilities {
    #     int64 buying;
    #     int64 selling;
    # };
    def __init__(self, buying=None, selling=None):
        self.buying = buying
        self.selling = selling

    def __repr__(self):
        out = []
        if self.buying is not None:
            out += ['buying=%s' % repr(self.buying)]
        if self.selling is not None:
            out += ['selling=%s' % repr(self.selling)]
        return 'Liabilities(%s)' % ', '.join(out)
    __str__ = __repr__

class Signer:
    # XDR definition:
    # struct Signer {
    #     SignerKey key;
    #     uint32 weight;
    # };
    def __init__(self, key=None, weight=None):
        self.key = key
        self.weight = weight

    def __getattr__(self, attr):
        return getattr(self.key, attr)

    def __repr__(self):
        out = []
        if self.key is not None:
            out += ['key=%s' % repr(self.key)]
        if self.weight is not None:
            out += ['weight=%s' % repr(self.weight)]
        return 'Signer(%s)' % ', '.join(out)
    __str__ = __repr__

class AccountEntry:
    # XDR definition:
    # struct AccountEntry {
    #     AccountID accountID;
    #     int64 balance;
    #     SequenceNumber seqNum;
    #     uint32 numSubEntries;
    #     AccountID inflationDest<1>;
    #     uint32 flags;
    #     string32 homeDomain;
    #     Thresholds thresholds;
    #     Signer signers<20>;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #         case 1:
    #             struct {
    #                 Liabilities liabilities;
    #                 union switch(int v) {
    #                     case 0:
    #                         void;
    #                 } ext;
    #             } v1;
    #     } ext;
    # };
    def __init__(self, accountID=None, balance=None, seqNum=None, numSubEntries=None, inflationDest=None, flags=None, homeDomain=None, thresholds=None, signers=None, ext=None):
        self.accountID = accountID
        self.balance = balance
        self.seqNum = seqNum
        self.numSubEntries = numSubEntries
        self.inflationDest = inflationDest
        self.flags = flags
        self.homeDomain = homeDomain
        self.thresholds = thresholds
        self.signers = signers
        self.ext = ext

    def __repr__(self):
        out = []
        if self.accountID is not None:
            out += ['accountID=%s' % repr(self.accountID)]
        if self.balance is not None:
            out += ['balance=%s' % repr(self.balance)]
        if self.seqNum is not None:
            out += ['seqNum=%s' % repr(self.seqNum)]
        if self.numSubEntries is not None:
            out += ['numSubEntries=%s' % repr(self.numSubEntries)]
        if self.inflationDest is not None:
            out += ['inflationDest=%s' % repr(self.inflationDest)]
        if self.flags is not None:
            out += ['flags=%s' % repr(self.flags)]
        if self.homeDomain is not None:
            out += ['homeDomain=%s' % repr(self.homeDomain)]
        if self.thresholds is not None:
            out += ['thresholds=%s' % repr(self.thresholds)]
        if self.signers is not None:
            out += ['signers=%s' % repr(self.signers)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'AccountEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class TrustLineEntry:
    # XDR definition:
    # struct TrustLineEntry {
    #     AccountID accountID;
    #     Asset asset;
    #     int64 balance;
    #     int64 limit;
    #     uint32 flags;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #         case 1:
    #             struct {
    #                 Liabilities liabilities;
    #                 union switch(int v) {
    #                     case 0:
    #                         void;
    #                 } ext;
    #             } v1;
    #     } ext;
    # };
    def __init__(self, accountID=None, asset=None, balance=None, limit=None, flags=None, ext=None):
        self.accountID = accountID
        self.asset = asset
        self.balance = balance
        self.limit = limit
        self.flags = flags
        self.ext = ext

    def __repr__(self):
        out = []
        if self.accountID is not None:
            out += ['accountID=%s' % repr(self.accountID)]
        if self.asset is not None:
            out += ['asset=%s' % repr(self.asset)]
        if self.balance is not None:
            out += ['balance=%s' % repr(self.balance)]
        if self.limit is not None:
            out += ['limit=%s' % repr(self.limit)]
        if self.flags is not None:
            out += ['flags=%s' % repr(self.flags)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'TrustLineEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class OfferEntry:
    # XDR definition:
    # struct OfferEntry {
    #     AccountID sellerID;
    #     uint64 offerID;
    #     Asset selling;
    #     Asset buying;
    #     int64 amount;
    #     Price price;
    #     uint32 flags;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, sellerID=None, offerID=None, selling=None, buying=None, amount=None, price=None, flags=None, ext=None):
        self.sellerID = sellerID
        self.offerID = offerID
        self.selling = selling
        self.buying = buying
        self.amount = amount
        self.price = price
        self.flags = flags
        self.ext = ext

    def __repr__(self):
        out = []
        if self.sellerID is not None:
            out += ['sellerID=%s' % repr(self.sellerID)]
        if self.offerID is not None:
            out += ['offerID=%s' % repr(self.offerID)]
        if self.selling is not None:
            out += ['selling=%s' % repr(self.selling)]
        if self.buying is not None:
            out += ['buying=%s' % repr(self.buying)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        if self.price is not None:
            out += ['price=%s' % repr(self.price)]
        if self.flags is not None:
            out += ['flags=%s' % repr(self.flags)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'OfferEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class DataEntry:
    # XDR definition:
    # struct DataEntry {
    #     AccountID accountID;
    #     string64 dataName;
    #     DataValue dataValue;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, accountID=None, dataName=None, dataValue=None, ext=None):
        self.accountID = accountID
        self.dataName = dataName
        self.dataValue = dataValue
        self.ext = ext

    def __repr__(self):
        out = []
        if self.accountID is not None:
            out += ['accountID=%s' % repr(self.accountID)]
        if self.dataName is not None:
            out += ['dataName=%s' % repr(self.dataName)]
        if self.dataValue is not None:
            out += ['dataValue=%s' % repr(self.dataValue)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'DataEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class LedgerEntry:
    # XDR definition:
    # struct LedgerEntry {
    #     uint32 lastModifiedLedgerSeq;
    #     union switch(LedgerEntryType type) {
    #         case ACCOUNT:
    #             AccountEntry account;
    #         case TRUSTLINE:
    #             TrustLineEntry trustLine;
    #         case OFFER:
    #             OfferEntry offer;
    #         case DATA:
    #             DataEntry data;
    #     } data;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, lastModifiedLedgerSeq=None, data=None, ext=None):
        self.lastModifiedLedgerSeq = lastModifiedLedgerSeq
        self.data = data
        self.ext = ext

    def __repr__(self):
        out = []
        if self.lastModifiedLedgerSeq is not None:
            out += ['lastModifiedLedgerSeq=%s' % repr(self.lastModifiedLedgerSeq)]
        if self.data is not None:
            out += ['data=%s' % repr(self.data)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'LedgerEntry(%s)' % ', '.join(out)
    __str__ = __repr__

class DecoratedSignature:
    # XDR definition:
    # struct DecoratedSignature {
    #     SignatureHint hint;
    #     Signature signature;
    # };
    def __init__(self, hint=None, signature=None):
        self.hint = hint
        self.signature = signature

    def __repr__(self):
        out = []
        if self.hint is not None:
            out += ['hint=%s' % repr(self.hint)]
        if self.signature is not None:
            out += ['signature=%s' % repr(self.signature)]
        return 'DecoratedSignature(%s)' % ', '.join(out)
    __str__ = __repr__

class CreateAccountOp:
    # XDR definition:
    # struct CreateAccountOp {
    #     AccountID destination;
    #     int64 startingBalance;
    # };
    def __init__(self, destination=None, startingBalance=None):
        self.destination = destination
        self.startingBalance = startingBalance

    def __getattr__(self, attr):
        return getattr(self.destination, attr)

    def __repr__(self):
        out = []
        if self.destination is not None:
            out += ['destination=%s' % repr(self.destination)]
        if self.startingBalance is not None:
            out += ['startingBalance=%s' % repr(self.startingBalance)]
        return 'CreateAccountOp(%s)' % ', '.join(out)
    __str__ = __repr__

class PaymentOp:
    # XDR definition:
    # struct PaymentOp {
    #     AccountID destination;
    #     Asset asset;
    #     int64 amount;
    # };
    def __init__(self, destination=None, asset=None, amount=None):
        self.destination = destination
        self.asset = asset
        self.amount = amount

    def __repr__(self):
        out = []
        if self.destination is not None:
            out += ['destination=%s' % repr(self.destination)]
        if self.asset is not None:
            out += ['asset=%s' % repr(self.asset)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        return 'PaymentOp(%s)' % ', '.join(out)
    __str__ = __repr__

class PathPaymentOp:
    # XDR definition:
    # struct PathPaymentOp {
    #     Asset sendAsset;
    #     int64 sendMax;
    #     AccountID destination;
    #     Asset destAsset;
    #     int64 destAmount;
    #     Asset path<5>;
    # };
    def __init__(self, sendAsset=None, sendMax=None, destination=None, destAsset=None, destAmount=None, path=None):
        self.sendAsset = sendAsset
        self.sendMax = sendMax
        self.destination = destination
        self.destAsset = destAsset
        self.destAmount = destAmount
        self.path = path

    def __repr__(self):
        out = []
        if self.sendAsset is not None:
            out += ['sendAsset=%s' % repr(self.sendAsset)]
        if self.sendMax is not None:
            out += ['sendMax=%s' % repr(self.sendMax)]
        if self.destination is not None:
            out += ['destination=%s' % repr(self.destination)]
        if self.destAsset is not None:
            out += ['destAsset=%s' % repr(self.destAsset)]
        if self.destAmount is not None:
            out += ['destAmount=%s' % repr(self.destAmount)]
        if self.path is not None:
            out += ['path=%s' % repr(self.path)]
        return 'PathPaymentOp(%s)' % ', '.join(out)
    __str__ = __repr__

class ManageOfferOp:
    # XDR definition:
    # struct ManageOfferOp {
    #     Asset selling;
    #     Asset buying;
    #     int64 amount;
    #     Price price;
    #     uint64 offerID;
    # };
    def __init__(self, selling=None, buying=None, amount=None, price=None, offerID=None):
        self.selling = selling
        self.buying = buying
        self.amount = amount
        self.price = price
        self.offerID = offerID

    def __repr__(self):
        out = []
        if self.selling is not None:
            out += ['selling=%s' % repr(self.selling)]
        if self.buying is not None:
            out += ['buying=%s' % repr(self.buying)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        if self.price is not None:
            out += ['price=%s' % repr(self.price)]
        if self.offerID is not None:
            out += ['offerID=%s' % repr(self.offerID)]
        return 'ManageOfferOp(%s)' % ', '.join(out)
    __str__ = __repr__

class CreatePassiveOfferOp:
    # XDR definition:
    # struct CreatePassiveOfferOp {
    #     Asset selling;
    #     Asset buying;
    #     int64 amount;
    #     Price price;
    # };
    def __init__(self, selling=None, buying=None, amount=None, price=None):
        self.selling = selling
        self.buying = buying
        self.amount = amount
        self.price = price

    def __repr__(self):
        out = []
        if self.selling is not None:
            out += ['selling=%s' % repr(self.selling)]
        if self.buying is not None:
            out += ['buying=%s' % repr(self.buying)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        if self.price is not None:
            out += ['price=%s' % repr(self.price)]
        return 'CreatePassiveOfferOp(%s)' % ', '.join(out)
    __str__ = __repr__

class SetOptionsOp:
    # XDR definition:
    # struct SetOptionsOp {
    #     AccountID inflationDest<1>;
    #     uint32 clearFlags<1>;
    #     uint32 setFlags<1>;
    #     uint32 masterWeight<1>;
    #     uint32 lowThreshold<1>;
    #     uint32 medThreshold<1>;
    #     uint32 highThreshold<1>;
    #     string32 homeDomain<1>;
    #     Signer signer<1>;
    # };
    def __init__(self, inflationDest=None, clearFlags=None, setFlags=None, masterWeight=None, lowThreshold=None, medThreshold=None, highThreshold=None, homeDomain=None, signer=None):
        self.inflationDest = inflationDest
        self.clearFlags = clearFlags
        self.setFlags = setFlags
        self.masterWeight = masterWeight
        self.lowThreshold = lowThreshold
        self.medThreshold = medThreshold
        self.highThreshold = highThreshold
        self.homeDomain = homeDomain
        self.signer = signer

    def __repr__(self):
        out = []
        if self.inflationDest is not None:
            out += ['inflationDest=%s' % repr(self.inflationDest)]
        if self.clearFlags is not None:
            out += ['clearFlags=%s' % repr(self.clearFlags)]
        if self.setFlags is not None:
            out += ['setFlags=%s' % repr(self.setFlags)]
        if self.masterWeight is not None:
            out += ['masterWeight=%s' % repr(self.masterWeight)]
        if self.lowThreshold is not None:
            out += ['lowThreshold=%s' % repr(self.lowThreshold)]
        if self.medThreshold is not None:
            out += ['medThreshold=%s' % repr(self.medThreshold)]
        if self.highThreshold is not None:
            out += ['highThreshold=%s' % repr(self.highThreshold)]
        if self.homeDomain is not None:
            out += ['homeDomain=%s' % repr(self.homeDomain)]
        if self.signer is not None:
            out += ['signer=%s' % repr(self.signer)]
        return 'SetOptionsOp(%s)' % ', '.join(out)
    __str__ = __repr__

class ChangeTrustOp:
    # XDR definition:
    # struct ChangeTrustOp {
    #     Asset line;
    #     int64 limit;
    # };
    def __init__(self, line=None, limit=None):
        self.line = line
        self.limit = limit

    def __getattr__(self, attr):
        return getattr(self.line, attr)

    def __repr__(self):
        out = []
        if self.line is not None:
            out += ['line=%s' % repr(self.line)]
        if self.limit is not None:
            out += ['limit=%s' % repr(self.limit)]
        return 'ChangeTrustOp(%s)' % ', '.join(out)
    __str__ = __repr__

class AllowTrustOp:
    # XDR definition:
    # struct AllowTrustOp {
    #     AccountID trustor;
    #     union switch(AssetType type) {
    #         case ASSET_TYPE_CREDIT_ALPHANUM4:
    #             opaque assetCode4[4];
    #         case ASSET_TYPE_CREDIT_ALPHANUM12:
    #             opaque assetCode12[12];
    #     } asset;
    #     bool authorize;
    # };
    def __init__(self, trustor=None, asset=None, authorize=None):
        self.trustor = trustor
        self.asset = asset
        self.authorize = authorize

    def __repr__(self):
        out = []
        if self.trustor is not None:
            out += ['trustor=%s' % repr(self.trustor)]
        if self.asset is not None:
            out += ['asset=%s' % repr(self.asset)]
        if self.authorize is not None:
            out += ['authorize=%s' % repr(self.authorize)]
        return 'AllowTrustOp(%s)' % ', '.join(out)
    __str__ = __repr__

class ManageDataOp:
    # XDR definition:
    # struct ManageDataOp {
    #     string64 dataName;
    #     DataValue dataValue<1>;
    # };
    def __init__(self, dataName=None, dataValue=None):
        self.dataName = dataName
        self.dataValue = dataValue

    def __repr__(self):
        out = []
        if self.dataName is not None:
            out += ['dataName=%s' % repr(self.dataName)]
        if self.dataValue is not None:
            out += ['dataValue=%s' % repr(self.dataValue)]
        return 'ManageDataOp(%s)' % ', '.join(out)
    __str__ = __repr__

class BumpSequenceOp:
    # XDR definition:
    # struct BumpSequenceOp {
    #     SequenceNumber bumpTo;
    # };
    def __init__(self, bumpTo=None):
        self.bumpTo = bumpTo

    def __repr__(self):
        out = []
        if self.bumpTo is not None:
            out += ['bumpTo=%s' % repr(self.bumpTo)]
        return 'BumpSequenceOp(%s)' % ', '.join(out)
    __str__ = __repr__

class Operation:
    # XDR definition:
    # struct Operation {
    #     AccountID sourceAccount<1>;
    #     union switch(OperationType type) {
    #         case CREATE_ACCOUNT:
    #             CreateAccountOp createAccountOp;
    #         case PAYMENT:
    #             PaymentOp paymentOp;
    #         case PATH_PAYMENT:
    #             PathPaymentOp pathPaymentOp;
    #         case MANAGE_OFFER:
    #             ManageOfferOp manageOfferOp;
    #         case CREATE_PASSIVE_OFFER:
    #             CreatePassiveOfferOp createPassiveOfferOp;
    #         case SET_OPTIONS:
    #             SetOptionsOp setOptionsOp;
    #         case CHANGE_TRUST:
    #             ChangeTrustOp changeTrustOp;
    #         case ALLOW_TRUST:
    #             AllowTrustOp allowTrustOp;
    #         case ACCOUNT_MERGE:
    #             AccountID destination;
    #         case INFLATION:
    #             void;
    #         case MANAGE_DATA:
    #             ManageDataOp manageDataOp;
    #         case BUMP_SEQUENCE:
    #             BumpSequenceOp bumpSequenceOp;
    #     } body;
    # };
    def __init__(self, sourceAccount=None, body=None):
        self.sourceAccount = sourceAccount
        self.body = body

    def __getattr__(self, attr):
        return getattr(self.body, attr)

    def __repr__(self):
        out = []
        if self.sourceAccount is not None:
            out += ['sourceAccount=%s' % repr(self.sourceAccount)]
        if self.body is not None:
            out += ['body=%s' % repr(self.body)]
        return 'Operation(%s)' % ', '.join(out)
    __str__ = __repr__

class Memo:
    # XDR definition:
    # union Memo switch(MemoType type) {
    #     case MEMO_NONE:
    #         void;
    #     case MEMO_TEXT:
    #         string text<28>;
    #     case MEMO_ID:
    #         uint64 id;
    #     case MEMO_HASH:
    #         Hash hash;
    #     case MEMO_RETURN:
    #         Hash retHash;
    # };
    def __init__(self, type=None, text=None, id=None, hash=None, retHash=None):
        self.type = type
        self.text = text
        self.id = id
        self.hash = hash
        self.retHash = retHash

    switch = property(lambda s: {const.MEMO_NONE:None,const.MEMO_TEXT:s.text,const.MEMO_ID:s.id,const.MEMO_HASH:s.hash,const.MEMO_RETURN:s.retHash,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.MemoType.get(self.type, self.type)]
        if self.text is not None:
            out += ['text=%s' % repr(self.text)]
        if self.id is not None:
            out += ['id=%s' % repr(self.id)]
        if self.hash is not None:
            out += ['hash=%s' % repr(self.hash)]
        if self.retHash is not None:
            out += ['retHash=%s' % repr(self.retHash)]
        return 'Memo(%s)' % ', '.join(out)
    __str__ = __repr__

class TimeBounds:
    # XDR definition:
    # struct TimeBounds {
    #     uint64 minTime;
    #     uint64 maxTime;
    # };
    def __init__(self, minTime=None, maxTime=None):
        self.minTime = minTime
        self.maxTime = maxTime

    def __repr__(self):
        out = []
        if self.minTime is not None:
            out += ['minTime=%s' % repr(self.minTime)]
        if self.maxTime is not None:
            out += ['maxTime=%s' % repr(self.maxTime)]
        return 'TimeBounds(%s)' % ', '.join(out)
    __str__ = __repr__

class Transaction:
    # XDR definition:
    # struct Transaction {
    #     AccountID sourceAccount;
    #     uint32 fee;
    #     SequenceNumber seqNum;
    #     TimeBounds timeBounds<1>;
    #     Memo memo;
    #     Operation operations<100>;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, sourceAccount=None, fee=None, seqNum=None, timeBounds=None, memo=None, operations=None, ext=None):
        self.sourceAccount = sourceAccount
        self.fee = fee
        self.seqNum = seqNum
        self.timeBounds = timeBounds
        self.memo = memo
        self.operations = operations
        self.ext = ext

    def __repr__(self):
        out = []
        if self.sourceAccount is not None:
            out += ['sourceAccount=%s' % repr(self.sourceAccount)]
        if self.fee is not None:
            out += ['fee=%s' % repr(self.fee)]
        if self.seqNum is not None:
            out += ['seqNum=%s' % repr(self.seqNum)]
        if self.timeBounds is not None:
            out += ['timeBounds=%s' % repr(self.timeBounds)]
        if self.memo is not None:
            out += ['memo=%s' % repr(self.memo)]
        if self.operations is not None:
            out += ['operations=%s' % repr(self.operations)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'Transaction(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionSignaturePayload:
    # XDR definition:
    # struct TransactionSignaturePayload {
    #     Hash networkId;
    #     union switch(EnvelopeType type) {
    #         case ENVELOPE_TYPE_TX:
    #             Transaction tx;
    #     } taggedTransaction;
    # };
    def __init__(self, networkId=None, taggedTransaction=None):
        self.networkId = networkId
        self.taggedTransaction = taggedTransaction

    def __getattr__(self, attr):
        return getattr(self.taggedTransaction, attr)

    def __repr__(self):
        out = []
        if self.networkId is not None:
            out += ['networkId=%s' % repr(self.networkId)]
        if self.taggedTransaction is not None:
            out += ['taggedTransaction=%s' % repr(self.taggedTransaction)]
        return 'TransactionSignaturePayload(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionEnvelope:
    # XDR definition:
    # struct TransactionEnvelope {
    #     Transaction tx;
    #     DecoratedSignature signatures<20>;
    # };
    def __init__(self, tx=None, signatures=None):
        self.tx = tx
        self.signatures = signatures

    def __getattr__(self, attr):
        return getattr(self.tx, attr)

    def __repr__(self):
        out = []
        if self.tx is not None:
            out += ['tx=%s' % repr(self.tx)]
        if self.signatures is not None:
            out += ['signatures=%s' % repr(self.signatures)]
        return 'TransactionEnvelope(%s)' % ', '.join(out)
    __str__ = __repr__

class ClaimOfferAtom:
    # XDR definition:
    # struct ClaimOfferAtom {
    #     AccountID sellerID;
    #     uint64 offerID;
    #     Asset assetSold;
    #     int64 amountSold;
    #     Asset assetBought;
    #     int64 amountBought;
    # };
    def __init__(self, sellerID=None, offerID=None, assetSold=None, amountSold=None, assetBought=None, amountBought=None):
        self.sellerID = sellerID
        self.offerID = offerID
        self.assetSold = assetSold
        self.amountSold = amountSold
        self.assetBought = assetBought
        self.amountBought = amountBought

    def __repr__(self):
        out = []
        if self.sellerID is not None:
            out += ['sellerID=%s' % repr(self.sellerID)]
        if self.offerID is not None:
            out += ['offerID=%s' % repr(self.offerID)]
        if self.assetSold is not None:
            out += ['assetSold=%s' % repr(self.assetSold)]
        if self.amountSold is not None:
            out += ['amountSold=%s' % repr(self.amountSold)]
        if self.assetBought is not None:
            out += ['assetBought=%s' % repr(self.assetBought)]
        if self.amountBought is not None:
            out += ['amountBought=%s' % repr(self.amountBought)]
        return 'ClaimOfferAtom(%s)' % ', '.join(out)
    __str__ = __repr__

class CreateAccountResult:
    # XDR definition:
    # union CreateAccountResult switch(CreateAccountResultCode code) {
    #     case CREATE_ACCOUNT_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.CREATE_ACCOUNT_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.CreateAccountResultCode.get(self.code, self.code)]
        return 'CreateAccountResult(%s)' % ', '.join(out)
    __str__ = __repr__

class PaymentResult:
    # XDR definition:
    # union PaymentResult switch(PaymentResultCode code) {
    #     case PAYMENT_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.PAYMENT_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.PaymentResultCode.get(self.code, self.code)]
        return 'PaymentResult(%s)' % ', '.join(out)
    __str__ = __repr__

class SimplePaymentResult:
    # XDR definition:
    # struct SimplePaymentResult {
    #     AccountID destination;
    #     Asset asset;
    #     int64 amount;
    # };
    def __init__(self, destination=None, asset=None, amount=None):
        self.destination = destination
        self.asset = asset
        self.amount = amount

    def __repr__(self):
        out = []
        if self.destination is not None:
            out += ['destination=%s' % repr(self.destination)]
        if self.asset is not None:
            out += ['asset=%s' % repr(self.asset)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        return 'SimplePaymentResult(%s)' % ', '.join(out)
    __str__ = __repr__

class PathPaymentResult:
    # XDR definition:
    # union PathPaymentResult switch(PathPaymentResultCode code) {
    #     case PATH_PAYMENT_SUCCESS:
    #         struct {
    #             ClaimOfferAtom offers<>;
    #             SimplePaymentResult last;
    #         } success;
    #     case PATH_PAYMENT_NO_ISSUER:
    #         Asset noIssuer;
    #     default:
    #         void;
    # };
    def __init__(self, code=None, success=None, noIssuer=None):
        self.code = code
        self.success = success
        self.noIssuer = noIssuer

    switch = property(lambda s: {const.PATH_PAYMENT_SUCCESS:s.success,const.PATH_PAYMENT_NO_ISSUER:s.noIssuer,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.PathPaymentResultCode.get(self.code, self.code)]
        if self.success is not None:
            out += ['success=%s' % repr(self.success)]
        if self.noIssuer is not None:
            out += ['noIssuer=%s' % repr(self.noIssuer)]
        return 'PathPaymentResult(%s)' % ', '.join(out)
    __str__ = __repr__

class ManageOfferSuccessResult:
    # XDR definition:
    # struct ManageOfferSuccessResult {
    #     ClaimOfferAtom offersClaimed<>;
    #     union switch(ManageOfferEffect effect) {
    #         case MANAGE_OFFER_CREATED:
    #         case MANAGE_OFFER_UPDATED:
    #             OfferEntry offer;
    #         default:
    #             void;
    #     } offer;
    # };
    def __init__(self, offersClaimed=None, offer=None):
        self.offersClaimed = offersClaimed
        self.offer = offer

    def __getattr__(self, attr):
        return getattr(self.offer, attr)

    def __repr__(self):
        out = []
        if self.offersClaimed is not None:
            out += ['offersClaimed=%s' % repr(self.offersClaimed)]
        if self.offer is not None:
            out += ['offer=%s' % repr(self.offer)]
        return 'ManageOfferSuccessResult(%s)' % ', '.join(out)
    __str__ = __repr__

class ManageOfferResult:
    # XDR definition:
    # union ManageOfferResult switch(ManageOfferResultCode code) {
    #     case MANAGE_OFFER_SUCCESS:
    #         ManageOfferSuccessResult success;
    #     default:
    #         void;
    # };
    def __init__(self, code=None, success=None):
        self.code = code
        self.success = success

    switch = property(lambda s: {const.MANAGE_OFFER_SUCCESS:s.success,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.ManageOfferResultCode.get(self.code, self.code)]
        if self.success is not None:
            out += ['success=%s' % repr(self.success)]
        return 'ManageOfferResult(%s)' % ', '.join(out)
    __str__ = __repr__

class SetOptionsResult:
    # XDR definition:
    # union SetOptionsResult switch(SetOptionsResultCode code) {
    #     case SET_OPTIONS_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.SET_OPTIONS_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.SetOptionsResultCode.get(self.code, self.code)]
        return 'SetOptionsResult(%s)' % ', '.join(out)
    __str__ = __repr__

class ChangeTrustResult:
    # XDR definition:
    # union ChangeTrustResult switch(ChangeTrustResultCode code) {
    #     case CHANGE_TRUST_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.CHANGE_TRUST_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.ChangeTrustResultCode.get(self.code, self.code)]
        return 'ChangeTrustResult(%s)' % ', '.join(out)
    __str__ = __repr__

class AllowTrustResult:
    # XDR definition:
    # union AllowTrustResult switch(AllowTrustResultCode code) {
    #     case ALLOW_TRUST_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.ALLOW_TRUST_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.AllowTrustResultCode.get(self.code, self.code)]
        return 'AllowTrustResult(%s)' % ', '.join(out)
    __str__ = __repr__

class AccountMergeResult:
    # XDR definition:
    # union AccountMergeResult switch(AccountMergeResultCode code) {
    #     case ACCOUNT_MERGE_SUCCESS:
    #         int64 sourceAccountBalance;
    #     default:
    #         void;
    # };
    def __init__(self, code=None, sourceAccountBalance=None):
        self.code = code
        self.sourceAccountBalance = sourceAccountBalance

    switch = property(lambda s: {const.ACCOUNT_MERGE_SUCCESS:s.sourceAccountBalance,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.AccountMergeResultCode.get(self.code, self.code)]
        if self.sourceAccountBalance is not None:
            out += ['sourceAccountBalance=%s' % repr(self.sourceAccountBalance)]
        return 'AccountMergeResult(%s)' % ', '.join(out)
    __str__ = __repr__

class InflationPayout:
    # XDR definition:
    # struct InflationPayout {
    #     AccountID destination;
    #     int64 amount;
    # };
    def __init__(self, destination=None, amount=None):
        self.destination = destination
        self.amount = amount

    def __getattr__(self, attr):
        return getattr(self.destination, attr)

    def __repr__(self):
        out = []
        if self.destination is not None:
            out += ['destination=%s' % repr(self.destination)]
        if self.amount is not None:
            out += ['amount=%s' % repr(self.amount)]
        return 'InflationPayout(%s)' % ', '.join(out)
    __str__ = __repr__

class InflationResult:
    # XDR definition:
    # union InflationResult switch(InflationResultCode code) {
    #     case INFLATION_SUCCESS:
    #         InflationPayout payouts<>;
    #     default:
    #         void;
    # };
    def __init__(self, code=None, payouts=None):
        self.code = code
        self.payouts = payouts

    switch = property(lambda s: {const.INFLATION_SUCCESS:s.payouts,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.InflationResultCode.get(self.code, self.code)]
        if self.payouts is not None:
            out += ['payouts=%s' % repr(self.payouts)]
        return 'InflationResult(%s)' % ', '.join(out)
    __str__ = __repr__

class ManageDataResult:
    # XDR definition:
    # union ManageDataResult switch(ManageDataResultCode code) {
    #     case MANAGE_DATA_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.MANAGE_DATA_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.ManageDataResultCode.get(self.code, self.code)]
        return 'ManageDataResult(%s)' % ', '.join(out)
    __str__ = __repr__

class BumpSequenceResult:
    # XDR definition:
    # union BumpSequenceResult switch(BumpSequenceResultCode code) {
    #     case BUMP_SEQUENCE_SUCCESS:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, code=None):
        self.code = code

    switch = property(lambda s: {const.BUMP_SEQUENCE_SUCCESS:None,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.BumpSequenceResultCode.get(self.code, self.code)]
        return 'BumpSequenceResult(%s)' % ', '.join(out)
    __str__ = __repr__

class OperationResult:
    # XDR definition:
    # union OperationResult switch(OperationResultCode code) {
    #     case opINNER:
    #         union switch(OperationType type) {
    #             case CREATE_ACCOUNT:
    #                 CreateAccountResult createAccountResult;
    #             case PAYMENT:
    #                 PaymentResult paymentResult;
    #             case PATH_PAYMENT:
    #                 PathPaymentResult pathPaymentResult;
    #             case MANAGE_OFFER:
    #                 ManageOfferResult manageOfferResult;
    #             case CREATE_PASSIVE_OFFER:
    #                 ManageOfferResult createPassiveOfferResult;
    #             case SET_OPTIONS:
    #                 SetOptionsResult setOptionsResult;
    #             case CHANGE_TRUST:
    #                 ChangeTrustResult changeTrustResult;
    #             case ALLOW_TRUST:
    #                 AllowTrustResult allowTrustResult;
    #             case ACCOUNT_MERGE:
    #                 AccountMergeResult accountMergeResult;
    #             case INFLATION:
    #                 InflationResult inflationResult;
    #             case MANAGE_DATA:
    #                 ManageDataResult manageDataResult;
    #             case BUMP_SEQUENCE:
    #                 BumpSequenceResult bumpSeqResult;
    #         } tr;
    #     default:
    #         void;
    # };
    def __init__(self, code=None, tr=None):
        self.code = code
        self.tr = tr

    switch = property(lambda s: {const.opINNER:s.tr,}.get(s.code, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.OperationResultCode.get(self.code, self.code)]
        if self.tr is not None:
            out += ['tr=%s' % repr(self.tr)]
        return 'OperationResult(%s)' % ', '.join(out)
    __str__ = __repr__

class TransactionResult:
    # XDR definition:
    # struct TransactionResult {
    #     int64 feeCharged;
    #     union switch(TransactionResultCode code) {
    #         case txSUCCESS:
    #         case txFAILED:
    #             OperationResult results<>;
    #         default:
    #             void;
    #     } result;
    #     union switch(int v) {
    #         case 0:
    #             void;
    #     } ext;
    # };
    def __init__(self, feeCharged=None, result=None, ext=None):
        self.feeCharged = feeCharged
        self.result = result
        self.ext = ext

    def __repr__(self):
        out = []
        if self.feeCharged is not None:
            out += ['feeCharged=%s' % repr(self.feeCharged)]
        if self.result is not None:
            out += ['result=%s' % repr(self.result)]
        if self.ext is not None:
            out += ['ext=%s' % repr(self.ext)]
        return 'TransactionResult(%s)' % ', '.join(out)
    __str__ = __repr__

class Error:
    # XDR definition:
    # struct Error {
    #     ErrorCode code;
    #     string msg<100>;
    # };
    def __init__(self, code=None, msg=None):
        self.code = code
        self.msg = msg

    def __repr__(self):
        out = []
        if self.code is not None:
            out += ['code=%s' % const.ErrorCode.get(self.code, self.code)]
        if self.msg is not None:
            out += ['msg=%s' % repr(self.msg)]
        return 'Error(%s)' % ', '.join(out)
    __str__ = __repr__

class AuthCert:
    # XDR definition:
    # struct AuthCert {
    #     Curve25519Public pubkey;
    #     uint64 expiration;
    #     Signature sig;
    # };
    def __init__(self, pubkey=None, expiration=None, sig=None):
        self.pubkey = pubkey
        self.expiration = expiration
        self.sig = sig

    def __getattr__(self, attr):
        return getattr(self.pubkey, attr)

    def __repr__(self):
        out = []
        if self.pubkey is not None:
            out += ['pubkey=%s' % repr(self.pubkey)]
        if self.expiration is not None:
            out += ['expiration=%s' % repr(self.expiration)]
        if self.sig is not None:
            out += ['sig=%s' % repr(self.sig)]
        return 'AuthCert(%s)' % ', '.join(out)
    __str__ = __repr__

class Hello:
    # XDR definition:
    # struct Hello {
    #     uint32 ledgerVersion;
    #     uint32 overlayVersion;
    #     uint32 overlayMinVersion;
    #     Hash networkID;
    #     string versionStr<100>;
    #     int listeningPort;
    #     NodeID peerID;
    #     AuthCert cert;
    #     uint256 nonce;
    # };
    def __init__(self, ledgerVersion=None, overlayVersion=None, overlayMinVersion=None, networkID=None, versionStr=None, listeningPort=None, peerID=None, cert=None, nonce=None):
        self.ledgerVersion = ledgerVersion
        self.overlayVersion = overlayVersion
        self.overlayMinVersion = overlayMinVersion
        self.networkID = networkID
        self.versionStr = versionStr
        self.listeningPort = listeningPort
        self.peerID = peerID
        self.cert = cert
        self.nonce = nonce

    def __repr__(self):
        out = []
        if self.ledgerVersion is not None:
            out += ['ledgerVersion=%s' % repr(self.ledgerVersion)]
        if self.overlayVersion is not None:
            out += ['overlayVersion=%s' % repr(self.overlayVersion)]
        if self.overlayMinVersion is not None:
            out += ['overlayMinVersion=%s' % repr(self.overlayMinVersion)]
        if self.networkID is not None:
            out += ['networkID=%s' % repr(self.networkID)]
        if self.versionStr is not None:
            out += ['versionStr=%s' % repr(self.versionStr)]
        if self.listeningPort is not None:
            out += ['listeningPort=%s' % repr(self.listeningPort)]
        if self.peerID is not None:
            out += ['peerID=%s' % repr(self.peerID)]
        if self.cert is not None:
            out += ['cert=%s' % repr(self.cert)]
        if self.nonce is not None:
            out += ['nonce=%s' % repr(self.nonce)]
        return 'Hello(%s)' % ', '.join(out)
    __str__ = __repr__

class Auth:
    # XDR definition:
    # struct Auth {
    #     int unused;
    # };
    def __init__(self, unused=None):
        self.unused = unused

    def __repr__(self):
        out = []
        if self.unused is not None:
            out += ['unused=%s' % repr(self.unused)]
        return 'Auth(%s)' % ', '.join(out)
    __str__ = __repr__

class PeerAddress:
    # XDR definition:
    # struct PeerAddress {
    #     union switch(IPAddrType type) {
    #         case IPv4:
    #             opaque ipv4[4];
    #         case IPv6:
    #             opaque ipv6[16];
    #     } ip;
    #     uint32 port;
    #     uint32 numFailures;
    # };
    def __init__(self, ip=None, port=None, numFailures=None):
        self.ip = ip
        self.port = port
        self.numFailures = numFailures

    def __getattr__(self, attr):
        return getattr(self.ip, attr)

    def __repr__(self):
        out = []
        if self.ip is not None:
            out += ['ip=%s' % repr(self.ip)]
        if self.port is not None:
            out += ['port=%s' % repr(self.port)]
        if self.numFailures is not None:
            out += ['numFailures=%s' % repr(self.numFailures)]
        return 'PeerAddress(%s)' % ', '.join(out)
    __str__ = __repr__

class DontHave:
    # XDR definition:
    # struct DontHave {
    #     MessageType type;
    #     uint256 reqHash;
    # };
    def __init__(self, type=None, reqHash=None):
        self.type = type
        self.reqHash = reqHash

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.MessageType.get(self.type, self.type)]
        if self.reqHash is not None:
            out += ['reqHash=%s' % repr(self.reqHash)]
        return 'DontHave(%s)' % ', '.join(out)
    __str__ = __repr__

class StellarMessage:
    # XDR definition:
    # union StellarMessage switch(MessageType type) {
    #     case ERROR_MSG:
    #         Error error;
    #     case HELLO:
    #         Hello hello;
    #     case AUTH:
    #         Auth auth;
    #     case DONT_HAVE:
    #         DontHave dontHave;
    #     case GET_PEERS:
    #         void;
    #     case PEERS:
    #         PeerAddress peers<100>;
    #     case GET_TX_SET:
    #         uint256 txSetHash;
    #     case TX_SET:
    #         TransactionSet txSet;
    #     case TRANSACTION:
    #         TransactionEnvelope transaction;
    #     case GET_SCP_QUORUMSET:
    #         uint256 qSetHash;
    #     case SCP_QUORUMSET:
    #         SCPQuorumSet qSet;
    #     case SCP_MESSAGE:
    #         SCPEnvelope envelope;
    #     case GET_SCP_STATE:
    #         uint32 getSCPLedgerSeq;
    # };
    def __init__(self, type=None, error=None, hello=None, auth=None, dontHave=None, peers=None, txSetHash=None, txSet=None, transaction=None, qSetHash=None, qSet=None, envelope=None, getSCPLedgerSeq=None):
        self.type = type
        self.error = error
        self.hello = hello
        self.auth = auth
        self.dontHave = dontHave
        self.peers = peers
        self.txSetHash = txSetHash
        self.txSet = txSet
        self.transaction = transaction
        self.qSetHash = qSetHash
        self.qSet = qSet
        self.envelope = envelope
        self.getSCPLedgerSeq = getSCPLedgerSeq

    switch = property(lambda s: {const.ERROR_MSG:s.error,const.HELLO:s.hello,const.AUTH:s.auth,const.DONT_HAVE:s.dontHave,const.GET_PEERS:None,const.PEERS:s.peers,const.GET_TX_SET:s.txSetHash,const.TX_SET:s.txSet,const.TRANSACTION:s.transaction,const.GET_SCP_QUORUMSET:s.qSetHash,const.SCP_QUORUMSET:s.qSet,const.SCP_MESSAGE:s.envelope,const.GET_SCP_STATE:s.getSCPLedgerSeq,}[s.type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.MessageType.get(self.type, self.type)]
        if self.error is not None:
            out += ['error=%s' % repr(self.error)]
        if self.hello is not None:
            out += ['hello=%s' % repr(self.hello)]
        if self.auth is not None:
            out += ['auth=%s' % repr(self.auth)]
        if self.dontHave is not None:
            out += ['dontHave=%s' % repr(self.dontHave)]
        if self.peers is not None:
            out += ['peers=%s' % repr(self.peers)]
        if self.txSetHash is not None:
            out += ['txSetHash=%s' % repr(self.txSetHash)]
        if self.txSet is not None:
            out += ['txSet=%s' % repr(self.txSet)]
        if self.transaction is not None:
            out += ['transaction=%s' % repr(self.transaction)]
        if self.qSetHash is not None:
            out += ['qSetHash=%s' % repr(self.qSetHash)]
        if self.qSet is not None:
            out += ['qSet=%s' % repr(self.qSet)]
        if self.envelope is not None:
            out += ['envelope=%s' % repr(self.envelope)]
        if self.getSCPLedgerSeq is not None:
            out += ['getSCPLedgerSeq=%s' % repr(self.getSCPLedgerSeq)]
        return 'StellarMessage(%s)' % ', '.join(out)
    __str__ = __repr__

class AuthenticatedMessage:
    # XDR definition:
    # union AuthenticatedMessage switch(uint32 v) {
    #     case 0:
    #         struct {
    #             uint64 sequence;
    #             StellarMessage message;
    #             HmacSha256Mac mac;
    #         } v0;
    # };
    def __init__(self, v=None, v0=None):
        self.v = v
        self.v0 = v0

    switch = property(lambda s: {0:s.v0,}[s.v])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.v is not None:
            out += ['v=%s' % repr(self.v)]
        if self.v0 is not None:
            out += ['v0=%s' % repr(self.v0)]
        return 'AuthenticatedMessage(%s)' % ', '.join(out)
    __str__ = __repr__

