# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-18 23:15
from __future__ import unicode_literals

import uuid
import hashlib

from django.db import migrations, models


def set_keyb_defaults(apps, schema_editor):
    POSHardware = apps.get_model('codenerix_pos', 'POSHardware')
    for poshw in POSHardware.objects.all().iterator():
        poshw.key = hashlib.md5(uuid.uuid4().hex.encode('utf-8')).hexdigest()
        poshw.save()


class Migration(migrations.Migration):

    dependencies = [
        ('codenerix_pos', '0021_auto_20170818_2225'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='pos',
            name='keyb',
        ),
        migrations.AddField(
            model_name='poshardware',
            name='key',
            field=models.CharField(default='', max_length=32, verbose_name='Key'),
            preserve_default=False,
        ),
        migrations.RunPython(set_keyb_defaults),
        migrations.AlterField(
            model_name='poshardware',
            name='key',
            field=models.CharField(default='', max_length=32, unique=True, verbose_name='Key'),
            preserve_default=False,
        ),
    ]
