# Copyright 2021 The Brax Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Loading/saving of inference functions."""

from typing import Any
from flax import serialization

from brax.io.file import File


def load_params(path: str, target: Any) -> Any:
  with File(path, 'rb') as fin:
    buf = fin.read()
  return serialization.from_bytes(target, buf)


def save_params(path: str, params: Any):
  """Saves parameters in Flax format."""
  with File(path, 'wb') as fout:
    fout.write(serialization.to_bytes(params))
