# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysignald_async']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pysignald-async',
    'version': '0.1.4',
    'description': 'Python bindings for signald',
    'long_description': '# Signald python bindings\n\nMost of the content here is generated by `util/generate_api.py` that uses\nthe output of the \'protocol\' request of the [signald](https://gitlab.com/signald/signald) [API](https://docs.signald.org/).\n\nSince this output is incomplete, a few manual additions are present in `pysignald_async/api.py`.\n\n## Install\n\n`pip install pysignald-async`\n\n## Usage\n\nAn example can be found in [this signal/XMPP gateway](https://gitlab.com/nicocool84/spectrum2_signald/-/blob/master/spectrum2_signald/signald.py).\n\n\n```py\nimport asyncio\n\nfrom pysignald_async import SignaldAPI\n\nasync def main():\n    loop = asyncio.get_running_loop()\n    _, signald = await loop.create_unix_connection(\n        SignaldAPI, path=SIGNALD_SOCKET_PATH)\n    await signald.register(username="+XXXXXX")\n    # Some async code to get the SMS code\n    await signald.verify(username="+XXXXXX", code=code)\n    await signald.on_con_lost\n\nSIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\nasyncio.run(main())\n\n```\n\n`TODO: Write a better README`\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/nicocool84/pysignald-async',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
