# NotionAI Chrome Extension

NotionAI Chrome Extension is an open-source tool that provides a simple way to access the NotionAI API. With this extension, you can use NotionAI in any input field in Chrome with ease.

## Requirements

Before using the extension, please ensure that you have:

- A Notion account
- Access to the NotionAI API

## Installation

### Install from Chrome Web Store

The easiest way to install the extension is via the [Chrome Web Store](https://chrome.google.com/webstore/detail/notionai/ilgkcoockdhdpkikaakkjacblhpmdmeo).

### Load from source

Alternatively, you can load the extension from source:

1. Download the [latest release](https://github.com/Vaayne/NotionAI/releases) as a ZIP file.
2. Extract the ZIP file to a folder named `notionai-chrome`.
3. Open Chrome and navigate to `chrome://extensions/`.
4. Enable Developer mode.
5. Load the unpacked folder `notionai-chrome`.
6. Refresh any web page and select any text in an input box, then right-click to use NotionAI!

## Usage

To use the extension:

1. Select any text in an input box.
2. Right-click to open the NotionAI menu.
3. Choose the desired action from the menu.

If the text is in an input box, the result will be inserted there. Otherwise, the result will be displayed in an alert.

## To-Do

Here are some planned improvements for the extension:

- [x] Add support for ChatGPT
- [ ] Add support for Firefox
- [ ] Implement auto-copy functionality for the result
- [ ] Update alert to show a more user-friendly popup box

If you have any suggestions or feedback, please don't hesitate to [open an issue](https://github.com/Vaayne/NotionAI/issues) on GitHub!

## Contributing

Contributions are welcome!
