# The Vision

This page describes the main principles that drive the development of `probatus` as well as the general directions, in which the development of the package will be heading.

## The Purpose

`probatus` has started as a side project of Data Scientists at ING Bank. 
Later, we have decided to open-source it, in order to share the tools and enable collaboration with the Data Science community.

We mainly focus on analysing the following aspects of building classification models:
- Model input: the quality of the dataset and how to prepare it for modelling,
- Model performance: the quality of the model and stability of the results. 
- Model interpretation: understanding the model decision making,

Our main goals are:
- Continue maintaining the tools that we have built, and make sure that they are well documented and tested
- Continuously extend functionality available in the package
- Build a community of users, which use the package in day-to-day work and learn from each other, while contributing to probatus

## The Principles

The main principles that drive development of `probatus` are the following

- Usefulness - any tool that we build should be useful for a broad range of users,
- Simplicity - simple to understand and analyse steps over state-of-the-art,
- Usability - the developed functionality must be have good documentation, consistent API and work flawlessly with scikit-learn compatible models,
- Reliability - the code that is available for the users should be well tested and reliable, and bugs should be fixed as soon as they are detected.

## The Roadmap

The following [issue](https://github.com/ing-bank/probatus/issues/93) keeps track of the features coming to probatus.
We are open to new ideas, so if you can think of a feature that fits the vision, make an [issue](https://github.com/ing-bank/probatus/issues) and help us further develop this package.