// Copyright (c) Mito
import React, { useEffect } from 'react';
import { ModalEnum } from './modals';
import "../../../css/upgrade-modal.css";
import TextButton from '../elements/TextButton';
/*
    A modal that appears and tells the user to upgrade to the
    new version of Mito
*/
const UpgradeModal = (props) => {
    useEffect(() => {
        // We log the opening of the upgrade modal
        void props.mitoAPI.log('opened_upgrade_modal');
    }, []);
    const onUpgrade = () => {
        // Log if the user clicked upgrade
        void props.mitoAPI.log('closed_upgrade');
        // And then manually mark as upgraded (assuming they did it, so they
        // don't get an annoying popup a bunch of times).
        void props.mitoAPI.updateManuallyMarkUpgraded();
        // Close the modal
        props.setUIState((prevUIState) => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
        });
    };
    return (React.createElement("div", { className: 'overlay' },
        React.createElement("div", { className: 'upgrade-mito-modal-container txt-16' },
            React.createElement("h2", { className: 'mt-5px' }, "Time to Upgrade!"),
            React.createElement("p", null, "To get Mito's most advanced functionality:"),
            React.createElement("ol", null,
                React.createElement("li", { className: 'mt-5px' },
                    React.createElement("p", null, "Open a new terminal/command prompt (where you ran the commands to install Mito).")),
                React.createElement("li", { className: 'mt-10px' },
                    React.createElement("div", { className: 'upgrade-modal-code-list-item' },
                        React.createElement("p", null, "Run the command:"),
                        React.createElement("code", { className: 'upgrade-modal-code' }, "python -m pip install mitoinstaller --upgrade"))),
                React.createElement("li", { className: 'mt-10px' },
                    React.createElement("div", { className: 'upgrade-modal-code-list-item' },
                        React.createElement("p", null, "Run the command:"),
                        React.createElement("code", { className: 'upgrade-modal-code' }, "python -m mitoinstaller upgrade"))),
                React.createElement("li", { className: 'mt-10px' },
                    React.createElement("p", null,
                        React.createElement("b", null, "Restart your Kernel"),
                        " by clicking on Kernel > Restart Kernel.")),
                React.createElement("li", { className: 'mt-10px' },
                    React.createElement("p", null,
                        React.createElement("b", null, "Refresh this webpage.")))),
            React.createElement(TextButton, { variant: 'dark', width: 'block', onClick: onUpgrade }, "Got it!"))));
};
export default UpgradeModal;
//# sourceMappingURL=UpgradeModal.js.map