// Copyright (c) Mito
import React from 'react';
import "../../css/CatchUpPopup.css";
import Col from './spacing/Col';
import Row from './spacing/Row';
import CatchUpIcon from './icons/CatchUpIcon';
/*
    A small upper-left modal that displays a message to the user
    to let them know to fast forward
*/
const FastForwardPopup = (props) => {
    return (React.createElement("div", { onClick: props.fastForward, className: 'catch-up-popup-container' },
        React.createElement(Row, null,
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-overflow-wrap' }, "You are viewing a previous step, and cannot make any edits."))),
        React.createElement(Row, null,
            React.createElement(Col, null,
                React.createElement(CatchUpIcon, { variant: 'light' })),
            React.createElement(Col, { offset: 1 },
                React.createElement("p", null,
                    React.createElement("span", { className: 'text-underline' }, " Catch up"),
                    " to start editing.")))));
};
export default FastForwardPopup;
//# sourceMappingURL=CatchUpPopup.js.map