"""
A python package based on PyTorch and NumPy to support the study of different sorts 
of disordered nano-material networks for natural and energy-efficient analogue computing.
Particularly, it has been applied to the concept of dopant network processing units (DNPUs), 
a novel and promising CMOS-compatible nano-scale tunable material with potentially very 
low power consumption at inference stage. The framework is focused on two material-based 
approaches, for training DNPUs to compute supervised learning tasks: evolution in matter 
and digital twin models. While the evolution in matter focuses on providing a quicker 
exploration of newly manufactured single units of DNPUs, the digital twin approach is 
used for the design and simulation of the interconnection between DNPUs, enabling to 
explore its scalability.

More information at: https://github.com/BraiNEdarwin/brains-py/wiki
"""
__VERSION__ = "1.0.2"
__TEST_MODE__ = "SIMULATION_PC"
