import os
from importlib.machinery import SourceFileLoader
from setuptools import setup, find_packages

version = SourceFileLoader(
    'axerflow.version', os.path.join('axerflow', 'version.py')).load_module().VERSION
#version = open("VERSION").read()


# Get a list of all files in the JS directory to include in our module
def package_files(directory):
    paths = []
    for (path, _, filenames) in os.walk(directory):
        if ".ptp-sync" in path :
            continue 
        for filename in filenames:
            paths.append(os.path.join('..', path, filename))
    return paths


# Prints out a set of paths (relative to the axerflow/ directory) of files in axerflow/server/js/build
# to include in the wheel, e.g. "../axerflow/server/js/build/index.html"
js_files = package_files('axerflow/server/js/build')
protoc_files = package_files('axerflow/protos')
models_container_server_files = package_files("axerflow/models/container")
alembic_files = ["../axerflow/store/db_migrations/alembic.ini",
                 "../axerflow/temporary_db_migrations_for_pre_1_users/alembic.ini"]
#others = ["VERSION"]
setup(
    name='axerflow',
    version=version,
    packages=find_packages(exclude=['tests', 'tests.*',"*egg-info*",".ptp-sync*"]),
    package_data={"axerflow": js_files + models_container_server_files + alembic_files+protoc_files},
#    include_package_data=True,
    install_requires=[
#        "torch",
#        'pytorch-ignite',
        'alembic',
        'click>=7.0',
        'cloudpickle',
        'databricks-cli>=0.8.7',
        'requests>=2.17.3',
        'six>=1.10.0',
        'waitress; platform_system == "Windows"',
        'gunicorn; platform_system != "Windows"',
        'Flask',
        'numpy',
        'pandas',
        'python-dateutil',
        'protobuf>=3.6.0',
        'gitpython>=2.1.0',
        'pyyaml',
        'querystring_parser',
        'docker>=4.0.0',
        'entrypoints',
        'sqlparse',
        'sqlalchemy<=1.3.13',
        'gorilla',
        'prometheus-flask-exporter',
    ],
    extras_require={
        'extras': [
            "scikit-learn; python_version >= '3.5'",
            # scikit-learn 0.20 is the last version to support Python 2.x  & Python 3.4.
            "scikit-learn==0.20; python_version < '3.5'",
            'boto3>=1.7.12',
            'mleap>=0.8.1',
            'azure-storage-blob>=12.0',
            'google-cloud-storage',
            'azureml-core>=1.2.0'
        ],
         'sqlserver': [
            "mlflow-dbstore",
        ],
    },
    entry_points='''
        [console_scripts]
        axerflow=axerflow.cli:cli
    ''',
    zip_safe=False,
    author='Databricks',
    description='Axerflow: An ML Workflow Tool',
    #long_description=open('README.rst').read(),
    license='Apache License 2.0',
    classifiers=[
        'Intended Audience :: Developers',
        'Programming Language :: Python :: 3.6',
    ],
    keywords='ml ai databricks',
    url="https://bitbucket.org/axer-team/axerflow/src/dev_wj/",
    #download_url="https://github.com/axerflow/axerflow/archive/0.0.1.zip",
    python_requires='>=3.5',
    project_urls={
        'Bug Tracker': 'https://github.com/axerflow/axerflow/issues',
        'Documentation': 'https://github.com/axerflow/axerflow/docs/latest/index.html',
        'Source Code': 'https://github.com/axerflow/axerflow'
    },
)
