![Build](https://github.com/Neoteroi/mkdocs-plugins/workflows/Build/badge.svg)
[![pypi](https://img.shields.io/pypi/v/neoteroi-mkdocs.svg)](https://pypi.python.org/pypi/neoteroi-mkdocs)
[![versions](https://img.shields.io/pypi/pyversions/neoteroi-mkdocs.svg)](https://github.com/neoteroi/mkdocs-plugins)
[![license](https://img.shields.io/github/license/neoteroi/mkdocs-plugins.svg)](https://github.com/neoteroi/mkdocs-plugins/blob/main/LICENSE)
[![codecov](https://codecov.io/gh/Neoteroi/mkdocs-plugins/branch/main/graph/badge.svg)](https://codecov.io/gh/Neoteroi/mkdocs-plugins)
[![documentation](https://img.shields.io/badge/📖-docs-purple)](https://www.neoteroi.dev/mkdocs-plugins/)


# Plugins for MkDocs and Python Markdown

```bash
pip install neoteroi-mkdocs
```

This package includes the following plugins and extensions:

| Name                                                              | Description                                                               |
| :---------------------------------------------------------------- | :------------------------------------------------------------------------ |
| [`mkdocsoad`](https://www.neoteroi.dev/mkdocs-plugins/web/oad/)   | Generates documentation from OpenAPI specification files.                 |
| [`cards`](https://www.neoteroi.dev/mkdocs-plugins/cards/)         | Component to display cards.                                               |
| [`timeline`](https://www.neoteroi.dev/mkdocs-plugins/timeline/)   | Component to display chronological information with style.                |
| [`gantt`](https://www.neoteroi.dev/mkdocs-plugins/gantt/)         | Component to display Gantt diagrams.                                      |
| [`spantable`](https://www.neoteroi.dev/mkdocs-plugins/spantable/) | Tables supporting colspan and rowspan.                                    |
| [`contribs`](https://www.neoteroi.dev/mkdocs-plugins/contribs/)   | MkDocs plugin to display last commit time and contributors for each file. |

## Documentation
Refer to the [documentation site](https://www.neoteroi.dev/mkdocs-plugins/). :rocket:

---

## Preview

### Cards extension

![Cards](https://gist.githubusercontent.com/RobertoPrevato/38a0598b515a2f7257c614938843b99b/raw/24a200029c70c3cda2d31db5b4ceda9692a98854/cards.png)

<em>Greek Mythology icons made by <a href="https://www.flaticon.com/authors/maxicons" title="max.icons">max.icons</a> from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></em>

---

### Gantt extension

![Gantt diagram](https://gist.githubusercontent.com/RobertoPrevato/38a0598b515a2f7257c614938843b99b/raw/eaf8116b887c72f024b51c94206064b4dfd46052/gantt.png)

### Timeline extension

![Timeline](https://gist.githubusercontent.com/RobertoPrevato/38a0598b515a2f7257c614938843b99b/raw/90c4a7bdeddc2f9ebdf205b02d8153c3de24f0f4/timeline.png)


### OpenAPI Documentation extension

![OAD 1](https://gist.githubusercontent.com/RobertoPrevato/38a0598b515a2f7257c614938843b99b/raw/eaf8116b887c72f024b51c94206064b4dfd46052/oad-example-1.png)

![OAD 2](https://gist.githubusercontent.com/RobertoPrevato/38a0598b515a2f7257c614938843b99b/raw/eaf8116b887c72f024b51c94206064b4dfd46052/oad-example-2.png)
